/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AActionGroup;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.ATabbedPane;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.eda.NetUtil;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DiffPairUI;
import com.sigrity.orbit.DiffPairs;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.NetCmd;
import com.sigrity.orbit.cmd.NetCommands;
import com.sigrity.orbit.ui.DeviceChooser;
import com.sigrity.orbit.ui.DevicePathChooser;
import com.sigrity.orbit.ui.InterfaceUI;
import com.sigrity.orbit.ui.NetMapBulkCreateChildUI;
import com.sigrity.orbit.ui.NetMgmtPanel;
import com.sigrity.orbit.ui.OrbitGuiObjectActionRegistry;
import com.sigrity.orbit.ui.netlist_editor.NetListEditorUI;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NetUI {
    public static final String DELETED = "<Deleted>";
    public static final ObjectActionRegistry.ActionFactory<Selection> ActionFactorySelection = (selection, constraints) -> {
        long count = 0L;
        ArrayList<Net> nets = new ArrayList<Net>();
        for (Net d : selection.get(Net.class)) {
            nets.add(d);
        }
        ArrayList hierNets = AUtil.arrayList((Iterator)selection.getSelectedHierInsts(Net.class));
        count = nets.size();
        if (count == 0L || count == 1L && ((Net)nets.get(0)).isUnused()) {
            return AEmptyItr.create();
        }
        LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
        AActionGroup classify = new AActionGroup("Classify");
        actions.add(classify);
        if (count == 2L) {
            classify.addAction(new ActionCreateDiffPair((Net)nets.get(0), (Net)nets.get(1)));
        } else {
            classify.addAction(new ActionCreateDiffPair(null, null));
        }
        classify.addSeparator();
        if (count > 0L) {
            classify.addAction(new ActionCreateSignalNets(nets));
            classify.addAction(new ActionCreatePowerNets(nets));
            classify.addAction(new ActionCreateGroundNets(nets));
            classify.addAction(new ActionCreateTerms(nets));
        }
        classify.addSeparator();
        if (!hierNets.isEmpty()) {
            classify.addAction(new ActionCreateInterface(hierNets));
        }
        if (count > 1L) {
            actions.add(new OrbitGuiObjectActionRegistry.ActionSelectMultiDbObject<Net>(hierNets, Net.class));
        }
        actions.add(new ActionSelectPins(hierNets));
        actions.add(new ActionSelectDescendantPins(hierNets));
        actions.add(new ActionSelectAssociatedPins(hierNets));
        return actions.iterator();
    };

    private NetUI() {
    }

    public static List<Action> getActions(DevicePath path) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new ActionCreateNet(path.getDeviceTemplate()));
        actions.add(NetListEditorUI.getAction(path));
        actions.add(new DiffPairUI.ActionCreateDiffPair(path.getDeviceTemplate()));
        return actions;
    }

    public static Personality getPowerNetPersonality(String devTemplateKeyStr, String powerNetName) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate devT = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTemplateKeyStr);
        if (devT == null) {
            ALog.logError((String)"Invalid Device Template");
            return null;
        }
        return NetCommands.getPowerNetPersonality(devT, powerNetName);
    }

    public static boolean updateNetColor(Db db, String netKeyStr, String colorStr, String devicePathStr) {
        Net net = (Net)db.getByKeyStr(Net.class, netKeyStr);
        if (net == null) {
            return false;
        }
        Color c = AUtil.colorFromString((String)colorStr);
        net.setColor(c);
        for (NetMap nm : NetMap.getDescendantNets((Net)net)) {
            Net n = nm.getChildNet();
            if (n.getDeviceTemplate().getType() == DeviceTemplate.Type.BUMP) continue;
            n.setColor(c);
        }
        return true;
    }

    public static NetDlg createDlg(Window owner, Db db) {
        return new NetDlg(owner, db);
    }

    @Deprecated
    public static void selectNetOfSelectedPorts() {
        NetCmd.selectNetOfSelectedPorts();
    }

    @Deprecated
    protected static void selectNet(Net n, boolean add) {
        NetCmd.selectNet((Net)n, (boolean)add);
    }

    @Deprecated
    public static void selectNet(Net n, boolean add, Selection s) {
        NetCmd.selectNet((Net)n, (boolean)add, (Selection)s);
    }

    @Deprecated
    public static void selectNet(String keyStr, boolean add) {
        NetCmd.selectNet((String)keyStr, (boolean)add);
    }

    @Deprecated
    public static void selectNetToggle(String keyStr) {
        NetCmd.selectNetToggle((String)keyStr);
    }

    @Deprecated
    public static boolean recordMapNet(Device childDevice, Net childNet, Net parentNet) {
        return NetCmd.recordMapNet((Device)childDevice, (Net)childNet, (Net)parentNet);
    }

    @Deprecated
    public static void connect(String fromPathName, String fromPortName, String toPathName, String toPortName, String netName) {
        NetCmd.connect((String)fromPathName, (String)fromPortName, (String)toPathName, (String)toPortName, (String)netName);
    }

    @Deprecated
    public static void reAssignNet(String pathName, String portName, String netName) {
        NetCmd.reAssignNet((String)pathName, (String)portName, (String)netName);
    }

    public static class DeleteNetUI {
        private DeleteNetUI() {
        }

        public static boolean delete(Component owner, Net n) {
            boolean moved;
            String msg = String.format("Delete Net '%s'?", n.getName());
            int res = JOptionPane.showConfirmDialog(owner, msg, "Confirm Delete Net", 0);
            if (res != 0) {
                return false;
            }
            if (n.getContents().hasNext() && !(moved = ((Boolean)Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").moveContents(null)", (Object[])new Object[]{n.getKeyStr()})).booleanValue())) {
                ALog.logError((String)"Unable to move net '%s' contents to NetUnused, the net is not being deleted.", (Object[])new Object[]{n.getName()});
                return false;
            }
            return (Boolean)Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").deleteFromDb()", (Object[])new Object[]{n.getKeyStr()});
        }
    }

    public static class RenameNetUI
    extends JDialog {
        public static final String BTNTXT_OK = "OK";
        public static final String BTNTXT_MERGE = "Merge";
        protected Net mNet;
        protected boolean mRenamed = false;
        protected JTextField mTxtCurName;
        protected JTextField mTxtNewName;
        protected JButton mBtnOk;
        protected DocumentListener mNewNameListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String newName = mTxtNewName.getText();
                boolean ok = this.newNameOk(newName);
                if (mBtnOk.isEnabled() != ok) {
                    mBtnOk.setEnabled(ok);
                }
                if (!ok || mNet.getDeviceTemplate().getNet(newName) == null) {
                    if (!mBtnOk.getText().equals(RenameNetUI.BTNTXT_OK)) {
                        mBtnOk.setText(RenameNetUI.BTNTXT_OK);
                    }
                } else if (!mBtnOk.getText().equals(RenameNetUI.BTNTXT_MERGE)) {
                    mBtnOk.setText(RenameNetUI.BTNTXT_MERGE);
                }
            }
        };
        protected ActionListener mOkListener = e -> {
            String oldName = this.mNet.getName();
            String newName = this.mTxtNewName.getText();
            if (!this.newNameOk(newName)) {
                String msg = String.format("New net name '%s' is invalid or already exists.", newName);
                JOptionPane.showMessageDialog(this, msg, "Invalid New Name", 0);
                return;
            }
            if (this.mNet.getDeviceTemplate().getNet(newName) == null) {
                Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").setName(\"%s\")", (Object[])new Object[]{this.mNet.getKeyStr(), newName});
                this.mRenamed = true;
            } else {
                Boolean b = (Boolean)Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").moveContents(\"%s\", true)", (Object[])new Object[]{this.mNet.getKeyStr(), newName});
                if (b != null && b.booleanValue()) {
                    this.mRenamed = b;
                    ALog.logInfo((String)"Net '%s' merged into Net '%s'.", (Object[])new Object[]{oldName, newName});
                }
            }
            UIUtil.closeWindow((Window)this);
        };

        public static boolean rename(Component owner, Net n) {
            RenameNetUI dlg = new RenameNetUI(owner, n);
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
            return dlg.getRenamed();
        }

        public RenameNetUI(Component owner, Net n) {
            super((Window)UIUtil.getAncestorOfType((Component)owner, Window.class, (boolean)true), "Rename Net");
            this.mNet = n;
            GridBagManager l = GridBagManager.layout((JDialog)this);
            l.push("Net", (GridBagConstraints)GridBagManager.FILLX);
            l.add("Current name:");
            this.mTxtCurName = (JTextField)l.addNl((Component)new JTextField(20), (GridBagConstraints)GridBagManager.FILLX);
            this.mTxtCurName.setEditable(false);
            l.add("New name:");
            this.mTxtNewName = (JTextField)l.addNl((Component)new JTextField(20), (GridBagConstraints)GridBagManager.FILLX);
            l.pop();
            l.newline();
            l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            this.mBtnOk = (JButton)l.add((Component)new JButton(BTNTXT_OK), (GridBagConstraints)GridBagManager.RIGHT);
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)this, (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            this.mTxtCurName.setText(n.getName());
            this.mTxtNewName.setText(n.getName());
            this.mTxtNewName.requestFocus();
            UIUtil.center((Component)this);
            this.mBtnOk.addActionListener(this.mOkListener);
            this.mTxtNewName.getDocument().addDocumentListener(this.mNewNameListener);
            this.mNewNameListener.changedUpdate(null);
        }

        public boolean getRenamed() {
            return this.mRenamed;
        }

        protected boolean newNameOk(String newName) {
            return !newName.equals(this.mNet.getName()) && newName.length() > 0;
        }

        protected static class ActionRenameNet
        extends AbstractAction {
            protected Net mNet;

            public ActionRenameNet(Net net) {
                super("Rename Net...");
                this.mNet = net;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameNetUI.rename(OrbitIO.getMainWindow(), this.mNet);
            }
        }
    }

    public static class AddNetUI
    extends JDialog {
        protected DeviceTemplate mDeviceTemplate;
        protected Net mNewNet = null;
        protected JLabel mTxtDeviceTemplate;
        protected JTextField mTxtNetName;
        protected JButton mBtnOk;
        protected DocumentListener mNewNameListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String netName = mTxtNetName.getText();
                boolean ok = this.netNameOk(netName);
                if (mBtnOk.isEnabled() != ok) {
                    mBtnOk.setEnabled(ok);
                }
            }
        };
        protected ActionListener mOkListener = e -> {
            String netName = this.mTxtNetName.getText();
            if (!this.netNameOk(netName)) {
                String msg = String.format("Net name '%s' is invalid or already exists.", netName);
                JOptionPane.showMessageDialog(this, msg, "Invalid New Name", 0);
                return;
            }
            Substrate substrate = this.mDeviceTemplate.getSubstrate();
            String substrateName = substrate == null ? null : String.format("\"%s\"", substrate.getName());
            this.mNewNet = (Net)Cp.exec((String)"Net.create(curDb(), \"%s\", \"%s\", %s)", (Object[])new Object[]{this.mDeviceTemplate.getName(), netName, substrateName});
            if (this.mNewNet != null) {
                UIUtil.closeWindow((Window)this);
            }
        };

        public static Net addNet(Component owner, DeviceTemplate dt) {
            AddNetUI dlg = new AddNetUI(owner, dt);
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
            return dlg.getNewNet();
        }

        public AddNetUI(Component owner, DeviceTemplate dt) {
            super((Window)UIUtil.getAncestorOfType((Component)owner, Window.class, (boolean)true), "Add Net");
            this.setTitle(String.format("Add Net on '%s'", dt.getName()));
            this.mDeviceTemplate = dt;
            GridBagManager l = GridBagManager.layout((JDialog)this);
            this.mTxtDeviceTemplate = new JLabel(dt.getName());
            this.mTxtDeviceTemplate.setIcon(DbExplorerPanel.getIconForDbObject((DbObject)dt));
            this.mTxtNetName = new JTextField(20);
            l.add("Device Template:");
            l.addNl((Component)this.mTxtDeviceTemplate, (GridBagConstraints)GridBagManager.LEFT);
            l.add("Net Name:");
            l.addNl((Component)this.mTxtNetName, (GridBagConstraints)GridBagManager.FILLX);
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOk = (JButton)l.add((Component)new JButton("Create"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)this, (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            this.mTxtNetName.requestFocus();
            this.pack();
            UIUtil.center((Component)this);
            this.mBtnOk.addActionListener(this.mOkListener);
            this.mTxtNetName.getDocument().addDocumentListener(this.mNewNameListener);
            this.mNewNameListener.changedUpdate(null);
        }

        public Net getNewNet() {
            return this.mNewNet;
        }

        protected boolean netNameOk(String newName) {
            return newName.length() > 0 && this.mDeviceTemplate.getNet(newName) == null;
        }
    }

    public static class NetDlg
    extends DbDialog {
        protected DevicePathChooser.Panel mDevicePathPanel;
        protected DeviceChooser.DCPanel mDcPanel;
        protected JPanel mCardLayout;
        protected ATabbedPane mTabs;
        protected JLabel mStatus;
        protected JComboBox<DeviceDisplayStyle> mCboShowName;
        protected JCheckBox mCbOnlyDevsWithChildren;
        protected JCheckBox mCbDisplayIOPad;
        protected JCheckBox mCbDisplayBump;
        protected BiMap<Device, NetMgmtPanel> mDevice2Panel = HashBiMap.create();
        protected DevicePathChooser.Panel.ContextMenuListener mMouseListener = new DevicePathChooser.Panel.ContextMenuListener(){

            @Override
            public void pathShowPopup(DevicePath p, MouseEvent e) {
                JPopupMenu m = new JPopupMenu();
                ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
                items.add(new JMenuItem(new OrbitGuiObjectActionRegistry.ActionImportCSVNetList(p, true)));
                items.add(new JMenuItem(new OrbitGuiObjectActionRegistry.ActionImportCSVNetList(p, false)));
                items.add(new JMenuItem(new OrbitGuiObjectActionRegistry.ActionImportCSVDeviceList(p)));
                AMenuUtil.sort(items, (boolean)false);
                for (JMenuItem mi : AMenuUtil.groupByFirstWord(items.iterator())) {
                    m.add(mi);
                }
                if (OrbitIO.getGuiWorkspace() != null) {
                    OrbitIO.getGuiWorkspace().beautify(m);
                }
                m.show(e.getComponent(), e.getX(), e.getY());
            }
        };
        protected DevicePathChooser.Panel.ChooserListener mDevicePathListener = new DevicePathChooser.Panel.ChooserListener(){

            @Override
            public void pathSelected(DevicePath p) {
            }

            @Override
            public void pathActivated(DevicePath path) {
                this.showNetPanel(path.getDevice());
            }
        };
        protected DeviceChooser.DCPanel.DeviceListener mDeviceListener = new DeviceChooser.DCPanel.DeviceListener(){

            @Override
            public void deviceSelected(Device d) {
            }

            @Override
            public void deviceActivated(Device d) {
                this.showNetPanel(d);
            }
        };
        protected ContainerListener mTabContainerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (!(c instanceof NetMgmtPanel)) {
                    return;
                }
                NetMgmtPanel p = (NetMgmtPanel)c;
                mDevice2Panel.put((Object)p.getDevice(), (Object)p);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (!(c instanceof NetMgmtPanel)) {
                    return;
                }
                NetMgmtPanel p = (NetMgmtPanel)c;
                mDevice2Panel.remove((Object)p.getDevice());
            }
        };

        public NetDlg(Window owner, Db db) {
            super(db, (Component)owner);
            this.setTitle("Net Management");
            ASplitPane splitter = new ASplitPane();
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add((Component)splitter, (GridBagConstraints)GridBagManager.FILLALL);
            JPanel pnlLeft = new JPanel();
            pnlLeft.setBorder(BorderFactory.createTitledBorder("Devices"));
            GridBagManager lLeft = GridBagManager.layout((Container)pnlLeft);
            this.mCboShowName = new JComboBox<DeviceDisplayStyle>(DeviceDisplayStyle.values());
            this.mCboShowName.addActionListener(e -> {
                CardLayout cl = (CardLayout)this.mCardLayout.getLayout();
                cl.show(this.mCardLayout, ((DeviceDisplayStyle)((Object)((Object)this.mCboShowName.getSelectedItem()))).toString());
            });
            this.mCboShowName.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean isSel, boolean hasFocus) {
                    super.getListCellRendererComponent(list, val, idx, isSel, hasFocus);
                    if (val instanceof DeviceDisplayStyle) {
                        this.setText(((DeviceDisplayStyle)((Object)val)).getDesc());
                    }
                    return this;
                }
            });
            lLeft.pushFillX();
            lLeft.add("Show:");
            lLeft.add(this.mCboShowName, (GridBagConstraints)GridBagManager.FILLALL);
            lLeft.pop();
            lLeft.newline();
            this.mDevicePathPanel = new DevicePathChooser.Panel(this.mDb, DeviceFilters.DEVICEFILTER_WITHCHILDREN);
            this.mDevicePathPanel.addChooserListener(this.mDevicePathListener);
            this.mDevicePathPanel.addContextMenuListener(this.mMouseListener);
            this.mDevicePathPanel.setPreferredSize(this.mDevicePathPanel.getPreferredSize());
            this.mDcPanel = new DeviceChooser.DCPanel();
            this.mDcPanel.setDb(this.mDb);
            this.mDcPanel.setPreferredSize(this.mDcPanel.getPreferredSize());
            this.mDcPanel.setSpecial(NetUtil.DESIGN_PLACEHOLDER);
            this.mDcPanel.setDeviceFilter(DeviceFilters.DEVICEFILTER_WITHCHILDREN);
            this.mDcPanel.addDeviceListener(this.mDeviceListener);
            this.mCardLayout = new JPanel(new CardLayout());
            this.mCardLayout.add((Component)this.mDevicePathPanel, DeviceDisplayStyle.DEVICE_PATH.toString());
            this.mCardLayout.add((Component)this.mDcPanel, DeviceDisplayStyle.LIST.toString());
            lLeft.add((Component)this.mCardLayout, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
            lLeft.newline();
            this.mCbOnlyDevsWithChildren = (JCheckBox)lLeft.add((Component)new JCheckBox("Only devices with children", true));
            this.mCbOnlyDevsWithChildren.addActionListener(e -> {
                this.mDevicePathPanel.setDeviceFilter(this.mCbOnlyDevsWithChildren.isSelected() ? DeviceFilters.DEVICEFILTER_WITHCHILDREN : DeviceFilters.DEVICEFILTER_ALL);
                this.mDcPanel.setDeviceFilter(this.mCbOnlyDevsWithChildren.isSelected() ? DeviceFilters.DEVICEFILTER_WITHCHILDREN : DeviceFilters.DEVICEFILTER_ALL);
            });
            lLeft.newline();
            this.mCbDisplayIOPad = (JCheckBox)lLeft.add((Component)this.makeDevTypeCtrl("Display IO pad devices", DeviceTemplate.Type.PAD));
            lLeft.newline();
            this.mCbDisplayBump = (JCheckBox)lLeft.add((Component)this.makeDevTypeCtrl("Display bump devices", DeviceTemplate.Type.BUMP));
            lLeft.newline();
            splitter.setLeftComponent(pnlLeft);
            this.mTabs = new ATabbedPane(1, 1);
            this.mTabs.setDefaultToClosable(true);
            this.mTabs.setMinimumSize(new Dimension(320, 150));
            splitter.setRightComponent(this.mTabs);
            l.newline();
            l.pushFillXRemainX();
            this.mStatus = new JLabel();
            l.add((Component)this.mStatus, (GridBagConstraints)GridBagManager.FILLX);
            JButton btnClose = new JButton("Close");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.setDb(db);
            this.setStatus("Drag and drop nets between devices to create or modify mapping.", false);
            this.mTabs.addContainerListener(this.mTabContainerListener);
        }

        public JCheckBox makeDevTypeCtrl(String text, DeviceTemplate.Type type) {
            JCheckBox cb = new JCheckBox(text, false);
            cb.addActionListener(e -> {
                boolean show = cb.isSelected();
                cb.setSelected(show);
                for (NetMgmtPanel panel : this.mDevice2Panel.values()) {
                    panel.reloadNetListsForDeviceType(this.mCbDisplayIOPad.isSelected(), this.mCbDisplayBump.isSelected());
                }
            });
            return cb;
        }

        public void setDb(Db db) {
            this.mDevicePathPanel.setDb(db);
            this.mDcPanel.setDb(db);
        }

        public void setStatus(String text) {
            this.setStatus(text, true);
        }

        public void setStatus(String text, boolean log) {
            if (log) {
                ALog.logInfo((String)("Net Management: " + text));
            }
            this.mStatus.setText(text);
        }

        private void showNetPanel(Device d) {
            NetMgmtPanel p;
            if (d == NetUtil.DESIGN_PLACEHOLDER) {
                d = null;
            }
            if ((p = (NetMgmtPanel)this.mDevice2Panel.get((Object)d)) != null) {
                this.mTabs.setSelectedComponent(p);
            } else {
                if (d != null && d.getDb() == null) {
                    ALog.logWarn((String)"Invalid device, perhaps it has been deleted.");
                    return;
                }
                p = new NetMgmtPanel(this.mDevicePathPanel.mDb, d, this.mCbDisplayIOPad.isSelected(), this.mCbDisplayBump.isSelected());
                String tabName = d == null ? NetUtil.DESIGN_PLACEHOLDER.getName() : d.getName();
                Icon tabIcon = DbExplorerPanel.getIconForDevice(d);
                this.mTabs.insertTab(tabName, tabIcon, p, null, this.mTabs.getTabCount());
                this.mTabs.setSelectedComponent(p);
            }
        }

        public static enum DeviceDisplayStyle {
            DEVICE_PATH("Show device path"),
            LIST("Show list");

            String desc;

            private DeviceDisplayStyle(String desc) {
                this.desc = desc;
            }

            public String getDesc() {
                return this.desc;
            }
        }
    }

    public static class ActionSelectAssociatedPins
    extends AbstractAction {
        protected List<HierInst<Net>> hierNets;

        public ActionSelectAssociatedPins(List<HierInst<Net>> hierNets) {
            super("Select Associated Pins");
            this.setEnabled(!hierNets.isEmpty());
            this.putValue("ShortDescription", "Select pins of nets and associated nets through net mapping");
            this.hierNets = hierNets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (HierInst<Net> netInst : this.hierNets) {
                Cp.exec((String)"com.sigrity.orbit.cmd.NetCmd.selectAssociatedPins(curSelection(), %s, true)", (Object[])new Object[]{netInst.toCpString()});
            }
        }
    }

    public static class ActionSelectDescendantPins
    extends AbstractAction {
        protected List<HierInst<Net>> hierNets;

        public ActionSelectDescendantPins(List<HierInst<Net>> hierNets) {
            super("Select Descendant Pins");
            this.setEnabled(!hierNets.isEmpty());
            this.putValue("ShortDescription", "Select pins of nets and descendant nets");
            this.hierNets = hierNets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (HierInst<Net> netInst : this.hierNets) {
                Cp.exec((String)"com.sigrity.orbit.cmd.NetCmd.selectDescendantPins(curSelection(), %s, true)", (Object[])new Object[]{netInst.toCpString()});
            }
        }
    }

    public static class ActionSelectPins
    extends AbstractAction {
        protected List<HierInst<Net>> hierNets;

        public ActionSelectPins(List<HierInst<Net>> hierNets) {
            super("Select Pins");
            this.setEnabled(!hierNets.isEmpty());
            this.putValue("ShortDescription", "Select pins of nets");
            this.hierNets = hierNets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (HierInst<Net> netInst : this.hierNets) {
                Cp.exec((String)"com.sigrity.orbit.cmd.NetCmd.selectPins(curSelection(), %s, true)", (Object[])new Object[]{netInst.toCpString()});
            }
        }
    }

    public static class ActionBulkCreateChildNet
    extends AbstractAction {
        protected DeviceTemplate devT;

        public ActionBulkCreateChildNet(DeviceTemplate devT) {
            super("Bulk Create Child Nets...");
            this.devT = devT;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetMapBulkCreateChildUI.show(OrbitIO.getMainWindow(), this.devT);
        }
    }

    public static class ActionCreateTerms
    extends AbstractAction {
        List<Net> nets;

        public ActionCreateTerms(List<Net> nets) {
            super("As a Term");
            this.nets = nets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Net net : this.nets) {
                if (net.isUnused()) continue;
                DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Create terms from nets");
                try {
                    Cp.exec((String)"_refNet = curDb().getByKeyStr(Net.class, \"%s\")", (Object[])new Object[]{net.getKeyStr()});
                    Cp.exec((String)"com.sigrity.acl.db.std.Term.create(_refNet)", (Object[])new Object[0]);
                    Cp.exec((String)"unset(\"_refNet\");", (Object[])new Object[0]);
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
        }
    }

    public static class ActionCreateInterface
    extends AbstractAction {
        List<Net> nets = new ArrayList<Net>();
        Interface parentInf;

        public ActionCreateInterface(List<HierInst<Net>> hierNets) {
            super("As a Interface");
            Net net = (Net)hierNets.get(0).getSecond();
            DevicePath path = (DevicePath)hierNets.get(0).getFirst();
            DeviceTemplate devT = net.getDeviceTemplate();
            this.parentInf = net.getInterface(path);
            for (HierInst<Net> hierNet : hierNets) {
                net = (Net)hierNet.getSecond();
                path = (DevicePath)hierNet.getFirst();
                if (((Net)hierNet.getSecond()).getDeviceTemplate() == devT && ((Net)hierNet.getSecond()).getInterface(path) == this.parentInf) continue;
                this.setEnabled(false);
                break;
            }
            if (this.parentInf != null) {
                for (HierInst<Net> hierNet : hierNets) {
                    Net keyNet = this.parentInf.connectedToKeyNet((Net)hierNet.getSecond());
                    if (keyNet != null) {
                        this.nets.add(keyNet);
                        continue;
                    }
                    this.setEnabled(false);
                }
                this.putValue("Name", String.format("As a Child Interface (%d) for '%s'", this.nets.size(), this.parentInf.getName()));
            } else {
                for (HierInst<Net> hierNet : hierNets) {
                    this.nets.add((Net)hierNet.getSecond());
                }
            }
        }

        public static void setInterfaceValue(Db db, String ancestry, String name, int IOcount) {
            Interface intf = Interface.find((Db)db, (String)ancestry);
            if (intf != null) {
                intf.setName(name);
                intf.setExpectedIOCount(IOcount);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                this.cpPerformed();
            }
        }

        private void cpPerformed() {
            Interface intf = null;
            intf = this.parentInf == null ? (Interface)Cp.exec((String)"com.sigrity.acl.db.std.Interface.createDefaultRoot(OrbitIO.getCurDb())", (Object[])new Object[0]) : (Interface)Cp.exec((String)"com.sigrity.acl.db.std.Interface.createDefault(OrbitIO.getCurDb(), \"%s\")", (Object[])new Object[]{this.parentInf.toStringPath()});
            if (intf == null) {
                return;
            }
            String intfName = AUtil.getPrettyPrefixName(this.nets.stream().map(Net::getName).collect(Collectors.toList()));
            Cp.exec((String)"%s.setInterfaceValue(OrbitIO.getCurDb(), \"%s\", \"%s\", %d)", (Object[])new Object[]{this.getClass().getName(), intf.toStringPath(), intfName, this.nets.size()});
            Interface selIntf = InterfaceUI.showSelectDialog(OrbitIO.getMainWindow(), intf);
            if (selIntf != intf) {
                Cp.exec((String)"com.sigrity.acl.db.std.Interface.delete(curDb(), \"%s\")", (Object[])new Object[]{intf.getKeyStr()});
            }
            if (selIntf == null) {
                return;
            }
            intf = selIntf;
            DbHistory history = OrbitIO.getCurDb().getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("EditFloorplanNets");){
                for (Net net : this.nets) {
                    Cp.exec((String)("com.sigrity.acl.db.std.Interface.addNet(OrbitIO.getCurDb(), \"" + intf.toStringPath() + "\", \"" + net.getKeyStr() + "\");"), (Object[])new Object[0]);
                }
            }
            Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.assignExistingPinsToFloorplanForAllDecendents(OrbitIO.getCurDb(), \"" + intf.toStringPath() + "\");"), (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionCreateGroundNets
    extends AbstractAction {
        List<Net> nets;

        public ActionCreateGroundNets(List<Net> nets) {
            super("As a Ground Net");
            this.nets = nets;
            DeviceTemplate devT = nets.get(0).getDeviceTemplate();
            for (Net net : nets) {
                if (net.getDeviceTemplate() == devT) continue;
                this.setEnabled(false);
                break;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbHistory history = OrbitIO.getCurDb().getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("Classify As a Ground Net");){
                DeviceTemplate devT = this.nets.get(0).getDeviceTemplate();
                Personality netPersonality = (Personality)Cp.exec((String)"_powerNetPersonality = %s.getPowerNetPersonality(\"%s\", \"%s\")", (Object[])new Object[]{NetUI.class.getName(), devT.getKeyStr(), this.nets.get(0).getName()});
                if (netPersonality == null) {
                    ALog.logInfo((String)"Something wrong when creating power net personality. Please check the name `%s`", (Object[])new Object[]{this.nets.get(0).getName()});
                    return;
                }
                for (Net net : this.nets) {
                    Cp.exec((String)"%s.classifyAsGround(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{NetCommands.class.getName(), net.getKeyStr(), netPersonality.getKeyStr()});
                }
                Cp.exec((String)"unset(\"_powerNetPersonality\")", (Object[])new Object[0]);
            }
        }
    }

    public static class ActionCreatePowerNets
    extends AbstractAction {
        List<Net> nets;

        public ActionCreatePowerNets(List<Net> nets) {
            super("As a Power Net");
            this.nets = nets;
            DeviceTemplate devT = nets.get(0).getDeviceTemplate();
            for (Net net : nets) {
                if (net.getDeviceTemplate() == devT) continue;
                this.setEnabled(false);
                break;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbHistory history = OrbitIO.getCurDb().getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("Classify As a Power Net");){
                DeviceTemplate devT = this.nets.get(0).getDeviceTemplate();
                Personality netPersonality = (Personality)Cp.exec((String)"_powerNetPersonality = %s.getPowerNetPersonality(\"%s\", \"%s\")", (Object[])new Object[]{NetUI.class.getName(), devT.getKeyStr(), this.nets.get(0).getName()});
                if (netPersonality == null) {
                    ALog.logInfo((String)"Something wrong when creating power net personality. Please check the name `%s`", (Object[])new Object[]{this.nets.get(0).getName()});
                    return;
                }
                for (Net net : this.nets) {
                    Cp.exec((String)"%s.classifyAsPower(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{NetCommands.class.getName(), net.getKeyStr(), netPersonality.getKeyStr()});
                }
                Cp.exec((String)"unset(\"_powerNetPersonality\")", (Object[])new Object[0]);
            }
        }
    }

    public static class ActionCreateSignalNets
    extends AbstractAction {
        List<Net> nets;

        public ActionCreateSignalNets(List<Net> nets) {
            super("As a Signal Net");
            this.nets = nets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbHistory history = OrbitIO.getCurDb().getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("Classify As a Signal Net");){
                for (Net net : this.nets) {
                    Cp.exec((String)"%s.classifyAsSignal(curDb(), \"%s\")", (Object[])new Object[]{NetCommands.class.getName(), net.getKeyStr()});
                }
            }
        }
    }

    public static class ActionCreateDiffPair
    extends AbstractAction {
        Net n1;
        Net n2;
        Personality p1;
        Personality p2;

        public ActionCreateDiffPair(Net n1, Net n2) {
            super("As a Diff Pair");
            if (n1 == null || n2 == null) {
                this.setEnabled(false);
                return;
            }
            if (n1.getDeviceTemplate() != n2.getDeviceTemplate()) {
                this.setEnabled(false);
            }
            this.p1 = Net.isDiffPair((Net)n1);
            this.p2 = Net.isDiffPair((Net)n2);
            if (this.p1 == this.p2 && this.p1 != null) {
                this.putValue("Name", "Not As a Diff Pair");
            } else if (this.p1 != null || this.p2 != null) {
                this.setEnabled(false);
            }
            this.n1 = n1;
            this.n2 = n2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.p1 == this.p2 && this.p1 != null) {
                Cp.exec((String)"%s.removePair(OrbitIO.getCurDb(), \"%s\", \"%s\")", (Object[])new Object[]{DiffPairs.class.getName(), this.n1.getKeyStr(), this.n2.getKeyStr()});
            } else {
                Cp.exec((String)"%s.createPair(OrbitIO.getCurDb(), \"%s\", \"%s\")", (Object[])new Object[]{DiffPairs.class.getName(), this.n1.getKeyStr(), this.n2.getKeyStr()});
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionCreateNet
    extends AbstractAction {
        protected DeviceTemplate mDeviceTemplate;

        public ActionCreateNet(DeviceTemplate dt) {
            super("Create Net...");
            this.mDeviceTemplate = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddNetUI.addNet(OrbitIO.getMainWindow(), this.mDeviceTemplate);
        }
    }
}

