/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AStringEscape;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AclInfo;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetObject;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitUtil;
import com.sigrity.orbit.ReferencePoint;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.util.PhysicalNetUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ObjectCopyOrMoveUI
extends DbDialog {
    public static final String FldStashOfConnected = OrbitUtil.softFieldName(PinInstance.class, "mStashOfConnected");
    private static OBJECT_TYPE mObjectType = null;
    static OBJECT_TYPE sThisObjectTypeString = null;
    protected static boolean sCopying = false;
    protected static boolean sCreateInstances = false;
    protected boolean mCopyMode = false;
    protected static String sNextName = null;
    protected Selection.SelSet mObjSet;
    protected Unit mUnit;
    protected ReferencePoint mRefPoint;
    protected JRadioButton mRbAbsolute;
    protected JRadioButton mRbRelative;
    protected JTextField mTxtName = null;
    protected JLabel mLblX;
    protected JTextField mTxtX;
    protected JLabel mLblY;
    protected JTextField mTxtY;
    protected JLabel mLblRotation;
    protected JTextField mTxtRotation;
    protected JLabel mLbRefPoint;
    protected JComboBox<ReferencePoint.Reference> mCoRefPoint;
    protected JLabel mLbRefX;
    protected JTextField mTxtRefX;
    protected JLabel mLbRefY;
    protected JTextField mTxtRefY;
    protected JLabel mLblMirror = null;
    protected JCheckBox mCbMirror = null;
    protected JComboBox<PARAMETER_MODE> mCboParaMode;
    protected JComboBox<PARAMETER_ORDER> mCboXOrder;
    protected JComboBox<PARAMETER_ORDER> mCboYOrder;
    protected JTextField mTxtXQty;
    protected JTextField mTxtYQty;
    protected JTextField mTxtXSpacing;
    protected JTextField mTxtYSpacing;
    protected ActionListener mMoveTypeChangedListener = e -> this.loadData();
    protected ActionListener mApplyListener = e -> {
        try {
            this.apply();
        }
        catch (AFieldValidator.AFieldValidationException fve) {
            ALog.logDebug((Throwable)fve);
        }
    };
    protected ActionListener mRefPointChangedListener = e -> {
        if (this.mCoRefPoint.getSelectedItem() == ReferencePoint.Reference.XY) {
            this.mTxtRefX.setEnabled(true);
            this.mTxtRefY.setEnabled(true);
        } else {
            this.mTxtRefX.setEnabled(false);
            this.mTxtRefY.setEnabled(false);
        }
        this.mRefPoint.setRef((ReferencePoint.Reference)this.mCoRefPoint.getSelectedItem());
        this.loadData();
    };
    protected String mBaseName = null;
    protected String mGenName = null;

    public static void setObjectTypeString(String objectTypeString) {
        if ((objectTypeString = objectTypeString.toLowerCase()).equals("device")) {
            mObjectType = OBJECT_TYPE.DEVICE;
        } else if (objectTypeString.equals("pin")) {
            mObjectType = OBJECT_TYPE.PIN;
        } else {
            mObjectType = OBJECT_TYPE.UNKNOWN;
            if (AclInfo.getDebugMode()) {
                ALog.logDebug((Throwable)new Throwable(), (String)"Unsupport: %s", (Object[])new Object[]{objectTypeString});
            }
        }
    }

    protected static OBJECT_TYPE getObjectType() {
        assert (mObjectType != null) : "Please ObjectCopyOrMoveUI.setObjectTypeString() first.";
        return mObjectType;
    }

    public static void prepareObjectForMove(Db db, String devPathStr, String objStr) {
        DevicePath dPath = DevicePath.fromString((Db)db, (String)devPathStr);
        if (ObjectCopyOrMoveUI.getObjectType() == OBJECT_TYPE.PIN) {
            PinInstance pinInst = ObjectCopyOrMoveUI.getPinInst(db, objStr, dPath);
            ObjectCopyOrMoveUI.stashPhysAndExternallyConnected(pinInst, dPath);
        }
    }

    public static void prepareObjectsForMove(Selection.SelSet objSet) {
        if (mObjectType != OBJECT_TYPE.PIN) {
            return;
        }
        for (HierInst hierInst : objSet.getHierInsts()) {
            DbObject obj = hierInst.getDbObject();
            if (!(obj instanceof PinInstance)) continue;
            PinInstance pin = (PinInstance)obj;
            PinTemplate pinT = pin.getPinTemplate();
            String objStr = pinT.getKeyStr();
            Cp.exec((String)"%s.%s(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{ObjectCopyOrMoveUI.class.getName(), "prepareObjectForMove", hierInst.getPath().toString(), objStr});
            Set stashed = (Set)pin.getValue(FldStashOfConnected);
            if (stashed == null) continue;
            AUtil.linkedList((Collection)stashed).stream().filter(hno -> hno.getDbObject() != pinT && hno.getDbObject() instanceof PinTemplate).forEach(hno -> {
                PinTemplate stashedPinT = (PinTemplate)hno.second;
                if (stashedPinT.getDeviceTemplate() == ((DevicePath)hno.first).getDeviceTemplate()) {
                    PinInstance stashedPinInst = PinInstance.getPinInstance((Device)((DevicePath)hno.first).getDevice(), (PinTemplate)stashedPinT);
                    if (objSet.contains((DevicePath)hno.first, (DbObject)stashedPinInst)) {
                        stashed.remove(hno);
                    }
                } else assert (false);
            });
        }
    }

    public static void setCopying(boolean flag) {
        sCopying = flag;
    }

    public static void setCreateInstances(boolean flag) {
        sCreateInstances = flag;
    }

    protected boolean isCopyMode() {
        return this.mCopyMode;
    }

    protected void setCopyMode(boolean copyMode) {
        this.mCopyMode = copyMode;
    }

    public static void showMoveObjects(Component uiOwner, AAppView v, Selection.SelSet objSet, boolean doCopy) {
        if (objSet == null || objSet.isEmpty()) {
            ALog.logError((String)"No %ss specified to %s.", (Object[])new Object[]{ObjectCopyOrMoveUI.getObjectType(), doCopy ? "copy" : "move"});
            return;
        }
        Db db = v.getDb();
        ObjectCopyOrMoveUI dlg = new ObjectCopyOrMoveUI(uiOwner, db, v, objSet, doCopy);
        dlg.setVisible(true);
    }

    public static void showMoveObject(Component uiOwner, AAppView v, Selection.SelSet objSet, String objectTypeString, boolean doCopy) {
        ObjectCopyOrMoveUI.setObjectTypeString(objectTypeString);
        ObjectCopyOrMoveUI.showMoveObjects(uiOwner, v, objSet, doCopy);
    }

    public static void movePinTemplateAbsolute(PinTemplate pin, long x, long y, float rot, boolean mirror) {
        for (PortTemplate port : pin.getPortTemplates()) {
            port.setLoc(new APoint2D(x, y));
            port.setRotate(rot);
        }
    }

    public static void movePinTemplateRelative(PinTemplate pin, long dx, long dy, float rot, boolean mirror) {
        for (PortTemplate port : pin.getPortTemplates()) {
            port.moveBy(dx, dy);
            port.setRotate(rot);
        }
    }

    private static PinTemplate copyPin(DevicePath devPath, PinTemplate originalPinT) {
        String name;
        Objects.requireNonNull(devPath);
        PinInstance originalPinInst = PinInstance.getPinInstance((Device)devPath.getDevice(), (PinTemplate)originalPinT);
        String string = name = sNextName != null ? sNextName : originalPinT.getName();
        if (sNextName != null) {
            sNextName = null;
        }
        PinTemplate pinT = PinTemplate.create((Net)originalPinT.getNet(), (String)name);
        pinT.setUse(originalPinT.getUse());
        pinT.setType(originalPinT.getType());
        for (PortTemplate port : AUtil.sort((IterableIterator)originalPinT.getPortTemplates(), (Comparator)PortTemplate.CompareByPortNum)) {
            port.copyTo(pinT);
        }
        pinT.setPadTemplate(originalPinT.getPadTemplate());
        PinInstance pinInst = PinInstance.getPinInstance((Device)originalPinInst.getDevice(), (PinTemplate)pinT);
        pinInst.setCopiedFrom(originalPinInst);
        PersonalityMap.copyPersonalities((DbObject)originalPinInst, (DevicePath)devPath, (DbObject)pinInst, (DevicePath)devPath, (boolean)true);
        return pinT;
    }

    public static void moveAbsolute(Db db, String path, String objName, long x, long y, float rot, boolean mirror) {
        if (db == null) {
            ALog.logError((String)"No Db specified to ObjectCopyOrMoveUI.moveAbsolute(), aborting %s.", (Object[])new Object[]{sCopying ? "copy" : "move"});
            return;
        }
        DevicePath dPath = DevicePath.fromString((Db)db, (String)path);
        ObjectCopyOrMoveUI.moveAbsolute(dPath, objName, x, y, rot, mirror);
    }

    public static void moveAbsolute(DevicePath dPath, String objName, long x, long y, float rot, boolean mirror) {
        Db db = dPath.getDb();
        if (ObjectCopyOrMoveUI.getObjectType() == OBJECT_TYPE.PIN) {
            PinTemplate pin = (PinTemplate)db.getByKeyStr(PinTemplate.class, objName);
            if (sCopying) {
                pin = ObjectCopyOrMoveUI.copyPin(dPath, pin);
            }
            ObjectCopyOrMoveUI.movePinTemplateAbsolute(pin, x, y, rot, mirror);
            return;
        }
        ObjectCopyOrMoveUI.moveDeviceAbsolute(dPath, objName, x, y, rot, mirror, db);
    }

    private static void moveDeviceAbsolute(DevicePath dPath, String objName, long x, long y, float rot, boolean mirror, Db db) {
        Device device = (Device)db.getByKeyStr(Device.class, objName);
        ObjectCopyOrMoveUI.moveDeviceAbsolute(dPath, device, x, y, rot, mirror);
    }

    public static void moveDeviceAbsolute(DevicePath dPath, Device device, long x, long y, float rot, boolean mirror) {
        if ((dPath = dPath.find(device, true)) == null || dPath.isEmpty()) {
            ALog.logError((String)"Invalid device path specified to ObjectCopyOrMoveUI.moveAbsolute(), aborting %s.", (Object[])new Object[]{sCopying ? "copy" : "move"});
            return;
        }
        DevicePath parentPath = dPath.getParent();
        Objects.requireNonNull(parentPath);
        AffineTransform undoParentTrans = ATransformUtil.inverse((AffineTransform)parentPath.getTransform());
        if (sCopying) {
            device = Device.copy((String)dPath.getString());
        }
        APoint2D newLoc = new APoint2D(x, y).transform(undoParentTrans);
        device.setLoc(newLoc);
        float parentRot = parentPath.getRot();
        float newRot = ATransformUtil.normRot((float)(rot - parentRot));
        device.setRotate(newRot);
        boolean parentMirror = parentPath.getMirror();
        boolean newMirror = mirror ^ parentMirror;
        if (newMirror != device.getMirror()) {
            device.setMirror(newMirror);
            device.setFlipped(newMirror);
        }
        device.setIsPlaced(true);
    }

    public static void stashPhysAndExternallyConnected(PinInstance pinInst, DevicePath dPath) {
        Set objs = (HashSet)pinInst.getValue(FldStashOfConnected);
        if (objs == null) {
            objs = new HashSet();
        }
        objs = PhysicalNetUtil.getPhysAndExternallyConnected((PinInstance)pinInst, (DevicePath)dPath, objs);
        DbClass clazz = OrbitApp.getCurDb().getDbClass(PinInstance.class);
        DbFieldDef c = clazz.getField(FldStashOfConnected);
        if (c == null) {
            clazz.addSoftField(FldStashOfConnected, Set.class, false);
        }
        pinInst.setValue(FldStashOfConnected, objs);
    }

    public static Set<HierInst<NetObject>> getNetObjs(PinInstance pinInst, DevicePath dPath) {
        Set objs = (Set)pinInst.getValue(FldStashOfConnected);
        if (objs == null) {
            objs = AUtil.hashSet((Object[])new HierInst[]{new HierInst(dPath, (DbObject)pinInst.getPinTemplate())});
        }
        return objs;
    }

    public static void setNextName(String name) {
        sNextName = name;
    }

    public static void movePinInstRelative(Db db, String path, String objName, long dx, long dy, float rot, boolean mirror) {
        if (db == null) {
            ALog.logError((String)"No Db specified to ObjectCopyOrMoveUI.moveAbsolute(), aborting %s.", (Object[])new Object[]{sCopying ? "copy" : "move"});
            return;
        }
        DevicePath dPath = DevicePath.fromString((Db)db, (String)path);
        ObjectCopyOrMoveUI.movePinInstRelative(dPath, objName, dx, dy, rot, mirror);
    }

    public static void movePinInstRelative(DevicePath dPath, String objName, long dx, long dy, float rot, boolean mirror) {
        if (ObjectCopyOrMoveUI.getObjectType() != OBJECT_TYPE.PIN) assert (false);
        Db db = dPath.getDb();
        PinInstance pinInst = (PinInstance)db.getByKeyStr(PinInstance.class, objName);
        PinTemplate pin = pinInst.getPinTemplate();
        if (sCopying) {
            pin = ObjectCopyOrMoveUI.copyPin(dPath, pin);
        }
        ObjectCopyOrMoveUI.movePinTemplateRelative(pin, dx, dy, rot, mirror);
    }

    public static void moveRelative(Db db, String path, String objName, long dx, long dy, float drot, boolean dmirror) {
        if (db == null) {
            ALog.logError((String)"No Db specified to ObjectCopyOrMoveUI.moveRelative(), aborting %s.", (Object[])new Object[]{sCopying ? "copy" : "move"});
            return;
        }
        DevicePath dPath = DevicePath.fromString((Db)db, (String)path);
        ObjectCopyOrMoveUI.moveRelative(dPath, objName, dx, dy, drot, dmirror);
    }

    public static void moveRelative(DevicePath dPath, String objName, long dx, long dy, float drot, boolean dmirror) {
        if (ObjectCopyOrMoveUI.getObjectType() == OBJECT_TYPE.PIN) {
            ObjectCopyOrMoveUI.movePinRelative(dPath, objName, dx, dy, drot, dmirror);
        } else {
            ObjectCopyOrMoveUI.moveDeviceRelative(dPath, objName, dx, dy, drot, dmirror);
        }
    }

    public static void movePinRelative(DevicePath dPath, String objName, long dx, long dy, float drot, boolean dmirror) {
        Db db = dPath.getDb();
        PinInstance pinInst = ObjectCopyOrMoveUI.getPinInst(db, objName, dPath);
        ObjectCopyOrMoveUI.movePinRelative(dPath, pinInst, dx, dy, drot, dmirror);
    }

    private static void movePinRelative(DevicePath dPath, PinInstance pinInst, long dx, long dy, float drot, boolean dmirror) {
        if (pinInst.getType() == PinTemplate.Type.BONDFINGERPAD) {
            PinTemplate pinT = pinInst.getPinTemplate();
            ObjectCopyOrMoveUI.moveBondFingerRelative(dPath, pinT, dx, dy, drot, dmirror);
        } else {
            APoint2D origPt = pinInst.getWorldLoc(dPath);
            Set<HierInst<NetObject>> objs = ObjectCopyOrMoveUI.getNetObjs(pinInst, dPath);
            for (HierInst<NetObject> obj : objs) {
                if (obj.second instanceof Wire) {
                    ObjectCopyOrMoveUI.moveWireInst((DevicePath)obj.first, (Wire)obj.second, dx, dy, drot, origPt);
                    continue;
                }
                if (obj.second instanceof PinTemplate) {
                    ObjectCopyOrMoveUI.movePinTemplateRelative((DevicePath)obj.first, (PinTemplate)obj.second, dx, dy, drot, dmirror);
                    continue;
                }
                ALog.logDebug((String)"Connected object '%s' do not move, when moving '%s'.", (Object[])new Object[]{obj, pinInst});
            }
        }
        if (pinInst.getValue(FldStashOfConnected) != null) {
            pinInst.unsetSoftValue(FldStashOfConnected);
        }
    }

    private static void moveBondFingerRelative(DevicePath dPath, PinTemplate pinT, long dx, long dy, float drot, boolean dmirror) {
        ObjectCopyOrMoveUI.movePinTemplateRelative(dPath, pinT, dx, dy, drot, dmirror);
        ObjectCopyOrMoveUI.updateConnectedWires(pinT);
    }

    public static void moveDeviceRelative(DevicePath dPath, String objName, long dx, long dy, float drot, boolean dmirror) {
        Db db = dPath.getDb();
        Device device = (Device)db.getByKeyStr(Device.class, objName);
        if (device == null) {
            ALog.logError((String)"Invalid device specified to ObjectCopyOrMoveUI.moveRelative(), aborting %s.", (Object[])new Object[]{sCopying ? "copy" : "move"});
            return;
        }
        ObjectCopyOrMoveUI.moveDeviceRelative(dPath, device, dx, dy, drot, dmirror);
    }

    public static void moveDeviceRelative(DevicePath dPath, Device device, long dx, long dy, float drot, boolean dmirror) {
        if (device.getIsFixed() && !sCopying) {
            ALog.logWarn((String)"Cannot move fixed device '%s'.", (Object[])new Object[]{device.getName()});
            return;
        }
        DevicePath dPath2 = dPath.find(device, true);
        if (dPath2 == null || dPath2.isEmpty()) {
            ALog.logError((String)"Invalid device path specified to ObjectCopyOrMoveUI.moveRelative(), aborting %s.", (Object[])new Object[]{sCopying ? "copy" : "move"});
            return;
        }
        APoint2D curLoc = dPath2.getLoc();
        float curRot = dPath2.getRot();
        boolean curMirror = dPath2.getMirror();
        long x = curLoc.getX() + dx;
        long y = curLoc.getY() + dy;
        float rot = curRot + drot;
        boolean mirror = curMirror ^ dmirror;
        ObjectCopyOrMoveUI.moveDeviceAbsolute(dPath, device, x, y, rot, mirror);
    }

    private static PinInstance getPinInst(Db db, String keyStr, DevicePath dPath) {
        PinInstance pinInst = (PinInstance)db.getByKeyStr(PinInstance.class, keyStr);
        if (pinInst == null) {
            PinTemplate pin = (PinTemplate)db.getByKeyStr(PinTemplate.class, keyStr);
            pinInst = pin.getPinInstance(dPath);
        }
        return pinInst;
    }

    private static Wire moveWireInst(DevicePath dPath, Wire wire, long dx, long dy, float drot, APoint2D origPt) {
        assert (dPath != null);
        AffineTransform trans = ATransformUtil.rotAboutAndXlate((double)origPt.getX(), (double)origPt.getY(), (float)drot, (double)dx, (double)dy);
        wire.setPath(wire.getPath().transform(trans));
        return wire;
    }

    private static PinTemplate movePinTemplateRelative(DevicePath dPath, PinTemplate pin, long dx, long dy, float drot, boolean dmirror) {
        if (dPath == null || pin == null) {
            assert (false);
            return null;
        }
        float curRot = pin.getRotate();
        boolean curMirror = pin.getMirror();
        AffineTransform devPathTrans = new AffineTransform(dPath.getTransform());
        long devX = (long)devPathTrans.getTranslateX();
        long devY = (long)devPathTrans.getTranslateY();
        AffineTransform undoParentTrans = ATransformUtil.inverse((AffineTransform)devPathTrans);
        APoint2D newLoc = new APoint2D(dx + devX, dy + devY);
        newLoc = newLoc.transform(undoParentTrans);
        dx = newLoc.getX();
        dy = newLoc.getY();
        float rot = curRot + drot;
        boolean mirror = curMirror ^ dmirror;
        if (sCopying) {
            pin = ObjectCopyOrMoveUI.copyPin(dPath, pin);
        }
        ObjectCopyOrMoveUI.movePinTemplateRelative(pin, dx, dy, rot, mirror);
        Device pinDev = dPath.getDevice();
        if (pinDev != null && dPath.getDeviceTemplate() != null) {
            dPath.getDeviceTemplate().invalidateExtent(true);
        }
        return pin;
    }

    public static void updateConnectedWires(PinTemplate pin) {
        pin.getConnectedWires().forEach(Wire::updateWirePath);
    }

    protected ObjectCopyOrMoveUI(Component uiOwner, Db db, AAppView view, Selection.SelSet objSet, boolean doCopy) {
        super(db, uiOwner);
        Object desc;
        Object title;
        this.setCopyMode(doCopy);
        sThisObjectTypeString = ObjectCopyOrMoveUI.getObjectType();
        this.mObjSet = sThisObjectTypeString == OBJECT_TYPE.PIN ? PinInstance.removePinsWithDuplicatePinTemplates((Selection.SelSet)objSet) : objSet;
        this.mUnit = view.getUnit();
        Object object = title = this.mCopyMode ? "Copy " : "Move ";
        title = (String)title + (this.mObjSet.size() == 1 ? String.format("%s '%s'", new Object[]{ObjectCopyOrMoveUI.getObjectType(), this.getFirstObjectName()}) : String.format("%d %s%s", new Object[]{this.mObjSet.size(), ObjectCopyOrMoveUI.getObjectType(), this.mObjSet.size() == 1 ? "" : "s"}));
        this.mRefPoint = new ReferencePoint();
        this.mRefPoint.setDbObj((DbObject)this.mObjSet.getDbObjects().next());
        this.mRefPoint.setRef(ReferencePoint.Reference.ORIG);
        this.setTitle((String)title);
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        this.mRbAbsolute = new JRadioButton("To:");
        this.mRbRelative = new JRadioButton("By:");
        ButtonGroup bgMoveType = new ButtonGroup();
        bgMoveType.add(this.mRbAbsolute);
        bgMoveType.add(this.mRbRelative);
        this.mRbRelative.setSelected(true);
        Object object2 = desc = this.mCopyMode ? "Copying " : "Moving ";
        desc = (String)desc + (this.mObjSet.size() == 1 ? String.format("'%s'", this.getFirstObjectName()) : String.format("%d %s%s", new Object[]{this.mObjSet.size(), ObjectCopyOrMoveUI.getObjectType(), this.mObjSet.size() == 1 ? "" : "s"}));
        this.getPinToCopy().ifPresent(pinT -> {
            JLabel lbl = l.add("New pin name:");
            this.mTxtName = (JTextField)l.add((Component)new JTextField(20));
            lbl.setLabelFor(this.mTxtName);
            l.newline();
            this.updateNewName();
        });
        if (((String)desc).length() > 20) {
            desc = ((String)desc).substring(0, 20) + "...";
        }
        l.pushFill((String)desc);
        l.add("Operator:", (GridBagConstraints)GridBagManager.LEFT.indent());
        if (this.mObjSet.size() == 1) {
            l.add((Component)this.mRbRelative, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.indent();
            l.add((Component)this.mRbAbsolute, (GridBagConstraints)GridBagManager.LEFT);
        } else {
            l.add("By:");
        }
        l.newline();
        this.mLblX = l.add("X:", (GridBagConstraints)GridBagManager.LEFT.indent());
        this.mTxtX = (JTextField)l.add((Component)new JTextField(10));
        l.newline();
        this.mLblY = l.add("Y:", (GridBagConstraints)GridBagManager.LEFT.indent());
        this.mTxtY = (JTextField)l.add((Component)new JTextField(10));
        l.newline();
        this.mLblRotation = l.add("Rotation:", (GridBagConstraints)GridBagManager.LEFT.indent());
        this.mTxtRotation = (JTextField)l.add((Component)new JTextField(5));
        l.newline();
        if (ObjectCopyOrMoveUI.getObjectType() != OBJECT_TYPE.PIN) {
            this.mLblMirror = l.add("Mirror:", (GridBagConstraints)GridBagManager.LEFT.indent());
            this.mCbMirror = (JCheckBox)l.add((Component)new JCheckBox());
            l.newline();
        }
        this.mLbRefPoint = l.add("Reference Point:", (GridBagConstraints)GridBagManager.LEFT.indent());
        this.mCoRefPoint = (JComboBox)l.add(new JComboBox<ReferencePoint.Reference>(ReferencePoint.Reference.values()));
        this.mCoRefPoint.setSelectedItem(ReferencePoint.Reference.ORIG);
        this.mCoRefPoint.addActionListener(this.mRefPointChangedListener);
        l.newline();
        this.mLbRefX = l.add("Reference X:", (GridBagConstraints)GridBagManager.LEFT.indent());
        this.mTxtRefX = (JTextField)l.add((Component)new JTextField(10));
        this.mTxtRefX.setEnabled(false);
        l.newline();
        this.mLbRefY = l.add("Reference Y:", (GridBagConstraints)GridBagManager.LEFT.indent());
        this.mTxtRefY = (JTextField)l.add((Component)new JTextField(10));
        this.mTxtRefY.setEnabled(false);
        l.newline();
        l.addFillY();
        l.addFillX();
        l.popNl();
        this.initAdvancedParameter(l);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnApply = (JButton)l.add((Component)new JButton("Apply"), (GridBagConstraints)GridBagManager.RIGHT);
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"), (GridBagConstraints)GridBagManager.RIGHT);
        this.mRbAbsolute.addActionListener(this.mMoveTypeChangedListener);
        this.mRbRelative.addActionListener(this.mMoveTypeChangedListener);
        btnApply.addActionListener(this.mApplyListener);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnApply);
        this.pack();
        UIUtil.center((Component)((Object)this));
    }

    private void initAdvancedParameter(GridBagManager l) {
        if (!this.mCopyMode) {
            return;
        }
        this.mCboParaMode = new JComboBox();
        this.mCboParaMode.addItem(PARAMETER_MODE.NONE);
        this.mCboParaMode.addItem(PARAMETER_MODE.RECTANGULAR);
        this.mCboXOrder = new JComboBox();
        this.mCboXOrder.addItem(PARAMETER_ORDER.RIGHT);
        this.mCboXOrder.addItem(PARAMETER_ORDER.LEFT);
        this.mCboYOrder = new JComboBox();
        this.mCboYOrder.addItem(PARAMETER_ORDER.DOWN);
        this.mCboYOrder.addItem(PARAMETER_ORDER.UP);
        this.mTxtXQty = new JTextField(5);
        this.mTxtXQty.setText("1");
        this.mTxtYQty = new JTextField(5);
        this.mTxtYQty.setText("1");
        this.mTxtXSpacing = new JTextField(10);
        this.mTxtXSpacing.setText("100.00");
        this.mTxtYSpacing = new JTextField(10);
        this.mTxtYSpacing.setText("100.00");
        JPanel paraPanel = new JPanel();
        l.push("Advanced Parameter", (GridBagConstraints)GridBagManager.FILLX);
        l.add("Mode:", this.mCboParaMode);
        l.newline();
        l.push((Container)paraPanel, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.add("");
        l.add("Quantity");
        l.add("Spacing");
        l.add("Order");
        l.addFillX();
        l.newline();
        l.add("X:");
        l.add((Component)this.mTxtXQty);
        l.add((Component)this.mTxtXSpacing);
        l.add(this.mCboXOrder, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add("Y:");
        l.add((Component)this.mTxtYQty);
        l.add((Component)this.mTxtYSpacing);
        l.add(this.mCboYOrder, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.addFillX();
        l.pop();
        l.addFillX();
        l.pop();
        l.addFillX();
        UIUtil.setEnabled((Container)paraPanel, (boolean)false);
        this.mCboParaMode.addItemListener(e -> UIUtil.setEnabled((Container)paraPanel, (this.mCboParaMode.getSelectedItem() != PARAMETER_MODE.NONE ? 1 : 0) != 0));
        this.mCboParaMode.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                PARAMETER_MODE mode = (PARAMETER_MODE)((Object)value);
                this.setText(mode.getUserName());
                return this;
            }
        });
        DefaultListCellRenderer orderRender = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                PARAMETER_ORDER order = (PARAMETER_ORDER)((Object)value);
                this.setText(order.getUserName());
                return this;
            }
        };
        this.mCboXOrder.setRenderer(orderRender);
        this.mCboYOrder.setRenderer(orderRender);
        this.mCboParaMode.setSelectedItem((Object)PARAMETER_MODE.RECTANGULAR);
    }

    protected Optional<PinTemplate> getPinToCopy() {
        if (!this.mCopyMode || this.mObjSet.size() != 1) {
            return Optional.empty();
        }
        DbObject dbo = this.mObjSet.getDbObjects().findFirst().orElse(null);
        if (!(dbo instanceof PinTemplate)) {
            return Optional.empty();
        }
        PinTemplate pinT = (PinTemplate)dbo;
        if (pinT.getDb() == null) {
            return Optional.empty();
        }
        return Optional.of(pinT);
    }

    protected void loadData() {
        APoint2D loc = this.getFirstLoc();
        if (loc == null) {
            ALog.logWarn((String)"Unable to find physical location.");
            EventQueue.invokeLater(() -> UIUtil.closeWindow((Window)((Object)this)));
            return;
        }
        if (this.mRbRelative.isSelected()) {
            this.mLblX.setText("Offset X by:");
            this.mLblY.setText("Offset Y by:");
            this.mLblRotation.setText("Rotate by:");
            if (this.mLblMirror != null) {
                this.mLblMirror.setText("Toggle mirror:");
            }
            this.mTxtX.setText("0.00");
            this.mTxtY.setText("0.00");
            this.mTxtRotation.setText("0.00");
            if (this.mCbMirror != null) {
                this.mCbMirror.setSelected(false);
            }
            this.mLbRefPoint.setVisible(false);
            this.mCoRefPoint.setVisible(false);
            this.mLbRefX.setVisible(false);
            this.mTxtRefX.setVisible(false);
            this.mLbRefY.setVisible(false);
            this.mTxtRefY.setVisible(false);
        } else {
            this.mLblX.setText("X:");
            this.mLblY.setText("Y:");
            this.mLblRotation.setText("Rotation:");
            if (this.mLblMirror != null) {
                this.mLblMirror.setText("Mirror:");
            }
            this.mTxtX.setText(this.mUnit.toUserStr(loc.getX()));
            this.mTxtY.setText(this.mUnit.toUserStr(loc.getY()));
            this.mTxtRotation.setText(AUtil.doubleToString((double)this.getFirstRot()));
            if (this.mCbMirror != null) {
                this.mCbMirror.setSelected(this.getFirstMirror());
            }
            this.mLbRefPoint.setVisible(true);
            this.mCoRefPoint.setVisible(true);
            this.mLbRefX.setVisible(true);
            this.mTxtRefX.setVisible(true);
            this.mTxtRefX.setText(this.mUnit.toUserStr(this.mRefPoint.getRefX()));
            this.mLbRefY.setVisible(true);
            this.mTxtRefY.setVisible(true);
            this.mTxtRefY.setText(this.mUnit.toUserStr(this.mRefPoint.getRefY()));
        }
        if (this.mTxtName != null) {
            this.mTxtName.requestFocus();
        } else {
            this.mTxtX.requestFocus();
        }
        this.setMinimumSize(this.getPreferredSize());
    }

    protected String getFirstObjectName() {
        DbObject obj = (DbObject)this.mObjSet.getDbObjects().next();
        return AbstractViewMode.getDbObjectName(obj);
    }

    protected APoint2D getFirstLoc() {
        DbObject object = (DbObject)this.mObjSet.getDbObjects().next();
        if (object instanceof Device) {
            DevicePath path = ((Selection.SelObj)this.mObjSet.get((Object)object)).getPaths().stream().findFirst().orElse(null);
            if (path != null) {
                path.add((Device)object);
                return path.getLoc();
            }
            return ((Device)object).getLoc();
        }
        if (object instanceof PinInstance) {
            return ((PinInstance)object).getLoc();
        }
        if (object instanceof PinTemplate) {
            return ((PinTemplate)object).getLoc();
        }
        return null;
    }

    protected boolean getFirstMirror() {
        DbObject object = (DbObject)this.mObjSet.getDbObjects().next();
        if (object instanceof Device) {
            return ((Device)object).getMirror();
        }
        if (object instanceof PinInstance) {
            return false;
        }
        return false;
    }

    protected float getFirstRot() {
        DbObject object = (DbObject)this.mObjSet.getDbObjects().next();
        if (object instanceof Device) {
            return ((Device)object).getRotate();
        }
        if (object instanceof PinInstance) {
            return ((PinInstance)object).getRotate();
        }
        return 0.0f;
    }

    public void addNotify() {
        super.addNotify();
        this.loadData();
    }

    public static String getKeyStrList(List<Object> mObjList) {
        StringBuilder listStr = new StringBuilder();
        for (Object dbObj : mObjList) {
            if (listStr.length() != 0) {
                listStr.append(",");
            }
            if (dbObj instanceof DevicePath) {
                listStr.append(((DevicePath)dbObj).getString());
                continue;
            }
            listStr.append(((DbObject)dbObj).getKeyStr());
        }
        return listStr.toString();
    }

    private boolean isValidConfig() {
        try {
            if (this.mCopyMode && this.mCboParaMode.getSelectedItem() == PARAMETER_MODE.RECTANGULAR) {
                AFieldValidator.validateInt((JTextField)this.mTxtXQty);
                AFieldValidator.validateInt((JTextField)this.mTxtYQty);
                AFieldValidator.validateDouble((JTextField)this.mTxtXSpacing);
                AFieldValidator.validateDouble((JTextField)this.mTxtYSpacing);
            }
        }
        catch (Exception e) {
            ALog.logError((String)"Invalid parameters, unable to apply");
            return false;
        }
        return true;
    }

    protected void apply() throws AFieldValidator.AFieldValidationException {
        if (sThisObjectTypeString == OBJECT_TYPE.DEVICE && !this.preapplyDeviceCheck()) {
            return;
        }
        if (!this.mCopyMode && this.hasFixedDevice()) {
            return;
        }
        if (!this.isValidConfig()) {
            return;
        }
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)this.getTransactionName());){
            Cp.exec((String)"com.sigrity.orbit.ui.ObjectCopyOrMoveUI.setObjectTypeString(\"%s\")", (Object[])new Object[]{sThisObjectTypeString});
            Cp.exec((String)"com.sigrity.orbit.ui.ObjectCopyOrMoveUI.setCopying(%b)", (Object[])new Object[]{this.mCopyMode});
            if (this.mCboParaMode == null || this.mCboParaMode.getSelectedItem() == PARAMETER_MODE.NONE) {
                this.copyOrMoveObject();
            } else if (this.mCopyMode && this.mCboParaMode.getSelectedItem() == PARAMETER_MODE.RECTANGULAR) {
                this.copyObjectParameterized((PARAMETER_MODE)((Object)this.mCboParaMode.getSelectedItem()));
            }
            if (this.mCopyMode) {
                Cp.exec((String)"com.sigrity.orbit.ui.ObjectCopyOrMoveUI.setCopying(false)", (Object[])new Object[0]);
            }
        }
        this.updateNewName();
        OrbitIO.refreshViewsOf(this.mDb);
    }

    private void copyOrMoveObject() throws AFieldValidator.AFieldValidationException {
        String devPathStr;
        ObjectCopyOrMoveUI.prepareObjectsForMove(this.mObjSet);
        String string = devPathStr = this.mObjSet.getDevicePathIfOnlyOne() == null ? "" : this.mObjSet.getDevicePathIfOnlyOne().toString();
        if (this.mCoRefPoint.getSelectedItem() == ReferencePoint.Reference.XY) {
            this.mRefPoint.setRefPoint(new APoint2D(this.mUnit.fromUserString(this.mTxtRefX.getText(), 0L), this.mUnit.fromUserString(this.mTxtRefY.getText(), 0L)));
        }
        long x = this.mRefPoint.toRefX(this.getXFromUserString().longValue());
        long y = this.mRefPoint.toRefY(this.getYFromUserString().longValue());
        float r = this.getRotFromString();
        boolean mirror = this.getIsMirror();
        Cp.exec((String)"unset(\"_sync\");", (Object[])new Object[0]);
        Cp.exec((String)"_sync = new com.sigrity.orbit.automation.contact_sync.ContactObjectSyncEngine(curDb());", (Object[])new Object[0]);
        for (Selection.SelObj selObj : this.mObjSet.values()) {
            if (this.mTxtName != null) {
                Cp.exec((String)"com.sigrity.orbit.ui.ObjectCopyOrMoveUI.setNextName(\"%s\")", (Object[])new Object[]{AStringEscape.escapeJavaString((String)this.mTxtName.getText())});
            }
            String objStr = this.getObjKeyStr(selObj);
            if (this.mRbAbsolute.isSelected()) {
                Cp.exec((String)"com.sigrity.orbit.ui.ObjectCopyOrMoveUI.moveAbsolute(curDb(), \"%s\", \"%s\", %dL, %dL, %ff, %b)", (Object[])new Object[]{devPathStr, objStr, x, y, Float.valueOf(r), mirror});
            } else {
                Cp.exec((String)"com.sigrity.orbit.ui.ObjectCopyOrMoveUI.moveRelative(curDb(), \"%s\", \"%s\", %dL, %dL, %ff, %b)", (Object[])new Object[]{devPathStr, objStr, x, y, Float.valueOf(r), mirror});
            }
            Cp.exec((String)"_sync.addToSyncLoc(%s);", (Object[])new Object[]{CpHelper.getObjCmdStr(selObj.getDbObject())});
        }
        Cp.exec((String)"_sync.execute()", (Object[])new Object[0]);
        Cp.exec((String)"unset(\"_sync\");", (Object[])new Object[0]);
    }

    private void copyObjectParameterized(PARAMETER_MODE mode) throws AFieldValidator.AFieldValidationException {
        String devPathStr;
        assert (mode == PARAMETER_MODE.RECTANGULAR);
        ObjectCopyOrMoveUI.prepareObjectsForMove(this.mObjSet);
        String string = devPathStr = this.mObjSet.getDevicePathIfOnlyOne() == null ? "" : this.mObjSet.getDevicePathIfOnlyOne().toString();
        if (this.mCoRefPoint.getSelectedItem() == ReferencePoint.Reference.XY) {
            this.mRefPoint.setRefPoint(new APoint2D(this.mUnit.fromUserString(this.mTxtRefX.getText(), 0L), this.mUnit.fromUserString(this.mTxtRefY.getText(), 0L)));
        }
        long x = this.mRefPoint.toRefX(this.getXFromUserString().longValue());
        long y = this.mRefPoint.toRefY(this.getYFromUserString().longValue());
        float r = this.getRotFromString();
        boolean mirror = this.getIsMirror();
        int xQty = Integer.parseInt(this.mTxtXQty.getText());
        int yQty = Integer.parseInt(this.mTxtYQty.getText());
        long spaceX = this.mUnit.fromUserString(this.mTxtXSpacing.getText());
        long spaceY = this.mUnit.fromUserString(this.mTxtYSpacing.getText());
        if (this.mCboXOrder.getSelectedItem() == PARAMETER_ORDER.LEFT) {
            spaceX = -spaceX;
        }
        if (this.mCboYOrder.getSelectedItem() == PARAMETER_ORDER.DOWN) {
            spaceY = -spaceY;
        }
        StringBuilder param = new StringBuilder("new String[] {");
        boolean firstItem = true;
        for (Selection.SelObj selObj : this.mObjSet.values()) {
            if (!firstItem) {
                param.append(",");
            } else {
                firstItem = false;
            }
            param.append("\"" + this.getObjKeyStr(selObj) + "\"");
        }
        param.append("}");
        Cp.exec((String)"unset(\"_paraEngine\")", (Object[])new Object[0]);
        Cp.exec((String)"_paraEngine = new com.sigrity.orbit.ui.ObjectCopyOrMoveUI.ParameterCopyEngine(curDb())", (Object[])new Object[0]);
        Cp.exec((String)"_paraEngine.setX(%dL)", (Object[])new Object[]{x});
        Cp.exec((String)"_paraEngine.setY(%dL)", (Object[])new Object[]{y});
        Cp.exec((String)"_paraEngine.setRotate(%ff)", (Object[])new Object[]{Float.valueOf(r)});
        Cp.exec((String)"_paraEngine.setMirror(%b)", (Object[])new Object[]{mirror});
        Cp.exec((String)"_paraEngine.setXQty(%d)", (Object[])new Object[]{xQty});
        Cp.exec((String)"_paraEngine.setYQty(%d)", (Object[])new Object[]{yQty});
        Cp.exec((String)"_paraEngine.setXSpace(%dL)", (Object[])new Object[]{spaceX});
        Cp.exec((String)"_paraEngine.setYSpace(%dL)", (Object[])new Object[]{spaceY});
        Cp.exec((String)"_paraEngine.setDevicePath(\"%s\")", (Object[])new Object[]{devPathStr});
        Cp.exec((String)"_paraEngine.setObjectKeys(%s)", (Object[])new Object[]{param.toString()});
        Cp.exec((String)"_paraEngine.setAbsolute(%b)", (Object[])new Object[]{this.mRbAbsolute.isSelected()});
        Cp.exec((String)"_paraEngine.setMode(\"%s\")", (Object[])new Object[]{this.mCboParaMode.getSelectedItem()});
        Cp.exec((String)"_paraEngine.exec()", (Object[])new Object[0]);
        Cp.exec((String)"unset(\"_paraEngine\")", (Object[])new Object[0]);
    }

    private boolean hasFixedDevice() {
        int numFixed = 0;
        for (Selection.SelObj selObj : this.mObjSet.values()) {
            DbObject obj = selObj.getDbObject();
            if (!(obj instanceof Device) || !((Device)obj).getIsFixed()) continue;
            ALog.logWarn((String)"Device, %s, is fixed.", (Object[])new Object[]{((Device)obj).getName()});
            ++numFixed;
        }
        if (numFixed > 0) {
            ALog.logError((String)"This command does not move fixed devices.");
            return true;
        }
        return false;
    }

    private String getObjKeyStr(Selection.SelObj selObj) {
        DbObject obj = selObj.getDbObject();
        String objStr = obj instanceof PinInstance ? ((PinInstance)obj).getPinTemplate().getKeyStr() : obj.getKeyStr();
        return objStr;
    }

    private Long getXFromUserString() throws AFieldValidator.AFieldValidationException {
        return this.mUnit.fromUserString(AFieldValidator.validateDouble((JTextField)this.mTxtX));
    }

    private Long getYFromUserString() throws AFieldValidator.AFieldValidationException {
        return this.mUnit.fromUserString(AFieldValidator.validateDouble((JTextField)this.mTxtY));
    }

    private float getRotFromString() throws AFieldValidator.AFieldValidationException {
        double rot = AUtil.doubleFromString((String)AFieldValidator.validateDouble((JTextField)this.mTxtRotation));
        return ATransformUtil.normRot((float)((float)rot));
    }

    private boolean getIsMirror() {
        return this.mCbMirror != null && this.mCbMirror.isSelected();
    }

    private String getTransactionName() {
        return String.format("%s %s", this.mCopyMode ? "Copy" : "Move", this.mRbAbsolute.isSelected() ? "Absolute" : "Relative");
    }

    protected void updateNewName() {
        this.getPinToCopy().ifPresent(pinT -> {
            if (this.mBaseName == null || this.mGenName == null || !this.mGenName.equals(this.mTxtName.getText())) {
                this.mBaseName = this.mTxtName.getText().isEmpty() ? pinT.getName() + "-copy" : this.mTxtName.getText();
            }
            this.mGenName = this.mBaseName;
            DeviceTemplate devT = pinT.getDeviceTemplate();
            long i = 1L;
            while (devT.getPinByName(this.mGenName) != null) {
                this.mGenName = this.mBaseName + i;
                ++i;
            }
            this.mTxtName.setText(this.mGenName);
        });
    }

    protected boolean preapplyDeviceCheck() throws AFieldValidator.AFieldValidationException {
        LinkedList pathsToModify = Lists.newLinkedList();
        if (this.mObjSet.size() < 2) {
            pathsToModify.add((DevicePath)this.mObjSet.getDevicePaths().next());
        } else {
            long x = this.getXFromUserString();
            long y = this.getYFromUserString();
            boolean moveRequested = x != 0L || y != 0L;
            HashMap device2Path = Maps.newHashMap();
            HashMultimap ref2Invalid = HashMultimap.create();
            for (Selection.SelObj selObj : this.mObjSet.values()) {
                Device curDevice = (Device)selObj.getDbObject();
                for (DevicePath curPath : selObj.getPaths()) {
                    curPath = new DevicePath(curPath, curDevice);
                    DevicePath existPath = (DevicePath)device2Path.get(curDevice);
                    if (existPath != null) {
                        if (!moveRequested || curPath.getRot() == existPath.getRot() && curPath.getMirror() == existPath.getMirror()) continue;
                        ref2Invalid.put((Object)existPath, (Object)curPath);
                        continue;
                    }
                    device2Path.put(curDevice, curPath);
                }
            }
            long totalInvalid = 0L;
            for (DevicePath refPath : ref2Invalid.keySet()) {
                Set invalids = ref2Invalid.get((Object)refPath);
                int count = invalids.size();
                totalInvalid += (long)count;
                ALog.logWarn((String)"%d instance(s) of device '%s' specified in orientation other than rotated %s mirrored %b:", (Object[])new Object[]{count, refPath.toString(), AUtil.doubleToString((double)refPath.getRot()), refPath.getMirror()});
                for (DevicePath invalid : invalids) {
                    ALog.logWarn((String)"\t%s is rotated %s mirrored %b", (Object[])new Object[]{invalid, AUtil.doubleToString((double)invalid.getRot()), invalid.getMirror()});
                }
            }
            if (totalInvalid > 0L) {
                String msg = String.format("The selection contains %d device instances that are not in the same\norientation as the primary instances to be moved, continuing may result\nin unexpected results as the specified device trasnlation (%s, %s)\nwill be applied to the primary instances but will result in different\ntranslations for the instances in other orientations.\n\nDo you want to continue the move operation?", totalInvalid, this.mTxtX, this.mTxtY);
                if (0 != JOptionPane.showConfirmDialog(this.getOwner(), msg, "Move Devices", 0, 2)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static class ParameterCopyEngine {
        long x;
        long y;
        float r;
        boolean mirror;
        int xQty;
        int yQty;
        long spaceX;
        long spaceY;
        boolean isAbsolute;
        String pathStr;
        final List<String> objKeys = new LinkedList<String>();
        String mode;
        Db db;

        public ParameterCopyEngine(Db db) {
            this.db = db;
        }

        public void setX(long x) {
            this.x = x;
        }

        public void setY(long y) {
            this.y = y;
        }

        public void setRotate(float r) {
            this.r = r;
        }

        public void setMirror(boolean m) {
            this.mirror = m;
        }

        public void setXQty(int xQty) {
            this.xQty = xQty;
        }

        public void setYQty(int yQty) {
            this.yQty = yQty;
        }

        public void setXSpace(long spaceX) {
            this.spaceX = spaceX;
        }

        public void setYSpace(long spaceY) {
            this.spaceY = spaceY;
        }

        public void setDevicePath(String pathStr) {
            this.pathStr = pathStr;
        }

        public void setObjectKeys(String[] objKeys) {
            for (String objKey : objKeys) {
                this.objKeys.add(objKey);
            }
        }

        public void setAbsolute(boolean isAbsolute) {
            this.isAbsolute = isAbsolute;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public boolean exec() {
            for (int i = 0; i < this.xQty; ++i) {
                for (int j = 0; j < this.yQty; ++j) {
                    for (String objKey : this.objKeys) {
                        if (this.isAbsolute) {
                            ObjectCopyOrMoveUI.moveAbsolute(this.db, this.pathStr, objKey, this.x + (long)i * this.spaceX, this.y + (long)j * this.spaceY, this.r, this.mirror);
                            continue;
                        }
                        ObjectCopyOrMoveUI.moveRelative(this.db, this.pathStr, objKey, this.x + (long)i * this.spaceX, this.y + (long)j * this.spaceY, this.r, this.mirror);
                    }
                }
            }
            OrbitIO.refreshViewsOf(this.db);
            return true;
        }
    }

    private static enum PARAMETER_ORDER {
        UP("Up"),
        DOWN("Down"),
        LEFT("Left"),
        RIGHT("Right");

        final String userName;

        private PARAMETER_ORDER(String name) {
            this.userName = name;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    private static enum PARAMETER_MODE {
        NONE("None"),
        RECTANGULAR("Rectangular");

        final String userName;

        private PARAMETER_MODE(String name) {
            this.userName = name;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    private static enum OBJECT_TYPE {
        PIN,
        DEVICE,
        UNKNOWN;

    }
}

