/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ABoolean;
import com.sigrity.acl.AFileExplorer;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.dbui.DbStructureUI;
import com.sigrity.acl.edaMgrs.HConnEngine;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AActionGroup;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.ATransformableIcon;
import com.sigrity.acl.ui.ActionOnPlaceableItem;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DiffPairUI;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.NetGraphPanel;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.automation.iocellplacement.ui.IOCellPlacerUI;
import com.sigrity.orbit.cmd.DeviceCommands;
import com.sigrity.orbit.cmd.WireCommands;
import com.sigrity.orbit.colView.ColViewPanel;
import com.sigrity.orbit.export.BgaDieTxtIO;
import com.sigrity.orbit.export.BumpLocUI;
import com.sigrity.orbit.export.DeviceCSVIn;
import com.sigrity.orbit.export.DeviceCSVOut;
import com.sigrity.orbit.export.ExportSymbolSpreadsheet;
import com.sigrity.orbit.term.ui.TermListExportUI;
import com.sigrity.orbit.term.ui.TermListImportUI;
import com.sigrity.orbit.term.ui.TermMapCsvExportUI;
import com.sigrity.orbit.term.ui.TermMapCsvImportUI;
import com.sigrity.orbit.ui.AssignPwrGndDlg;
import com.sigrity.orbit.ui.AutoBundleDlg;
import com.sigrity.orbit.ui.BundleUI;
import com.sigrity.orbit.ui.CSVNetMarixOutDlg;
import com.sigrity.orbit.ui.CSVNetlistInDlg;
import com.sigrity.orbit.ui.CSVNetlistOutDlg;
import com.sigrity.orbit.ui.CSVPersonalityInDlg;
import com.sigrity.orbit.ui.CSVPersonalityOutDlg;
import com.sigrity.orbit.ui.CSVPinListUI;
import com.sigrity.orbit.ui.ConnectionUI;
import com.sigrity.orbit.ui.ConstructPlaceDlg;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.DeleteContactUI;
import com.sigrity.orbit.ui.DevicePinMappingDlg;
import com.sigrity.orbit.ui.DeviceTemplateUI;
import com.sigrity.orbit.ui.DeviceUI;
import com.sigrity.orbit.ui.DieExtentsUI;
import com.sigrity.orbit.ui.DimensionsUI;
import com.sigrity.orbit.ui.EditPortUI;
import com.sigrity.orbit.ui.ExportAIFUI;
import com.sigrity.orbit.ui.ExportCCTUI;
import com.sigrity.orbit.ui.ExportDEFUI;
import com.sigrity.orbit.ui.ExportNetsText;
import com.sigrity.orbit.ui.ExportVerilogUI2;
import com.sigrity.orbit.ui.FloorplanUI;
import com.sigrity.orbit.ui.GridChooser;
import com.sigrity.orbit.ui.ImportCCTUI;
import com.sigrity.orbit.ui.InterfaceUI;
import com.sigrity.orbit.ui.LayerUI;
import com.sigrity.orbit.ui.MountingMgmtDlg;
import com.sigrity.orbit.ui.NetMapBulkCreateUI;
import com.sigrity.orbit.ui.NetMappingExportUI;
import com.sigrity.orbit.ui.NetMappingImportUI;
import com.sigrity.orbit.ui.NetUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PatternPlacementUI;
import com.sigrity.orbit.ui.PeripheralIOUI;
import com.sigrity.orbit.ui.PersonalityActions;
import com.sigrity.orbit.ui.PinUI;
import com.sigrity.orbit.ui.PowerConfigUI;
import com.sigrity.orbit.ui.RemoveNetsUI;
import com.sigrity.orbit.ui.RenameDeviceTemplateUI;
import com.sigrity.orbit.ui.RenameDeviceUI;
import com.sigrity.orbit.ui.RenamePinUI;
import com.sigrity.orbit.ui.RenameSubstrateUI;
import com.sigrity.orbit.ui.ReplaceDeviceUI;
import com.sigrity.orbit.ui.SetPinNetUI;
import com.sigrity.orbit.ui.SubstrateFromFootprintDeviceUI;
import com.sigrity.orbit.ui.TextUI;
import com.sigrity.orbit.ui.VerilogUI;
import com.sigrity.orbit.ui.WireUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.netlist_editor.NetListEditorUI;
import com.sigrity.orbit.ui.rename_group.RenameDeviceGroupUI;
import com.sigrity.orbit.ui.rename_group.RenamePinGroupUI;
import com.sigrity.orbit.ui.table_editor.EditDeviceUI;
import com.sigrity.orbit.ui.table_editor.EditLayerUI;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import com.sigrity.orbit.ui.wb_route.RDLRuleSetDlg;
import com.sigrity.orbit.ui.wb_route.RouterRuleSetDlg;
import com.sigrity.orbit.util.MatrixRenamePins;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.NodeIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class OrbitGuiObjectActionRegistry
extends ObjectActionRegistry {
    protected OrbitGuiWS mWs;
    protected ObjectActionRegistry.ActionFactory<HierInst<?>> mHierInstFactory = new ObjectActionRegistry.ActionFactory<HierInst<?>>(){

        private void addDeviceActions(Device device, DevicePath path, List<Action> actions, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            Substrate substrate;
            AAppView view = OrbitGuiObjectActionRegistry.this.mWs.getCurrentView();
            DeviceTemplate devT = device.getTemplate();
            DeviceTemplate.Type devType = devT == null ? null : devT.getType();
            boolean extras = DbExplorerPanel.enableExtendedUI();
            if (path != null && path.getLast() != device) {
                path = new DevicePath(path, device);
            }
            if (path != null) {
                actions.add(new ActionZoomToDevicePath(path, view));
            } else {
                actions.add(new ActionZoomToDevice(device, view));
            }
            if (path != null) {
                actions.add(new ActionShowMe(path));
            }
            ArrayList<Device> objList = null;
            AActionGroup deviceGroup = new AActionGroup("Device");
            deviceGroup.setGroupByFirstWord(true);
            actions.add(deviceGroup);
            if (path != null) {
                objList = new ArrayList<Device>();
                objList.add(device);
                actions.add(new ActionOnPlaceableItem(path, (DbObject)device, ActionOnPlaceableItem.ACTION.MOVE, "Move Device Parametrically..."));
                actions.add(new ActionOnPlaceableItem(path, (DbObject)device, ActionOnPlaceableItem.ACTION.MOVE_OBJ_INT, true, "false, false", "Move Device Interactively"));
                AActionGroup actionMoveOrigin = new AActionGroup("Move Origin");
                for (DeviceCommands.ORIGIN_POS pos : DeviceCommands.ORIGIN_POS.values()) {
                    actionMoveOrigin.addAction(new DeviceUI.ActionMoveOrigin(path, pos));
                }
                actions.add(actionMoveOrigin);
            }
            if (path != null) {
                actions.add(new DeviceUI.ActionCenterDevice(path));
            }
            if (path != null) {
                deviceGroup.addAction(new DeviceUI.ActionEditDevice(path));
            }
            deviceGroup.addAction(new RenameDeviceUI.ActionRenameDevice(device));
            if (path != null) {
                actions.add(new ActionAutoBundleDevice(path));
            }
            if (path != null) {
                actions.add(new TextUI.ActionTextDevice(path, null));
            }
            if (path != null) {
                actions.add(new DimensionsUI.ActionDimsDevice(path, null));
            }
            if (path != null) {
                actions.add(new ActionOnPlaceableItem(path, (DbObject)device, ActionOnPlaceableItem.ACTION.COPY, "Copy Device to Location..."));
                actions.add(new ActionCopyPath(path));
            }
            actions.add(new DeviceUI.ActionCopyDevice(device));
            actions.add(new DeviceUI.ActionMoveDevice(path, device));
            actions.add(new ActionOnPlaceableItem(path, (DbObject)device, ActionOnPlaceableItem.ACTION.DELETE_OBJ, false, "", "Delete Device..."));
            actions.add(new ActionDeleteDeviceContents(device));
            if (path != null && DeleteContactUI.hasContacts(path)) {
                actions.add(DeleteContactUI.getAction(path));
            }
            actions.add(new ActionReplaceDevice(device));
            actions.add(AssignPwrGndDlg.getAction(path));
            if (path != null && (devType == DeviceTemplate.Type.GROUP || devType == DeviceTemplate.Type.COVER)) {
                actions.add(new DeviceUI.ActionUngroupDevices(path));
            } else {
                Selection sel = new Selection(device.getDb());
                sel.add(path, (DbObject)device);
                actions.add(new DeviceUI.ActionGroupDevices(sel));
            }
            if (path != null && devType == DeviceTemplate.Type.GROUP) {
                actions.add(new ActionShowIOView(path));
                actions.add(new ActionShowIOViewByRotation(path));
            }
            if (extras && path != null) {
                actions.add(new ActionExportCCT(path));
                actions.add(new ActionImportCCT(path));
            }
            if (path != null && device.getIsSubstrate()) {
                actions.add(new ActionExportAIF(path));
                actions.add(new ActionFlipInPlace(path));
            }
            if (path != null && device.isDie()) {
                actions.add(new ActionExportDef(path));
                actions.add(new ExportDieBgaTxt(path));
                actions.add(new ActionSelectDriversOfDie(path));
                actions.add(new ActionSelectIOPorts(path));
                actions.add(new DeviceUI.ActionSelectPadsOfType(path, PinTemplate.Type.IOPAD));
                actions.add(new DeviceUI.ActionSelectPadsOfType(path, PinTemplate.Type.BUMPPAD));
                actions.add(new DeviceUI.ActionSelectPadsOfType(path, PinTemplate.Type.WIREBONDPAD));
                actions.add(new ActionShowIOView(path));
                actions.add(new ActionShowIOViewByRotation(path));
                actions.add(new ActionShowColView(path));
                actions.add(new ActionEditRDLRuleSets(path));
                actions.add(new DeviceUI.ActionAssignBumpsToPersonalities(path));
                actions.add(new ActionPlaceIOCell(path));
                DeviceTemplate parent = device.getParent();
                if (parent != null && parent.getType() == DeviceTemplate.Type.PACKAGE) {
                    actions.add(new ExportDiePackageMapping(path));
                    actions.add(new ImportDiePackageMapping(path));
                }
            }
            if (path != null && devType == DeviceTemplate.Type.PACKAGEDDIE) {
                actions.add(new ExportDieBgaTxt(path));
            }
            if (path != null && devType == DeviceTemplate.Type.INTERPOSER) {
                actions.add(new ActionExportDef(path));
                actions.add(new DeviceUI.ActionSelectPadsOfType(path, PinTemplate.Type.BUMPPAD));
                actions.add(new DeviceUI.ActionSelectPadsOfType(path, PinTemplate.Type.BALLPAD));
                actions.add(new DeviceUI.ActionAssignBumpsToPersonalities(path));
            }
            if (path != null && device.isPackage()) {
                actions.add(new ExportDieBgaTxt(path));
                actions.add(new DeviceUI.ActionSelectPadsOfType(path, PinTemplate.Type.BALLPAD));
                actions.add(new DeviceUI.ActionAssignBallsToPersonalities(path));
                actions.add(new ActionExportBallMap(path));
                actions.add(new ImportPinProperties(path));
            }
            if (path != null && device.isBoard()) {
                actions.add(new DeviceUI.ActionAssignPinsToPersonalities(path));
            }
            if (path != null && path.size() > 1) {
                actions.add(new ActionLinearNetMap(path));
            }
            if (path != null) {
                actions.add(new ActionExportVerilog(path));
                actions.add(EditDeviceUI.getAction(path));
                actions.add(NetListEditorUI.getAction(path));
            }
            if (path != null) {
                actions.add(new ActionImportCSVPersonalities(path));
                actions.add(new ActionExportCSVPersonalities(path));
            }
            if (path != null) {
                actions.add(new ActionExportCSVDeviceList(path));
                actions.add(new ActionImportCSVDeviceList(path));
                actions.add(TermListImportUI.getAction(device));
                actions.add(TermListExportUI.getAction(device));
                actions.add(TermMapCsvImportUI.getAction(device));
                actions.add(TermMapCsvExportUI.getAction(device));
            }
            if (path != null) {
                actions.add(CSVPinListUI.getPinInAction(path));
                actions.add(CSVPinListUI.getPinOutAction(path));
            }
            if (path != null) {
                actions.add(PowerConfigUI.getAction(path));
            }
            if (path != null) {
                actions.add(BumpLocUI.getAction(path));
            }
            actions.add(new ActionExportDeviceToOio(device));
            if (path != null && device.getIsSubstrate(true)) {
                actions.add(new ActionImportCSVNetList(path, false));
                actions.add(new ActionImportCSVNetList(path, true));
                actions.add(new ActionExportDevicePinMapping(path));
                actions.add(new ActionExportCSVNetList(path));
                actions.add(new ActionExportCSVNetMatrix(path));
                actions.add(new ActionImportTechnologyLibrary(path));
                actions.add(new ActionExportTechnologyLibrary(path));
                actions.add(new ActionExportNetsText(path));
                actions.add(new ActionExportSessionFile(path));
                if (!path.getParent().isEmpty()) {
                    actions.add(new ActionManageMountingMethod(path));
                }
                actions.add(new ActionEditPadStack(path));
                if (OrbitIO.isPrototypeMode()) {
                    actions.add(new ConstructivePlacement(path));
                }
            }
            actions.add(new ActionSelectPinsNotConnectedToDeviceT(devT));
            if (path != null) {
                actions.add(new ShowConnections(path, device));
                actions.add(new ActionSelectPinsNotConnectedToSubstrate(path));
                actions.add(new ActionSelectPinsInArea(path));
            }
            if (path != null && device.getIsSubstrate()) {
                actions.add(new ActionSelectPinsNotConnectedToOtherSubstrate(path));
            }
            actions.add(new ActionSelectAllPins(path));
            actions.add(DeviceUI.getDimensionActions(device));
            if (devT != null) {
                HierInst hdt = HierInst.create((DevicePath)path, (DbObject)devT);
                deviceGroup.addActions((Iterator<Action>)OrbitGuiObjectActionRegistry.this.getActions((Object)hdt, constraints));
            }
            if ((substrate = device.getSubstrate()) != null) {
                HierInst hs = HierInst.create((DevicePath)path, (DbObject)substrate);
                actions.add(new AActionGroup("Substrate", (Iterator<Action>)OrbitGuiObjectActionRegistry.this.getActions((Object)hs, constraints)));
            }
        }

        private void addDeviceTemplateActions(DeviceTemplate dt, DevicePath path, List<Action> actions, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            boolean extras = DbExplorerPanel.enableExtendedUI();
            if (!(dt instanceof Design)) {
                actions.add(new ActionExportTemplateToOio(dt));
                actions.add(new ActionCopyTemplate(dt));
                actions.add(new ActionRenameDeviceTemplate(dt));
                actions.add(SubstrateFromFootprintDeviceUI.createAction(OrbitIO.getMainWindow(), dt));
                actions.add(MatrixRenamePins.createAction(dt));
                actions.add(new ActionUnassignNets(path));
            }
            if (path != null) {
                actions.add(new ActionExportCSVDeviceList(path));
                actions.add(new ActionImportCSVDeviceList(path));
                actions.add(RenamePinGroupUI.createAction(path));
                actions.add(RenameDeviceGroupUI.createAction(path));
                actions.add(EditDeviceUI.getAction(path));
                actions.add(NetListEditorUI.getAction(path));
                actions.add(TermListImportUI.getAction(dt));
                actions.add(TermListExportUI.getAction(dt));
                actions.add(TermMapCsvImportUI.getAction(dt));
                actions.add(TermMapCsvExportUI.getAction(dt));
            } else {
                actions.add(RenamePinGroupUI.createAction(new DevicePath(dt)));
            }
            actions.add(new ActionRemoveNets(dt));
            if (dt.getType() == DeviceTemplate.Type.DIE) {
                actions.add(DieExtentsUI.getAction(dt));
            }
            if (extras) {
                actions.add(new ActionReindexDeviceTemplate(dt));
            }
        }

        private void addSubstrateActions(Substrate s, List<Action> actions, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            actions.add(new ActionRenameSubstrate(s));
            actions.add(new ActionEditGrids(s));
            actions.add(new DeleteSubstrate(s));
            actions.add(EditLayerUI.getAction(s));
        }

        private void addPinTemplateActions(PinTemplate dtp, DevicePath path, List<Action> actions, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            AAppView view = OrbitGuiObjectActionRegistry.this.mWs.getCurrentView();
            if (OrbitGuiWS.extendedUIEnabled()) {
                actions.add(new ActionEditPin(path, dtp));
            }
            if (path != null) {
                actions.add(new ActionRenamePin(dtp, Optional.of(path)));
                actions.add(new ActionSelectNetOfPort(path, dtp));
                ActionAddPinToSelectPersonality addToPersonalityAction = new ActionAddPinToSelectPersonality(path, dtp);
                if (addToPersonalityAction.getActionCount() > 0) {
                    actions.add(addToPersonalityAction);
                }
                actions.add(new ActionEditPadStackOfPin(path, dtp));
                actions.add(new ActionOnPlaceableItem(path, (DbObject)dtp, ActionOnPlaceableItem.ACTION.DELETE_OBJ, false, "", "Delete Pin"));
                actions.add(new ActionOnPlaceableItem(path, (DbObject)dtp, ActionOnPlaceableItem.ACTION.MOVE, "Move Pin..."));
                actions.add(new ActionOnPlaceableItem(path, (DbObject)dtp, ActionOnPlaceableItem.ACTION.COPY, "Copy Pin..."));
                actions.add(new PinUI.ActionShowMePorts(path, dtp));
                actions.add(new ActionZoomToHierPin(view, path, dtp));
            }
            HierInst hn = new HierInst(path, (DbObject)dtp.getNet());
            actions.add(new AActionGroup("Net", (Iterator<Action>)OrbitGuiObjectActionRegistry.this.getActions((Object)hn, constraints)));
        }

        private void addPortTemplateActions(PortTemplate port, DevicePath path, List<Action> actions, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            AAppView view = OrbitGuiObjectActionRegistry.this.mWs.getCurrentView();
            actions.add(new PinUI.ActionShowMePort(path, port));
            actions.add(new ActionZoomToHierPort(view, path, port));
            HierInst hierPinT = new HierInst(path, (DbObject)port.getPinTemplate());
            actions.add(new AActionGroup("Pin", (Iterator<Action>)OrbitGuiObjectActionRegistry.this.getActions((Object)hierPinT, constraints)));
        }

        private void addWireActions(Wire wire, DevicePath path, List<Action> actions, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            if (path != null) {
                actions.add(new ActionSelectNetOfWire(path, wire));
            }
            actions.add(new ActionDeleteWire(wire));
            HierInst hn = new HierInst(path, (DbObject)wire.getNet());
            actions.add(new AActionGroup("Net", (Iterator<Action>)OrbitGuiObjectActionRegistry.this.getActions((Object)hn, constraints)));
            Db db = wire.getDb();
            Selection sel = new Selection(db);
            sel.add(path, (DbObject)wire);
            actions.addAll(AUtil.arrayList(WireUI.ActionFactorySelection.getActions(sel, constraints)));
        }

        private void addNetActions(Net n, DevicePath path, List<Action> actions, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            if (n.isUnused()) {
                return;
            }
            actions.add(NetGraphPanel.createShowNetGraphAction(OrbitIO.getMainWindow(), path, n));
            actions.add(new NetUI.RenameNetUI.ActionRenameNet(n));
            Db db = n.getDb();
            Selection sel = new Selection(db);
            sel.add(path, (DbObject)n);
            for (Action a : AUtil.arrayList(NetUI.ActionFactorySelection.getActions(sel, constraints))) {
                actions.add(a);
            }
        }

        private void addNetMapActions(NetMap nm, List<Action> actions) {
            if (nm.getParentNet() != null) {
                actions.add(NetGraphPanel.createShowNetGraphAction(OrbitIO.getMainWindow(), new DevicePath(nm.getParentNet().getDeviceTemplate()), nm.getParentNet()));
            } else if (nm.getChildNet() != null) {
                actions.add(NetGraphPanel.createShowNetGraphAction(OrbitIO.getMainWindow(), new DevicePath(nm.getDevice()), nm.getChildNet()));
            }
        }

        private void addConnectionAction(Connection c, DevicePath path, List<Action> actions, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            Db db = c.getDb();
            Selection sel = new Selection(db);
            sel.add(path, (DbObject)c);
            for (Object obj : AUtil.arrayList(ConnectionUI.ViewActionFactory.getActions(db, sel, null))) {
                actions.add((Action)obj);
            }
        }

        private void addLayerAcion(Layer l, List<Action> actions) {
            actions.add(new LayerUI.ActionSetLayerColor(l));
            actions.add(new LayerUI.ActionEditLayer(l));
            actions.add(EditLayerUI.getAction(l.getSubstrate()));
        }

        private void addTermAcion(Term term, DevicePath path, List<Action> actions, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            Action a = NetGraphPanel.createShowNetGraphAction(OrbitIO.getMainWindow(), path, term.getNet(), true, false);
            a.putValue("Name", "Graph Term...");
            actions.add(a);
            if (term.getNet() != null) {
                HierInst hn = new HierInst(path, (DbObject)term.getNet());
                actions.add(new AActionGroup("Net", (Iterator<Action>)OrbitGuiObjectActionRegistry.this.getActions((Object)hn, constraints)));
            }
        }

        @Override
        public Iterator<Action> getActions(HierInst<?> inst, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            Design design;
            LinkedList<Action> actions = new LinkedList<Action>();
            AAppView view = OrbitGuiObjectActionRegistry.this.mWs.getCurrentView();
            DbObject dbo = inst.getDbObject();
            Db db = dbo.getDb();
            DevicePath path = inst.getPath();
            actions.add(new ActionShowDetails(null, inst, view));
            if (db == null) {
                return actions.iterator();
            }
            if (dbo instanceof PinInstance) {
                dbo = ((PinInstance)dbo).getPinTemplate();
            }
            if ((design = Design.getDesign((Db)db)) != null && dbo != design && dbo.getDbClass().hasKeyFields()) {
                ActionSelectDbObject a = new ActionSelectDbObject(dbo, path);
                actions.add(a);
            }
            if (dbo == design) {
                actions.add(new ActionImportVerilog(db));
                actions.add(new ActionShowDbStruct(db));
                actions.add(new NodeIcons.ActionEnableShowDeviceDirection(design));
                actions.add(new NodeIcons.ActionEnableShowBumpDirection(design));
                actions.add(new NodeIcons.ActionEnableShowContactAttribute(design));
                actions.add(new ActionImportCSVNetMapping());
                actions.add(new ActionExportCSVNetMapping());
                actions.add(new ActionOpenContainingFolder((DeviceTemplate)design));
            }
            if (dbo instanceof Device) {
                this.addDeviceActions((Device)dbo, path, actions, constraints);
            } else if (dbo instanceof DeviceTemplate) {
                this.addDeviceTemplateActions((DeviceTemplate)dbo, path, actions, constraints);
            } else if (dbo instanceof Substrate) {
                this.addSubstrateActions((Substrate)dbo, actions, constraints);
            } else if (dbo instanceof PinTemplate) {
                this.addPinTemplateActions((PinTemplate)dbo, path, actions, constraints);
            } else if (dbo instanceof PortTemplate) {
                this.addPortTemplateActions((PortTemplate)dbo, path, actions, constraints);
            } else if (dbo instanceof Wire) {
                this.addWireActions((Wire)dbo, path, actions, constraints);
            } else if (dbo instanceof Net) {
                this.addNetActions((Net)dbo, path, actions, constraints);
            } else if (dbo instanceof NetMap) {
                this.addNetMapActions((NetMap)dbo, actions);
            } else if (dbo instanceof Connection) {
                this.addConnectionAction((Connection)dbo, path, actions, constraints);
            } else if (dbo instanceof Layer) {
                this.addLayerAcion((Layer)dbo, actions);
            } else if (dbo instanceof Term) {
                this.addTermAcion((Term)dbo, path, actions, constraints);
            }
            return actions.iterator();
        }
    };
    protected ObjectActionRegistry.ActionFactory<DbObject> mDbObjFactory = (dbo, constraints) -> this.mHierInstFactory.getActions(new HierInst(null, dbo), constraints);

    public OrbitGuiObjectActionRegistry(OrbitGuiWS ws) {
        this.mWs = ws;
        this.registerActionFactory(HierInst.class, this.mHierInstFactory);
        this.registerActionFactory(HierInst.class, SetPinNetUI.ActionFactory);
        this.registerActionFactory(DbObject.class, this.mDbObjFactory);
        this.registerActionFactory(HierInst.class, PatternPlacementUI.ActionFactory);
        this.registerActionFactory(HierInst.class, DiffPairUI.ActionFactory);
        this.registerActionFactory(HierInst.class, BundleUI.ActionFactory);
        this.registerActionFactory(Selection.class, InterfaceUI.ActionFactorySelection);
        this.registerActionFactory(Selection.class, FloorplanUI.ActionFactorySelection);
        this.registerActionFactory(Selection.class, BundleUI.ActionFactorySelection);
        this.registerActionFactory(Selection.class, DeviceUI.ActionFactorySelection);
        this.registerActionFactory(Selection.class, NetUI.ActionFactorySelection);
        this.registerActionFactory(HierInst.class, PersonalityActions.HierInstActionFactory);
        this.registerActionFactory(DbObject.class, PersonalityActions.DbObjectActionFactory);
    }

    public static class ImportDiePackageMapping
    extends AbstractAction {
        public static final String CREATE_PARENT_NETS = "CreateParentNets";
        protected DevicePath mDiePath;

        public ImportDiePackageMapping(DevicePath diePath) {
            super("Import Package to Die Net Mapping...");
            this.mDiePath = diePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean createParentNets;
            AFileChooser fc = new AFileChooser();
            JPanel options = new JPanel();
            GridBagManager l = GridBagManager.layout((Container)options);
            JCheckBox cbCreateParentNets = (JCheckBox)l.add((Component)new JCheckBox("Create parent nets"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            cbCreateParentNets.setToolTipText("<html>If selected, parent Nets will be created during read. If not selected, errors will be logged if parent nets are referenced that don't already exist.</html>");
            l.addFillY();
            fc.setAccessory((JComponent)options);
            Settings settings = Settings.getSettings((String)this.getClass().getName());
            cbCreateParentNets.setSelected((Boolean)settings.getSetting(CREATE_PARENT_NETS, (Object)true));
            AFileFilter filter = AFileFilter.CSV;
            fc.setFileFilter((FileFilter)filter);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            String path = f.getPath();
            if (fc.getFileFilter() == filter && !f.exists() && !f.getName().contains(".") && (f = new File(path + ".csv")).exists()) {
                path = f.getPath();
            }
            if ((createParentNets = cbCreateParentNets.isSelected()) != (Boolean)settings.getSetting(CREATE_PARENT_NETS, (Object)true)) {
                settings.putSetting(CREATE_PARENT_NETS, (Object)createParentNets);
                settings.save();
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.export.NetMapImport.setAutoCreateParentNets(%b)", (Object[])new Object[]{createParentNets});
                Cp.exec((String)"com.sigrity.orbit.export.NetMapImport.importCsv(%s)", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
            }
        }
    }

    public static class ExportDiePackageMapping
    extends AbstractAction {
        protected DevicePath mDiePath;

        public ExportDiePackageMapping(DevicePath diePath) {
            super("Export Package to Die Net Mapping...");
            this.mDiePath = diePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = AFileFilter.CSV;
            fc.setFileFilter((FileFilter)filter);
            fc.setDialogTitle("Export Package to Die Net Mapping");
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            String path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = String.format("%s.csv", path);
            }
            Cp.exec((String)"exportDiePackageMapping(\"%s\", %s)", (Object[])new Object[]{this.mDiePath, Cp.getFileAsArgument((String)path)});
        }
    }

    protected class ShowConnections
    extends AbstractAction {
        protected final Device mDevice;
        protected final DevicePath mPath;

        public ShowConnections(DevicePath path, Device d) {
            super("Show Connections", OrbitIcons.SHOW_RATS);
            String tooltip = new HConnEngine.ShowOnOrBetweenDevices().getDescription();
            this.putValue("ShortDescription", tooltip);
            this.mPath = path;
            this.mDevice = d;
            assert (path.getDevice() == d);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Show Connections From One Device");){
                Cp.exec((String)"_show = new com.sigrity.acl.edaMgrs.HConnEngine.ShowOnOrBetweenDevices();", (Object[])new Object[0]);
                Cp.exec((String)"_show.addDevicePath(\"%s\");", (Object[])new Object[]{this.mPath.escapedString()});
                Cp.exec((String)"_show.showOn();", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    protected class ActionReplaceDevice
    extends AbstractAction {
        protected Device mDevice;

        public ActionReplaceDevice(Device d) {
            super("Replace Device with...");
            this.mDevice = d;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReplaceDeviceUI.showMe(OrbitIO.getMainWindow(), this.mDevice, null);
        }
    }

    protected class ActionDeleteDeviceContents
    extends AbstractAction {
        protected Device mDevice;

        public ActionDeleteDeviceContents(Device d) {
            super("Delete Device Contents");
            this.mDevice = d;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                boolean deleted = (Boolean)Cp.exec((String)"DeviceTemplate.get(curDb(), \"%s\", \"%s\").deleteContentsFromDb()", (Object[])new Object[]{this.mDevice.getSubstrate().getName(), this.mDevice.getTemplate().getName()});
                if (deleted) {
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            }
        }
    }

    protected static class ActionEditRDLRuleSets
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionEditRDLRuleSets(DevicePath path) {
            super("Manage RDL Rule Sets");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Substrate s = this.mDevicePath.getSubstrate();
            RDLRuleSetDlg rsd = new RDLRuleSetDlg(OrbitIO.getMainWindow());
            rsd.showMe(s.getKeyStr(), RouterRuleSetDlg.DialogMode.EditAnyRule, null);
        }
    }

    protected static class ActionLinearNetMap
    extends AbstractAction {
        protected final DevicePath mDevicePath;

        public ActionLinearNetMap(DevicePath path) {
            super("Connect to Parent Nets");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetMapBulkCreateUI.bulkMap(OrbitIO.getMainWindow(), this.mDevicePath.getDevice());
        }
    }

    protected static class ActionShowColView
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionShowColView(DevicePath path) {
            super("Column View");
            this.mDevicePath = path;
            Icon icon = DbExplorerPanel.getIconForTemplateType(DeviceTemplate.Type.COVER);
            ATransformableIcon noci = new ATransformableIcon();
            noci.setImageIcon((ImageIcon)icon);
            noci.setIconRot(90.0f);
            this.putValue("SmallIcon", noci);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColViewPanel.show(this.mDevicePath);
        }
    }

    protected static class ActionPlaceIOCell
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionPlaceIOCell(DevicePath path) {
            super("Place IO Cell");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IOCellPlacerUI.showMe(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), this.mDevicePath.escapedString());
        }
    }

    protected static class ActionShowIOViewByRotation
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionShowIOViewByRotation(DevicePath path) {
            super("IOView by Device Angle");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.iov.IOViewDlg.create(OrbitIO.getMainWindow(), OrbitIO.getCurView(), \"%s\", true);", (Object[])new Object[]{this.mDevicePath});
            }
        }
    }

    protected static class ActionShowIOView
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionShowIOView(DevicePath path) {
            super("IOView by Device Location");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.iov.IOViewDlg.create(OrbitIO.getMainWindow(), OrbitIO.getCurView(), \"%s\");", (Object[])new Object[]{this.mDevicePath});
            }
        }
    }

    protected static class ActionShowMe
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionShowMe(DevicePath path) {
            super("Show Me", OrbitIcons.SHOW_ME);
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowMeTheWay.addDevicePath(this.mDevicePath);
        }
    }

    protected static class ActionImportCCT
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionImportCCT(DevicePath path) {
            super("Import CCT File...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportCCTUI.showMe(this.mDevicePath.toString());
        }
    }

    protected static class ActionExportCCT
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportCCT(DevicePath path) {
            super("Export CCT File...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportCCTUI.showMe(this.mDevicePath.toString());
        }
    }

    protected static class ActionFlipInPlace
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionFlipInPlace(DevicePath path) {
            super("Flip in Place");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"UserCommands.flipDeviceInPlace(\"%s\");", (Object[])new Object[]{this.mDevicePath.toString()});
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    protected static class ActionExportAIF
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportAIF(DevicePath path) {
            super("Export AIF...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportAIFUI.showMe(this.mDevicePath.toString());
        }
    }

    @Deprecated
    public static class ActionEditLayersDlg
    extends AbstractAction {
        protected Substrate mSubstrate;

        public ActionEditLayersDlg(Substrate s) {
            super("Edit Layers...");
            this.mSubstrate = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayerUI.createDlg(OrbitIO.getMainWindow(), OrbitApp.getCurDb(), this.mSubstrate.getName()).setVisible(true);
        }
    }

    public static class DeleteSubstrate
    extends AbstractAction {
        protected Substrate mSubstrate;

        public DeleteSubstrate(Substrate s) {
            super("Delete");
            this.mSubstrate = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int devTCount = this.mSubstrate.getDeviceTemplateCount();
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                if (devTCount > 0) {
                    long devCount = this.mSubstrate.getDeviceCount();
                    String msg = String.format("Substrate '%s' currently defines %d DeviceTemplates and %d Device instances. Are you sure you want to delete them all?", this.mSubstrate.getName(), devTCount, devCount);
                    int res = JOptionPane.showConfirmDialog(OrbitIO.getMainWindow(), msg, "Confirm Delete", 0);
                    if (res != 0) {
                        return;
                    }
                }
                Cp.exec((String)"curDb().getByKeyStr(Substrate.class, \"%s\").deleteFromDb(true)", (Object[])new Object[]{this.mSubstrate.getKeyStr()});
            }
        }
    }

    public static class DeleteImmaterial
    extends AbstractAction {
        protected Substrate mSubstrate;

        public DeleteImmaterial(Substrate s) {
            super("Delete");
            this.mSubstrate = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.acl.db.std.Substrate.removeImmaterial(OrbitApp.getCurDb(), \"%s\");", (Object[])new Object[]{this.mSubstrate.getName()});
            }
        }
    }

    public static class ActionEditGrids
    extends AbstractAction {
        protected Substrate mSubstrate;

        public ActionEditGrids(Substrate s) {
            super("Edit Grids...");
            this.mSubstrate = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GridChooser.editGrids(OrbitIO.getMainWindow(), this.mSubstrate);
        }
    }

    protected static class ActionRenameSubstrate
    extends AbstractAction {
        protected Substrate mSubstrate;

        public ActionRenameSubstrate(Substrate s) {
            super("Rename Substrate...");
            this.mSubstrate = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameSubstrateUI.rename(OrbitIO.getMainWindow(), this.mSubstrate);
        }
    }

    protected static class ActionReindexDeviceTemplate
    extends AbstractAction {
        protected DeviceTemplate mDeviceTemplate;

        public ActionReindexDeviceTemplate(DeviceTemplate dt) {
            super("Reindex Device Template");
            this.mDeviceTemplate = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"DeviceTemplateCmd.reindex(\"%s\")", (Object[])new Object[]{this.mDeviceTemplate.getKeyStr()});
            }
        }
    }

    protected static class ActionRenameDeviceTemplate
    extends AbstractAction {
        protected DeviceTemplate mDeviceTemplate;

        public ActionRenameDeviceTemplate(DeviceTemplate dt) {
            super("Rename Device Template...");
            this.mDeviceTemplate = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameDeviceTemplateUI.rename(OrbitIO.getMainWindow(), this.mDeviceTemplate);
        }
    }

    public static class ActionAddPinToPersonality
    extends AbstractAction {
        protected DevicePath mPath;
        protected PinTemplate mPort;
        protected DevicePath mPortPath;
        protected Personality mPersonality;

        public ActionAddPinToPersonality(PinTemplate port, DevicePath portPath, HierInst<Personality> hierPersonality) {
            super(((DevicePath)hierPersonality.first).toString() + ":" + ((Personality)hierPersonality.second).getName());
            AColorIcon icon = new AColorIcon(16, 16, ((Personality)hierPersonality.second).getColor());
            PinInstance pi = portPath.getLast().getPin(port);
            Personality p = pi.getPersonality();
            if (p == hierPersonality.second) {
                icon = new AColorIcon(16, ((Personality)hierPersonality.second).getColor());
            }
            this.putValue("SmallIcon", icon);
            this.mPath = (DevicePath)hierPersonality.first;
            this.mPort = port;
            this.mPortPath = portPath;
            this.mPersonality = (Personality)hierPersonality.second;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PinInstance devPort = this.mPortPath.getLast().getPin(this.mPort);
            if (devPort == null) {
                ALog.logError((String)"Error looking up PinInstance '%s' on Device '%s'", (Object[])new Object[]{this.mPort.getKeyStr(), this.mPath.toString()});
                return;
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.addPinToPersonality(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{devPort.getKeyStr(), this.mPersonality.getKeyStr()});
            }
        }
    }

    public static class ActionAddPinToSelectPersonality
    extends AActionGroup {
        public ActionAddPinToSelectPersonality(DevicePath path, PinTemplate port) {
            super("Assign to Personality");
            Stream personalities = Personality.getPersonalities((DevicePath)path, (Personality.Type)Personality.Type.PORT);
            this.addActions(personalities.map(hp -> new ActionAddPinToPersonality(port, path, (HierInst<Personality>)hp)));
        }
    }

    protected static class ActionUnassignNets
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionUnassignNets(DevicePath path) {
            super("Unassign Nets");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.cmd.DeviceTemplateCmd.unassignNets(curDb(), \"%s\")", (Object[])new Object[]{this.mDevicePath.toString()});
            }
        }
    }

    protected static class ActionRemoveNets
    extends AbstractAction {
        protected DeviceTemplate mDeviceTemplate;

        public ActionRemoveNets(DeviceTemplate dt) {
            super("Remove Nets...");
            this.mDeviceTemplate = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RemoveNetsUI.showDialog(OrbitIO.getMainWindow(), this.mDeviceTemplate);
        }
    }

    protected static class ActionPeripheralIOCellManagement
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionPeripheralIOCellManagement(DevicePath path) {
            super("Peripheral IO Cell Management...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PeripheralIOUI.showMe(OrbitIO.getMainWindow(), this.mDevicePath.toString());
        }
    }

    protected static class ActionExportSessionFile
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportSessionFile(DevicePath devPath) {
            super("Export Session File...");
            this.putValue("ShortDescription", "Specctra Session File for CCT");
            this.mDevicePath = devPath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = new AFileFilter("ses", "Specctra Session File");
            fc.setFileFilter((FileFilter)filter);
            fc.setDialogTitle("Export Session File");
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            String filePath = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                filePath = String.format("%s.ses", filePath);
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Boolean b = (Boolean)Cp.exec((String)"CCTFileCommands.writeSession(curDb(), \"%s\", %s)", (Object[])new Object[]{this.mDevicePath.toString(), Cp.getFileAsArgument((String)filePath)});
                if (b != null && b.booleanValue()) {
                    ALog.logInfo((String)"Session file written to '%s'.", (Object[])new Object[]{filePath});
                }
            }
        }
    }

    protected static class ActionImportCSVDeviceList
    extends AbstractAction {
        private static final String TITLE = "Import CSV Devices...";
        protected DevicePath mDevicePath;

        public ActionImportCSVDeviceList(DevicePath path) {
            super(TITLE);
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeviceCSVIn.showUI(this.mDevicePath);
        }
    }

    protected static class ActionExportCSVDeviceList
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportCSVDeviceList(DevicePath path) {
            super("Export CSV Devices...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeviceCSVOut.showUI(this.mDevicePath);
        }
    }

    protected static class ActionExportCSVPersonalities
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportCSVPersonalities(DevicePath path) {
            super("Export CSV Personalities...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVPersonalityOutDlg.showMe(this.mDevicePath.toString());
        }
    }

    protected static class ActionImportCSVPersonalities
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionImportCSVPersonalities(DevicePath path) {
            super("Import CSV Personalities...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVPersonalityInDlg.showMe(this.mDevicePath.toString());
        }
    }

    protected static class ActionExportCSVNetMatrix
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportCSVNetMatrix(DevicePath path) {
            super("Export CSV Net Matrix...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVNetMarixOutDlg.showMe(this.mDevicePath);
        }
    }

    protected static class ActionExportCSVNetList
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportCSVNetList(DevicePath path) {
            super("Export CSV Netlist...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVNetlistOutDlg.showMe(this.mDevicePath.toString());
        }
    }

    protected static class ActionExportCSVNetMapping
    extends AbstractAction {
        public ActionExportCSVNetMapping() {
            super("Export CSV Net Mapping...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetMappingExportUI.showMe();
        }
    }

    protected static class ActionImportCSVNetMapping
    extends AbstractAction {
        public ActionImportCSVNetMapping() {
            super("Import CSV Net Mapping...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetMappingImportUI.showMe();
        }
    }

    protected static class ActionExportDevicePinMapping
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportDevicePinMapping(DevicePath path) {
            super("Export Device Pin Mapping...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePinMappingDlg.showMe(this.mDevicePath.toString());
        }
    }

    protected static class ActionEditPadStack
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionEditPadStack(DevicePath path) {
            super("Edit Padstacks...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PadStackDlg.createDialog(OrbitIO.getMainWindow(), this.mDevicePath);
        }
    }

    protected static class ConstructivePlacement
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ConstructivePlacement(DevicePath path) {
            super("Place Contents...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConstructPlaceDlg.showMe((Frame)OrbitIO.getMainWindow(), this.mDevicePath, null);
        }
    }

    protected static class ActionManageMountingMethod
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionManageMountingMethod(DevicePath path) {
            super("Manage Contact Pads...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MountingMgmtDlg.show(this.mDevicePath);
        }
    }

    protected static class ActionImportCSVNetList
    extends AbstractAction {
        protected DevicePath mDevicePath;
        protected boolean mNetsOnly;

        public ActionImportCSVNetList(DevicePath path, boolean netsOnly) {
            super(netsOnly ? "Import Net-Interface Map..." : "Import CSV Netlist...");
            this.mDevicePath = path;
            this.mNetsOnly = netsOnly;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVNetlistInDlg.showMe(this.mDevicePath.toString(), this.mNetsOnly);
        }
    }

    protected static class ActionExportTechnologyLibrary
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportTechnologyLibrary(DevicePath path) {
            super("Export Technology Library...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = AFileFilter.XML;
            fc.setFileFilter((FileFilter)filter);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            String path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = String.format("%s.xml", path);
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.iov.PinDefinition.setSubstrateName(\"%s\");", (Object[])new Object[]{this.mDevicePath.getSubstrate().getName()});
                Cp.exec((String)"com.sigrity.orbit.iov.PinDefinition.writeXML(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
            }
        }
    }

    protected static class ActionExportNetsText
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportNetsText(DevicePath path) {
            super("Export Net-Interface Map...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportNetsText.showMe(this.mDevicePath.escapedString());
        }
    }

    protected static class ActionImportTechnologyLibrary
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionImportTechnologyLibrary(DevicePath path) {
            super("Import Technology Library...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = AFileFilter.XML;
            fc.setFileFilter((FileFilter)filter);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            String path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = String.format("%s.xml", path);
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.iov.PinDefinition.setSubstrateName(\"%s\");", (Object[])new Object[]{this.mDevicePath.getSubstrate().getName()});
                Cp.exec((String)"com.sigrity.orbit.iov.PinDefinition.readXML(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
            }
        }
    }

    protected static class ActionExportVerilog
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportVerilog(DevicePath path) {
            super("Export Verilog...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportVerilogUI2.show(OrbitIO.getMainWindow(), this.mDevicePath);
        }
    }

    protected static class ActionExportBallMap
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportBallMap(DevicePath path) {
            super("Export Ball Map...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportSymbolSpreadsheet.showFor(this.mDevicePath.toString());
        }
    }

    protected static class ActionAutoBundleDevice
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionAutoBundleDevice(DevicePath path) {
            super("Auto-Bundle to Parent...");
            this.mDevicePath = path;
            if (path == null || path.size() <= 1) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoBundleDlg.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), this.mDevicePath.escapedString());
        }
    }

    protected static class ImportPinProperties
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ImportPinProperties(DevicePath path) {
            super("Import Pin Properties");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = AFileFilter.CSV;
            fc.setFileFilter((FileFilter)filter);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = (String)path + ".csv";
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"UserCommands.importPinProperties(\"%s\", %s);", (Object[])new Object[]{this.mDevicePath.toString(), Cp.getFileAsArgument((String)path)});
            }
        }
    }

    protected static class ActionImportVerilog
    extends AbstractAction {
        private Db mDb;

        public ActionImportVerilog(Db db) {
            super("Import Verilog...");
            this.mDb = db;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VerilogUI.showDialog(OrbitIO.getMainWindow(), this.mDb);
        }
    }

    protected static class ExportDieBgaTxt
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ExportDieBgaTxt(DevicePath path) {
            super("Export Text...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgaDieTxtIO.showExportUI(this.mDevicePath.getDb(), this.mDevicePath.toString());
        }
    }

    protected static class ActionExportDef
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportDef(DevicePath path) {
            super("Export DEF...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportDEFUI.showMe(this.mDevicePath);
        }
    }

    protected static class ActionSelectPinsNotConnectedToOtherSubstrate
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionSelectPinsNotConnectedToOtherSubstrate(DevicePath path) {
            super("Select pins not connected to other substrate");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplatePortUI.selectUnmappedPins(\"%s\")", (Object[])new Object[]{this.mDevicePath.toString()});
        }
    }

    protected static class ActionSelectAllPins
    extends AbstractAction {
        protected DevicePath mDevPath;

        public ActionSelectAllPins(DevicePath devPath) {
            super("Select all Pins");
            this.putValue("ShortDescription", "Select this device's pins and pins of descendant devices");
            this.mDevPath = devPath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplatePortUI.selectAllPins(curDb(), \"%s\")", (Object[])new Object[]{this.mDevPath.escapedString()});
            }
        }
    }

    protected static class ActionSelectPinsNotConnectedToSubstrate
    extends AbstractAction {
        protected DevicePath mDevPath;

        public ActionSelectPinsNotConnectedToSubstrate(DevicePath devPath) {
            super("Select pins not connected to substrate");
            this.putValue("ShortDescription", "Select all descendant pins that do not connect to this device's topmost substrate device");
            this.mDevPath = devPath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplatePortUI.selectPinsNotConnectedToSubstrate(curDb(), \"%s\")", (Object[])new Object[]{this.mDevPath.escapedString()});
            }
        }
    }

    protected static class ActionSelectPinsInArea
    extends AbstractAction {
        protected DevicePath mDevicePath;

        protected ActionSelectPinsInArea(DevicePath path) {
            super("Select pins covered by this device");
            this.putValue("ShortDescription", "Select all pins at any level on this device's substrate that overlap the the device bounds");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplatePortUI.selectPinsInArea(curDb(), \"%s\")", (Object[])new Object[]{this.mDevicePath.escapedString()});
            }
        }
    }

    protected static class ActionSelectPinsNotConnectedToDeviceT
    extends AbstractAction {
        protected DeviceTemplate mDevT;

        protected ActionSelectPinsNotConnectedToDeviceT(DeviceTemplate devT) {
            super("Select pins not connected here");
            this.putValue("ShortDescription", "Select all descendant pins that do not connect to this level of hierarchy");
            this.mDevT = devT;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplatePortUI.selectPinsNotConnectedToDeviceT(curDb(), \"%s\")", (Object[])new Object[]{this.mDevT.getKeyStr()});
        }
    }

    protected static class ActionSelectDriversOfDie
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionSelectDriversOfDie(DevicePath path) {
            super("Select Drivers of Die");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"OrbitIO.selectDriversOfDie(\"%s\")", (Object[])new Object[]{this.mDevicePath.toString()});
            }
        }
    }

    protected static class ActionSelectIOPorts
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionSelectIOPorts(DevicePath path) {
            super("Select Most Likely IO Pins");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"OrbitIO.selectMostLikelyIOPorts(\"%s\")", (Object[])new Object[]{this.mDevicePath.toString()});
            }
        }
    }

    protected static class ActionImportDieSpreadsheet
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionImportDieSpreadsheet(DevicePath devicePath) {
            super("Import IOView CSV...");
            this.mDevicePath = devicePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            ImportDieSpreadsheetOtionsPanel options = new ImportDieSpreadsheetOtionsPanel();
            fc.setAccessory((JComponent)options);
            AFileFilter filter = AFileFilter.CSV;
            fc.setFileFilter((FileFilter)filter);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = (String)path + ".csv";
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                String devicePath = this.mDevicePath.toString();
                if (options.getRemoveFirst()) {
                    Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplateUI.deleteIODevices(\"%s\", false);", (Object[])new Object[]{devicePath});
                }
                Cp.exec((String)"OrbitIO.importDieSpreadsheet(%s, \"%s\");", (Object[])new Object[]{Cp.getFileAsArgument((String)path), devicePath});
            }
        }

        protected static class ImportDieSpreadsheetOtionsPanel
        extends JPanel {
            JCheckBox mRemoveFirst;

            public ImportDieSpreadsheetOtionsPanel() {
                this.setBorder(BorderFactory.createTitledBorder("Import IOView .csv options"));
                GridBagManager l = new GridBagManager((Container)this);
                this.mRemoveFirst = new JCheckBox("Remove Current IO Devices First");
                this.mRemoveFirst.setToolTipText("<html>If selected, all devices and their templates will be deleted prior to Reading in the spreadsheet. <br> Templates from .lef will not be deleted</html>");
                l.add((Component)this.mRemoveFirst, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
                l.newline();
                l.addFillY();
            }

            public boolean getRemoveFirst() {
                return this.mRemoveFirst.isSelected();
            }
        }
    }

    protected static class ActionExportDieSpreadsheet
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportDieSpreadsheet(DevicePath devicePath) {
            super("Export Die Spreadsheet...");
            this.mDevicePath = devicePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = AFileFilter.CSV;
            fc.setFileFilter((FileFilter)filter);
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = (String)path + ".csv";
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"OrbitIO.exportDieSpreadsheet(%s, \"%s\");", (Object[])new Object[]{Cp.getFileAsArgument((String)path), this.mDevicePath});
            }
        }
    }

    public static class ActionEditPadStackOfPin
    extends AbstractAction {
        protected DevicePath mDevicePath;
        protected PinTemplate mPinTemplate;

        public ActionEditPadStackOfPin(DevicePath path, PinTemplate pt) {
            super("Edit Padstack...");
            this.mDevicePath = path;
            this.mPinTemplate = pt;
            this.setEnabled(this.mDevicePath != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PadTemplate padT = this.mPinTemplate == null ? null : this.mPinTemplate.getPadTemplate();
            PadStackDlg.createDialog(OrbitIO.getMainWindow(), this.mDevicePath, padT);
        }
    }

    public static class ActionDeleteWire
    extends AbstractAction {
        protected Wire mWire;

        public ActionDeleteWire(Wire wire) {
            super("Delete");
            this.mWire = wire;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Delete Wire");){
                Cp.exec((String)"%s.deleteWire(OrbitIO.getCurDb(), \"%s\")", (Object[])new Object[]{WireCommands.class.getName(), this.mWire.getKeyStr()});
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionSelectNetOfWire
    extends AbstractAction {
        protected final DevicePath mDevicePath;
        protected final Wire mWire;

        public ActionSelectNetOfWire(DevicePath path, Wire wire) {
            super("Select Net of Wire");
            this.mDevicePath = path;
            this.mWire = wire;
            this.setEnabled(this.mDevicePath != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Net n = NetMap.getTopmostNet((Net)this.mWire.getNet(), (DevicePath)this.mDevicePath);
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.ui.NetUI.selectNetToggle(\"%s\")", (Object[])new Object[]{n.getKeyStr()});
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    public static class ActionSelectNetOfPort
    extends AbstractAction {
        protected final DevicePath mDevicePath;
        protected final PinTemplate mPinTemplate;

        public ActionSelectNetOfPort(DevicePath path, PinTemplate dtp) {
            super(String.format("Select Net of %s '%s'", PinUI.getTextForPin(dtp), dtp.getName()));
            this.mDevicePath = path;
            this.mPinTemplate = dtp;
            this.setEnabled(this.mDevicePath != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Net n = NetMap.getTopmostNet((Net)this.mPinTemplate.getNet(), (DevicePath)this.mDevicePath);
                Cp.exec((String)"com.sigrity.orbit.ui.NetUI.selectNetToggle(\"%s\")", (Object[])new Object[]{n.getKeyStr()});
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    protected static class ActionRenamePin
    extends AbstractAction {
        protected PinTemplate mPinTemplate;
        protected Optional<DevicePath> mDevicePath;

        public ActionRenamePin(PinTemplate dtp, Optional<DevicePath> path) {
            super("Rename Pin...");
            this.mDevicePath = path;
            this.mPinTemplate = dtp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenamePinUI.show(OrbitIO.getMainWindow(), this.mPinTemplate, this.mDevicePath);
        }
    }

    protected static class ActionEditPin
    extends AbstractAction {
        protected DevicePath mDevicePath;
        protected PinTemplate mPinTemplate;

        public ActionEditPin(DevicePath path, PinTemplate dtp) {
            super("Edit...");
            this.mDevicePath = path;
            this.mPinTemplate = dtp;
            this.setEnabled(this.mDevicePath != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditPortUI.showMe(OrbitIO.getMainWindow(), this.mDevicePath.toString(), this.mPinTemplate);
        }
    }

    protected static class ActionCopyPath
    extends AbstractAction {
        protected final DevicePath mDevicePath;

        public ActionCopyPath(DevicePath path) {
            super("Copy DevicePath to Clipboard");
            this.mDevicePath = path;
            this.setEnabled(this.mDevicePath != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection newcontents = new StringSelection(this.mDevicePath.escapedString());
            clipboard.setContents(newcontents, null);
        }
    }

    protected static class ActionExportDeviceToOio
    extends AbstractAction {
        protected Device mDevice;

        public ActionExportDeviceToOio(Device d) {
            super("Export OIO...");
            this.mDevice = d;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setFileFilter((FileFilter)OrbitIO.OIO_FILE_FILTER);
            fc.setDialogTitle(String.format("Export Device '%s'", this.mDevice.getName()));
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object path = f.getPath();
            if (fc.getFileFilter() == OrbitIO.OIO_FILE_FILTER && !f.getName().contains(".")) {
                path = (String)path + ".oio";
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Boolean b = (Boolean)Cp.exec((String)"OrbitIOWriter.write(%s, %s, true)", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mDevice), Cp.getFileAsArgument((String)path)});
                if (b != null && b.booleanValue()) {
                    ALog.logInfo((String)"Device '%s' exported to '%s'.", (Object[])new Object[]{this.mDevice.getName(), path});
                }
            }
        }
    }

    protected static class ActionExportTemplateToOio
    extends AbstractAction {
        protected DeviceTemplate mTemplate;

        public ActionExportTemplateToOio(DeviceTemplate dt) {
            super("Export OIO...");
            this.mTemplate = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean b;
            AFileChooser fc = new AFileChooser();
            fc.setFileFilter((FileFilter)OrbitIO.OIO_FILE_FILTER);
            fc.setDialogTitle(String.format("Export DeviceTemplate '%s'", this.mTemplate.getName()));
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object path = f.getPath();
            if (fc.getFileFilter() == OrbitIO.OIO_FILE_FILTER && !f.getName().contains(".")) {
                path = (String)path + ".oio";
            }
            if ((b = (Boolean)Cp.exec((String)"OrbitIOWriter.write(DeviceTemplate.get(curDb(), \"%s\", \"%s\"), %s, true)", (Object[])new Object[]{this.mTemplate.getSubstrate().getName(), this.mTemplate.getName(), Cp.getFileAsArgument((String)path)})) != null && b.booleanValue()) {
                ALog.logInfo((String)"DeviceTemplate '%s' exported to '%s'.", (Object[])new Object[]{this.mTemplate.getName(), path});
            }
        }
    }

    protected static class ActionOpenContainingFolder
    extends AbstractAction {
        protected DeviceTemplate mTemplate;

        public ActionOpenContainingFolder(DeviceTemplate dt) {
            super("Open Containing Folder...");
            this.mTemplate = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = this.mTemplate.getDb();
            File file = db.getFile();
            if (file == null) {
                ALog.logWarn((String)"Unsaved Design, cannot open containing folder...");
                return;
            }
            AFileExplorer.browseFileDirectory((File)file);
        }
    }

    protected static class ActionCopyTemplate
    extends AbstractAction {
        protected DeviceTemplate mTemplate;

        public ActionCopyTemplate(DeviceTemplate dt) {
            super(String.format("Copy Template '%s'...", dt.getName()));
            this.mTemplate = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new DeviceTemplateUI.CopyDlg(OrbitIO.getMainWindow(), this.mTemplate);
        }
    }

    protected static class ActionShowDbStruct
    extends AbstractAction {
        protected Db mDb;

        public ActionShowDbStruct(Db db) {
            super("Explore Database Structure");
            this.mDb = db;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbStructureUI.show(this.mDb, OrbitIO.getMainWindow());
        }
    }

    protected static class ActionSelectDbObject
    extends AbstractAction {
        protected DbObject mDbObj;
        protected DevicePath mPath;

        public ActionSelectDbObject(DbObject dbo, DevicePath path) {
            super("Selected");
            this.mDbObj = dbo;
            this.mPath = path;
            if (dbo instanceof Device && this.mPath != null && this.mPath.getDevice() == dbo) {
                this.mPath = path.getParent();
            }
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Selected"));
            this.putValue("SwingSelectedKey", this.isSelected());
        }

        protected boolean isSelected() {
            Design design = Design.getDesign((Db)this.mDbObj.getDb());
            if (design == null) {
                return false;
            }
            if (this.mPath == null) {
                return design.getCurSelection().contains(this.mDbObj);
            }
            return design.getCurSelection().contains(this.mPath, this.mDbObj);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Design design = Design.getDesign((Db)this.mDbObj.getDb());
            if (design == null) {
                return;
            }
            if (this.mDbObj instanceof NetMap) {
                NetMap netmap = (NetMap)this.mDbObj;
                Net net = netmap.getParentNet();
                String key = net.getKeyStr();
                Cp.exec((String)"com.sigrity.orbit.ui.NetUI.selectNetToggle(\"%s\")", (Object[])new Object[]{key});
            } else {
                String key = this.mDbObj.getKeyStr();
                Cp.exec((String)"com.sigrity.acl.db.Selection.setSelected(\"%s\", \"%s\", %s, %s)", (Object[])new Object[]{this.mDbObj.getDbClass().getName(), key, this.mPath == null ? "null" : String.format("\"%s\"", this.mPath.escapedString()), ABoolean.toString((!this.isSelected() ? 1 : 0) != 0)});
            }
            OrbitIO.refreshViewsOf(design.getDb());
        }
    }

    public static class ActionSelectMultiDbObject<T extends DbObject>
    extends AbstractAction {
        protected List<HierInst<T>> dbos;
        protected Selection selection;
        protected Class<T> type;
        protected boolean allSelected;

        public ActionSelectMultiDbObject(List<HierInst<T>> dbos, Class<T> type) {
            super(String.format("Selected %ss (%d)", type.getSimpleName(), dbos.size()));
            this.dbos = dbos;
            this.type = type;
            this.allSelected = true;
            Selection sel = Design.getSelection((Db)OrbitIO.getCurDb());
            for (HierInst<T> hi : dbos) {
                if (sel == null || sel.contains(hi)) continue;
                this.allSelected = false;
                break;
            }
            this.putValue("SwingSelectedKey", this.allSelected);
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Selected"));
        }

        public ActionSelectMultiDbObject(Selection selection, Class<T> type) {
            super(String.format("Selected %ss (%d)", type.getSimpleName(), selection.getCount(type)));
            this.selection = selection;
            this.type = type;
            Selection curSelection = Design.getSelection((Db)selection.getDb());
            this.allSelected = curSelection.contains(selection, type);
            this.putValue("SwingSelectedKey", this.allSelected);
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Selected"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dbos == null) {
                this.dbos = AUtil.arrayList((Iterator)this.selection.getSelectedHierInsts(this.type));
            }
            if (Net.class.isAssignableFrom(this.type)) {
                for (HierInst<T> hi : this.dbos) {
                    Net net = (Net)hi.getDbObject();
                    String key = net.getKeyStr();
                    Cp.exec((String)"com.sigrity.orbit.ui.NetUI.selectNet(\"%s\", %s)", (Object[])new Object[]{key, ABoolean.toString((!this.allSelected ? 1 : 0) != 0)});
                }
            } else if (Device.class.isAssignableFrom(this.type) || PinTemplate.class.isAssignableFrom(this.type) || PinInstance.class.isAssignableFrom(this.type)) {
                for (HierInst<T> hi : this.dbos) {
                    DbObject dbo = hi.getDbObject();
                    String key = dbo.getKeyStr();
                    DevicePath path = hi.getPath();
                    Cp.exec((String)"com.sigrity.acl.db.Selection.setSelected(\"%s\", \"%s\", %s, %s)", (Object[])new Object[]{dbo.getDbClass().getName(), key, path == null ? "null" : String.format("\"%s\"", path.escapedString()), ABoolean.toString((!this.allSelected ? 1 : 0) != 0)});
                }
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionZoomToHierPort
    extends AbstractAction {
        protected DevicePath mDevicePath;
        protected PortTemplate mPortT;
        protected DesignView2D mView;

        public ActionZoomToHierPort(AAppView view, DevicePath dpath, PortTemplate port) {
            super("Zoom To");
            this.mDevicePath = dpath;
            this.mPortT = port;
            if (!(view instanceof DesignView2D)) {
                this.setEnabled(false);
                return;
            }
            this.mView = (DesignView2D)view;
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Zoom"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mPortT.getDb() == null) {
                return;
            }
            ARect g = this.mPortT.getBounds();
            if (g == null) {
                return;
            }
            ARect bounds = g.transform(this.mDevicePath.getTransform()).getBounds();
            ARect r = new ARect(bounds);
            r.changeSizeBy(0.1);
            this.mView.getCanvas().getXForm().setWorld(r);
            this.mView.getCanvas().refresh();
        }
    }

    public static class ActionZoomToHierPin
    extends AbstractAction {
        protected DevicePath mDevicePath;
        protected PinTemplate mPinT;
        protected DesignView2D mView;

        public ActionZoomToHierPin(AAppView view, DevicePath dpath, PinTemplate pinT) {
            super("Zoom To");
            this.mDevicePath = dpath;
            this.mPinT = pinT;
            if (!(view instanceof DesignView2D)) {
                this.setEnabled(false);
                return;
            }
            this.mView = (DesignView2D)view;
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Zoom"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mPinT.getDb() == null) {
                return;
            }
            HierPin hPin = HierPin.forPinT((DevicePath)this.mDevicePath, (PinTemplate)this.mPinT);
            ARect bounds = hPin.getWorldBounds();
            if (bounds == null) {
                return;
            }
            ARect r = new ARect(bounds);
            r.changeSizeBy(0.1);
            this.mView.getCanvas().getXForm().setWorld(r);
            this.mView.getCanvas().refresh();
        }
    }

    protected static class ActionZoomToDevice
    extends AbstractAction {
        protected final Device mDevice;
        protected DesignView2D mView;

        public ActionZoomToDevice(Device device, AAppView view) {
            super("Zoom To");
            this.mDevice = device;
            if (!(view instanceof DesignView2D)) {
                this.setEnabled(false);
                return;
            }
            boolean hasInstance = this.mDevice.getHierarchicalInstances().hasNext();
            if (!hasInstance) {
                this.setEnabled(false);
                this.putValue("ShortDescription", "This design of device have not placed.");
                return;
            }
            this.mView = (DesignView2D)view;
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Zoom"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ARect bounds = null;
            int i = 0;
            for (DevicePath p : this.mDevice.getHierarchicalInstances()) {
                ++i;
                if (bounds == null) {
                    bounds = p.getBB();
                    continue;
                }
                bounds.expand(p.getBB());
            }
            if (bounds == null) {
                assert (false);
                return;
            }
            bounds.changeSizeBy(0.1);
            this.mView.getCanvas().getXForm().setWorld(bounds);
            this.mView.getCanvas().refresh();
            if (i > 1) {
                ALog.logInfo((String)"Zoomed to %d hierarchical instances of Device '%s'.", (Object[])new Object[]{i, this.mDevice.getName()});
            }
        }
    }

    protected static class ActionZoomToDevicePath
    extends AbstractAction {
        protected DevicePath mDevicePath;
        protected DesignView2D mView;

        public ActionZoomToDevicePath(DevicePath dpath, AAppView view) {
            super("Zoom To");
            this.mDevicePath = dpath;
            if (!this.mDevicePath.getIsAbsolute()) {
                this.mDevicePath = this.mDevicePath.getAFullPath();
            }
            if (!(view instanceof DesignView2D)) {
                this.setEnabled(false);
                return;
            }
            this.mView = (DesignView2D)view;
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Zoom"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ARect bounds = this.mDevicePath.getBB();
            if (bounds == null) {
                assert (false);
                return;
            }
            ARect r = new ARect(bounds);
            r.changeSizeBy(0.1);
            this.mView.getCanvas().getXForm().setWorld(r);
            this.mView.getCanvas().refresh();
        }
    }

    public static class ActionShowDetails
    extends AbstractAction {
        protected Component mUiOwner;
        protected DbObject mDbo;
        protected AAppView mView;
        protected DevicePath mPath;

        public ActionShowDetails(Component uiOwner, DbObject dbo, AAppView view, DevicePath path) {
            super("Details...");
            this.mUiOwner = uiOwner;
            this.mDbo = dbo;
            this.mView = view;
            this.mPath = path;
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Detail"));
        }

        public ActionShowDetails(Component uiOwner, HierInst<?> inst, AAppView view) {
            this(uiOwner, inst.getDbObject(), view, inst.getPath());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbObjectDetailsUI.show(this.mUiOwner, this.mDbo, this.mPath, this.mView);
        }
    }
}

