/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.NestedIterator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.ui.BundleUI;
import com.sigrity.orbit.ui.ConnectionUI;
import com.sigrity.orbit.ui.DeviceUI;
import com.sigrity.orbit.ui.LayerShapeUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.orbit.ui.PinUI;
import com.sigrity.orbit.ui.PortUI;
import com.sigrity.orbit.ui.WireUI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class OrbitGuiShortcutActionRegistry {
    protected HashMap<Class<?>, ActionFactoryList> mFactories = new HashMap();
    protected static OrbitGuiShortcutActionRegistry singleton = null;
    public static final ViewActionFactory mSelectionViewActionFactory = new ViewActionFactory(){

        @Override
        public Iterator<Object> getActions(Db db, Selection selection, APoint2D worldLoc) {
            LinkedList<JMenuItem> actions = new LinkedList<JMenuItem>();
            if (Selection.undoSelectionAvailable((Db)db)) {
                JMenuItem undoRedo = new JMenuItem(new ActionUndo());
                actions.add(undoRedo);
            }
            if (Selection.redoSelectionAvailable((Db)db)) {
                JMenuItem redoRedo = new JMenuItem(new ActionRedo());
                actions.add(redoRedo);
            }
            return actions.iterator();
        }

        @Override
        public String getGroupName() {
            return "Selection Actions";
        }
    };

    public static OrbitGuiShortcutActionRegistry get() {
        if (singleton == null) {
            singleton = new OrbitGuiShortcutActionRegistry();
        }
        return singleton;
    }

    private OrbitGuiShortcutActionRegistry() {
        this.registerActionFactory(Bundle.class, BundleUI.ViewActionFactory);
        this.registerActionFactory(PinInstance.class, PinUI.ViewActionFactory);
        this.registerActionFactory(PortTemplate.class, PortUI.ViewActionFactory);
        this.registerActionFactory(Connection.class, ConnectionUI.ViewActionFactory);
        this.registerActionFactory(Device.class, DeviceUI.ViewActionFactory);
        this.registerActionFactory(LayerShape.class, LayerShapeUI.ViewActionFactory);
        this.registerActionFactory(Personality.class, PersonalityUI.ViewActionFactory);
        this.registerActionFactory(Wire.class, WireUI.ViewActionFactory);
        this.registerActionFactory(Selection.class, mSelectionViewActionFactory);
    }

    public <T> boolean registerActionFactory(Class<T> c, ViewActionFactory a) {
        ActionFactoryList afl = this.mFactories.get(c);
        if (afl == null) {
            afl = new ActionFactoryList();
            this.mFactories.put(c, afl);
        } else if (afl.contains(a)) {
            return false;
        }
        return afl.add(a);
    }

    public IterableIterator<Class<?>> getClasses() {
        ArrayList cs = new ArrayList();
        for (Class<?> c : this.mFactories.keySet()) {
            cs.add(c);
        }
        Collections.sort(cs, (x, y) -> x.getSimpleName().compareTo(y.getSimpleName()));
        return new AIterableItr(cs);
    }

    public IterableIterator<Object> getActions(Class<?> c, final Db db, final Selection selection, final APoint2D worldLoc) {
        if (c == null) {
            return AEmptyItr.create();
        }
        Iterator factories = this.mFactories.get(c).iterator();
        return new NestedIterator<ViewActionFactory, Object>(factories){

            public Iterator<Object> getLowerIterator(ViewActionFactory af) {
                return af.getActions(db, selection, worldLoc);
            }
        };
    }

    public IterableIterator<Object> getActions(final Db db, final Selection selection, final APoint2D worldLoc) {
        return new NestedIterator<Class<?>, Object>(this.mFactories.keySet().iterator()){

            public Iterator<Object> getLowerIterator(Class<?> c) {
                return OrbitGuiShortcutActionRegistry.this.getActions(c, db, selection, worldLoc);
            }
        };
    }

    public IterableIterator<Object> getActions(Db db, Selection selection, APoint2D worldLoc, ViewConstraint vc) {
        if (vc == null) {
            return this.getActions(db, selection, worldLoc);
        }
        ArrayList lst = new ArrayList();
        for (Class<?> c : this.mFactories.keySet()) {
            if (!vc.contains(c)) continue;
            for (Object obj : this.getActions(c, db, selection, worldLoc)) {
                lst.add(obj);
            }
        }
        return new AIterableItr(lst.iterator());
    }

    public String getGroupName(Class<?> c) {
        Iterator factories = this.mFactories.get(c).iterator();
        if (factories.hasNext()) {
            return ((ViewActionFactory)factories.next()).getGroupName();
        }
        return "Actions";
    }

    public static class ActionRedo
    extends AbstractAction {
        public ActionRedo() {
            super("Redo Selection", OrbitIcons.REDO);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"Selection.redo()", (Object[])new Object[0]);
        }
    }

    public static class ActionUndo
    extends AbstractAction {
        public ActionUndo() {
            super("Undo Selection", OrbitIcons.UNDO);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"Selection.undo()", (Object[])new Object[0]);
        }
    }

    protected static class ActionFactoryList
    extends LinkedList<ViewActionFactory> {
        protected ActionFactoryList() {
        }
    }

    public static class ViewConstraint {
        HashSet<Class<?>> mSet = new HashSet();

        public static ViewConstraint createEmpty() {
            return new ViewConstraint();
        }

        public static ViewConstraint createAll() {
            ViewConstraint vc = new ViewConstraint();
            for (Class c : OrbitGuiShortcutActionRegistry.get().getClasses()) {
                vc.mSet.add(c);
            }
            return vc;
        }

        private ViewConstraint() {
        }

        public boolean contains(Class<?> c) {
            return this.mSet.contains(c);
        }

        public boolean add(Class<?> c) {
            return this.mSet.add(c);
        }

        public boolean remove(Class<?> c) {
            return this.mSet.remove(c);
        }
    }

    public static interface ViewActionFactory {
        public Iterator<Object> getActions(Db var1, Selection var2, APoint2D var3);

        public String getGroupName();
    }
}

