/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUrlUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.ExternalAttachment;
import com.sigrity.orbit.ui.EditDbFieldUI;
import com.sigrity.orbit.ui.ExternalAttachmentUI;
import java.awt.Component;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;

public class OrbitHyperlinkHandler
implements AFloatWindow.LinkHandler {
    protected AFloatWindow mWindow;

    public OrbitHyperlinkHandler(AFloatWindow window) {
        this.mWindow = window;
    }

    @Override
    public boolean linkUpdate(HyperlinkEvent e) {
        URL url;
        boolean wasPinned;
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return false;
        }
        if (this.mWindow != null && !(wasPinned = this.mWindow.getPinned())) {
            this.mWindow.setPinned(true);
        }
        if ((url = e.getURL()) == null || !url.getProtocol().equals("http")) {
            return false;
        }
        String host = url.getHost();
        if (host.equals("orbit.addAttachment")) {
            if (ExternalAttachmentUI.add(url.getPath().substring(1), url.getQuery())) {
                this.ownerDataChanged();
            }
            return true;
        }
        if (host.equals("orbit.showAttachment")) {
            LinkedList nv = AUrlUtil.parseQueryString((String)url.getQuery());
            ExternalAttachment.show((String)url.getPath().substring(1), (String)((AUrlUtil.NameVal)nv.get(0)).getName(), (String)((AUrlUtil.NameVal)nv.get(1)).getName(), (String)((AUrlUtil.NameVal)nv.get(2)).getName());
            return true;
        }
        if (host.equals("orbit.deleteAttachment")) {
            int response = JOptionPane.showConfirmDialog(OrbitIO.getMainWindow(), "Are you sure you want to remove the attachment?", "Confirm Remove", 0, 3);
            if (response == 0) {
                LinkedList nv = AUrlUtil.parseQueryString((String)url.getQuery());
                Object result = Cp.exec((String)"ExternalAttachment.remove(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{url.getPath().substring(1), ((AUrlUtil.NameVal)nv.get(0)).getName(), ((AUrlUtil.NameVal)nv.get(1)).getName(), ((AUrlUtil.NameVal)nv.get(2)).getName()});
                if (((Boolean)result).booleanValue()) {
                    this.ownerDataChanged();
                }
            }
            return true;
        }
        if (host.equals("orbit.modifyField")) {
            LinkedList nv = AUrlUtil.parseQueryString((String)url.getQuery());
            String strDbClass = url.getPath().substring(1);
            DbClass dbc = OrbitIO.getCurDb().getDbClass(strDbClass);
            if (dbc == null) {
                ALog.logError((Throwable)new Throwable(), (String)"No database class '%s' in current db for '%s'.", (Object[])new Object[]{strDbClass, url.toExternalForm()});
                return true;
            }
            String strObjKey = ((AUrlUtil.NameVal)nv.get(0)).getName();
            DbObject dbo = dbc.getInstanceByKeyStr(strObjKey);
            if (dbo == null) {
                ALog.logError((Throwable)new Throwable(), (String)"No database object with key '%s' in current db for '%s'.", (Object[])new Object[]{strObjKey, url.toExternalForm()});
                return true;
            }
            String strFieldName = ((AUrlUtil.NameVal)nv.get(1)).getName();
            DbFieldDef dbfd = dbc.getField(strFieldName);
            if (dbfd == null) {
                ALog.logError((Throwable)new Throwable(), (String)"No database field '%s' in class %s for '%s'.", (Object[])new Object[]{strFieldName, strDbClass, url.toExternalForm()});
                return true;
            }
            if (EditDbFieldUI.edit(dbo, dbfd, (Component)((Object)this.mWindow))) {
                this.ownerDataChanged();
            }
            return true;
        }
        return false;
    }

    protected void ownerDataChanged() {
    }
}

