/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ATransformableIcon;
import com.sigrity.acl.ui.AclResources;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.core.OrbitContextMenuWS;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class OrbitIcons {
    public static final Icon ORBIT = AclResources.ICON_ORBIT;
    public static final Icon BLANK16x16 = new AColorIcon(16, 16, AColor.CLEAR, AColor.CLEAR);
    public static final Icon EMPTY16x16 = OrbitContextMenuWS.AEmptyIcon.N;
    public static final Icon ACCEPT = OrbitIcons.getIcon("iconAccept.png");
    public static final Icon ADD = OrbitIcons.getIcon("iconAdd.png");
    public static final Icon AVOID = OrbitIcons.getIcon("iconAvoid.gif");
    public static final Icon ALIGN = OrbitIcons.getIcon("iconAlign.gif");
    public static final Icon BLOCKED_PERSONALITY_PIN = OrbitIcons.getIcon("iconBlockedPersonalitiesPin.png");
    public static final Icon BRIGHTNESS = OrbitIcons.getIcon("iconBrightness.png");
    public static final Icon BRIGHTNESS_LOW = OrbitIcons.getIcon("iconBrightnessLow.png");
    public static final Icon PERSONALITY_PIN = OrbitIcons.getIcon("iconPersonalitiesPin.png");
    public static final Icon CHECK = ACCEPT;
    public static final Icon COG = OrbitIcons.getIcon("iconCogStandard.png");
    public static final Icon COG_ADVANCED = OrbitIcons.getIcon("db/iconCogAdvanced.png");
    public static final Icon COG_EDIT = OrbitIcons.getIcon("iconCogEdit.png");
    public static final Icon COMMENT = OrbitIcons.getIcon("iconComment.png", "CDNS.annotateIcon");
    public static final Icon CONSOLE = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("iconConsole.png", "CDNS.outputIcon"), (int)16, (int)16);
    public static final Icon CONS_ELECTRICAL = OrbitIcons.getIcon("consmgr/electrical_displayed.png");
    public static final Icon CONS_PHYSICAL = OrbitIcons.getIcon("consmgr/physical_displayed.png");
    public static final Icon CONS_PROPERTY = OrbitIcons.getIcon("consmgr/property_displayed.png");
    public static final Icon CONS_SAME_NET_SPACING = OrbitIcons.getIcon("consmgr/same_net_spacing_displayed.png");
    public static final Icon CONS_SPACING = OrbitIcons.getIcon("consmgr/spacing_displayed.png");
    public static final Icon COPY_FILE = OrbitIcons.getIcon("iconCopyDesign.png", "CDNS.copyIcon");
    public static final Icon CROSS = OrbitIcons.getIcon("iconCross.png", "CDNS.deleteIcon");
    public static final Icon DELETE = OrbitIcons.getIcon("iconDelete.png");
    public static final Icon DIFF = OrbitIcons.getIcon("iconDiff.png");
    public static final Icon DOCUMENT = OrbitIcons.getIcon("iconDocument.png");
    public static final Icon DOCUMENT_DEL = OrbitIcons.getIcon("iconDocumentDel.png");
    public static final Icon DOWN = OrbitIcons.getIcon("iconDown.png");
    public static final Icon ICON_BELOW = OrbitIcons.getIcon("iconBelow.png");
    public static final Icon DRC_ERROR = OrbitIcons.getIcon("iconDRCError.png");
    public static final Icon EXCLAMATION = OrbitIcons.getIcon("iconExclamation.png");
    public static final Icon FLIP_ABOUTX = OrbitIcons.getIcon("iconFlipAboutX.png", "CDNS.flipHorizontalAxisIcon");
    public static final Icon FLIP_ABOUTY = OrbitIcons.getIcon("iconFlipAboutY.png", "CDNS.flipVerticalAxisIcon");
    public static final Icon FLOORPLAN_BLOCKED = OrbitIcons.getIcon("iconBlockedFloorplan.png");
    public static final Icon FLOORPLAN_HAPPY = OrbitIcons.getIcon("iconHappyFloorplan.png");
    public static final Icon FILTER_MORE = OrbitIcons.getIcon("iconFilterMore.png");
    public static final Icon FILTER_LESS = OrbitIcons.getIcon("iconFilterLess.png");
    public static final Icon FILE_OPEN = OrbitIcons.getIcon("db/iconFolder.png", "CDNS.fileOpenIcon");
    public static final Icon FILE_SAVE = OrbitIcons.getIcon("iconSave.png", "CDNS.fileSaveIcon");
    public static final Icon FOLDER = OrbitIcons.getIcon("iconFolder.png");
    public static final Icon FOLDER_DESIGN = OrbitIcons.getIcon("iconDesignFolder.png");
    public static final Icon FOLDER_DESIGN_COG = OrbitIcons.getIcon("iconDesignFolderCog.png");
    public static final Icon HISTORY = OrbitIcons.getIcon("iconRollback.png", "CDNS.historyIcon");
    public static final Icon INSPECT = OrbitIcons.getIcon("iconInspect.png", "CDNS.whatIsThisIcon");
    public static final Icon IOVIEW = OrbitIcons.getIcon("iconIOView.png");
    public static final Icon LAYERS = OrbitIcons.getIcon("iconLayers.png");
    public static final Icon LIBRARY_HIERARCHY = OrbitIcons.getIcon("iconDesignFolder.png", "CDNS.hierarchyIcon");
    public static final Icon LOCK = OrbitIcons.getIcon("iconLock.png");
    public static final Icon LOG_FILE = AclResources.ICON_LOG_FILE;
    public static final Icon MAKE_CONNECTIONS = OrbitIcons.getIcon("iconSelPin.png");
    public static final Icon MOVE_DEVICE = OrbitIcons.getIcon("iconMoveDevice.png", "CDNS.moveIcon");
    public static final Icon MOVE_ORTH = OrbitIcons.getIcon("iconMoveDevice.png", "CDNS.moveOrthIcon");
    public static final Icon MOVE_VIA = OrbitIcons.getIcon("iconViaMove.gif");
    public static final Icon NAVIGATE = OrbitIcons.getIcon("iconPanView.png", "CDNS.panIcon");
    public static final Icon NETMAP = OrbitIcons.getIcon("iconNetMap.png");
    public static final Icon NETMAP_NO = OrbitIcons.getIcon("iconNetMapNo.png");
    public static final Icon NETMAP_DOWN = OrbitIcons.getIcon("iconNetMapDown.png");
    public static final Icon NETMAP_UP = OrbitIcons.getIcon("iconNetMapUp.png");
    public static final Icon NEW_FILE = OrbitIcons.getIcon("db/iconDesign.png", "CDNS.newFileIcon");
    public static final Icon PAINT_PALETTE = OrbitIcons.getIcon("iconPaintPalette.png");
    public static final Icon PAN_DOWN = OrbitIcons.getIcon("iconPanDown.gif", "CDNS.downIcon");
    public static final Icon PAN_LEFT = OrbitIcons.getIcon("iconPanLeft.gif", "CDNS.leftIcon");
    public static final Icon PAN_RIGHT = OrbitIcons.getIcon("iconPanRight.gif", "CDNS.rightIcon");
    public static final Icon PAN_UP = OrbitIcons.getIcon("iconPanUp.gif", "CDNS.upIcon");
    public static final Icon PARTITION_TOOL = OrbitIcons.getIcon("iconTemplate.png");
    public static final Icon PIN = OrbitIcons.getIcon("iconPin.png");
    public static final Icon RECORD_SCRIPT = OrbitIcons.getIcon("iconRecord.png", "CDNS.scriptCreateIcon");
    public static final Icon RECORDING = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("iconRecording.png", "CDNS.recordIcon"), (int)16, (int)16);
    public static final Icon REFRESH = OrbitIcons.getIcon("iconRefresh.gif", "CDNS.refreshIcon");
    public static final Icon ROUTE_EDIT = OrbitIcons.getIcon("iconRouteEdit.png");
    public static final Icon ROTATE_180 = OrbitIcons.getIcon("iconRot180.png");
    public static final Icon ROTATE_90CW = OrbitIcons.getIcon("iconRot90CW.png", "CDNS.rotate90RightIcon");
    public static final Icon ROTATE_90CCW = OrbitIcons.getIcon("iconRot90CCW.png", "CDNS.rotate90LeftIcon");
    public static final Icon RULER = OrbitIcons.getIcon("iconRuler.png", "CDNS.rulerCreateIcon");
    public static final Icon RUN_SCRIPT = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("iconRunScript.png", "CDNS.scriptRunIcon"), (int)16, (int)16);
    public static final Icon SCRIPT_FILE = AclResources.ICON_OJS_FILE;
    public static final Icon SELECT = OrbitIcons.getIcon("iconSelect.png", "CDNS.selectIcon");
    public static final Icon SELECT_LASSO = OrbitIcons.getIcon("iconSelectLasso.png");
    public static final Icon SELECT_CLEAR = OrbitIcons.getIcon("iconSelectionClear.png", "CDNS.deselectAllIcon");
    public static final Icon SELECT_DEVICE = OrbitIcons.getIcon("iconSelDevice.png");
    public static final Icon SELECT_PORT = OrbitIcons.getIcon("iconSelPin.png");
    public static final Icon SELECT_NET = OrbitIcons.getIcon("iconSelNets.png");
    public static final Icon SHAPE_EDIT = OrbitIcons.getIcon("iconShapeEdit.png");
    public static final Icon SNAP_TO_CLIPBOARD = OrbitIcons.getIcon("iconSnapshot.png", "CDNS.snapshotIcon");
    public static final Icon SRCH = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("iconSearch.gif", "CDNS.findTextIcon"), (int)16, (int)16);
    public static final Icon SRCH_GOTO = OrbitIcons.getIcon("iconSearchGoto.gif");
    public static final Icon SRCH_GOTO_X = OrbitIcons.getIcon("iconSearchGotoX.gif");
    public static final Icon SRCH_HIST = OrbitIcons.getIcon("iconSearchHist.gif");
    public static final Icon SRCH_HIST_X = OrbitIcons.getIcon("iconSearchHistX.gif");
    public static final Icon SRCH_NEXT = OrbitIcons.getIcon("iconSearchNext.gif");
    public static final Icon SRCH_NEXT_X = OrbitIcons.getIcon("iconSearchNextX.gif");
    public static final Icon SRCH_PREV = OrbitIcons.getIcon("iconSearchPrev.gif");
    public static final Icon SRCH_PREV_X = OrbitIcons.getIcon("iconSearchPrevX.gif");
    public static final Icon SRCH_X = OrbitIcons.getIcon("iconSearchX.gif");
    public static final Icon STACK = OrbitIcons.getIcon("iconStack.png");
    public static final Icon SWAP = OrbitIcons.getIcon("iconFlipAboutX.png", "CDNS.swapIcon");
    public static final Icon UNDO = OrbitIcons.getIcon("iconUndo.png", "CDNS.undoIcon");
    public static final Icon REDO = OrbitIcons.getIcon("iconRedo.png", "CDNS.redoIcon");
    public static final Icon UP = OrbitIcons.getIcon("iconUp.png");
    public static final Icon VIEW_HORIZONTAL = OrbitIcons.getIcon("view-horizontal.png");
    public static final Icon VIEW_VERTICAL = OrbitIcons.getIcon("view-vertical.png");
    public static final Icon WAIT = OrbitIcons.getIcon("iconWait.png");
    public static final Icon WIN_CLOSE = OrbitIcons.getIcon("iconWinClose.png");
    public static final Icon WIN_EXTERNALIZE = OrbitIcons.getIcon("iconWinExternalize.png");
    public static final Icon WIN_MAXIMIZE = OrbitIcons.getIcon("iconWinMaximize.png");
    public static final Icon WIN_MINIMIZE = OrbitIcons.getIcon("iconWinMinimize.png");
    public static final Icon WIN_NORMALIZE = OrbitIcons.getIcon("iconWinNormalize.png");
    public static final Icon WIN_UNEXTERNALIZE = OrbitIcons.getIcon("iconWinUnexternalize.png");
    public static final Icon WORKFLOW = OrbitIcons.getIcon("iconWorkflow.png");
    public static final Icon WRENCH = OrbitIcons.getIcon("iconWrench.png");
    public static final Icon XFORM = OrbitIcons.getIcon("iconXForm.png");
    public static final Icon ZOOM_FIT = OrbitIcons.getIcon("iconZoomFit.png", "CDNS.zoomFitIcon");
    public static final Icon ZOOM_IN = OrbitIcons.getIcon("iconZoomIn.png", "CDNS.zoomInIcon");
    public static final Icon ZOOM_OUT = OrbitIcons.getIcon("iconZoomOut.png", "CDNS.zoomOutIcon");
    public static final Icon ZOOM_REGION = OrbitIcons.getIcon("iconZoomRegion.png", "CDNS.zoomByPointsIcon");
    public static final Icon ZOOM_SELECTED = OrbitIcons.getIcon("iconZoomSelected.png", "CDNS.zoomSelectedIcon");
    public static final Icon ZOOM_PREVIOUS = OrbitIcons.getIcon("iconZoomPrevious.png", "CDNS.zoomPreviousIcon");
    public static final Icon ZOOM_NEXT = OrbitIcons.getIcon("iconZoomNext.png", "CDNS.zoomNextIcon");
    public static final Icon SHOW_RATS = OrbitIcons.getIcon("iconShowRats.png", "CDNS.flightIcon");
    public static final Icon BLANK_RATS = OrbitIcons.getIcon("iconBlankRats.png", "CDNS.deflightIcon");
    public static final Icon SHOW_ME = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("iconShowMe.png", "CDNS.searchlightIcon"), (int)16, (int)16);
    public static final Icon SHOWME_CLEAR = OrbitIcons.getIcon("iconShowMeClear.png", "CDNS.desearchlightAllIcon");
    public static final Icon EDIT = OrbitIcons.getIcon("iconEdit.png");
    public static final Icon VIEW_SETTING = OrbitIcons.getIcon("iconViewSettings16.png", "CDNS.colorIcon");
    public static final Icon DECOR_ADDED = OrbitIcons.getIcon("idecorAdd.png");
    public static final Icon DECOR_DELETED = OrbitIcons.getIcon("idecorDelete.png");
    public static final Icon DECOR_ACCEPT = OrbitIcons.getIcon("idecorAccept.png");
    public static final Icon DECOR_MODIFIED = OrbitIcons.getIcon("idecorModify.png");
    public static final Icon SAVE_DISK = OrbitIcons.getIcon("iconDisk.png", "CDNS.fileSaveIcon");
    public static final Icon SAVE_AS_DISK = OrbitIcons.getIcon("iconSaveAs.png", "CDNS.fileSaveAsIcon");
    public static final Icon BACK_TO = OrbitIcons.getIcon("iconBackTo.png");
    public static final Icon UP_TO = OrbitIcons.getIcon("iconUpTo.png");
    public static final Icon ADD_ROWS = OrbitIcons.getIcon("iconAddRows.png");
    public static final Icon DELETE_ROWS = OrbitIcons.getIcon("iconDeleteRows.png");
    public static final Icon INSERT_ROW_ABOVE = OrbitIcons.getIcon("iconInsertRowAbove.png");
    public static final Icon INSERT_ROW_BELOW = OrbitIcons.getIcon("iconInsertRowBelow.png");
    public static final Icon INSERT_COLUMN_LEFT = OrbitIcons.getIcon("iconInsertColumnLeft.png");
    public static final Icon INSERT_COLUMN_RIGHT = OrbitIcons.getIcon("iconInsertColumnRight.png");
    public static final Icon DELETE_ROW = OrbitIcons.getIcon("iconDeleteRow.png");
    public static final Icon DELETE_COLUMN = OrbitIcons.getIcon("iconDeleteColumn.png");
    public static final Icon TABLE = OrbitIcons.getIcon("iconTable.png");
    public static final Icon INFORMATION = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("iconInformation.png", "CDNS.instanceObjectIcon"), (int)16, (int)16);
    public static final Icon GRAPHNET = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("iconGraphNet.png"), (int)16, (int)16);
    public static final Icon FILTER_TABLE = OrbitIcons.getIcon("iconFilterTable.png");
    public static final Icon IMPORT = OrbitIcons.getIcon("iconImport.png");
    public static final Icon EXPORT = OrbitIcons.getIcon("iconExport.png");
    public static final Icon EXPORT_PIN = OrbitIcons.getIcon("iconExportPin.png");
    public static final Icon POWER = OrbitIcons.getIcon("iconPower.png");
    public static final Icon GROUND = OrbitIcons.getIcon("iconGround.png");
    public static final Icon SIGNAL = OrbitIcons.getIcon("iconSignal.png");
    public static final Icon ALIGN_BOTTOM = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("placement/iconAlignBottom.png", "CDNS.alignBottomIcon"), (int)16, (int)16);
    public static final Icon ALIGN_CENTER_X = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("placement/iconAlignCenterX.png", "CDNS.alignCenterHorizIcon"), (int)16, (int)16);
    public static final Icon ALIGN_CENTER_Y = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("placement/iconAlignCenterY.png", "CDNS.alignCenterVerticalIcon"), (int)16, (int)16);
    public static final Icon ALIGN_LEFT = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("placement/iconAlignLeft.png", "CDNS.alignLeftIcon"), (int)16, (int)16);
    public static final Icon ALIGN_RIGHT = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("placement/iconAlignRight.png", "CDNS.alignRightIcon"), (int)16, (int)16);
    public static final Icon ALIGN_TOP = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("placement/iconAlignTop.png", "CDNS.alignTopIcon"), (int)16, (int)16);
    public static final Icon SPACE = UIUtil.getScaledIcon((Icon)OrbitIcons.getIcon("placement/iconSpace.png"), (int)16, (int)16);
    public static final Icon ROUTER_APR = OrbitIcons.getIcon("iconAPR.png");

    protected OrbitIcons() {
    }

    public static Icon getSmallIcon(Class<?> type) {
        if (type.isAssignableFrom(DeviceTemplate.class)) {
            return DBEResources.ICON_TEMPLATE;
        }
        if (type.isAssignableFrom(Net.class)) {
            return DBEResources.ICON_NET;
        }
        if (type.isAssignableFrom(NetMap.class)) {
            return NETMAP;
        }
        if (type.isAssignableFrom(PinTemplate.class)) {
            return PIN;
        }
        if (type.isAssignableFrom(PinInstance.class)) {
            return PIN;
        }
        if (type.isAssignableFrom(Layer.class)) {
            return UIUtil.getScaledIcon((Icon)LAYERS, (int)16, (int)16);
        }
        return BLANK16x16;
    }

    public static Icon getSmallIcon(DbObject dbo) {
        if (DeviceTemplate.class.isAssignableFrom(dbo.getClass())) {
            return DbExplorerPanel.getIconForTemplate((DeviceTemplate)dbo);
        }
        if (Device.class.isAssignableFrom(dbo.getClass())) {
            return DbExplorerPanel.getIconForDevice((Device)dbo);
        }
        if (Net.class.isAssignableFrom(dbo.getClass())) {
            return DbExplorerPanel.getIconForNet((Net)dbo);
        }
        return OrbitIcons.getSmallIcon(dbo.getClass());
    }

    public static Icon getDefTransformIcon(DeviceTemplate.DefTransform dt) {
        ATransformableIcon ti = new ATransformableIcon();
        ti.setIconRot(dt.getRot());
        ti.setIconMirror(dt.getMirror());
        ti.setImageIcon((ImageIcon)XFORM);
        return ti;
    }

    public static Icon getIcon(String name) {
        return OrbitIcons.getIcon(name, null);
    }

    public static Icon getIcon(String name, String defaultIconKey) {
        if (defaultIconKey != null && UIManager.get(defaultIconKey) != null) {
            return (Icon)UIManager.get(defaultIconKey);
        }
        return UIUtil.getIcon(OrbitIcons.class, (String)("res/" + name));
    }
}

