/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AObjectArranger;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class OrbitObjectArrangerDlg {
    public static Long getMinSep(Object o1, Object o2) {
        return 0L;
    }

    public static APolygon getBounds(HierInst<DbObject> ho) {
        if (ho.getDbObject() instanceof PinInstance) {
            PinInstance pinInstance = (PinInstance)ho.getDbObject();
            APair pI = pinInstance.getPinTemplate().getLargestGeom(null);
            if (pI != null) {
                LayerShape ls = (LayerShape)pI.first;
                AGeom g = ls.getGeom();
                APolygon p = g.toPoly();
                p = p.transform(pinInstance.getLocalTransform());
                return p.transform(ho.getPathTransform());
            }
        } else if (ho.getDbObject() instanceof DeviceTemplate) {
            DeviceTemplate dt = (DeviceTemplate)ho.getDbObject();
            AGeom g = dt.getBounds();
            APolygon p = g.toPoly();
            return p.transform(ho.getPathTransform());
        }
        return null;
    }

    protected static List<HierInst<DbObject>> getSelected(Db db) {
        Selection s = Selection.getCurrentSelectionForDb((Db)db);
        LinkedList<HierInst<DbObject>> list = new LinkedList<HierInst<DbObject>>();
        for (DbObject obj : s.getAll()) {
            for (DevicePath dp : s.getSelectedPaths(obj)) {
                list.add((HierInst<DbObject>)new HierInst(dp, obj));
            }
        }
        return list;
    }

    protected static void moveOrbitObject(HierInst<DbObject> hi, APoint2D ds) {
        if (hi.getDbObject() instanceof PinInstance) {
            PinInstance pi = (PinInstance)hi.getDbObject();
            pi.getPinTemplate().moveBy(ds);
        } else if (hi.getDbObject() instanceof DeviceTemplate) {
            hi.getPath().getLast().moveBy(ds);
        }
    }

    public static void alignTop(Db db) {
        List<HierInst<DbObject>> os = OrbitObjectArrangerDlg.getSelected(db);
        AObjectArranger oa = new AObjectArranger();
        HashMap instructions = oa.arrangeObjects("aligntop", os, OrbitObjectArrangerDlg::getBounds, OrbitObjectArrangerDlg::getMinSep);
        instructions.keySet().forEach(o -> OrbitObjectArrangerDlg.moveOrbitObject((HierInst<DbObject>)o, (APoint2D)instructions.get(o)));
    }
}

