/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.SubstrateTemplateListRenderer;
import com.sigrity.acl.dbui.render.TemplateListRenderer;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.SubstrateTemplate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PartFactoryUI {
    public static Action getAction() {
        return new AbstractAction("Instantiate Devices..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartFactoryDialog dlg = PartFactoryUI.createDlg(AApp.getApp().getMainWin(), OrbitIO.getCurDb());
                if (dlg != null) {
                    dlg.setVisible(true);
                }
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static PartFactoryDialog createDlg(Window owner, Db db) {
        if (!db.getObjects(Substrate.class).hasNext()) {
            ALog.logWarn((String)"There are no Substrates in the database, unable to instantiate devices.");
            return null;
        }
        return new PartFactoryDialog(owner, db);
    }

    public static class ByTypeNameSorter
    implements Comparator<DeviceTemplate> {
        @Override
        public int compare(DeviceTemplate dt0, DeviceTemplate dt1) {
            if (dt0 instanceof Design && !(dt1 instanceof Design)) {
                return -1;
            }
            if (!(dt0 instanceof Design) && dt1 instanceof Design) {
                return 1;
            }
            int c = dt0.getType().compareTo((Enum)dt1.getType());
            if (c == 0) {
                c = dt0.getName().compareTo(dt1.getName());
            }
            return c;
        }
    }

    public static class PartFactoryDialog
    extends DbDialog {
        protected PartFactoryPanel mPartFactoryPanel = new PartFactoryPanel();

        public PartFactoryDialog(Component owner, Db db) {
            super(db, owner);
            this.setTitle("Instantiate Devices");
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.addNl((Component)this.mPartFactoryPanel, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            l.addFillY();
            l.addFillX();
            JButton btnCancel = (JButton)l.add((Component)new JButton("Close"));
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)btnCancel);
            UIUtil.enableEscCloseMinSize((Window)((Object)this), (AbstractButton)btnCancel);
        }

        protected class PartFactoryPanel
        extends JPanel {
            protected JTextField mNumInstancesByTemplate;
            protected JTextField mNumInstancesBySelected;
            protected JTextField mPrefix;
            protected JComboBox<DeviceTemplate> mTemplateList;
            protected JLabel mDestinationTemplateLabel;
            protected JComboBox<DeviceTemplate> mDestinationTemplateList;
            protected JComboBox<SubstrateTemplate> mSubstrateList;
            protected JButton mInstatiate;
            protected JButton mCopy;
            protected boolean mUserModifiedPrefix = false;
            protected ActionListener mInstantiateTemplateListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object command = "com.sigrity.orbit.ui.DeviceTemplateUI.createInstance(\"";
                    command = (String)command + ((DeviceTemplate)PartFactoryPanel.this.mTemplateList.getSelectedItem()).getKeyStr();
                    command = (String)command + "\"";
                    command = (String)command + ",";
                    command = (String)command + "\"" + PartFactoryPanel.this.mPrefix.getText() + "\"";
                    command = (String)command + ",";
                    command = (String)command + "\"" + ((DeviceTemplate)PartFactoryPanel.this.mDestinationTemplateList.getSelectedItem()).getKeyStr() + "\"";
                    command = (String)command + ",";
                    command = (String)command + PartFactoryPanel.this.mNumInstancesByTemplate.getText();
                    command = (String)command + ")";
                    Cp.exec((String)command, (Object[])new Object[0]);
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            };
            protected ActionListener mCopySelectedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Cp.exec((String)("com.sigrity.orbit.ui.DeviceTemplateUI.cloneSelected (\"\"," + PartFactoryPanel.this.mNumInstancesBySelected.getText() + ")"), (Object[])new Object[0]);
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            };
            protected ActionListener mTemplateChanged = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PartFactoryPanel.this.updateDestinationTemplateList();
                    DeviceTemplate devT = (DeviceTemplate)PartFactoryPanel.this.mTemplateList.getSelectedItem();
                    if (!PartFactoryPanel.this.mUserModifiedPrefix && devT != null) {
                        String[] removeSuffixes;
                        String name = devT.getName();
                        for (String removeSuffix : removeSuffixes = new String[]{"T", "Template"}) {
                            if (!name.endsWith(removeSuffix)) continue;
                            name = name.substring(0, name.length() - removeSuffix.length());
                        }
                        PartFactoryPanel.this.mPrefix.setText(name);
                        PartFactoryPanel.this.mUserModifiedPrefix = false;
                    }
                }
            };
            protected ActionListener mSubstrateChanged = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PartFactoryPanel.this.updateTemplateList();
                    PartFactoryPanel.this.updateDestinationTemplateList();
                }
            };

            public PartFactoryPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                l.add("Substrate of Template to be Instantiated:");
                this.mSubstrateList = (JComboBox)l.add(new JComboBox());
                this.mSubstrateList.setRenderer(new SubstrateTemplateListRenderer());
                this.mSubstrateList.addActionListener(this.mSubstrateChanged);
                this.mSubstrateList.setPreferredSize(new Dimension(200, 24));
                l.newline();
                l.add("Template to be instantiated:");
                this.mTemplateList = (JComboBox)l.add(new JComboBox());
                this.mTemplateList.setRenderer(new TemplateListRenderer());
                this.mTemplateList.addActionListener(this.mTemplateChanged);
                this.mTemplateList.setPreferredSize(new Dimension(200, 24));
                l.newline();
                this.mDestinationTemplateLabel = l.add("Destination Template:");
                this.mDestinationTemplateList = (JComboBox)l.add(new JComboBox());
                this.mDestinationTemplateList.setRenderer(new TemplateListRenderer());
                this.mDestinationTemplateList.setPreferredSize(new Dimension(200, 24));
                l.newline();
                l.add("Number to create:");
                this.mNumInstancesByTemplate = (JTextField)l.add((Component)((JTextField)UIUtil.setMinToPref((Component)new JTextField("1", 2))));
                l.newline();
                l.add("Base name:");
                this.mPrefix = (JTextField)l.add((Component)((JTextField)UIUtil.setMinToPref((Component)new JTextField(20))));
                this.mPrefix.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.change();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.change();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.change();
                    }

                    void change() {
                        PartFactoryPanel.this.mUserModifiedPrefix = true;
                    }
                });
                l.addFillY();
                l.pushFillXRemainX();
                l.addFillX();
                this.mInstatiate = (JButton)l.add((Component)new JButton("Instantiate"), (GridBagConstraints)GridBagManager.RIGHT);
                this.mInstatiate.addActionListener(this.mInstantiateTemplateListener);
                l.pop();
                this.updateSubstrateList();
                this.updateTemplateList();
            }

            protected Substrate getSelectedSubstrate() {
                Substrate s = (Substrate)((SubstrateTemplate)((Object)this.mSubstrateList.getSelectedItem())).first;
                return s;
            }

            protected void updateSubstrateList() {
                this.mSubstrateList.removeAllItems();
                LinkedList<SubstrateTemplate> sts = SubstrateTemplate.getSubstrateInstances(PartFactoryDialog.this.mDb, true, false, null);
                for (SubstrateTemplate st : sts) {
                    this.mSubstrateList.addItem(st);
                }
            }

            protected void updateTemplateList() {
                LinkedList<DeviceTemplate> sortedTemplateList = new LinkedList<DeviceTemplate>();
                Substrate s = this.getSelectedSubstrate();
                for (DeviceTemplate t : PartFactoryDialog.this.mDb.getObjects(DeviceTemplate.class)) {
                    if (t.getSubstrate() != s || Design.getIsDesign((DeviceTemplate)t)) continue;
                    sortedTemplateList.add(t);
                }
                Collections.sort(sortedTemplateList, new ByTypeNameSorter());
                this.mTemplateList.setModel(new DefaultComboBoxModel<DeviceTemplate>(sortedTemplateList.toArray(new DeviceTemplate[sortedTemplateList.size()])));
            }

            protected void updateDestinationTemplateList() {
                this.mDestinationTemplateList.removeAllItems();
                DeviceTemplate devTCreate = (DeviceTemplate)this.mTemplateList.getSelectedItem();
                if (devTCreate == null) {
                    return;
                }
                Set invalidParents = devTCreate.getDescendantDevices().stream().map(DevicePath::getDeviceTemplate).distinct().collect(Collectors.toSet());
                invalidParents.add(devTCreate);
                DeviceTemplate curSelected = (DeviceTemplate)this.mDestinationTemplateList.getSelectedItem();
                this.mDestinationTemplateLabel.setText("Destination Template:");
                List<DeviceTemplate> elems = PartFactoryDialog.this.mDb.getObjects(DeviceTemplate.class).stream().filter(potentialParent -> !invalidParents.contains(potentialParent)).sorted(new ByTypeNameSorter()).collect(Collectors.toList());
                this.mDestinationTemplateList.setModel(new DefaultComboBoxModel<DeviceTemplate>(elems.toArray(new DeviceTemplate[elems.size()])));
                if (curSelected != null) {
                    this.mDestinationTemplateList.setSelectedItem(curSelected);
                }
            }
        }
    }
}

