/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.AColor;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.AStream;
import com.sigrity.acl.AStringEscape;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AHorizDivider;
import com.sigrity.acl.ui.ASmallHelpButton;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.BumpFactoryData;
import com.sigrity.orbit.automation.BumpRatioOptimizer;
import com.sigrity.orbit.automation.placement.PlaceableDefinitionUI;
import com.sigrity.orbit.automation.placement.PlaceableFactory;
import com.sigrity.orbit.factory.DeviceMatrixFactory;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.DesignDialog;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import org.javatuples.Pair;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PatternPlacementUI
extends DesignDialog {
    protected static final int INSET = 12;
    static final HashSet<DeviceTemplate.Type> NoPatternCreationForTypes = new HashSet<DeviceTemplate.Type>(Arrays.asList(DeviceTemplate.Type.BONDFINGER, DeviceTemplate.Type.ENDCAP, DeviceTemplate.Type.PERSONALITY));
    public static final ObjectActionRegistry.ActionFactory<HierInst<DbObject>> ActionFactory = (hinst, constraints) -> {
        if (!(hinst.getDbObject() instanceof Device)) {
            return AEmptyItr.create();
        }
        final Device device = (Device)hinst.getDbObject();
        final DeviceTemplate devT = device.getTemplate();
        BumpFactoryData d = BumpFactoryData.getForTemplate((DeviceTemplate)devT, (boolean)false);
        if (d != null) {
            String itemType = d.getPlaceableType();
            String editMenuText = String.format("Edit %sPattern...", itemType == null ? "" : itemType + " ");
            return new ASingletonItr((Object)new AbstractAction(editMenuText){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PatternPlacementUI ui = PatternPlacementUI.create(OrbitIO.getMainWindow(), device.getParent());
                    if (ui != null) {
                        ui.setEditPattern(device);
                        ui.setVisible(true);
                    }
                }
            });
        }
        if (devT != null && !NoPatternCreationForTypes.contains(devT.getType())) {
            return new ASingletonItr((Object)new AbstractAction("Create Pin or Device Pattern..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PatternPlacementUI ui = PatternPlacementUI.create(OrbitIO.getMainWindow(), devT);
                    if (ui != null) {
                        ui.setVisible(true);
                    }
                }
            });
        }
        return AEmptyItr.create();
    };
    Color BackgroundColor_Valid = new JTextField().getBackground();
    Color BackgroundColor_Error = AColor.mix((Color)this.BackgroundColor_Valid, (Color)Color.RED, (float)0.66f);
    Color BackgroundColor_Disabled_Error = AColor.mix((Color)this.BackgroundColor_Valid, (Color)Color.RED, (float)0.85f);
    protected DeviceTemplate mPatternOwner;
    protected Device mPatternDevice = null;
    protected JTextField mTxtRotation;
    protected JCheckBox mCbMirror;
    protected JLabel mLblItemName;
    protected JTextField mTxtItemName;
    protected ASmallHelpButton mBtnScriptHelp;
    protected JCheckBox mCbNameScript;
    protected PlaceableDefinitionUI mPlaceableDefnUI = null;
    protected JCheckBox mCbStagger;
    protected JPanel mPnlCornerKeepoutsAndMargins;
    protected JTextField mTxtCornerClearX;
    protected JTextField mTxtCornerClearY;
    protected JTextField mTxtPadRight;
    protected JTextField mTxtPadTop;
    protected JTextField mTxtPadLeft;
    protected JTextField mTxtPadBottom;
    protected JTabbedPane mTabs;
    protected CenterArrayPanel mPnlCenterArray;
    protected PeriMatrixPanel mPnlPeriMatrix;
    protected PeriRingsPanel mPnlPeriRings;
    protected RatioDrivenPanel mPnlRatioDriven;
    protected static LinkedList<ProgressListener> sLoadListener = new LinkedList();

    public static PatternPlacementUI create(Component owner, DeviceTemplate patternOwner) {
        try {
            return new PatternPlacementUI(owner, patternOwner);
        }
        catch (LSession.NoLicenseException e) {
            ALog.logError((Throwable)e, (String)"No license available.", (Object[])new Object[0]);
            return null;
        }
    }

    protected PatternPlacementUI(Component owner, DeviceTemplate patternOwner) throws LSession.NoLicenseException {
        super(patternOwner.getDb(), owner);
        this.mPatternOwner = patternOwner;
        this.setRecallBounds(false);
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        l.addNl((Component)new AHorizDivider("Item Creation Settings"), (GridBagConstraints)GridBagManager.FILLX_REMAINX.insetBottom(0));
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.indent());
        if (this.mPlaceableDefnUI == null) {
            this.mPlaceableDefnUI = new PlaceableDefinitionUI(patternOwner, true, null, null);
            l.add((Component)this.mPlaceableDefnUI, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
        }
        this.mTxtRotation = (JTextField)l.add((Component)new JTextField(5));
        this.mTxtRotation.setText("0.00");
        this.mCbMirror = new JCheckBox();
        l.add("Rotate items:");
        l.add((Component)this.mTxtRotation, (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
        l.add("Mirror items:");
        l.add((Component)this.mCbMirror, (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
        l.newline();
        this.mTxtRotation.addActionListener(e -> {
            Component c = this.mTabs.getSelectedComponent();
            if (c instanceof UsesPlacableItemBounds) {
                ((UsesPlacableItemBounds)((Object)c)).placableItemBoundsChanged();
            }
        });
        l.pushFillXRemainX();
        this.mLblItemName = l.add("Name:");
        this.mTxtItemName = (JTextField)l.add((Component)new JTextField(12), (GridBagConstraints)GridBagManager.FILLX);
        switch (this.mPatternOwner.getType()) {
            case DIE: 
            case INTERPOSER: {
                this.mTxtItemName.setText("Bump");
                break;
            }
            case PACKAGE: {
                this.mTxtItemName.setText("Ball");
                break;
            }
            default: {
                this.mTxtItemName.setText("Pin");
            }
        }
        try {
            URL helpUrl = AApp.getInstallDir().toURI().toURL();
            this.mBtnScriptHelp = new ASmallHelpButton(String.format("%s/docs/help/PatternPlacement/PatternPlacementUI.html#NameScript", helpUrl.toExternalForm()));
            l.add((Component)this.mBtnScriptHelp, (GridBagConstraints)GridBagManager.LEFT.noInsets());
        }
        catch (MalformedURLException e2) {
            ALog.logError((String)"Exception when trying to get Orbit install location: %s", (Object[])new Object[]{e2.getMessage()});
        }
        this.mCbNameScript = (JCheckBox)l.add((Component)new JCheckBox("Script"));
        this.mCbNameScript.setToolTipText("Specify a script to generate item names");
        this.mCbNameScript.addActionListener(e -> this.updateNamingStrategy());
        this.updateNamingStrategy();
        l.pop();
        l.popNl();
        l.addNl((Component)new AHorizDivider("Placement Pattern Options"), (GridBagConstraints)GridBagManager.FILLX_REMAINX.insetBottom(0));
        l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0).indent());
        this.mCbStagger = (JCheckBox)l.add((Component)new JCheckBox("Stagger pattern"), (GridBagConstraints)GridBagManager.LEFT);
        l.pop();
        l.newline();
        this.mPnlCornerKeepoutsAndMargins = this.createCornerKeepOutPanel();
        this.mTabs = new JTabbedPane();
        l.add((Component)this.mTabs, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        this.mTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Component component = PatternPlacementUI.this.mTabs.getSelectedComponent();
                if (component instanceof UsesCornerKeepoutsAndMargins) {
                    UsesCornerKeepoutsAndMargins ckuser = (UsesCornerKeepoutsAndMargins)((Object)component);
                    ckuser.installCornerKeepoutsAndMargins(PatternPlacementUI.this.mPnlCornerKeepoutsAndMargins);
                    UIUtil.setEnabled((Container)PatternPlacementUI.this.mPnlCornerKeepoutsAndMargins, (boolean)true);
                } else {
                    UIUtil.setEnabled((Container)PatternPlacementUI.this.mPnlCornerKeepoutsAndMargins, (boolean)false);
                }
            }
        });
        l.newline();
        ARect bb = patternOwner.getBB();
        Long width = bb.width();
        Long height = bb.height();
        this.mPnlCenterArray = new CenterArrayPanel();
        this.mTabs.add("Center Matrix", this.mPnlCenterArray);
        this.mPnlPeriMatrix = new PeriMatrixPanel();
        this.mTabs.add("Peripheral Matrix", this.mPnlPeriMatrix);
        this.mPnlPeriRings = new PeriRingsPanel();
        this.mTabs.add("Peripheral Rings", this.mPnlPeriRings);
        this.mPnlRatioDriven = new RatioDrivenPanel(width, height);
        this.mTabs.add("Ratio Driven", this.mPnlRatioDriven);
        this.mTabs.setFont(this.mTabs.getFont().deriveFont(1));
        this.mTabs.setTabLayoutPolicy(0);
        Dimension tabsDim = this.mTabs.getPreferredSize();
        while (this.mTabs.getTabRunCount() > 1) {
            ++tabsDim.width;
            this.mTabs.setSize(tabsDim);
        }
        this.mTabs.setPreferredSize(tabsDim);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"));
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)btnClose);
        l.pop();
        this.mPlaceableDefnUI.updateTemplates(this.mPatternOwner.getSubstrate(), this.mPatternOwner.getType());
        this.mPlaceableDefnUI.updateLayerList(this.mPatternOwner);
    }

    private JPanel createCornerKeepOutPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = GridBagManager.layout((Container)panel);
        String cornerClearanceTip = String.format("Space to stay out of corners of owner %s device.", this.getOwnerTypeName());
        l.addNl(String.format("%s Corner Keepout", this.getOwnerTypeName()), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0)).setToolTipText(cornerClearanceTip);
        l.add("X:", (GridBagConstraints)GridBagManager.LEFT.insetLeft(12));
        this.mTxtCornerClearX = (JTextField)l.add((Component)new JTextField(10));
        l.add("Y:");
        this.mTxtCornerClearY = (JTextField)l.add((Component)new JTextField(10));
        l.addFillX();
        this.mTxtCornerClearX.setText("0");
        this.mTxtCornerClearY.setText("0");
        l.newline();
        l.add("Cover Cell Padding", (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0)).setToolTipText("Space to add inside the cover cell defintion around the outer bumps.");
        l.newline();
        l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets().insetLeft(12));
        this.mTxtPadLeft = (JTextField)l.add("Left:", (Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        this.mTxtPadTop = (JTextField)l.add("Top:", (Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        l.newline();
        this.mTxtPadRight = (JTextField)l.add("Right:", (Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        this.mTxtPadBottom = (JTextField)l.add("Bottom:", (Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        l.pop();
        this.mTxtPadRight.setText("0");
        this.mTxtPadTop.setText("0");
        this.mTxtPadLeft.setText("0");
        this.mTxtPadBottom.setText("0");
        return panel;
    }

    public void setEditPattern(Device patternGroup) {
        this.mPatternDevice = patternGroup;
    }

    public void load(BumpFactoryData bfd) {
        Unit unit = this.getUnitDist();
        this.mPlaceableDefnUI.load(bfd);
        String baseName = bfd.getBumpBaseName();
        if (baseName != null && baseName.length() > 0) {
            this.mTxtItemName.setText(baseName);
        }
        this.mCbNameScript.setSelected(bfd.getBumpNameIsScript());
        this.updateNamingStrategy();
        if (bfd.getCornerKeepoutX() > 0L) {
            this.mTxtCornerClearX.setText(unit.toUserStr(bfd.getCornerKeepoutX()));
        }
        if (bfd.getCornerKeepoutY() > 0L) {
            this.mTxtCornerClearY.setText(unit.toUserStr(bfd.getCornerKeepoutY()));
        }
        this.mCbStagger.setSelected(bfd.isStagger());
        if (bfd.getPaddingR() > 0L) {
            this.mTxtPadRight.setText(unit.toUserStr(bfd.getPaddingR()));
        }
        if (bfd.getPaddingT() > 0L) {
            this.mTxtPadTop.setText(unit.toUserStr(bfd.getPaddingT()));
        }
        if (bfd.getPaddingL() > 0L) {
            this.mTxtPadLeft.setText(unit.toUserStr(bfd.getPaddingL()));
        }
        if (bfd.getPaddingB() > 0L) {
            this.mTxtPadBottom.setText(unit.toUserStr(bfd.getPaddingB()));
        }
        switch (bfd.getFactoryType()) {
            case CENTER_MATRIX: {
                this.configUICenterMatrix(bfd, unit);
                break;
            }
            case PERIPHERAL_MATRIX: {
                this.configUIPeripheralMatrix(bfd, unit);
                break;
            }
            case PERIPHERAL_RINGS: {
                this.configUIPeripheralRings(bfd, unit);
                break;
            }
            case RATIO_DRIVEN: {
                this.configUIRatioDriven(bfd, unit);
                break;
            }
            default: {
                ALog.logError((String)"Unsupported BumpFactoryType:%s", (Object[])new Object[]{bfd.getFactoryType()});
            }
        }
    }

    private void configUICenterMatrix(BumpFactoryData bfd, Unit unit) {
        this.setTitle("Edit Center Matrix");
        this.mTabs.remove(this.mPnlPeriMatrix);
        this.mTabs.remove(this.mPnlPeriRings);
        this.mTabs.remove(this.mPnlRatioDriven);
        this.mPnlCenterArray.mTxtDX.setText(unit.toUserStr(bfd.getDx()));
        this.mPnlCenterArray.mTxtDY.setText(unit.toUserStr(bfd.getDy()));
        if (bfd.getRows() > 0) {
            this.mPnlCenterArray.mTxtCols.setText("" + bfd.getCols());
            this.mPnlCenterArray.mTxtRows.setText("" + bfd.getRows());
        } else {
            this.mPnlCenterArray.mTxtEdgeClearL.setText(unit.toUserStr(bfd.getEdgeClearL()));
            this.mPnlCenterArray.mTxtEdgeClearR.setText(unit.toUserStr(bfd.getEdgeClearR()));
            this.mPnlCenterArray.mTxtEdgeClearT.setText(unit.toUserStr(bfd.getEdgeClearT()));
            this.mPnlCenterArray.mTxtEdgeClearB.setText(unit.toUserStr(bfd.getEdgeClearB()));
        }
        this.mPnlCenterArray.mTxtMinBumpPitch.setText(unit.toUserStr(bfd.getMinPitch()));
        this.mPnlCenterArray.recalc(null);
    }

    private void configUIPeripheralMatrix(BumpFactoryData bfd, Unit unit) {
        this.setTitle("Edit Peripheral Matrix");
        this.mTabs.remove(this.mPnlCenterArray);
        this.mTabs.remove(this.mPnlPeriRings);
        this.mTabs.remove(this.mPnlRatioDriven);
        this.mPnlPeriMatrix.mTxtRingCount.setText("" + bfd.getCols());
        this.mPnlPeriMatrix.mTxtEdgeClearL.setText(unit.toUserStr(bfd.getEdgeClearL()));
        this.mPnlPeriMatrix.mTxtEdgeClearR.setText(unit.toUserStr(bfd.getEdgeClearR()));
        this.mPnlPeriMatrix.mTxtEdgeClearT.setText(unit.toUserStr(bfd.getEdgeClearT()));
        this.mPnlPeriMatrix.mTxtEdgeClearB.setText(unit.toUserStr(bfd.getEdgeClearB()));
        this.mPnlPeriMatrix.mTxtPitchX.setText(unit.toUserStr(bfd.getDx()));
        this.mPnlPeriMatrix.mTxtPitchY.setText(unit.toUserStr(bfd.getDy()));
    }

    private void configUIPeripheralRings(BumpFactoryData bfd, Unit unit) {
        this.setTitle("Edit Peripheral Rings");
        this.mTabs.remove(this.mPnlCenterArray);
        this.mTabs.remove(this.mPnlPeriMatrix);
        this.mTabs.remove(this.mPnlRatioDriven);
        this.mPnlPeriRings.mTxtRingCount.setText("" + bfd.getCols());
        this.mPnlPeriRings.mTxtEdgeClearL.setText(unit.toUserStr(bfd.getEdgeClearL()));
        this.mPnlPeriRings.mTxtEdgeClearR.setText(unit.toUserStr(bfd.getEdgeClearR()));
        this.mPnlPeriRings.mTxtEdgeClearT.setText(unit.toUserStr(bfd.getEdgeClearT()));
        this.mPnlPeriRings.mTxtEdgeClearB.setText(unit.toUserStr(bfd.getEdgeClearB()));
        this.mPnlPeriRings.mTxtShiftL.setText(unit.toUserStr(bfd.getShiftL()));
        this.mPnlPeriRings.mTxtShiftR.setText(unit.toUserStr(bfd.getShiftR()));
        this.mPnlPeriRings.mTxtShiftT.setText(unit.toUserStr(bfd.getShiftT()));
        this.mPnlPeriRings.mTxtShiftB.setText(unit.toUserStr(bfd.getShiftB()));
        this.mPnlPeriRings.mTxtRotateL.setText(AUtil.floatToString((float)bfd.getRotateL()));
        this.mPnlPeriRings.mTxtRotateR.setText(AUtil.floatToString((float)bfd.getRotateR()));
        this.mPnlPeriRings.mTxtRotateT.setText(AUtil.floatToString((float)bfd.getRotateT()));
        this.mPnlPeriRings.mTxtRotateB.setText(AUtil.floatToString((float)bfd.getRotateB()));
        this.mPnlPeriRings.mTxtSweepPitch.setText(unit.toUserStr(bfd.getDx()));
        this.mPnlPeriRings.mTxtRingPitch.setText(unit.toUserStr(bfd.getDy()));
    }

    private void configUIRatioDriven(BumpFactoryData bfd, Unit unit) {
        this.setTitle("Edit Ratio Generated Pattern");
        this.mTabs.remove(this.mPnlCenterArray);
        this.mTabs.remove(this.mPnlPeriMatrix);
        this.mTabs.remove(this.mPnlPeriRings);
        unit.setDecimalPlaces(3);
        this.mPnlRatioDriven.numIO.setText(Integer.toString(bfd.getNumIO()));
        this.mPnlRatioDriven.height.setText(unit.toUserStr(bfd.getHeight()));
        this.mPnlRatioDriven.width.setText(unit.toUserStr(bfd.getWidth()));
        this.mPnlRatioDriven.bumpPitch.setText(unit.toUserStr(bfd.getMinPitch()));
        if (bfd.getXPitch() == 0L) {
            bfd.setXPitch(bfd.getMinPitch());
        }
        if (bfd.getYPitch() == 0L) {
            bfd.setYPitch(bfd.getMinPitch());
        }
        this.mPnlRatioDriven.xPitch.setText(unit.toUserStr(bfd.getXPitch()));
        this.mPnlRatioDriven.yPitch.setText(unit.toUserStr(bfd.getYPitch()));
        this.mPnlRatioDriven.ratioTableModel.populateFromBumpFactoryData(bfd);
        this.mPnlRatioDriven.leftKeepout.setText(unit.toUserStr(bfd.getLeftKeepout()));
        this.mPnlRatioDriven.rightKeepout.setText(unit.toUserStr(bfd.getRightKeepout()));
        this.mPnlRatioDriven.bottomKeepout.setText(unit.toUserStr(bfd.getBottomKeepout()));
        this.mPnlRatioDriven.topKeepout.setText(unit.toUserStr(bfd.getTopKeepout()));
        this.mPnlRatioDriven.enableCalcButtons();
    }

    public void setJustRatioDriven() {
        this.setTitle("Edit Ratio Generated Pattern");
        this.mTabs.remove(this.mPnlCenterArray);
        this.mTabs.remove(this.mPnlPeriMatrix);
        this.mTabs.remove(this.mPnlPeriRings);
        Unit unit = this.getUnitDist();
        unit.setDecimalPlaces(1);
        this.mPlaceableDefnUI.restrictPlaceableType(PlaceableDefinitionUI.PlaceableType.Device);
        this.mPnlRatioDriven.enableCalcButtons();
    }

    public boolean isEditing() {
        return this.mPatternDevice != null;
    }

    public void addNotify() {
        BumpFactoryData bfd;
        this.setTitle(String.format("%s Pattern", this.isEditing() ? "Edit" : "Create"));
        DeviceTemplate patternGroupT = this.mPatternDevice == null ? null : this.mPatternDevice.getTemplate();
        BumpFactoryData bumpFactoryData = bfd = this.mPatternDevice == null ? null : BumpFactoryData.getForTemplate((DeviceTemplate)patternGroupT, (boolean)false);
        if (bfd != null) {
            this.load(bfd);
        }
        this.enableControls();
        this.updateCreateOrEdit();
        super.addNotify();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    public void setTitle(String title) {
        DeviceTemplate.Type ownerType = this.mPatternOwner.getType();
        String ownerDesc = String.format("%s (%s)", this.mPatternOwner.getName(), ownerType == null ? "" : AUtil.capitalizeFirstThenLower((String)ownerType.name()));
        String s = String.format("%s for %s", title, ownerDesc);
        super.setTitle(s);
    }

    protected void enableControls() {
        this.mPlaceableDefnUI.enableControls();
    }

    protected void updateCreateOrEdit() {
        BumpFactoryData bfd = this.mPatternDevice == null ? null : BumpFactoryData.getForTemplate((DeviceTemplate)this.mPatternDevice.getTemplate(), (boolean)false);
        boolean editCenterMatrix = bfd != null && bfd.getFactoryType() == BumpFactoryData.BumpFactoryType.CENTER_MATRIX;
        boolean editPeriMatrix = bfd != null && bfd.getFactoryType() == BumpFactoryData.BumpFactoryType.PERIPHERAL_MATRIX;
        boolean editPeriRings = bfd != null && bfd.getFactoryType() == BumpFactoryData.BumpFactoryType.PERIPHERAL_RINGS;
        boolean editRatioDriven = bfd != null && bfd.getFactoryType() == BumpFactoryData.BumpFactoryType.RATIO_DRIVEN;
        this.mPnlCenterArray.mBtnCreate.setText(this.mPnlCenterArray.mBtnCreate.getText().replaceFirst("[^\\s]*", editCenterMatrix ? "Update" : "Create"));
        this.mPnlPeriMatrix.mBtnCreate.setText(this.mPnlPeriMatrix.mBtnCreate.getText().replaceFirst("[^\\s]*", editPeriMatrix ? "Update" : "Create"));
        this.mPnlPeriRings.mBtnCreate.setText(this.mPnlPeriRings.mBtnCreate.getText().replaceFirst("[^\\s]*", editPeriRings ? "Update" : "Create"));
        if (this.mPnlRatioDriven != null) {
            this.mPnlRatioDriven.mBtnCreate.setText(this.mPnlRatioDriven.mBtnCreate.getText().replaceFirst("[^\\s]*", editRatioDriven ? "Update" : "Create"));
        }
        if (bfd != null) {
            this.load(bfd);
        }
    }

    protected void updateNamingStrategy() {
        if (this.mCbNameScript.isSelected()) {
            this.mLblItemName.setText("Name script:");
            this.mBtnScriptHelp.setVisible(true);
            this.mTxtItemName.setToolTipText("Enter a script snippet that will return the name for each item. If a non-unique name is returned, a number will be appended to create a unique name.");
        } else {
            this.mLblItemName.setText("Name prefix:");
            this.mBtnScriptHelp.setVisible(false);
            this.mTxtItemName.setToolTipText("Set the base name for new items. A number will be appended to create a unique name for each item.");
        }
    }

    protected void validateBaseDialogSettings() throws AFieldValidator.AFieldValidationException {
        this.mPlaceableDefnUI.validateSettings();
        if (this.mTabs.getSelectedComponent() instanceof UsesCornerKeepoutsAndMargins) {
            AFieldValidator.validateDouble((JTextField)this.mTxtCornerClearX);
            AFieldValidator.validateDouble((JTextField)this.mTxtCornerClearY);
            AFieldValidator.validateDouble((JTextField)this.mTxtPadRight);
            AFieldValidator.validateDouble((JTextField)this.mTxtPadTop);
            AFieldValidator.validateDouble((JTextField)this.mTxtPadLeft);
            AFieldValidator.validateDouble((JTextField)this.mTxtPadBottom);
        }
    }

    protected Object eval(Interpreter intrp, String cmd, Object ... args) {
        return this.eval(intrp, true, cmd, args);
    }

    protected Object eval(Interpreter intrp, boolean escapeCmd, String cmd, Object ... args) {
        if (args.length > 0) {
            cmd = String.format(cmd, args);
        }
        if (escapeCmd) {
            cmd = AStringEscape.escapeJavaCode((String)cmd);
        }
        if (intrp != null) {
            try {
                return intrp.eval(cmd);
            }
            catch (EvalError ee) {
                ALog.logError((Throwable)ee, (String)"Error evaluating '%s'.", (Object[])new Object[]{cmd});
                return null;
            }
        }
        return Cp.exec((boolean)true, (boolean)escapeCmd, (String)cmd, (Object[])new Object[0]);
    }

    private static DeviceMatrixFactory getMatrixFactoryInCP() {
        return (DeviceMatrixFactory)Cp.exec((boolean)false, (boolean)false, (String)"matrixFactory;", (Object[])new Object[0]);
    }

    protected DeviceMatrixFactory initFactory(Unit unit, Device replaceCover) {
        return this.initFactory(null, unit, replaceCover);
    }

    protected DeviceMatrixFactory initFactory(Interpreter intrp, Unit unit, Device replaceCover) {
        String baseName;
        this.eval(intrp, "unset(\"matrixFactory\")", new Object[0]);
        this.eval(intrp, "com.sigrity.orbit.factory.DeviceMatrixFactory matrixFactory = new com.sigrity.orbit.factory.DeviceMatrixFactory(curDb(), \"%s\")", this.mPatternOwner.getKeyStr());
        DeviceMatrixFactory factory = null;
        try {
            Interpreter i = intrp == null ? Cp.getCp().getInterpreter() : intrp;
            factory = (DeviceMatrixFactory)i.get("matrixFactory");
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Error during matrixFactory creation.", (Object[])new Object[0]);
        }
        if (factory == null) {
            ALog.logError((Throwable)new IllegalStateException(), (String)"Failed to create DeviceMatrixFactory.", (Object[])new Object[0]);
            return null;
        }
        if (replaceCover != null && this.mPatternOwner.getChild(replaceCover.getName()) != null) {
            this.eval(intrp, "matrixFactory.deleteBumpCoverCell(\"%s\")", replaceCover.getName());
            replaceCover = null;
        }
        StringBuilder createPFCmds = new StringBuilder();
        for (String s : this.mPlaceableDefnUI.getFactoryCreationCmds()) {
            createPFCmds.append(s);
        }
        this.eval(intrp, false, "_createPlaceableFactory() { \n" + createPFCmds.toString() + "\n}", new Object[0]);
        this.eval(intrp, "matrixFactory.setPlaceableFactory(_createPlaceableFactory())", new Object[0]);
        float rot = 0.0f;
        try {
            rot = AUtil.floatFromString((String)AFieldValidator.validateFloat((JTextField)this.mTxtRotation));
        }
        catch (AFieldValidator.AFieldValidationException ve) {
            ALog.logError((String)"Invalid rotation, using 0.0.");
        }
        if ((double)rot != 0.0) {
            this.eval(intrp, "matrixFactory.setItemRotation((float) %f)", Float.valueOf(rot));
        }
        if (this.mCbMirror.isSelected()) {
            this.eval(intrp, "matrixFactory.setItemMirror(true)", new Object[0]);
        }
        if ((baseName = this.mTxtItemName.getText().trim()).length() > 0 && !baseName.equals("Bump")) {
            this.eval(intrp, "matrixFactory.setBumpBaseName(\"%s\")", AUtil.escapeDoubleQuotes((String)baseName));
        }
        if (this.mCbNameScript.isSelected()) {
            this.eval(intrp, "matrixFactory.setBumpNameIsScript(true)", new Object[0]);
        }
        if (this.mTabs.getSelectedComponent() instanceof UsesCornerKeepoutsAndMargins) {
            long cornerClearX = unit.fromUserString(this.mTxtCornerClearX.getText());
            long cornerClearY = unit.fromUserString(this.mTxtCornerClearY.getText());
            if (cornerClearX != 0L || cornerClearY != 0L) {
                this.eval(intrp, "matrixFactory.setCornerKeepouts(%dL, %dL)", cornerClearX, cornerClearY);
            }
            long padRight = unit.fromUserString(this.mTxtPadRight.getText());
            long padTop = unit.fromUserString(this.mTxtPadTop.getText());
            long padLeft = unit.fromUserString(this.mTxtPadLeft.getText());
            long padBottom = unit.fromUserString(this.mTxtPadBottom.getText());
            if (padRight != 0L || padTop != 0L || padLeft != 0L || padBottom != 0L) {
                this.eval(intrp, "matrixFactory.setPadding(%dL, %dL, %dL, %dL)", padLeft, padRight, padTop, padBottom);
            }
        }
        if (this.mCbStagger.isSelected()) {
            this.eval(intrp, "matrixFactory.setStagger(true)", new Object[0]);
        }
        return factory;
    }

    protected void releaseFactory() {
        Cp.exec((String)"unset(\"matrixFactory\")", (Object[])new Object[0]);
    }

    protected String getOwnerTypeName() {
        Object typeName = this.mPatternOwner.getType().toString();
        typeName = ((String)typeName).substring(0, 1).toUpperCase() + ((String)typeName).substring(1).toLowerCase();
        return typeName;
    }

    public static boolean isPatternCoverCell(DeviceTemplate dt) {
        return BumpFactoryData.getForTemplate((DeviceTemplate)dt, (boolean)false) != null;
    }

    public static BumpFactoryData.BumpFactoryType getPatternCoverCellType(DeviceTemplate dt) {
        BumpFactoryData d = BumpFactoryData.getForTemplate((DeviceTemplate)dt, (boolean)false);
        if (d == null) {
            return null;
        }
        return d.getFactoryType();
    }

    int toQuadIdx(int fld) {
        switch (fld) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return fld;
    }

    public static boolean addLoadListener(ProgressListener l) {
        return sLoadListener.add(l);
    }

    public static boolean removeLoadListener(ProgressListener l) {
        return sLoadListener.remove(l);
    }

    protected static void firePercentUpdate(int percent, boolean done, String data) {
        for (ProgressListener l : sLoadListener) {
            l.stats(percent, done, data);
        }
    }

    public static void updateProgress(boolean done, double percent, String data) {
        int iPercent = (int)(percent * 100.0);
        PatternPlacementUI.firePercentUpdate(iPercent, done, data);
    }

    static void bindFieldToTypeListener(ActionListenerForKeyPressInTextField a, JTextField field) {
        MyDocumentListener mdl = new MyDocumentListener(a);
        field.getDocument().addDocumentListener(mdl);
    }

    static class MyDocumentListener
    implements DocumentListener {
        ActionListenerForKeyPressInTextField l;

        public MyDocumentListener(ActionListenerForKeyPressInTextField l) {
            this.l = l;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.l.type();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.l.type();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.l.type();
        }
    }

    public static interface ActionListenerForKeyPressInTextField {
        public void type();
    }

    public static interface ProgressListener {
        public void stats(int var1, boolean var2, String var3);
    }

    protected class AutoFillRotationGroup
    extends AutoFillGroup {
        private AutoFillRotationGroup(JTextField[] group) {
            super(group);
        }

        @Override
        public void focusLost(JTextField tf, String text) {
            int idx = this.groupIndexOf(tf);
            if (idx < 0) {
                return;
            }
            if (text.trim().length() == 0) {
                return;
            }
            float r = AUtil.floatFromString((String)text);
            if (Float.isNaN(r)) {
                return;
            }
            AStream.zipWithIndex((Stream)AStream.of((Object[])this.mGroup)).forEach(fldIdx -> {
                if ((Long)fldIdx.second == (long)idx || ((JTextField)fldIdx.first).getText().trim().length() != 0) {
                    return;
                }
                int idxOff = PatternPlacementUI.this.toQuadIdx(((Long)fldIdx.second).intValue()) - PatternPlacementUI.this.toQuadIdx(idx);
                float newRot = ATransformUtil.normRot((float)(r + (float)(idxOff * 90)));
                ((JTextField)fldIdx.first).setText(AUtil.roundDoubleToStr((double)newRot));
            });
        }
    }

    protected class AutoFillDoubleGroup
    extends AutoFillGroup {
        private AutoFillDoubleGroup(JTextField[] group) {
            super(group);
        }

        @Override
        public void focusLost(JTextField tf, String text) {
            Unit unit = PatternPlacementUI.this.getUnitDist();
            Long l = unit.fromUserString(text);
            if (l == null) {
                return;
            }
            text = unit.toUserStr(l.longValue());
            for (JTextField f : this.mGroup) {
                if (f.getText().trim().length() != 0) continue;
                f.setText(text);
            }
        }
    }

    protected abstract class AutoFillGroup
    extends FocusAdapter {
        protected JTextField[] mGroup;

        private AutoFillGroup(JTextField[] group) {
            this.mGroup = group;
            for (JTextField tf : group) {
                tf.addFocusListener(this);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component c = e.getComponent();
            if (!(c instanceof JTextField)) {
                return;
            }
            JTextField tf = (JTextField)c;
            String text = tf.getText();
            this.focusLost(tf, text);
        }

        protected abstract void focusLost(JTextField var1, String var2);

        public int groupIndexOf(JTextField f) {
            return ((Long)AStream.zipWithIndex((Stream)AStream.of((Object[])this.mGroup)).filter((Predicate<APair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$groupIndexOf$0(javax.swing.JTextField com.sigrity.acl.APair ), (Lcom/sigrity/acl/APair;)Z)((JTextField)f)).findFirst().orElseGet((Supplier<APair>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$groupIndexOf$1(), ()Lcom/sigrity/acl/APair;)()).second).intValue();
        }

        private static /* synthetic */ APair lambda$groupIndexOf$1() {
            return APair.create((Object)null, (Object)-1L);
        }

        private static /* synthetic */ boolean lambda$groupIndexOf$0(JTextField f, APair fldIdx) {
            return fldIdx.first == f;
        }
    }

    protected class RatioDrivenPanel
    extends JPanel
    implements UsesPlacableItemBounds {
        protected JTextField width;
        protected JTextField height;
        protected JTextField numIO;
        protected JLabel requiredBumps;
        protected JButton mBtnCreate;
        protected JTextField bumpPitch;
        protected JTextField xPitch;
        protected JTextField yPitch;
        protected JTextField totalBumps;
        protected JButton calcWidth;
        protected JButton calcHeight;
        protected JButton calcXPitch;
        protected JButton calcYPitch;
        protected JButton calcTotalBumps;
        protected JButton calcRequired;
        protected JLabel widthLabel;
        protected JLabel heightLabel;
        protected JLabel pitchLabel;
        protected JLabel totalBumpsLabel;
        protected JComboBox<BumpRatioOptimizer.SignalPatternSynthesis> patternChoice;
        protected JTable ratioTable;
        static final int deleteColumn = 0;
        static final int netNameColumn = 1;
        static final int netUseColumn = 2;
        static final int shortedColumn = 3;
        static final int lockColumn = 4;
        static final int generatedColumn = 5;
        static final int biasColumn = 6;
        static final int ratioColumn = 7;
        protected RatioTableModel ratioTableModel;
        protected Substrate substrate;
        protected JProgressBar progressMeter;
        protected MyTextEditor textEditor;
        protected JTextField leftKeepout;
        protected JTextField rightKeepout;
        protected JTextField topKeepout;
        protected JTextField bottomKeepout;
        final Icon ICON_CALCULATOR = UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconCalc.png");
        private static final String TOOLTIP_DELETE = "Delete this rule of PG bumps generation.";
        private static final String TOOLTIP_ADD = "Add a new rule for PG bumps generation.";
        private static final String TOOLTIP_NETNAME = "The personality name. PG bumps generated by this rule would be associated with this personality.";
        private static final String TOOLTIP_SHORTED = "<html>Remember in the personality if all PG bumps generated by this rule should be connected to the same net at die level.<br>Or a unique net name would be created for each bump.</html>";
        private static final String TOOLTIP_RATIO = "Signal to PG ratio. This decides how many PG bumps would be generated. It is calculated by dividing the number of signal bumps divided by this number.";
        private static final String TOOLTIP_GENERATED = "Number of PG bumps would be generated by this rule, if locked.";
        private static final String TOOLTIP_LOCK = "Use the number specified in 'Required' when locked. Otherwise, would use 'Ratio' to calculate the number of PG bumps.";
        private static final String TOOLTIP_NETUSE = "Change the type of generated PG bumps. Either power or ground.";
        private static final String TOOLTIP_BIAS = "Placement locations preferrence, geometrically or electrically.";
        protected ActionListener mCalcWidth = e -> {
            Interpreter intrp = Cp.getCp().createChildInterpreter();
            Unit unit = PatternPlacementUI.this.getUnitDist();
            DeviceMatrixFactory dmf = PatternPlacementUI.this.initFactory(intrp, unit, null);
            dmf.setLeftKeepout(unit.fromUserString(this.leftKeepout.getText()));
            dmf.setRightKeepout(unit.fromUserString(this.rightKeepout.getText()));
            dmf.setBottomKeepout(unit.fromUserString(this.bottomKeepout.getText()));
            dmf.setTopKeepout(unit.fromUserString(this.topKeepout.getText()));
            dmf.setHeight(unit.fromUserString(this.height.getText()));
            dmf.setTotalBumps(Integer.parseInt(this.totalBumps.getText()));
            dmf.setMinPitch(unit.fromUserString(this.bumpPitch.getText()));
            dmf.setXPitch(unit.fromUserString(this.xPitch.getText()));
            dmf.setYPitch(unit.fromUserString(this.yPitch.getText()));
            Long num = dmf.calcWidth();
            this.width.setText(unit.toUserStr(num.longValue()));
        };
        protected ActionListener mCalcHeight = e -> {
            Interpreter intrp = Cp.getCp().createChildInterpreter();
            Unit unit = PatternPlacementUI.this.getUnitDist();
            DeviceMatrixFactory dmf = PatternPlacementUI.this.initFactory(intrp, unit, null);
            dmf.setLeftKeepout(unit.fromUserString(this.leftKeepout.getText()));
            dmf.setRightKeepout(unit.fromUserString(this.rightKeepout.getText()));
            dmf.setBottomKeepout(unit.fromUserString(this.bottomKeepout.getText()));
            dmf.setTopKeepout(unit.fromUserString(this.topKeepout.getText()));
            dmf.setWidth(unit.fromUserString(this.width.getText()));
            dmf.setTotalBumps(Integer.parseInt(this.totalBumps.getText()));
            dmf.setMinPitch(unit.fromUserString(this.bumpPitch.getText()));
            dmf.setXPitch(unit.fromUserString(this.xPitch.getText()));
            dmf.setYPitch(unit.fromUserString(this.yPitch.getText()));
            Long num = dmf.calcHeight();
            this.height.setText(unit.toUserStr(num.longValue()));
        };
        protected ActionListener mCalcXPitch = e -> {
            Interpreter intrp = Cp.getCp().createChildInterpreter();
            Unit unit = PatternPlacementUI.this.getUnitDist();
            DeviceMatrixFactory dmf = PatternPlacementUI.this.initFactory(intrp, unit, null);
            dmf.setLeftKeepout(unit.fromUserString(this.leftKeepout.getText()));
            dmf.setRightKeepout(unit.fromUserString(this.rightKeepout.getText()));
            dmf.setBottomKeepout(unit.fromUserString(this.bottomKeepout.getText()));
            dmf.setTopKeepout(unit.fromUserString(this.topKeepout.getText()));
            dmf.setWidth(unit.fromUserString(this.width.getText()));
            dmf.setHeight(unit.fromUserString(this.height.getText()));
            dmf.setMinPitch(unit.fromUserString(this.bumpPitch.getText()));
            dmf.setYPitch(unit.fromUserString(this.yPitch.getText()));
            dmf.setTotalBumps(Integer.parseInt(this.totalBumps.getText()));
            Long num = dmf.calcXPitch();
            this.xPitch.setText(unit.toUserStr(num.longValue()));
            this.enableCalcButtons();
        };
        protected ActionListener mCalcYPitch = e -> {
            Interpreter intrp = Cp.getCp().createChildInterpreter();
            Unit unit = PatternPlacementUI.this.getUnitDist();
            DeviceMatrixFactory dmf = PatternPlacementUI.this.initFactory(intrp, unit, null);
            dmf.setLeftKeepout(unit.fromUserString(this.leftKeepout.getText()));
            dmf.setRightKeepout(unit.fromUserString(this.rightKeepout.getText()));
            dmf.setBottomKeepout(unit.fromUserString(this.bottomKeepout.getText()));
            dmf.setTopKeepout(unit.fromUserString(this.topKeepout.getText()));
            dmf.setWidth(unit.fromUserString(this.width.getText()));
            dmf.setHeight(unit.fromUserString(this.height.getText()));
            dmf.setMinPitch(unit.fromUserString(this.bumpPitch.getText()));
            dmf.setXPitch(unit.fromUserString(this.xPitch.getText()));
            dmf.setTotalBumps(Integer.parseInt(this.totalBumps.getText()));
            Long num = dmf.calcYPitch();
            this.yPitch.setText(unit.toUserStr(num.longValue()));
            this.enableCalcButtons();
        };
        protected ActionListener mCalcTotalBumps = e -> {
            Interpreter intrp = Cp.getCp().createChildInterpreter();
            Unit unit = PatternPlacementUI.this.getUnitDist();
            DeviceMatrixFactory dmf = PatternPlacementUI.this.initFactory(intrp, unit, null);
            dmf.setLeftKeepout(unit.fromUserString(this.leftKeepout.getText()));
            dmf.setRightKeepout(unit.fromUserString(this.rightKeepout.getText()));
            dmf.setBottomKeepout(unit.fromUserString(this.bottomKeepout.getText()));
            dmf.setTopKeepout(unit.fromUserString(this.topKeepout.getText()));
            dmf.setWidth(unit.fromUserString(this.width.getText()));
            dmf.setHeight(unit.fromUserString(this.height.getText()));
            dmf.setMinPitch(unit.fromUserString(this.bumpPitch.getText()));
            dmf.setXPitch(unit.fromUserString(this.xPitch.getText()));
            dmf.setYPitch(unit.fromUserString(this.yPitch.getText()));
            Integer num = dmf.calcTotalBumps();
            this.totalBumps.setText(num.toString());
        };
        protected ActionListener mCalcRequired = e -> {
            this.textEditor.stopCellEditing();
            Interpreter intrp = Cp.getCp().createChildInterpreter();
            Unit unit = PatternPlacementUI.this.getUnitDist();
            DeviceMatrixFactory dmf = PatternPlacementUI.this.initFactory(intrp, unit, null);
            dmf.setNumIO(Integer.parseInt(this.numIO.getText()));
            String s = this.ratioDataToString().replaceAll("\"", "'");
            dmf.setRatioInstructions(s);
            String ratioData = dmf.calcRequired();
            this.toRatioTableRow(ratioData);
            this.postCalcRequired();
        };
        protected ActionListener mCreateAction = e -> {
            int potential;
            this.textEditor.stopCellEditing();
            try {
                PatternPlacementUI.this.validateBaseDialogSettings();
                AFieldValidator.validateDouble((JTextField)this.width);
                AFieldValidator.validateDouble((JTextField)this.height);
                AFieldValidator.validateDouble((JTextField)this.bumpPitch);
                AFieldValidator.validateInt((JTextField)this.numIO);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            int required = this.postCalcRequired();
            if (this.validInt(this.totalBumps) && (potential = Integer.parseInt(this.totalBumps.getText())) != required && !this.shouldContinueWithWarning(potential, required)) {
                return;
            }
            Unit unit = PatternPlacementUI.this.getUnitDist();
            if (PatternPlacementUI.this.mPatternDevice != null && PatternPlacementUI.this.mPatternDevice.getDb() != null) {
                Object name = null;
                name = PatternPlacementUI.this.mPatternDevice.getTemplate().getType().equals((Object)DeviceTemplate.Type.COVER) ? PatternPlacementUI.this.mPatternDevice.getName() : PatternPlacementUI.this.mPatternDevice.getName() + "_Cover";
                String deviceKeyString = PatternPlacementUI.this.mPatternDevice.getKeyStr();
                PatternPlacementUI.this.initFactory(unit, null);
                Object name_ = name;
                Cp.exec(() -> RatioDrivenPanel.lambda$new$23((String)name_), (String)"matrixFactory.setCustomName(\"%s\");", (Object[])new Object[]{name});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setDeviceKeyStr(deviceKeyString), (String)"matrixFactory.setDeviceKeyStr(\"%s\"); ", (Object[])new Object[]{deviceKeyString});
            } else {
                PatternPlacementUI.this.initFactory(unit, null);
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setCustomName("cover"), (String)"matrixFactory.setCustomName(\"%s\");", (Object[])new Object[]{"cover"});
            }
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setLeftKeepout(unit.fromUserString(this.leftKeepout.getText())), (String)"matrixFactory.setLeftKeepout(%dL);", (Object[])new Object[]{unit.fromUserString(this.leftKeepout.getText())});
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setRightKeepout(unit.fromUserString(this.rightKeepout.getText())), (String)"matrixFactory.setRightKeepout(%dL);", (Object[])new Object[]{unit.fromUserString(this.rightKeepout.getText())});
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setBottomKeepout(unit.fromUserString(this.bottomKeepout.getText())), (String)"matrixFactory.setBottomKeepout(%dL);", (Object[])new Object[]{unit.fromUserString(this.bottomKeepout.getText())});
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setTopKeepout(unit.fromUserString(this.topKeepout.getText())), (String)"matrixFactory.setTopKeepout(%dL);", (Object[])new Object[]{unit.fromUserString(this.topKeepout.getText())});
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setNumIO(Integer.parseInt(this.numIO.getText())), (String)"matrixFactory.setNumIO(%d);", (Object[])new Object[]{Integer.parseInt(this.numIO.getText())});
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setWidth(unit.fromUserString(this.width.getText())), (String)"matrixFactory.setWidth(%dL);", (Object[])new Object[]{unit.fromUserString(this.width.getText())});
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setHeight(unit.fromUserString(this.height.getText())), (String)"matrixFactory.setHeight(%dL);", (Object[])new Object[]{unit.fromUserString(this.height.getText())});
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setMinPitch(unit.fromUserString(this.bumpPitch.getText())), (String)"matrixFactory.setMinPitch(%dL);", (Object[])new Object[]{unit.fromUserString(this.bumpPitch.getText())});
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setXPitch(unit.fromUserString(this.xPitch.getText())), (String)"matrixFactory.setXPitch(%dL);", (Object[])new Object[]{unit.fromUserString(this.xPitch.getText())});
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setYPitch(unit.fromUserString(this.yPitch.getText())), (String)"matrixFactory.setYPitch(%dL);", (Object[])new Object[]{unit.fromUserString(this.yPitch.getText())});
            String s = this.ratioDataToString();
            String s_ = s = s.replaceAll("\"", "'");
            Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setRatioInstructions(s_), (String)"matrixFactory.setRatioInstructions(\"%s\");", (Object[])new Object[]{s});
            Device testDevice = (Device)Cp.exec((String)"matrixFactory.createRatioDriven()", (Object[])new Object[0]);
            if (testDevice != null) {
                PatternPlacementUI.this.mPatternDevice = testDevice;
            }
            String ratioInstructions = (String)Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().getRatioInstructions(), (String)"matrixFactory.getRatioInstructions();", (Object[])new Object[0]);
            this.toRatioTableRow(ratioInstructions);
            this.postCalcRequired();
            PatternPlacementUI.this.releaseFactory();
            PatternPlacementUI.this.updateCreateOrEdit();
        };

        private JTextField addNumberEntryTextField(String name, GridBagManager lArray, GridBagConstraints lcStatic, GridBagConstraints lcTxtEntry) {
            lArray.add((Component)new JLabel(name), lcStatic);
            JTextField textField = (JTextField)lArray.add((Component)new JTextField(5), lcTxtEntry);
            textField.setName(name);
            return textField;
        }

        public RatioDrivenPanel(Long defaultWidth, Long defaultHeight) {
            Cp.exec((String)"com.sigrity.orbit.automation.BumpRatioOptimizer.registerStandardPatterns()", (Object[])new Object[0]);
            Unit unit = PatternPlacementUI.this.getUnitDist();
            GridBagManager lArray = GridBagManager.layout((Container)this);
            lArray.pushFillXRemainX("Plan Calculator");
            GridBagManager.GridBagConstraintsEx lcStatic = GridBagManager.LEFT.insetVert(1);
            GridBagManager.GridBagConstraintsEx lcTxtEntry = GridBagManager.FILLX.insetVert(1);
            this.leftKeepout = this.addNumberEntryTextField("Left Keepout:", lArray, (GridBagConstraints)lcStatic, (GridBagConstraints)lcTxtEntry);
            lArray.add("", (GridBagConstraints)lcStatic);
            this.rightKeepout = this.addNumberEntryTextField("Right Keepout:", lArray, (GridBagConstraints)lcStatic, (GridBagConstraints)lcTxtEntry);
            lArray.newline();
            this.bottomKeepout = this.addNumberEntryTextField("Bottom Keepout:", lArray, (GridBagConstraints)lcStatic, (GridBagConstraints)lcTxtEntry);
            lArray.add("", (GridBagConstraints)lcStatic);
            this.topKeepout = this.addNumberEntryTextField("Top Keepout:", lArray, (GridBagConstraints)lcStatic, (GridBagConstraints)lcTxtEntry);
            lArray.newline();
            this.bumpPitch = this.addNumberEntryTextField("Min Pitch:", lArray, (GridBagConstraints)lcStatic, (GridBagConstraints)lcTxtEntry);
            this.bumpPitch.setToolTipText("<html>Preferred distance between bumps.<br>It is not a constraint.</html>");
            PatternPlacementUI.bindFieldToTypeListener(new CalcFieldsActionlister(), this.bumpPitch);
            lArray.add("", (GridBagConstraints)lcStatic);
            this.totalBumps = this.addNumberEntryTextField("Potential Bumps:", lArray, (GridBagConstraints)lcStatic, (GridBagConstraints)lcTxtEntry);
            PatternPlacementUI.bindFieldToTypeListener(new CalcFieldsActionlister(), this.totalBumps);
            this.calcTotalBumps = new JButton();
            this.calcTotalBumps.setIcon(this.ICON_CALCULATOR);
            this.calcTotalBumps.addActionListener(this.mCalcTotalBumps);
            lArray.add((Component)this.calcTotalBumps, (GridBagConstraints)lcStatic);
            lArray.newline();
            this.widthLabel = new JLabel("Width:");
            lArray.add((Component)this.widthLabel, (GridBagConstraints)lcStatic);
            this.width = (JTextField)lArray.add((Component)new JTextField(6), (GridBagConstraints)lcTxtEntry);
            this.width.setToolTipText("Width of the rectangel where all bumps are to be placed");
            if (defaultWidth != null) {
                this.width.setText(unit.toUserStr(defaultWidth.longValue()));
            }
            PatternPlacementUI.bindFieldToTypeListener(new CalcFieldsActionlister(), this.width);
            this.calcWidth = new JButton();
            this.calcWidth.setIcon(this.ICON_CALCULATOR);
            this.calcWidth.addActionListener(this.mCalcWidth);
            lArray.add((Component)this.calcWidth, (GridBagConstraints)lcStatic);
            this.heightLabel = new JLabel("Height:");
            lArray.add((Component)this.heightLabel, (GridBagConstraints)lcStatic);
            this.height = (JTextField)lArray.add((Component)new JTextField(6), (GridBagConstraints)lcTxtEntry);
            this.height.setToolTipText("Height of the rectangel where all bumps are to be placed");
            if (defaultHeight != null) {
                this.height.setText(unit.toUserStr(defaultHeight.longValue()));
            }
            PatternPlacementUI.bindFieldToTypeListener(new CalcFieldsActionlister(), this.height);
            this.calcHeight = new JButton();
            this.calcHeight.setIcon(this.ICON_CALCULATOR);
            this.calcHeight.addActionListener(this.mCalcHeight);
            lArray.add((Component)this.calcHeight, (GridBagConstraints)lcStatic);
            lArray.newline();
            this.xPitch = this.addNumberEntryTextField("X Pitch:", lArray, (GridBagConstraints)lcStatic, (GridBagConstraints)lcTxtEntry);
            this.xPitch.setToolTipText("Horizontal pitch between two bumps");
            PatternPlacementUI.bindFieldToTypeListener(new CalcFieldsActionlister(), this.xPitch);
            this.calcXPitch = new JButton();
            this.calcXPitch.setIcon(this.ICON_CALCULATOR);
            this.calcXPitch.addActionListener(this.mCalcXPitch);
            lArray.add((Component)this.calcXPitch, (GridBagConstraints)lcStatic);
            this.yPitch = this.addNumberEntryTextField("Y Pitch:", lArray, (GridBagConstraints)lcStatic, (GridBagConstraints)lcTxtEntry);
            this.yPitch.setToolTipText("Vertical pitch between two bumps");
            PatternPlacementUI.bindFieldToTypeListener(new CalcFieldsActionlister(), this.yPitch);
            this.calcYPitch = new JButton();
            this.calcYPitch.setIcon(this.ICON_CALCULATOR);
            this.calcYPitch.addActionListener(this.mCalcYPitch);
            lArray.add((Component)this.calcYPitch, (GridBagConstraints)lcStatic);
            lArray.pop();
            lArray.newline();
            lArray.pushFillAllRemainX("Generate Bumps");
            lArray.pushFillX();
            this.numIO = new JTextField(5);
            String nameNumIO = "Number of Signals:";
            this.numIO.setName(nameNumIO);
            lArray.add(nameNumIO);
            lArray.add((Component)this.numIO);
            PatternPlacementUI.bindFieldToTypeListener(new CalcFieldsActionlister(), this.numIO);
            this.requiredBumps = new JLabel("Required Bumps: 0");
            lArray.add((Component)this.requiredBumps);
            this.calcRequired = new JButton();
            this.calcRequired.setIcon(this.ICON_CALCULATOR);
            this.calcRequired.addActionListener(this.mCalcRequired);
            lArray.add((Component)this.calcRequired);
            lArray.addFillX();
            lArray.newline();
            lArray.popNl();
            int desiredWidth = 20;
            int desiredHeight = 80;
            this.ratioTable = this.addRatioTable(20, 80);
            JScrollPane scrollPane = new JScrollPane(this.ratioTable);
            scrollPane.setMinimumSize(new Dimension(20, 80));
            lArray.pushFill();
            lArray.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
            lArray.pop();
            lArray.newline();
            this.progressMeter = new JProgressBar(0, 100);
            this.progressMeter.setStringPainted(true);
            PatternPlacementUI.addLoadListener(new ProgressListener(){

                @Override
                public void stats(int percent, boolean done, String data) {
                    if (done) {
                        percent = 100;
                    }
                    RatioDrivenPanel.this.progressMeter.setValue(percent);
                    Object s = done ? data : percent + "% " + data;
                    RatioDrivenPanel.this.progressMeter.setString((String)s);
                    Dimension d = RatioDrivenPanel.this.progressMeter.getSize();
                    RatioDrivenPanel.this.progressMeter.paintImmediately(0, 0, d.width, d.height);
                }
            });
            lArray.pushFillXRemainX();
            JLabel patternLabel = new JLabel("Pattern");
            lArray.add((Component)patternLabel);
            this.patternChoice = new JComboBox();
            lArray.add(this.patternChoice);
            List<BumpRatioOptimizer.SignalPatternSynthesis> patternList = BumpRatioOptimizer.SignalPatternSynthesisRegistry.getRegistryList();
            for (BumpRatioOptimizer.SignalPatternSynthesis sps : patternList) {
                this.patternChoice.addItem(sps);
            }
            this.patternChoice.addActionListener(new PatternChoiceListener());
            this.patternChoice.setRenderer(new PatternChoiceRenderer());
            lArray.addFillX();
            this.mBtnCreate = (JButton)lArray.add((Component)new JButton("Update Ratio Driven"));
            this.mBtnCreate.addActionListener(this.mCreateAction);
            this.mBtnCreate.setFont(this.mBtnCreate.getFont().deriveFont(1));
            lArray.pop();
            lArray.pop();
            this.enableCalcButtons();
            this.setMinimumSize(this.getPreferredSize());
        }

        private Pair<Integer, Integer> getRowCol(JTable table, MouseEvent e) {
            TableColumnModel columnModel = table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / table.getRowHeight();
            return new Pair((Object)row, (Object)column);
        }

        private JTable addRatioTable(int desiredWidth, int desiredHeight) {
            JTable aRatioTable = new JTable(){

                @Override
                public String getToolTipText(MouseEvent e) {
                    Pair<Integer, Integer> rc = RatioDrivenPanel.this.getRowCol(this, e);
                    int column = (Integer)rc.getValue1();
                    int row = (Integer)rc.getValue0();
                    if (row >= 0 && row < this.getModel().getRowCount()) {
                        RatioTableModel model = (RatioTableModel)this.getModel();
                        return this.getToolTipText(model, row, column);
                    }
                    return super.getToolTipText();
                }

                private String getToolTipText(RatioTableModel model, int row, int col) {
                    if (col == 0) {
                        return model.isActive(row) ? RatioDrivenPanel.TOOLTIP_DELETE : RatioDrivenPanel.TOOLTIP_ADD;
                    }
                    if (col == 1) {
                        return RatioDrivenPanel.TOOLTIP_NETNAME;
                    }
                    if (col == 3) {
                        return RatioDrivenPanel.TOOLTIP_SHORTED;
                    }
                    if (col == 5) {
                        return RatioDrivenPanel.TOOLTIP_GENERATED;
                    }
                    if (col == 4) {
                        String s2 = "";
                        if (RatioDrivenPanel.this.ratioTableModel.isActive(row)) {
                            s2 = String.format("In this case, if locked then %d PG bumps would be generated.", RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).created);
                        }
                        return RatioDrivenPanel.TOOLTIP_LOCK + s2;
                    }
                    if (col == 2) {
                        String s2 = "";
                        if (RatioDrivenPanel.this.ratioTableModel.isActive(row)) {
                            s2 = String.format("Currently %s bumps would be generated.", RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).netUse == Net.Use.POWER ? "power" : "ground");
                        }
                        return RatioDrivenPanel.TOOLTIP_NETUSE + s2;
                    }
                    if (col == 6 && RatioDrivenPanel.this.ratioTableModel.isActive(row)) {
                        return model.ratioTableData.get((int)row).bias.getDescription();
                    }
                    if (col == 7) {
                        return RatioDrivenPanel.TOOLTIP_RATIO;
                    }
                    return super.getToolTipText();
                }
            };
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int columnWidth = metrics.charWidth('m');
            aRatioTable.setPreferredScrollableViewportSize(new Dimension(desiredWidth, desiredHeight));
            aRatioTable.setRowHeight(20);
            aRatioTable.setFillsViewportHeight(true);
            aRatioTable.getTableHeader().setReorderingAllowed(false);
            aRatioTable.setRowSelectionAllowed(false);
            aRatioTable.setAutoResizeMode(4);
            this.ratioTableModel = new RatioTableModel();
            aRatioTable.setModel(this.ratioTableModel);
            aRatioTable.setSelectionMode(0);
            aRatioTable.addMouseListener(new TableButtonMouseListener(aRatioTable));
            TableColumn col = aRatioTable.getColumnModel().getColumn(0);
            col.setPreferredWidth(20);
            col.setMaxWidth(20);
            col.setResizable(false);
            this.textEditor = new MyTextEditor();
            col = aRatioTable.getColumnModel().getColumn(1);
            col.setHeaderRenderer(new ColumnHeaderRender());
            col.setPreferredWidth(5 * columnWidth);
            col.setResizable(true);
            col.setCellEditor(this.textEditor);
            col = aRatioTable.getColumnModel().getColumn(2);
            col.setHeaderRenderer(new ColumnHeaderRender());
            col.setResizable(false);
            col.setPreferredWidth(20);
            col.setMaxWidth(20);
            col = aRatioTable.getColumnModel().getColumn(3);
            col.setHeaderRenderer(new ColumnHeaderRender());
            col.setResizable(false);
            col.setPreferredWidth(20);
            col.setMaxWidth(20);
            col = aRatioTable.getColumnModel().getColumn(7);
            col.setHeaderRenderer(new ColumnHeaderRender());
            col.setPreferredWidth(3 * columnWidth);
            col.setResizable(true);
            col.setCellEditor(this.textEditor);
            T[] list = BumpFactoryData.BumpBiasType.class.getEnumConstants();
            JComboBox<Object> box = new JComboBox<Object>();
            for (Object l : list) {
                box.addItem(l);
            }
            col = aRatioTable.getColumnModel().getColumn(6);
            col.setHeaderRenderer(new ColumnHeaderRender());
            col.setPreferredWidth(7 * columnWidth);
            col.setResizable(false);
            col.setCellEditor(new MyComboBoxEditor(box));
            col = aRatioTable.getColumnModel().getColumn(4);
            col.setHeaderRenderer(new ColumnHeaderRender());
            col.setHeaderRenderer(new ColumnHeaderRender());
            col.setResizable(false);
            col.setPreferredWidth(20);
            col.setMaxWidth(20);
            col = aRatioTable.getColumnModel().getColumn(5);
            col.setHeaderRenderer(new ColumnHeaderRender());
            col.setPreferredWidth(5 * columnWidth);
            col.setResizable(false);
            col.setCellEditor(this.textEditor);
            aRatioTable.setDefaultRenderer(Object.class, new RatioTableRenderer());
            return aRatioTable;
        }

        @Deprecated
        public RatioDrivenPanel() {
            this(null, null);
        }

        protected boolean validDouble(JTextField f) {
            String s = f.getText();
            try {
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.parse(s);
                f.setBackground(Color.WHITE);
                return true;
            }
            catch (ParseException e) {
                if (f.isEnabled()) {
                    f.setBackground(PatternPlacementUI.this.BackgroundColor_Error);
                } else {
                    f.setBackground(PatternPlacementUI.this.BackgroundColor_Disabled_Error);
                }
                return false;
            }
        }

        protected boolean validDoubleGreaterThan0(JTextField f) {
            String s = f.getText();
            try {
                NumberFormat nf = NumberFormat.getNumberInstance();
                Number n = nf.parse(s);
                if (n.doubleValue() <= 0.0) {
                    if (f.isEnabled()) {
                        f.setBackground(PatternPlacementUI.this.BackgroundColor_Error);
                    } else {
                        f.setBackground(PatternPlacementUI.this.BackgroundColor_Disabled_Error);
                    }
                    return false;
                }
                f.setBackground(Color.WHITE);
                return true;
            }
            catch (ParseException e) {
                if (f.isEnabled()) {
                    f.setBackground(PatternPlacementUI.this.BackgroundColor_Error);
                } else {
                    f.setBackground(PatternPlacementUI.this.BackgroundColor_Disabled_Error);
                }
                return false;
            }
        }

        protected boolean validIntGreaterThan0(JTextField f) {
            String s = f.getText();
            try {
                NumberFormat nf = NumberFormat.getNumberInstance();
                Number n = nf.parse(s);
                if (n.intValue() <= 0) {
                    if (f.isEnabled()) {
                        f.setBackground(PatternPlacementUI.this.BackgroundColor_Error);
                    } else {
                        f.setBackground(PatternPlacementUI.this.BackgroundColor_Disabled_Error);
                    }
                    return false;
                }
                f.setBackground(Color.WHITE);
                return true;
            }
            catch (ParseException e) {
                if (f.isEnabled()) {
                    f.setBackground(PatternPlacementUI.this.BackgroundColor_Error);
                } else {
                    f.setBackground(PatternPlacementUI.this.BackgroundColor_Disabled_Error);
                }
                return false;
            }
        }

        protected boolean validInt(JTextField f) {
            String s = f.getText();
            try {
                Integer.parseInt(s);
                f.setBackground(Color.WHITE);
                return true;
            }
            catch (NumberFormatException e) {
                if (f.isEnabled()) {
                    f.setBackground(PatternPlacementUI.this.BackgroundColor_Error);
                } else {
                    f.setBackground(PatternPlacementUI.this.BackgroundColor_Disabled_Error);
                }
                return false;
            }
        }

        protected void enableCalcButtons() {
            boolean validMinBumpPitch = this.validDoubleGreaterThan0(this.bumpPitch);
            this.width.setEnabled(validMinBumpPitch);
            this.height.setEnabled(validMinBumpPitch);
            this.totalBumps.setEnabled(validMinBumpPitch);
            this.xPitch.setEnabled(validMinBumpPitch);
            this.yPitch.setEnabled(validMinBumpPitch);
            this.calcHeight.setEnabled(false);
            this.calcWidth.setEnabled(false);
            this.calcTotalBumps.setEnabled(false);
            this.calcXPitch.setEnabled(false);
            this.calcYPitch.setEnabled(false);
            this.calcRequired.setEnabled(false);
            boolean validWidth = this.validDouble(this.width);
            boolean validHeight = this.validDouble(this.height);
            boolean validtotalBump = this.validInt(this.totalBumps);
            boolean validPitch = this.validDoubleGreaterThan0(this.bumpPitch);
            boolean validNumSignals = this.validIntGreaterThan0(this.numIO);
            boolean validXPitch = validPitch && this.validDoubleGreaterThan0(this.xPitch);
            boolean bl = validXPitch = validXPitch && Double.parseDouble(this.xPitch.getText()) >= Double.parseDouble(this.bumpPitch.getText());
            if (!validXPitch) {
                if (this.xPitch.isEnabled()) {
                    this.xPitch.setBackground(PatternPlacementUI.this.BackgroundColor_Error);
                } else {
                    this.xPitch.setBackground(PatternPlacementUI.this.BackgroundColor_Disabled_Error);
                }
            }
            boolean validYPitch = validPitch && this.validDoubleGreaterThan0(this.yPitch);
            boolean bl2 = validYPitch = validYPitch && Double.parseDouble(this.yPitch.getText()) >= Double.parseDouble(this.bumpPitch.getText());
            if (!validYPitch) {
                if (this.yPitch.isEnabled()) {
                    this.yPitch.setBackground(PatternPlacementUI.this.BackgroundColor_Error);
                } else {
                    this.yPitch.setBackground(PatternPlacementUI.this.BackgroundColor_Disabled_Error);
                }
            }
            boolean validBumpSetting = PatternPlacementUI.this.mPlaceableDefnUI.hasValidBumpSetting();
            if (!this.validDouble(PatternPlacementUI.this.mTxtCornerClearX)) {
                validBumpSetting = false;
            }
            if (!this.validDouble(PatternPlacementUI.this.mTxtCornerClearY)) {
                validBumpSetting = false;
            }
            if (validBumpSetting && validWidth && validHeight && validPitch && validXPitch && validYPitch) {
                this.calcTotalBumps.setEnabled(true);
            }
            if (validBumpSetting && validWidth && validHeight && validtotalBump && validYPitch) {
                this.calcXPitch.setEnabled(true);
            }
            if (validBumpSetting && validWidth && validHeight && validtotalBump && validXPitch) {
                this.calcYPitch.setEnabled(true);
            }
            if (validBumpSetting && validWidth && validPitch && validtotalBump && validXPitch && validYPitch) {
                this.calcHeight.setEnabled(true);
            }
            if (validBumpSetting && validHeight && validPitch && validtotalBump && validXPitch && validYPitch) {
                this.calcWidth.setEnabled(true);
            }
            if (validNumSignals) {
                this.calcRequired.setEnabled(true);
            }
            boolean okForCreate = false;
            if (validBumpSetting && validHeight && validWidth && validMinBumpPitch && validXPitch && validYPitch && validtotalBump) {
                Unit unit = Design.getUnit((Db)PatternPlacementUI.this.mDb);
                Cp.exec((boolean)false, (boolean)false, (String)"unset(\"matrixFactory\")", (Object[])new Object[0]);
                Cp.exec(() -> {
                    try {
                        DeviceMatrixFactory deviceMatrixFactory = new DeviceMatrixFactory(OrbitApp.getCurDb(), PatternPlacementUI.this.mPatternOwner.getKeyStr());
                    }
                    catch (LSession.NoLicenseException e) {
                        ALog.logError((String)"Error when creating DeviceMatrixFactory with %s.", (Object[])new Object[]{e.getMessage()});
                        return;
                    }
                }, (boolean)false, (boolean)false, (String)"com.sigrity.orbit.factory.DeviceMatrixFactory matrixFactory = new com.sigrity.orbit.factory.DeviceMatrixFactory(curDb(), \"%s\")", (Object[])new Object[]{PatternPlacementUI.this.mPatternOwner.getKeyStr()});
                StringBuilder createPFCmds = new StringBuilder();
                for (String s : PatternPlacementUI.this.mPlaceableDefnUI.getFactoryCreationCmds()) {
                    createPFCmds.append(s);
                }
                Cp.exec((boolean)false, (boolean)false, (String)("_createPlaceableFactory() { \n" + createPFCmds.toString() + "\n}"), (Object[])new Object[0]);
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setPlaceableFactory(null), (boolean)false, (boolean)false, (String)"matrixFactory.setPlaceableFactory(_createPlaceableFactory())", (Object[])new Object[0]);
                String baseName = PatternPlacementUI.this.mTxtItemName.getText().trim();
                if (baseName.length() > 0 && !baseName.equals("Bump")) {
                    Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setBumpBaseName(AUtil.escapeDoubleQuotes((String)baseName)), (boolean)true, (boolean)false, (String)"matrixFactory.setBumpBaseName(\"%s\")", (Object[])new Object[]{AUtil.escapeDoubleQuotes((String)baseName)});
                }
                if (PatternPlacementUI.this.mCbNameScript.isSelected()) {
                    Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setBumpNameIsScript(true), (boolean)false, (boolean)false, (String)"matrixFactory.setBumpNameIsScript(true)", (Object[])new Object[0]);
                }
                long cornerKeepoutX = unit.fromUserString(PatternPlacementUI.this.mTxtCornerClearX.getText());
                long cornerKeepoutY = unit.fromUserString(PatternPlacementUI.this.mTxtCornerClearY.getText());
                if (cornerKeepoutX != 0L || cornerKeepoutY != 0L) {
                    Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setCornerKeepouts(cornerKeepoutX, cornerKeepoutY), (boolean)false, (boolean)false, (String)"matrixFactory.setCornerKeepouts(%dL, %dL)", (Object[])new Object[]{cornerKeepoutX, cornerKeepoutY});
                }
                if (PatternPlacementUI.this.mCbStagger.isSelected()) {
                    Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setStagger(true), (boolean)false, (boolean)false, (String)"matrixFactory.setStagger(true)", (Object[])new Object[0]);
                }
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setHeight(unit.fromUserString(this.height.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setHeight(%dL);", (Object[])new Object[]{unit.fromUserString(this.height.getText())});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setWidth(unit.fromUserString(this.width.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setWidth(%dL);", (Object[])new Object[]{unit.fromUserString(this.width.getText())});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setTotalBumps(Integer.parseInt(this.totalBumps.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setTotalBumps(%d);", (Object[])new Object[]{Integer.parseInt(this.totalBumps.getText())});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setMinPitch(unit.fromUserString(this.bumpPitch.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setMinPitch(%dL);", (Object[])new Object[]{unit.fromUserString(this.bumpPitch.getText())});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setXPitch(unit.fromUserString(this.xPitch.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setXPitch(%dL);", (Object[])new Object[]{unit.fromUserString(this.xPitch.getText())});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setYPitch(unit.fromUserString(this.yPitch.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setYPitch(%dL);", (Object[])new Object[]{unit.fromUserString(this.yPitch.getText())});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setLeftKeepout(unit.fromUserString(this.leftKeepout.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setLeftKeepout(%dL);", (Object[])new Object[]{unit.fromUserString(this.leftKeepout.getText())});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setRightKeepout(unit.fromUserString(this.rightKeepout.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setRightKeepout(%dL);", (Object[])new Object[]{unit.fromUserString(this.rightKeepout.getText())});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setBottomKeepout(unit.fromUserString(this.bottomKeepout.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setBottomKeepout(%dL);", (Object[])new Object[]{unit.fromUserString(this.bottomKeepout.getText())});
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setTopKeepout(unit.fromUserString(this.topKeepout.getText())), (boolean)false, (boolean)false, (String)"matrixFactory.setTopKeepout(%dL);", (Object[])new Object[]{unit.fromUserString(this.topKeepout.getText())});
                Boolean canFit = (Boolean)Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().canFit(), (boolean)false, (boolean)false, (String)"matrixFactory.canFit()", (Object[])new Object[0]);
                if (Boolean.TRUE.equals(canFit)) {
                    okForCreate = true;
                }
            }
            this.mBtnCreate.setEnabled(okForCreate);
        }

        protected String ratioDataToString() {
            StringBuilder returnString = new StringBuilder();
            returnString.append("<RatioData>\n");
            for (RatioTableRow rtr : this.ratioTableModel.ratioTableData) {
                if (!rtr.active) continue;
                returnString.append(String.format("\t<RatioData net=\"%s\" netType=\"%s\" shorted=\"%b\" ratio=\"%d\" bias=\"%s\" created=\"%d\" locked=\"%b\"/>\n", rtr.netName, rtr.netUse.toString(), rtr.shorted, rtr.ratio, rtr.bias.toString(), rtr.created, rtr.locked));
            }
            returnString.append("</RatioData>\n");
            return returnString.toString();
        }

        protected int postCalcRequired() {
            int num = 0;
            for (RatioTableRow rtr : this.ratioTableModel.ratioTableData) {
                if (!rtr.active) continue;
                num += rtr.created;
            }
            this.requiredBumps.setText("Required Bumps: " + (num += Integer.parseInt(this.numIO.getText())));
            this.updateUI();
            return num;
        }

        protected void toRatioTableRow(String xml) {
            byte[] currentXMLBytes;
            ByteArrayInputStream byteArrayInputStream;
            Element root;
            this.ratioTableModel.ratioTableData.clear();
            if (xml != null && (root = AXDomUtil.getDocumentElement((InputStream)(byteArrayInputStream = new ByteArrayInputStream(currentXMLBytes = xml.getBytes())))) != null) {
                for (Element ratioData : AXDomUtil.getChildElems((Node)root, (String)"RatioData")) {
                    Boolean isShorted;
                    Optional p;
                    String netName = ratioData.getAttribute("net");
                    String ratio = ratioData.getAttribute("ratio");
                    String bias = ratioData.getAttribute("bias");
                    String created = ratioData.getAttribute("created");
                    String locked = ratioData.getAttribute("locked");
                    String netUseS = ratioData.getAttribute("netType");
                    String shorted = ratioData.getAttribute("shorted");
                    if (this.substrate == null) {
                        this.substrate = PatternPlacementUI.this.mPatternOwner.getSubstrate();
                    }
                    if ((p = Personality.getPersonality((DeviceTemplate)PatternPlacementUI.this.mPatternOwner, (Personality.Type)Personality.Type.PORT, (String)netName)).isPresent() && (isShorted = (Boolean)((Personality)p.get()).getValue("RatioDrivenShorted")) != null) {
                        shorted = isShorted.toString();
                    }
                    Net.Use netUse = Net.Use.POWER;
                    if (netUseS != null && !netUseS.isEmpty()) {
                        netUse = Net.Use.valueOf((String)netUseS);
                    }
                    if (created == null || created.isEmpty()) {
                        created = "0";
                    }
                    if (locked == null || locked.isEmpty()) {
                        locked = "false";
                    }
                    if (shorted == null || shorted.isEmpty()) {
                        shorted = "false";
                    }
                    RatioTableRow rtr = new RatioTableRow(netName, netUse, Boolean.parseBoolean(shorted), Integer.parseInt(ratio), BumpFactoryData.BumpBiasType.valueOf((String)bias), Integer.parseInt(created), Boolean.parseBoolean(locked));
                    this.ratioTableModel.ratioTableData.add(rtr);
                }
            }
            RatioTableRow rtr = new RatioTableRow();
            this.ratioTableModel.ratioTableData.add(rtr);
        }

        protected boolean shouldContinueWithWarning(int potential, int calculated) {
            Settings s = Settings.getSettings((String)"UserPreferences");
            boolean understands = (Boolean)s.getSetting("UserUnderstandsBumpWarning", (Object)false);
            if (understands) {
                return true;
            }
            MutableBoolean result = MutableBoolean.create((boolean)false);
            String msg = "<html>The bump plan calculator indicates a cover cell of " + potential + " potential bumps.<br>";
            msg = msg + "Based on the specified ratios and number of signals " + calculated + " bumps are required.<br>";
            msg = msg + "Due to this difference the cover cell construction may not be as intended.<br>";
            msg = msg + "Consider changing the Potential bumps to " + calculated + " and recalculate width/height/pitch.";
            final JButton btnOk = new JButton("Optimize");
            btnOk.setMnemonic('o');
            JButton btnCancel = new JButton("Cancel");
            btnCancel.setMnemonic('c');
            JDialog dlg = new JDialog(OrbitIO.getMainWindow(), Dialog.ModalityType.APPLICATION_MODAL){

                @Override
                public void addNotify() {
                    super.addNotify();
                    btnOk.requestFocus();
                }
            };
            dlg.setDefaultCloseOperation(2);
            dlg.setTitle("Potential Confusion");
            GridBagManager l = GridBagManager.layout((JDialog)dlg);
            l.addNl(msg);
            JCheckBox cbNoPrompt = (JCheckBox)l.addNl((Component)new JCheckBox("Do not display this message again."), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.pushFillXRemainX();
            l.addFillX();
            l.add((Component)btnOk);
            l.add((Component)btnCancel);
            l.pop();
            btnOk.addActionListener(e -> {
                result.setValue(true);
                if (cbNoPrompt.isSelected()) {
                    Settings ss = Settings.getSettings((String)"UserPreferences");
                    ss.putSetting("UserUnderstandsBumpWarning", (Object)true);
                    ss.save();
                }
                UIUtil.closeWindow((Window)dlg);
            });
            dlg.pack();
            dlg.setResizable(false);
            UIUtil.center((Component)dlg, (boolean)true);
            UIUtil.enableEscapeClose((Window)dlg, (AbstractButton)btnCancel);
            dlg.setVisible(true);
            return result.getValue();
        }

        @Override
        public void placableItemBoundsChanged() {
            this.enableCalcButtons();
        }

        private static /* synthetic */ void lambda$new$23(String name_) {
            PatternPlacementUI.getMatrixFactoryInCP().setCustomName(name_);
        }

        class RatioTableModel
        extends AbstractTableModel {
            private String[] columnNames = new String[]{"", "Net Name", "Type", "Shorted", "Locked", "Required", "Bias", "Ratio"};
            private ArrayList<RatioTableRow> ratioTableData = new ArrayList();

            RatioTableModel() {
            }

            public void populateFromBumpFactoryData(BumpFactoryData bfd) {
                this.ratioTableData.clear();
                RatioDrivenPanel.this.toRatioTableRow(bfd.getRatioInstructions());
                RatioDrivenPanel.this.postCalcRequired();
            }

            public void addNewRow() {
                this.ratioTableData.add(this.ratioTableData.size() - 1, new RatioTableRow("net", Net.Use.GROUND, true, 1, BumpFactoryData.BumpBiasType.NEAR_SIGNAL, 0, false));
            }

            public boolean isActive(int row) {
                return this.ratioTableData.get((int)row).active;
            }

            public void removeRow(int row) {
                this.ratioTableData.remove(row);
            }

            @Override
            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public int getRowCount() {
                return this.ratioTableData.size();
            }

            @Override
            public Object getValueAt(int arg0, int arg1) {
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (row == this.getRowCount() - 1) {
                    return false;
                }
                return col != 0 && col != 4 && col != 2 && col != 3;
            }

            String toString(int row, int col) {
                RatioTableRow rtr = this.ratioTableData.get(row);
                if (col == 1) {
                    return rtr.netName;
                }
                if (col == 7) {
                    return Integer.toString(rtr.ratio);
                }
                if (col == 5) {
                    return Integer.toString(rtr.created);
                }
                return "";
            }
        }

        public class ColumnHeaderRender
        implements TableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader jth = RatioDrivenPanel.this.ratioTable.getTableHeader();
                TableCellRenderer tcr = jth.getDefaultRenderer();
                if (tcr == null) {
                    return null;
                }
                Component component = tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel label = null;
                if (!(component instanceof JLabel)) {
                    return null;
                }
                label = (JLabel)component;
                if (column == 1) {
                    label.setToolTipText(RatioDrivenPanel.TOOLTIP_NETNAME);
                } else if (column == 5) {
                    label.setToolTipText(RatioDrivenPanel.TOOLTIP_GENERATED);
                } else if (column == 4) {
                    label.setText("");
                    label.setIcon(OrbitIcons.LOCK);
                    label.setToolTipText(RatioDrivenPanel.TOOLTIP_LOCK);
                } else if (column == 2) {
                    label.setText("T");
                    label.setToolTipText(RatioDrivenPanel.TOOLTIP_NETUSE);
                } else if (column == 3) {
                    label.setText("S");
                    label.setToolTipText(RatioDrivenPanel.TOOLTIP_SHORTED);
                } else if (column == 6) {
                    label.setToolTipText(RatioDrivenPanel.TOOLTIP_BIAS);
                } else if (column == 7) {
                    label.setToolTipText(RatioDrivenPanel.TOOLTIP_RATIO);
                } else {
                    label.setToolTipText(null);
                }
                return component;
            }
        }

        public class RatioTableRenderer
        extends DefaultTableCellRenderer {
            protected ArrayList<PinTemplate> ioPorts = null;
            protected DeviceTemplate lastDT = null;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
                RatioTableRow rtr = RatioDrivenPanel.this.ratioTableModel.ratioTableData.get(row);
                this.setToolTipText("");
                this.setIcon(null);
                this.setForeground(Color.BLACK);
                if (column == 0) {
                    this.rendererDeleteColumn(rtr);
                } else if (column == 1) {
                    this.rendererNetNameColumn(rtr);
                } else if (column == 2) {
                    this.rendererNetUseColumn(rtr);
                } else if (column == 3) {
                    this.rendererShortedColumn(rtr);
                } else if (column == 7) {
                    this.renderRatioColumn(rtr);
                } else if (column == 6) {
                    this.rendererBiasColumn(rtr);
                } else if (column == 5) {
                    this.rendererGeneratedColumn(rtr);
                } else if (column == 4) {
                    this.rendererLockedColumn(rtr);
                }
                return this;
            }

            private void rendererDeleteColumn(RatioTableRow rtr) {
                if (rtr.active) {
                    this.setIcon(OrbitIcons.DELETE);
                } else {
                    this.setIcon(OrbitIcons.ADD);
                }
            }

            private void rendererNetNameColumn(RatioTableRow rtr) {
                if (rtr.active) {
                    Optional p;
                    if (RatioDrivenPanel.this.substrate == null) {
                        RatioDrivenPanel.this.substrate = PatternPlacementUI.this.mPatternOwner.getSubstrate();
                    }
                    if ((p = Personality.getPersonality((DeviceTemplate)PatternPlacementUI.this.mPatternOwner, (Personality.Type)Personality.Type.PORT, (String)rtr.netName)).isPresent()) {
                        this.setIcon((Icon)new AColorIcon(10, 10, ((Personality)p.get()).getColor()));
                    }
                    this.setText(rtr.netName);
                } else {
                    this.setText("");
                }
            }

            private void rendererNetUseColumn(RatioTableRow rtr) {
                if (rtr.active) {
                    if (rtr.netUse == Net.Use.GROUND) {
                        this.setText("G");
                        this.setForeground(Color.BLACK);
                    } else if (rtr.netUse == Net.Use.POWER) {
                        this.setText("P");
                        this.setForeground(Color.RED);
                    } else if (rtr.netUse == Net.Use.SIGNAL) {
                        this.setText("S");
                        this.setForeground(Color.GREEN);
                    }
                } else {
                    this.setText("");
                }
            }

            private void rendererShortedColumn(RatioTableRow rtr) {
                if (rtr.active) {
                    this.setIcon((Icon)new AColorIcon(16, 16, Color.white, Color.white));
                    this.setText("");
                    boolean shorted = rtr.shorted;
                    if (shorted) {
                        this.setIcon(OrbitIcons.CHECK);
                    }
                } else {
                    this.setText("");
                }
            }

            private void renderRatioColumn(RatioTableRow rtr) {
                if (rtr.active) {
                    if (rtr.locked) {
                        this.setForeground(Color.GRAY);
                        this.setText("?");
                        if (RatioDrivenPanel.this.validIntGreaterThan0(RatioDrivenPanel.this.numIO) && rtr.created > 0) {
                            double actualRatio = (double)Integer.parseInt(RatioDrivenPanel.this.numIO.getText()) / (double)rtr.created;
                            String t = String.format("%5.2f", actualRatio);
                            this.setText(t);
                        }
                    } else {
                        this.setText(Integer.toString(rtr.ratio));
                    }
                } else {
                    this.setText("");
                }
            }

            private void rendererBiasColumn(RatioTableRow rtr) {
                if (rtr.active) {
                    this.setText(rtr.bias.toString());
                } else {
                    this.setText("");
                }
            }

            private void rendererGeneratedColumn(RatioTableRow rtr) {
                if (rtr.active) {
                    if (!rtr.locked) {
                        this.setForeground(Color.GRAY);
                    }
                    this.setText("" + rtr.created);
                } else {
                    this.setText("");
                }
            }

            private void rendererLockedColumn(RatioTableRow rtr) {
                this.setIcon((Icon)new AColorIcon(16, 16, Color.white, Color.white));
                this.setText("");
                boolean locked = rtr.locked;
                if (locked) {
                    this.setIcon(OrbitIcons.LOCK);
                }
            }
        }

        public class MyComboBoxEditor
        extends DefaultCellEditor {
            JComboBox<Object> myBox;
            int myRow;

            public MyComboBoxEditor(JComboBox<Object> box) {
                super(box);
                this.myRow = -1;
                this.myBox = box;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.myRow = row;
                return this.myBox;
            }

            @Override
            public boolean stopCellEditing() {
                boolean state = super.stopCellEditing();
                if (this.myRow >= 0) {
                    RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)this.myRow).bias = (BumpFactoryData.BumpBiasType)this.myBox.getSelectedItem();
                }
                return state;
            }
        }

        public class MyTextEditor
        extends AbstractCellEditor
        implements TableCellEditor {
            JComponent component = new JTextField();
            int row;
            int col;

            public MyTextEditor() {
                JTextField ftf = (JTextField)this.component;
                ftf.setBorder(new EditorBorder());
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
                this.row = rowIndex;
                this.col = vColIndex;
                String curValue = RatioDrivenPanel.this.ratioTableModel.toString(rowIndex, vColIndex);
                ((JTextField)this.component).setText(curValue);
                return this.component;
            }

            @Override
            public Object getCellEditorValue() {
                return ((JTextField)this.component).getText();
            }

            @Override
            public boolean stopCellEditing() {
                boolean state = super.stopCellEditing();
                if (this.col == 1) {
                    RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)this.row).netName = ((JTextField)this.component).getText();
                } else if (this.col == 7) {
                    String s = ((JTextField)this.component).getText();
                    try {
                        int r;
                        RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)this.row).ratio = r = Integer.parseInt(s);
                        RatioDrivenPanel.this.postCalcRequired();
                    }
                    catch (NumberFormatException e) {
                        ALog.logWarn((String)(s + " is not a valid integer"));
                    }
                } else if (this.col == 5) {
                    String s = ((JTextField)this.component).getText();
                    try {
                        int c;
                        RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)this.row).created = c = Integer.parseInt(s);
                        RatioDrivenPanel.this.postCalcRequired();
                    }
                    catch (NumberFormatException e) {
                        ALog.logWarn((String)(s + " is not a valid integer"));
                    }
                }
                return state;
            }
        }

        class EditorBorder
        extends AbstractBorder {
            protected Insets editorBorderInsets = new Insets(4, 2, 4, 0);

            EditorBorder() {
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                g.translate(x, y);
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, 0, 0, h - 2);
                g.drawLine(0, h - 2, w - 1, h - 2);
                g.setColor(MetalLookAndFeel.getControlHighlight());
                g.drawLine(1, 1, w - 1, 1);
                g.drawLine(1, 1, 1, h - 1);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.setColor(MetalLookAndFeel.getControl());
                g.drawLine(1, h - 2, 1, h - 2);
                g.translate(-x, -y);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return this.editorBorderInsets;
            }
        }

        class TableButtonMouseListener
        extends MouseAdapter {
            protected JTable table;
            JPopupMenu popup;

            public TableButtonMouseListener(JTable table) {
                this.table = table;
            }

            protected void showPopup(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                } else {
                    Pair<Integer, Integer> rc = RatioDrivenPanel.this.getRowCol(this.table, e);
                    int column = (Integer)rc.getValue1();
                    int row = (Integer)rc.getValue0();
                    if (row >= 0 && row < this.table.getModel().getRowCount()) {
                        if (column == 0) {
                            this.addOrDeleteRow(row);
                        } else if (column == 4) {
                            this.toggleLocked(row);
                        } else if (column == 2) {
                            this.changeToNextNetUse(row);
                        } else if (column == 3) {
                            this.toggleShorted(row);
                        }
                    }
                    RatioDrivenPanel.this.updateUI();
                }
            }

            private void addOrDeleteRow(int row) {
                if (RatioDrivenPanel.this.ratioTableModel.isActive(row)) {
                    RatioDrivenPanel.this.ratioTableModel.removeRow(row);
                    RatioDrivenPanel.this.postCalcRequired();
                } else {
                    RatioDrivenPanel.this.ratioTableModel.addNewRow();
                }
            }

            private void toggleLocked(int row) {
                if (RatioDrivenPanel.this.ratioTableModel.isActive(row)) {
                    RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).locked = !RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).locked;
                }
            }

            private void changeToNextNetUse(int row) {
                if (RatioDrivenPanel.this.ratioTableModel.isActive(row)) {
                    if (RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).netUse == Net.Use.POWER) {
                        RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).netUse = Net.Use.GROUND;
                    } else if (RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).netUse == Net.Use.GROUND) {
                        RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).netUse = Net.Use.POWER;
                    }
                }
            }

            private void toggleShorted(int row) {
                if (RatioDrivenPanel.this.ratioTableModel.isActive(row)) {
                    boolean shorted = RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).shorted;
                    RatioDrivenPanel.this.ratioTableModel.ratioTableData.get((int)row).shorted = shorted = !shorted;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }
        }

        class CalcFieldsActionlister
        implements ActionListenerForKeyPressInTextField {
            CalcFieldsActionlister() {
            }

            @Override
            public void type() {
                if (RatioDrivenPanel.this.isVisible()) {
                    RatioDrivenPanel.this.enableCalcButtons();
                }
            }
        }

        class PatternChoiceListener
        implements ActionListener {
            PatternChoiceListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                BumpRatioOptimizer.SignalPatternSynthesisRegistry.setSelected((BumpRatioOptimizer.SignalPatternSynthesis)RatioDrivenPanel.this.patternChoice.getSelectedItem());
            }
        }

        class PatternChoiceRenderer
        extends DefaultListCellRenderer {
            PatternChoiceRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                BumpRatioOptimizer.SignalPatternSynthesis sps = (BumpRatioOptimizer.SignalPatternSynthesis)value;
                this.setText(sps.name());
                this.setToolTipText(sps.description());
                return this;
            }
        }

        class RatioTableRow {
            String netName;
            Net.Use netUse;
            int ratio;
            BumpFactoryData.BumpBiasType bias;
            boolean active;
            int created;
            boolean locked;
            boolean shorted;

            public RatioTableRow() {
                this.active = false;
                this.netName = "";
                this.netUse = Net.Use.GROUND;
                this.shorted = true;
                this.ratio = 0;
                this.bias = null;
                this.locked = false;
                this.created = 0;
            }

            public RatioTableRow(String netName, Net.Use netUse, boolean shorted, int ratio, BumpFactoryData.BumpBiasType bias, int created, boolean locked) {
                this.active = true;
                this.netName = netName;
                this.netUse = netUse;
                this.shorted = shorted;
                this.ratio = ratio;
                this.bias = bias;
                this.created = created;
                this.locked = locked;
            }
        }
    }

    protected class PeriRingsPanel
    extends JPanel
    implements UsesCornerKeepoutsAndMargins {
        protected JPanel mCornerKeepoutsContainer;
        protected JTextField mTxtSweepPitch;
        protected JTextField mTxtRingPitch;
        protected JTextField mTxtRingCount;
        protected JTextField mTxtEdgeClearL;
        protected JTextField mTxtEdgeClearR;
        protected JTextField mTxtEdgeClearT;
        protected JTextField mTxtEdgeClearB;
        protected JTextField[] mEdgeClearFields;
        protected JTextField mTxtShiftL;
        protected JTextField mTxtShiftR;
        protected JTextField mTxtShiftT;
        protected JTextField mTxtShiftB;
        protected JTextField[] mShiftFields;
        protected JTextField mTxtRotateL;
        protected JTextField mTxtRotateR;
        protected JTextField mTxtRotateT;
        protected JTextField mTxtRotateB;
        protected JTextField[] mRotFields;
        protected JButton mBtnCreate;
        protected ActionListener mCreateAction = e -> {
            boolean rot;
            boolean shift;
            for (JTextField f : AUtil.getIterator((Object[][])new JTextField[][]{this.mEdgeClearFields, this.mShiftFields})) {
                if (f.getText().trim().length() != 0) continue;
                f.setText("0");
                f.paintImmediately(0, 0, f.getWidth(), f.getHeight());
            }
            try {
                PatternPlacementUI.this.validateBaseDialogSettings();
                AFieldValidator.validateDouble((JTextField)this.mTxtSweepPitch);
                AFieldValidator.validateDouble((JTextField)this.mTxtRingPitch);
                AFieldValidator.validateInt((JTextField)this.mTxtRingCount);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearL);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearR);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearT);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearB);
                AFieldValidator.validateDouble((JTextField)this.mTxtShiftL);
                AFieldValidator.validateDouble((JTextField)this.mTxtShiftR);
                AFieldValidator.validateDouble((JTextField)this.mTxtShiftT);
                AFieldValidator.validateDouble((JTextField)this.mTxtShiftB);
                AFieldValidator.validateDouble((JTextField)this.mTxtRotateL);
                AFieldValidator.validateDouble((JTextField)this.mTxtRotateR);
                AFieldValidator.validateDouble((JTextField)this.mTxtRotateT);
                AFieldValidator.validateDouble((JTextField)this.mTxtRotateB);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            Unit unit = PatternPlacementUI.this.getUnitDist();
            PatternPlacementUI.this.initFactory(unit, PatternPlacementUI.this.mPatternDevice);
            boolean bl = shift = AUtil.doubleFromString((String)this.mTxtShiftL.getText()) != 0.0 || AUtil.doubleFromString((String)this.mTxtShiftR.getText()) != 0.0 || AUtil.doubleFromString((String)this.mTxtShiftT.getText()) != 0.0 || AUtil.doubleFromString((String)this.mTxtShiftB.getText()) != 0.0;
            if (shift) {
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setShift(unit.fromUserString(this.mTxtShiftL.getText()), unit.fromUserString(this.mTxtShiftR.getText()), unit.fromUserString(this.mTxtShiftT.getText()), unit.fromUserString(this.mTxtShiftB.getText())), (String)"matrixFactory.setShift(%dL, %dL, %dL, %dL)", (Object[])new Object[]{unit.fromUserString(this.mTxtShiftL.getText()), unit.fromUserString(this.mTxtShiftR.getText()), unit.fromUserString(this.mTxtShiftT.getText()), unit.fromUserString(this.mTxtShiftB.getText())});
            }
            boolean bl2 = rot = AUtil.doubleFromString((String)this.mTxtRotateL.getText()) != 0.0 || AUtil.doubleFromString((String)this.mTxtRotateR.getText()) != 0.0 || AUtil.doubleFromString((String)this.mTxtRotateT.getText()) != 0.0 || AUtil.doubleFromString((String)this.mTxtRotateB.getText()) != 0.0;
            if (rot) {
                Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().setRotate(AUtil.floatFromString((String)this.mTxtRotateL.getText()), AUtil.floatFromString((String)this.mTxtRotateR.getText()), AUtil.floatFromString((String)this.mTxtRotateT.getText()), AUtil.floatFromString((String)this.mTxtRotateB.getText())), (String)"matrixFactory.setRotate(%ff, %ff, %ff, %ff)", (Object[])new Object[]{Float.valueOf(AUtil.floatFromString((String)this.mTxtRotateL.getText())), Float.valueOf(AUtil.floatFromString((String)this.mTxtRotateR.getText())), Float.valueOf(AUtil.floatFromString((String)this.mTxtRotateT.getText())), Float.valueOf(AUtil.floatFromString((String)this.mTxtRotateB.getText()))});
            }
            PatternPlacementUI.this.mPatternDevice = (Device)Cp.exec(() -> PatternPlacementUI.getMatrixFactoryInCP().createPeripheralRings(Integer.parseInt(this.mTxtRingCount.getText()), unit.fromUserString(this.mTxtEdgeClearL.getText()), unit.fromUserString(this.mTxtEdgeClearR.getText()), unit.fromUserString(this.mTxtEdgeClearT.getText()), unit.fromUserString(this.mTxtEdgeClearB.getText()), unit.fromUserString(this.mTxtSweepPitch.getText()), unit.fromUserString(this.mTxtRingPitch.getText())), (String)"matrixFactory.createPeripheralRings(%s, %dL, %dL, %dL, %dL, %dL, %dL)", (Object[])new Object[]{this.mTxtRingCount.getText(), unit.fromUserString(this.mTxtEdgeClearL.getText()), unit.fromUserString(this.mTxtEdgeClearR.getText()), unit.fromUserString(this.mTxtEdgeClearT.getText()), unit.fromUserString(this.mTxtEdgeClearB.getText()), unit.fromUserString(this.mTxtSweepPitch.getText()), unit.fromUserString(this.mTxtRingPitch.getText())});
            PatternPlacementUI.this.releaseFactory();
            PatternPlacementUI.this.updateCreateOrEdit();
        };

        public PeriRingsPanel() {
            GridBagManager l = GridBagManager.layout((Container)this);
            this.mTxtSweepPitch = (JTextField)l.add("Item Pitch:", (Component)new JTextField(10));
            this.mTxtRingPitch = (JTextField)l.add("Ring Pitch:", (Component)new JTextField(10));
            l.newline();
            this.mTxtRingCount = (JTextField)l.add("Ring count:", (Component)new JTextField(5));
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.advance();
            l.add(String.format("Edge Clearance %s", PatternPlacementUI.this.getOwnerTypeName()), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            l.add("CCW Shift", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            l.add("Added Rotation", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            l.newline();
            l.add("Left");
            this.mTxtEdgeClearL = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtShiftL = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtRotateL = (JTextField)l.add((Component)new JTextField(10));
            l.newline();
            l.add("Right");
            this.mTxtEdgeClearR = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtShiftR = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtRotateR = (JTextField)l.add((Component)new JTextField(10));
            l.newline();
            l.add("Top");
            this.mTxtEdgeClearT = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtShiftT = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtRotateT = (JTextField)l.add((Component)new JTextField(10));
            l.newline();
            l.add("Bottom");
            this.mTxtEdgeClearB = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtShiftB = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtRotateB = (JTextField)l.add((Component)new JTextField(10));
            l.popNl();
            this.mCornerKeepoutsContainer = (JPanel)l.add((Component)new JPanel(new BorderLayout()), (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            l.addFillY();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnCreate = (JButton)l.add((Component)new JButton("Create Peripheral Rings"));
            this.mBtnCreate.addActionListener(this.mCreateAction);
            this.mBtnCreate.setFont(this.mBtnCreate.getFont().deriveFont(1));
            l.pop();
            this.mEdgeClearFields = new JTextField[]{this.mTxtEdgeClearL, this.mTxtEdgeClearR, this.mTxtEdgeClearT, this.mTxtEdgeClearB};
            new AutoFillDoubleGroup(this.mEdgeClearFields);
            this.mShiftFields = new JTextField[]{this.mTxtShiftL, this.mTxtShiftR, this.mTxtShiftT, this.mTxtShiftB};
            new AutoFillDoubleGroup(this.mShiftFields);
            this.mRotFields = new JTextField[]{this.mTxtRotateL, this.mTxtRotateR, this.mTxtRotateT, this.mTxtRotateB};
            new AutoFillRotationGroup(this.mRotFields);
        }

        @Override
        public void installCornerKeepoutsAndMargins(JPanel ckp) {
            this.mCornerKeepoutsContainer.add(ckp);
        }
    }

    protected class PeriMatrixPanel
    extends JPanel
    implements UsesCornerKeepoutsAndMargins {
        protected JPanel mCornerKeepoutsContainer;
        protected JTextField mTxtRingCount;
        protected JTextField mTxtEdgeClearL;
        protected JTextField mTxtEdgeClearR;
        protected JTextField mTxtEdgeClearT;
        protected JTextField mTxtEdgeClearB;
        protected JTextField[] mEdgeClearFields;
        protected JTextField mTxtPitchX;
        protected JTextField mTxtPitchY;
        protected JButton mBtnCreate;
        protected ActionListener mCreateAction = e -> {
            for (JTextField f : this.mEdgeClearFields) {
                if (f.getText().trim().length() != 0) continue;
                f.setText("0");
                f.paintImmediately(0, 0, f.getWidth(), f.getHeight());
            }
            try {
                PatternPlacementUI.this.validateBaseDialogSettings();
                AFieldValidator.validateDouble((JTextField)this.mTxtPitchX);
                AFieldValidator.validateDouble((JTextField)this.mTxtPitchY);
                AFieldValidator.validateInt((JTextField)this.mTxtRingCount);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearL);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearR);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearT);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearB);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            Unit unit = PatternPlacementUI.this.getUnitDist();
            PatternPlacementUI.this.initFactory(unit, PatternPlacementUI.this.mPatternDevice);
            PatternPlacementUI.this.mPatternDevice = (Device)Cp.exec(() -> {
                DeviceMatrixFactory dmf = PatternPlacementUI.getMatrixFactoryInCP();
                dmf.createPeripheralMatrix(Integer.parseInt(this.mTxtRingCount.getText()), unit.fromUserString(this.mTxtEdgeClearL.getText()), unit.fromUserString(this.mTxtEdgeClearR.getText()), unit.fromUserString(this.mTxtEdgeClearT.getText()), unit.fromUserString(this.mTxtEdgeClearB.getText()), unit.fromUserString(this.mTxtPitchX.getText()), unit.fromUserString(this.mTxtPitchY.getText()));
            }, (String)"matrixFactory.createPeripheralMatrix(%s, %dL, %dL, %dL, %dL, %dL, %dL)", (Object[])new Object[]{this.mTxtRingCount.getText(), unit.fromUserString(this.mTxtEdgeClearL.getText()), unit.fromUserString(this.mTxtEdgeClearR.getText()), unit.fromUserString(this.mTxtEdgeClearT.getText()), unit.fromUserString(this.mTxtEdgeClearB.getText()), unit.fromUserString(this.mTxtPitchX.getText()), unit.fromUserString(this.mTxtPitchY.getText())});
            PatternPlacementUI.this.releaseFactory();
            PatternPlacementUI.this.updateCreateOrEdit();
        };

        public PeriMatrixPanel() {
            GridBagManager l = GridBagManager.layout((Container)this);
            this.mTxtPitchX = (JTextField)l.add("Pitch X:", (Component)new JTextField(10));
            this.mTxtPitchY = (JTextField)l.add("Pitch Y:", (Component)new JTextField(10));
            l.newline();
            this.mTxtRingCount = (JTextField)l.add("Ring count:", (Component)new JTextField(5));
            l.newline();
            l.addNl(String.format("Minimum %s Edge Clearance", PatternPlacementUI.this.getOwnerTypeName()), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
            l.add("Left:", (GridBagConstraints)GridBagManager.LEFT.insetLeft(12).insetVert(0));
            this.mTxtEdgeClearL = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
            l.add("Top:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            this.mTxtEdgeClearT = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            l.newline();
            l.add("Right:", (GridBagConstraints)GridBagManager.LEFT.insetLeft(12).insetBottom(0));
            this.mTxtEdgeClearR = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            l.add("Bottom:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            this.mTxtEdgeClearB = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            l.newline();
            this.mCornerKeepoutsContainer = (JPanel)l.add((Component)new JPanel(new BorderLayout()), (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            l.addFillY();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnCreate = (JButton)l.add((Component)new JButton("Create Peripheral Matrix"));
            this.mBtnCreate.addActionListener(this.mCreateAction);
            this.mBtnCreate.setFont(this.mBtnCreate.getFont().deriveFont(1));
            l.pop();
            this.mEdgeClearFields = new JTextField[]{this.mTxtEdgeClearL, this.mTxtEdgeClearR, this.mTxtEdgeClearT, this.mTxtEdgeClearB};
            new AutoFillDoubleGroup(this.mEdgeClearFields);
        }

        @Override
        public void installCornerKeepoutsAndMargins(JPanel ckp) {
            this.mCornerKeepoutsContainer.add(ckp);
        }
    }

    protected class CenterArrayPanel
    extends JPanel
    implements UsesCornerKeepoutsAndMargins,
    UsesPlacableItemBounds {
        protected JPanel mCornerKeepoutsContainer;
        protected MonitoredTextField mTxtDX;
        protected MonitoredTextField mTxtDY;
        protected MonitoredTextField mTxtCols;
        protected MonitoredTextField mTxtRows;
        protected MonitoredTextField mTxtEdgeClearL;
        protected MonitoredTextField mTxtEdgeClearR;
        protected MonitoredTextField mTxtEdgeClearT;
        protected MonitoredTextField mTxtEdgeClearB;
        protected MonitoredTextField[] mEdgeClearFields;
        protected HashSet<MonitoredTextField> mHorizFields = new HashSet();
        protected HashSet<MonitoredTextField> mVertFields = new HashSet();
        protected JTextField mTxtMinBumpPitch;
        protected JLabel mLblCount;
        protected JButton mBtnRecenter;
        protected JButton mBtnCreate;
        protected ActionListener mRecenter = e -> {
            for (MonitoredTextField t : this.mEdgeClearFields) {
                t.clearAndReset();
            }
            this.recalc(null);
        };
        protected ActionListener mCreateAction = e -> {
            Unit unit;
            try {
                PatternPlacementUI.this.validateBaseDialogSettings();
                this.recalc(null);
                this.mInMonitoredFieldUpdate = true;
                AFieldValidator.validateDouble((JTextField)this.mTxtDX);
                AFieldValidator.validateDouble((JTextField)this.mTxtDY);
                AFieldValidator.validateInt((JTextField)this.mTxtCols, (int)1, (int)Integer.MAX_VALUE);
                AFieldValidator.validateInt((JTextField)this.mTxtRows, (int)1, (int)Integer.MAX_VALUE);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearL);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearR);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearT);
                AFieldValidator.validateDouble((JTextField)this.mTxtEdgeClearB);
                unit = PatternPlacementUI.this.getUnitDist();
                Long pitchX = this.getUserDbDist(unit, this.mTxtDX);
                Long pitchY = this.getUserDbDist(unit, this.mTxtDY);
                ARect itemBounds = this.getPlaceableBounds();
                if (itemBounds.width() + pitchX <= 0L) {
                    throw AFieldValidator.createException(null, (String)"Pitch X (<= item width)", null, (Component)this.mTxtDX);
                }
                if (itemBounds.height() + pitchY <= 0L) {
                    throw AFieldValidator.createException(null, (String)"Pitch Y (<= item height)", null, (Component)this.mTxtDY);
                }
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            finally {
                this.mInMonitoredFieldUpdate = false;
            }
            unit = PatternPlacementUI.this.getUnitDist();
            PatternPlacementUI.this.initFactory(unit, PatternPlacementUI.this.mPatternDevice);
            Cp.exec((String)"matrixFactory.setMinPitch(%dL)", (Object[])new Object[]{unit.fromUserString(this.mTxtMinBumpPitch.getText())});
            PatternPlacementUI.this.mPatternDevice = (Device)Cp.exec(() -> {
                DeviceMatrixFactory dmf = PatternPlacementUI.getMatrixFactoryInCP();
                dmf.createCenterMatrix(unit.fromUserString(this.mTxtEdgeClearL.getText()), unit.fromUserString(this.mTxtEdgeClearR.getText()), unit.fromUserString(this.mTxtEdgeClearT.getText()), unit.fromUserString(this.mTxtEdgeClearB.getText()), unit.fromUserString(this.mTxtDX.getText()), unit.fromUserString(this.mTxtDY.getText()));
            }, (String)"matrixFactory.createCenterMatrix(%dL, %dL, %dL, %dL, %dL, %dL)", (Object[])new Object[]{unit.fromUserString(this.mTxtEdgeClearL.getText()), unit.fromUserString(this.mTxtEdgeClearR.getText()), unit.fromUserString(this.mTxtEdgeClearT.getText()), unit.fromUserString(this.mTxtEdgeClearB.getText()), unit.fromUserString(this.mTxtDX.getText()), unit.fromUserString(this.mTxtDY.getText())});
            PatternPlacementUI.this.releaseFactory();
            PatternPlacementUI.this.updateCreateOrEdit();
        };
        protected long mMonitoredFieldModCounter = 0L;
        protected boolean mInMonitoredFieldUpdate = false;

        public CenterArrayPanel() {
            GridBagManager l = GridBagManager.layout((Container)this);
            l.push((GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mTxtDX = (MonitoredTextField)l.add("Pitch X:", (Component)new MonitoredTextField(10));
            this.mTxtDY = (MonitoredTextField)l.add("Pitch Y:", (Component)new MonitoredTextField(10));
            l.newline();
            this.mTxtCols = (MonitoredTextField)l.add("Columns:", (Component)new MonitoredTextField(10));
            this.mTxtRows = (MonitoredTextField)l.add("Rows:", (Component)new MonitoredTextField(10));
            l.newline();
            l.popNl();
            l.push((GridBagConstraints)GridBagManager.LEFT.noInsets());
            l.add(String.format("Minimum %s Edge Clearance", PatternPlacementUI.this.getOwnerTypeName()), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).width(2));
            this.mBtnRecenter = (JButton)l.add((Component)UIUtil.makeTinyButton((String)"Recenter"), (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            this.mBtnRecenter.setToolTipText("Recalculate edge clearances to center the matrix");
            this.mBtnRecenter.addActionListener(this.mRecenter);
            this.mBtnRecenter.setEnabled(false);
            l.popNl();
            l.push((GridBagConstraints)GridBagManager.LEFT.noInsets());
            l.add("Left:", (GridBagConstraints)GridBagManager.LEFT.insetLeft(12));
            this.mTxtEdgeClearL = (MonitoredTextField)l.add((Component)new MonitoredTextField(10));
            this.mTxtEdgeClearT = (MonitoredTextField)l.add("Top:", (Component)new MonitoredTextField(10));
            l.newline();
            l.add("Right:", (GridBagConstraints)GridBagManager.LEFT.insetLeft(12));
            this.mTxtEdgeClearR = (MonitoredTextField)l.add((Component)new MonitoredTextField(10));
            this.mTxtEdgeClearB = (MonitoredTextField)l.add("Bottom:", (Component)new MonitoredTextField(10));
            l.newline();
            l.popNl();
            this.mCornerKeepoutsContainer = (JPanel)l.add((Component)new JPanel(new BorderLayout()), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mTxtMinBumpPitch = new JTextField(10);
            this.mTxtMinBumpPitch.setText("0.00");
            l.add("Min Bump Pitch:", (Component)this.mTxtMinBumpPitch);
            l.popNl();
            l.addFillY();
            l.pushFillXRemainX();
            l.add("Count:");
            this.mLblCount = (JLabel)l.add((Component)new JLabel("-"));
            l.addFillX();
            this.mBtnCreate = (JButton)l.add((Component)new JButton("Create Center Matrix"));
            this.mBtnCreate.addActionListener(this.mCreateAction);
            this.mBtnCreate.setFont(this.mBtnCreate.getFont().deriveFont(1));
            l.pop();
            this.mEdgeClearFields = new MonitoredTextField[]{this.mTxtEdgeClearL, this.mTxtEdgeClearR, this.mTxtEdgeClearT, this.mTxtEdgeClearB};
            this.mHorizFields.addAll(Arrays.asList(this.mTxtCols, this.mTxtDX, this.mTxtEdgeClearL, this.mTxtEdgeClearR));
            this.mVertFields.addAll(Arrays.asList(this.mTxtRows, this.mTxtDY, this.mTxtEdgeClearT, this.mTxtEdgeClearB));
        }

        @Override
        public void installCornerKeepoutsAndMargins(JPanel ckp) {
            this.mCornerKeepoutsContainer.add(ckp);
            final DocumentListener docListener = new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CenterArrayPanel.this.updateControls();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CenterArrayPanel.this.updateControls();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    CenterArrayPanel.this.updateControls();
                }
            };
            PatternPlacementUI.this.mTxtCornerClearX.getDocument().addDocumentListener(docListener);
            PatternPlacementUI.this.mTxtCornerClearY.getDocument().addDocumentListener(docListener);
            this.mCornerKeepoutsContainer.addContainerListener(new ContainerAdapter(){

                @Override
                public void componentRemoved(ContainerEvent e) {
                    PatternPlacementUI.this.mTxtCornerClearX.getDocument().removeDocumentListener(docListener);
                    PatternPlacementUI.this.mTxtCornerClearY.getDocument().removeDocumentListener(docListener);
                    CenterArrayPanel.this.mCornerKeepoutsContainer.removeContainerListener(this);
                }
            });
        }

        protected Long getUserDbDist(Unit unit, JTextField txt) {
            String s = txt.getText();
            return s == null || s.isEmpty() ? null : unit.fromUserString(s);
        }

        protected void recalc(Component updated) {
            if (updated == null) {
                this.mInMonitoredFieldUpdate = true;
                try {
                    this.recalcHorizontal(null);
                    this.recalcVertical(null);
                }
                finally {
                    this.mInMonitoredFieldUpdate = false;
                }
            } else if (this.mHorizFields.contains(updated)) {
                this.recalcHorizontal(updated);
            } else if (this.mVertFields.contains(updated)) {
                this.recalcVertical(updated);
            }
            this.updateControls();
        }

        protected void recalcHorizontal(Component updated) {
            this.recalc(updated, PatternPlacementUI.this.mPatternOwner.getBB().width(), this.getPlaceableBounds().width(), this.mTxtCols, this.mTxtDX, this.mTxtEdgeClearL, this.mTxtEdgeClearR);
        }

        protected void recalcVertical(Component updated) {
            this.recalc(updated, PatternPlacementUI.this.mPatternOwner.getBB().height(), this.getPlaceableBounds().height(), this.mTxtRows, this.mTxtDY, this.mTxtEdgeClearT, this.mTxtEdgeClearB);
        }

        protected void recalc(Component updated, long space, long itemSize, MonitoredTextField txtCount, MonitoredTextField txtPitch, MonitoredTextField txtClearA, MonitoredTextField txtClearB) {
            Long clearB;
            Long clearA;
            Unit unit = PatternPlacementUI.this.getUnitDist();
            int count = AFieldValidator.getInt((JTextField)txtCount, (int)-1);
            Long pitch = this.getUserDbDist(unit, txtPitch);
            int valid = (pitch != null ? 1 : 0) + (count > 0 ? 1 : 0) + ((clearA = this.getUserDbDist(unit, txtClearA)) != null ? 1 : 0) + ((clearB = this.getUserDbDist(unit, txtClearB)) != null ? 1 : 0);
            if (valid < 2) {
                return;
            }
            if (valid == 2 && clearA == null && clearB == null && updated != txtClearA && updated != txtClearB) {
                this.updateEdgeClears(space, itemSize, count, pitch, txtClearA, txtClearB);
            } else if (valid == 3) {
                if (pitch == null && updated != txtPitch) {
                    this.updatePitch(space, itemSize, txtPitch, count, clearA, clearB);
                } else if (count <= 0 && updated != txtCount) {
                    this.updateCount(space, itemSize, txtCount, pitch, clearA, clearB);
                } else if (clearA == null && updated != txtClearA) {
                    this.updateEdgeClears(space, itemSize, count, pitch, txtClearA, txtClearB);
                } else if (clearB == null && updated != txtClearB) {
                    this.updateEdgeClears(space, itemSize, count, pitch, txtClearA, txtClearB);
                }
            } else if (valid == 4) {
                MonitoredTextField[] fields = new MonitoredTextField[]{txtCount, txtClearA, txtClearB};
                Arrays.sort(fields, (a, b) -> Long.compare(a.getLastModified(), b.getLastModified()));
                MonitoredTextField update = fields[0];
                if (update == txtCount && updated != txtCount) {
                    this.updateCount(space, itemSize, txtCount, pitch, clearA, clearB);
                } else if (updated != txtClearA && updated != txtClearB && (update == txtClearA && txtClearB.getLastModified() == 0L || update == txtClearB && txtClearA.getLastModified() == 0L)) {
                    this.updateEdgeClears(space, itemSize, count, pitch, txtClearA, txtClearB);
                } else if (update == txtClearA && updated != txtClearA) {
                    this.updateEdgeClear(space, itemSize, txtClearA, count, pitch, clearB);
                } else if (update == txtClearB && updated != txtClearB) {
                    this.updateEdgeClear(space, itemSize, txtClearB, count, pitch, clearA);
                } else assert (false);
            }
        }

        protected void updatePitch(long space, long itemSize, JTextField txtPitch, int count, long clearA, long clearB) {
            long pitch = count == 1 ? 0L : (space - itemSize - clearA - clearB) / (long)(count - 1);
            txtPitch.setText(PatternPlacementUI.this.getUnitDist().toUserStr(pitch));
        }

        protected void updateCount(long space, long itemSize, JTextField txtCount, long pitch, long clearA, long clearB) {
            long count = pitch == 0L ? 1L : 1L + (space - itemSize - clearA - clearB) / pitch;
            txtCount.setText("" + count);
        }

        protected void updateEdgeClear(long space, long itemSize, JTextField txtClearCalc, int count, long pitch, long clearExist) {
            long clearCalc = space - (long)(count - 1) * pitch - itemSize - clearExist;
            txtClearCalc.setText(PatternPlacementUI.this.getUnitDist().toUserStr(clearCalc));
        }

        protected void updateEdgeClears(long space, long itemSize, int count, long pitch, MonitoredTextField txtClearCalcA, MonitoredTextField txtClearCalcB) {
            Unit unit = PatternPlacementUI.this.getUnitDist();
            Long clearA = txtClearCalcA.getLastModified() == 0L ? null : this.getUserDbDist(unit, txtClearCalcA);
            Long clearB = txtClearCalcB.getLastModified() == 0L ? null : this.getUserDbDist(unit, txtClearCalcB);
            long clearCalc = space - (long)(count - 1) * pitch - itemSize - (clearA == null ? 0L : clearA) - (clearB == null ? 0L : clearB);
            if (clearA == null && clearB == null) {
                String clearStr = PatternPlacementUI.this.getUnitDist().toUserStr(clearCalc / 2L);
                txtClearCalcA.setText(clearStr);
                txtClearCalcB.setText(clearStr);
            } else if (clearA == null) {
                txtClearCalcA.setText(unit.toUserStr(clearCalc));
            } else {
                txtClearCalcB.setText(unit.toUserStr(clearCalc));
            }
        }

        protected void updateControls() {
            Unit unit = PatternPlacementUI.this.getUnitDist();
            long cols = AFieldValidator.getLong((JTextField)this.mTxtCols, (long)-1L);
            long rows = AFieldValidator.getLong((JTextField)this.mTxtRows, (long)-1L);
            Long pitchX = this.getUserDbDist(unit, this.mTxtDX);
            Long pitchY = this.getUserDbDist(unit, this.mTxtDY);
            Long clearL = this.getUserDbDist(unit, this.mTxtEdgeClearL);
            Long clearR = this.getUserDbDist(unit, this.mTxtEdgeClearR);
            Long clearT = this.getUserDbDist(unit, this.mTxtEdgeClearT);
            Long clearB = this.getUserDbDist(unit, this.mTxtEdgeClearB);
            Long koX = this.getUserDbDist(unit, PatternPlacementUI.this.mTxtCornerClearX);
            Long koY = this.getUserDbDist(unit, PatternPlacementUI.this.mTxtCornerClearY);
            if (clearL == null && clearR == null && clearT == null && clearB == null) {
                this.mBtnRecenter.setEnabled(false);
            } else if (AUtil.equals((Object)clearL, (Object)clearR) && AUtil.equals((Object)clearT, (Object)clearB)) {
                this.mBtnRecenter.setEnabled(false);
            } else {
                this.mBtnRecenter.setEnabled(true);
            }
            if (rows < 1L || cols < 1L || pitchX == null || pitchY == null || clearL == null || clearR == null || clearT == null || clearB == null || koX == null || koY == null) {
                this.mLblCount.setText("-");
                return;
            }
            try {
                long count = rows * cols;
                ARect itemBounds = this.getPlaceableBounds();
                ARect dieBounds = PatternPlacementUI.this.mPatternOwner.getBB();
                ARect placeBounds = new ARect(dieBounds.left() + clearL, dieBounds.bottom() + clearB, dieBounds.left() + clearL + (cols - 1L) * pitchX + itemBounds.width(), dieBounds.bottom() + clearB + (rows - 1L) * pitchY + itemBounds.height());
                count -= this.calcRemove(placeBounds, itemBounds, pitchX, pitchY, new ARect(dieBounds.left(), dieBounds.top() - koY, dieBounds.left() + koX, dieBounds.top()));
                count -= this.calcRemove(placeBounds, itemBounds, pitchX, pitchY, new ARect(dieBounds.right() - koX, dieBounds.top() - koY, dieBounds.right(), dieBounds.top()));
                count -= this.calcRemove(placeBounds, itemBounds, pitchX, pitchY, new ARect(dieBounds.left(), dieBounds.bottom(), dieBounds.left() + koX, dieBounds.bottom() + koY));
                if ((count -= this.calcRemove(placeBounds, itemBounds, pitchX, pitchY, new ARect(dieBounds.right() - koX, dieBounds.bottom(), dieBounds.right(), dieBounds.bottom() + koY))) < 0L) {
                    count = 0L;
                }
                this.mLblCount.setText("" + count);
            }
            catch (Exception e) {
                ALog.logWarn((String)"Error when updatControls. %s.", (Object[])new Object[]{e.getMessage()});
                this.mLblCount.setText("-");
            }
        }

        protected long calcRemove(ARect placeBounds, ARect itemBounds, long pitchX, long pitchY, ARect keepOut) {
            if (placeBounds == null || keepOut == null || itemBounds == null) {
                return 0L;
            }
            ARect overLap = placeBounds.intersection(keepOut);
            if (overLap == null) {
                return 0L;
            }
            long itemWidth = itemBounds.width() / 2L + pitchX;
            long itemHeight = itemBounds.height() / 2L + pitchY;
            return (long)(Math.ceil((double)overLap.width() / (double)itemWidth) * Math.ceil((double)overLap.height() / (double)itemHeight));
        }

        protected ARect getPlaceableBounds() {
            Interpreter i = Cp.getCp().createChildInterpreter();
            Object o = null;
            for (String s : PatternPlacementUI.this.mPlaceableDefnUI.getFactoryCreationCmds()) {
                try {
                    o = i.eval(s);
                }
                catch (EvalError e) {
                    ALog.logError((Throwable)e, (String)"Exception while creating PlaceableFactory.", (Object[])new Object[0]);
                    return null;
                }
            }
            if (!(o instanceof PlaceableFactory)) {
                ALog.logError((String)"Unexpected return type '%'s from creating PlaceableFactory.", (Object[])new Object[]{o == null ? "null" : o.getClass().getName()});
                return null;
            }
            PlaceableFactory pf = (PlaceableFactory)o;
            double rot = 0.0;
            try {
                rot = AUtil.doubleFromString((String)AFieldValidator.validateDouble((JTextField)PatternPlacementUI.this.mTxtRotation));
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                ALog.logWarn((String)"Error with %s. %s.", (Object[])new Object[]{PatternPlacementUI.this.mTxtRotation.getText(), ve.getMessage()});
            }
            return pf.getTransformedItemBounds(PatternPlacementUI.this.mCbMirror.isSelected(), (float)rot);
        }

        @Override
        public void placableItemBoundsChanged() {
            PatternPlacementUI.this.mPnlCenterArray.recalc(null);
        }

        private String getMTFDesc(MonitoredTextField mtf) {
            if (mtf == this.mTxtDX) {
                return "dx";
            }
            if (mtf == this.mTxtDY) {
                return "dy";
            }
            if (mtf == this.mTxtCols) {
                return "cols";
            }
            if (mtf == this.mTxtRows) {
                return "rows";
            }
            if (mtf == this.mTxtEdgeClearL) {
                return "clear L";
            }
            if (mtf == this.mTxtEdgeClearR) {
                return "clear R";
            }
            if (mtf == this.mTxtEdgeClearT) {
                return "clear T";
            }
            if (mtf == this.mTxtEdgeClearB) {
                return "clear B";
            }
            return "?";
        }

        protected class MonitoredTextField
        extends JTextField {
            protected long mLastModifiedCounter;
            protected DocumentListener mDocListener;

            public MonitoredTextField() {
                this.mLastModifiedCounter = 0L;
                this.mDocListener = new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        MonitoredTextField.this.docUpdated();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        MonitoredTextField.this.docUpdated();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        MonitoredTextField.this.docUpdated();
                    }
                };
            }

            public MonitoredTextField(Document doc, String text, int columns) {
                super(doc, text, columns);
                this.mLastModifiedCounter = 0L;
                this.mDocListener = new /* invalid duplicate definition of identical inner class */;
            }

            public MonitoredTextField(int columns) {
                super(columns);
                this.mLastModifiedCounter = 0L;
                this.mDocListener = new /* invalid duplicate definition of identical inner class */;
            }

            public MonitoredTextField(String text, int columns) {
                super(text, columns);
                this.mLastModifiedCounter = 0L;
                this.mDocListener = new /* invalid duplicate definition of identical inner class */;
            }

            public MonitoredTextField(String text) {
                super(text);
                this.mLastModifiedCounter = 0L;
                this.mDocListener = new /* invalid duplicate definition of identical inner class */;
            }

            public long getLastModified() {
                return this.mLastModifiedCounter;
            }

            @Override
            public void addNotify() {
                super.addNotify();
                this.getDocument().addDocumentListener(this.mDocListener);
            }

            @Override
            public void removeNotify() {
                this.getDocument().removeDocumentListener(this.mDocListener);
                super.removeNotify();
            }

            protected void docUpdated() {
                if (CenterArrayPanel.this.mInMonitoredFieldUpdate) {
                    return;
                }
                CenterArrayPanel.this.mInMonitoredFieldUpdate = true;
                this.mLastModifiedCounter = this.getText().length() == 0 ? 0L : (CenterArrayPanel.this.mMonitoredFieldModCounter = CenterArrayPanel.this.mMonitoredFieldModCounter + 1L);
                CenterArrayPanel.this.recalc(this);
                CenterArrayPanel.this.mInMonitoredFieldUpdate = false;
            }

            public void clearAndReset() {
                CenterArrayPanel.this.mInMonitoredFieldUpdate = true;
                this.setText("");
                this.mLastModifiedCounter = 0L;
                CenterArrayPanel.this.mInMonitoredFieldUpdate = false;
            }
        }
    }

    protected static interface UsesPlacableItemBounds {
        public void placableItemBoundsChanged();
    }

    protected static interface UsesCornerKeepoutsAndMargins {
        public void installCornerKeepoutsAndMargins(JPanel var1);
    }
}

