/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PeripheralIOUI
extends ADialog {
    protected static final int NUM_COLS = 12;
    static final String TITLE = "Peripheral IO Cell Management";
    protected String mDevicePath;
    protected JCheckBox mAutoCells = new JCheckBox("Automatically Manage Cells");
    protected JRadioButton mOptimizeWireBond = new JRadioButton("Optimize for WireBond");
    protected JRadioButton mEvenlySpace = new JRadioButton("Evenly Space");
    protected JRadioButton mPushBeginning = new JRadioButton("Push Beginning");
    protected JRadioButton mPushEnd = new JRadioButton("Push End");
    protected JRadioButton mSpecificSpacing = new JRadioButton("Specific Space");
    protected JTextField mSpacing = new JTextField("2000", 12);
    protected JCheckBox mAvoidCorners = new JCheckBox("Avoid Corners");
    protected JTextField mCornerSpacing = new JTextField("2000", 12);
    protected JCheckBox mManageSelected = new JCheckBox("Manage Only Selected");
    protected JButton mBtnApply = new JButton("Apply");
    protected JButton mBtnOK = new JButton("Ok");
    protected JButton mBtnClose = new JButton("Close");
    protected ChangeListener mOptionsSpacListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            PeripheralIOUI.this.spaceOptionChanged();
        }
    };
    protected ChangeListener mOptionsCornerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            PeripheralIOUI.this.cornerOptionChanged();
        }
    };
    protected ActionListener mOnOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PeripheralIOUI.this.doCommand();
            PeripheralIOUI.this.setVisible(false);
        }
    };
    protected ActionListener mOnApply = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PeripheralIOUI.this.doCommand();
        }
    };

    public static void showMe(Window owner, String devicePath) {
        PeripheralIOUI ui = new PeripheralIOUI(owner, devicePath);
        UIUtil.center((Component)((Object)ui));
        ui.setVisible(true);
    }

    protected PeripheralIOUI(String path) {
        super((Window)null, TITLE);
        this.mDevicePath = path;
        this.initialize();
    }

    protected PeripheralIOUI(Window owner, String path) {
        super(owner, TITLE);
        this.mDevicePath = path;
        this.initialize();
    }

    protected PeripheralIOUI(Dialog owner, String path) {
        super(owner, TITLE);
        this.mDevicePath = path;
        this.initialize();
    }

    protected void cornerOptionChanged() {
        if (this.mAvoidCorners.isSelected()) {
            this.mCornerSpacing.setEnabled(true);
        } else {
            this.mCornerSpacing.setEnabled(false);
        }
    }

    protected void spaceOptionChanged() {
        if (this.mSpecificSpacing.isSelected()) {
            this.mSpacing.setEnabled(true);
        } else {
            this.mSpacing.setEnabled(false);
        }
    }

    protected void doCommand() {
        Unit u = this.getCurrentUnit();
        String algo = this.mOptimizeWireBond.isSelected() ? "com.sigrity.acl.transformers.AIOCellSpreader.SpreadAlgo.ForWireBonding" : (this.mEvenlySpace.isSelected() ? "com.sigrity.acl.transformers.AIOCellSpreader.SpreadAlgo.Evenly" : (this.mPushBeginning.isSelected() ? "com.sigrity.acl.transformers.AIOCellSpreader.SpreadAlgo.PushBeginning" : (this.mPushEnd.isSelected() ? "com.sigrity.acl.transformers.AIOCellSpreader.SpreadAlgo.PushEnd" : (this.mSpecificSpacing.isSelected() ? "com.sigrity.acl.transformers.AIOCellSpreader.SpreadAlgo.Specific" : "com.sigrity.acl.transformers.AIOCellSpreader.SpreadAlgo.Undefined"))));
        try {
            Cp.exec((String)"com.sigrity.acl.transformers.AIOCellSpreader spreader = new com.sigrity.acl.transformers.AIOCellSpreader();", (Object[])new Object[0]);
            Cp.exec((String)"spreader.spreadIOCells (\"%s\", %s, %s, %dL, %dL);", (Object[])new Object[]{this.mDevicePath, algo, Boolean.toString(this.mManageSelected.isSelected()), this.mAvoidCorners.isSelected() ? u.fromUser(Double.parseDouble(this.mCornerSpacing.getText())) : 0L, this.mSpecificSpacing.isSelected() ? u.fromUser(Double.parseDouble(this.mSpacing.getText())) : 0L});
            OrbitIO.getApp().refreshCurrentView(false);
            this.saveProperties();
        }
        catch (NumberFormatException err) {
            ALog.logError((Throwable)err, (String)"Invalid string: %s", (Object[])new Object[]{err.getMessage()});
        }
    }

    protected Unit getCurrentUnit() {
        Db db = OrbitIO.getCurDb();
        return Design.getUnit((Db)db);
    }

    protected void initialize() {
        GridBagManager.GridBagConstraintsEx LEFT_INDENT = GridBagManager.LEFT.insets(0, 24, 0, 0);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        l.add((Component)this.mAutoCells, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        ButtonGroup g1 = new ButtonGroup();
        l.pushRemainX("Distribution Algorithm");
        l.newline();
        l.add((Component)this.mOptimizeWireBond, (GridBagConstraints)GridBagManager.FILLX);
        this.mOptimizeWireBond.setSelected(true);
        g1.add(this.mOptimizeWireBond);
        l.newline();
        l.add((Component)this.mEvenlySpace, (GridBagConstraints)GridBagManager.FILLX);
        g1.add(this.mEvenlySpace);
        l.newline();
        l.add((Component)this.mPushBeginning, (GridBagConstraints)GridBagManager.FILLX);
        g1.add(this.mPushBeginning);
        l.newline();
        l.add((Component)this.mPushEnd, (GridBagConstraints)GridBagManager.FILLX);
        g1.add(this.mPushEnd);
        l.newline();
        l.add((Component)this.mSpecificSpacing, (GridBagConstraints)GridBagManager.FILLX);
        g1.add(this.mSpecificSpacing);
        this.mSpecificSpacing.addChangeListener(this.mOptionsSpacListener);
        l.newline();
        l.add((Component)new JLabel("Spacing: "), (GridBagConstraints)LEFT_INDENT);
        l.add((Component)this.mSpacing, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.pop();
        l.newline();
        l.pushRemainX("");
        l.add((Component)this.mAvoidCorners, (GridBagConstraints)GridBagManager.FILLX);
        this.mAvoidCorners.addChangeListener(this.mOptionsCornerListener);
        l.newline();
        l.add((Component)new JLabel("Corner Spacing: "), (GridBagConstraints)LEFT_INDENT);
        l.add((Component)this.mCornerSpacing, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.pop();
        l.newline();
        ButtonGroup g2 = new ButtonGroup();
        l.pushRemainX("Manage Set");
        l.newline();
        l.add((Component)this.mManageSelected, (GridBagConstraints)GridBagManager.FILLX);
        g2.add(this.mManageSelected);
        l.pop();
        l.newline();
        l.pushFillX();
        l.addFillX();
        l.add((Component)this.mBtnApply, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mBtnOK, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mBtnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.newline();
        this.mBtnApply.addActionListener(this.mOnApply);
        this.mBtnOK.addActionListener(this.mOnOk);
        l.pop();
        this.pack();
        this.loadProperties();
        this.spaceOptionChanged();
        this.cornerOptionChanged();
        UIUtil.center((Component)((Object)this));
        UIUtil.enableDefaultBtn((JDialog)((Object)this), (JButton)this.mBtnApply);
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mBtnClose);
        this.setResizable(true);
        this.setModal(false);
    }

    protected void loadProperties() {
    }

    protected void saveProperties() {
    }
}

