/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AMutableReference;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.PersonalityAssigner;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.AddPinsToPersonalityMode;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.DeviceChooser;
import com.sigrity.orbit.ui.GetAnObjectChooserDlg;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.docking.DesignDockable;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PersonalitiesEditor
extends DesignDockable {
    protected DeviceTemplate mDevT;
    protected PersonalitiesTree mTreePersonalities;
    protected JButton mBtnAdd;
    protected JButton mBtnEdit;
    protected JButton mBtnDelete;
    protected DeviceChooser.DCPanel mDeviceChooserPanel;
    protected DbRelationDef.DbRelationListener mRelationListener = new DbRelationDef.DbRelationAdapter(){

        public void related(DbRelationDef.RelationChange change) {
            Personality personality = (Personality)change.getRight();
            PersonalityMap pm = (PersonalityMap)change.getLeft();
            PersonalityUI.PersonalityNode pn = PersonalitiesEditor.this.getRootNode().findNode(personality);
            if (pn == null) {
                return;
            }
            if (pm.getObject() != null) {
                pn.add(pm);
            }
        }

        public void unrelated(DbRelationDef.RelationChange change) {
            Personality personality = (Personality)change.getRight();
            PersonalityMap pm = (PersonalityMap)change.getLeft();
            PersonalityUI.PersonalityNode pn = PersonalitiesEditor.this.getRootNode().findNode(personality);
            if (pn == null) {
                return;
            }
            DbObject dbo = pm.getObject();
            if (dbo != null) {
                int idx = pn.getIndex(dbo);
                if (idx == -1) {
                    return;
                }
                pn.remove(idx);
            }
        }
    };
    protected DbClass.DbObjectListener mPersonalityListener = new DbClass.DbObjectAdapter(){

        public void addedObject(DbClass.ObjectAdd add) {
            PersonalitiesEditor.this.getRootNode().notifyChange((DbClass.DbObjectEvent)add);
        }

        public void changedObject(DbClass.ObjectChange change) {
            PersonalitiesEditor.this.getRootNode().notifyChange((DbClass.DbObjectEvent)change);
        }

        public void removedObject(DbClass.ObjectRemove remove) {
            PersonalitiesEditor.this.getRootNode().notifyChange((DbClass.DbObjectEvent)remove);
        }
    };
    protected Action mAddNewPortPersonality = new AbstractAction("Add..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            DeviceTemplate devTemp = PersonalitiesEditor.this.mTreePersonalities.getSelectedDeviceTemplates().get(0);
            PersonalityUI.PortPersonalityEditDlg dlg = new PersonalityUI.PortPersonalityEditDlg((Window)UIUtil.getAncestorOfType((Component)PersonalitiesEditor.this.getContentPane(), Window.class), "Create Personality", devTemp, null);
            dlg.setVisible(true);
            if (!dlg.getAccepted()) {
                return;
            }
            String templateName = devTemp.getKeyStr();
            Personality personality = (Personality)Cp.exec(() -> PersonalityUI.addPersonalityByDevTemp(dlg.getPersonalityName(), Personality.Type.PORT, templateName, AUtil.colorToString((Color)dlg.getPersonalityColor())), (String)"com.sigrity.orbit.ui.PersonalityUI.addPersonalityByDevTemp(\"%s\", com.sigrity.acl.db.std.Personality.Type.PORT, \"%s\", \"%s\")", (Object[])new Object[]{dlg.getPersonalityName(), templateName, AUtil.colorToString((Color)dlg.getPersonalityColor())});
            if (personality == null) {
                return;
            }
            PersonalitiesEditor.this.doPortConstraintUpdateCommands(dlg, templateName);
        }
    };
    protected ActionListener mAddNewNetPersonality = e -> {
        DeviceTemplate devTemp = this.mTreePersonalities.getSelectedDeviceTemplates().get(0);
        PersonalityUI.NetPersonalityEditDlg dlg = new PersonalityUI.NetPersonalityEditDlg((Window)UIUtil.getAncestorOfType((Component)this.getContentPane(), Window.class), "Create Personality", devTemp, null);
        dlg.setVisible(true);
        if (!dlg.getAccepted()) {
            return;
        }
        String templateName = devTemp.getKeyStr();
        Personality personality = (Personality)Cp.exec(() -> PersonalityUI.addPersonalityByDevTemp(dlg.getPersonalityName(), Personality.Type.NET, templateName, AUtil.colorToString((Color)dlg.getPersonalityColor())), (String)"com.sigrity.orbit.ui.PersonalityUI.addPersonalityByDevTemp(\"%s\", com.sigrity.acl.db.std.Personality.Type.NET, \"%s\", \"%s\")", (Object[])new Object[]{dlg.getPersonalityName(), templateName, AUtil.colorToString((Color)dlg.getPersonalityColor())});
        if (personality == null) {
            return;
        }
        this.doNetConstraintUpdateCommands(dlg, templateName);
    };
    protected ActionListener mAddNewDevicePersonality = e -> {
        DeviceTemplate devTemp = this.mTreePersonalities.getSelectedDeviceTemplates().get(0);
        PersonalityUI.DevicePersonalityEditDlg dlg = new PersonalityUI.DevicePersonalityEditDlg((Window)UIUtil.getAncestorOfType((Component)this.getContentPane(), Window.class), "Create Personality", devTemp, null);
        dlg.setVisible(true);
        if (!dlg.getAccepted()) {
            return;
        }
        String templateName = devTemp.getKeyStr();
        Personality personality = (Personality)Cp.exec(() -> PersonalityUI.addPersonalityByDevTemp(dlg.getPersonalityName(), Personality.Type.DEVICE, templateName, AUtil.colorToString((Color)dlg.getPersonalityColor())), (String)"com.sigrity.orbit.ui.PersonalityUI.addPersonalityByDevTemp(\"%s\", com.sigrity.acl.db.std.Personality.Type.DEVICE, \"%s\", \"%s\")", (Object[])new Object[]{dlg.getPersonalityName(), templateName, AUtil.colorToString((Color)dlg.getPersonalityColor())});
        if (personality == null) {
            return;
        }
        this.doGridAreaUpdateCommands(dlg, templateName);
    };
    protected ActionListener mDeleteAllNetPersonalities = e -> Cp.exec(() -> PersonalityUI.deleteAllPersonalities(OrbitIO.getCurDb(), this.mTreePersonalities.getSelectedDeviceTemplates().get(0).getKeyStr(), Personality.Type.NET), (String)"com.sigrity.orbit.ui.PersonalityUI.deleteAllPersonalities(curDb(), \"%s\", %s)", (Object[])new Object[]{this.mTreePersonalities.getSelectedDeviceTemplates().get(0).getKeyStr(), "com.sigrity.acl.db.std.Personality.Type.NET"});
    protected Action mDeleteAllPinPersonalities = new AbstractAction("Delete All..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(() -> PersonalityUI.deleteAllPersonalities(OrbitIO.getCurDb(), PersonalitiesEditor.this.mTreePersonalities.getSelectedDeviceTemplates().get(0).getKeyStr(), Personality.Type.PORT), (String)"com.sigrity.orbit.ui.PersonalityUI.deleteAllPersonalities(curDb(), \"%s\", %s)", (Object[])new Object[]{PersonalitiesEditor.this.mTreePersonalities.getSelectedDeviceTemplates().get(0).getKeyStr(), "com.sigrity.acl.db.std.Personality.Type.PORT"});
        }
    };
    protected ActionListener mDeleteAllDevicePersonalities = e -> Cp.exec(() -> PersonalityUI.deleteAllPersonalities(OrbitIO.getCurDb(), this.mTreePersonalities.getSelectedDeviceTemplates().get(0).getKeyStr(), Personality.Type.DEVICE), (String)"com.sigrity.orbit.ui.PersonalityUI.deleteAllPersonalities(curDb(), \"%s\", %s)", (Object[])new Object[]{this.mTreePersonalities.getSelectedDeviceTemplates().get(0).getKeyStr(), "com.sigrity.acl.db.std.Personality.Type.DEVICE"});
    protected Action mCopyPortPersonality = new AbstractAction("Copy..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            DeviceTemplate devTemp = PersonalitiesEditor.this.mTreePersonalities.getSelectedDeviceTemplates().get(0);
            PersonalityUI.PortPersonalityCopyDlg dlg = PersonalityUI.PortPersonalityCopyDlg.createDialog((Window)UIUtil.getAncestorOfType((Component)PersonalitiesEditor.this.getContentPane(), Window.class), "Copy Personality", devTemp);
            dlg.setVisible(true);
            if (!dlg.getAccepted()) {
                return;
            }
            String toDevTempKeyStr = devTemp.getKeyStr();
            boolean added = (Boolean)Cp.exec(() -> PersonalityUI.copyPinPersonalityByDevTemp(dlg.getFromDevTempKeyStr(), toDevTempKeyStr), (String)"com.sigrity.orbit.ui.PersonalityUI.copyPinPersonalityByDevTemp(\"%s\", \"%s\")", (Object[])new Object[]{dlg.getFromDevTempKeyStr(), toDevTempKeyStr});
            if (!added) {
                return;
            }
        }
    };
    protected ActionListener mEditNetPersonality = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        PersonalityUI.NetPersonalityEditDlg dlg = new PersonalityUI.NetPersonalityEditDlg((Window)UIUtil.getAncestorOfType((Component)this.getContentPane(), Window.class), "Edit Personality", personality.getOwner(), personality);
        dlg.setVisible(true);
        if (!dlg.getAccepted()) {
            return;
        }
        String templateKeyStr = personality.getOwner().getKeyStr();
        boolean updated = dlg.updateNameIfChanged();
        Object[] objectArray = new Object[]{personality.getName(), templateKeyStr, AUtil.colorToString((Color)dlg.getPersonalityColor())};
        this.doNetConstraintUpdateCommands(dlg, templateKeyStr);
        if (updated |= ((Boolean)Cp.exec(() -> PersonalityUI.updatePersonalityColor(Personality.Type.NET, personality.getName(), templateKeyStr, AUtil.colorToString((Color)dlg.getPersonalityColor())), (String)"com.sigrity.orbit.ui.PersonalityUI.updatePersonalityColor(com.sigrity.acl.db.std.Personality.Type.NET, \"%s\", \"%s\", \"%s\")", (Object[])objectArray)).booleanValue()) {
            this.mTreePersonalities.repaint(personality);
        }
    };
    protected ActionListener mEditDevicePersonality = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        PersonalityUI.DevicePersonalityEditDlg dlg = new PersonalityUI.DevicePersonalityEditDlg((Window)UIUtil.getAncestorOfType((Component)this.getContentPane(), Window.class), "Edit Personality", personality.getOwner(), personality);
        dlg.setVisible(true);
        if (!dlg.getAccepted()) {
            return;
        }
        boolean updated = dlg.updateNameIfChanged();
        String templateName = personality.getOwner().getKeyStr();
        Object[] objectArray = new Object[]{personality.getName(), templateName, AUtil.colorToString((Color)dlg.getPersonalityColor())};
        this.doGridAreaUpdateCommands(dlg, templateName);
        if (updated |= ((Boolean)Cp.exec(() -> PersonalityUI.updatePersonalityColor(Personality.Type.DEVICE, personality.getName(), templateName, AUtil.colorToString((Color)dlg.getPersonalityColor())), (String)"com.sigrity.orbit.ui.PersonalityUI.updatePersonalityColor(com.sigrity.acl.db.std.Personality.Type.DEVICE, \"%s\", \"%s\", \"%s\")", (Object[])objectArray)).booleanValue()) {
            this.mTreePersonalities.repaint(personality);
        }
    };
    protected Action mEditPortPersonality = new AbstractAction("Edit..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Personality> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            if (selected.size() != 1) {
                return;
            }
            Personality personality = selected.get(0);
            PersonalityUI.PortPersonalityEditDlg dlg = new PersonalityUI.PortPersonalityEditDlg((Window)UIUtil.getAncestorOfType((Component)PersonalitiesEditor.this.getContentPane(), Window.class), "Edit Personality", personality.getOwner(), personality);
            dlg.setVisible(true);
            if (!dlg.getAccepted()) {
                return;
            }
            String templateKeyStr = personality.getOwner().getKeyStr();
            boolean updated = dlg.updateNameIfChanged();
            Object[] objectArray = new Object[]{personality.getName(), templateKeyStr, AUtil.colorToString((Color)dlg.getPersonalityColor())};
            PersonalitiesEditor.this.doPortConstraintUpdateCommands(dlg, templateKeyStr);
            if (updated |= ((Boolean)Cp.exec(() -> PersonalityUI.updatePersonalityColor(Personality.Type.PORT, personality.getName(), templateKeyStr, AUtil.colorToString((Color)dlg.getPersonalityColor())), (String)"com.sigrity.orbit.ui.PersonalityUI.updatePersonalityColor(com.sigrity.acl.db.std.Personality.Type.PORT, \"%s\", \"%s\", \"%s\")", (Object[])objectArray)).booleanValue()) {
                PersonalitiesEditor.this.mTreePersonalities.repaint(personality);
            }
        }
    };
    protected ActionListener mAddSelectedNets = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        String pname = personality.getKeyStr();
        Cp.exec(() -> PersonalityUI.addSelectedNetsToPersonality(pname), (String)"com.sigrity.orbit.ui.PersonalityUI.addSelectedNetsToPersonality(\"%s\")", (Object[])new Object[]{pname});
        OrbitIO.getApp().refreshCurrentView(false);
    };
    protected ActionListener mRemoveSelectedNets = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        String pname = personality.getKeyStr();
        Cp.exec(() -> PersonalityUI.removeSelectedNetsFromPersonality(pname), (String)"com.sigrity.orbit.ui.PersonalityUI.removeSelectedNetsFromPersonality(\"%s\")", (Object[])new Object[]{pname});
        OrbitIO.getApp().refreshCurrentView(false);
    };
    protected Action mPickPortsToAdd = new AbstractAction("Pick Pins to Add..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Personality> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            if (selected.size() != 1) {
                ALog.logError((String)"Unable to pick pins, more than one personality is selected.");
                return;
            }
            Personality personality = selected.get(0);
            AddPinsToPersonalityMode mode = new AddPinsToPersonalityMode(personality);
            AAppView v = OrbitIO.getCurView();
            if (v.getDb() != PersonalitiesEditor.this.mDb) {
                ALog.logError((String)"Current view design differs from selected design.");
                assert (false);
                return;
            }
            if (!(v instanceof DesignView2D)) {
                ALog.logError((String)"Unable to pick pins, active view is not a 2D design view.");
                return;
            }
            DesignView2D v2d = (DesignView2D)v;
            v2d.setMode(mode);
        }
    };
    protected Action mHighlightPersonality = new AbstractAction("Highlight"){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Personality pers : PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities()) {
                PersonalityUI.highlight(pers);
            }
        }
    };
    protected ActionListener mDetails = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        DbObjectDetailsUI.show(null, (DbObject)personality, null, OrbitIO.getCurView());
    };
    protected ActionListener mAddSelectedPorts = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        Cp.exec(() -> PersonalityUI.addSelectedPortsToPersonalityOfKeyStr(personality.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.addSelectedPortsToPersonalityOfKeyStr(\"%s\")", (Object[])new Object[]{personality.getKeyStr()});
        OrbitIO.getApp().refreshCurrentView(false);
    };
    protected Action mMoveSelectedPorts = new AbstractAction("Move Selected Pins"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Personality> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            if (selected.size() != 1) {
                return;
            }
            Personality personality = selected.get(0);
            Cp.exec(() -> PersonalityUI.moveSelectedPortsToPersonalityOfKeyStr(personality.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.moveSelectedPortsToPersonalityOfKeyStr(\"%s\")", (Object[])new Object[]{personality.getKeyStr()});
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected Action mRemoveSelectedPorts = new AbstractAction("Remove Selected Pins"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Personality> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            if (selected.size() != 1) {
                return;
            }
            Personality personality = selected.get(0);
            Cp.exec(() -> PersonalityUI.removeSelectedPortsFromPersonality(personality.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removeSelectedPortsFromPersonality(\"%s\")", (Object[])new Object[]{personality.getKeyStr()});
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected final ActionListener mAddSelectedDevices = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        Cp.exec(() -> PersonalityUI.addSelectedDevices(OrbitIO.getCurDb(), personality.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.addSelectedDevices(curDb(), \"%s\")", (Object[])new Object[]{personality.getKeyStr()});
        OrbitIO.getApp().refreshCurrentView(false);
    };
    protected final ActionListener mSelectNets = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        String pname = personality.getName();
        DeviceTemplate dt = personality.getOwner();
        String dtName = dt != null ? dt.getKeyStr() : null;
        Cp.exec(() -> PersonalityUI.selectNetsInPersonalityByDevTemp(pname, dtName), (String)"com.sigrity.orbit.ui.PersonalityUI.selectNetsInPersonalityByDevTemp (\"%s\", \"%s\")", (Object[])new Object[]{pname, dtName});
        OrbitIO.getApp().refreshCurrentView(false);
    };
    protected final Action mSelectPorts = new AbstractAction("Select Pins"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Personality> selPers = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            if (selPers.size() != 1) {
                return;
            }
            Cp.exec(() -> PersonalityUI.selectObjectsOfPersonality(OrbitIO.getCurDb(), ((Personality)selPers.get(0)).getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.selectObjectsOfPersonality(curDb(), \"%s\")", (Object[])new Object[]{selPers.get(0).getKeyStr()});
        }
    };
    protected final ActionListener mSelectDevices = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        String pname = personality.getName();
        DeviceTemplate dt = personality.getOwner();
        if (dt == null) {
            return;
        }
        String dtname = dt.getKeyStr();
        Cp.exec(() -> PersonalityUI.selectDevicesInPersonalityByDevTemp(pname, dtname), (String)"com.sigrity.orbit.ui.PersonalityUI.selectDevicesInPersonalityByDevTemp (\"%s\", \"%s\")", (Object[])new Object[]{pname, dtname});
        OrbitIO.getApp().refreshCurrentView(false);
    };
    protected Action mDistributePorts = new AbstractAction("Distribute Selected Pins..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            DeviceTemplate devTemp = PersonalitiesEditor.this.mTreePersonalities.getSelectedDeviceTemplates().get(0);
            if (devTemp == null || !PersonalitiesEditor.hasSelectedPins(devTemp)) {
                return;
            }
            String sName = devTemp.getSubstrate().getName();
            Cp.exec(() -> PersonalityAssigner.assignSelectedRandomly(sName), (String)"com.sigrity.acl.optimizer.PersonalityAssigner.assignSelectedRandomly(\"%s\")", (Object[])new Object[]{sName});
        }

        private boolean isDistributeOk(Substrate substrate) {
            Design design = OrbitIO.getCurDesign();
            Db db = design.getDb();
            for (DeviceTemplate devTemp : substrate.getDeviceTemplates()) {
                if (!Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT).anyMatch(p -> {
                    long ratio;
                    Constraint c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.PORT_ASSIGN_RATIO);
                    return c != null && (ratio = ((Long)c.getValue()).longValue()) > 0L;
                })) continue;
                return true;
            }
            ALog.logWarn((String)("Please define ratio pin personalities on " + substrate.getName() + " before distribution."));
            return false;
        }
    };
    protected ActionListener mDeleteDevicePersonality = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Personality> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            if (selected.isEmpty()) {
                return;
            }
            for (Personality personality : selected) {
                boolean deleteMe = true;
                if (personality.getObjects().anyMatch(hi -> hi.second instanceof Device)) {
                    String msg = String.format("Personality '%s' has related devices. Do you want todelete it?", personality.getKeyStr());
                    int r = JOptionPane.showConfirmDialog(PersonalitiesEditor.this.getContentPane(), msg, "Confirm Delete", 0, 3);
                    boolean bl = deleteMe = r == 0;
                }
                if (!deleteMe) continue;
                String dtname = personality.getOwner().getKeyStr();
                Cp.exec(() -> PersonalityUI.deletePersonalityOfDevTemp(personality.getName(), Personality.Type.DEVICE, dtname), (String)"com.sigrity.orbit.ui.PersonalityUI.deletePersonalityOfDevTemp(\"%s\", com.sigrity.acl.db.std.Personality.Type.DEVICE, \"%s\")", (Object[])new Object[]{personality.getName(), dtname});
                ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
            }
        }
    };
    protected ActionListener mRemoveNets = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Personality> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            if (selected.size() != 1) {
                return;
            }
            Personality personality = selected.get(0);
            String pname = personality.getKeyStr();
            Cp.exec(() -> PersonalityUI.removeNetsFromPersonality(pname), (String)"com.sigrity.orbit.ui.PersonalityUI.removeNetsFromPersonality(\"%s\")", (Object[])new Object[]{pname});
        }
    };
    protected ActionListener mRemoveNet = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<APair<Personality, Net>> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityNets();
            TreePath[] selection = PersonalitiesEditor.this.mTreePersonalities.getSelectionPaths();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Remove Objects From Personality");){
                for (APair<Personality, Net> pair : selected) {
                    Personality personality = (Personality)pair.first;
                    Net net = (Net)pair.second;
                    Cp.exec(() -> PersonalityUI.removeDbObjectFromPersonality(PersonalitiesEditor.this.getDevT().getKeyStr(), personality.getKeyStr(), "Net", net.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removeDbObjectFromPersonality(\"%s\", \"%s\", \"Net\", \"%s\")", (Object[])new Object[]{PersonalitiesEditor.this.getDevT().getKeyStr(), personality.getKeyStr(), net.getKeyStr()});
                }
            }
            PersonalitiesEditor.this.reenumerateObjectsOfPersonality(selection);
            OrbitApp.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mMovePinToPersonalities = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GetAnObjectChooserDlg.createDialog(OrbitIO.getMainWindow(), new MovePinToPersonalitiesChooserAdaptor(), false);
        }

        class MovePinToPersonalitiesChooserAdaptor
        implements GetAnObjectChooserDlg.GetAnObjectChooserHelper {
            private boolean removeExisting = true;

            MovePinToPersonalitiesChooserAdaptor() {
            }

            @Override
            public Db getDb() {
                return PersonalitiesEditor.this.mDb;
            }

            @Override
            public String getTitle() {
                return "Copy or Move pin(s) to personalities";
            }

            @Override
            public String getUserObjectName() {
                return "Personality";
            }

            @Override
            public void doDoneCommand(List<Object> list) {
                ArrayList<APair<Personality, PinInstance>> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityPins();
                TreePath[] selectionPaths = PersonalitiesEditor.this.mTreePersonalities.getSelectionPaths();
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)(this.removeExisting ? "Move pin(s) to Personality" : "Copy pin(s) to Personality"));){
                    for (APair<Personality, PinInstance> pair : selected) {
                        if (this.removeExisting) {
                            Cp.exec(() -> PersonalityUI.removePinFromPersonality(OrbitIO.getCurDb(), ((PinInstance)pair.second).getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removePinFromPersonality(curDb(), \"%s\")", (Object[])new Object[]{((PinInstance)pair.second).getKeyStr()});
                        }
                        for (Object obj : list) {
                            Cp.exec(() -> PersonalityUI.addPinToPersonality(OrbitIO.getCurDb(), ((PinInstance)pair.second).getKeyStr(), ((DbObject)obj).getKeyStr(), false), (String)"com.sigrity.orbit.ui.PersonalityUI.addPinToPersonality(curDb(), \"%s\", \"%s\", false)", (Object[])new Object[]{((PinInstance)pair.second).getKeyStr(), ((DbObject)obj).getKeyStr()});
                        }
                    }
                }
                if (this.removeExisting) {
                    PersonalitiesEditor.this.reenumerateObjectsOfPersonality(selectionPaths);
                }
                OrbitApp.getApp().refreshCurrentView(false);
            }

            @Override
            public void doClosingCommand() {
            }

            @Override
            public String getObjectString(Object obj) {
                Personality psn = (Personality)obj;
                return String.format("%s (%s)", psn.getName(), psn.getOwner().getName());
            }

            @Override
            public Color getObjectColor(Object pers) {
                return ((Personality)pers).getColor();
            }

            private DevicePath getCommonParentDevicePath(ArrayList<APair<Personality, PinInstance>> selected) {
                AMutableReference ans = new AMutableReference(null);
                for (APair<Personality, PinInstance> pair : selected) {
                    ((PinInstance)pair.second).getDevice().getAllPaths().forEach(dp -> ans.set((Object)(ans.get() == null ? dp : ((DevicePath)ans.get()).commonParent(dp))));
                }
                return (DevicePath)ans.get();
            }

            @Override
            public List<Object> getSortedObjectList() {
                ArrayList selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityPins();
                return PersonalitiesEditor.this.getSortedTargetablePersonalities(selected, Personality.Type.PORT, "pin");
            }

            @Override
            public int getNumCheckboxes() {
                return 1;
            }

            @Override
            public String getCheckboxTitle(int index) {
                return "Copy pin(s) to picked personailites, keeping current assignments.";
            }

            @Override
            public String getCheckboxTooltip(int index) {
                return "Uncheck to Move pins to picked personalities.";
            }

            @Override
            public boolean getDefaultCheckboxValue(int index) {
                return !this.removeExisting;
            }

            @Override
            public void notifyCheckboxChanged(String title, boolean newValue) {
                this.removeExisting = !newValue;
            }
        }
    };
    protected ActionListener mMoveNetToPersonalities = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GetAnObjectChooserDlg.createDialog(OrbitIO.getMainWindow(), new MoveNetToPersonalitiesChooserAdaptor(), false);
        }

        class MoveNetToPersonalitiesChooserAdaptor
        implements GetAnObjectChooserDlg.GetAnObjectChooserHelper {
            private boolean removeExisting = true;

            MoveNetToPersonalitiesChooserAdaptor() {
            }

            @Override
            public Db getDb() {
                return PersonalitiesEditor.this.mDb;
            }

            @Override
            public String getTitle() {
                return "Copy or Move net(s) to personalities";
            }

            @Override
            public String getUserObjectName() {
                return "Personality";
            }

            @Override
            public void doDoneCommand(List<Object> list) {
                ArrayList<APair<Personality, Net>> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityNets();
                TreePath[] selectionPaths = PersonalitiesEditor.this.mTreePersonalities.getSelectionPaths();
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)(this.removeExisting ? "Move net(s) to Personality" : "Copy net(s) to Personality"));){
                    for (APair<Personality, Net> pair : selected) {
                        if (this.removeExisting) {
                            Cp.exec(() -> PersonalityUI.removeObjectFromPersonality(OrbitIO.getCurDb(), "Net", ((Net)pair.second).getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removeObjectFromPersonality(curDb(), \"Net\", \"%s\")", (Object[])new Object[]{((Net)pair.second).getKeyStr()});
                        }
                        for (Object obj : list) {
                            Cp.exec(() -> PersonalityUI.addObjectToPersonality(OrbitIO.getCurDb(), "Net", ((Net)pair.second).getKeyStr(), ((DbObject)obj).getKeyStr(), false), (String)"com.sigrity.orbit.ui.PersonalityUI.addObjectToPersonality(curDb(), \"Net\", \"%s\", \"%s\", false)", (Object[])new Object[]{((Net)pair.second).getKeyStr(), ((DbObject)obj).getKeyStr()});
                        }
                    }
                }
                if (this.removeExisting) {
                    PersonalitiesEditor.this.reenumerateObjectsOfPersonality(selectionPaths);
                }
                OrbitApp.getApp().refreshCurrentView(false);
            }

            @Override
            public void doClosingCommand() {
            }

            @Override
            public String getObjectString(Object obj) {
                Personality psn = (Personality)obj;
                return String.format("%s (%s)", psn.getName(), psn.getOwner().getName());
            }

            @Override
            public Color getObjectColor(Object pers) {
                return ((Personality)pers).getColor();
            }

            private DevicePath getCommonParentDevicePath(ArrayList<APair<Personality, Net>> selected) {
                AMutableReference ans = new AMutableReference(null);
                for (APair<Personality, Net> pair : selected) {
                    ((Net)pair.second).getDeviceTemplate().getHierarchicalInstances().forEach(dp -> ans.set((Object)(ans.get() == null ? dp : ((DevicePath)ans.get()).commonParent(dp))));
                }
                return (DevicePath)ans.get();
            }

            @Override
            public List<Object> getSortedObjectList() {
                ArrayList selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityNets();
                return PersonalitiesEditor.this.getSortedTargetablePersonalities(selected, Personality.Type.NET, "net");
            }

            @Override
            public int getNumCheckboxes() {
                return 1;
            }

            @Override
            public String getCheckboxTitle(int index) {
                return "Copy net(s) to picked personailites, keeping current assignments.";
            }

            @Override
            public String getCheckboxTooltip(int index) {
                return "Uncheck to Move nets to picked personalities.";
            }

            @Override
            public boolean getDefaultCheckboxValue(int index) {
                return !this.removeExisting;
            }

            @Override
            public void notifyCheckboxChanged(String title, boolean newValue) {
                this.removeExisting = !newValue;
            }
        }
    };
    protected ActionListener mMoveDeviceToPersonalities = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GetAnObjectChooserDlg.createDialog(OrbitIO.getMainWindow(), new MoveDeviceToPersonalitiesChooserAdaptor(), false);
        }

        class MoveDeviceToPersonalitiesChooserAdaptor
        implements GetAnObjectChooserDlg.GetAnObjectChooserHelper {
            private boolean removeExisting = true;

            MoveDeviceToPersonalitiesChooserAdaptor() {
            }

            @Override
            public Db getDb() {
                return PersonalitiesEditor.this.mDb;
            }

            @Override
            public String getTitle() {
                return "Copy or Move Device(s) to personalities";
            }

            @Override
            public String getUserObjectName() {
                return "Personality";
            }

            @Override
            public void doDoneCommand(List<Object> list) {
                ArrayList<APair<Personality, Device>> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityDevices();
                TreePath[] selectionPaths = PersonalitiesEditor.this.mTreePersonalities.getSelectionPaths();
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)(this.removeExisting ? "Move Device(s) to Personality" : "Copy Device(s) to Personality"));){
                    for (APair<Personality, Device> pair : selected) {
                        if (this.removeExisting) {
                            Cp.exec(() -> PersonalityUI.removeObjectFromPersonality(OrbitIO.getCurDb(), "Device", ((Device)pair.second).getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removeObjectFromPersonality(curDb(), \"Device\", \"%s\")", (Object[])new Object[]{((Device)pair.second).getKeyStr()});
                        }
                        for (Object obj : list) {
                            Cp.exec(() -> PersonalityUI.addObjectToPersonality(OrbitIO.getCurDb(), "Device", ((Device)pair.second).getKeyStr(), ((DbObject)obj).getKeyStr(), false), (String)"com.sigrity.orbit.ui.PersonalityUI.addObjectToPersonality(curDb(), \"Device\", \"%s\", \"%s\", false)", (Object[])new Object[]{((Device)pair.second).getKeyStr(), ((DbObject)obj).getKeyStr()});
                        }
                    }
                }
                if (this.removeExisting) {
                    PersonalitiesEditor.this.reenumerateObjectsOfPersonality(selectionPaths);
                }
                OrbitApp.getApp().refreshCurrentView(false);
            }

            @Override
            public void doClosingCommand() {
            }

            @Override
            public String getObjectString(Object obj) {
                Personality psn = (Personality)obj;
                return String.format("%s (%s)", psn.getName(), psn.getOwner().getName());
            }

            @Override
            public Color getObjectColor(Object pers) {
                return ((Personality)pers).getColor();
            }

            private DevicePath getCommonParentDevicePath(ArrayList<APair<Personality, Device>> selected) {
                AMutableReference ans = new AMutableReference(null);
                for (APair<Personality, Device> pair : selected) {
                    ((Device)pair.second).getTemplate().getHierarchicalInstances().forEach(dp -> ans.set((Object)(ans.get() == null ? dp : ((DevicePath)ans.get()).commonParent(dp))));
                }
                return (DevicePath)ans.get();
            }

            @Override
            public List<Object> getSortedObjectList() {
                ArrayList selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityDevices();
                return PersonalitiesEditor.this.getSortedTargetablePersonalities(selected, Personality.Type.DEVICE, "device");
            }

            @Override
            public int getNumCheckboxes() {
                return 1;
            }

            @Override
            public String getCheckboxTitle(int index) {
                return "Copy Device(s) to picked personailites, keeping current assignments.";
            }

            @Override
            public String getCheckboxTooltip(int index) {
                return "Uncheck to Move nets to picked personalities.";
            }

            @Override
            public boolean getDefaultCheckboxValue(int index) {
                return !this.removeExisting;
            }

            @Override
            public void notifyCheckboxChanged(String title, boolean newValue) {
                this.removeExisting = !newValue;
            }
        }
    };
    protected ActionListener mRemovePin = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<APair<Personality, PinInstance>> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityPins();
            TreePath[] selection = PersonalitiesEditor.this.mTreePersonalities.getSelectionPaths();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Remove Objects From Personality");){
                for (APair<Personality, PinInstance> pair : selected) {
                    Personality personality = (Personality)pair.first;
                    PinInstance pinInstance = (PinInstance)pair.second;
                    Cp.exec(() -> PersonalityUI.removeDbObjectFromPersonality(PersonalitiesEditor.this.getDevT().getKeyStr(), personality.getKeyStr(), "PinInstance", pinInstance.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removeDbObjectFromPersonality(\"%s\", \"%s\", \"PinInstance\", \"%s\")", (Object[])new Object[]{PersonalitiesEditor.this.getDevT().getKeyStr(), personality.getKeyStr(), pinInstance.getKeyStr()});
                }
            }
            PersonalitiesEditor.this.reenumerateObjectsOfPersonality(selection);
            OrbitApp.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mRemoveDevice = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<APair<Personality, Device>> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityDevices();
            TreePath[] selection = PersonalitiesEditor.this.mTreePersonalities.getSelectionPaths();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Remove Objects From Personality");){
                for (APair<Personality, Device> pair : selected) {
                    Personality personality = (Personality)pair.first;
                    Device device = (Device)pair.second;
                    Cp.exec(() -> PersonalityUI.removeDbObjectFromPersonality(PersonalitiesEditor.this.getDevT().getKeyStr(), personality.getKeyStr(), "Device", device.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removeDbObjectFromPersonality(\"%s\", \"%s\", \"Device\", \"%s\")", (Object[])new Object[]{PersonalitiesEditor.this.getDevT().getKeyStr(), personality.getKeyStr(), device.getKeyStr()});
                }
            }
            PersonalitiesEditor.this.reenumerateObjectsOfPersonality(selection);
            OrbitApp.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mDeleteNetPersonality = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.isEmpty()) {
            return;
        }
        for (Personality personality : selected) {
            boolean deleteMe = true;
            if (personality.getObjects().anyMatch(hi -> hi.second instanceof Net)) {
                String msg = String.format("Personality '%s' has related nets. Do you want todelete it?", personality.getKeyStr());
                int r = JOptionPane.showConfirmDialog(this.getContentPane(), msg, "Confirm Delete", 0, 3);
                boolean bl = deleteMe = r == 0;
            }
            if (!deleteMe) continue;
            String dtname = personality.getOwner().getKeyStr();
            Cp.exec(() -> PersonalityUI.deletePersonalityOfDevTemp(personality.getName(), Personality.Type.NET, dtname), (String)"com.sigrity.orbit.ui.PersonalityUI.deletePersonalityOfDevTemp(\"%s\", com.sigrity.acl.db.std.Personality.Type.NET, \"%s\")", (Object[])new Object[]{personality.getName(), dtname});
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
        }
    };
    protected Action mDeletePortPersonality = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Personality> selected = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            if (selected.isEmpty()) {
                return;
            }
            for (Personality personality : selected) {
                boolean deleteMe = true;
                if (personality.getObjects().anyMatch(hi -> hi.second instanceof PinInstance)) {
                    String msg = String.format("Personality '%s' has related pins. Do you want to delete it?", personality.getKeyStr());
                    int r = JOptionPane.showConfirmDialog(PersonalitiesEditor.this.getContentPane(), msg, "Confirm Delete", 0, 3);
                    boolean bl = deleteMe = r == 0;
                }
                if (!deleteMe) continue;
                String dtname = personality.getOwner().getKeyStr();
                Cp.exec(() -> PersonalityUI.deletePersonalityOfDevTemp(personality.getName(), Personality.Type.PORT, dtname), (String)"com.sigrity.orbit.ui.PersonalityUI.deletePersonalityOfDevTemp(\"%s\", com.sigrity.acl.db.std.Personality.Type.PORT, \"%s\")", (Object[])new Object[]{personality.getName(), dtname});
                ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
            }
        }
    };
    protected ActionListener mFilterDevices = e -> {
        ArrayList<Personality> selected = this.mTreePersonalities.getSelectedPersonalities();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get(0);
        this.mDeviceChooserPanel.setFilter("personality", personality.getKeyStr());
    };
    JPopupMenu mNetPersonalityPopupMenu = new JPopupMenu(){
        protected Action mItemAdd;
        protected Action mItemDeleteAll;
        protected Action mItemEdit;
        protected Action mItemDelete;
        protected Action mItemAddSelectedNets;
        protected Action mItemSelectNets;
        protected Action mItemDeleteNets;
        protected Action mItemHighlight;
        protected Action mItemRemoveSelectedNets;

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            OrbitIO.getGuiWorkspace().beautify(this);
            super.show(invoker, x, y);
        }

        protected void prepare(int x, int y) {
            this.removeAll();
            OrbitGuiWS gws = OrbitIO.getApp().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            ArrayList<Personality> selPers = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            List<Personality.Type> selPersonalityTypes = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonityTypes();
            this.mItemAdd = this.add("Add...", PersonalitiesEditor.this.mAddNewNetPersonality);
            this.mItemDeleteAll = this.add("Delete All", PersonalitiesEditor.this.mDeleteAllNetPersonalities);
            this.mItemEdit = this.add("Edit...", PersonalitiesEditor.this.mEditNetPersonality);
            this.mItemDelete = this.add("Delete", PersonalitiesEditor.this.mDeleteNetPersonality);
            this.mItemDeleteNets = this.add("Remove Nets from Personality", PersonalitiesEditor.this.mRemoveNets);
            this.mItemAddSelectedNets = this.add("Add Selected Nets", PersonalitiesEditor.this.mAddSelectedNets);
            this.mItemRemoveSelectedNets = this.add("Remove Selected Nets", PersonalitiesEditor.this.mRemoveSelectedNets);
            this.mItemSelectNets = this.add("Select Nets", PersonalitiesEditor.this.mSelectNets);
            this.mItemHighlight = this.add("Highlight", PersonalitiesEditor.this.mHighlightPersonality);
            if (selPers.size() == 1) {
                HierInst hdbo = new HierInst(null, (DbObject)selPers.get(0));
                LinkedList objItems = AMenuUtil.groupByFirstWord(oar.getJMenuItems(hdbo));
                for (JMenuItem item : objItems) {
                    if (item.getAction().getValue("Name").equals("Selected")) continue;
                    this.add(item);
                }
            }
            this.mItemAdd.setEnabled(selPersonalityTypes.size() == 1);
            this.mItemDeleteAll.setEnabled(selPersonalityTypes.size() == 1);
            this.mItemEdit.setEnabled(selPers.size() == 1);
            this.mItemDelete.setEnabled(!selPers.isEmpty());
            this.mItemAddSelectedNets.setEnabled(selPers.size() == 1);
            this.mItemRemoveSelectedNets.setEnabled(selPers.size() == 1);
            this.mItemSelectNets.setEnabled(selPers.size() == 1);
            this.mItemDeleteNets.setEnabled(selPers.size() == 1);
            this.mItemHighlight.setEnabled(!selPers.isEmpty());
        }
    };
    JPopupMenu mNetObjectPersonalityPopupMenu = new JPopupMenu(){

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare();
            OrbitIO.getGuiWorkspace().beautify(this);
            super.show(invoker, x, y);
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        protected void prepare() {
            this.removeAll();
            ArrayList<APair<Personality, Net>> selNets = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityNets();
            Action itemDelete = this.add("Remove from Personality", PersonalitiesEditor.this.mRemoveNet);
            this.add("Copy or Move to Personality", PersonalitiesEditor.this.mMoveNetToPersonalities);
            itemDelete.setEnabled(!selNets.isEmpty());
            OrbitGuiWS gws = OrbitIO.getApp().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            this.addSeparator();
            if (selNets.size() == 1) {
                Net net = (Net)selNets.get(0).getSecond();
                DevicePath path = new DevicePath(PersonalitiesEditor.this.mDevT);
                for (JMenuItem item : oar.getJMenuItems(new HierInst(path, (DbObject)net))) {
                    this.add(item);
                }
            } else {
                Selection sel = new Selection(PersonalitiesEditor.this.mDb);
                for (APair<Personality, Net> psnNet : selNets) {
                    sel.add(new DevicePath(PersonalitiesEditor.this.mDevT), (DbObject)psnNet.getSecond());
                }
                for (JMenuItem item : oar.getJMenuItems(sel)) {
                    this.add(item);
                }
            }
        }
    };
    JPopupMenu mPinObjectPersonalityPopupMenu = new JPopupMenu(){
        protected Action mItemDelete;
        protected Action mItemMove;

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            OrbitIO.getGuiWorkspace().beautify(this);
            super.show(invoker, x, y);
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        protected void prepare(int x, int y) {
            this.removeAll();
            ArrayList<APair<Personality, PinInstance>> selPins = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityPins();
            this.mItemDelete = this.add("Remove from Personality", PersonalitiesEditor.this.mRemovePin);
            this.mItemMove = this.add("Copy or Move to Personality", PersonalitiesEditor.this.mMovePinToPersonalities);
            this.mItemDelete.setEnabled(selPins.size() > 0);
        }
    };
    JPopupMenu mDeviceObjectPersonalityPopupMenu = new JPopupMenu(){

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare();
            OrbitIO.getGuiWorkspace().beautify(this);
            super.show(invoker, x, y);
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        protected void prepare() {
            this.removeAll();
            ArrayList<APair<Personality, Device>> selDevices = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityDevices();
            Action itemDelete = this.add("Remove from Personality", PersonalitiesEditor.this.mRemoveDevice);
            this.add("Copy or Move to Personality", PersonalitiesEditor.this.mMoveDeviceToPersonalities);
            itemDelete.setEnabled(!selDevices.isEmpty());
            OrbitGuiWS gws = OrbitIO.getApp().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            this.addSeparator();
            if (selDevices.size() == 1) {
                Device device = (Device)selDevices.get(0).getSecond();
                DevicePath path = new DevicePath(PersonalitiesEditor.this.mDevT);
                for (JMenuItem item : AMenuUtil.groupByFirstWord(oar.getJMenuItems(new HierInst(path, (DbObject)device)))) {
                    this.add(item);
                }
            } else {
                Selection sel = new Selection(PersonalitiesEditor.this.mDb);
                for (APair<Personality, Device> psnDevice : selDevices) {
                    sel.add(new DevicePath(PersonalitiesEditor.this.mDevT), (DbObject)psnDevice.getSecond());
                }
                for (JMenuItem item : oar.getJMenuItems(sel)) {
                    this.add(item);
                }
            }
        }
    };
    JPopupMenu mDevicePersonalityPopupMenu = new JPopupMenu(){
        protected Action mItemAdd;
        protected Action mItemEdit;
        protected Action mItemDelete;
        protected Action mItemDeleteAll;
        protected Action mItemAddSelected;
        protected Action mItemSelectDevices;
        {
            this.mItemAdd = this.add("Add...", PersonalitiesEditor.this.mAddNewDevicePersonality);
            this.mItemEdit = this.add("Edit...", PersonalitiesEditor.this.mEditDevicePersonality);
            this.mItemDeleteAll = this.add("Delete All", PersonalitiesEditor.this.mDeleteAllDevicePersonalities);
            this.mItemDelete = this.add("Delete", PersonalitiesEditor.this.mDeleteDevicePersonality);
            this.mItemAddSelected = this.add("Add Selected Devices", PersonalitiesEditor.this.mAddSelectedDevices);
            this.mItemSelectDevices = this.add("Select Devices", PersonalitiesEditor.this.mSelectDevices);
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            OrbitIO.getGuiWorkspace().beautify(this);
            super.show(invoker, x, y);
        }

        protected void prepare(int x, int y) {
            ArrayList<Personality> selPers = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            List<Personality.Type> selPersonalityTypes = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonityTypes();
            this.mItemAdd.setEnabled(selPersonalityTypes.size() == 1);
            this.mItemEdit.setEnabled(selPers.size() == 1);
            this.mItemDelete.setEnabled(!selPers.isEmpty());
            this.mItemAddSelected.setEnabled(selPers.size() == 1);
            this.mItemSelectDevices.setEnabled(selPers.size() == 1);
            this.mItemDeleteAll.setEnabled(selPersonalityTypes.size() == 1);
        }
    };
    protected PersonalitiesTree.PopupMenuHandler mTreePopupMenuHandler = new PersonalitiesTree.PopupMenuHandler(){

        @Override
        public void handlePopup(int x, int y) {
            ArrayList<Personality> selPers = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalities();
            List<Personality.Type> selPersonalityTypes = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonityTypes();
            ArrayList<APair<Personality, Net>> selNets = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityNets();
            ArrayList<APair<Personality, PinInstance>> selPins = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityPins();
            ArrayList<APair<Personality, Device>> selDevices = PersonalitiesEditor.this.mTreePersonalities.getSelectedPersonalityDevices();
            if (selPers.size() == 1) {
                Personality p = selPers.get(0);
                if (p.getType() == Personality.Type.DEVICE) {
                    PersonalitiesEditor.this.mDevicePersonalityPopupMenu.show(PersonalitiesEditor.this.mTreePersonalities, x, y);
                } else if (p.getType() == Personality.Type.PORT) {
                    PersonalitiesEditor.this.showPinPersonalityPopupMenu(PersonalitiesEditor.this.mTreePersonalities, x, y);
                } else if (p.getType() == Personality.Type.NET) {
                    PersonalitiesEditor.this.mNetPersonalityPopupMenu.show(PersonalitiesEditor.this.mTreePersonalities, x, y);
                }
            } else if (selPersonalityTypes.size() == 1) {
                Personality.Type t = selPersonalityTypes.get(0);
                if (t == Personality.Type.DEVICE) {
                    PersonalitiesEditor.this.mDevicePersonalityPopupMenu.show(PersonalitiesEditor.this.mTreePersonalities, x, y);
                }
                if (t == Personality.Type.PORT) {
                    PersonalitiesEditor.this.showPinPersonalityPopupMenu(PersonalitiesEditor.this.mTreePersonalities, x, y);
                }
                if (t == Personality.Type.NET) {
                    PersonalitiesEditor.this.mNetPersonalityPopupMenu.show(PersonalitiesEditor.this.mTreePersonalities, x, y);
                }
            } else if (selNets.size() > 0) {
                PersonalitiesEditor.this.mNetObjectPersonalityPopupMenu.show(PersonalitiesEditor.this.mTreePersonalities, x, y);
            } else if (selPins.size() > 0) {
                PersonalitiesEditor.this.mPinObjectPersonalityPopupMenu.show(PersonalitiesEditor.this.mTreePersonalities, x, y);
            } else if (selDevices.size() > 0) {
                PersonalitiesEditor.this.mDeviceObjectPersonalityPopupMenu.show(PersonalitiesEditor.this.mTreePersonalities, x, y);
            }
        }
    };
    protected TreeSelectionListener mPersonalitySelListener = e -> this.enableButtons();
    static final int ICON_WIDTH = 12;
    static final int ICON_HEIGHT = 12;
    protected static final DataFlavor DF_DBOBJECTS = new DataFlavor(DbObject.class, "DbObjects Data Flavor");
    protected static final DataFlavor[] DF_ARRAY_DBOBJECTS = new DataFlavor[]{DF_DBOBJECTS};

    public PersonalitiesEditor(DeviceTemplate devT, String name) {
        super(devT.getDb(), String.format("%s:%d:%s", PersonalitiesEditor.class.getName(), devT.getDb().getId(), devT.getKeyStr()));
        this.mDevT = devT;
        this.setTitleText(String.format("Personalities - %s", name));
        this.setTitleIcon(null);
        final Container pane = this.getContentPane();
        GridBagManager l = new GridBagManager(pane);
        ATreeModel tm = new ATreeModel();
        this.mTreePersonalities = new PersonalitiesTree(tm);
        tm.setRoot((TreeNode)((Object)new RootNode(tm)));
        this.mTreePersonalities.setCellRenderer((TreeCellRenderer)((Object)new PTCellRenderer()));
        this.mTreePersonalities.setRootVisible(false);
        this.mTreePersonalities.setShowsRootHandles(true);
        this.mTreePersonalities.setPopupMenuHandler(this.mTreePopupMenuHandler);
        JScrollPane spPers = new JScrollPane(this.mTreePersonalities);
        l.add((Component)spPers, (GridBagConstraints)GridBagManager.FILLALL);
        this.mTreePersonalities.getSelectionModel().addTreeSelectionListener(this.mPersonalitySelListener);
        UIUtil.expandTreeLevels((JTree)this.mTreePersonalities, (int)3);
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX.noInsets());
        l.pop();
        this.setCloseable(true);
        pane.setMinimumSize(pane.getPreferredSize());
        this.enableButtons();
        DbClass dbcPersonality = this.getDb().getDbClass(Personality.class);
        assert (dbcPersonality != null);
        dbcPersonality.addObjectListener(this.mPersonalityListener, DbClass.DbObjectEventType.getUpdated());
        DbRelationDef dbrd = this.getDb().getRelation("PersonalityMap-personality");
        dbrd.addRelationListener((DbRelationDef.DbRelationListener)new DbRelationDef.DbRelationAdapter(){

            public void unrelated(DbRelationDef.RelationChange change) {
                pane.repaint();
            }

            public void related(DbRelationDef.RelationChange change) {
                pane.repaint();
            }
        }, DbRelationDef.RELATION_UPDATED);
        DbRelationDef rd = this.getDb().getRelation("PersonalityMap-personality");
        assert (rd != null);
        rd.addRelationListener(this.mRelationListener, DbRelationDef.RELATION_UPDATED);
    }

    protected DeviceTemplate getDevT() {
        return this.mDevT;
    }

    protected PersonalitiesTree getPersTree() {
        return this.mTreePersonalities;
    }

    protected RootNode getRootNode() {
        return (RootNode)((Object)this.mTreePersonalities.getModel().getRoot());
    }

    protected void enableButtons() {
    }

    private Set<DeviceTemplate> getTemplates(StoredPath sp) {
        HashSet<DeviceTemplate> templates = new HashSet<DeviceTemplate>();
        for (Device d : sp.getPath()) {
            templates.add(d.getTemplate());
        }
        templates.add(sp.getAnchor());
        return templates;
    }

    private Set<DeviceTemplate> getAncestorTemplates(Set<DeviceTemplate> ts) {
        return ts.stream().flatMap(t -> t.getHierarchicalInstances().stream()).flatMap(dp -> dp.getDeviceTemplatePath(true)).collect(Collectors.toSet());
    }

    private Set<DeviceTemplate> getPossibleOwners(DeviceTemplate owner, PersonalityMap pm) {
        Set<DeviceTemplate> possibleOwners = this.getTemplates(pm.getPath());
        Set<DeviceTemplate> ancestorTemplates = this.getAncestorTemplates(possibleOwners);
        possibleOwners.addAll(ancestorTemplates);
        possibleOwners.add(owner);
        return possibleOwners;
    }

    private Set<DeviceTemplate> intersection(Set<DeviceTemplate> a, Set<DeviceTemplate> b) {
        if (a == null) {
            return b;
        }
        if (a.isEmpty()) {
            return a;
        }
        a.retainAll(b);
        return a;
    }

    private List<Personality> getPersonalitiesSortedByTemplateAndPersonality(Set<DeviceTemplate> owners, Set<Personality> exclude, Personality.Type type) {
        List sortedOwners = owners.stream().sorted((t1, t2) -> t1.getName().compareTo(t2.getName())).collect(Collectors.toList());
        LinkedList<Personality> sortedTargets = new LinkedList<Personality>();
        for (DeviceTemplate t : sortedOwners) {
            sortedTargets.addAll(Personality.getPersonalities((DeviceTemplate)t, (Personality.Type)type).filter(psn -> !exclude.contains(psn)).sorted(AUtil::compareAlphaNumericAccountForNone).collect(Collectors.toList()));
        }
        return sortedTargets;
    }

    private <T extends DbObject> List<Object> getSortedTargetablePersonalities(List<APair<Personality, T>> selected, Personality.Type type, String dboTypeName) {
        Set<DeviceTemplate> owners = null;
        HashSet<Personality> originalPersonalities = new HashSet<Personality>();
        for (APair<Personality, T> pair : selected) {
            Personality psn = (Personality)pair.first;
            DbObject dbo = (DbObject)pair.second;
            Stream pms = PersonalityMap.getPersonalityMaps((DbObject)dbo, (Personality)psn);
            DeviceTemplate owner = psn.getOwner();
            originalPersonalities.add(psn);
            HashSet<DeviceTemplate> possibleOwners = new HashSet<DeviceTemplate>();
            pms.forEach(pm -> possibleOwners.addAll(this.getPossibleOwners(owner, (PersonalityMap)pm)));
            if (!(owners = this.intersection(owners, possibleOwners)).isEmpty()) continue;
            break;
        }
        if (owners == null) {
            ALog.logWarn((String)"No %s is selected!", (Object[])new Object[]{dboTypeName});
            return Collections.emptyList();
        }
        List<Personality> list = this.getPersonalitiesSortedByTemplateAndPersonality(owners, originalPersonalities, type);
        return list;
    }

    private void reenumerateObjectsOfPersonality(TreePath[] selPaths) {
        ArrayList<PersonalityUI.PersonalityNode> refreshNodes = this.mTreePersonalities.getPersonalityNodesOfSelectedObjects(selPaths);
        for (PersonalityUI.PersonalityNode node : refreshNodes) {
            node.invalidateChildren();
        }
    }

    private static boolean hasSelectedPins(DeviceTemplate devTemp) {
        Design design = OrbitIO.getCurDesign();
        Selection selected = design.getCurSelection();
        PinInstance dp = null;
        for (PinInstance port : selected.get(PinInstance.class)) {
            DeviceTemplate dt = port.getDeviceTemplate();
            if (dt != devTemp) continue;
            dp = port;
            break;
        }
        if (dp == null) {
            ALog.logWarn((String)("Select pins on " + devTemp.getName() + " before distribution. Select Pin personalities and Edit... and then setup 'Assignment ratio's"));
            return false;
        }
        return true;
    }

    void showPinPersonalityPopupMenu(Component invoker, int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        Action itemAdd = this.mAddNewPortPersonality;
        Action mItemCopy = this.mCopyPortPersonality;
        Action mItemEdit = this.mEditPortPersonality;
        Action mItemDelete = this.mDeletePortPersonality;
        Action mItemDeleteAll = this.mDeleteAllPinPersonalities;
        Action mItemMoveSelectedPorts = this.mMoveSelectedPorts;
        Action mItemRemoveSelectedPorts = this.mRemoveSelectedPorts;
        Action mItemPickPortsToAdd = this.mPickPortsToAdd;
        Action mItemSelectPorts = this.mSelectPorts;
        Action mItemDistributePorts = this.mDistributePorts;
        Action mItemHighlight = this.mHighlightPersonality;
        mItemMoveSelectedPorts.putValue("Name", "Add Selected Pins");
        menu.add(itemAdd);
        menu.add(mItemCopy);
        menu.add(mItemEdit);
        menu.add(mItemDelete);
        menu.add(mItemDeleteAll);
        menu.add(mItemMoveSelectedPorts);
        menu.add(mItemRemoveSelectedPorts);
        menu.add(mItemPickPortsToAdd);
        menu.add(mItemSelectPorts);
        menu.add(mItemDistributePorts);
        menu.add(mItemHighlight);
        ArrayList<Personality> selPers = this.mTreePersonalities.getSelectedPersonalities();
        List<Personality.Type> selPersonalityTypes = this.mTreePersonalities.getSelectedPersonityTypes();
        Design design = OrbitIO.getCurDesign();
        Selection selection = design.getCurSelection();
        boolean selPins = selection.getCount(PinInstance.class) > 0;
        itemAdd.setEnabled(selPersonalityTypes.size() == 1);
        mItemCopy.setEnabled(selPersonalityTypes.size() == 1);
        mItemEdit.setEnabled(selPers.size() == 1);
        mItemDelete.setEnabled(!selPers.isEmpty());
        mItemMoveSelectedPorts.setEnabled(selPers.size() == 1 && selPins);
        mItemRemoveSelectedPorts.setEnabled(selPers.size() == 1 && selPins);
        mItemPickPortsToAdd.setEnabled(selPers.size() == 1);
        mItemSelectPorts.setEnabled(selPers.size() == 1);
        mItemDistributePorts.setEnabled(selPersonalityTypes.size() == 1);
        mItemDeleteAll.setEnabled(selPersonalityTypes.size() == 1);
        mItemPickPortsToAdd.setEnabled(false);
        mItemHighlight.setEnabled(!selPers.isEmpty());
        OrbitIO.getGuiWorkspace().beautify(menu);
        menu.show(invoker, x, y);
    }

    protected void initDAndD() {
        DbItemDnDHandler h = new DbItemDnDHandler();
        this.mTreePersonalities.setTransferHandler(h);
        this.mTreePersonalities.setDropTarget(new DropTarget(this.mTreePersonalities, h));
        this.mTreePersonalities.setDragEnabled(true);
        this.mDeviceChooserPanel.mTreeDevices.setTransferHandler(h);
        this.mDeviceChooserPanel.mTreeDevices.setDropTarget(new DropTarget(this.mDeviceChooserPanel.mTreeDevices, h));
        this.mDeviceChooserPanel.mTreeDevices.setDragEnabled(true);
    }

    protected void doNetConstraintUpdateCommands(PersonalityUI.NetPersonalityEditDlg dlg, String templateName) {
        boolean matchLength = dlg.getMatchLength();
        boolean starTopology = false;
        boolean power = dlg.getPower();
        boolean keepGap = false;
        long gapDistance = 0L;
        Cp.exec(() -> PersonalityUI.setPersonalityNetByDevTempConstraints(dlg.getPersonalityName(), templateName, matchLength, starTopology, power, keepGap, gapDistance), (String)"com.sigrity.orbit.ui.PersonalityUI.setPersonalityNetByDevTempConstraints (\"%s\", \"%s\", %b, %b, %b, %b, %dL)", (Object[])new Object[]{dlg.getPersonalityName(), templateName, matchLength, starTopology, power, keepGap, gapDistance});
    }

    protected void doPortConstraintUpdateCommands(PersonalityUI.PortPersonalityEditDlg dlg, String templateName) {
        long ratio = dlg.getPortAssignRatio();
        String swap = Boolean.toString(dlg.isAllowSwapping());
        Cp.exec(() -> PersonalityUI.setPersonalityByDevTempPortConstraints(dlg.getPersonalityName(), templateName, ratio, dlg.isAllowSwapping()), (String)"com.sigrity.orbit.ui.PersonalityUI.setPersonalityByDevTempPortConstraints (\"%s\", \"%s\", %dL, %s)", (Object[])new Object[]{dlg.getPersonalityName(), templateName, ratio, swap});
    }

    protected void doGridAreaUpdateCommands(PersonalityUI.DevicePersonalityEditDlg dlg, String templateName) {
        AGrid grid = dlg.getGrid();
        if (grid != null) {
            Cp.exec(() -> PersonalityUI.setPersonalityPlacementGridByDevTemp(dlg.getPersonalityName(), templateName, grid.getOrignX(), grid.getOrignY(), grid.getDeltaX(), grid.getDeltaY()), (String)"com.sigrity.orbit.ui.PersonalityUI.setPersonalityPlacementGridByDevTemp(\"%s\", \"%s\", %dL, %dL, %dL, %dL)", (Object[])new Object[]{dlg.getPersonalityName(), templateName, grid.getOrignX(), grid.getOrignY(), grid.getDeltaX(), grid.getDeltaY()});
        } else {
            Cp.exec(() -> PersonalityUI.setPersonalityPlacementGridByDevTemp(dlg.getPersonalityName(), templateName, 0L, 0L, 0L, 0L), (String)"com.sigrity.orbit.ui.PersonalityUI.setPersonalityPlacementGridByDevTemp(\"%s\", \"%s\", 0, 0, 0, 0)", (Object[])new Object[]{dlg.getPersonalityName(), templateName});
        }
        ARect area = dlg.getPlacementArea();
        if (area != null) {
            Cp.exec(() -> PersonalityUI.setPersonalityPlacementAreaByDevTemp(dlg.getPersonalityName(), templateName, area.left(), area.bottom(), area.right(), area.top()), (String)"com.sigrity.orbit.ui.PersonalityUI.setPersonalityPlacementAreaByDevTemp(\"%s\", \"%s\", %dL, %dL, %dL, %dL)", (Object[])new Object[]{dlg.getPersonalityName(), templateName, area.left(), area.bottom(), area.right(), area.top()});
            Cp.exec(() -> PersonalityUI.setPersonalityPlacementAreaExclusiveByDevTemp(dlg.getPersonalityName(), templateName, dlg.getPlacementAreaExclusive()), (String)"com.sigrity.orbit.ui.PersonalityUI.setPersonalityPlacementAreaExclusiveByDevTemp(\"%s\", \"%s\", %b)", (Object[])new Object[]{dlg.getPersonalityName(), templateName, dlg.getPlacementAreaExclusive()});
        } else {
            Cp.exec(() -> PersonalityUI.setPersonalityPlacementAreaByDevTemp(dlg.getPersonalityName(), templateName, 0L, 0L, 0L, 0L), (String)"com.sigrity.orbit.ui.PersonalityUI.setPersonalityPlacementAreaByDevTemp(\"%s\", \"%s\", 0, 0, 0, 0)", (Object[])new Object[]{dlg.getPersonalityName(), templateName});
        }
    }

    protected static DbTransferData getDbTransferData(Transferable t) {
        Object o = null;
        try {
            o = t.getTransferData(DF_DBOBJECTS);
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Error getting transer data from Transferable.", (Object[])new Object[0]);
            return null;
        }
        if (!(o instanceof DbTransferData)) {
            ALog.logError((Throwable)new Exception("Transfer data error"), (String)"Invalid transfer data.", (Object[])new Object[0]);
            return null;
        }
        return (DbTransferData)o;
    }

    protected static class DbTransferable
    implements Transferable {
        protected DbTransferData mData;

        public DbTransferable(JComponent srcComp, List<? extends DbObject> objects) {
            this.mData = new DbTransferData(srcComp, objects);
        }

        @Override
        public DbTransferData getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == DF_DBOBJECTS) {
                return this.mData;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return DF_ARRAY_DBOBJECTS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == DF_DBOBJECTS;
        }

        public List<? extends DbObject> getDbObjects() {
            return this.mData.mDbObects;
        }

        public JComponent getSourceComponent() {
            return this.mData.mSrcComp;
        }
    }

    static class DbTransferData {
        JComponent mSrcComp;
        List<? extends DbObject> mDbObects;

        public DbTransferData(JComponent srcComp, List<? extends DbObject> dbObects) {
            this.mSrcComp = srcComp;
            this.mDbObects = dbObects;
        }
    }

    protected class DbItemDnDHandler
    extends TransferHandler
    implements DropTargetListener {
        protected DbItemDnDHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            List<Device> devices = null;
            if (c == PersonalitiesEditor.this.mTreePersonalities) {
                devices = PersonalitiesEditor.this.mTreePersonalities.getSelectedDevices();
            } else if (c == PersonalitiesEditor.this.mDeviceChooserPanel.mTreeDevices) {
                devices = new ArrayList<Device>();
                for (Object o : PersonalitiesEditor.this.mDeviceChooserPanel.getSelectedValues()) {
                    if (!(o instanceof Device)) continue;
                    devices.add((Device)o);
                }
            }
            if (devices != null && !devices.isEmpty()) {
                return new DbTransferable(c, devices);
            }
            return null;
        }

        @Override
        public boolean importData(JComponent tgtComp, Transferable t) {
            DbTransferData data = PersonalitiesEditor.getDbTransferData(t);
            if (tgtComp != PersonalitiesEditor.this.mTreePersonalities || data == null) {
                return false;
            }
            if (PersonalitiesEditor.this.mTreePersonalities.mDropTaget == null) {
                return false;
            }
            Personality personality = PersonalitiesEditor.this.mTreePersonalities.mDropTaget.mPersonality;
            HashSet<Personality> modifiedPersonalities = new HashSet<Personality>();
            StringBuilder devices = new StringBuilder();
            for (DbObject dbObject : data.mDbObects) {
                if (!(dbObject instanceof Device)) continue;
                Device d = (Device)dbObject;
                Personality oldPersonality = d.getPersonality();
                if (devices.length() > 0) {
                    devices.append(", ");
                }
                devices.append('\"');
                devices.append(d.getKeyStr());
                devices.append('\"');
                if (modifiedPersonalities.isEmpty()) {
                    modifiedPersonalities.add(personality);
                }
                modifiedPersonalities.add(oldPersonality);
            }
            Cp.exec(() -> PersonalityUI.setDevicePersonalities(OrbitIO.getCurDb(), new String[]{devices.toString()}, personality.getName(), personality.getOwner().getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.setDevicePersonalities(curDb(), new String[] { %s }, \"%s\", \"%s\")", (Object[])new Object[]{devices.toString(), personality.getName(), personality.getOwner().getKeyStr()});
            return true;
        }

        @Override
        protected void exportDone(JComponent srcComp, Transferable data, int action) {
            if (srcComp == PersonalitiesEditor.this.mDeviceChooserPanel.mTreeDevices) {
                PersonalitiesEditor.this.mDeviceChooserPanel.updateAllDevices();
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.dragOver(dtde);
        }

        @Override
        public void dragExit(DropTargetEvent dtde) {
            PersonalitiesEditor.this.mTreePersonalities.showDrop(null, null);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            Object o = dtde.getSource();
            if (!(o instanceof DropTarget)) {
                dtde.rejectDrag();
                return;
            }
            DropTarget dt = (DropTarget)o;
            Component comp = dt.getComponent();
            Point pt = dtde.getLocation();
            if (comp instanceof Autoscroll) {
                ((Autoscroll)((Object)comp)).autoscroll(pt);
            }
            PersonalitiesEditor.this.mTreePersonalities.showDrop(null, null);
            int action = dtde.getDropAction();
            if (action != 2) {
                dtde.rejectDrag();
                return;
            }
            if (comp == PersonalitiesEditor.this.mTreePersonalities && dtde.getCurrentDataFlavorsAsList().contains(DF_DBOBJECTS) && PersonalitiesEditor.this.mTreePersonalities.showDrop(dtde.getTransferable(), pt) != null) {
                dtde.acceptDrag(action);
                return;
            }
            dtde.rejectDrag();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Component comp = dtde.getDropTargetContext().getComponent();
            Transferable t = dtde.getTransferable();
            if (comp == PersonalitiesEditor.this.mTreePersonalities && dtde.getCurrentDataFlavorsAsList().contains(DF_DBOBJECTS)) {
                DbTransferData data;
                if (this.importData(PersonalitiesEditor.this.mTreePersonalities, t) && (data = PersonalitiesEditor.getDbTransferData(t)) != null) {
                    try {
                        this.exportDone(data.mSrcComp, t, dtde.getDropAction());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                PersonalitiesEditor.this.mTreePersonalities.showDrop(null, null);
            } else {
                dtde.rejectDrop();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.dragOver(dtde);
        }
    }

    protected class PTCellRenderer
    extends ATreeCellRenderer {
        protected PTCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (((PersonalitiesTree)tree).mDropTaget == value) {
                this.setBackground(Color.LIGHT_GRAY);
                this.setOpaque(true);
            } else {
                this.setOpaque(false);
                this.setBackground(new Color(0, 0, 0, 0));
            }
            if (value instanceof PersonalityUI.PersonalityNode) {
                PersonalityUI.PersonalityNode persNode = (PersonalityUI.PersonalityNode)((Object)value);
                Personality p = persNode.mPersonality;
                Color color = p.getColor();
                if (c != null) {
                    this.setIcon((Icon)new AColorIcon(12, 12, color));
                }
                this.setText(p.getName() + " (" + persNode.getChildCount() + ")");
            }
            if (value instanceof PersonalityTypeNode) {
                Personality.Type t = ((PersonalityTypeNode)((Object)value)).mType;
                this.setIcon(PersonalityUI.getIconForPersonalityType(t));
            }
            if (value instanceof DevTempNode) {
                DeviceTemplate aDT = ((DevTempNode)((Object)value)).mDevTemp;
                if (aDT != null) {
                    this.setIcon(DbExplorerPanel.getIconForTemplate(aDT));
                } else {
                    this.setIcon(DbExplorerPanel.getFolderIcon());
                }
            }
            return c;
        }
    }

    protected static class PersonalitiesTree
    extends JTree
    implements Autoscroll {
        protected ATreeModel mDbTreeModel;
        protected PersonalityUI.PersonalityNode mOldDropTarget = null;
        protected PersonalityUI.PersonalityNode mDropTaget = null;
        protected PopupMenuHandler mPopupMenuHandler = null;
        protected MouseListener mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!this.editPersonalityColor(e) && e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!this.editPersonalityColor(e) && e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!this.editPersonalityColor(e) && e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }
        };
        protected Insets mAutoscrollInsets = new Insets(20, 20, 20, 20);

        public PersonalitiesTree(ATreeModel tm) {
            super((TreeModel)tm);
            this.mDbTreeModel = tm;
            this.addMouseListener(this.mMouseListener);
        }

        public void setPopupMenuHandler(PopupMenuHandler h) {
            this.mPopupMenuHandler = h;
        }

        public List<Device> getSelectedDevices() {
            ArrayList<Device> res = new ArrayList<Device>();
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return res;
            }
            for (TreePath path : paths) {
                PersonalityUI.DbTreeObjNode on;
                DbObject dbo;
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.DbTreeObjNode) || !((dbo = (on = (PersonalityUI.DbTreeObjNode)((Object)o)).getDbObject()) instanceof Device)) continue;
                res.add((Device)dbo);
            }
            return res;
        }

        public ArrayList<APair<Personality, Net>> getSelectedPersonalityNets() {
            ArrayList<APair<Personality, Net>> res = new ArrayList<APair<Personality, Net>>();
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return res;
            }
            for (TreePath path : paths) {
                Object op;
                PersonalityUI.DbTreeObjNode on;
                DbObject dbo;
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.DbTreeObjNode) || !((dbo = (on = (PersonalityUI.DbTreeObjNode)((Object)o)).getDbObject()) instanceof Net) || !((op = path.getParentPath().getLastPathComponent()) instanceof PersonalityUI.PersonalityNode)) continue;
                res.add((APair<Personality, Net>)new APair((Object)((PersonalityUI.PersonalityNode)((Object)op)).getPersonality(), (Object)((Net)dbo)));
            }
            return res;
        }

        public ArrayList<APair<Personality, PinInstance>> getSelectedPersonalityPins() {
            ArrayList<APair<Personality, PinInstance>> res = new ArrayList<APair<Personality, PinInstance>>();
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return res;
            }
            for (TreePath path : paths) {
                Object op;
                PersonalityUI.DbTreeObjNode on;
                DbObject dbo;
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.DbTreeObjNode) || !((dbo = (on = (PersonalityUI.DbTreeObjNode)((Object)o)).getDbObject()) instanceof PinInstance) || !((op = path.getParentPath().getLastPathComponent()) instanceof PersonalityUI.PersonalityNode)) continue;
                res.add((APair<Personality, PinInstance>)new APair((Object)((PersonalityUI.PersonalityNode)((Object)op)).getPersonality(), (Object)((PinInstance)dbo)));
            }
            return res;
        }

        public ArrayList<APair<Personality, Device>> getSelectedPersonalityDevices() {
            ArrayList<APair<Personality, Device>> res = new ArrayList<APair<Personality, Device>>();
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return res;
            }
            for (TreePath path : paths) {
                Object op;
                PersonalityUI.DbTreeObjNode on;
                DbObject dbo;
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.DbTreeObjNode) || !((dbo = (on = (PersonalityUI.DbTreeObjNode)((Object)o)).getDbObject()) instanceof Device) || !((op = path.getParentPath().getLastPathComponent()) instanceof PersonalityUI.PersonalityNode)) continue;
                res.add((APair<Personality, Device>)new APair((Object)((PersonalityUI.PersonalityNode)((Object)op)).getPersonality(), (Object)((Device)dbo)));
            }
            return res;
        }

        public boolean allSelectedArePersonalityNets() {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return false;
            }
            for (TreePath path : paths) {
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.DbTreeObjNode)) {
                    return false;
                }
                PersonalityUI.DbTreeObjNode on = (PersonalityUI.DbTreeObjNode)((Object)o);
                DbObject dbo = on.getDbObject();
                if (!(dbo instanceof Net)) {
                    return false;
                }
                Object op = path.getParentPath().getLastPathComponent();
                if (op instanceof PersonalityUI.PersonalityNode) continue;
                return false;
            }
            return true;
        }

        public boolean allSelectedArePersonalityPins() {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return false;
            }
            for (TreePath path : paths) {
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.DbTreeObjNode)) {
                    return false;
                }
                PersonalityUI.DbTreeObjNode on = (PersonalityUI.DbTreeObjNode)((Object)o);
                DbObject dbo = on.getDbObject();
                if (!(dbo instanceof PinInstance)) {
                    return false;
                }
                Object op = path.getParentPath().getLastPathComponent();
                if (op instanceof PersonalityUI.PersonalityNode) continue;
                return false;
            }
            return true;
        }

        public boolean allSelectedArePersonalityDevices() {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return false;
            }
            for (TreePath path : paths) {
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.DbTreeObjNode)) {
                    return false;
                }
                PersonalityUI.DbTreeObjNode on = (PersonalityUI.DbTreeObjNode)((Object)o);
                DbObject dbo = on.getDbObject();
                if (!(dbo instanceof Device)) {
                    return false;
                }
                Object op = path.getParentPath().getLastPathComponent();
                if (op instanceof PersonalityUI.PersonalityNode) continue;
                return false;
            }
            return true;
        }

        public ArrayList<PersonalityUI.PersonalityNode> getPersonalityNodesOfSelectedObjects(TreePath[] selPaths) {
            ArrayList<PersonalityUI.PersonalityNode> res = new ArrayList<PersonalityUI.PersonalityNode>();
            if (selPaths == null) {
                return res;
            }
            for (TreePath path : selPaths) {
                Object o;
                int count = path.getPathCount();
                if (count < 2 || !((o = path.getPath()[count - 2]) instanceof PersonalityUI.PersonalityNode)) continue;
                res.add((PersonalityUI.PersonalityNode)((Object)o));
            }
            return res;
        }

        public ArrayList<Personality> getSelectedPersonalities() {
            ArrayList<Personality> res = new ArrayList<Personality>();
            TreePath[] selPaths = this.getSelectionPaths();
            if (selPaths == null) {
                return res;
            }
            for (TreePath path : selPaths) {
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.PersonalityNode)) continue;
                res.add(((PersonalityUI.PersonalityNode)((Object)o)).mPersonality);
            }
            return res;
        }

        public List<Personality.Type> getSelectedPersonityTypes() {
            ArrayList<Personality.Type> res = new ArrayList<Personality.Type>();
            TreePath[] selPaths = this.getSelectionPaths();
            if (selPaths == null) {
                return res;
            }
            for (TreePath path : selPaths) {
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityTypeNode)) continue;
                res.add(((PersonalityTypeNode)((Object)o)).mType);
            }
            return res;
        }

        public List<DeviceTemplate> getSelectedDeviceTemplates() {
            ArrayList<DeviceTemplate> res = new ArrayList<DeviceTemplate>();
            TreePath[] selPaths = this.getSelectionPaths();
            if (selPaths == null) {
                return res;
            }
            for (TreePath path : selPaths) {
                Object o = path.getLastPathComponent();
                if (o instanceof DevTempNode) {
                    res.add(((DevTempNode)((Object)o)).mDevTemp);
                }
                if (!(o instanceof PersonalityTypeNode)) continue;
                res.add(((DevTempNode)((Object)path.getParentPath().getLastPathComponent())).mDevTemp);
            }
            return res;
        }

        public PersonalityUI.PersonalityNode showDrop(Transferable data, Point pt) {
            ATreeNode node = pt == null ? null : this.getNodeAtPoint(pt);
            this.mDropTaget = node instanceof PersonalityUI.PersonalityNode ? (PersonalityUI.PersonalityNode)node : null;
            if (this.mOldDropTarget != this.mDropTaget) {
                this.repaint();
                this.mOldDropTarget = this.mDropTaget;
            }
            return this.mDropTaget;
        }

        public ATreeNode getNodeAtPoint(Point pt) {
            TreePath path = this.getPathForLocation(pt.x, pt.y);
            if (path == null) {
                return null;
            }
            Object obj = path.getLastPathComponent();
            if (obj instanceof ATreeNode) {
                return (ATreeNode)obj;
            }
            return null;
        }

        public void repaint(Personality personality) {
            int rowCount = this.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                TreePath path = this.getPathForRow(i);
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.PersonalityNode)) continue;
                PersonalityUI.PersonalityNode pn = (PersonalityUI.PersonalityNode)((Object)o);
                if (pn.mPersonality != personality) continue;
                Rectangle r = this.getPathBounds(path);
                this.repaint(r);
                return;
            }
        }

        boolean editPersonalityColor(MouseEvent e) {
            Personality personality = this.getColorIconClickedPersonality(e);
            if (personality != null) {
                AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)this, "Select Color", personality.getColor());
                ccd.setShowOpacity(true);
                Color c = ccd.doModal();
                if (c != null) {
                    Personality.Type type = personality.getType();
                    String typeString = String.format("%s.%s", type.getClass().getCanonicalName(), type.toString());
                    String templateKeyStr = personality.getOwner().getKeyStr();
                    boolean updated = false;
                    if (updated |= ((Boolean)Cp.exec(() -> PersonalityUI.updatePersonalityColor(type, personality.getName(), templateKeyStr, AUtil.colorToString((Color)c)), (String)"com.sigrity.orbit.ui.PersonalityUI.updatePersonalityColor(%s, \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{typeString, personality.getName(), templateKeyStr, AUtil.colorToString((Color)c)})).booleanValue()) {
                        this.repaint(personality);
                    }
                }
                return true;
            }
            return false;
        }

        Personality getColorIconClickedPersonality(MouseEvent e) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return null;
            }
            Object obj = path.getLastPathComponent();
            if (!PersonalityUI.PersonalityNode.class.isInstance(obj)) {
                return null;
            }
            Rectangle bounds = this.getPathBounds(path);
            Rectangle iconBounds = new Rectangle(bounds.x, bounds.y, 12, 12);
            PersonalityUI.PersonalityNode pn = (PersonalityUI.PersonalityNode)((Object)obj);
            return iconBounds.contains(e.getPoint()) ? pn.getPersonality() : null;
        }

        protected void popupMenu(MouseEvent e) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            if (!this.isRowSelected(row)) {
                this.setSelectionRow(row);
            } else if (!(this.allSelectedArePersonalityNets() || this.allSelectedArePersonalityPins() || this.allSelectedArePersonalityDevices())) {
                this.setSelectionRow(row);
            }
            if (this.mPopupMenuHandler != null) {
                this.mPopupMenuHandler.handlePopup(e.getX(), e.getY());
            }
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.mAutoscrollInsets;
        }

        @Override
        public void autoscroll(Point cursorLocation) {
            Insets insets = this.getAutoscrollInsets();
            Rectangle outer = this.getVisibleRect();
            Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
            if (!inner.contains(cursorLocation)) {
                Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
                this.scrollRectToVisible(scrollRect);
            }
        }

        static interface PopupMenuHandler {
            public void handlePopup(int var1, int var2);
        }
    }

    protected class PersonalityTypeNode
    extends ALazyTreeNode {
        protected Personality.Type mType;
        protected ArrayList<PersonalityUI.PersonalityNode> mPersonalityNodes;
        protected DeviceTemplate mDevTemp;

        public PersonalityTypeNode(ATreeNode parent, DeviceTemplate dt, Personality.Type t) {
            super(parent);
            this.mType = t;
            this.mDevTemp = dt;
        }

        public Personality.Type getType() {
            return this.mType;
        }

        public IterableIterator<PersonalityUI.PersonalityNode> getPersonalityNodes() {
            if (this.mPersonalityNodes == null) {
                return AEmptyItr.create();
            }
            return new AIterableItr(this.mPersonalityNodes.iterator());
        }

        public int getIndex(Personality p) {
            if (this.mPersonalityNodes == null) {
                return -1;
            }
            for (int i = 0; i < this.mPersonalityNodes.size(); ++i) {
                if (this.mPersonalityNodes.get(i).getPersonality() != p) continue;
                return i;
            }
            return -1;
        }

        public PersonalityUI.PersonalityNode getNode(int idx) {
            if (this.mPersonalityNodes == null) {
                return null;
            }
            return this.mPersonalityNodes.get(idx);
        }

        public void add(Personality p) {
            if (this.mPersonalityNodes == null) {
                return;
            }
            PersonalityUI.PersonalityNode[] children = new PersonalityUI.PersonalityNode[]{new PersonalityUI.PersonalityNode((ATreeNode)this, p, this.mType)};
            int[] indices = new int[]{this.getChildCount()};
            this.mPersonalityNodes.add(children[0]);
            this.mTreeModel.treeNodesInserted((Object)this, this.getTreePath().getPath(), indices, (Object[])children);
        }

        public void remove(int idx) {
            if (this.mPersonalityNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mPersonalityNodes.get(idx)};
            this.mPersonalityNodes.remove(idx);
            this.mTreeModel.treeNodesRemoved((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public void update(int idx) {
            if (this.mPersonalityNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mPersonalityNodes.get(idx)};
            this.mTreeModel.treeNodesChanged((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public ArrayList<PersonalityUI.PersonalityNode> populateChildren() {
            this.mPersonalityNodes = new ArrayList();
            if (this.mDevTemp == null) {
                Personality.getPersonalities((DeviceTemplate)this.mDevTemp, (Personality.Type)this.mType).forEach(p -> this.mPersonalityNodes.add(new PersonalityUI.PersonalityNode((ATreeNode)this, (Personality)p, this.mType)));
                for (Personality p2 : OrbitIO.getApp().getCurrentDb().getObjects(Personality.class)) {
                    if (p2.getOwner() != null || p2.getType() != this.mType) continue;
                    this.mPersonalityNodes.add(new PersonalityUI.PersonalityNode((ATreeNode)this, p2, this.mType));
                }
            } else {
                Personality.getPersonalities((DeviceTemplate)this.mDevTemp, (Personality.Type)this.mType).forEach(p -> this.mPersonalityNodes.add(new PersonalityUI.PersonalityNode((ATreeNode)this, (Personality)p, this.mType)));
            }
            return this.mPersonalityNodes;
        }

        public String getText() {
            switch (this.mType) {
                case DEVICE: {
                    return "Device Personalities";
                }
                case PORT: {
                    return "Pin Personalities";
                }
                case NET: {
                    return "Net Personalities";
                }
            }
            return this.mType.toString();
        }
    }

    protected class DevTempNode
    extends ALazyTreeNode {
        protected ArrayList<PersonalityTypeNode> mPersonalityTypeNodes;
        protected DeviceTemplate mDevTemp;

        public DevTempNode(ATreeNode m, DeviceTemplate s) {
            super(m);
            this.mDevTemp = s;
        }

        public DeviceTemplate getDevTemp() {
            return this.mDevTemp;
        }

        public ArrayList<PersonalityTypeNode> populateChildren() {
            this.mPersonalityTypeNodes = new ArrayList();
            this.mPersonalityTypeNodes.add(new PersonalityTypeNode((ATreeNode)this, this.mDevTemp, Personality.Type.DEVICE));
            this.mPersonalityTypeNodes.add(new PersonalityTypeNode((ATreeNode)this, this.mDevTemp, Personality.Type.PORT));
            this.mPersonalityTypeNodes.add(new PersonalityTypeNode((ATreeNode)this, this.mDevTemp, Personality.Type.NET));
            return this.mPersonalityTypeNodes;
        }

        public String getText() {
            if (this.mDevTemp == null) {
                return "Design";
            }
            return this.mDevTemp.getQualifiedName();
        }

        public IterableIterator<PersonalityTypeNode> getPersonalityTypeNodes() {
            if (this.mPersonalityTypeNodes == null) {
                return AEmptyItr.create();
            }
            return new AIterableItr(this.mPersonalityTypeNodes.iterator());
        }

        public PersonalityTypeNode getPersonalityTypeNode(Personality.Type pt) {
            for (PersonalityTypeNode ptn : this.getPersonalityTypeNodes()) {
                if (ptn.getType() != pt) continue;
                return ptn;
            }
            return null;
        }

        public PersonalityUI.PersonalityNode findNodeFor(Personality p) {
            PersonalityTypeNode ptn = this.getPersonalityTypeNode(p.getType());
            if (ptn == null) {
                return null;
            }
            int idxPersonality = ptn.getIndex(p);
            if (idxPersonality == -1) {
                return null;
            }
            return ptn.getNode(idxPersonality);
        }
    }

    protected class RootNode
    extends ALazyTreeNode {
        protected ArrayList<DevTempNode> mDevTempNodes;

        public RootNode(ATreeModel m) {
            super(m);
            this.setSortChildren(false);
        }

        public ArrayList<DevTempNode> populateChildren() {
            this.mDevTempNodes = new ArrayList();
            this.mDevTempNodes.add(new DevTempNode((ATreeNode)this, PersonalitiesEditor.this.mDevT));
            return this.mDevTempNodes;
        }

        public String getText() {
            return "Device Templates";
        }

        public int getIndex(DeviceTemplate dt) {
            if (this.mDevTempNodes == null) {
                return -1;
            }
            for (int i = 0; i < this.mDevTempNodes.size(); ++i) {
                if (this.mDevTempNodes.get(i).getDevTemp() != dt) continue;
                return i;
            }
            return -1;
        }

        public void add(DeviceTemplate dt) {
            if (this.mDevTempNodes == null) {
                return;
            }
            DevTempNode[] children = new DevTempNode[]{new DevTempNode((ATreeNode)this, dt)};
            int[] indices = new int[]{this.getChildCount()};
            this.mDevTempNodes.add(children[0]);
            this.mTreeModel.treeNodesInserted((Object)this, this.getTreePath().getPath(), indices, (Object[])children);
        }

        public void remove(int idx) {
            if (this.mDevTempNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mDevTempNodes.get(idx)};
            this.mDevTempNodes.remove(idx);
            this.mTreeModel.treeNodesRemoved((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public void update(int idx) {
            if (this.mDevTempNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mDevTempNodes.get(idx)};
            this.mTreeModel.treeNodesChanged((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public PersonalityUI.PersonalityNode findNode(Personality p) {
            if (p.getOwner() != null) {
                int idxSubstrate = this.getIndex(p.getOwner());
                if (idxSubstrate == -1) {
                    return null;
                }
                DevTempNode sn = this.mDevTempNodes.get(idxSubstrate);
                return sn.findNodeFor(p);
            }
            for (DevTempNode sn : this.mDevTempNodes) {
                PersonalityUI.PersonalityNode pn = sn.findNodeFor(p);
                if (pn == null) continue;
                return pn;
            }
            return null;
        }

        public void notifyChange(DbClass.DbObjectEvent event) {
            DbObject dbo = event.getDbObject();
            assert (dbo instanceof Personality);
            Personality personality = (Personality)dbo;
            Personality.Type pt = personality.getType();
            DeviceTemplate devTemp = personality.getOwner();
            if (event instanceof DbClass.ObjectAdd) {
                int idxSubstrate = this.getIndex(devTemp);
                if (idxSubstrate == -1) {
                    return;
                }
                DevTempNode sn = this.mDevTempNodes.get(idxSubstrate);
                PersonalityTypeNode ptn = sn.getPersonalityTypeNode(pt);
                if (ptn == null) {
                    return;
                }
                ptn.add(personality);
                return;
            }
            PersonalityUI.PersonalityNode pn = this.findNode(personality);
            if (pn == null) {
                return;
            }
            PersonalityTypeNode ptn = (PersonalityTypeNode)pn.getParent();
            int idxPersonalityNode = ptn.getIndex(personality);
            if (idxPersonalityNode == -1) {
                return;
            }
            if (event instanceof DbClass.ObjectRemove) {
                ptn.remove(idxPersonalityNode);
            } else if (event instanceof DbClass.ObjectChange) {
                ptn.update(idxPersonalityNode);
            }
        }
    }
}

