/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.Personalities;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class PersonalityActions {
    private static final String SETTINGS_SECTION = PersonalityActions.class.getName();
    public static final String SETTING_IMPORT_REPLACE = "ImportPersonalities-Replace";
    public static final ObjectActionRegistry.ActionFactory<HierInst<?>> HierInstActionFactory = (hInst, constraints) -> {
        if (hInst.getDbObject() instanceof DeviceTemplate) {
            DeviceTemplate devT = (DeviceTemplate)hInst.getDbObject();
            return AIterableItr.itr((Object[])new Action[]{PersonalityActions.getExportPinPersonalitiesAction(devT), PersonalityActions.getImportPinPersonalitiesAction(devT)});
        }
        return AEmptyItr.create();
    };
    public static final ObjectActionRegistry.ActionFactory<DbObject> DbObjectActionFactory = (dbo, constraints) -> HierInstActionFactory.getActions(HierInst.create((DevicePath)null, (DbObject)dbo), constraints);

    public static Action getExportPinPersonalitiesAction(final DeviceTemplate devT) {
        return new AbstractAction("Export Pin Personalities..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                AFileChooser fc = new AFileChooser();
                fc.setDialogTitle("Export Pin Personalities");
                fc.setFileFilter((FileFilter)AFileFilter.CSV);
                if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                    return;
                }
                File file = fc.getSelectedFile();
                Cp.exec(() -> Personalities.write((DeviceTemplate)((DeviceTemplate)OrbitIO.getCurDb().getByKeyStr(DeviceTemplate.class, devT.getKeyStr())), (String)file.getAbsolutePath(), Optional.of(Personalities.PinTypeFilter)), (String)"com.sigrity.orbit.Personalities.write(curDb().getByKeyStr(DeviceTemplate.class, \"%s\"), %s, Optional.of(com.sigrity.orbit.Personalities.PinTypeFilter))", (Object[])new Object[]{devT.getKeyStr(), Cp.getFileAsArgument((File)file)});
            }
        };
    }

    public static Action getImportPinPersonalitiesAction(final DeviceTemplate devT) {
        return new AbstractAction("Import Pin Personalities..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                AFileChooser fc = new AFileChooser();
                fc.setDialogTitle("Import Pin Personalities");
                fc.setFileFilter((FileFilter)AFileFilter.CSV);
                JPanel pnlOpts = new JPanel();
                GridBagManager l = GridBagManager.layout((Container)pnlOpts);
                JCheckBox cbAppend = (JCheckBox)l.addNl((Component)new JCheckBox("Replace existing personalities"));
                l.addFillY();
                cbAppend.setToolTipText("<html>If selected, imported personalities will replace any existing personalities;<br>otherwise, the imported personalities will be added to existing personalities");
                cbAppend.setSelected((Boolean)Settings.get((String)SETTINGS_SECTION, (String)PersonalityActions.SETTING_IMPORT_REPLACE, (Object)true));
                fc.setAccessory((JComponent)pnlOpts);
                if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                    return;
                }
                Settings.set((String)SETTINGS_SECTION, (String)PersonalityActions.SETTING_IMPORT_REPLACE, (Object)cbAppend.isSelected());
                Settings.save((String)SETTINGS_SECTION);
                File file = fc.getSelectedFile();
                Cp.exec(() -> Personalities.read((DeviceTemplate)((DeviceTemplate)OrbitIO.getCurDb().getByKeyStr(DeviceTemplate.class, devT.getKeyStr())), (String)file.getAbsolutePath(), Optional.of(Personalities.PinTypeFilter), (boolean)cbAppend.isSelected()), (String)"com.sigrity.orbit.Personalities.read(curDb().getByKeyStr(DeviceTemplate.class, \"%s\"), \"%s\", Optional.of(com.sigrity.orbit.Personalities.PinTypeFilter), %b)", (Object[])new Object[]{devT.getKeyStr(), Cp.getFileAsArgument((File)file), cbAppend.isSelected()});
                OrbitIO.refreshViewsOf(OrbitIO.getCurDb());
            }
        };
    }
}

