/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.DefaultCommonDockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AComponentTitledBorder;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.ActionOnPlaceableItem;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.RegexFilterField;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.Personalities;
import com.sigrity.orbit.cmd.NetCmd;
import com.sigrity.orbit.ui.DevicePathChooser;
import com.sigrity.orbit.ui.GetAnObjectChooserDlg;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.PersonalitiesEditor;
import com.sigrity.orbit.ui.PinUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.docking.DockingUtil;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;

public class PersonalityUI {
    private static final Icon ICON_PERSONALITYPORT = PersonalityUI.getIcon("res/iconPersonalitiesPin.png");
    private static final Icon ICON_PERSONALITYNET = PersonalityUI.getIcon("res/iconPersonalitiesNet.png");
    private static final Icon ICON_PERSONALITYDEVICE = PersonalityUI.getIcon("res/iconPersonalitiesDevice.png");
    private static final Set<DeviceTemplate.Type> DefaultDeviceTemplateTypes = AUtil.hashSet((Object[])new DeviceTemplate.Type[]{DeviceTemplate.Type.DIE, DeviceTemplate.Type.BOARD, DeviceTemplate.Type.PACKAGE, DeviceTemplate.Type.INTERPOSER, DeviceTemplate.Type.GROUP, DeviceTemplate.Type.LOGICAL});
    private static final String DEFAULT_DEVICETEMPLATE_TYPES_DESC = "All templates that own personalities as well as all " + DefaultDeviceTemplateTypes.stream().map(type -> type.name()).sorted().map(AUtil::capitalizeFirstThenLower).collect(Collectors.joining(", "));
    public static final OrbitGuiShortcutActionRegistry.ViewActionFactory ViewActionFactory = new OrbitGuiShortcutActionRegistry.ViewActionFactory(){

        @Override
        public Iterator<Object> getActions(Db db, Selection selection, APoint2D worldLoc) {
            JMenuItem pRemoveN;
            int selPinCount = selection.getCount(db.getDbClass(PinInstance.class));
            int selDeviceCount = selection.getCount(db.getDbClass(Device.class));
            int selItemCount = selPinCount + selDeviceCount;
            HierInst bestPin = null;
            if (worldLoc != null) {
                ARect worldPtRect = new ARect(worldLoc, worldLoc);
                bestPin = Selectors.DevicePortSelector.getBestAt((Db)db, (ARect)worldPtRect);
            }
            if (bestPin != null && bestPin.getPath() == null) {
                bestPin = null;
            }
            LinkedList<Serializable> actions = new LinkedList<Serializable>();
            if (selItemCount == 0 && bestPin != null) {
                PinInstance pin = (PinInstance)bestPin.second;
                int cnt = 0;
                for (PersonalityMap pm : pin.getPersonalityMaps()) {
                    if (pm.getPersonality() == null) continue;
                    JMenuItem pRemove = new JMenuItem(String.format("Remove Pin %s From Personality %s", pin.getName(), pm.getPersonality().getName()));
                    AColorIcon icon = new AColorIcon(16, 16, pm.getPersonality().getColor());
                    pRemove.setIcon((Icon)icon);
                    pRemove.addActionListener(new ActionRemovePortPersonality(pin, pm.getPersonality()));
                    actions.add(pRemove);
                    ++cnt;
                }
                if (cnt > 1) {
                    JMenuItem pRemove = new JMenuItem(String.format("Remove Pin %s From All Personalities", pin.getName()));
                    pRemove.addActionListener(new ActionRemovePortPersonality(pin));
                    actions.add(pRemove);
                }
                LinkedList<Personality> personalities = new LinkedList<Personality>();
                for (DevicePath path = (DevicePath)bestPin.first; path != null; path = path.getParent()) {
                    DeviceTemplate devT = path.getDeviceTemplate();
                    Personality.getPersonalities((DeviceTemplate)devT, (Personality.Type)Personality.Type.PORT).forEach(personalities::add);
                    if (devT.amIASubstrate()) break;
                }
                if (personalities.size() > 1) {
                    actions.add(new ActionAddPortsToPersonalityFromDialog(String.format("Add Pin %s To Personality(ies)...", pin.getName()), personalities, AUtil.linkedList((Object[])new HierInst[]{bestPin})));
                } else {
                    JMenu p0 = new JMenu(String.format("Add Pin %s To Personality", pin.getName()));
                    LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
                    for (Personality personality : personalities) {
                        JMenuItem p1 = new JMenuItem(personality.getName());
                        AColorIcon icon = new AColorIcon(16, 16, personality.getColor());
                        p1.setIcon((Icon)icon);
                        ArrayList<PinInstance> single = new ArrayList<PinInstance>();
                        single.add(pin);
                        p1.addActionListener(new ActionAddPortsToPersonality(personality, single));
                        menuItems.add(p1);
                    }
                    LinkedList sortedItems = AMenuUtil.groupByFirstWord(menuItems.iterator());
                    AMenuUtil.sort((List)sortedItems, (boolean)true);
                    for (JMenuItem a : sortedItems) {
                        p0.add(a);
                    }
                    if (p0.getMenuComponentCount() > 0) {
                        actions.add(p0);
                    }
                }
            }
            if (selPinCount > 0) {
                actions.add(new ActionOnPlaceableItem(selection, selPinCount, "PinPersonality", ActionOnPlaceableItem.ACTION.MOVE_SEL_INT, true, "false,true", String.format("Copy Selected %s Personalities", PinUI.getTextForPinInstanceList(AUtil.arrayList((Iterator)selection.get(PinInstance.class))))));
                ArrayList selHPins = AUtil.arrayList((Iterator)selection.getSelectedHierInsts(PinInstance.class));
                List<Personality> availPersonalities = selHPins.stream().flatMap(hinst -> Personality.getPersonalities((DevicePath)((DevicePath)hinst.first), (Personality.Type)Personality.Type.PORT)).map(hinstPers -> (Personality)hinstPers.second).distinct().collect(Collectors.toList());
                if (!availPersonalities.isEmpty()) {
                    actions.add(new ActionAddPortsToPersonalityFromDialog(String.format("Add Selected Pins (%d) To Personality...", selPinCount), availPersonalities, selHPins));
                }
            }
            int devicesWithPersonality = PersonalityUI.countSelectedObjectsWithPersonalities(db, Device.class);
            int pinsWithPersonality = PersonalityUI.countSelectedObjectsWithPersonalities(db, PinInstance.class);
            int netsWithPersonality = PersonalityUI.countSelectedObjectsWithPersonalities(db, Net.class);
            if (devicesWithPersonality > 0) {
                JMenuItem pRemoveD = new JMenuItem(String.format("Remove Personalities from Selected Devices (%d)", devicesWithPersonality));
                pRemoveD.addActionListener(new ActionRemovePersonalitiesFromSelectedDevices());
                actions.add(pRemoveD);
            }
            if (pinsWithPersonality > 0) {
                JMenuItem pRemoveP = new JMenuItem(String.format("Remove Personalities from Selected Pins (%d)", pinsWithPersonality));
                pRemoveP.addActionListener(new ActionRemovePersonalitiesFromSelectedPins());
                actions.add(pRemoveP);
            }
            if (netsWithPersonality > 0) {
                pRemoveN = new JMenuItem(String.format("Remove Personalities from Selected Nets (%d)", netsWithPersonality));
                pRemoveN.addActionListener(new ActionRemovePersonalitiesFromSelectedNets());
                actions.add(pRemoveN);
            }
            if ((devicesWithPersonality > 0 ? 1 : 0) + (netsWithPersonality > 0 ? 1 : 0) + (pinsWithPersonality > 0 ? 1 : 0) >= 2) {
                pRemoveN = new JMenuItem(String.format("Remove Personalities from All Selected Objects (%d)", netsWithPersonality + pinsWithPersonality + devicesWithPersonality));
                pRemoveN.addActionListener(new ActionRemovePersonalitiesFromSelectedObjects());
                actions.add(pRemoveN);
            }
            return actions.iterator();
        }

        @Override
        public String getGroupName() {
            return "Personality Actions";
        }
    };
    protected static HashMap<DeviceTemplate, PersonalitiesEditor> gCurEditors = new HashMap();

    private PersonalityUI() {
    }

    public static PersonalitiesDialog create(Window owner, Db db) {
        PersonalitiesDialog dialog = PersonalitiesDialog.dialog;
        if (dialog != null) {
            UIUtil.closeWindow((Window)((Object)dialog));
        }
        PersonalitiesDialog.dialog = dialog = new PersonalitiesDialog(owner, db, false);
        return dialog;
    }

    public static PersonalitiesDialog createBallPlanner(Window owner, Db db) {
        PersonalitiesDialog dialog = PersonalitiesDialog.dialog;
        if (dialog != null) {
            UIUtil.closeWindow((Window)((Object)dialog));
        }
        PersonalitiesDialog.dialog = dialog = new PersonalitiesDialog(owner, db, true);
        return dialog;
    }

    public static String getDisplayText(DeviceTemplate devT, DevTDisplayName nameOpt) {
        return nameOpt.apply(devT);
    }

    public static Optional<PersonalitiesEditor> getPersonalitiesEditor(DeviceTemplate devT) {
        return Optional.ofNullable(gCurEditors.get(devT));
    }

    public static void addPersonalitiesEditor(DeviceTemplate devT, PersonalitiesEditor pe) {
        assert (!PersonalityUI.getPersonalitiesEditor(devT).isPresent());
        gCurEditors.put(devT, pe);
    }

    public static void removePersonalitiesEditor(DeviceTemplate devT) {
        assert (PersonalityUI.getPersonalitiesEditor(devT).isPresent());
        gCurEditors.remove(devT);
    }

    public static void deleteAllPersonalities(Db db, String devTempKeyStr, Personality.Type type) {
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        ArrayList toBeDeleted = new ArrayList();
        Personality.getPersonalities((DeviceTemplate)devTemp).filter(p -> p.getType() == type).forEach(toBeDeleted::add);
        for (Personality personality : toBeDeleted) {
            String dtname = personality.getOwner().getKeyStr();
            PersonalityUI.deletePersonalityOfDevTemp(personality.getName(), type, dtname);
        }
    }

    public static Icon getIcon(String name) {
        return UIUtil.getIcon(PersonalityUI.class, (String)name);
    }

    public static Icon getIconForPersonalityType(Personality.Type t) {
        switch (t) {
            case DEVICE: {
                return ICON_PERSONALITYDEVICE;
            }
            case PORT: {
                return ICON_PERSONALITYPORT;
            }
            case NET: {
                return ICON_PERSONALITYNET;
            }
        }
        return null;
    }

    public static boolean updatePersonalityNameByDevTemp(String templateName, String personalityType, String oldName, String newName) {
        Personality.Type ptype = Personality.Type.valueOf((String)personalityType);
        Optional<Personality> personality = PersonalityUI.getPersonalityOpt(ptype, templateName, oldName);
        personality.ifPresent(p -> p.setName(newName));
        return true;
    }

    @Deprecated
    public static boolean updatePersonalityName(String templateName, String personalityType, String oldName, String newName) {
        Personality.Type ptype = Personality.Type.valueOf((String)personalityType);
        Personality p = PersonalityUI.findPersonality(oldName, ptype, templateName);
        if (p == null) {
            ALog.logWarn((String)"Can not update personality name as it can not be found in template '%s'", (Object[])new Object[]{templateName});
            return false;
        }
        p.setName(newName);
        return true;
    }

    public static void removePersonalitiesFromSelected(Db db, Class<?>[] types) {
        Selection curSelected = Selection.getCurrentSelectionForDb((Db)db);
        for (Class<?> theClass : types) {
            DbClass dbClass = db.getDbClass(theClass);
            for (DbObject dbo : curSelected.get(dbClass)) {
                PersonalityMap.deleteAllPersonalityMapsRelatedTo((DbObject)dbo);
            }
        }
    }

    public static int countSelectedObjectsWithPersonalities(Db db, Class<?> type) {
        int ans = 0;
        Selection curSelected = Selection.getCurrentSelectionForDb((Db)db);
        DbClass dbClass = db.getDbClass(type);
        for (DbObject dbo : curSelected.get(dbClass)) {
            if (!PersonalityMap.getPersonalityMaps((DbObject)dbo).findAny().isPresent()) continue;
            ++ans;
        }
        return ans;
    }

    @Deprecated
    public static Color defaultPersonalityColor(Personality p) {
        return Personalities.getDefaultPersonalityColor((Personality)p);
    }

    @Deprecated
    public static String defaultPersonalityName(String name) {
        return Personalities.getDefaultPersonalityName((String)name);
    }

    public static void assignBumpsToPersonalities(String devicePathString) {
        PersonalityUI.assignPinsToPersonalities(devicePathString, PinTemplate.Type.BUMPPAD);
    }

    public static void assignBallsToPersonalities(String devicePathString) {
        PersonalityUI.assignPinsToPersonalities(devicePathString, PinTemplate.Type.BALLPAD);
    }

    public static void assignPCBPinsToPersonalities(String devicePathString) {
        PersonalityUI.assignPinsToPersonalities(devicePathString, null);
    }

    private static Optional<DeviceTemplate> getLowestSubstrateInstance(DevicePath dp, List<DeviceTemplate> templates) {
        DevicePath path = dp.pathToSubstrate();
        if (path == null) {
            return Optional.empty();
        }
        DeviceTemplate substrateInstance = path.getLast().getTemplate();
        return templates.stream().filter(t -> t.equals(substrateInstance)).findAny();
    }

    public static void assignPinsToPersonalities(String devicePathString, PinTemplate.Type type) {
        boolean useParentNet;
        String methodName;
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        boolean assignToUnconn = (Boolean)Settings.get((String)Personalities.SETTING_SECTION, (String)"AssignPersonalitiesToUnconnected", (Object)true);
        if (Personalities.existMethodByName((String)"defaultPersonalityName")) {
            methodName = "defaultPersonalityName";
            useParentNet = false;
        } else {
            methodName = "getDefaultPersonalityNameByParentNet";
            useParentNet = true;
        }
        Device packageDevice = devicePath.getLast();
        Substrate s = packageDevice.getSubstrate();
        MutableInteger pinCount = MutableInteger.create((int)0);
        List substrateInstances = s.getSubstrateTemplates().collect(Collectors.toList());
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Assign Pin Personalities");){
            devicePath.getDescendantsOnSubstrate(true).stream().forEach(child -> {
                Optional<DeviceTemplate> _substrateInstance = PersonalityUI.getLowestSubstrateInstance(child, substrateInstances);
                if (!_substrateInstance.isPresent()) {
                    return;
                }
                DeviceTemplate substrateInstance = _substrateInstance.get();
                child.getLast().getPins().stream().forEach(pi -> {
                    if (type == null || pi.getType().equals((Object)type)) {
                        Optional<Net> parentNet;
                        Net topNet = NetMap.getSubstrateNet((Net)pi.getNet(), (DevicePath)child);
                        if (topNet == null) {
                            return;
                        }
                        if (useParentNet && (parentNet = NetMap.getParentMappings((Net)topNet).stream().map(NetMap::getParentNet).filter(Objects::nonNull).findAny()).isPresent()) {
                            topNet = parentNet.get();
                        }
                        Net pkgNet = topNet;
                        if (!useParentNet && topNet.getDeviceTemplate() != packageDevice.getTemplate()) {
                            if (!assignToUnconn) {
                                return;
                            }
                            pkgNet = packageDevice.getTemplate().getNetUnused();
                        }
                        String name = pkgNet.getName();
                        try {
                            Cp.getCp().getInterpreter().set("_topNet", (Object)topNet);
                        }
                        catch (Exception ex) {
                            ALog.logWarn((Throwable)ex, (String)"Error setting interpreter variable.", (Object[])new Object[0]);
                        }
                        String personalityName = null;
                        try {
                            personalityName = Personalities.getDefaultPersonalityNameByMethod((String)methodName, (String)name);
                        }
                        catch (Exception t) {
                            ALog.logError((Throwable)t, (String)"Error getting defautl personality name.", (Object[])new Object[0]);
                            return;
                        }
                        finally {
                            try {
                                Cp.getCp().getInterpreter().unset("_topNet");
                            }
                            catch (Exception t) {
                                ALog.logDebug((Throwable)t, (String)"Error removing interpreter variable.", (Object[])new Object[0]);
                            }
                        }
                        Personality p = PersonalityUI.getOrMakePersonality(Personality.Type.PORT, substrateInstance, personalityName);
                        if (p != null) {
                            pi.assignToPersonality(p);
                            pinCount.increment();
                        } else {
                            ALog.logWarn((String)"Failed to create personality '%s'", (Object[])new Object[]{personalityName});
                        }
                    }
                });
            });
        }
        ALog.logInfo((String)"%d pins assigned to personalities", (Object[])new Object[]{pinCount.get()});
        if (pinCount.get() > 0) {
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    @Deprecated
    public static Personality getOrMakePersonality(String sKey, String name, Personality.Type t) {
        Substrate s = (Substrate)OrbitIO.getCurDb().getByKeyStr(Substrate.class, sKey);
        Personality p = null;
        for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
            p = PersonalityUI.getOrMakePersonality(t, devTemp, name);
        }
        return p;
    }

    public static Personality getOrMakePersonality(Personality.Type t, DeviceTemplate devTemp, String name) {
        return Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)t, (String)name, p -> {
            Color c = PersonalityUI.defaultPersonalityColor(p);
            if (c != null) {
                p.setColor(c);
            }
        });
    }

    public static Personality getOrMakePersonality(Personality.Type t, String devTempKey, String name) {
        DeviceTemplate devTemp = (DeviceTemplate)OrbitIO.getCurDb().getByKeyStr(DeviceTemplate.class, devTempKey);
        return PersonalityUI.getOrMakePersonality(t, devTemp, name);
    }

    public static Optional<Personality> getPersonalityByKey(Db db, String key, Personality.Type expectedType) {
        Personality p = Personality.getByKeyStr((Db)db, (String)key);
        if (p == null) {
            ALog.logError((String)"Personality with key '%s' not found.", (Object[])new Object[]{key});
            return Optional.empty();
        }
        if (p.getType() != expectedType) {
            ALog.logInfo((String)"Specified Personality '%s' not of type '%s'.", (Object[])new Object[]{expectedType});
            return Optional.empty();
        }
        return Optional.of(p);
    }

    @Deprecated
    public static void addSelectedPortsToPersonality(String name, boolean moveTo) {
        Design design = OrbitIO.getCurDesign();
        Selection s = design.getCurSelection();
        MutableInteger num = new MutableInteger(0);
        s.get(PinInstance.class).stream().forEach(pin -> {
            List<Object> paths = s.getSelectedPaths((DbObject)pin).stream().collect(Collectors.toList());
            if (paths.isEmpty() && pin.getDeviceTemplate().amIASubstrate()) {
                paths = List.of(new DevicePath(pin.getDeviceTemplate()));
            }
            if (paths.isEmpty()) {
                ALog.logWarn((String)"The selection does not specifiy any paths for pin '%s', it is notbeing assinged a personality.", (Object[])new Object[]{pin.getKeyStr()});
            } else {
                paths.stream().forEach(path -> {
                    Optional op = Personality.getSubstratePersonality((DevicePath)path, (Personality.Type)Personality.Type.PORT, (String)name);
                    if (op.isPresent()) {
                        Personality pers = (Personality)op.get();
                        if (moveTo) {
                            Personality.removeAll((Personality.Type)Personality.Type.PORT, (DbObject)pin);
                        }
                        DevicePath relPath = path.getRelativePath(pers.getOwner());
                        pers.apply(relPath, (DbObject)pin);
                        num.increment();
                    } else {
                        String pinDesc = String.format("%s/%s", pin.getName(), path.escapedString());
                        ALog.logWarn((String)"There is no personality '%s' associated with the substrate DeviceTemplate for pin '%s', the pin is not being assinged a new personality.", (Object[])new Object[]{name, pinDesc});
                    }
                });
            }
        });
        if (moveTo) {
            ALog.logInfo((String)(num + " pins moved to " + name));
        } else {
            ALog.logInfo((String)(num + " pins added to " + name));
        }
    }

    public static void addSelectedPortsToPersonalityOfKeyStr(String keyStr, boolean moveTo) {
        Design design = OrbitIO.getCurDesign();
        Personality personality = Personality.getByKeyStr((Db)design.getDb(), (String)keyStr);
        if (personality == null) {
            return;
        }
        Selection s = design.getCurSelection();
        MutableInteger numMissing = new MutableInteger(0);
        MutableInteger num = new MutableInteger(0);
        s.get(PinInstance.class).stream().forEach(pin -> {
            List<Object> paths = s.getSelectedPaths((DbObject)pin).stream().collect(Collectors.toList());
            if (paths.isEmpty() && pin.getDeviceTemplate().amIASubstrate()) {
                paths = List.of(new DevicePath(pin.getDeviceTemplate()));
            }
            if (paths.isEmpty()) {
                ALog.logWarn((String)"The selection does not specifiy any paths for pin '%s', it is notbeing assinged a personality.", (Object[])new Object[]{pin.getKeyStr()});
            } else {
                paths.stream().forEach(path -> {
                    DevicePath relPath;
                    if (moveTo) {
                        Personality.removeAll((Personality.Type)Personality.Type.PORT, (DbObject)pin);
                    }
                    if ((relPath = path.getRelativePathFromAnchor(personality.getOwner())) != null) {
                        personality.apply(relPath, (DbObject)pin);
                        num.increment();
                    } else {
                        numMissing.increment();
                    }
                });
            }
        });
        if (moveTo) {
            ALog.logInfo((String)(num + " pins moved to '" + personality.getName() + "'"));
        } else {
            ALog.logInfo((String)(num + " pins added to '" + personality.getName() + "'"));
        }
        if (numMissing.getValue() > 0) {
            if (moveTo) {
                ALog.logInfo((String)(numMissing + " pins not moved to '" + personality.getName() + "' because they are not related to Device Template '" + personality.getOwner().getQualifiedName() + "'"));
            } else {
                ALog.logInfo((String)(numMissing + " pins not added to '" + personality.getName() + "' because they are not related to Device Template '" + personality.getOwner().getQualifiedName() + "'"));
            }
        }
    }

    public static void addSelectedPortsToPersonalityOfKeyStr(String name) {
        PersonalityUI.addSelectedPortsToPersonalityOfKeyStr(name, false);
    }

    public static void moveSelectedPortsToPersonalityOfKeyStr(String name) {
        PersonalityUI.addSelectedPortsToPersonalityOfKeyStr(name, true);
    }

    @Deprecated
    public static void addSelectedPortsToPersonality(String name) {
        PersonalityUI.addSelectedPortsToPersonality(name, false);
    }

    @Deprecated
    public static void moveSelectedPortsToPersonality(String name) {
        PersonalityUI.addSelectedPortsToPersonality(name, true);
    }

    public static void removeSelectedPortsFromPersonality(String keyStr) {
        Db db = OrbitIO.getCurDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)keyStr);
        if (p == null) {
            ALog.logWarn((String)"Cannot find personality '%s'", (Object[])new Object[]{keyStr});
            return;
        }
        int num = 0;
        Selection s = Design.getSelection((Db)db);
        for (PinInstance dp : s.get(PinInstance.class)) {
            boolean has = dp.getPersonalityMaps().stream().anyMatch(pm -> pm.getPersonality() == p);
            if (!has) continue;
            dp.unAssignFromPersonality(p);
            ++num;
        }
        ALog.logInfo((String)(num + " pins removed from " + p.getName()));
    }

    public static void removeNetsFromPersonality(String persKey) {
        PersonalityUI.getPersonalityByKey(OrbitIO.getCurDb(), persKey, Personality.Type.NET).ifPresent(p -> {
            for (PersonalityMap pm : AUtil.arrayList((Stream)p.getPersonalityMaps())) {
                pm.deleteFromDb();
            }
        });
    }

    public static void removeDbObjectFromPersonality(String devTempKeyStr, String personalityKeyStr, String objTypeStr, String objectKeyStr) {
        DbClass dbc = OrbitIO.getCurDb().getDbClass(objTypeStr);
        DeviceTemplate tmp = (DeviceTemplate)OrbitIO.getCurDb().getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        DbObject obj = OrbitIO.getCurDb().getByKeyStr(dbc.getJavaClass(), objectKeyStr);
        Personality personality = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, personalityKeyStr);
        List delList = PersonalityMap.getPersonalityMaps((DbObject)obj, (Personality)personality).filter(pm -> pm.getPath().getRootTemplate() == tmp).collect(Collectors.toList());
        for (PersonalityMap pm2 : delList) {
            pm2.deleteFromDb();
        }
    }

    public static void removeSelectedNetsFromPersonality(String keyStr) {
        Optional<Personality> op = PersonalityUI.getPersonalityByKey(OrbitIO.getCurDb(), keyStr, Personality.Type.NET);
        if (!op.isPresent()) {
            return;
        }
        Selection sel = Selection.getCurrentSelectionForDb((Db)OrbitIO.getCurDb());
        Personality pers = op.get();
        pers.getObjects(Net.class).forEach(hnet -> {
            if (sel.contains((DbObject)hnet.second)) {
                PersonalityMap.get((Personality)pers, (DevicePath)hnet.getPath(), (DbObject)hnet.getDbObject()).ifPresent(DbObject::deleteFromDb);
            }
        });
    }

    protected static Personality getPersonalityConvertingOldKeys(Db db, String persKey) {
        Personality p = Personality.getByKeyStr((Db)db, (String)persKey);
        if (p == null) {
            int sep = persKey.indexOf(58);
            String subStr = persKey.substring(0, sep);
            String perStr = persKey.substring(sep + 1);
            int sep2 = perStr.indexOf(58);
            String typeStr = perStr.substring(sep2 + 1);
            String perNameStr = perStr.substring(0, sep2);
            Substrate substrate = (Substrate)db.getByKeyStr(Substrate.class, subStr);
            DeviceTemplate devTemp = (DeviceTemplate)substrate.getDeviceTemplates().next();
            p = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.valueOf((String)typeStr), (String)perNameStr).orElse(null);
            assert (p != null);
        }
        return p;
    }

    public static void addDbObjectToPersonality(String objClassName, String objKeyStr, String perKeyString) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        DbObject obj = db.get(objClassName, objKeyStr);
        Personality p = PersonalityUI.getPersonalityConvertingOldKeys(db, perKeyString);
        PersonalityUI.addDbObjectToPersonality(obj, p);
    }

    public static void addDbObjectToPersonality(DbObject obj, Personality p) {
        DeviceTemplate targetDevT;
        if (p == null) {
            return;
        }
        DeviceTemplate persOwner = p.getOwner();
        Object object = obj instanceof Floorplan ? ((Floorplan)obj).getDeviceTemplate() : (obj instanceof Net ? ((Net)obj).getDeviceTemplate() : (obj instanceof PinInstance ? ((PinInstance)obj).getDeviceTemplate() : (obj instanceof PinTemplate ? ((PinTemplate)obj).getDeviceTemplate() : (targetDevT = obj instanceof Device ? ((Device)obj).getParent() : null))));
        if (targetDevT == null) {
            ALog.logWarn((String)"Unable to add DbObject '%s' to Personality '%s', unable to determine target DeviceTemplate from the DbObject.", (Object[])new Object[]{obj.getKeyStr(), p.getKeyStr()});
            return;
        }
        persOwner.getDescendants().filter(path -> path.getDeviceTemplate() == targetDevT).map(path -> path.getRelativePathFromAnchor(persOwner)).forEach(path -> PersonalityMap.create((Personality)p, (DevicePath)path, (DbObject)obj));
    }

    public static void addFloorplanToPersonality(String objClassName, String objKeyStr, String perKeyString, boolean includeDecendents) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        DbObject obj = db.get(objClassName, objKeyStr);
        Personality p = Personality.getByKeyStr((Db)db, (String)perKeyString);
        if (p == null) {
            int sep = perKeyString.indexOf(58);
            String subStr = perKeyString.substring(0, sep);
            String perStr = perKeyString.substring(sep + 1);
            int sep2 = perStr.indexOf(58);
            String typeStr = perStr.substring(sep2 + 1);
            String perNameStr = perStr.substring(0, sep2);
            Substrate substrate = (Substrate)db.getByKeyStr(Substrate.class, subStr);
            DeviceTemplate devTemp = (DeviceTemplate)substrate.getDeviceTemplates().next();
            p = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.valueOf((String)typeStr), (String)perNameStr).orElse(null);
            assert (p != null);
        }
        PersonalityUI.addFloorplanToPersonality(obj, p, includeDecendents);
    }

    public static void addFloorplanToPersonality(DbObject obj, Personality p, boolean includeDecendents) {
        if (obj instanceof Floorplan) {
            LinkedList floorplans = new LinkedList();
            if (includeDecendents) {
                floorplans = Floorplan.selfAndChildren((Interface)((Floorplan)obj).getMyInterface(), null, (DeviceTemplate)((Floorplan)obj).getDeviceTemplate());
            } else {
                floorplans.add((Floorplan)obj);
            }
            for (Floorplan floorplan : floorplans) {
                for (DevicePath devPath : floorplan.getDeviceTemplate().getHierarchicalInstances()) {
                    PersonalityMap.create((Personality)p, (DevicePath)devPath.getRelativePathFromAnchor(floorplan.getDeviceTemplate()), (DbObject)floorplan);
                }
            }
        } else assert (false);
    }

    public static void removeDbObjectFromPersonality(String objClassName, String objKeyStr, String perKeyString, Boolean includeDecendents) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        DbObject obj = db.get(objClassName, objKeyStr);
        Personality p = Personality.getByKeyStr((Db)db, (String)perKeyString);
        if (obj instanceof Floorplan && Boolean.TRUE.equals(includeDecendents)) {
            for (Floorplan floorplan : Floorplan.selfAndChildren((Interface)((Floorplan)obj).getMyInterface(), null, (DeviceTemplate)((Floorplan)obj).getDeviceTemplate())) {
                PersonalityMap.removePersonalityMaps((DbObject)floorplan, (Personality)p);
            }
        } else {
            PersonalityMap.removePersonalityMaps((DbObject)obj, (Personality)p);
        }
    }

    public static void removeDbObjectFromPersonality(String objClassName, String objKeyStr, String perKeyString) {
        PersonalityUI.removeDbObjectFromPersonality(objClassName, objKeyStr, perKeyString, false);
    }

    public static void addSelectedNetsToPersonality(String keyStr) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        Selection s = design.getCurSelection();
        Personality p = Personality.getByKeyStr((Db)db, (String)keyStr);
        if (p == null) {
            ALog.logError((String)"Net Personality '%s' not found", (Object[])new Object[]{keyStr});
            return;
        }
        for (Net n : s.get(Net.class)) {
            if (n.getDeviceTemplate() == null || n.getDeviceTemplate() != p.getOwner()) {
                Substrate substrate = p.getOwner().getSubstrate();
                DevicePath dp = substrate.getADevicePathUsing();
                if (dp == null) {
                    ALog.logInfo((String)"There does not seem to be an instantiated device on this substrate");
                    return;
                }
                dp = dp.pathToParent(substrate);
                Device sInstance = dp.getLast();
                DeviceTemplate sTemplate = sInstance.getTemplate();
                DeviceTemplate dt = n.getDeviceTemplate();
                Device d = dt.getAnInstance();
                dp = d.getADevicePath();
                Net eqNet = NetMap.getNetAt((Net)n, (DevicePath)dp, (DeviceTemplate)sTemplate);
                if (eqNet != null && eqNet.getDeviceTemplate() == sTemplate) {
                    n = eqNet;
                } else {
                    ALog.logWarn((String)("net " + n.getName() + " does not exist on the substrate for this personality, nor does it map there."));
                    continue;
                }
            }
            Net net = n;
            p.getOwner().getDescendants(true).filter(path -> path.getDeviceTemplate() == net.getDeviceTemplate()).forEach(path -> PersonalityMap.create((Personality)p, (DevicePath)path, (DbObject)net));
        }
    }

    public static long addSelectedDevices(Db db, String persKey) {
        Personality pers = (Personality)db.getByKeyStr(Personality.class, persKey);
        if (pers == null) {
            ALog.logError((String)"Personality with key '%s' does not exist, selected devices are not being added.", (Object[])new Object[]{persKey});
            Stream.empty();
            return 0L;
        }
        DeviceTemplate persOwner = pers.getOwner();
        Selection s = Design.getSelection((Db)db);
        long mapped = 0L;
        for (Device device : s.get(Device.class)) {
            for (DevicePath path : s.getSelectedPaths((DbObject)device)) {
                DevicePath relPath = path.getRelativePathFromAnchor(persOwner);
                if (relPath == null || PersonalityMap.get((Personality)pers, (DevicePath)relPath, (DbObject)device).isPresent()) continue;
                PersonalityMap.create((Personality)pers, (DevicePath)relPath, (DbObject)device);
                ++mapped;
            }
        }
        return mapped;
    }

    @Deprecated
    public static void addSelectedDevicesToPersonality(String name) {
        Design design = OrbitIO.getCurDesign();
        Selection s = design.getCurSelection();
        for (Device d : s.get(Device.class)) {
            Personality oldPersonality;
            Personality p = Personality.getOrCreate((DeviceTemplate)d.getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)name);
            if (p == (oldPersonality = d.getPersonality())) continue;
            PersonalityMap.create((Personality)p, (DevicePath)new DevicePath(d.getTemplate()), (DbObject)d);
        }
    }

    public static Personality addPersonality(String name, Personality.Type type, DeviceTemplate devTemp, String color) {
        return Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)type, (String)name, p -> {
            Color c = AUtil.colorFromString((String)color);
            if (c != null) {
                p.setColor(c);
            } else {
                ALog.logWarn((String)"Invalid color '%s' specified, using default color for personality '%s'.", (Object[])new Object[]{color, name});
            }
        });
    }

    public static Personality addPersonality(String name, Personality.Type type, String deviceTemplateKeyStr, String color) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot add personality, no current database.");
            return null;
        }
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, deviceTemplateKeyStr);
        if (devTemp == null) {
            ALog.logError((String)"Cannot add personality, no DeviceTemplate with key string '%s'.", (Object[])new Object[]{deviceTemplateKeyStr});
            return null;
        }
        if (Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)type, (String)name).isPresent()) {
            ALog.logError((String)"Cannot add '%s', a personality by that name already exists.", (Object[])new Object[]{name});
            return null;
        }
        return PersonalityUI.addPersonality(name, type, devTemp, color);
    }

    @Deprecated
    public static Personality addPersonality(String substrateName, String name, Personality.Type type, String deviceTemplateName, String color) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot add personality, no current database.");
            return null;
        }
        Substrate s = Substrate.getSubstrate((Db)db, (String)substrateName);
        if (s == null) {
            ALog.logError((String)"Cannot add personality, no substrate named '%s'.", (Object[])new Object[]{substrateName});
            return null;
        }
        Personality personality = null;
        for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
            personality = PersonalityUI.addPersonality(name, type, devTemp, color);
        }
        return personality;
    }

    public static Personality addPersonalityByDevTemp(String name, Personality.Type type, String deviceTemplateKeyStr, String color) {
        return PersonalityUI.addPersonality(name, type, deviceTemplateKeyStr, color);
    }

    public static void highlight(Personality personality) {
        Db db = personality.getDb();
        AAppView view = OrbitIO.getApp().getWorkspace().getView(db);
        if (!(view instanceof DesignView2D)) {
            return;
        }
        DesignView2D v2d = (DesignView2D)view;
        if (personality.getType() == Personality.Type.PORT) {
            PersonalityUI.highlightPortPersonality(v2d, personality);
        } else if (personality.getType() == Personality.Type.NET) {
            PersonalityUI.highlightNetPersonality(v2d, personality);
        }
    }

    @Deprecated
    public static boolean copyPinPersonality(Db db, String fromSubstrateName, String toSubstrateName, String personalityName) {
        if (db == null) {
            ALog.logError((String)"Cannot find personality, no current database.");
            return false;
        }
        Substrate fromSubstrate = Substrate.getSubstrate((Db)db, (String)fromSubstrateName);
        if (fromSubstrate == null) {
            ALog.logError((String)"Cannot copy personality, no from substrate named '%s'.", (Object[])new Object[]{fromSubstrateName});
            return false;
        }
        DeviceTemplate fromDevTemp = (DeviceTemplate)fromSubstrate.getDeviceTemplates().next();
        Substrate toSubstrate = Substrate.getSubstrate((Db)db, (String)toSubstrateName);
        if (toSubstrate == null) {
            ALog.logError((String)"Cannot copy personality, no to substrate named '%s'.", (Object[])new Object[]{toSubstrateName});
            return false;
        }
        DeviceTemplate toDevTemp = (DeviceTemplate)toSubstrate.getDeviceTemplates().next();
        return PersonalityUI.copyPinPersonalityFromDevTemp(fromDevTemp, toDevTemp, personalityName);
    }

    public static boolean copyPinPersonalityFromDevTemp(Db db, String fromDevTempKeyStr, String toDevTempKeyStr, String personalityName) {
        if (db == null) {
            ALog.logError((String)"Cannot find personality, no current database.");
            return false;
        }
        DeviceTemplate fromDevTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, fromDevTempKeyStr);
        if (fromDevTemp == null) {
            ALog.logError((String)"Cannot copy personality, no from Device Template with key string '%s'.", (Object[])new Object[]{fromDevTemp});
            return false;
        }
        DeviceTemplate toDevTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, toDevTempKeyStr);
        if (toDevTemp == null) {
            ALog.logError((String)"Cannot copy personality, no Device Template with key string '%s'.", (Object[])new Object[]{toDevTempKeyStr});
            return false;
        }
        return PersonalityUI.copyPinPersonalityFromDevTemp(fromDevTemp, toDevTemp, personalityName);
    }

    public static boolean copyPinPersonalityFromDevTemp(DeviceTemplate fromDevTemp, DeviceTemplate toDevTemp, String personalityName) {
        Personality p = Personality.getPersonality((DeviceTemplate)fromDevTemp, (Personality.Type)Personality.Type.PORT, (String)personalityName).orElse(null);
        if (p == null) {
            ALog.logWarn((String)"Can not copy pin personality '%s' from '%s' as it does not exist!", (Object[])new Object[]{personalityName, fromDevTemp});
            return false;
        }
        Personality personality = Personality.getPersonality((DeviceTemplate)toDevTemp, (Personality.Type)Personality.Type.PORT, (String)personalityName).orElse(null);
        if (personality != null) {
            ALog.logWarn((String)"Cannot copy '%s', a personality by that name already exists.", (Object[])new Object[]{personalityName});
            return false;
        }
        personality = Personality.getOrCreate((DeviceTemplate)toDevTemp, (Personality.Type)Personality.Type.PORT, (String)personalityName, per -> per.setColor(p.getColor()));
        Personality.copyConstraints((Personality)p, (Personality)personality);
        return true;
    }

    @Deprecated
    public static boolean copyPinPersonality(String fromSubstrateName, String toSubstrateName) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot find personality, no current database.");
            return false;
        }
        Substrate fromSubstrate = Substrate.getSubstrate((Db)db, (String)fromSubstrateName);
        if (fromSubstrate == null) {
            ALog.logError((String)"Cannot copy personality, no from substrate named '%s'.", (Object[])new Object[]{fromSubstrateName});
            return false;
        }
        Substrate toSubstrate = Substrate.getSubstrate((Db)db, (String)toSubstrateName);
        if (toSubstrate == null) {
            ALog.logError((String)"Cannot copy personality, no to substrate named '%s'.", (Object[])new Object[]{toSubstrateName});
            return false;
        }
        for (DeviceTemplate fromDevTemp : fromSubstrate.getDeviceTemplates()) {
            Personality.getPersonalities((DeviceTemplate)fromDevTemp, (Personality.Type)Personality.Type.PORT).forEach(p -> {
                Personality.Type pType = p.getType();
                for (DeviceTemplate toDevTemp : toSubstrate.getDeviceTemplates()) {
                    Personality personality = Personality.getOrCreate((DeviceTemplate)toDevTemp, (Personality.Type)Personality.Type.PORT, (String)p.getName(), per -> {
                        per.setType(pType);
                        per.setColor(p.getColor());
                    });
                    Personality.copyConstraints((Personality)p, (Personality)personality);
                }
            });
        }
        return true;
    }

    public static boolean copyPinPersonalityByDevTemp(String fromDevTempKeyStr, String toDevTempKeyStr) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot find personality, no current database.");
            return false;
        }
        DeviceTemplate fromDevTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, fromDevTempKeyStr);
        if (fromDevTemp == null) {
            ALog.logError((String)"Cannot copy personality, no from device template with keyStr '%s'.", (Object[])new Object[]{fromDevTempKeyStr});
            return false;
        }
        DeviceTemplate toDevTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, toDevTempKeyStr);
        if (toDevTemp == null) {
            ALog.logError((String)"Cannot copy personality, no to device template with keyStr '%s'.", (Object[])new Object[]{toDevTempKeyStr});
            return false;
        }
        Personality.getPersonalities((DeviceTemplate)fromDevTemp, (Personality.Type)Personality.Type.PORT).forEach(p -> {
            Personality.Type pType = p.getType();
            Personality personality = Personality.getOrCreate((DeviceTemplate)toDevTemp, (Personality.Type)Personality.Type.PORT, (String)p.getName(), per -> {
                per.setType(pType);
                per.setColor(p.getColor());
            });
            Personality.copyConstraints((Personality)p, (Personality)personality);
        });
        return true;
    }

    public static boolean updatePersonalityColor(Personality personality, String color) {
        Color c = AUtil.colorFromString((String)color);
        if (c == null) {
            ALog.logError((String)"Invalid color '%s' specified, not updating color for personality '%s'.", (Object[])new Object[]{color, personality.getName()});
            return false;
        }
        personality.setColor(c);
        OrbitIO.refreshViewsOf(OrbitIO.getCurDb());
        return true;
    }

    public static boolean updatePersonalityColor(Db db, String personalityKeyStr, String colorStr) {
        Personality p = (Personality)db.getByKeyStr(Personality.class, personalityKeyStr);
        if (p == null) {
            return false;
        }
        Color c = AUtil.colorFromString((String)colorStr);
        p.setColor(c);
        return true;
    }

    public static boolean updatePersonalityColor(String name, Personality.Type type, String templateName, String color) {
        Personality personality = PersonalityUI.findPersonality(name, type, templateName);
        if (personality == null) {
            return false;
        }
        return PersonalityUI.updatePersonalityColor(personality, color);
    }

    private static Optional<Personality> getPersonalityOpt(Personality.Type type, String templateKeyStr, String name) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot find personality, no current database.");
            return Optional.empty();
        }
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKeyStr);
        return Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)type, (String)name);
    }

    public static boolean updatePersonalityColor(Personality.Type type, String name, String templateKeyStr, String color) {
        Optional<Personality> personality = PersonalityUI.getPersonalityOpt(type, templateKeyStr, name);
        if (!personality.isPresent()) {
            return false;
        }
        return PersonalityUI.updatePersonalityColor(personality.get(), color);
    }

    public static boolean setPersonalityNetConstraints(Personality personality, boolean matchLength, boolean starTopology, boolean power, boolean keepGap, long gapDistance) {
        Net.setPersonalityConstraints((Personality)personality, (Boolean)matchLength, (Boolean)power);
        return true;
    }

    @Deprecated
    public static boolean setPersonalityNetConstraints(String name, String templateName, boolean matchLength, boolean starTopology, boolean power, boolean keepGap, long gapDistance) {
        Personality personality = PersonalityUI.findPersonality(name, Personality.Type.NET, templateName);
        if (personality == null) {
            return false;
        }
        return PersonalityUI.setPersonalityNetConstraints(personality, matchLength, starTopology, power, keepGap, gapDistance);
    }

    public static boolean setPersonalityNetByDevTempConstraints(String name, String templateName, boolean matchLength, boolean starTopology, boolean power, boolean keepGap, long gapDistance) {
        Personality personality = PersonalityUI.findPersonalityOfDevTemp(name, Personality.Type.NET, templateName);
        if (personality == null) {
            return false;
        }
        return PersonalityUI.setPersonalityNetConstraints(personality, matchLength, starTopology, power, keepGap, gapDistance);
    }

    public static boolean setPersonalityNetConstraints(String name, String templateName, boolean matchLength, boolean starTopology, boolean power) {
        PersonalityUI.setPersonalityNetConstraints(name, templateName, matchLength, starTopology, power, false, 0L);
        return true;
    }

    public static boolean setPersonalityPortConstraints(Personality personality, long ratio, boolean allowSwap) {
        return PinInstance.setPersonalityConstraints((Personality)personality, (Long)ratio, (Boolean)allowSwap);
    }

    @Deprecated
    public static boolean setPersonalityPortConstraints(String name, String templateName, long ratio, boolean allowSwap) {
        Personality personality = PersonalityUI.findPersonality(name, Personality.Type.PORT, templateName);
        if (personality == null) {
            return false;
        }
        return PersonalityUI.setPersonalityPortConstraints(personality, ratio, allowSwap);
    }

    public static boolean setPersonalityByDevTempPortConstraints(String name, String templateName, long ratio, boolean allowSwap) {
        Personality personality = PersonalityUI.findPersonalityOfDevTemp(name, Personality.Type.PORT, templateName);
        if (personality == null) {
            return false;
        }
        return PersonalityUI.setPersonalityPortConstraints(personality, ratio, allowSwap);
    }

    public static boolean setPersonalityPlacementGrid(Personality personality, long ox, long oy, long dx, long dy) {
        Db db = personality.getDb();
        Constraint constraint = Constraint.getConstraint((Db)db, (DbObject)personality, (Constraint.Descriptor)Constraint.PLACE_GRID);
        if (dx == 0L && dy == 0L) {
            if (constraint != null) {
                return constraint.deleteFromDb();
            }
            return true;
        }
        AGrid grid = null;
        if (constraint == null) {
            constraint = Constraint.getConstraint((Db)db, (DbObject)personality, (Constraint.Descriptor)Constraint.PLACE_GRID, (boolean)true);
        } else {
            grid = (AGrid)constraint.getValue();
        }
        if (grid == null) {
            grid = new AGrid();
            constraint.setValue((Object)grid);
        }
        grid.setOrigin(ox, oy);
        grid.setDelta(dx, dy);
        return true;
    }

    @Deprecated
    public static boolean setPersonalityPlacementGrid(String name, String templateName, long ox, long oy, long dx, long dy) {
        Personality personality = PersonalityUI.findPersonality(name, Personality.Type.DEVICE, templateName);
        if (personality == null) {
            return false;
        }
        return PersonalityUI.setPersonalityPlacementGrid(personality, ox, oy, dx, dy);
    }

    public static boolean setPersonalityPlacementGridByDevTemp(String name, String templateKeyStr, long ox, long oy, long dx, long dy) {
        Optional<Personality> personality = PersonalityUI.getPersonalityOpt(Personality.Type.DEVICE, templateKeyStr, name);
        if (!personality.isPresent()) {
            return false;
        }
        return PersonalityUI.setPersonalityPlacementGrid(personality.get(), ox, oy, dx, dy);
    }

    public static boolean setPersonalityPlacementArea(Personality personality, long x0, long y0, long x1, long y1) {
        Db db = personality.getDb();
        Constraint constraint = Constraint.getConstraint((Db)db, (DbObject)personality, (Constraint.Descriptor)Constraint.PLACE_AREA);
        if (x0 == y1 && y0 == y1) {
            if (constraint != null) {
                return constraint.deleteFromDb();
            }
            return true;
        }
        ARect area = null;
        if (constraint == null) {
            constraint = Constraint.getConstraint((Db)db, (DbObject)personality, (Constraint.Descriptor)Constraint.PLACE_AREA, (boolean)true);
        } else {
            area = (ARect)constraint.getValue();
        }
        if (area == null) {
            area = new ARect();
            constraint.setValue((Object)area);
        }
        area.setBounds(x0, y0, x1, y1);
        return true;
    }

    @Deprecated
    public static boolean setPersonalityPlacementArea(String name, String templateName, long x0, long y0, long x1, long y1) {
        Personality personality = PersonalityUI.findPersonality(name, Personality.Type.DEVICE, templateName);
        if (personality == null) {
            return false;
        }
        return PersonalityUI.setPersonalityPlacementArea(personality, x0, y0, x1, y1);
    }

    public static boolean setPersonalityPlacementAreaByDevTemp(String name, String templateKeyStr, long x0, long y0, long x1, long y1) {
        Optional<Personality> personality = PersonalityUI.getPersonalityOpt(Personality.Type.DEVICE, templateKeyStr, name);
        if (!personality.isPresent()) {
            return false;
        }
        return PersonalityUI.setPersonalityPlacementArea(personality.get(), x0, y0, x1, y1);
    }

    public static boolean setPersonalityPlacementAreaExclusive(Personality personality, boolean exclusive) {
        Constraint.getOrCreate((DbObject)personality, (Constraint.Descriptor)Constraint.PLACE_AREA_EXCLUSIVE, (Object)exclusive);
        return true;
    }

    public static boolean setPersonalityPlacementAreaExclusive(String name, String templateName, boolean exclusive) {
        Personality personality = PersonalityUI.findPersonality(name, Personality.Type.DEVICE, templateName);
        if (personality == null) {
            return false;
        }
        return PersonalityUI.setPersonalityPlacementAreaExclusive(personality, exclusive);
    }

    @Deprecated
    public static boolean setPersonalityPlacementAreaExclusiveByDevTemp(String name, String templateKeyStr, boolean exclusive) {
        Optional<Personality> personality = PersonalityUI.getPersonalityOpt(Personality.Type.DEVICE, templateKeyStr, name);
        if (!personality.isPresent()) {
            return false;
        }
        return PersonalityUI.setPersonalityPlacementAreaExclusive(personality.get(), exclusive);
    }

    @Deprecated
    public static boolean setDevicePersonalities(String[] devices, String personalityName, String templateName) {
        Personality p = PersonalityUI.findPersonality(personalityName, Personality.Type.DEVICE, templateName);
        if (p == null) {
            return false;
        }
        Db db = p.getDb();
        for (String dname : devices) {
            Device d = (Device)db.getByKeyStr(Device.class, dname);
            if (d == null) {
                ALog.logError((String)"No device '%s', it is being ignored.", (Object[])new Object[]{dname});
                continue;
            }
            d.assignToPersonality(p);
        }
        return true;
    }

    public static boolean setDevicePersonalities(Db db, String[] devices, String personalityName, String templateKeyStr) {
        Optional p = Personality.getPersonality((DeviceTemplate)((DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKeyStr)), (Personality.Type)Personality.Type.DEVICE, (String)personalityName);
        if (!p.isPresent()) {
            return false;
        }
        for (String dname : devices) {
            Device d = (Device)db.getByKeyStr(Device.class, dname);
            if (d == null) {
                ALog.logError((String)"No device '%s', it is being ignored.", (Object[])new Object[]{dname});
                continue;
            }
            d.assignToPersonality((Personality)p.get());
        }
        return true;
    }

    public static boolean deletePersonalityOfDevTemp(String name, Personality.Type type, String templateName) {
        Personality p = PersonalityUI.findPersonalityOfDevTemp(name, type, templateName);
        if (p == null) {
            return false;
        }
        boolean status = p.deleteFromDb();
        if (!status) {
            ALog.logWarn((String)"Removing device personaility '%s' for template '%s' failed.", (Object[])new Object[]{name, templateName});
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean deletePersonality(String name, Personality.Type type, String templateName) {
        Personality p = PersonalityUI.findPersonality(name, type, templateName);
        if (p == null) {
            return false;
        }
        boolean status = p.deleteFromDb();
        if (!status) {
            ALog.logWarn((String)"Removing device personaility '%s' for template '%s' failed.", (Object[])new Object[]{name, templateName});
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean selectDevicesInPersonality(String name, String templateName) {
        Personality p = PersonalityUI.findPersonality(name, Personality.Type.DEVICE, templateName);
        if (p == null) {
            return false;
        }
        Selection s = Design.getSelection((Db)p.getDb());
        p.getPersonalityMaps().forEach(pm -> s.add(pm.getObject()));
        OrbitIO.getApp().refreshCurrentView(false);
        return true;
    }

    public static boolean selectDevicesInPersonalityByDevTemp(String name, String templateKeyStr) {
        Optional<Personality> personality = PersonalityUI.getPersonalityOpt(Personality.Type.DEVICE, templateKeyStr, name);
        if (!personality.isPresent()) {
            return false;
        }
        Selection s = Design.getSelection((Db)personality.get().getDb());
        if (PersonalitiesDialog.dialog.mSelectedDevicePath != null) {
            personality.get().getPersonalityMaps().forEach(pm -> {
                DevicePath dp = new DevicePath(PersonalitiesDialog.dialog.mSelectedDevicePath, (Device)pm.getObject());
                s.add(dp, pm.getObject());
            });
        } else {
            personality.get().getPersonalityMaps().forEach(pm -> s.add(pm.getObject()));
        }
        OrbitIO.getApp().refreshCurrentView(false);
        return true;
    }

    public static boolean selectNetsInPersonalityByDevTemp(String name, String templateKeyStr) {
        Optional<Personality> personality = PersonalityUI.getPersonalityOpt(Personality.Type.NET, templateKeyStr, name);
        if (!personality.isPresent()) {
            return false;
        }
        personality.get().getPersonalityMaps().forEach(pm -> NetCmd.selectNetToggle((String)((Net)pm.getObject()).getKeyStr()));
        OrbitIO.getApp().refreshCurrentView(false);
        return true;
    }

    @Deprecated
    public static boolean selectNetsInPersonality(String name, String substrateName) {
        Personality p = PersonalityUI.findPersonality(name, Personality.Type.NET, substrateName);
        if (p == null) {
            return false;
        }
        p.getPersonalityMaps().forEach(pm -> NetCmd.selectNetToggle((String)((Net)pm.getObject()).getKeyStr()));
        OrbitIO.getApp().refreshCurrentView(false);
        return true;
    }

    @Deprecated
    public static boolean selectPortsInPersonality(String name, String templateName) {
        Personality p = PersonalityUI.findPersonality(name, Personality.Type.PORT, templateName);
        if (p == null) {
            return false;
        }
        Db db = p.getDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        Substrate substrate = p.getOwner().getSubstrate();
        DevicePath devicePath = null;
        for (DevicePath path : OrbitIO.getCurDesign().getDescendantDevices()) {
            if (path.getSubstrate() != substrate) continue;
            for (PinInstance pi : path.getLast().getPins()) {
                List list = PersonalityMap.getPersonalityList((DbObject)pi);
                if (!list.contains(p)) continue;
                s.add(devicePath, (DbObject)pi);
            }
        }
        OrbitIO.getApp().refreshCurrentView(false);
        return true;
    }

    public static void selectObjectsOfPersonality(Db db, String personalityKey) {
        Personality p = (Personality)db.getByKeyStr(Personality.class, personalityKey);
        if (p == null) {
            ALog.logError((String)"There is no Personality with key '%s', nothing is being selected.", (Object[])new Object[]{personalityKey});
            return;
        }
        Selection sel = Selection.getCurrentSelectionForDb((Db)p.getDb());
        sel.clear();
        p.getOwner().getHierarchicalInstances().stream().forEach(ownerInst -> p.getObjects().forEach(hierObj -> {
            DevicePath fullPath = ownerInst.addPath(hierObj.getPath());
            DbObject dbo = hierObj.getDbObject();
            switch (p.getType()) {
                case DEVICE: {
                    if (dbo != fullPath.getDevice()) break;
                    sel.add(fullPath, hierObj.getDbObject());
                    break;
                }
                case PORT: {
                    if (!(dbo instanceof PinInstance) || ((PinInstance)dbo).getDevice() != fullPath.getDevice()) break;
                    sel.add(fullPath, hierObj.getDbObject());
                    break;
                }
                case NET: {
                    NetCmd.selectNet((HierInst)HierInst.create((DevicePath)fullPath, (DbObject)((Net)hierObj.getDbObject())), (boolean)true, (Selection)sel);
                    break;
                }
                default: {
                    assert (false);
                    ALog.logError((String)"%s.selectObjectsOfPersonality does not support Personalities of type %s.", (Object[])new Object[]{PersonalityUI.class, p.getType().name()});
                    return;
                }
            }
        }));
        OrbitIO.getApp().refreshCurrentView(false);
    }

    @Deprecated
    public static Personality findPersonality(String name, Personality.Type type, String substrateName) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot find personality, no current database.");
            return null;
        }
        Substrate s = Substrate.getSubstrate((Db)db, (String)substrateName);
        for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
            Optional p = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)type, (String)name);
            if (!p.isPresent()) continue;
            return (Personality)p.get();
        }
        ALog.logWarn((String)"Unable to find personality '%s' for substrate '%s'.", (Object[])new Object[]{name, substrateName});
        return null;
    }

    public static Personality findPersonalityOfDevTemp(String name, Personality.Type type, String devTempKeyStr) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot find personality, no current database.");
            return null;
        }
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        Personality p = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)type, (String)name).orElse(null);
        if (p == null) {
            ALog.logWarn((String)"Unable to find personality '%s' for device template '%s'.", (Object[])new Object[]{name, devTemp.getName()});
        }
        return p;
    }

    public static boolean addObjectToPersonality(Db db, String objectTypeKey, String devPortKey, String pinPersKey, boolean removeExisting) {
        DbClass dbClass = db.getDbClass(objectTypeKey);
        Personality pers = Personality.getByKeyStr((Db)db, (String)pinPersKey);
        if (pers == null) {
            ALog.logError((String)"Invalid personality key '%s'.", (Object[])new Object[]{pinPersKey});
            return false;
        }
        DbObject object = db.getByKeyStr(dbClass.getJavaClass(), devPortKey);
        if (object == null) {
            ALog.logError((String)"Invalid %s key '%s'.", (Object[])new Object[]{dbClass.getName(), devPortKey});
            return false;
        }
        PersonalityMap.assignToPersonality((DbObject)object, (Personality)pers, (boolean)removeExisting);
        OrbitIO.getApp().refreshCurrentView(false);
        return true;
    }

    public static boolean addPinToPersonality(Db db, String devPortKey, String pinPersKey, boolean removeExisting) {
        return PersonalityUI.addObjectToPersonality(db, "PinInstance", devPortKey, pinPersKey, removeExisting);
    }

    public static boolean addPinToPersonality(Db db, String devPortKey, String pinPersKey) {
        return PersonalityUI.addPinToPersonality(db, devPortKey, pinPersKey, true);
    }

    public static boolean removeObjectFromPersonality(Db db, String objectTypeKey, String devPortKey) {
        return PersonalityUI.removeObjectFromPersonality(db, objectTypeKey, devPortKey, "");
    }

    public static boolean removeObjectFromPersonality(Db db, String objectTypeKey, String objectKey, String personalityStrKey) {
        DbClass dbClass = db.getDbClass(objectTypeKey);
        Personality personality = personalityStrKey.length() == 0 ? null : (Personality)db.getByKeyStr(Personality.class, personalityStrKey);
        DbObject object = db.getByKeyStr(dbClass.getJavaClass(), objectKey);
        if (object == null) {
            ALog.logError((String)"Invalid %s key '%s'.", (Object[])new Object[]{dbClass.getName(), objectKey});
            return false;
        }
        if (personality == null) {
            PersonalityMap.unAssignFromPersonality((DbObject)object);
        } else {
            PersonalityMap.unAssignFromPersonality((Personality)personality, (DbObject)object);
        }
        OrbitIO.getApp().refreshCurrentView(false);
        return true;
    }

    public static boolean removePinFromPersonality(Db db, String devPortKey) {
        return PersonalityUI.removePinFromPersonality(db, devPortKey, "");
    }

    public static boolean removePinFromPersonality(Db db, String devPortKey, String personalityStrKey) {
        return PersonalityUI.removeObjectFromPersonality(db, "PinInstance", devPortKey, personalityStrKey);
    }

    public static boolean copyPersonalities(Db db, String objectTypeKey, String fromObjectKey, String toObjectKey, boolean overwrite) {
        DbClass dbClass = db.getDbClass(objectTypeKey);
        DbObject fromObject = db.getByKeyStr(dbClass.getJavaClass(), fromObjectKey);
        DbObject toObject = db.getByKeyStr(dbClass.getJavaClass(), toObjectKey);
        if (fromObject == null) {
            ALog.logError((String)"Invalid object key '%s'.", (Object[])new Object[]{fromObjectKey});
            return false;
        }
        if (toObject == null) {
            ALog.logError((String)"Invalid object key '%s'.", (Object[])new Object[]{toObjectKey});
            return false;
        }
        if (fromObject instanceof PinInstance) {
            for (Device device : ((PinInstance)fromObject).getDeviceTemplate().getDeviceInstances()) {
                for (DevicePath devPath : device.getHierarchicalInstances()) {
                    PersonalityMap.copyPersonalities((DbObject)fromObject, (DevicePath)devPath, (DbObject)toObject, (DevicePath)devPath, (boolean)overwrite);
                }
            }
        }
        return true;
    }

    public static boolean copyPersonalities(Db db, String objectTypeKey, String fromObjectKey, String fromDevicePathString, String toObjectKey, String toDevicePathString, boolean overwrite) {
        DbClass dbClass = db.getDbClass(objectTypeKey);
        DevicePath fromDevicePath = DevicePath.fromEscapedString((Db)db, (String)fromDevicePathString);
        DevicePath toDevicePath = DevicePath.fromEscapedString((Db)db, (String)toDevicePathString);
        DbObject fromObject = db.getByKeyStr(dbClass.getJavaClass(), fromObjectKey);
        DbObject toObject = db.getByKeyStr(dbClass.getJavaClass(), toObjectKey);
        if (fromObject == null) {
            ALog.logError((String)"Invalid object key '%s'.", (Object[])new Object[]{fromObjectKey});
            return false;
        }
        if (toObject == null) {
            ALog.logError((String)"Invalid object key '%s'.", (Object[])new Object[]{toObjectKey});
            return false;
        }
        if (fromObject instanceof PinInstance) {
            PersonalityMap.copyPersonalities((DbObject)fromObject, (DevicePath)fromDevicePath, (DbObject)toObject, (DevicePath)toDevicePath, (boolean)overwrite);
        }
        return true;
    }

    @Deprecated
    public static void doSynthesizeAreaCommands(String personalityName, String templateName) {
        Personality p = PersonalityUI.findPersonality(personalityName, Personality.Type.DEVICE, templateName);
        if (p != null) {
            p.synthesizeAreaFromDevices();
            p.arrangeDevicesInArea();
            p.createParent(null);
            Db db = p.getDb();
            Design design = Design.getDesign((Db)db);
            design.binAllDevices();
        }
    }

    public static void doSynthesizeAreaCommands(Db db, String personalityName, String templateKeyStr) {
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKeyStr);
        Optional p = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.DEVICE, (String)personalityName);
        if (p.isPresent()) {
            ((Personality)p.get()).synthesizeAreaFromDevices();
            ((Personality)p.get()).arrangeDevicesInArea();
            ((Personality)p.get()).createParent(null);
            Design design = Design.getDesign((Db)db);
            design.binAllDevices();
        }
    }

    protected static void highlightPortPersonality(DesignView2D v, Personality portPersonality) {
        Db db = portPersonality.getDb();
        Selection sel = new Selection(db);
        portPersonality.getPersonalityMaps().filter(pm -> pm.getObject() instanceof PinInstance).forEach(pm -> {
            PinInstance dport = (PinInstance)pm.getObject();
            for (DevicePath path : dport.getDevice().getHierarchicalInstances()) {
                sel.add(path, (DbObject)dport);
            }
        });
        if (sel.getCountTotal() > 0L) {
            v.highlight(sel, false);
        }
    }

    protected static void highlightNetPersonality(DesignView2D v, Personality netPersonality) {
        Db db = netPersonality.getDb();
        Selection sel = new Selection(db);
        netPersonality.getPersonalityMaps().forEach(pm -> {
            Net net = (Net)pm.getObject();
            NetCmd.selectNet((Net)net, (boolean)true, (Selection)sel);
        });
        if (sel.getCountTotal() > 0L) {
            v.highlight(sel, false);
        }
    }

    public static class ActionRemovePersonalitiesFromSelectedNets
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(() -> PersonalityUI.removePersonalitiesFromSelected(OrbitIO.getCurDb(), new Class[]{Net.class}), (String)"com.sigrity.orbit.ui.PersonalityUI.removePersonalitiesFromSelected(curDb(), new Class[]{Net.class})", (Object[])new Object[0]);
        }
    }

    public static class ActionRemovePersonalitiesFromSelectedObjects
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(() -> PersonalityUI.removePersonalitiesFromSelected(OrbitIO.getCurDb(), new Class[]{Device.class, Net.class, PinInstance.class}), (String)"com.sigrity.orbit.ui.PersonalityUI.removePersonalitiesFromSelected(curDb(), new Class[]{Device.class, Net.class, PinInstance.class})", (Object[])new Object[0]);
        }
    }

    public static class ActionRemovePersonalitiesFromSelectedPins
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(() -> PersonalityUI.removePersonalitiesFromSelected(OrbitIO.getCurDb(), new Class[]{PinInstance.class}), (String)"com.sigrity.orbit.ui.PersonalityUI.removePersonalitiesFromSelected(curDb(), new Class[]{PinInstance.class})", (Object[])new Object[0]);
        }
    }

    public static class ActionRemovePersonalitiesFromSelectedDevices
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(() -> PersonalityUI.removePersonalitiesFromSelected(OrbitIO.getCurDb(), new Class[]{Device.class}), (String)"com.sigrity.orbit.ui.PersonalityUI.removePersonalitiesFromSelected(curDb(), new Class[]{Device.class})", (Object[])new Object[0]);
        }
    }

    public static class ActionAddPortsToPersonality
    extends AbstractAction {
        protected Personality p;
        protected List<PinInstance> dpps;

        public ActionAddPortsToPersonality(Personality p, List<PinInstance> dpps) {
            this.p = p;
            this.dpps = dpps;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (PinInstance dpp : this.dpps) {
                if (this.p == null) {
                    Cp.exec(() -> PersonalityUI.removePinFromPersonality(OrbitIO.getCurDb(), dpp.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removePinFromPersonality(curDb(), \"%s\")", (Object[])new Object[]{dpp.getKeyStr()});
                    continue;
                }
                Cp.exec(() -> PersonalityUI.addPinToPersonality(OrbitIO.getCurDb(), dpp.getKeyStr(), this.p.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.addPinToPersonality(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{dpp.getKeyStr(), this.p.getKeyStr()});
            }
        }
    }

    public static class ActionAddPortsToPersonalityFromDialog
    extends AbstractAction {
        protected List<Personality> mPersonalities;
        protected List<HierInst<PinInstance>> mHierPins;
        protected Db mDb;

        public ActionAddPortsToPersonalityFromDialog(String name, List<Personality> personalities, List<HierInst<PinInstance>> hPins) {
            super(name);
            this.mPersonalities = personalities;
            this.mPersonalities.sort((Comparator<Personality>)AAlphaNumComp.get());
            this.mHierPins = hPins;
            this.mDb = !personalities.isEmpty() ? personalities.get(0).getDb() : this.mHierPins.get(0).getDb();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GetAnObjectChooserDlg.createDialog(OrbitIO.getMainWindow(), new GetDbObjectChooserAdaptor(), false);
        }

        class GetDbObjectChooserAdaptor
        implements GetAnObjectChooserDlg.GetAnObjectChooserHelper {
            private boolean removeExisting = true;

            GetDbObjectChooserAdaptor() {
            }

            @Override
            public Db getDb() {
                return ActionAddPortsToPersonalityFromDialog.this.mDb;
            }

            @Override
            public String getTitle() {
                return "" + ActionAddPortsToPersonalityFromDialog.this.getValue("Name");
            }

            @Override
            public String getUserObjectName() {
                return "Personality";
            }

            @Override
            public void doDoneCommand(List<Object> personalities) {
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)ActionAddPortsToPersonalityFromDialog.this.mDb, (String)"Assign Personalities");){
                    for (HierInst<PinInstance> hPin : ActionAddPortsToPersonalityFromDialog.this.mHierPins) {
                        if (this.removeExisting) {
                            Cp.exec(() -> PersonalityUI.removePinFromPersonality(OrbitIO.getCurDb(), ((PinInstance)hPin.second).getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removePinFromPersonality(curDb(), \"%s\")", (Object[])new Object[]{((PinInstance)hPin.second).getKeyStr()});
                        }
                        int numSkipped = 0;
                        for (Object obj : personalities) {
                            Personality pers = (Personality)obj;
                            DevicePath relPath = ((DevicePath)hPin.first).getRelativePathFromAnchor(pers.getOwner());
                            if (relPath == null) {
                                ++numSkipped;
                                continue;
                            }
                            Cp.exec(() -> PersonalityMap.create((Db)OrbitIO.getCurDb(), (String)pers.getKeyStr(), (String)relPath.escapedString(), ((PinInstance)hPin.second).getClass(), (String)((PinInstance)hPin.second).getKeyStr()), (String)"PersonalityMap.create(curDb(), \"%s\", \"%s\", %s.class, \"%s\")", (Object[])new Object[]{pers.getKeyStr(), relPath.escapedString(), ((PinInstance)hPin.second).getClass().getName(), ((PinInstance)hPin.second).getKeyStr()});
                        }
                        if (numSkipped <= 0) continue;
                        if (numSkipped > 1) {
                            ALog.logWarn((String)(numSkipped + " pins were skipped because they are not on the appropriate substrate."));
                            continue;
                        }
                        ALog.logWarn((String)"One pin was skipped because it was not on the appropriate substrate.");
                    }
                }
            }

            @Override
            public void doClosingCommand() {
            }

            @Override
            public String getObjectString(Object obj) {
                Personality p = (Personality)obj;
                DeviceTemplate owner = p.getOwner();
                return String.format("<html><b>%s</b> <i>(%s)</i>", p.getName(), owner == null ? "unknown" : owner.getName());
            }

            @Override
            public String getObjectTip(Object obj) {
                Personality p = (Personality)obj;
                DeviceTemplate owner = p.getOwner();
                if (owner == null) {
                    return null;
                }
                if (owner.getSubstrate() == null) {
                    return null;
                }
                return String.format("<html><b>Owner:</b> Substrate '%s', template '%s'", owner.getSubstrate().getName(), owner.getName());
            }

            @Override
            public Color getObjectColor(Object pers) {
                return ((Personality)pers).getColor();
            }

            @Override
            public List<Object> getSortedObjectList() {
                return ActionAddPortsToPersonalityFromDialog.this.mPersonalities.stream().collect(Collectors.toList());
            }

            @Override
            public int getNumCheckboxes() {
                return 1;
            }

            @Override
            public String getCheckboxTitle(int index) {
                return "Add to existing personalities";
            }

            @Override
            public String getCheckboxTooltip(int index) {
                return "Keep the personalites already assigned before adding the ones picked?";
            }

            @Override
            public boolean getDefaultCheckboxValue(int index) {
                return !this.removeExisting;
            }

            @Override
            public void notifyCheckboxChanged(String title, boolean newValue) {
                this.removeExisting = !newValue;
            }
        }
    }

    public static class ActionRemovePortPersonality
    extends AbstractAction {
        PinInstance p;
        Personality personality;

        public ActionRemovePortPersonality(PinInstance p, Personality pers) {
            this.p = p;
            this.personality = pers;
        }

        public ActionRemovePortPersonality(PinInstance p) {
            this.p = p;
            this.personality = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(() -> PersonalityUI.removePinFromPersonality(OrbitIO.getCurDb(), this.p.getKeyStr(), this.personality == null ? "" : this.personality.getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.removePinFromPersonality(curDb(),  \"%s\",  \"%s\")", (Object[])new Object[]{this.p.getKeyStr(), this.personality == null ? "" : this.personality.getKeyStr()});
        }
    }

    public static class DevicePersonalityEditDlg
    extends AbstractPersonalityEditDlg {
        protected GridPanel mGridPanel = new GridPanel();
        protected PlacementAreaPanel mAreaPanel = new PlacementAreaPanel();
        protected ActionListener mChangeColor = e -> {
            AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)this), "Select Color", this.mIconColor.getColor());
            ccd.setShowOpacity(true);
            Color c = ccd.doModal();
            if (c != null) {
                this.mIconColor.setColor(c);
            }
        };
        protected ActionListener mOk = e -> {
            try {
                AFieldValidator.validateText((JTextComponent)this.mTxtName);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            if (!this.mGridPanel.validateFields()) {
                return;
            }
            if (!this.mAreaPanel.validateFields()) {
                return;
            }
            this.mAccepted = true;
            UIUtil.closeWindow((Window)((Object)this));
        };

        @Deprecated
        public DevicePersonalityEditDlg(Window owner, String title, Substrate s, Personality edit) {
            super(owner, title, Personality.Type.DEVICE, s, edit);
            this.init(edit);
        }

        public DevicePersonalityEditDlg(Window owner, String title, DeviceTemplate dt, Personality edit) {
            super(owner, title, Personality.Type.DEVICE, dt, edit);
            this.init(edit);
        }

        public boolean getAccepted() {
            return this.mAccepted;
        }

        public String getPersonalityName() {
            return this.mTxtName.getText();
        }

        public Color getPersonalityColor() {
            return this.mIconColor.getColor();
        }

        public AGrid getGrid() {
            return this.mGridPanel.getGrid();
        }

        public ARect getPlacementArea() {
            return this.mAreaPanel.getPlacementArea();
        }

        public boolean getPlacementAreaExclusive() {
            return this.mAreaPanel.getAreaExclusive();
        }

        protected void init(Personality personality) {
            this.mView = OrbitIO.getCurView();
            this.mPersonality = personality;
            this.setTitle("Device Personalities");
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Name:");
            this.mTxtName = new JTextField(10);
            l.add((Component)this.mTxtName, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add("Color:");
            this.mIconColor = new AColorIcon(16, 16, this.getBackground());
            this.mBtnColor = new JButton((Icon)this.mIconColor);
            this.mBtnColor.addActionListener(this.mChangeColor);
            l.add((Component)this.mBtnColor, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.mGridPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            l.add((Component)this.mAreaPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton btnOk = new JButton("OK");
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(this.mOk);
            JButton btnClose = new JButton("Cancel");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.updateUI();
        }

        protected void updateUI() {
            if (this.mPersonality == null) {
                return;
            }
            this.mTxtName.setText(this.mPersonality.getName());
            this.mIconColor.setColor(this.mPersonality.getColor());
            this.mBtnColor.repaint();
            Db db = this.mPersonality.getDb();
            this.mGridPanel.setGrid((AGrid)Constraint.getValue((Db)db, (DbObject)this.mPersonality, (Constraint.Descriptor)Constraint.PLACE_GRID));
            this.mAreaPanel.setArea((ARect)Constraint.getValue((Db)db, (DbObject)this.mPersonality, (Constraint.Descriptor)Constraint.PLACE_AREA));
            this.mAreaPanel.setExclusive((Boolean)Constraint.getValue((Db)db, (DbObject)this.mPersonality, (Constraint.Descriptor)Constraint.PLACE_AREA_EXCLUSIVE));
            this.mAreaPanel.setDeviceManaged((Boolean)Constraint.getValue((Db)db, (DbObject)this.mPersonality, (Constraint.Descriptor)Constraint.DEVICE_MANAGED));
        }

        public long getDbVal(JTextField tf) {
            String s = tf.getText();
            double d = 0.0;
            try {
                d = NumberFormat.getInstance().parse(s).doubleValue();
            }
            catch (ParseException e) {
                assert (false);
                return 0L;
            }
            if (this.mView == null) {
                assert (false);
                return (long)d;
            }
            return this.mView.getUnit().fromUser(d);
        }

        public void setUserVal(JTextField tf, long l) {
            tf.setText(this.mView.getUnit().toUserStr(l));
        }

        protected class PlacementAreaPanel
        extends JPanel {
            protected JRadioButton mSynType = new JRadioButton("Synthesize Area");
            protected JRadioButton mHardType = new JRadioButton("User Defined Area");
            protected JButton mCalcAreaNow = new JButton("Calculate");
            protected JButton mCreateParent = new JButton("Create");
            protected JTextField mTxtX0 = new JTextField(10);
            protected JTextField mTxtY0 = new JTextField(10);
            protected JTextField mTxtX1 = new JTextField(10);
            protected JTextField mTxtY1 = new JTextField(10);
            protected JCheckBox mCbExclusive = new JCheckBox("Exclude other devices");

            public PlacementAreaPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                l.pushRemainX("Placement Area");
                l.add((Component)this.mSynType, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                l.add("Calculate area based on currently assigned devices");
                l.newline();
                l.add((Component)this.mCalcAreaNow, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
                l.newline();
                l.add((Component)this.mHardType, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                ButtonGroup synGroup = new ButtonGroup();
                synGroup.add(this.mSynType);
                synGroup.add(this.mHardType);
                l.add("Lower-left X:");
                l.add((Component)this.mTxtX0, (GridBagConstraints)GridBagManager.FILLX);
                l.add("Y:");
                l.add((Component)this.mTxtY0, (GridBagConstraints)GridBagManager.FILLX);
                l.newline();
                l.add("Uper-right X:");
                l.add((Component)this.mTxtX1, (GridBagConstraints)GridBagManager.FILLX);
                l.add("Y:");
                l.add((Component)this.mTxtY1, (GridBagConstraints)GridBagManager.FILLX);
                l.newline();
                l.add((Component)this.mCbExclusive, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
                this.mHardType.addActionListener(e -> this.enableControls());
                this.mSynType.addActionListener(e -> this.enableControls());
                this.mCalcAreaNow.addActionListener(e -> {
                    Cp.exec(() -> PersonalityUI.doSynthesizeAreaCommands(OrbitIO.getCurDb(), DevicePersonalityEditDlg.this.mPersonality.getName(), DevicePersonalityEditDlg.this.mPersonality.getOwner().getKeyStr()), (String)"com.sigrity.orbit.ui.PersonalityUI.doSynthesizeAreaCommands(curDb(),\"%s\", \"%s\")", (Object[])new Object[]{DevicePersonalityEditDlg.this.mPersonality.getName(), DevicePersonalityEditDlg.this.mPersonality.getOwner().getKeyStr()});
                    this.enableControls();
                });
                this.mCreateParent.addActionListener(e -> {
                    DevicePersonalityEditDlg.this.mPersonality.createParent(null);
                    this.enableControls();
                });
                this.mSynType.setSelected(true);
                this.enableControls();
            }

            public boolean validateFields() {
                if (this.mHardType.isSelected()) {
                    try {
                        AFieldValidator.validateDouble((JTextField)this.mTxtX0);
                        AFieldValidator.validateDouble((JTextField)this.mTxtY0);
                        AFieldValidator.validateDouble((JTextField)this.mTxtX1);
                        AFieldValidator.validateDouble((JTextField)this.mTxtY1);
                    }
                    catch (AFieldValidator.AFieldValidationException e) {
                        return false;
                    }
                }
                return true;
            }

            public boolean useArea() {
                return this.mHardType.isSelected();
            }

            public void enableControls() {
                if (this.mHardType.isSelected()) {
                    this.mCalcAreaNow.setEnabled(false);
                    this.mTxtX0.setEnabled(true);
                    this.mTxtY0.setEnabled(true);
                    this.mTxtX1.setEnabled(true);
                    this.mTxtY1.setEnabled(true);
                } else {
                    this.mCalcAreaNow.setEnabled(true);
                    this.mTxtX0.setEnabled(false);
                    this.mTxtY0.setEnabled(false);
                    this.mTxtX1.setEnabled(false);
                    this.mTxtY1.setEnabled(false);
                }
            }

            public ARect getPlacementArea() {
                if (!this.useArea()) {
                    return null;
                }
                return new ARect(DevicePersonalityEditDlg.this.getDbVal(this.mTxtX0), DevicePersonalityEditDlg.this.getDbVal(this.mTxtY0), DevicePersonalityEditDlg.this.getDbVal(this.mTxtX1), DevicePersonalityEditDlg.this.getDbVal(this.mTxtY1));
            }

            public boolean getAreaExclusive() {
                return this.mCbExclusive.isSelected();
            }

            public void setArea(ARect rect) {
                this.mHardType.setSelected(rect != null);
                if (rect != null) {
                    DevicePersonalityEditDlg.this.setUserVal(this.mTxtX0, rect.left());
                    DevicePersonalityEditDlg.this.setUserVal(this.mTxtY0, rect.bottom());
                    DevicePersonalityEditDlg.this.setUserVal(this.mTxtX1, rect.right());
                    DevicePersonalityEditDlg.this.setUserVal(this.mTxtY1, rect.top());
                }
            }

            public void setExclusive(Boolean exclusive) {
                if (exclusive != null) {
                    this.mCbExclusive.setSelected(exclusive);
                }
                this.enableControls();
            }

            public void setDeviceManaged(Boolean deviceManaged) {
                this.mHardType.setSelected(true);
                this.mSynType.setSelected(false);
                if (deviceManaged != null && deviceManaged.booleanValue()) {
                    this.mSynType.setSelected(true);
                    this.mHardType.setSelected(false);
                }
                this.enableControls();
            }
        }

        protected class GridPanel
        extends JPanel {
            protected JCheckBox mCbUseGrid = new JCheckBox("Placement Grid");
            protected JTextField mTxtOriginX = new JTextField(10);
            protected JTextField mTxtOriginY = new JTextField(10);
            protected JTextField mTxtDeltaX = new JTextField(10);
            protected JTextField mTxtDeltaY = new JTextField(10);

            public GridPanel() {
                AComponentTitledBorder border = new AComponentTitledBorder(this.mCbUseGrid, this);
                this.setBorder(border);
                GridBagManager l = new GridBagManager((Container)this);
                l.add("Origin X:");
                l.add((Component)this.mTxtOriginX, (GridBagConstraints)GridBagManager.FILLX);
                l.add("Y:");
                l.add((Component)this.mTxtOriginY, (GridBagConstraints)GridBagManager.FILLX);
                l.newline();
                l.add("Space X:");
                l.add((Component)this.mTxtDeltaX, (GridBagConstraints)GridBagManager.FILLX);
                l.add("Y:");
                l.add((Component)this.mTxtDeltaY, (GridBagConstraints)GridBagManager.FILLX);
                this.mCbUseGrid.addActionListener(e -> this.enableControls());
                this.enableControls();
            }

            public boolean validateFields() {
                if (!this.useGrid()) {
                    return true;
                }
                try {
                    AFieldValidator.validateDouble((JTextField)this.mTxtOriginX);
                    AFieldValidator.validateDouble((JTextField)this.mTxtOriginY);
                    AFieldValidator.validateDouble((JTextField)this.mTxtDeltaX);
                    AFieldValidator.validateDouble((JTextField)this.mTxtDeltaY);
                }
                catch (AFieldValidator.AFieldValidationException e) {
                    return false;
                }
                return true;
            }

            public boolean useGrid() {
                return this.mCbUseGrid.isSelected();
            }

            public void enableControls() {
                UIUtil.setEnabled((Container)this, (boolean)this.useGrid());
                this.mCbUseGrid.setEnabled(true);
            }

            public AGrid getGrid() {
                if (!this.useGrid()) {
                    return null;
                }
                return new AGrid(DevicePersonalityEditDlg.this.getDbVal(this.mTxtDeltaX), DevicePersonalityEditDlg.this.getDbVal(this.mTxtDeltaY), DevicePersonalityEditDlg.this.getDbVal(this.mTxtOriginX), DevicePersonalityEditDlg.this.getDbVal(this.mTxtOriginY));
            }

            public void setGrid(AGrid grid) {
                this.mCbUseGrid.setSelected(grid != null);
                if (grid != null) {
                    DevicePersonalityEditDlg.this.setUserVal(this.mTxtOriginX, grid.getOrignX());
                    DevicePersonalityEditDlg.this.setUserVal(this.mTxtOriginY, grid.getOrignY());
                    DevicePersonalityEditDlg.this.setUserVal(this.mTxtDeltaX, grid.getDeltaX());
                    DevicePersonalityEditDlg.this.setUserVal(this.mTxtDeltaY, grid.getDeltaY());
                }
                this.enableControls();
            }
        }
    }

    public static class NetPersonalityEditDlg
    extends AbstractPersonalityEditDlg {
        protected JCheckBox mMatchLength;
        protected JCheckBox mPower;
        protected ActionListener mChangeColor = e -> {
            AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)this), "Select Color", this.mIconColor.getColor());
            ccd.setShowOpacity(true);
            Color c = ccd.doModal();
            if (c != null) {
                this.mIconColor.setColor(c);
            }
        };
        protected ActionListener mOk = e -> {
            try {
                AFieldValidator.validateText((JTextComponent)this.mTxtName);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            this.mAccepted = true;
            UIUtil.closeWindow((Window)((Object)this));
        };

        @Deprecated
        public NetPersonalityEditDlg(Window owner, String title, Substrate s, Personality edit) {
            super(owner, title, Personality.Type.NET, s, edit);
            this.init(edit);
        }

        public NetPersonalityEditDlg(Window owner, String title, DeviceTemplate dt, Personality edit) {
            super(owner, title, Personality.Type.NET, dt, edit);
            this.init(edit);
        }

        public boolean getAccepted() {
            return this.mAccepted;
        }

        public String getPersonalityName() {
            return this.mTxtName.getText();
        }

        public Color getPersonalityColor() {
            return this.mIconColor.getColor();
        }

        public boolean getMatchLength() {
            return this.mMatchLength.isSelected();
        }

        public boolean getPower() {
            return this.mPower.isSelected();
        }

        public long getDbVal(JTextField tf) {
            String s = tf.getText();
            if (s == null || s.isEmpty()) {
                return 0L;
            }
            double d = 0.0;
            try {
                d = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                assert (false);
                return 0L;
            }
            if (this.mView == null) {
                assert (false);
                return (long)d;
            }
            return this.mView.getUnit().fromUser(d);
        }

        public void setUserVal(JTextField tf, long l) {
            tf.setText(this.mView.getUnit().toUserStr(l));
        }

        protected void init(Personality personality) {
            this.mView = OrbitIO.getCurView();
            this.mPersonality = personality;
            this.setTitle("Net Personalities");
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Name:");
            this.mTxtName = new JTextField(10);
            l.add((Component)this.mTxtName, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add("Color:");
            this.mIconColor = new AColorIcon(16, 16, this.getBackground());
            this.mBtnColor = new JButton((Icon)this.mIconColor);
            this.mBtnColor.addActionListener(this.mChangeColor);
            l.add((Component)this.mBtnColor, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.mMatchLength = new JCheckBox("Diff Pair");
            l.add((Component)this.mMatchLength, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.mPower = new JCheckBox("Power Net");
            l.add((Component)this.mPower, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton btnOk = new JButton("OK");
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(this.mOk);
            JButton btnClose = new JButton("Cancel");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.updateUI();
        }

        protected void updateUI() {
            if (this.mPersonality == null) {
                return;
            }
            this.mTxtName.setText(this.mPersonality.getName());
            this.mIconColor.setColor(this.mPersonality.getColor());
            this.mBtnColor.repaint();
            Db db = this.mPersonality.getDb();
            Boolean matchLength = (Boolean)Constraint.getValue((Db)db, (DbObject)this.mPersonality, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH);
            this.mMatchLength.setSelected(matchLength != null && matchLength != false);
            Boolean power = (Boolean)Constraint.getValue((Db)db, (DbObject)this.mPersonality, (Constraint.Descriptor)Constraint.IS_POWER);
            this.mPower.setSelected(power != null && power != false);
        }
    }

    public static class PortPersonalityEditDlg
    extends AbstractPersonalityEditDlg {
        protected JTextField mRatio;
        protected JCheckBox mSwap;
        protected JCheckBox mAllowAutoPop;
        protected JLabel mAllowLabel;
        protected ActionListener mChangeColor = e -> {
            AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)this), "Select Color", this.mIconColor.getColor());
            ccd.setShowOpacity(true);
            Color c = ccd.doModal();
            if (c != null) {
                this.mIconColor.setColor(c);
            }
        };
        protected ActionListener mChangeAutoPopListener = e -> {
            this.mRatio.setEnabled(this.mAllowAutoPop.isSelected());
            this.mAllowLabel.setEnabled(this.mAllowAutoPop.isSelected());
        };
        protected ActionListener mOk = e -> {
            if (!this.validateNameField()) {
                return;
            }
            try {
                AFieldValidator.validateLong((JTextField)this.mRatio);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            this.mAccepted = true;
            UIUtil.closeWindow((Window)((Object)this));
        };

        @Deprecated
        public PortPersonalityEditDlg(Window owner, String title, Substrate s, Personality edit) {
            super(owner, title, Personality.Type.PORT, s, edit);
            this.init(edit);
        }

        public PortPersonalityEditDlg(Window owner, String title, DeviceTemplate dt, Personality edit) {
            super(owner, title, Personality.Type.PORT, dt, edit);
            this.init(edit);
        }

        public boolean getAccepted() {
            return this.mAccepted;
        }

        public String getPersonalityName() {
            return this.mTxtName.getText();
        }

        public Color getPersonalityColor() {
            return this.mIconColor.getColor();
        }

        public long getPortAssignRatio() {
            if (this.mAllowAutoPop.isSelected()) {
                return this.getValue(this.mRatio);
            }
            return 0L;
        }

        public boolean isAllowSwapping() {
            return this.mSwap.isSelected();
        }

        protected void init(Personality personality) {
            this.mView = OrbitIO.getCurView();
            this.mPersonality = personality;
            this.setTitle("Pin Personalities");
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Name:");
            this.mTxtName = new JTextField(10);
            l.add((Component)this.mTxtName, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            this.mAllowAutoPop = new JCheckBox("Allow Automatic Assignment");
            l.add((Component)this.mAllowAutoPop, (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
            this.mAllowAutoPop.addActionListener(this.mChangeAutoPopListener);
            l.newline();
            this.mAllowLabel = new JLabel("Assignment Ratio:");
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets().indent());
            l.add((Component)this.mAllowLabel);
            this.mRatio = new JTextField(10);
            l.add((Component)this.mRatio, (GridBagConstraints)GridBagManager.LEFT);
            l.popNl();
            this.mSwap = new JCheckBox("Allow Swapping During Placement");
            l.add((Component)this.mSwap, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.add("Color:");
            this.mIconColor = new AColorIcon(16, 16, this.getBackground());
            this.mBtnColor = new JButton((Icon)this.mIconColor);
            this.mBtnColor.addActionListener(this.mChangeColor);
            l.add((Component)this.mBtnColor, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.addFillY();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton btnOk = new JButton("OK");
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(this.mOk);
            JButton btnClose = new JButton("Cancel");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.updateUI();
        }

        protected void updateUI() {
            this.mRatio.setEnabled(false);
            this.mAllowLabel.setEnabled(false);
            this.setValue(this.mRatio, 0L);
            if (this.mPersonality == null) {
                return;
            }
            this.mTxtName.setText(this.mPersonality.getName());
            this.mIconColor.setColor(this.mPersonality.getColor());
            this.mBtnColor.repaint();
            Db db = this.mPersonality.getDb();
            Long ratio = (Long)Constraint.getValue((Db)db, (DbObject)this.mPersonality, (Constraint.Descriptor)Constraint.PORT_ASSIGN_RATIO);
            if (ratio == null) {
                this.setValue(this.mRatio, 0L);
            } else {
                this.setValue(this.mRatio, ratio);
            }
            if (ratio != null && ratio != 0L) {
                this.mRatio.setEnabled(true);
                this.mAllowAutoPop.setSelected(true);
                this.mAllowLabel.setEnabled(true);
            } else {
                this.mRatio.setEnabled(false);
                this.mAllowAutoPop.setSelected(false);
                this.mAllowLabel.setEnabled(false);
            }
            Boolean swap = (Boolean)Constraint.getValue((Db)db, (DbObject)this.mPersonality, (Constraint.Descriptor)Constraint.ALLOW_SWAPPING);
            if (swap == null) {
                this.mSwap.setSelected(false);
            } else {
                this.mSwap.setSelected(swap);
            }
        }

        public long getValue(JTextField tf) {
            String s = tf.getText();
            long l = 0L;
            try {
                l = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
            return l;
        }

        public void setValue(JTextField tf, Long l) {
            tf.setText(l.toString());
        }
    }

    public static class AbstractPersonalityEditDlg
    extends ADialog {
        protected Personality.Type mPersonalityType;
        protected AAppView mView;
        protected Substrate mSubstrate = null;
        protected DeviceTemplate mDeviceTemplate = null;
        protected Personality mPersonality = null;
        protected JTextField mTxtName;
        protected JButton mBtnColor;
        protected AColorIcon mIconColor;
        protected boolean mAccepted = false;

        @Deprecated
        protected AbstractPersonalityEditDlg(Window owner, String title, Personality.Type type, Substrate substrate, Personality editPersonality) {
            super(owner);
            this.mPersonalityType = type;
            this.mSubstrate = substrate;
            this.mPersonality = editPersonality;
        }

        protected AbstractPersonalityEditDlg(Window owner, String title, Personality.Type type, DeviceTemplate dt, Personality editPersonality) {
            super(owner);
            this.mPersonalityType = type;
            this.mDeviceTemplate = dt;
            this.mPersonality = editPersonality;
        }

        protected boolean validateNameField() {
            try {
                AFieldValidator.validateText((JTextComponent)this.mTxtName);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return false;
            }
            String newName = this.mTxtName.getText().trim();
            if (this.mPersonality == null || !this.mPersonality.getName().equals(newName)) {
                if (this.mDeviceTemplate != null) {
                    if (Personality.getPersonality((DeviceTemplate)this.mDeviceTemplate, (Personality.Type)this.mPersonalityType, (String)newName).isPresent()) {
                        this.mTxtName.requestFocus();
                        String msg = String.format("The name '%s' is already in use.", newName);
                        JOptionPane.showMessageDialog(this.mTxtName, msg, "Invalid Data", 0);
                        return false;
                    }
                } else {
                    for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
                        if (!Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)this.mPersonalityType, (String)newName).isPresent()) continue;
                        this.mTxtName.requestFocus();
                        String msg = String.format("The name '%s' is already in use.", newName);
                        JOptionPane.showMessageDialog(this.mTxtName, msg, "Invalid Data", 0);
                        return false;
                    }
                }
            }
            return true;
        }

        public boolean isNameChanged() {
            String newName = this.mTxtName.getText().trim();
            return this.mPersonality != null && !this.mPersonality.getName().equals(newName);
        }

        public boolean updateNameIfChanged() {
            if (!this.isNameChanged()) {
                return false;
            }
            String newName = this.mTxtName.getText().trim();
            boolean updated = false;
            updated = this.mDeviceTemplate != null ? ((Boolean)Cp.exec(() -> PersonalityUI.updatePersonalityNameByDevTemp(this.mDeviceTemplate.getKeyStr(), this.mPersonalityType.name(), this.mPersonality.getName(), newName), (String)"com.sigrity.orbit.ui.PersonalityUI.updatePersonalityNameByDevTemp(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{this.mDeviceTemplate.getKeyStr(), this.mPersonalityType.name(), this.mPersonality.getName(), newName})).booleanValue() : ((Boolean)Cp.exec(() -> PersonalityUI.updatePersonalityName(this.mSubstrate.getName(), this.mPersonalityType.name(), this.mPersonality.getName(), newName), (String)"com.sigrity.orbit.ui.PersonalityUI.updatePersonalityName(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{this.mSubstrate.getName(), this.mPersonalityType.name(), this.mPersonality.getName(), newName})).booleanValue();
            return updated;
        }
    }

    public static class PortPersonalityDistributeDlg
    extends ADialog {
        protected AAppView mView;
        protected Substrate mSubstrate = null;
        protected JRadioButton mButtonRandom;
        protected JRadioButton mButtonProximity;
        protected String mBaseSubstrate = null;
        protected JComboBox<String> mSubstrateList = null;
        protected boolean mAccepted = false;
        protected ActionListener mRandom = e -> this.mSubstrateList.invalidate();
        protected ActionListener mProximity = e -> this.mSubstrateList.validate();
        protected ActionListener mOk = e -> {
            if (this.mButtonProximity.isSelected()) {
                Object o = this.mSubstrateList.getSelectedItem();
                if (o == null) {
                    return;
                }
                if (o instanceof String) {
                    this.mBaseSubstrate = (String)o;
                }
                if (this.mBaseSubstrate == null) {
                    return;
                }
            }
            this.mAccepted = true;
            UIUtil.closeWindow((Window)((Object)this));
        };

        public static PortPersonalityDistributeDlg createDialog(Window owner, String title, Substrate toSubstrate) {
            PortPersonalityDistributeDlg dlg = null;
            dlg = new PortPersonalityDistributeDlg(owner, toSubstrate);
            dlg.setTitle(title);
            dlg.init();
            return dlg;
        }

        public PortPersonalityDistributeDlg(Window owner, Substrate substrate) {
            super(owner);
            this.mSubstrate = substrate;
        }

        public boolean getAccepted() {
            return this.mAccepted;
        }

        public boolean isRandom() {
            return this.mButtonRandom.isSelected();
        }

        public String getBaseSubstrateName() {
            return this.isRandom() ? null : this.mBaseSubstrate;
        }

        protected void init() {
            this.mView = OrbitIO.getCurView();
            this.setTitle("Distribute " + this.mSubstrate.getName() + " Pin Personalities");
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            this.mButtonRandom = new JRadioButton("Uniform");
            this.mButtonProximity = new JRadioButton("Proximity Based Substrate: ");
            ButtonGroup group = new ButtonGroup();
            group.add(this.mButtonRandom);
            group.add(this.mButtonProximity);
            l.add((Component)this.mButtonRandom, (GridBagConstraints)GridBagManager.LEFT);
            this.mButtonRandom.addActionListener(this.mRandom);
            l.newline();
            l.add((Component)this.mButtonProximity, (GridBagConstraints)GridBagManager.LEFT);
            this.mButtonProximity.addActionListener(this.mProximity);
            this.mSubstrateList = new JComboBox();
            l.add(this.mSubstrateList, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton btnOk = new JButton("OK");
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(this.mOk);
            JButton btnClose = new JButton("Cancel");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.initUI();
        }

        protected void initUI() {
            this.mButtonRandom.setSelected(true);
            this.mSubstrateList.removeAllItems();
            LinkedHashSet<String> elems = new LinkedHashSet<String>();
            Db db = OrbitIO.getApp().getCurrentDb();
            for (Device d : db.getObjects(Device.class)) {
                DeviceTemplate t;
                Substrate s;
                if (!d.getIsSubstrate() || (s = (t = d.getTemplate()).getSubstrate()) == this.mSubstrate) continue;
                elems.add(t.getSubstrate().getName());
            }
            this.mSubstrateList.setModel(new DefaultComboBoxModel<String>(elems.toArray(new String[elems.size()])));
        }
    }

    public static class PortPersonalityCopyDlg
    extends ADialog {
        protected AAppView mView;
        protected DeviceTemplate mToDeviceTemplate;
        protected String mFromDevTemp = null;
        protected JComboBox<DeviceTemplate> mDevTList = null;
        protected boolean mAccepted = false;
        protected ActionListener mOk = e -> {
            Object o = this.mDevTList.getSelectedItem();
            if (o == null) {
                return;
            }
            if (o instanceof DeviceTemplate) {
                this.mFromDevTemp = ((DeviceTemplate)o).getKeyStr();
            }
            if (this.mFromDevTemp == null) {
                return;
            }
            this.mAccepted = true;
            UIUtil.closeWindow((Window)((Object)this));
        };

        public static PortPersonalityCopyDlg createDialog(Window owner, String title, DeviceTemplate toDeviceTemplate) {
            PortPersonalityCopyDlg dlg = null;
            dlg = new PortPersonalityCopyDlg(owner, toDeviceTemplate);
            dlg.setTitle(title);
            dlg.init();
            return dlg;
        }

        public PortPersonalityCopyDlg(Window owner, DeviceTemplate deviceTemplate) {
            super(owner);
            this.mToDeviceTemplate = deviceTemplate;
        }

        public boolean getAccepted() {
            return this.mAccepted;
        }

        public String getFromDevTempKeyStr() {
            return this.mFromDevTemp;
        }

        protected void init() {
            this.mView = OrbitIO.getCurView();
            this.setTitle("Copy Pin Personalities");
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            JLabel label = new JLabel("From Device Template:");
            l.add((Component)label, (GridBagConstraints)GridBagManager.LEFT);
            this.mDevTList = new JComboBox<DeviceTemplate>(){
                private boolean layingOut = false;

                @Override
                public void doLayout() {
                    this.layingOut = true;
                    try {
                        super.doLayout();
                    }
                    finally {
                        this.layingOut = false;
                    }
                }

                @Override
                public Dimension getSize() {
                    Dimension dim = super.getSize();
                    if (!this.layingOut) {
                        dim.width = Math.max(dim.width, this.getPreferredSize().width);
                    }
                    return dim;
                }
            };
            l.add(this.mDevTList, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mDevTList.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean selected, boolean hasFocus) {
                    super.getListCellRendererComponent(list, val, idx, selected, hasFocus);
                    this.setText(val == null ? "<NONE>" : ((DeviceTemplate)val).getQualifiedName());
                    return this;
                }
            });
            l.newline();
            l.add("To Device Template: ", (GridBagConstraints)GridBagManager.LEFT);
            l.add(this.mToDeviceTemplate.getQualifiedName(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton btnOk = new JButton("OK");
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(this.mOk);
            JButton btnClose = new JButton("Cancel");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.initUI();
        }

        protected void initUI() {
            Db db = OrbitIO.getApp().getCurrentDb();
            LinkedHashSet<DeviceTemplate> elems = new LinkedHashSet<DeviceTemplate>();
            for (Device d : db.getObjects(Device.class)) {
                if (d.getTemplate() == this.mToDeviceTemplate || !Personality.getPersonalities((DeviceTemplate)d.getTemplate(), (Personality.Type)Personality.Type.PORT).findAny().isPresent()) continue;
                elems.add(d.getTemplate());
                this.mDevTList.addItem(d.getTemplate());
            }
            this.mDevTList.setModel(new DefaultComboBoxModel<DeviceTemplate>(elems.toArray(new DeviceTemplate[elems.size()])));
        }
    }

    public static class DbTreeObjNode
    extends ATreeNode {
        protected PersonalityMap mPersMap;

        public DbTreeObjNode(ATreeNode parent, PersonalityMap pmap) {
            super(parent);
            this.mPersMap = pmap;
        }

        public String getText() {
            DbObject dbo = this.getDbObject();
            if (dbo == null) {
                return "";
            }
            if (dbo instanceof Net) {
                return ((Net)dbo).getName();
            }
            if (dbo instanceof PinInstance) {
                StoredPath path = this.mPersMap.getPath();
                String strPath = path != null && path.getLength() > 0 ? path.getPath().stream().map(Device::getName).collect(Collectors.joining("/")) + "/" : "";
                String pinName = ((PinInstance)dbo).getName();
                return String.format("%s%s", strPath, pinName);
            }
            return dbo.getKeyStr();
        }

        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        public int getChildCount() {
            return 1;
        }

        public int getIndex(TreeNode node) {
            return -1;
        }

        public Enumeration<TreeNode> children() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        public void render(ATreeCellRenderer r) {
            super.render(r);
            Icon icon = this.getIcon();
            if (icon != null) {
                r.setIcon(icon);
            }
        }

        public Icon getIcon() {
            DbObject dbo = this.getDbObject();
            if (dbo instanceof PinInstance) {
                return DbExplorerPanel.getIconForPinTemplate(((PinInstance)dbo).getPinTemplate());
            }
            if (dbo instanceof Device) {
                return DbExplorerPanel.getIconForDevice((Device)dbo);
            }
            if (dbo instanceof Net) {
                return DbExplorerPanel.getIconForNet((Net)dbo);
            }
            return null;
        }

        public DbObject getDbObject() {
            return this.mPersMap.getObject();
        }
    }

    public static class PersonalityNode
    extends ALazyTreeNode {
        protected Personality mPersonality;
        protected Personality.Type mType;
        protected ArrayList<DbTreeObjNode> mChildNodes;
        protected Predicate<? super DbObject> mDisplayedObjectFilter;

        public PersonalityNode(ATreeNode parent, Personality p, Personality.Type t) {
            super(parent);
            this.mPersonality = p;
            this.mType = t;
            this.mDisplayedObjectFilter = this.mType == Personality.Type.PORT ? dbo -> dbo instanceof PinInstance : dbo -> true;
        }

        public Personality getPersonality() {
            return this.mPersonality;
        }

        public int getIndex(DbObject o) {
            if (this.mChildNodes == null) {
                return -1;
            }
            for (int i = 0; i < this.mChildNodes.size(); ++i) {
                if (this.mChildNodes.get(i).getDbObject() != o) continue;
                return i;
            }
            return -1;
        }

        public IterableIterator<DbTreeObjNode> getChildNodes() {
            if (this.mChildNodes == null) {
                return AEmptyItr.create();
            }
            return AIterableItr.itr(this.mChildNodes);
        }

        public DbTreeObjNode getNode(int idx) {
            if (this.mChildNodes == null) {
                return null;
            }
            return this.mChildNodes.get(idx);
        }

        public void add(PersonalityMap pmap) {
            if (pmap.getObject() == null) {
                return;
            }
            if (this.mChildNodes == null || !this.mDisplayedObjectFilter.test((DbObject)pmap.getObject())) {
                return;
            }
            DbTreeObjNode[] children = new DbTreeObjNode[]{new DbTreeObjNode((ATreeNode)this, pmap)};
            int[] indices = new int[]{this.getChildCount()};
            this.mChildNodes.add(children[0]);
            this.mTreeModel.treeNodesInserted((Object)this, this.getTreePath().getPath(), indices, (Object[])children);
        }

        public void remove(int idx) {
            if (this.mChildNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mChildNodes.get(idx)};
            this.mChildNodes.remove(idx);
            this.mTreeModel.treeNodesRemoved((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public void update(int idx) {
            if (this.mChildNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mChildNodes.get(idx)};
            this.mTreeModel.treeNodesChanged((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public ArrayList<DbTreeObjNode> populateChildren() {
            this.mChildNodes = new ArrayList();
            this.mPersonality.getPersonalityMaps().filter(pm -> this.mDisplayedObjectFilter.test((DbObject)pm.getObject())).forEach(pm -> this.mChildNodes.add(new DbTreeObjNode((ATreeNode)this, (PersonalityMap)pm)));
            return this.mChildNodes;
        }

        public String getText() {
            return this.mPersonality.getName();
        }
    }

    private static class PersonalitiesDialog
    extends DbDialog
    implements DevicePathChooser.Panel.ChooserListener {
        public static final String SETTING_SECTION = AReflection.getJavaClassName(PersonalitiesDialog.class);
        public static final String SETTING_DEV_FILTER = "DeviceTemplateFilter";
        public static final DevTFilter Setting_DevTFilter_Dflt = DevTFilter.DEFAULT;
        public static final String SETTING_DEV_DISPLAY_NAME = "DeviceTemplateDisplayName";
        public static final DevTDisplayName Setting_DevTDisplayName_Dflt = DevTDisplayName.NAME;
        protected static PersonalitiesDialog dialog = null;
        protected JComboBox<DevTFilter> mCboDevTFilter;
        protected JComboBox<DevTDisplayName> mCboShowName;
        protected RegexFilterField mFilter;
        protected Pattern mPattern = null;
        protected JList<DeviceTemplate> mLstOwners;
        protected DefaultListModel<DeviceTemplate> mLmOwners = new DefaultListModel();
        protected CContentArea mDockingArea;
        protected JLabel mLblStatus;
        protected DevicePathChooser.Panel mDevicePathPanel;
        protected JScrollPane mListPanel;
        protected JPanel mCardLayout;
        protected DevicePath mSelectedDevicePath;
        protected WindowListener mWindowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CControl dockControl = OrbitIO.getApp().getWorkspace().getDockingController();
                LinkedList sds = new LinkedList();
                LinkedList mds = new LinkedList();
                DockingUtil.getCStations(mDockingArea).flatMap(cs -> DockingUtil.getDockableDescendants((DockStation)cs.getStation())).filter(d -> d instanceof DefaultCommonDockable).map(d -> ((DefaultCommonDockable)d).getDockable()).forEach(cd -> {
                    if (cd instanceof SingleCDockable) {
                        sds.add((SingleCDockable)cd);
                    } else if (cd instanceof MultipleCDockable) {
                        mds.add((MultipleCDockable)cd);
                    }
                });
                for (SingleCDockable s : sds) {
                    s.setVisible(false);
                }
                for (MultipleCDockable m : mds) {
                    m.setVisible(false);
                }
                dockControl.removeContentArea(mDockingArea);
                this.dispose();
            }
        };

        public PersonalitiesDialog(Component owner, Db db, boolean ballMapPlannerView) {
            super(db, owner);
            this.setDefaultCloseOperation(0);
            this.mDb = db;
            this.setTitle("Personality Editor");
            GridBagManager lMain = GridBagManager.layout((JDialog)((Object)this));
            ASplitPane sp = (ASplitPane)lMain.add((Component)new ASplitPane(), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            lMain.newline();
            this.mLblStatus = lMain.add("", (GridBagConstraints)GridBagManager.FILLX);
            JButton btnClose = (JButton)lMain.add((Component)new JButton("Close"));
            String SHOW_DEVICE_PATH = "Show device path";
            String SHOW_LIST = "Show list";
            JPanel pnlLeft = new JPanel();
            sp.setLeftComponent(pnlLeft);
            GridBagManager lLeft = GridBagManager.layout((Container)pnlLeft);
            lLeft.add("Type:");
            this.mCboDevTFilter = (JComboBox)lLeft.add(new JComboBox<DevTFilter>(DevTFilter.values()));
            this.mCboDevTFilter.addActionListener(e -> this.populateDeviceTemplates());
            this.mCboDevTFilter.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean isSel, boolean hasFocus) {
                    super.getListCellRendererComponent(list, val, idx, isSel, hasFocus);
                    if (val instanceof DevTFilter) {
                        this.setToolTipText(((DevTFilter)((Object)val)).getDesc());
                    } else {
                        this.setToolTipText(null);
                    }
                    return this;
                }
            });
            lLeft.add("Show:");
            this.mCboShowName = (JComboBox)lLeft.add(new JComboBox<DevTDisplayName>(DevTDisplayName.values()));
            this.mCboShowName.addActionListener(e -> {
                CardLayout cl = (CardLayout)this.mCardLayout.getLayout();
                if (this.mCboShowName.getSelectedItem().equals(DevTDisplayName.DEVICEPATH)) {
                    cl.show(this.mCardLayout, "Show device path");
                    this.mFilter.setEnabled(false);
                } else {
                    cl.show(this.mCardLayout, "Show list");
                    this.mFilter.setEnabled(true);
                    this.mLstOwners.repaint();
                }
            });
            this.mCboShowName.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean isSel, boolean hasFocus) {
                    super.getListCellRendererComponent(list, (Object)null, idx, isSel, hasFocus);
                    if (val instanceof DevTDisplayName) {
                        this.setText(((DevTDisplayName)val).getDesc());
                    }
                    return this;
                }
            });
            lLeft.newline();
            lLeft.add("Filter:");
            this.mFilter = new RegexFilterField(this::populateDeviceTemplates);
            lLeft.add((Component)this.mFilter, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            lLeft.newline();
            this.mLstOwners = new JList<DeviceTemplate>(this.mLmOwners);
            this.mDevicePathPanel = new DevicePathChooser.Panel(this.mDb);
            this.mDevicePathPanel.addChooserListener(this);
            this.mListPanel = new JScrollPane(this.mLstOwners);
            this.mCardLayout = new JPanel(new CardLayout());
            this.mCardLayout.add((Component)this.mDevicePathPanel, "Show device path");
            this.mCardLayout.add(this.mLstOwners, "Show list");
            lLeft.add((Component)this.mCardLayout, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstOwners.setSelectionMode(0);
            this.mLstOwners.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean selected, boolean hasFocus) {
                    super.getListCellRendererComponent(list, (Object)null, index, selected, hasFocus);
                    if (value instanceof DeviceTemplate) {
                        DeviceTemplate devT = (DeviceTemplate)value;
                        this.setIcon(DbExplorerPanel.getIconForTemplate(devT));
                        this.setText(this.getDevTDisplayName(devT));
                    }
                    return this;
                }
            });
            this.mLstOwners.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        mSelectedDevicePath = null;
                        this.openOrActivateEditor(e);
                    }
                }
            });
            CControl dockControl = OrbitIO.getApp().getWorkspace().getDockingController();
            this.mDockingArea = dockControl.createContentArea(String.format("%s:%d", PersonalitiesDialog.class.getName(), this.mDb.getId()));
            this.mDockingArea.setPreferredSize(new Dimension(250, 400));
            sp.setRightComponent((Component)this.mDockingArea);
            this.mCboDevTFilter.setSelectedItem(Settings.get((String)SETTING_SECTION, (String)SETTING_DEV_FILTER, (Object)((Object)Setting_DevTFilter_Dflt)));
            this.mCboShowName.setSelectedItem(Settings.get((String)SETTING_SECTION, (String)SETTING_DEV_DISPLAY_NAME, (Object)Setting_DevTDisplayName_Dflt));
            UIUtil.enableEscCloseMinSize((Window)((Object)this), (AbstractButton)btnClose);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.populateDeviceTemplates();
            this.setStatus("Double-click a template to edit its Personalities", new Object[0]);
            this.setVisible(true);
            if (ballMapPlannerView) {
                DeviceTemplate dt = null;
                for (DevicePath dp : OrbitIO.getCurDesign().getDescendantDevices()) {
                    if (!dp.getLast().isPackage()) continue;
                    dt = dp.getDeviceTemplate();
                    break;
                }
                this.ActivateEditor(dt);
            }
        }

        @Override
        public void pathSelected(DevicePath p) {
        }

        @Override
        public void pathActivated(DevicePath p) {
            this.mSelectedDevicePath = this.mDevicePathPanel.getSelectedPath();
            DeviceTemplate devT = this.mSelectedDevicePath.getDeviceTemplate();
            this.openOrActivateEditor(devT, null);
        }

        public void addNotify() {
            super.addNotify();
            this.addWindowListener(this.mWindowListener);
        }

        public void removeNotify() {
            Settings settings = Settings.getSettings((String)SETTING_SECTION);
            settings.putSetting(SETTING_DEV_FILTER, this.mCboDevTFilter.getSelectedItem());
            settings.putSetting(SETTING_DEV_DISPLAY_NAME, this.mCboShowName.getSelectedItem());
            settings.save();
            this.removeWindowListener(this.mWindowListener);
            super.removeNotify();
        }

        protected boolean isPersEditor(Dockable d) {
            return d instanceof DefaultCommonDockable && ((DefaultCommonDockable)d).getDockable() instanceof PersonalitiesEditor;
        }

        protected void closeTabIfNecessary(InputEvent e) {
            Settings userPrefs = Settings.getSettings((String)"UserPreferences");
            boolean enableTabs = (Boolean)userPrefs.getSetting("EnableTabsInPersonalityEditor", (Object)true);
            if (e != null && e.isShiftDown()) {
                boolean bl = enableTabs = !enableTabs;
            }
            if (!enableTabs) {
                Object[] cds;
                for (Object cd : cds = DockingUtil.getCStations(this.mDockingArea).flatMap(cs -> DockingUtil.getDockableDescendants((DockStation)cs.getStation())).filter(d -> d instanceof DefaultCommonDockable).map(d -> ((DefaultCommonDockable)d).getDockable()).toArray()) {
                    ((CDockable)cd).setVisible(false);
                }
            }
        }

        protected String getDevTDisplayName(DeviceTemplate devT) {
            return ((DevTDisplayName)this.mCboShowName.getSelectedItem()).apply(devT);
        }

        protected boolean matchesFilter(DeviceTemplate devT) {
            return this.mPattern == null || this.mPattern.matcher(this.getDevTDisplayName(devT)).matches();
        }

        protected void populateDeviceTemplates(Pattern pattern) {
            if (AUtil.equals((Object)pattern, (Object)this.mPattern)) {
                return;
            }
            this.mPattern = pattern;
            this.populateDeviceTemplates();
        }

        protected void populateDeviceTemplates() {
            DevTFilter showOpt = (DevTFilter)((Object)this.mCboDevTFilter.getSelectedItem());
            this.mLmOwners.clear();
            showOpt.getDeviceTemplates(this.mDb).filter(this::matchesFilter).sorted((a, b) -> AAlphaNumComp.comp((Object)this.getDevTDisplayName((DeviceTemplate)a), (Object)this.getDevTDisplayName((DeviceTemplate)b))).forEach(devT -> this.mLmOwners.addElement((DeviceTemplate)devT));
        }

        protected void setStatus(String fmt, Object ... args) {
            this.mLblStatus.setText(String.format(fmt, args));
        }

        protected PersonalitiesEditor openOrActivateEditor(InputEvent e) {
            DeviceTemplate devT = this.mLstOwners.getSelectedValue();
            if (devT == null) {
                return null;
            }
            return this.openOrActivateEditor(devT, e);
        }

        protected PersonalitiesEditor openOrActivateEditor(DeviceTemplate devT, InputEvent e) {
            this.closeTabIfNecessary(e);
            PersonalitiesEditor pe = PersonalityUI.getPersonalitiesEditor(devT).orElseGet(() -> this.createPersonalityEditor(devT));
            pe.toFront();
            return pe;
        }

        protected PersonalitiesEditor ActivateEditor(DeviceTemplate devT) {
            if (devT == null) {
                return null;
            }
            PersonalitiesEditor pe = PersonalityUI.getPersonalitiesEditor(devT).orElseGet(() -> this.createPersonalityEditor(devT));
            pe.toFront();
            return pe;
        }

        protected PersonalitiesEditor createPersonalityEditor(final DeviceTemplate devT) {
            assert (!PersonalityUI.getPersonalitiesEditor(devT).isPresent());
            final PersonalitiesEditor pe = new PersonalitiesEditor(devT, this.getDevTDisplayName(devT));
            PersonalityUI.addPersonalitiesEditor(devT, pe);
            this.mDockingArea.getControl().addDockable((SingleCDockable)pe);
            pe.setDefaultLocation(ExtendedMode.NORMALIZED, (CLocation)CLocation.normalized((CGridArea)this.mDockingArea.getCenterArea()));
            pe.setLocation((CLocation)CLocation.normalized((CGridArea)this.mDockingArea.getCenterArea()));
            pe.setVisible(true);
            pe.addVetoClosingListener(new CVetoClosingListener(){

                public void closing(CVetoClosingEvent event) {
                }

                public void closed(CVetoClosingEvent event) {
                    if (!pe.getHidden()) {
                        PersonalityUI.removePersonalitiesEditor(devT);
                        mDockingArea.getControl().removeDockable((SingleCDockable)pe);
                        pe.removeVetoClosingListener(this);
                    }
                }
            });
            return pe;
        }
    }

    private static enum DevTDisplayName implements Function<DeviceTemplate, String>
    {
        NAME("Template Name", devT -> devT.getName()),
        KEY("Substrate: Template", devT -> String.format("%s%s", devT.getSubstrate() == null ? "" : devT.getSubstrate().getName() + ": ", devT.getName())),
        DEVICE("Representative Device", devT -> {
            int count = devT.getDeviceInstanceCount();
            if (count == 0) {
                return String.format("Template: %s (0 devices)", KEY.apply((DeviceTemplate)devT));
            }
            if (count == 1) {
                return devT.getAnInstance().getName();
            }
            return String.format("%s (+%d)", devT.getAnInstance().getName(), count - 1);
        }),
        DEVICEPATH("DevicePath", devT -> devT.getName());

        String mDesc;
        Function<DeviceTemplate, String> mGetUserText;

        private DevTDisplayName(String desc, Function<DeviceTemplate, String> getUserText) {
            this.mDesc = desc;
            this.mGetUserText = getUserText;
        }

        public String getDesc() {
            return this.mDesc;
        }

        @Override
        public String apply(DeviceTemplate devT) {
            return this.mGetUserText.apply(devT);
        }
    }

    private static enum DevTFilter {
        DEFAULT(DEFAULT_DEVICETEMPLATE_TYPES_DESC, devT -> DefaultDeviceTemplateTypes.contains(devT.getType()) || Personality.getPersonalities((DeviceTemplate)devT).iterator().hasNext()),
        SUBSTRATES("Substrate-type templates (Board, Package, Die, Interposer)", devT -> devT.amIASubstrate()),
        ALL("All templates", devT -> true);

        String mDesc;
        Predicate<DeviceTemplate> mPredicate;

        private DevTFilter(String desc, Predicate<DeviceTemplate> predicate) {
            this.mDesc = desc;
            this.mPredicate = predicate;
        }

        public String getDesc() {
            return this.mDesc;
        }

        public Stream<DeviceTemplate> getDeviceTemplates(Db db) {
            return db.getObjects(DeviceTemplate.class).stream().filter(this.mPredicate);
        }
    }
}

