/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.PinMapExportUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class PinMapConfigurationUI {
    public static Action getImportAction() {
        return new AbstractAction(UiType.IMPORT.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinMapConfigurationUI.importShowUI();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static Action getExportAction() {
        return new AbstractAction(UiType.EXPORT.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinMapConfigurationUI.exportShowUI();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static Action getCompareAction() {
        return new AbstractAction(UiType.COMPARE.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinMapConfigurationUI.compareShowUI();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void importShowUI() {
        AFileChooser fc = new AFileChooser();
        fc.addChoosableFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        ImportOptionsPanel exportOptionsPnl = new ImportOptionsPanel();
        fc.setAccessory((JComponent)exportOptionsPnl);
        fc.setDialogTitle(UiType.IMPORT.getName());
        if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File fRuleFile = fc.getSelectedFile();
        if (fRuleFile == null) {
            return;
        }
        Cp.exec((String)"com.sigrity.orbit.automation.pinMap.PinMapConfiguration.importPinMapCsv(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)fRuleFile)});
    }

    public static void exportShowUI() {
        PinMapExportUI ui = new PinMapExportUI();
        ui.showUI();
    }

    public static void compareShowUI() {
        AFileChooser fc = new AFileChooser();
        fc.addChoosableFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle(UiType.COMPARE.getName());
        if (fc.showDialog((Component)OrbitIO.getMainWindow(), "Compare PinMaps") != 0) {
            return;
        }
        File fRuleFile = fc.getSelectedFile();
        if (fRuleFile == null) {
            return;
        }
        Cp.exec((String)"com.sigrity.orbit.automation.pinMap.PinMapConfiguration.comparePinMapCsv(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)fRuleFile)});
    }

    protected static class ImportOptionsPanel
    extends JPanel {
        protected JCheckBox createNetMaps;

        public ImportOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Import options"));
            GridBagManager l = new GridBagManager((Container)this);
            this.createNetMaps = (JCheckBox)l.add((Component)new JCheckBox("Create NetMaps"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.createNetMaps.setSelected(true);
            l.newline();
            l.addFillY();
        }

        public boolean createNetMaps() {
            return this.createNetMaps.isSelected();
        }
    }

    public static enum UiType {
        IMPORT("Import Pin Mapping CSV"),
        EXPORT("Export Pin Mapping CSV"),
        COMPARE("Compare Pin Mapping");

        private String typeStr;

        private UiType(String typeStr) {
            this.typeStr = typeStr;
        }

        public String getName() {
            return this.typeStr;
        }
    }
}

