/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.PinMapConfigurationUI;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class PinMapExportUI {
    List<ContactLayer> mContactLayers;

    public PinMapExportUI() {
        this(null);
    }

    public PinMapExportUI(List<ContactLayer> contactLayers) {
        this.mContactLayers = contactLayers;
    }

    public void showUI() {
        AFileChooser fc = new AFileChooser();
        fc.addChoosableFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle(PinMapConfigurationUI.UiType.EXPORT.getName());
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File fRuleFile = fc.getSelectedFile();
        if (fRuleFile == null) {
            return;
        }
        String fileName = fRuleFile.getPath();
        if (this.mContactLayers == null) {
            this.exportAllPinMaps(fileName);
        } else {
            this.cpExportPinMapOnContactLayers(fileName);
        }
    }

    private void exportAllPinMaps(String fileName) {
        Cp.exec((String)"com.sigrity.orbit.automation.pinMap.PinMapConfiguration.exportPinMapCsv(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)fileName)});
    }

    private void cpExportPinMapOnContactLayers(String fileName) {
        Cp.exec((String)"unset(\"_exportPinMap\");", (Object[])new Object[0]);
        Cp.exec((String)"_exportPinMap = new com.sigrity.orbit.automation.pinMap.ExportPinMap(curDb());", (Object[])new Object[0]);
        for (ContactLayer contactLayer : this.mContactLayers) {
            String contactLayerStr = String.format("curDb().getByKeyStr(ContactLayer.class, \"%s\")", contactLayer.getKeyStr());
            Cp.exec((String)"_exportPinMap.addContactLayer(%s);", (Object[])new Object[]{contactLayerStr});
        }
        Cp.exec((String)"_exportPinMap.exportPinMapCsv(\"%s\")", (Object[])new Object[]{fileName});
        Cp.exec((String)"unset(\"_exportPinMap\");", (Object[])new Object[0]);
    }
}

