/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapCheckOptionUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class PinMapGeneratorUI
extends DbDialog {
    protected PinMapOptionsPanel mPinMapOptionsPnl;
    protected PinMapCheckOptionUI.CheckingOptionsPanel mCheckingOptionsPanel;
    protected ActionListener mOkHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            this.generatePinMaps();
            this.checkPinMaps();
            UIUtil.closeWindow((Window)((Object)PinMapGeneratorUI.this));
            ALog.logInfo((String)"Generating port mapping from physical contact complete.");
        }

        protected void generatePinMaps() {
            PinMapCheckOptionUI.cpGeneratePinMaps(PinMapGeneratorUI.this.mPinMapOptionsPnl.createNetMap());
        }

        protected void checkPinMaps() {
            PinMapCheckOptionUI.cpExecuteChecking(PinMapGeneratorUI.this.mDb, PinMapGeneratorUI.this.mCheckingOptionsPanel);
        }
    };

    public static Action getAction() {
        return new AbstractAction("Generate PinMaps"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinMapGeneratorUI.showUI(OrbitIO.getMainWindow());
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showUI(Window owner) {
        PinMapGeneratorUI dlg = new PinMapGeneratorUI(owner);
        dlg.setVisible(true);
    }

    public PinMapGeneratorUI(Window owner) {
        super(OrbitIO.getApp().getCurrentDb(), (Component)owner, "Generate PinMaps", Dialog.ModalityType.DOCUMENT_MODAL);
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        this.mPinMapOptionsPnl = new PinMapOptionsPanel();
        l.add((Component)this.mPinMapOptionsPnl, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        this.mCheckingOptionsPanel = new PinMapCheckOptionUI.CheckingOptionsPanel(this.mDb, (Window)((Object)this));
        l.add((Component)this.mCheckingOptionsPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        btnOk.addActionListener(this.mOkHandler);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    protected static class PinMapOptionsPanel
    extends JPanel {
        protected JCheckBox mCreateNetMap;

        public PinMapOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("PinMap Options"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mCreateNetMap = (JCheckBox)l.add((Component)new JCheckBox("Create NetMaps and parent nets"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mCreateNetMap.setSelected(true);
            this.mCreateNetMap.setToolTipText("Create a net mapping for two contact pins.");
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public boolean createNetMap() {
            return this.mCreateNetMap.isSelected();
        }
    }
}

