/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.APair;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.LinkedList;
import javax.swing.Icon;

public class PinTemplateIcon
implements Icon {
    protected static final Color[] SampleColors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.BLACK};
    protected int mWidth;
    protected int mHeight;
    protected PadTemplate mPadTemplate;
    protected Color mBorderColor;
    protected Rectangle screenRect;
    protected AffineTransform xForm = new AffineTransform();
    protected Substrate mSubstrate;

    public PinTemplateIcon(Substrate s, PadTemplate padTemplate, int width, int height) {
        this.mSubstrate = s;
        this.mWidth = width;
        this.mHeight = height;
        this.mPadTemplate = padTemplate;
        this.screenRect = new Rectangle(0, 0, width, height);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Shape oldClip = g.getClip();
        g.clipRect(x, y, this.mWidth, this.mHeight);
        g.setColor(Color.WHITE);
        g.fillRect(x + 1, y + 1, this.mWidth - 2, this.mHeight - 2);
        if (this.mBorderColor != null) {
            g.setColor(this.mBorderColor);
            g.drawRect(x, y, this.mWidth - 1, this.mHeight - 1);
        }
        ARect bounds = this.mPadTemplate.getBounds(null);
        LinkedList<APair> layerShapes = new LinkedList<APair>();
        for (LayerShape ls : this.mPadTemplate.getLayerShapes()) {
            ARect r = ls.getGeom().getBounds();
            layerShapes.add(new APair((Object)ls.getLayer(), (Object)r));
        }
        if (bounds == null) {
            return;
        }
        bounds.expand(0.1);
        this.setXForm(bounds);
        ViewColorizer colorizer = OrbitIO.getCurColorizer();
        DevicePath path = this.mSubstrate.getADevicePathUsing();
        for (APair ls : layerShapes) {
            APatternColor colorT = colorizer.getColor(path, (Layer)ls.first);
            if (colorT != null) {
                g.setColor(colorT.getColor());
            }
            ARect screenRect = (ARect)ls.second;
            screenRect = screenRect.transform(this.xForm).getBounds();
            Rectangle r = new Rectangle((int)screenRect.getLL().getX(), (int)screenRect.getLL().getY(), (int)screenRect.width(), (int)screenRect.height());
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        g.setClip(oldClip);
    }

    public void setXForm(ARect bounds) {
        double sx = (double)this.screenRect.width / (double)bounds.width();
        double sy = (double)this.screenRect.height / (double)bounds.height();
        double m = Math.abs(sx) < Math.abs(sy) ? sx : sy;
        double aX = (double)this.screenRect.x + (double)this.screenRect.width / 2.0 - (double)bounds.centerX() * m;
        double aY = (double)this.screenRect.y + (double)this.screenRect.height / 2.0 - (double)bounds.centerY() * m;
        this.xForm = AffineTransform.getScaleInstance(m, m);
        this.xForm.preConcatenate(AffineTransform.getTranslateInstance(aX, aY));
    }

    @Override
    public int getIconWidth() {
        return this.mWidth;
    }

    @Override
    public int getIconHeight() {
        return this.mHeight;
    }

    public void setBorderColor(Color c) {
        this.mBorderColor = c;
    }
}

