/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.dbui.render.TemplateListRenderer;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PinToDeviceUI
extends DbDialog {
    private PinSelectionPanel mPinSelectionPanel;
    private DevicePinPanel mDevicePinPanel;
    private ActionListener mOkHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"_pinToDevice = new com.sigrity.orbit.factory.PinToDevice()", (Object[])new Object[0]);
            Cp.exec((String)"_pinToDevice.setJustSelected(%b)", (Object[])new Object[]{PinToDeviceUI.this.mPinSelectionPanel.justSelectedPins()});
            if (PinToDeviceUI.this.mDevicePinPanel.hasInstNamePrefix()) {
                Cp.exec((String)"_pinToDevice.setInstNamePrefix(\"%s\")", (Object[])new Object[]{PinToDeviceUI.this.mDevicePinPanel.getInstNamePrefix()});
            }
            if (PinToDeviceUI.this.mDevicePinPanel.hasInstRotation()) {
                Cp.exec((String)"_pinToDevice.setInstRotation(%df)", (Object[])new Object[]{PinToDeviceUI.this.mDevicePinPanel.getInstRotation()});
            }
            if (PinToDeviceUI.this.mDevicePinPanel.isUseExistTemplate()) {
                Cp.exec((String)"_pinToDevice.loadDeviceByKeyStr(\"%s\")", (Object[])new Object[]{PinToDeviceUI.this.mDevicePinPanel.getPinDevT().getKeyStr()});
            } else {
                Cp.exec((String)"_pinToDevice.setPinName(\"%s\")", (Object[])new Object[]{PinToDeviceUI.this.mDevicePinPanel.getPinName()});
                Cp.exec((String)"_pinToDevice.setNetName(\"%s\")", (Object[])new Object[]{PinToDeviceUI.this.mDevicePinPanel.getNetName()});
            }
            Cp.exec((String)"_pinToDevice.setOriginAtLL(%b)", (Object[])new Object[]{!PinToDeviceUI.this.mDevicePinPanel.isOriginAtCenter()});
            Cp.exec((String)"_pinToDevice.pinsToDevices()", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_pinToDevice\");", (Object[])new Object[0]);
            UIUtil.closeWindow((Window)((Object)PinToDeviceUI.this));
        }
    };

    public static Action getAction() {
        return new AbstractAction("Pin to device"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinToDeviceUI.showUI(OrbitIO.getCurDb(), OrbitIO.getMainWindow());
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showUI(Db db, Window owner) {
        PinToDeviceUI dlg = new PinToDeviceUI(db, owner);
        dlg.setVisible(true);
    }

    private PinToDeviceUI(Db db, Window owner) {
        super(db, (Component)owner, "Pin To Device", Dialog.ModalityType.DOCUMENT_MODAL);
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        this.mPinSelectionPanel = new PinSelectionPanel();
        l.add((Component)this.mPinSelectionPanel, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.mDevicePinPanel = new DevicePinPanel(this.mDb);
        l.add((Component)this.mDevicePinPanel, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        btnOk.addActionListener(this.mOkHandler);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    private static class DevicePinTemplatePanel
    extends JPanel {
        private Db db;
        private AButtonGroup devicePinTemplateGroup = new AButtonGroup();
        private JRadioButton useExistButton;
        private JComboBox<DeviceTemplate> pinDevTComboBox;
        private JRadioButton createNewButton;
        private NewTemplatePanel newTemplatePanel;
        JRadioButton ctrButton;
        JRadioButton llButton;

        public DevicePinTemplatePanel(Db db) {
            this.db = db;
            this.setBorder(BorderFactory.createTitledBorder("Template"));
            GridBagManager l = new GridBagManager((Container)this);
            JPanel useExistPanel = new JPanel();
            this.useExistButton = new JRadioButton("Use existing:");
            useExistPanel.add((Component)this.useExistButton, GridBagManager.LEFT.noInsets());
            this.pinDevTComboBox = new JComboBox();
            this.pinDevTComboBox.setRenderer(new TemplateListRenderer());
            this.loadPinDeviceTemplate();
            useExistPanel.add(this.pinDevTComboBox, GridBagManager.LEFT.noInsets());
            l.add((Component)useExistPanel, (GridBagConstraints)GridBagManager.LEFT.noInsets());
            l.newline();
            this.createNewButton = new JRadioButton("Create from pad");
            this.createNewButton.setSelected(true);
            l.add((Component)this.createNewButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.newTemplatePanel = new NewTemplatePanel();
            l.add((Component)this.newTemplatePanel, (GridBagConstraints)GridBagManager.FILLX_REMAINX.insetTop(0).indent().indent());
            l.newline();
            this.devicePinTemplateGroup.add(this.useExistButton);
            this.devicePinTemplateGroup.add(this.createNewButton);
            JPanel pnlOrigin = l.push("Origin:", (GridBagConstraints)GridBagManager.FILLX);
            GridBagManager ll = new GridBagManager((Container)pnlOrigin);
            this.ctrButton = new JRadioButton("Center");
            this.ctrButton.setSelected(true);
            ll.addNl((Component)this.ctrButton, (GridBagConstraints)GridBagManager.FILLX);
            this.llButton = new JRadioButton("Lower left corner");
            ll.addNl((Component)this.llButton, (GridBagConstraints)GridBagManager.FILLX);
            l.popNl();
            AButtonGroup originGroup = new AButtonGroup();
            originGroup.add(this.llButton);
            originGroup.add(this.ctrButton);
            ActionListener createNewBtnListener = e -> {
                this.newTemplatePanel.setEnabled(this.createNewButton.isSelected());
                this.pinDevTComboBox.setEnabled(!this.createNewButton.isSelected());
            };
            createNewBtnListener.actionPerformed(null);
            this.createNewButton.addActionListener(createNewBtnListener);
            ActionListener useExistBtnListener = e -> {
                this.newTemplatePanel.setEnabled(!this.useExistButton.isSelected());
                this.pinDevTComboBox.setEnabled(this.useExistButton.isSelected());
            };
            useExistBtnListener.actionPerformed(null);
            this.useExistButton.addActionListener(useExistBtnListener);
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public boolean isUseExistTemplate() {
            return this.useExistButton.isSelected();
        }

        public boolean isOriginAtCenter() {
            return this.ctrButton.isSelected();
        }

        public DeviceTemplate getPinDevT() {
            return (DeviceTemplate)this.pinDevTComboBox.getSelectedItem();
        }

        public String getPinName() {
            return this.newTemplatePanel.getPinName();
        }

        public String getNetName() {
            return this.newTemplatePanel.getNetName();
        }

        private void loadPinDeviceTemplate() {
            for (DeviceTemplate devT : this.db.getObjects(DeviceTemplate.class)) {
                if (!devT.amIAPin()) continue;
                this.pinDevTComboBox.addItem(devT);
            }
        }

        private static class NewTemplatePanel
        extends JPanel {
            private JTextField pinNameTextField;
            private JTextField netNameTextField;

            public NewTemplatePanel() {
                GridBagManager l = new GridBagManager((Container)this);
                JLabel pinNameLabel = new JLabel("Pin Name:");
                l.add((Component)pinNameLabel, (GridBagConstraints)GridBagManager.LEFT);
                this.pinNameTextField = new JTextField("Pin", 10);
                l.add((Component)this.pinNameTextField, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
                l.newline();
                JLabel netNameLabel = new JLabel("Net Name:");
                l.add((Component)netNameLabel, (GridBagConstraints)GridBagManager.LEFT);
                this.netNameTextField = new JTextField("Pin", 10);
                l.add((Component)this.netNameTextField, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
                l.newline();
                l.addFillX();
                this.setMinimumSize(this.getPreferredSize());
            }

            @Override
            public void setEnabled(boolean b) {
                this.pinNameTextField.setEnabled(b);
                this.netNameTextField.setEnabled(b);
            }

            public String getPinName() {
                return this.pinNameTextField.getText();
            }

            public String getNetName() {
                return this.netNameTextField.getText();
            }
        }
    }

    private static class DevicePinInstancePanel
    extends JPanel {
        private JCheckBox namePrefixCheckBox;
        private JTextField namePrefixTextField;
        private JCheckBox rotationCheckBox;
        private JComboBox<Integer> rotationComboBox;

        public DevicePinInstancePanel() {
            this.setBorder(BorderFactory.createTitledBorder("Instance"));
            GridBagManager l = new GridBagManager((Container)this);
            this.namePrefixCheckBox = new JCheckBox("Name prefix:");
            this.namePrefixTextField = new JTextField("bump_", 10);
            l.add((Component)this.namePrefixCheckBox, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.namePrefixTextField, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            this.rotationCheckBox = new JCheckBox("Set rotation");
            this.rotationComboBox = new JComboBox();
            this.rotationComboBox.addItem(0);
            this.rotationComboBox.addItem(90);
            this.rotationComboBox.addItem(180);
            this.rotationComboBox.addItem(270);
            l.add((Component)this.rotationCheckBox, (GridBagConstraints)GridBagManager.LEFT);
            l.add(this.rotationComboBox, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            ActionListener useExistBtnListener = e -> this.namePrefixTextField.setEnabled(this.namePrefixCheckBox.isSelected());
            useExistBtnListener.actionPerformed(null);
            this.namePrefixCheckBox.addActionListener(useExistBtnListener);
            ActionListener setRotationListener = e -> this.rotationComboBox.setEnabled(this.rotationCheckBox.isSelected());
            setRotationListener.actionPerformed(null);
            this.rotationCheckBox.addActionListener(setRotationListener);
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public boolean hasInstNamePrefix() {
            return this.namePrefixCheckBox.isSelected();
        }

        public String getInstNamePrefix() {
            return this.namePrefixTextField.getText();
        }

        public boolean hasInstRotation() {
            return this.rotationCheckBox.isSelected();
        }

        public int getInstRotation() {
            return (Integer)this.rotationComboBox.getSelectedItem();
        }
    }

    private static class DevicePinPanel
    extends JPanel {
        private DevicePinInstancePanel mDevicePinInstancePanel;
        private DevicePinTemplatePanel mDevicePinTemplatePanel;

        public DevicePinPanel(Db db) {
            this.setBorder(BorderFactory.createTitledBorder("Device Pin"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mDevicePinInstancePanel = new DevicePinInstancePanel();
            l.add((Component)this.mDevicePinInstancePanel, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            this.mDevicePinTemplatePanel = new DevicePinTemplatePanel(db);
            l.add((Component)this.mDevicePinTemplatePanel, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public boolean isUseExistTemplate() {
            return this.mDevicePinTemplatePanel.isUseExistTemplate();
        }

        public boolean isOriginAtCenter() {
            return this.mDevicePinTemplatePanel.isOriginAtCenter();
        }

        public DeviceTemplate getPinDevT() {
            return this.mDevicePinTemplatePanel.getPinDevT();
        }

        public boolean hasInstNamePrefix() {
            return this.mDevicePinInstancePanel.hasInstNamePrefix();
        }

        public String getInstNamePrefix() {
            return this.mDevicePinInstancePanel.getInstNamePrefix();
        }

        public boolean hasInstRotation() {
            return this.mDevicePinInstancePanel.hasInstRotation();
        }

        public int getInstRotation() {
            return this.mDevicePinInstancePanel.getInstRotation();
        }

        public String getPinName() {
            return this.mDevicePinTemplatePanel.getPinName();
        }

        public String getNetName() {
            return this.mDevicePinTemplatePanel.getNetName();
        }
    }

    private static class PinSelectionPanel
    extends JPanel {
        private AButtonGroup pinSelectionGroup = new AButtonGroup();
        private JRadioButton allPinsButton;
        private JRadioButton selectedPinsButton;

        public PinSelectionPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Pin Selection"));
            GridBagManager l = new GridBagManager((Container)this);
            this.allPinsButton = new JRadioButton("All pins");
            this.allPinsButton.setSelected(true);
            l.add((Component)this.allPinsButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.selectedPinsButton = new JRadioButton("Selected pins");
            l.add((Component)this.selectedPinsButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.pinSelectionGroup.add(this.allPinsButton);
            this.pinSelectionGroup.add(this.selectedPinsButton);
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public boolean justSelectedPins() {
            return this.selectedPinsButton.isSelected();
        }
    }
}

