/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ActionOnPlaceableItem;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.automation.AutoBundleNetUI;
import com.sigrity.orbit.ui.AssignPwrGndDlg;
import com.sigrity.orbit.ui.CreateFanoutBumpsUI;
import com.sigrity.orbit.ui.CreateFanoutsUI;
import com.sigrity.orbit.ui.OrbitGuiObjectActionRegistry;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.SetPinNetUI;
import com.sigrity.orbit.ui.SwapPinsUI;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class PinUI {
    public static final OrbitGuiShortcutActionRegistry.ViewActionFactory ViewActionFactory = new OrbitGuiShortcutActionRegistry.ViewActionFactory(){

        @Override
        public Iterator<Object> getActions(Db db, Selection selection, APoint2D worldLoc) {
            int selPinTemplateCnt;
            OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            DbClass pinInstClass = db.getDbClass(PinInstance.class);
            int selPinCount = selection.getCount(pinInstClass);
            int selItemCount = (int)selection.getCountTotal();
            HierInst bestPin = null;
            if (worldLoc != null) {
                ARect worldPtRect = new ARect(worldLoc, worldLoc);
                bestPin = Selectors.DevicePortSelector.getBestAt((Db)db, (ARect)worldPtRect);
            }
            if (bestPin != null && bestPin.getPath() == null) {
                bestPin = null;
            }
            LinkedList<Object> actions = new LinkedList<Object>();
            if (selItemCount == 0 && bestPin != null) {
                DevicePath path = (DevicePath)bestPin.first;
                PinInstance pin = (PinInstance)bestPin.second;
                PinTemplate pinT = pin.getPinTemplate();
                for (JMenuItem mi : oar.getJMenuItems(new HierInst(bestPin.getPath(), (DbObject)((PinInstance)bestPin.getDbObject()).getPinTemplate()))) {
                    if (!mi.getText().equals("Set Pin's Net...")) continue;
                    String text = String.format("Set %s %s's Net...", PinUI.getTextForPin((PinInstance)bestPin.getDbObject()), ((PinInstance)bestPin.getDbObject()).getName());
                    mi.setText(text);
                    actions.add(mi);
                }
                actions.add(new OrbitGuiObjectActionRegistry.ActionSelectNetOfPort(path, pinT));
            }
            List<PinInstance> selPinInsts = selection.get(PinInstance.class).stream().collect(Collectors.toList());
            String pinText = PinUI.getTextForPinInstanceList(selPinInsts);
            if (selPinCount > 0) {
                if (selPinCount == 2) {
                    Action a = SwapPinsUI.getSwapSelectedPinsAction();
                    a.putValue("Name", "Swap Nets");
                    actions.add(a);
                }
                for (Action a : AUtil.arrayList(SetPinNetUI.ActionFactorySelection.getActions(selection, null))) {
                    actions.add(a);
                }
                actions.add(new ActionOnPlaceableItem(selection, selPinCount, "Pin", ActionOnPlaceableItem.ACTION.DELETE_SEL, false, "", String.format("Delete Selected %s", pinText)));
                if (selection.getSelectedHierInsts(PinInstance.class).stream().map(HierInst::getPath).distinct().limit(2L).count() == 1L) {
                    actions.add(new ActionOnPlaceableItem(selection, pinInstClass, ActionOnPlaceableItem.ACTION.COPY, String.format("Copy %s...", pinText)));
                    actions.add(new ActionOnPlaceableItem(selection, selPinCount, "Pin", ActionOnPlaceableItem.ACTION.MOVE_SEL_INT, true, "true,false", String.format("Copy %s Interactively", pinText)));
                    actions.add(new ActionOnPlaceableItem(selection, pinInstClass, ActionOnPlaceableItem.ACTION.MOVE, String.format("Move %s...", pinText)));
                    actions.add(new ActionOnPlaceableItem(selection, selPinCount, "Pin", ActionOnPlaceableItem.ACTION.MOVE_SEL_INT, true, "false,false", String.format("Move %s Interactively", pinText)));
                }
                actions.add(new ActionShowMeSelectedPorts(selection, pinText));
                JMenuItem fanoutViaMenueitem = new JMenuItem(new ActionFanoutVias(selection));
                actions.add(fanoutViaMenueitem);
                JMenuItem fanoutBumpMenueitem = new JMenuItem(new ActionFanoutBumps(selection, worldLoc));
                actions.add(fanoutBumpMenueitem);
            }
            if (selPinCount > 0) {
                Selection.SelSet selPins;
                ActionShowRatsOnPin ratAction = new ActionShowRatsOnPin(selection);
                JMenuItem showRatsOnN = new JMenuItem(ratAction);
                showRatsOnN.setText(String.format("Show Connections on (%d)", selPinCount));
                actions.add(showRatsOnN);
                JMenuItem autoBundle = new JMenuItem(new ActionAutoBundle(selection));
                autoBundle.setText(String.format("Auto Bundle (%d)", selPinCount));
                actions.add(autoBundle);
                if (selection != Selection.getCurrentSelectionForDb((Db)OrbitIO.getCurDb())) {
                    OrbitGuiObjectActionRegistry.ActionSelectMultiDbObject<PinInstance> a = new OrbitGuiObjectActionRegistry.ActionSelectMultiDbObject<PinInstance>(selection, PinInstance.class);
                    a.putValue("Name", String.format("Select %s (%d)", pinText, selection.getCount(PinInstance.class)));
                    actions.add(a);
                }
                if ((selPins = selection.getSelSet(PinInstance.class)).getDevicePathIfOnlyOne() != null) {
                    actions.add(AssignPwrGndDlg.getAction(selPins.getDevicePathIfOnlyOne()));
                }
            }
            if ((selPinTemplateCnt = selection.getCount(db.getDbClass(PinTemplate.class))) > 0 && selection != Selection.getCurrentSelectionForDb((Db)db, (boolean)false)) {
                List<PinTemplate> pts = selection.get(PinTemplate.class).stream().collect(Collectors.toList());
                OrbitGuiObjectActionRegistry.ActionSelectMultiDbObject<PinTemplate> a = new OrbitGuiObjectActionRegistry.ActionSelectMultiDbObject<PinTemplate>(selection, PinTemplate.class);
                a.putValue("Name", String.format("Select %s (%d)", PinUI.getTextForPinTemplateList(pts), pts.size()));
                actions.add(a);
            }
            return actions.iterator();
        }

        @Override
        public String getGroupName() {
            return "Pin Actions";
        }
    };
    private static final String INVALID_PIN = "<invalid>";
    private static final Map<String, Integer> TEXT2INDEX = AUtil.indexMap((Object[])new String[]{"Pin", "Pins", "Via", "Vias", "Finger", "Fingers", "<invalid>"});

    private PinUI() {
    }

    public static String getTextForPin(PinTemplate pt) {
        if (pt == null || pt.getDb() == null) {
            return INVALID_PIN;
        }
        if (Selectors.VIA_PIN_TYPE.contains(pt.getType())) {
            return "Via";
        }
        if (Selectors.FINGER_PIN_TYPE.contains(pt.getType())) {
            return "Finger";
        }
        return "Pin";
    }

    public static String getTextForPin(PinInstance pinInst) {
        return PinUI.getTextForPin(pinInst.getPinTemplate());
    }

    public static String getTextForPinTemplateList(List<PinTemplate> ptList) {
        return ptList.stream().map(PinUI::getTextForPin).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(e -> {
            if ((Long)e.getValue() > 1L && !((String)e.getKey()).equals(INVALID_PIN)) {
                return (String)e.getKey() + "s";
            }
            return (String)e.getKey();
        }).sorted((a, b) -> Integer.compare(TEXT2INDEX.get(a), TEXT2INDEX.get(b))).collect(Collectors.joining("/"));
    }

    public static String getTextForPinInstanceList(List<PinInstance> pinInstList) {
        return PinUI.getTextForPinTemplateList(pinInstList.stream().map(PinInstance::getPinTemplate).collect(Collectors.toList()));
    }

    public static String getTextForPinHierList(List<HierInst<PinTemplate>> pinHierList) {
        return PinUI.getTextForPinTemplateList(pinHierList.stream().map(APair::getSecond).collect(Collectors.toList()));
    }

    public static class ActionAutoBundle
    extends AbstractAction {
        protected Selection mSelection;

        public ActionAutoBundle(Selection s) {
            this.mSelection = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoBundleNetUI.go(this.mSelection);
        }
    }

    public static class ActionShowRatsOnPin
    extends AbstractAction {
        protected Selection mSelection;

        public ActionShowRatsOnPin(Selection s) {
            super("Show Connections on", OrbitIcons.SHOW_RATS);
            this.mSelection = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Show Connections on Selected Devices and Pins");){
                Cp.exec((String)"_show = new com.sigrity.acl.edaMgrs.HConnEngine.ShowOnDevicesOrPins();", (Object[])new Object[0]);
                for (HierInst pin : this.mSelection.getSelectedHierInsts(PinInstance.class)) {
                    Cp.exec((String)"_show.addPin(\"%s\", \"%s\");", (Object[])new Object[]{((PinInstance)pin.getDbObject()).getKeyStr(), pin.getPath().escapedString()});
                }
                Cp.exec((String)"_show.showOn();", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_show\");", (Object[])new Object[0]);
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionFanoutBumps
    extends AbstractAction {
        protected final Selection mSelection;
        protected final APoint2D mRefWorldLoc;

        public ActionFanoutBumps(Selection s, APoint2D worldLoc) {
            super("Bumps for All Layer Shapes");
            this.mSelection = s;
            this.mRefWorldLoc = worldLoc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            CreateFanoutBumpsUI dlg = new CreateFanoutBumpsUI(OrbitIO.getMainWindow(), db, this.mSelection, this.mRefWorldLoc);
            dlg.setVisible(true);
        }
    }

    public static class ActionFanoutVias
    extends AbstractAction {
        protected Selection mSelection;

        public ActionFanoutVias(Selection s) {
            super("Fanout Vias...");
            this.mSelection = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            CreateFanoutsUI dlg = new CreateFanoutsUI(OrbitIO.getMainWindow(), db, this.mSelection);
            dlg.setVisible(true);
        }
    }

    public static class ActionShowMePort
    extends AbstractAction {
        protected PortTemplate portT;
        protected DevicePath path;

        public ActionShowMePort(DevicePath path, PortTemplate port) {
            super("Show Me");
            this.portT = port;
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowMeTheWay.addHierPort(this.path, this.portT);
        }
    }

    public static class ActionShowMePorts
    extends AbstractAction {
        protected PinTemplate pinT;
        protected DevicePath path;

        public ActionShowMePorts(DevicePath path, PinTemplate pinT) {
            super("Show Me", OrbitIcons.SHOW_ME);
            this.pinT = pinT;
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.pinT.getPortTemplates().forEach(portT -> ShowMeTheWay.addHierPort(this.path, portT));
        }
    }

    public static class ActionShowMeSelectedPorts
    extends AbstractAction {
        private Selection mSelection;

        public ActionShowMeSelectedPorts(Selection selection, String pinText) {
            super(String.format("Show Me Selected %s", pinText), OrbitIcons.SHOW_ME);
            this.mSelection = selection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mSelection.getSelectedHierInsts(PinInstance.class).forEach(pinInst -> ShowMeTheWay.addHierPin(HierPin.forHPin((HierInst)pinInst)));
        }
    }
}

