/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Text;
import com.sigrity.acl.dbui.MovingSet;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.contact_sync.ContactObjectSyncEngine;
import com.sigrity.orbit.ui.BoundsAndOrigin;
import com.sigrity.orbit.ui.DeleteDeviceUI;
import com.sigrity.orbit.ui.InterfaceTreeUI;
import com.sigrity.orbit.ui.ObjectCopyOrMoveUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PostPlaceActionRegistry;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_modes.MovePlaceableItemMode;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class PlaceableItemUI {
    private static TypeInfo thePOType = null;
    static APoint2D mMoveStartLoc = null;
    protected static DbClass mdbc = null;
    static boolean mCopyMode = false;
    static boolean mCopyFirstTime = false;
    static MovingSet movingSet = null;
    static DevicePath mDevicePath = null;
    static DevicePath mMovingDevicePath = null;
    static MovePlaceableItemMode movePlaceableItemMode = null;
    static DesignView2D.ViewMode prevMode;
    private static boolean isVerifyContactSync;
    protected static boolean sOverwriteExistingFloorplanFlag;
    protected static boolean sSmartAlign;
    protected static boolean sKeepInsideParent;
    protected static boolean sRestrictOrthogonalMovement;
    protected static boolean sAuxiliaryLine;
    protected static boolean sUseAppropriateGrid;
    protected static boolean sOverwriteExistingPersonality;
    protected static boolean sRestrictToParent;
    protected static boolean sAllowMissingSlots;
    protected static boolean sIncludeNonIOPins;
    protected static boolean sRequirePersonalityMatch;
    protected static JMenuItem mRotate90;
    protected static JMenuItem mRotate180;
    protected static JMenuItem mRotate270;
    protected static JMenuItem mBestRotate;
    protected static JMenuItem mStopDynamics;
    protected static JMenuItem mMirrorAboutYAndFlip;
    protected static JMenuItem mMirrorAboutXAndFlip;
    protected static JMenuItem mMirrorAboutY;
    protected static JMenuItem mMirrorAboutX;

    static void setThePOType(TypeInfo newType) {
        if (thePOType != null) {
            thePOType.cleanup();
        }
        thePOType = newType;
    }

    public static void setStartLoc(long x, long y) {
        mMoveStartLoc = new APoint2D(x, y);
    }

    public static void setIsVerifyContactSync(boolean b) {
        isVerifyContactSync = b;
    }

    public static void init() {
        movingSet = new MovingSet(true);
    }

    public static DesignView2D.ViewMode getPrevMode() {
        return prevMode;
    }

    public static void setPrevMode(DesignView2D.ViewMode mode) {
        prevMode = mode;
    }

    public static TypeInfo getThePOType() {
        return thePOType;
    }

    public static Selection.SelSet getMovingSelectSet() {
        return movingSet.getSelSet();
    }

    public static MovingSet getMovingSet() {
        return movingSet;
    }

    public static void setCopyMode(boolean flag) {
        mCopyMode = flag;
    }

    public static boolean getCopyMode() {
        return mCopyMode;
    }

    public static void setCopyFirstTime(boolean flag) {
        mCopyFirstTime = flag;
    }

    public static boolean getCopyFirstTime() {
        return mCopyFirstTime;
    }

    public static boolean verifyObjectListOkToMove() {
        String ans = MovingSet.fireValidToMove(movingSet, thePOType.getType());
        if (ans != null) {
            ALog.logWarn((String)ans);
            return false;
        }
        mDevicePath = movingSet.getSelSet().getDevicePathIfOnlyOne();
        return true;
    }

    public static void copyAllObjects() {
        if (movePlaceableItemMode != null) {
            movePlaceableItemMode.clearDynConnections();
        }
        mDevicePath = movingSet.copyAllObjects();
    }

    public static void clearSelSet(boolean deleteObjects) {
        if (movingSet.getObjectsAreCopy()) {
            if (deleteObjects) {
                for (DbObject d : movingSet.getSelSet().getDbObjects()) {
                    PlaceableItemUI.deleteFromDb(d);
                }
            }
            movingSet.setObjectsAreCopy(false);
        }
        movingSet.clearSelSet();
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        if (view != null) {
            view.setBeingMoved(null);
        }
    }

    public static void startMove(boolean firstMove) {
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        DesignView2D.ViewMode vm = v.getMode("MovePlaceableItemMode");
        if (!(v.getCurMode() instanceof MovePlaceableItemMode)) {
            v.setMode(vm);
        }
        movePlaceableItemMode = (MovePlaceableItemMode)vm;
        movePlaceableItemMode.setPlaceableItemMode(thePOType, firstMove || !PlaceableItemUI.getCopyFirstTime());
        if (PlaceableItemUI.getCopyMode() || firstMove && PlaceableItemUI.getCopyFirstTime()) {
            Cp.exec((boolean)false, (String)"com.sigrity.orbit.ui.PlaceableItemUI.copyAllObjects();", (Object[])new Object[0]);
        }
        if (!PlaceableItemUI.verifyObjectListOkToMove()) {
            v.setMode(prevMode);
            return;
        }
        movingSet.initialize();
        assert (movePlaceableItemMode != null);
        if (movePlaceableItemMode != null) {
            movePlaceableItemMode.setItemOnCursor(true);
            movePlaceableItemMode.createCursorContentsImage();
            ALog.logInfo((String)"Beginning dynamic %s of %s(s).", (Object[])new Object[]{PlaceableItemUI.getCopyMode() || PlaceableItemUI.getCopyFirstTime() ? "copy" : "move", thePOType.getType().toLowerCase()});
            if (PlaceableItemUI.getCopyFirstTime() && !firstMove) {
                movePlaceableItemMode.dynRotate(0.0f);
            } else if (!firstMove) {
                movePlaceableItemMode.refreshImage();
            }
            movePlaceableItemMode.repaintView();
        }
        v.setBeingMoved(movingSet);
    }

    public static BoundsAndOrigin getPlaceableItemScreenBoundsAndOrigin(DesignView2D view) {
        BoundsAndOrigin ans = new BoundsAndOrigin();
        APoint2D placeableItemWorldOrigin = movingSet.getLoc(mMoveStartLoc);
        movingSet.rotateAndMirror();
        ARect placeableItemWorldBounds = movingSet.getBB();
        if (placeableItemWorldBounds == null) {
            return ans;
        }
        Point deviceImageOrigin = new Point();
        DesignCanvas2D canvas = view.getCanvas();
        DesignCanvas2D.XForm xform = canvas.getXForm();
        Rectangle placeableItemScreenBounds = xform.getScreenRect(placeableItemWorldBounds);
        long wdx = placeableItemWorldOrigin.getX() - placeableItemWorldBounds.getLL().getX();
        long wdy = placeableItemWorldOrigin.getY() - placeableItemWorldBounds.getLL().getY();
        int sdx = xform.getScreenLength(wdx);
        int sdy = xform.getScreenLength(wdy);
        Point p = new Point(sdx, placeableItemScreenBounds.height - sdy);
        deviceImageOrigin.setLocation(p);
        Rectangle clip = canvas.getBounds();
        if (placeableItemScreenBounds.width > clip.width) {
            int clipX = placeableItemScreenBounds.width - clip.width;
            if (deviceImageOrigin.x > placeableItemScreenBounds.width - clipX) {
                int originOffset = clipX + Math.max(0, placeableItemScreenBounds.width - deviceImageOrigin.x);
                deviceImageOrigin.x -= originOffset;
                placeableItemScreenBounds.x += originOffset;
            }
            placeableItemScreenBounds.width -= clipX;
        }
        if (placeableItemScreenBounds.height > clip.height) {
            int clipY = placeableItemScreenBounds.height - clip.height;
            if (deviceImageOrigin.y > placeableItemScreenBounds.height - clipY) {
                int orginOffset = clipY + Math.max(0, placeableItemScreenBounds.height - deviceImageOrigin.y);
                deviceImageOrigin.y -= orginOffset;
                placeableItemScreenBounds.y += orginOffset;
            }
            placeableItemScreenBounds.height -= clipY;
        }
        if (placeableItemScreenBounds.width <= 0 || placeableItemScreenBounds.height <= 0) {
            placeableItemScreenBounds.width = 1;
            placeableItemScreenBounds.height = 1;
        }
        ans.setWorldBounds(placeableItemWorldBounds);
        ans.setOrigin(deviceImageOrigin);
        movingSet.setStartLoc(placeableItemWorldOrigin.getX(), placeableItemWorldOrigin.getY());
        ans.setScreenBounds(placeableItemScreenBounds);
        return ans;
    }

    public static BufferedImage getImage(DesignView2D view, DefaultViewDrawer viewDrawer, BoundsAndOrigin boundsAndOrigin) {
        DesignCanvas2D canvas = view.getCanvas();
        Rectangle screenBounds = boundsAndOrigin.getScreenBounds();
        if (screenBounds == null || canvas.getXForm().getScreen() == null) {
            return null;
        }
        int ansWidth = screenBounds.width + 10;
        int ansHeight = screenBounds.height + 10;
        BufferedImage ans = new BufferedImage(ansWidth, ansHeight, 6);
        Graphics2D g = (Graphics2D)ans.getGraphics();
        g.translate(5, 5);
        DesignCanvas2D.XForm oldXForm = canvas.copyXForm(canvas.getXForm());
        ARect drawWorldBounds = canvas.getXForm().getWorldRect(screenBounds);
        canvas.getXForm().setWorld(drawWorldBounds);
        Rectangle drawScreenBounds = new Rectangle(0, 0, screenBounds.width, screenBounds.height);
        canvas.getXForm().setScreen(drawScreenBounds);
        movingSet.draw(viewDrawer, g);
        canvas.setXForm(oldXForm);
        g.dispose();
        return ans;
    }

    public static void placeDynamicMoveAt(long x, long y, float pendingRot, boolean pendingMirrorX, boolean pendingMirrorY, boolean isShiftDown) {
        Settings prefs = Settings.getSettings((String)"UserPreferences");
        APoint2D worldPoint = new APoint2D(x, y);
        boolean allowHierarchyChange = (Boolean)prefs.getSetting("ChangeHeirarchyDuringMove", (Object)false);
        if (isShiftDown) {
            allowHierarchyChange = !allowHierarchyChange;
        }
        Db db = OrbitIO.getCurDb();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Place At");){
            ContactObjectSyncEngine sync = new ContactObjectSyncEngine(db);
            movingSet.getSelSet().getDbObjects().forEach(sync::addToSyncLoc);
            movingSet.setCurLoc(worldPoint);
            movingSet.rotateAndMirror();
            MovingSet.firePlace(movingSet, allowHierarchyChange, PlaceableItemUI.getSmartAlign());
            if (!PlaceableItemUI.getCopyMode() && !PlaceableItemUI.getCopyFirstTime()) {
                PlaceableItemUI.postPlaceActions(PlaceableItemUI.getMovingSet());
            }
            sync.execute(!isVerifyContactSync);
        }
        OrbitIO.getApp().refreshCurrentView(true);
        PlaceableItemUI.moveFinished(false);
    }

    public static void postPlaceActions(MovingSet movingSet) {
        try {
            for (PostPlaceActionRegistry.PostPlaceActionRegistryFunction f : PostPlaceActionRegistry.getRegistry()) {
                f.postPlace(movingSet);
            }
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Error running postPlaceActions", (Object[])new Object[0]);
        }
    }

    public static void endDynamicMoveAt(DesignView2D view, DesignView2D.MouseAction e, float pendingRot, boolean pendingMirrorX, boolean pendingMirrorY) {
        Point newLoc = new Point(e.getPoint());
        APoint2D worldPoint = view.getCanvas().getXForm().getWorldPt(newLoc);
        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.placeDynamicMoveAt(%dL, %dL, %fF, %s, %s, %s)", (Object[])new Object[]{worldPoint.getX(), worldPoint.getY(), Float.valueOf(pendingRot), Boolean.toString(pendingMirrorX), Boolean.toString(pendingMirrorY), Boolean.toString(e.isShiftDown())});
    }

    public static float getBestRotation() {
        return MovingSet.fireBestRot(movingSet);
    }

    public static void deleteFromDb(DbObject d) {
        DbObject dbo = thePOType.objectToManipulate(d);
        if (dbo != null && dbo.getDb() != null) {
            dbo.deleteFromDb();
        }
    }

    public static void deleteSelected() {
        Design currentDesign = OrbitIO.getCurDesign();
        Selection s = currentDesign.getCurSelection();
        movingSet.getSelSet().clear();
        movingSet.setSelSet(s.getSelSet(mdbc));
        thePOType.removeDuplicateObjectIdentifiers();
        ArrayList deletedObjs = AUtil.arrayList((Iterator)movingSet.getSelSet().getDbObjects());
        ContactObjectSyncEngine sync = new ContactObjectSyncEngine(OrbitIO.getCurDb());
        deletedObjs.forEach(obj -> {
            s.remove(obj);
            sync.addToSyncDelete((DbObject)obj);
        });
        sync.execute();
        deletedObjs.forEach(PlaceableItemUI::deleteFromDb);
    }

    private static void prepareSelectedObjectsForMove() {
        Design currentDesign = OrbitIO.getCurDesign();
        Selection s = currentDesign.getCurSelection();
        movingSet.setSelSet(thePOType.filterSelectSet(s.getSelSet(mdbc)), mMoveStartLoc);
        if (mdbc.equals((Object)OrbitIO.getCurDb().getDbClass(PinInstance.class))) {
            ObjectCopyOrMoveUI.setObjectTypeString("pin");
        } else if (mdbc.equals((Object)OrbitIO.getCurDb().getDbClass(Device.class))) {
            ObjectCopyOrMoveUI.setObjectTypeString("device");
        } else {
            assert (false) : "Unkown DbObject type";
            ObjectCopyOrMoveUI.setObjectTypeString(null);
        }
        ObjectCopyOrMoveUI.prepareObjectsForMove(movingSet.getSelSet());
        Selection.SelSet drawingSet = thePOType.modifyDrawingSet(movingSet.getDynamicDrawingSet());
        movingSet.setDynamicDrawingSet(drawingSet);
    }

    public static void moveObjectInteractively(long x, long y, String devicePathStr, String objectKeyStr, boolean copy, boolean copyFirstTimeOnly) {
        PlaceableItemUI.setStartLoc(x, y);
        PlaceableItemUI.moveObjectInteractively(devicePathStr, objectKeyStr, copy, copyFirstTimeOnly);
    }

    public static void moveObjectInteractively(String devicePathStr, String objectKeyStr, boolean copy, boolean copyFirstTimeOnly) {
        PlaceableItemUI.setCopyMode(copy);
        PlaceableItemUI.setCopyFirstTime(copyFirstTimeOnly);
        DbObject object = thePOType.getFromKeyStr(objectKeyStr);
        boolean initMovingSet = object instanceof Text;
        movingSet = new MovingSet(initMovingSet);
        DevicePath devPath = DevicePath.fromString((Db)object.getDb(), (String)devicePathStr);
        if (object instanceof Device && devPath.getLast() == object) {
            devPath = devPath.getParent();
        }
        movingSet.getSelSet().add(devPath, object);
        PlaceableItemUI.startMove(true);
    }

    public static void moveSelectedInteractively(long startX, long startY, boolean copy, boolean copyFirstTimeOnly) {
        PlaceableItemUI.setStartLoc(startX, startY);
        PlaceableItemUI.moveSelectedInteractively(copy, copyFirstTimeOnly);
    }

    public static void moveSelectedInteractively(boolean copy, boolean copyFirstTimeOnly) {
        PlaceableItemUI.setCopyMode(copy);
        PlaceableItemUI.setCopyFirstTime(copyFirstTimeOnly);
        PlaceableItemUI.prepareSelectedObjectsForMove();
        if (movingSet.getSelSet().getDevicePathIfOnlyOne() == null && !thePOType.allowMovesFromMultipleDevicePaths()) {
            ALog.logError((String)"Cannot move items from multiple device paths at the same time. Please change your selection.");
            return;
        }
        PlaceableItemUI.startMove(true);
    }

    public static void moveFloorplanInteractively(Db db, String floorplanStr, String pathStr) {
        movingSet = new MovingSet(false);
        DevicePath devPath = DevicePath.fromString((Db)db, (String)pathStr);
        Floorplan floorplan = (Floorplan)db.getByKeyStr(Floorplan.class, floorplanStr);
        MovingSet.setMovingFloorplan(db, floorplanStr);
        PlaceableItemUI.setCopyMode(false);
        PlaceableItemUI.setCopyFirstTime(false);
        Selection.SelSet objects = new Selection.SelSet();
        Selection.SelSet objectsToDraw = new Selection.SelSet();
        objectsToDraw.add(devPath, (DbObject)floorplan);
        objects.add(devPath, (DbObject)floorplan);
        LinkedList<Net> pinsNets = new LinkedList<Net>();
        for (FloorplanPin fpPin : floorplan.getAllDescendantPins()) {
            devPath = fpPin.getDevicePath();
            for (HierPin hierPin : fpPin.getPinTemplate().getHierarchicalInstances()) {
                if (!devPath.isEndOf((DevicePath)hierPin.first)) continue;
                objects.add((DevicePath)hierPin.first, (DbObject)hierPin.second);
                ALog.logDebug((String)"%s %s, %s", (Object[])new Object[]{hierPin.first, hierPin.second, devPath});
            }
            Net net = fpPin.getSubstrateNet();
            pinsNets.add(net);
        }
        movingSet.setSelSet(objects);
        movingSet.setNetsList(pinsNets);
        movingSet.setDynamicDrawingSet(objectsToDraw);
        if (movingSet.getSelSet().getDevicePathIfOnlyOne() == null && !thePOType.allowMovesFromMultipleDevicePaths()) {
            ALog.logError((String)"Cannot move items from multiple device paths at the same time. Change your selection to use this command.");
            return;
        }
        PlaceableItemUI.startMove(true);
        PlaceableItemUI.setCopyFirstTime(false);
    }

    public static void moveCanceled() {
        if (PlaceableItemUI.getCopyMode() || PlaceableItemUI.getCopyFirstTime()) {
            Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.clearSelSet(true);", (Object[])new Object[0]);
        } else {
            PlaceableItemUI.getMovingSet().clearSelSet();
        }
        if (movePlaceableItemMode != null) {
            movePlaceableItemMode.removePlaceableItemFromCursor();
        }
    }

    public static void moveFinished(boolean cancel) {
        if (cancel) {
            thePOType.cancel();
            return;
        }
        if (PlaceableItemUI.getCopyMode() || PlaceableItemUI.getCopyFirstTime()) {
            PlaceableItemUI.startMove(false);
        } else {
            DesignView2D v = (DesignView2D)OrbitIO.getCurView();
            v.setBeingMoved(null);
            v.setMode(prevMode);
            if (prevMode instanceof MovePlaceableItemMode) {
                movePlaceableItemMode.setItemOnCursor(false);
            }
        }
    }

    public static void deleteObject(String devicePathStr, String objectKeyStr) {
        thePOType.deleteUI(thePOType.getFromKeyStr(objectKeyStr));
    }

    protected static boolean getSmartAlign() {
        return sSmartAlign;
    }

    protected static void setSmartAlign(boolean enable) {
        sSmartAlign = enable;
    }

    public static void setKeepInsideParentInitialValue(String objectKeyStr) {
        Device d;
        DeviceTemplate parentT;
        boolean keepInsideParent = true;
        DbObject object = thePOType.getFromKeyStr(objectKeyStr);
        if (object instanceof Device && (parentT = (d = (Device)object).getParent()) != null) {
            keepInsideParent = parentT.getType() != DeviceTemplate.Type.GROUP;
        }
        PlaceableItemUI.setKeepInsideParent(keepInsideParent);
    }

    public static void setKeepInsideParent(boolean flag) {
        sKeepInsideParent = flag;
        if (flag) {
            MovingSet.restrictMovementInsideParent();
        } else {
            MovingSet.removeRestrictMovementInsideParent();
        }
    }

    public static void setOrthogonalMovement(boolean flag) {
        sRestrictOrthogonalMovement = flag;
        if (flag) {
            MovingSet.restrictOrthogonalMovement();
        } else {
            MovingSet.removeRestrictOrthogonalMovement();
        }
    }

    public static void setAuxiliaryLine(boolean e) {
        sAuxiliaryLine = e;
        MovingSet.setAxuiliaryLine(e);
    }

    public static void setUseAppropriateGrid(boolean flag) {
        sUseAppropriateGrid = flag;
        if (flag) {
            MovingSet.addSnapAdapter();
        } else {
            MovingSet.removeSnapAdapter();
        }
    }

    public static boolean getOverwriteExisting() {
        return sOverwriteExistingPersonality;
    }

    public static void setOverwriteExistingPersonality(boolean flag) {
        sOverwriteExistingPersonality = flag;
    }

    public static boolean getOverwriteExistingFloorplan() {
        return sOverwriteExistingFloorplanFlag;
    }

    public static void setOverwriteExistingFloorplan(boolean enable) {
        sOverwriteExistingFloorplanFlag = enable;
    }

    public static boolean getAllowMissingSlots() {
        return sAllowMissingSlots;
    }

    public static boolean getIncludeNonIOPins() {
        return sIncludeNonIOPins;
    }

    public static boolean getRequirePersonalityMatch() {
        return sRequirePersonalityMatch;
    }

    public static boolean getRestrictToParent() {
        return InterfaceTreeUI.getRestrictToParent(OrbitIO.getCurDb());
    }

    public static void setAllowMissingSlots(boolean flag) {
        sAllowMissingSlots = flag;
    }

    public static void includeNonIOPins(boolean flag) {
        sIncludeNonIOPins = flag;
        movePlaceableItemMode.setItemOnCursor(true);
        movePlaceableItemMode.createCursorContentsImage();
        movePlaceableItemMode.repaintView();
    }

    public static void setRequirePersonalityMatch(boolean flag) {
        sRequirePersonalityMatch = flag;
    }

    public static void setRestrictToParent(boolean flag) {
        InterfaceTreeUI.setRestrictToParent(OrbitIO.getCurDb(), flag);
    }

    public static void initKeepInsideParent() {
        sKeepInsideParent = true;
        PlaceableItemUI.setUseAppropriateGrid(true);
        MovingSet.restrictMovementInsideParent();
        MovingSet.addSnapAdapter();
    }

    public static void rotateOnCursor(float rotation) {
        if (movePlaceableItemMode != null) {
            movePlaceableItemMode.dynRotate(rotation);
        }
    }

    public static void dynMirror(boolean aboutX) {
        if (movePlaceableItemMode != null) {
            movePlaceableItemMode.dynMirror(aboutX);
        }
    }

    public static void mirrorAboutXAxis() {
        if (movePlaceableItemMode != null) {
            movePlaceableItemMode.dynMirrorX();
        }
    }

    public static void mirrorAboutYAxis() {
        if (movePlaceableItemMode != null) {
            movePlaceableItemMode.dynMirrorY();
        }
    }

    public static void dynRotateBest() {
        if (movePlaceableItemMode != null) {
            movePlaceableItemMode.dynRotateBest();
        }
    }

    public static JCheckBoxMenuItem createMenuItemOverwriteExistingFloorplans() {
        return new JCheckBoxMenuItem(new AbstractAction("Overwrite existing floorplans", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setOverwriteExistingFloorplan(%b);", (Object[])new Object[]{!sOverwriteExistingFloorplanFlag});
            }
        }){

            @Override
            public boolean isSelected() {
                return sOverwriteExistingFloorplanFlag;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemSmartAlign() {
        return new JCheckBoxMenuItem(new AbstractAction("Smart Align", OrbitIcons.ALIGN){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaceableItemUI.setSmartAlign(!sSmartAlign);
            }
        }){

            @Override
            public boolean isSelected() {
                return sSmartAlign;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemKeepInsideParent() {
        return new JCheckBoxMenuItem(new AbstractAction("Keep inside parent", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setKeepInsideParent(%b);", (Object[])new Object[]{!sKeepInsideParent});
            }
        }){

            @Override
            public boolean isSelected() {
                return sKeepInsideParent;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemRestrictOrthogonalMovement() {
        return new JCheckBoxMenuItem(new AbstractAction("Orthogonal Movements Only", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setOrthogonalMovement(%b);", (Object[])new Object[]{!sRestrictOrthogonalMovement});
            }
        }){

            @Override
            public boolean isSelected() {
                return sRestrictOrthogonalMovement;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemAuxiliaryLine() {
        return new JCheckBoxMenuItem(new AbstractAction("Use Auxiliary Line", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setAuxiliaryLine(%b);", (Object[])new Object[]{!sAuxiliaryLine});
            }
        }){

            @Override
            public boolean isSelected() {
                return sAuxiliaryLine;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemAppropriateGrid() {
        return new JCheckBoxMenuItem(new AbstractAction("Use Appropriate Grid", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setUseAppropriateGrid(%b);", (Object[])new Object[]{!sUseAppropriateGrid});
            }
        }){

            @Override
            public boolean isSelected() {
                return sUseAppropriateGrid;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemOverwriteExistingPersonality() {
        return new JCheckBoxMenuItem(new AbstractAction("Overwrite existing personalities", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setOverwriteExistingPersonality(%b);", (Object[])new Object[]{!sOverwriteExistingPersonality});
            }
        }){

            @Override
            public boolean isSelected() {
                return sOverwriteExistingPersonality;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemRestrictToParent() {
        return new JCheckBoxMenuItem(new AbstractAction("Restrict to Parent", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setRestrictToParent(%b);", (Object[])new Object[]{!sRestrictToParent});
            }
        }){

            @Override
            public boolean isSelected() {
                return sRestrictToParent;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemAllowMissingSlots() {
        return new JCheckBoxMenuItem(new AbstractAction("Allow Missing Slots", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setAllowMissingSlots(%b);", (Object[])new Object[]{!sAllowMissingSlots});
            }
        }){

            @Override
            public boolean isSelected() {
                return sAllowMissingSlots;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemIncludeNonIOPins() {
        return new JCheckBoxMenuItem(new AbstractAction("Include Non-IO Pins", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.includeNonIOPins(%b);", (Object[])new Object[]{!sIncludeNonIOPins});
            }
        }){

            @Override
            public boolean isSelected() {
                return sIncludeNonIOPins;
            }
        };
    }

    public static JCheckBoxMenuItem createMenuItemRequirePersonalityMatch() {
        return new JCheckBoxMenuItem(new AbstractAction("Require Personality Match", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setRequirePersonalityMatch(%b);", (Object[])new Object[]{!sRequirePersonalityMatch});
            }
        }){

            @Override
            public boolean isSelected() {
                return sRequirePersonalityMatch;
            }
        };
    }

    public static void insertItemsInMenu(AbstractViewMode.ContextMenu contextMenu, AbstractButton[] contextMenuItems) {
        for (int i = 0; i < contextMenuItems.length; ++i) {
            AbstractButton b = contextMenuItems[i];
            if (b == null) {
                contextMenu.insert(new JSeparator(), i);
                continue;
            }
            contextMenu.insert(b, i);
            if (b.getText().startsWith("Rotate ")) {
                b.setMnemonic(b.getText().charAt(7));
                continue;
            }
            UIUtil.setUniqueMnemonic((JPopupMenu)contextMenu, (AbstractButton)b);
        }
    }

    public static void doneAction() {
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        v.setMode(PlaceableItemUI.getPrevMode());
    }

    private static void prepareBeforeStart() {
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        if (v == null) {
            return;
        }
        DesignView2D.ViewMode vm = v.getMode("MovePlaceableItemMode");
        if (!(v.getCurMode() instanceof MovePlaceableItemMode)) {
            PlaceableItemUI.setPrevMode(v.getCurMode());
            v.setMode(vm);
        }
    }

    private static void endOfMode() {
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        if (v == null) {
            return;
        }
        if (v.getCurMode() instanceof MovePlaceableItemMode) {
            v.getCurMode().uninstallMode();
        }
    }

    static {
        isVerifyContactSync = true;
        sOverwriteExistingFloorplanFlag = false;
        sSmartAlign = false;
        sKeepInsideParent = false;
        sRestrictOrthogonalMovement = false;
        sAuxiliaryLine = false;
        sUseAppropriateGrid = false;
        sOverwriteExistingPersonality = true;
        sRestrictToParent = false;
        sAllowMissingSlots = false;
        sIncludeNonIOPins = true;
        sRequirePersonalityMatch = false;
        mRotate90 = new JMenuItem(new AbstractAction("Rotate 90 Clockwise", OrbitIcons.ROTATE_90CW){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.rotateOnCursor(90.0F);", (Object[])new Object[0]);
            }
        });
        mRotate180 = new JMenuItem(new AbstractAction("Rotate 180", OrbitIcons.ROTATE_180){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.rotateOnCursor(180.0F);", (Object[])new Object[0]);
            }
        });
        mRotate270 = new JMenuItem(new AbstractAction("Rotate 90 Counterclockwise", OrbitIcons.ROTATE_90CCW){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.rotateOnCursor(270.0F);", (Object[])new Object[0]);
            }
        });
        mBestRotate = new JMenuItem(new AbstractAction("Best Rotate"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.dynRotateBest();", (Object[])new Object[0]);
            }
        });
        mStopDynamics = new JMenuItem(new AbstractAction("Done"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaceableItemUI.doneAction();
            }
        });
        mMirrorAboutYAndFlip = new JMenuItem(new AbstractAction("Mirror About Y Axis and Flip", OrbitIcons.FLIP_ABOUTY){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.dynMirror(false);", (Object[])new Object[0]);
            }
        });
        mMirrorAboutXAndFlip = new JMenuItem(new AbstractAction("Mirror About X Axis and Flip", OrbitIcons.FLIP_ABOUTX){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.dynMirror(true);", (Object[])new Object[0]);
            }
        });
        mMirrorAboutY = new JMenuItem(new AbstractAction("Mirror About Y Axis", OrbitIcons.FLIP_ABOUTY){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.mirrorAboutYAxis();", (Object[])new Object[0]);
            }
        });
        mMirrorAboutX = new JMenuItem(new AbstractAction("Mirror About X Axis", OrbitIcons.FLIP_ABOUTX){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.mirrorAboutXAxis();", (Object[])new Object[0]);
            }
        });
    }

    public static class DoText
    implements TypeInfo {
        public static final String TYPE_NAME = "Text";
        static TypeInfo me = null;
        protected AbstractButton[] mContextMenuItems = new AbstractButton[]{null};

        @Override
        public DbObject objectToManipulate(DbObject obj) {
            return obj;
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void removeDuplicateObjectIdentifiers() {
        }

        @Override
        public String getType() {
            return TYPE_NAME;
        }

        @Override
        public DbObject getFromKeyStr(String str) {
            return OrbitIO.getCurDb().getByKeyStr(Text.class, str);
        }

        public DoText() {
            mdbc = OrbitIO.getCurDb().getDbClass(Text.class);
            ObjectCopyOrMoveUI.setObjectTypeString("text");
        }

        public static void Start() {
            PlaceableItemUI.prepareBeforeStart();
            PlaceableItemUI.setThePOType(new DoText());
        }

        public static void end() {
            PlaceableItemUI.endOfMode();
        }

        @Override
        public boolean isOfType(DbObject o) {
            return o instanceof Text;
        }

        @Override
        public void deleteUI(DbObject obj) {
        }

        @Override
        public boolean isDynamicConnection(Connection c) {
            return false;
        }

        @Override
        public void startDynamicMoveAt(DesignView2D view, DesignView2D.MouseAction e) {
        }

        @Override
        public void insertItemsInContextMenu(AbstractViewMode.ContextMenu contextMenu) {
            PlaceableItemUI.insertItemsInMenu(contextMenu, this.mContextMenuItems);
        }

        @Override
        public Cursor getCursor() {
            return UIUtil.createCursor((Icon)OrbitIcons.MOVE_DEVICE);
        }

        @Override
        public boolean allowMovesFromMultipleDevicePaths() {
            return false;
        }

        @Override
        public void cancel() {
            PlaceableItemUI.moveCanceled();
        }

        @Override
        public Selection.SelSet filterSelectSet(Selection.SelSet initSet) {
            return initSet;
        }

        @Override
        public Selection.SelSet modifyDrawingSet(Selection.SelSet dynamicDrawingSet) {
            return dynamicDrawingSet;
        }

        @Override
        public List<AbstractButton> getToolBarActions() {
            return AUtil.arrayList((Object[])this.mContextMenuItems);
        }
    }

    public static class DoFloorplan
    implements TypeInfo {
        public static final String TYPE_NAME = "Floorplan";
        protected static AbstractButton[] mContextMenuItems = new AbstractButton[]{mRotate90, mRotate180, mRotate270, mMirrorAboutX, mMirrorAboutY, PlaceableItemUI.createMenuItemOverwriteExistingFloorplans(), PlaceableItemUI.createMenuItemIncludeNonIOPins(), PlaceableItemUI.createMenuItemRequirePersonalityMatch(), PlaceableItemUI.createMenuItemRestrictToParent(), null, mStopDynamics, null};
        static final Cursor validLocCursor = UIUtil.createCursor((Icon)OrbitIcons.FLOORPLAN_HAPPY);
        static final Cursor invalidLocCursor = UIUtil.createCursor((Icon)OrbitIcons.FLOORPLAN_BLOCKED);
        static boolean mValidLoc = true;

        @Override
        public DbObject objectToManipulate(DbObject obj) {
            return ((PinInstance)obj).getPinTemplate();
        }

        @Override
        public void cleanup() {
            MovingSet.stopMoveFloorplanAdapter();
        }

        @Override
        public void removeDuplicateObjectIdentifiers() {
            movingSet.setSelSet(PinInstance.removePinsWithDuplicatePinTemplates((Selection.SelSet)movingSet.getSelSet()));
        }

        @Override
        public String getType() {
            return TYPE_NAME;
        }

        @Override
        public DbObject getFromKeyStr(String str) {
            return OrbitIO.getCurDb().getByKeyStr(PinTemplate.class, str);
        }

        public DoFloorplan() {
            mdbc = OrbitIO.getCurDb().getDbClass(PinInstance.class);
        }

        public static void Start() {
            PlaceableItemUI.prepareBeforeStart();
            PlaceableItemUI.setOverwriteExistingFloorplan(sOverwriteExistingFloorplanFlag);
            PlaceableItemUI.setRestrictToParent(InterfaceTreeUI.getRestrictToParent(OrbitIO.getCurDb()));
            PlaceableItemUI.setThePOType(new DoFloorplan());
            MovingSet.initMoveFloorplanAdapter();
        }

        public static void end() {
            PlaceableItemUI.endOfMode();
        }

        @Override
        public boolean isOfType(DbObject o) {
            return o instanceof PinInstance;
        }

        @Override
        public void deleteUI(DbObject obj) {
        }

        @Override
        public boolean isDynamicConnection(Connection c) {
            return false;
        }

        @Override
        public void startDynamicMoveAt(DesignView2D view, DesignView2D.MouseAction e) {
        }

        @Override
        public void insertItemsInContextMenu(AbstractViewMode.ContextMenu contextMenu) {
            PlaceableItemUI.insertItemsInMenu(contextMenu, mContextMenuItems);
        }

        public static void setValidLoc(boolean flag) {
            if (mValidLoc != flag) {
                mValidLoc = flag;
                ((DesignView2D)OrbitIO.getCurView()).setCursor(thePOType.getCursor());
            }
        }

        @Override
        public Cursor getCursor() {
            if (mValidLoc) {
                return validLocCursor;
            }
            return invalidLocCursor;
        }

        @Override
        public boolean allowMovesFromMultipleDevicePaths() {
            return true;
        }

        @Override
        public void cancel() {
            PlaceableItemUI.moveCanceled();
        }

        @Override
        public Selection.SelSet filterSelectSet(Selection.SelSet initSet) {
            return initSet;
        }

        @Override
        public Selection.SelSet modifyDrawingSet(Selection.SelSet dynamicDrawingSet) {
            return dynamicDrawingSet;
        }

        @Override
        public List<AbstractButton> getToolBarActions() {
            return AUtil.arrayList((Object[])mContextMenuItems);
        }
    }

    public static class DoPinPersonality
    implements TypeInfo {
        public static final String TYPE_NAME = "Pin Personality";
        static final Cursor validLocCursor = UIUtil.createCursor((Icon)OrbitIcons.PERSONALITY_PIN);
        static final Cursor invalidLocCursor = UIUtil.createCursor((Icon)OrbitIcons.BLOCKED_PERSONALITY_PIN);
        static boolean mValidLoc = true;
        protected static AbstractButton[] mContextMenuItems = new AbstractButton[]{mRotate90, mRotate180, mRotate270, mMirrorAboutX, mMirrorAboutY, PlaceableItemUI.createMenuItemOverwriteExistingPersonality(), PlaceableItemUI.createMenuItemAllowMissingSlots(), PlaceableItemUI.createMenuItemKeepInsideParent(), null, mStopDynamics, null};

        @Override
        public DbObject objectToManipulate(DbObject obj) {
            return ((PinInstance)obj).getPinTemplate();
        }

        @Override
        public void cleanup() {
            MovingSet.stopCopyPersonalityAdapter();
        }

        @Override
        public void removeDuplicateObjectIdentifiers() {
            movingSet.setSelSet(PinInstance.removePinsWithDuplicatePinTemplates((Selection.SelSet)movingSet.getSelSet()));
        }

        @Override
        public String getType() {
            return TYPE_NAME;
        }

        @Override
        public DbObject getFromKeyStr(String str) {
            return OrbitIO.getCurDb().getByKeyStr(PinTemplate.class, str);
        }

        public DoPinPersonality() {
            mdbc = OrbitIO.getCurDb().getDbClass(PinInstance.class);
        }

        public static void Start() {
            PlaceableItemUI.prepareBeforeStart();
            OrbitIO.getMovingSetMonitor().setActive(false);
            Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setOverwriteExistingPersonality(%b);", (Object[])new Object[]{sOverwriteExistingPersonality});
            Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setAllowMissingSlots(%b);", (Object[])new Object[]{sAllowMissingSlots});
            PlaceableItemUI.setThePOType(new DoPinPersonality());
            MovingSet.initCopyPersonalityAdapter();
        }

        public static void end() {
            PlaceableItemUI.endOfMode();
        }

        @Override
        public boolean isOfType(DbObject o) {
            return o instanceof PinInstance;
        }

        @Override
        public void deleteUI(DbObject obj) {
        }

        @Override
        public boolean isDynamicConnection(Connection c) {
            return false;
        }

        @Override
        public void startDynamicMoveAt(DesignView2D view, DesignView2D.MouseAction e) {
        }

        @Override
        public void insertItemsInContextMenu(AbstractViewMode.ContextMenu contextMenu) {
            PlaceableItemUI.insertItemsInMenu(contextMenu, mContextMenuItems);
        }

        public static void setValidLoc(boolean flag) {
            if (mValidLoc != flag) {
                mValidLoc = flag;
                ((DesignView2D)OrbitIO.getCurView()).setCursor(thePOType.getCursor());
            }
        }

        @Override
        public Cursor getCursor() {
            if (mValidLoc) {
                return validLocCursor;
            }
            return invalidLocCursor;
        }

        @Override
        public boolean allowMovesFromMultipleDevicePaths() {
            return true;
        }

        @Override
        public void cancel() {
            for (DbObject object : movingSet.getSelSet().getDbObjects()) {
                PinInstance pin;
                PinTemplate pinT;
                if (!(object instanceof PinInstance) || !(pinT = (pin = (PinInstance)object).getPinTemplate()).getIsDynamic()) continue;
                pinT.deleteFromDb();
            }
            PlaceableItemUI.moveCanceled();
            OrbitIO.getMovingSetMonitor().setActive(true);
        }

        @Override
        public Selection.SelSet filterSelectSet(Selection.SelSet initSet) {
            return initSet;
        }

        @Override
        public Selection.SelSet modifyDrawingSet(Selection.SelSet dynamicDrawingSet) {
            return dynamicDrawingSet;
        }

        @Override
        public List<AbstractButton> getToolBarActions() {
            return AUtil.arrayList((Object[])mContextMenuItems);
        }
    }

    public static class DoPin
    implements TypeInfo {
        public static final String TYPE_NAME = "Pin";
        protected static AbstractButton[] mContextMenuItems = new AbstractButton[]{mRotate90, mRotate180, mRotate270, mBestRotate, mStopDynamics, null, PlaceableItemUI.createMenuItemKeepInsideParent(), PlaceableItemUI.createMenuItemAppropriateGrid(), null};

        @Override
        public DbObject objectToManipulate(DbObject obj) {
            return ((PinInstance)obj).getPinTemplate();
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void removeDuplicateObjectIdentifiers() {
            movingSet.setSelSet(PinInstance.removePinsWithDuplicatePinTemplates((Selection.SelSet)movingSet.getSelSet()));
        }

        @Override
        public String getType() {
            return TYPE_NAME;
        }

        @Override
        public DbObject getFromKeyStr(String str) {
            return OrbitIO.getCurDb().getByKeyStr(PinTemplate.class, str);
        }

        public DoPin() {
            mdbc = OrbitIO.getCurDb().getDbClass(PinInstance.class);
            ObjectCopyOrMoveUI.setObjectTypeString("pin");
        }

        public static void Start() {
            PlaceableItemUI.prepareBeforeStart();
            PlaceableItemUI.setThePOType(new DoPin());
        }

        public static void end() {
            PlaceableItemUI.endOfMode();
        }

        @Override
        public boolean isOfType(DbObject o) {
            return o instanceof PinInstance;
        }

        @Override
        public void deleteUI(DbObject obj) {
            if (obj == null) {
                ALog.logError((String)"No pins specified to delete.");
                return;
            }
            if (!(obj instanceof PinTemplate)) {
                assert (false);
                return;
            }
            PinTemplate curPT = (PinTemplate)obj;
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)curPT.getDb(), (String)"Delete pin...");){
                Cp.exec((String)"unset(\"_sync\");", (Object[])new Object[0]);
                Cp.exec((String)"_sync = new com.sigrity.orbit.automation.contact_sync.ContactObjectSyncEngine(curDb());", (Object[])new Object[0]);
                Cp.exec((String)"_sync.addToSyncDelete(%s);", (Object[])new Object[]{CpHelper.getObjCmdStr(curPT)});
                Cp.exec((String)"_sync.execute()", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_sync\");", (Object[])new Object[0]);
                Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(curPT)});
            }
            OrbitIO.refreshViewsOf(OrbitIO.getCurDb());
        }

        @Override
        public boolean isDynamicConnection(Connection c) {
            return false;
        }

        @Override
        public void startDynamicMoveAt(DesignView2D view, DesignView2D.MouseAction e) {
        }

        @Override
        public void insertItemsInContextMenu(AbstractViewMode.ContextMenu contextMenu) {
            PlaceableItemUI.insertItemsInMenu(contextMenu, mContextMenuItems);
        }

        @Override
        public Cursor getCursor() {
            return UIUtil.createCursor((Icon)OrbitIcons.MOVE_VIA);
        }

        @Override
        public boolean allowMovesFromMultipleDevicePaths() {
            return false;
        }

        @Override
        public void cancel() {
            PlaceableItemUI.moveCanceled();
        }

        @Override
        public Selection.SelSet filterSelectSet(Selection.SelSet initSet) {
            return initSet.getPinsWithoutDuplicateVias();
        }

        @Override
        public Selection.SelSet modifyDrawingSet(Selection.SelSet dynamicDrawingSet) {
            return MovingSet.addAttachedToDrawingSet(dynamicDrawingSet);
        }

        @Override
        public List<AbstractButton> getToolBarActions() {
            return AUtil.arrayList((Object[])mContextMenuItems);
        }
    }

    public static class DoDevice
    implements TypeInfo {
        public static final String TYPE_NAME = "Device";
        static TypeInfo me = null;
        protected AbstractButton[] mContextMenuItems = new AbstractButton[]{mRotate90, mRotate270, mRotate180, mBestRotate, mStopDynamics, null, mMirrorAboutXAndFlip, mMirrorAboutYAndFlip, null, PlaceableItemUI.createMenuItemKeepInsideParent(), PlaceableItemUI.createMenuItemAppropriateGrid(), PlaceableItemUI.createMenuItemSmartAlign(), PlaceableItemUI.createMenuItemRestrictOrthogonalMovement(), PlaceableItemUI.createMenuItemAuxiliaryLine(), null};

        @Override
        public DbObject objectToManipulate(DbObject obj) {
            return obj;
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void removeDuplicateObjectIdentifiers() {
        }

        @Override
        public String getType() {
            return TYPE_NAME;
        }

        @Override
        public DbObject getFromKeyStr(String str) {
            return OrbitIO.getCurDb().getByKeyStr(Device.class, str);
        }

        public DoDevice() {
            mdbc = OrbitIO.getCurDb().getDbClass(Device.class);
            ObjectCopyOrMoveUI.setObjectTypeString("device");
        }

        public static void Start() {
            PlaceableItemUI.prepareBeforeStart();
            DoDevice me = new DoDevice();
            PlaceableItemUI.setThePOType(me);
        }

        public static void end() {
            PlaceableItemUI.endOfMode();
        }

        public static void StartWithoutObject() {
            DoDevice me = new DoDevice();
            PlaceableItemUI.setThePOType(me);
            DesignView2D view = (DesignView2D)OrbitIO.getCurView();
            MovePlaceableItemMode vm = MovePlaceableItemMode.install(view, me);
            vm.setStartAgainAfterPlacing(true);
        }

        @Override
        public boolean isOfType(DbObject o) {
            return o instanceof Device;
        }

        @Override
        public void deleteUI(DbObject obj) {
            DeleteDeviceUI.showUI(OrbitIO.getMainWindow(), (Device)obj);
        }

        @Override
        public boolean isDynamicConnection(Connection c) {
            if (mDevicePath != null) {
                return mDevicePath.contains((DevicePath)c.getDPPA().first) || mDevicePath.contains((DevicePath)c.getDPPB().first);
            }
            return false;
        }

        @Override
        public void startDynamicMoveAt(DesignView2D view, DesignView2D.MouseAction e) {
            DevicePath clickedDPath;
            Settings prefs = Settings.getSettings((String)"UserPreferences");
            APoint2D worldPoint = view.getCanvas().getXForm().getWorldPt(e.getPoint());
            boolean defGuess = (Boolean)prefs.getSetting("DevicePickGuessBestDevice", (Object)false);
            boolean guess = e.isControlDown() || defGuess && !e.isShiftDown();
            mDevicePath = clickedDPath = view.getDeviceAt(worldPoint, "Select Device to Move", guess);
            PlaceableItemUI.moveObjectInteractively(mDevicePath.toString(), mDevicePath.getLast().getKeyStr(), false, false);
        }

        @Override
        public void insertItemsInContextMenu(AbstractViewMode.ContextMenu contextMenu) {
            PlaceableItemUI.insertItemsInMenu(contextMenu, this.mContextMenuItems);
        }

        @Override
        public Cursor getCursor() {
            return UIUtil.createCursor((Icon)OrbitIcons.MOVE_DEVICE);
        }

        @Override
        public boolean allowMovesFromMultipleDevicePaths() {
            return false;
        }

        @Override
        public void cancel() {
            PlaceableItemUI.moveCanceled();
        }

        @Override
        public Selection.SelSet filterSelectSet(Selection.SelSet initSet) {
            return initSet;
        }

        @Override
        public Selection.SelSet modifyDrawingSet(Selection.SelSet dynamicDrawingSet) {
            return dynamicDrawingSet;
        }

        @Override
        public List<AbstractButton> getToolBarActions() {
            return AUtil.arrayList((Object[])this.mContextMenuItems);
        }
    }

    public static interface TypeInfo {
        public static final String TYPE_NAME = "UNKOWN";

        public DbObject getFromKeyStr(String var1);

        public Selection.SelSet modifyDrawingSet(Selection.SelSet var1);

        public void cancel();

        public void cleanup();

        public boolean isOfType(DbObject var1);

        public void deleteUI(DbObject var1);

        public DbObject objectToManipulate(DbObject var1);

        public boolean isDynamicConnection(Connection var1);

        public void startDynamicMoveAt(DesignView2D var1, DesignView2D.MouseAction var2);

        public String getType();

        public boolean allowMovesFromMultipleDevicePaths();

        public void removeDuplicateObjectIdentifiers();

        public void insertItemsInContextMenu(AbstractViewMode.ContextMenu var1);

        public List<AbstractButton> getToolBarActions();

        public Cursor getCursor();

        public Selection.SelSet filterSelectSet(Selection.SelSet var1);
    }
}

