/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.PinUI;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenuItem;

public class PortUI {
    public static final OrbitGuiShortcutActionRegistry.ViewActionFactory ViewActionFactory = new OrbitGuiShortcutActionRegistry.ViewActionFactory(){

        @Override
        public Iterator<Object> getActions(Db db, Selection selection, APoint2D worldLoc) {
            DbClass portClass = db.getDbClass(PortTemplate.class);
            int selPinCount = selection.getCount(portClass);
            LinkedList<JMenuItem> actions = new LinkedList<JMenuItem>();
            if (selPinCount > 0) {
                JMenuItem fanoutViaMenueitem = new JMenuItem(new PinUI.ActionFanoutVias(selection));
                actions.add(fanoutViaMenueitem);
                JMenuItem fanoutBumpMenueitem = new JMenuItem(new PinUI.ActionFanoutBumps(selection, worldLoc));
                actions.add(fanoutBumpMenueitem);
            }
            return actions.iterator();
        }

        @Override
        public String getGroupName() {
            return "Port Actions";
        }
    };

    private PortUI() {
    }
}

