/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;

public class PowerConfigUI {
    public static Action getAction(final DevicePath path) {
        return new AbstractAction("Export Power Config"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PowerConfigUI.showUI(path);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitApp.getCurDb() != null;
            }
        };
    }

    public static void showUI(DevicePath path) {
        AFileChooser fc = new AFileChooser();
        AFileFilter fileFilter = new AFileFilter("pwrcfg", "Power Config");
        fc.addChoosableFileFilter((FileFilter)fileFilter);
        fc.setFileFilter((FileFilter)fileFilter);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("Export Power Config file");
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File fcFilePath = fc.getSelectedFile();
        if (fcFilePath == null) {
            return;
        }
        String fileName = fcFilePath.getPath();
        PowerConfigUI.exportPowerConfig(path, fileName);
    }

    private static void exportPowerConfig(DevicePath path, String fileName) {
        Cp.exec((String)"unset(\"_pwrCfgExport\");", (Object[])new Object[0]);
        Cp.exec((String)"_pwrCfgExport = new com.sigrity.orbit.export.PowerConfigExport();", (Object[])new Object[0]);
        Cp.exec((String)"_pwrCfgExport.export(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)fileName)});
        Cp.exec((String)"unset(\"_pwrCfgExport\");", (Object[])new Object[0]);
    }

    private PowerConfigUI() {
    }
}

