/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ui.AButtonListCellRenderer;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AImageIcon;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;

public class ProductSelector
extends ADialog {
    protected List<OrbitApp.Product> mProducts;
    protected Integer mSelected = -1;

    public static int select(List<OrbitApp.Product> products, Component owner) {
        ProductSelector dlg = new ProductSelector(products, owner);
        SelectRunnable runnable = new SelectRunnable(dlg);
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return runnable.getResult();
    }

    public ProductSelector(List<OrbitApp.Product> products, Component owner) {
        this.mProducts = products;
        this.setModal(true);
        this.setTitle("Select Product");
        AImageIcon icon = new AImageIcon(OrbitIO.getIconFile().getPath());
        this.setIconImage(icon.getImage());
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        l.add("Available product licenses:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0).insetRight(24));
        l.newline();
        AListModel<OrbitApp.Product> model = new AListModel<OrbitApp.Product>();
        model.setContents(products);
        final JList list = new JList(model);
        list.setSelectionMode(0);
        list.setCellRenderer(new AButtonListCellRenderer.RadioButton<OrbitApp.Product>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends OrbitApp.Product> list, OrbitApp.Product value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof OrbitApp.Product) {
                    this.setText(value.getDisplayName());
                }
                return this;
            }
        });
        l.addScroll(list, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.pushFillX();
        l.addFillX();
        final JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        this.pack();
        UIUtil.center((Component)((Object)this));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = list.getSelectedIndex();
                if (i < 0) {
                    JOptionPane.showMessageDialog((Component)((Object)ProductSelector.this), "A product must be selected.", "Select Product", 0);
                    return;
                }
                ProductSelector.this.mSelected = i;
                UIUtil.closeWindow((Window)((Object)ProductSelector.this));
            }
        });
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    btnOk.doClick(0);
                }
            }
        });
        list.setSelectedIndex(0);
    }

    public Integer getSelected() {
        return this.mSelected;
    }

    protected static class SelectRunnable
    implements Runnable {
        protected ProductSelector mDlg;
        protected int mResult = -1;

        public SelectRunnable(ProductSelector dlg) {
            this.mDlg = dlg;
        }

        @Override
        public void run() {
            Integer sel;
            do {
                this.mDlg.setVisible(true);
            } while ((sel = this.mDlg.getSelected()) == null);
            this.mResult = sel;
        }

        public int getResult() {
            return this.mResult;
        }
    }
}

