/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.ui.AComboBox;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class RatioSpecificationDlg
extends DbDialog {
    protected RatioSpecificationDlg theDialog = null;
    protected RatioSpecificationListener mListener = null;
    protected AComboBox<DbObject> mItem1;
    protected AComboBox<DbObject> mItem2;
    protected JCheckBox mAllowTolerance;
    protected JTextField mValue1 = null;
    protected JTextField mValue2 = null;
    protected JTextField mToleranceValue = null;
    protected JLabel mColonLabel = null;
    protected JLabel mPercentLabel = null;
    protected JButton mButOk = new JButton("OK");
    protected JButton mButCancel = new JButton("Cancel");
    protected ActionListener mItem1Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RatioSpecificationDlg.this.mItem1.getSelectedIndex() == RatioSpecificationDlg.this.mItem2.getSelectedIndex()) {
                RatioSpecificationDlg.this.mItem2.setSelectedIndex(RatioSpecificationDlg.this.mItem1.getSelectedIndex() == 0 ? 1 : 0);
            }
        }
    };
    protected ActionListener mItem2Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RatioSpecificationDlg.this.mItem1.getSelectedIndex() == RatioSpecificationDlg.this.mItem2.getSelectedIndex()) {
                RatioSpecificationDlg.this.mItem1.setSelectedIndex(RatioSpecificationDlg.this.mItem2.getSelectedIndex() == 0 ? 1 : 0);
            }
        }
    };
    protected ActionListener mAllowToleranceListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RatioSpecificationDlg.this.allowToleranceChanged();
        }
    };
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RatioSpecificationDlg.this.mItem1.getSelectedItem() == (DbObject)RatioSpecificationDlg.this.mItem2.getSelectedItem()) {
                JOptionPane.showConfirmDialog((Component)((Object)RatioSpecificationDlg.this), "Cannot set a ratio betwwen an object and itself", "Confirm Invalid ratio", 2);
                return;
            }
            try {
                AFieldValidator.validateLong((JTextField)RatioSpecificationDlg.this.mValue1, (long)1L, (long)Integer.MAX_VALUE);
                AFieldValidator.validateLong((JTextField)RatioSpecificationDlg.this.mValue1, (long)1L, (long)Integer.MAX_VALUE);
            }
            catch (AFieldValidator.AFieldValidationException e1) {
                return;
            }
            double tolerance = 0.0;
            if (RatioSpecificationDlg.this.mAllowTolerance.isSelected()) {
                tolerance = Double.parseDouble(RatioSpecificationDlg.this.mToleranceValue.getText());
            }
            RatioSpecificationDlg.this.mListener.doOk((DbObject)RatioSpecificationDlg.this.mItem1.getSelectedItem(), (DbObject)RatioSpecificationDlg.this.mItem2.getSelectedItem(), Integer.parseInt(RatioSpecificationDlg.this.mValue1.getText()), Integer.parseInt(RatioSpecificationDlg.this.mValue2.getText()), tolerance);
            UIUtil.closeWindow((Window)((Object)RatioSpecificationDlg.this.theDialog));
        }
    };

    public RatioSpecificationDlg(Window owner, Db db, RatioSpecificationListener listener) {
        super(db, (Component)owner);
        this.mListener = listener;
    }

    public static RatioSpecificationDlg createDialog(Window owner, Db db, RatioSpecificationListener listener) {
        RatioSpecificationDlg dlg = null;
        dlg = new RatioSpecificationDlg(owner, db, listener);
        dlg.init();
        return dlg;
    }

    protected void allowToleranceChanged() {
        this.mToleranceValue.setVisible(this.mAllowTolerance.isSelected());
        this.mPercentLabel.setVisible(this.mAllowTolerance.isSelected());
    }

    protected void populateItem1() {
        List<Object> list = this.mListener.getList();
        if (list == null) {
            list = Collections.emptyList();
        }
        this.mItem1.setModel(new DefaultComboBoxModel<DbObject>(list.toArray(new DbObject[list.size()])));
    }

    protected void populateItem2() {
        List<Object> list = this.mListener.getList();
        if (list == null) {
            list = Collections.emptyList();
        }
        this.mItem2.setModel(new DefaultComboBoxModel<DbObject>(list.toArray(new DbObject[list.size()])));
    }

    protected void init() {
        this.setTitle(this.mListener.getTitle());
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        this.mItem1 = new AComboBox();
        l.add(this.mItem1, (GridBagConstraints)GridBagManager.FILLX);
        this.mItem1.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                DbObject obj = (DbObject)value;
                if (obj == null) {
                    this.setIcon(null);
                    this.setText("<NONE>");
                    return this;
                }
                this.setIcon(RatioSpecificationDlg.this.mListener.getIcon(obj));
                this.setText(RatioSpecificationDlg.this.mListener.getText(obj));
                return this;
            }
        });
        JLabel la = new JLabel(":");
        la.setFont(new Font("Times New Roman", 1, 12));
        l.add((Component)la);
        this.mItem2 = new AComboBox();
        l.add(this.mItem2, (GridBagConstraints)GridBagManager.FILLX);
        this.mItem2.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                DbObject obj = (DbObject)value;
                if (obj == null) {
                    this.setIcon(null);
                    this.setText("<NONE>");
                    return this;
                }
                this.setIcon(RatioSpecificationDlg.this.mListener.getIcon(obj));
                this.setText(RatioSpecificationDlg.this.mListener.getText(obj));
                return this;
            }
        });
        l.newline();
        this.mValue1 = new JTextField("", 5);
        l.add((Component)this.mValue1, (GridBagConstraints)GridBagManager.FILLX);
        this.mColonLabel = new JLabel(":");
        this.mColonLabel.setFont(new Font("Times New Roman", 1, 12));
        l.add((Component)this.mColonLabel);
        this.mValue2 = new JTextField("", 5);
        l.add((Component)this.mValue2, (GridBagConstraints)GridBagManager.FILLX);
        l.pop();
        l.newline();
        l.push((GridBagConstraints)GridBagManager.LEFT.noInsets());
        this.mAllowTolerance = new JCheckBox("Allow Tolerance");
        this.mAllowTolerance.setToolTipText("If checked ratio values which are not exact, but withing the tolerance will be displayed in with a yellow background.");
        this.mAllowTolerance.addActionListener(this.mAllowToleranceListener);
        this.mAllowTolerance.setSelected(this.mListener.getToleranceInitValue() != 0.0);
        l.add((Component)this.mAllowTolerance);
        this.mToleranceValue = new JTextField("", 5);
        this.mToleranceValue.setText(this.mListener.getToleranceInitValue() == 0.0 ? "" : Double.toString(this.mListener.getToleranceInitValue()));
        l.add((Component)this.mToleranceValue, (GridBagConstraints)GridBagManager.LEFT);
        this.mPercentLabel = new JLabel("%");
        l.add((Component)this.mPercentLabel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.pop();
        l.newline();
        if (this.mListener.getValue1InitValue() < 0) {
            this.mValue1.setText("");
        } else {
            this.mValue1.setText(Integer.toString(this.mListener.getValue1InitValue()));
        }
        if (this.mListener.getValue2InitValue() < 0) {
            this.mValue2.setText("");
        } else {
            this.mValue2.setText(Integer.toString(this.mListener.getValue2InitValue()));
        }
        l.addFillY();
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        l.addFillX();
        l.add((Component)this.mButOk, (GridBagConstraints)GridBagManager.RIGHT);
        this.mButOk.addActionListener(this.mOk);
        l.add((Component)this.mButCancel, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.pack();
        this.populateItem1();
        this.populateItem2();
        this.mItem1.setSelectedItem((Object)this.mListener.getItem1InitValue());
        this.mItem2.setSelectedItem((Object)this.mListener.getItem2InitValue());
        if (this.mListener.getItem1InitValue() != null && this.mListener.getItem1InitValue() == this.mListener.getItem2InitValue() && this.mItem2.getItemCount() > 1) {
            this.mItem2.setSelectedIndex(1);
        }
        this.mItem1.addActionListener(this.mItem1Listener);
        this.mItem2.addActionListener(this.mItem2Listener);
        this.allowToleranceChanged();
        this.setMinimumSize(this.getPreferredSize());
        this.theDialog = this;
        UIUtil.center((Component)((Object)this));
        UIUtil.enableDefaultBtn((JDialog)((Object)this), (JButton)this.mButOk);
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mButCancel);
        UIUtil.enforceDialogMinSize((Window)((Object)this));
        this.setModal(true);
        this.setVisible(true);
    }

    public static interface RatioSpecificationListener {
        public String getTitle();

        public DbObject getItem1InitValue();

        public DbObject getItem2InitValue();

        public double getToleranceInitValue();

        public int getValue1InitValue();

        public int getValue2InitValue();

        public List<DbObject> getList();

        public String getText(DbObject var1);

        public Icon getIcon(DbObject var1);

        public void doOk(DbObject var1, DbObject var2, int var3, int var4, double var5);
    }
}

