/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RemoveNetsUI
extends DbDialog {
    protected DeviceTemplate mDeviceTemplate;
    protected JComboBox<Object> mDescendantLevels;
    protected static final String ALL = "All";
    protected JRadioButton mRbAllNets;
    protected JRadioButton mRbSpecifiedNets;
    protected JPanel mPnlNetSel;
    protected JCheckBox mCbSelNets;
    protected JCheckBox mCbSelChildren;
    protected JCheckBox mCbSelPorts;
    protected JCheckBox mCbSelConnections;
    protected JCheckBox mCbDelete;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object res;
            if (!RemoveNetsUI.this.validateFields()) {
                return;
            }
            String strLvls = "" + RemoveNetsUI.this.mDescendantLevels.getSelectedItem();
            int lvls = -1;
            if (!strLvls.equals(RemoveNetsUI.ALL)) {
                try {
                    lvls = Integer.parseInt(strLvls);
                }
                catch (NumberFormatException nfe) {
                    RemoveNetsUI.this.mDescendantLevels.requestFocus();
                    JOptionPane.showMessageDialog(RemoveNetsUI.this.mDescendantLevels, String.format("Unable to integer from parse '%s' as integer.", strLvls), "Parse Error", 0);
                    return;
                }
            }
            boolean delNets = RemoveNetsUI.this.mCbDelete.isSelected();
            if (lvls == 0 && !delNets) {
                JOptionPane.showMessageDialog(RemoveNetsUI.this.mDescendantLevels, "No levels of mappings are to be removed and no nets are to be deleted; therefore, there is nothing to do.", "Input Error", 0);
                return;
            }
            boolean selChildren = false;
            boolean selNets = false;
            boolean selPorts = false;
            boolean selConnections = false;
            if (RemoveNetsUI.this.mRbSpecifiedNets.isSelected()) {
                selChildren = RemoveNetsUI.this.mCbSelChildren.isSelected();
                selNets = RemoveNetsUI.this.mCbSelNets.isSelected();
                selPorts = RemoveNetsUI.this.mCbSelPorts.isSelected();
                selConnections = RemoveNetsUI.this.mCbSelConnections.isSelected();
            }
            if ((res = Cp.exec((String)"com.sigrity.orbit.cmd.DeviceTemplateCmd.removeNets(curDb(), \"%s\", %d, %s, %s, %s, %s, %s)", (Object[])new Object[]{RemoveNetsUI.this.mDeviceTemplate.getKeyStr(), lvls, delNets, selChildren, selNets, selPorts, selConnections})) == null || (Integer)res > 0) {
                UIUtil.closeWindow((Window)((Object)RemoveNetsUI.this));
                ALog.logInfo((String)"%s nets removed from '%s'.", (Object[])new Object[]{res != null ? res : "Unknown number of", RemoveNetsUI.this.mDeviceTemplate.getName()});
            }
        }
    };

    public static void showDialog(Component owner, DeviceTemplate dt) {
        new RemoveNetsUI(owner, dt).setVisible(true);
    }

    public RemoveNetsUI(Component owner, DeviceTemplate fromTemplate) {
        super(fromTemplate.getDb(), owner);
        this.mDeviceTemplate = fromTemplate;
        this.setTitle(String.format("Remove Nets From '%s'", this.mDeviceTemplate.getName()));
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        l.push("Specify Nets", (GridBagConstraints)GridBagManager.FILLX);
        this.mRbAllNets = (JRadioButton)l.add((Component)new JRadioButton("All Nets"));
        l.newline();
        this.mRbSpecifiedNets = (JRadioButton)l.add((Component)new JRadioButton("Nets that match all conditions:"));
        l.newline();
        UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mRbAllNets, this.mRbSpecifiedNets});
        this.mPnlNetSel = new JPanel();
        l.push((Container)this.mPnlNetSel, (GridBagConstraints)GridBagManager.FILLX);
        l.indent();
        this.mCbSelNets = (JCheckBox)l.add((Component)new JCheckBox("Only selected Nets"));
        l.newline();
        l.indent();
        this.mCbSelChildren = (JCheckBox)l.add((Component)new JCheckBox("Only Nets mapped to selected child devices"));
        l.newline();
        l.indent();
        this.mCbSelPorts = (JCheckBox)l.add((Component)new JCheckBox("Only Nets on selected pins"));
        l.newline();
        l.indent();
        this.mCbSelConnections = (JCheckBox)l.add((Component)new JCheckBox("Only Nets of selected connections"));
        l.addFillX();
        l.pop();
        l.popNl();
        l.push("Specify Actions", (GridBagConstraints)GridBagManager.FILLX);
        l.pushNoFill();
        l.add("Unmap ");
        this.mDescendantLevels = (JComboBox)l.add(new JComboBox<Object>(new Object[]{1, 2, ALL}));
        this.mDescendantLevels.setSelectedItem(1);
        String s = String.format("level(s) down from '%s'", this.mDeviceTemplate.getName());
        l.add(s);
        l.popNl();
        this.mCbDelete = (JCheckBox)l.add((Component)new JCheckBox(String.format("Delete nets from '%s'", this.mDeviceTemplate.getName())));
        l.addFillX();
        l.popNl();
        l.pushFillAllRemainX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        l.pop();
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.mRbSpecifiedNets.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RemoveNetsUI.this.enableControls();
            }
        });
        btnOk.addActionListener(this.mOk);
        this.mRbAllNets.setSelected(true);
        this.mDescendantLevels.setEditable(true);
        this.enableControls();
    }

    protected void enableControls() {
        UIUtil.setEnabled((Container)this.mPnlNetSel, (boolean)this.mRbSpecifiedNets.isSelected());
    }

    protected boolean validateFields() {
        String levels = "" + this.mDescendantLevels.getSelectedItem();
        if (!levels.equals(ALL)) {
            try {
                AFieldValidator.validateInt((String)levels, this.mDescendantLevels);
            }
            catch (AFieldValidator.AFieldValidationException fve) {
                return false;
            }
            int lvls = -1;
            try {
                lvls = Integer.parseInt("" + this.mDescendantLevels.getSelectedItem());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (lvls <= 0) {
                this.mDescendantLevels.requestFocus();
                JOptionPane.showMessageDialog(this.mDescendantLevels, "One or more levels of hierarchy must be specified for unmapping.", "Input Error", 0);
                return false;
            }
        }
        if (!(!this.mRbSpecifiedNets.isSelected() || this.mCbSelChildren.isSelected() || this.mCbSelNets.isSelected() || this.mCbSelPorts.isSelected() || this.mCbSelConnections.isSelected())) {
            this.mRbSpecifiedNets.requestFocus();
            JOptionPane.showMessageDialog(this.mRbSpecifiedNets, "If 'Specified Nets' is selected, at lease one selection criteria must be selected", "Input Error", 0);
            return false;
        }
        return true;
    }
}

