/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADocumentAdapter;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RenameDeviceTemplateUI {
    public static boolean renameTemplate(String templateName, String newName, String substrateName) {
        Substrate s = Substrate.getSubstrate((Db)OrbitIO.getCurDb(), (String)substrateName);
        DeviceTemplate dt = DeviceTemplate.getDeviceTemplate((Substrate)s, (String)templateName);
        if (dt == null) {
            ALog.logError((String)"No device template named '%s' exists in the current database.", (Object[])new Object[]{templateName});
            return false;
        }
        dt.setName(newName);
        return true;
    }

    public static boolean rename(Window dlgOwner, DeviceTemplate dt) {
        if (Design.getIsDesign((DeviceTemplate)dt)) {
            JOptionPane.showMessageDialog(dlgOwner, "Cannot rename design template.", "Rename Device Template", 2);
            return false;
        }
        RenameDeviceTemplateDlg dlg = new RenameDeviceTemplateDlg(dlgOwner, dt);
        dlg.setVisible(true);
        return true;
    }

    static class RenameDeviceTemplateDlg
    extends ADialog {
        protected DeviceTemplate mDT;
        protected JTextField mTxtNewName;
        protected JButton mBtnOk;
        protected DocumentListener mNameChangeListener = new ADocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                super.documentChanged(e);
                mBtnOk.setEnabled(mTxtNewName.getText().trim().length() > 0);
            }
        };
        protected ActionListener mOk = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName = mTxtNewName.getText().trim();
                if (DeviceTemplate.getDeviceTemplate((Substrate)mDT.getSubstrate(), (String)newName) != null) {
                    mTxtNewName.requestFocus();
                    String msg = String.format("A device template named '%s' already exists in the design.", newName);
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, "Duplicate Device Template Name", 0);
                    return;
                }
                String pkg = this.getClass().getPackage().getName();
                Cp.exec((String)"%s.RenameDeviceTemplateUI.renameTemplate(\"%s\", \"%s\" , \"%s\")", (Object[])new Object[]{pkg, mDT.getName(), newName, mDT.getSubstrate().getName()});
                UIUtil.closeWindow((Window)((Object)this));
            }
        };

        public RenameDeviceTemplateDlg(Window owner, DeviceTemplate dt) {
            super(owner);
            this.setTitle("Rename Device Template");
            this.mDT = dt;
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Current name:");
            l.add(this.mDT.getName());
            l.newline();
            l.add("New name:");
            this.mTxtNewName = new JTextField(20);
            l.add((Component)this.mTxtNewName, (GridBagConstraints)GridBagManager.FILLX);
            this.mTxtNewName.getDocument().addDocumentListener(this.mNameChangeListener);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOk = new JButton("OK");
            l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnOk.addActionListener(this.mOk);
            JButton btnCancel = new JButton("Cancel");
            l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.mNameChangeListener.changedUpdate(null);
            this.mTxtNewName.setText(this.mDT.getName());
        }
    }
}

