/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADocumentAdapter;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RenameDeviceUI {
    public static void renameDevice(String deviceKey, String newDeviceName) {
        Device d = (Device)OrbitIO.getCurDb().getByKeyStr(Device.class, deviceKey);
        if (d != null) {
            ALog.logInfo((String)"Device %s is renamed to %s", (Object[])new Object[]{d.getName(), newDeviceName});
            d.setName(newDeviceName);
        }
    }

    public static boolean renameDevice(Window dlgOwner, Device device) {
        RenameDeviceDlg dlg = dlgOwner instanceof Dialog ? new RenameDeviceDlg((Dialog)dlgOwner, device) : new RenameDeviceDlg((Frame)dlgOwner, device);
        dlg.setVisible(true);
        return true;
    }

    protected static class ActionRenameDevice
    extends AbstractAction {
        protected Device mDevice;

        public ActionRenameDevice(Device device) {
            super("Rename Device...");
            this.mDevice = device;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameDeviceUI.renameDevice(OrbitIO.getMainWindow(), this.mDevice);
        }
    }

    static class RenameDeviceDlg
    extends ADialog {
        protected Device mDevice;
        protected JTextField mTxtNewName;
        protected JButton mBtnOk;
        protected DocumentListener mNameChangeListener = new ADocumentAdapter(this){
            final /* synthetic */ RenameDeviceDlg this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void documentChanged(DocumentEvent e) {
                super.documentChanged(e);
                this.this$0.mBtnOk.setEnabled(this.this$0.mTxtNewName.getText().trim().length() > 0);
            }
        };
        protected ActionListener mOk = new ActionListener(this){
            final /* synthetic */ RenameDeviceDlg this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName = this.this$0.mTxtNewName.getText().trim();
                DeviceTemplate dtParent = this.this$0.mDevice.getParent();
                if (Device.getChildDevice((DeviceTemplate)dtParent, (String)newName) != null) {
                    this.this$0.mTxtNewName.requestFocus();
                    String parentDesc = DeviceTemplate.getShortDesc((DeviceTemplate)dtParent);
                    String msg = String.format("A device named '%s' already exists in the %s.", newName, parentDesc);
                    JOptionPane.showMessageDialog((Component)((Object)this.this$0), msg, "Duplicate Device Name", 0);
                    return;
                }
                Cp.exec((String)"com.sigrity.orbit.ui.RenameDeviceUI.renameDevice(\"%s\", \"%s\")", (Object[])new Object[]{this.this$0.mDevice.getKeyStr(), newName});
                UIUtil.closeWindow((Window)((Object)this.this$0));
            }
        };

        public RenameDeviceDlg(Dialog owner, Device device) {
            super(owner);
            this.init(device);
        }

        public RenameDeviceDlg(Frame owner, Device device) {
            super(owner);
            this.init(device);
        }

        protected void init(Device device) {
            this.setTitle("Rename Device");
            this.mDevice = device;
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Current name:");
            l.add(this.mDevice.getName());
            l.newline();
            l.add("New name:");
            this.mTxtNewName = new JTextField(20);
            l.add((Component)this.mTxtNewName, (GridBagConstraints)GridBagManager.FILLX);
            this.mTxtNewName.getDocument().addDocumentListener(this.mNameChangeListener);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOk = new JButton("OK");
            l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnOk.addActionListener(this.mOk);
            JButton btnCancel = new JButton("Cancel");
            l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.mNameChangeListener.changedUpdate(null);
            this.mTxtNewName.setText(this.mDevice.getName());
        }
    }
}

