/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AReflection;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADocumentAdapter;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.cmd.PinCmd;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JTextField;

public class RenamePinUI {
    public static void show(Window owner, PinTemplate pinT, Optional<DevicePath> path) {
        if (path.isPresent() && path.get().getDeviceTemplate() != pinT.getDeviceTemplate()) {
            throw new IllegalArgumentException("PinTemplate is not from the specified path's DeviceTemplate");
        }
        new RenamePinDlg(owner, pinT, path).setVisible(true);
    }

    static class RenamePinDlg
    extends ADialog {
        protected PinTemplate mPinTemplate;
        protected DevicePath mPath = null;
        protected PinInstance mPinInstance = null;
        protected JTextField mTxtTmpltName;
        protected JCheckBox mCbOverride;
        protected JTextField mTxtInstName;
        protected JCheckBox mCbRemoveAllOverrides;
        protected JButton mBtnOk;
        protected ActionListener mOk = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitApp.getCurDb(), (String)"Rename Pin");){
                    if (this.removeAllOverrides()) {
                        Cp.exec((String)"%s.removeAllInstNames(curDb(), \"%s\")", (Object[])new Object[]{AReflection.getJavaClassName(PinCmd.class), mPinTemplate.getKeyStr()});
                    }
                    if (this.pinTNameChanged()) {
                        Cp.exec((String)"%s.setPinTemplateName(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{AReflection.getJavaClassName(PinCmd.class), mPinTemplate.getKeyStr(), this.getNewPinTName()});
                    }
                    if (mPinInstance != null && !this.getOrigInstName().orElse("").equals(this.getNewInstName())) {
                        Cp.exec((String)"%s.setPinInstanceName(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{AReflection.getJavaClassName(PinCmd.class), mPinInstance.getKeyStr(), this.getNewInstName()});
                    }
                }
                UIUtil.closeWindow((Window)((Object)this));
            }
        };

        public RenamePinDlg(Window owner, PinTemplate pinT, Optional<DevicePath> path) {
            super(owner);
            this.setRecallBounds(false);
            this.mPinTemplate = pinT;
            if (path.isPresent()) {
                this.mPath = path.get();
            }
            if (this.mPath != null && this.mPath.getDevice() != null) {
                this.mPinInstance = PinInstance.getPinInstance((Device)this.mPath.getDevice(), (PinTemplate)this.mPinTemplate);
            }
            this.setTitle("Rename Pin");
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Pin Template name:");
            this.mTxtTmpltName = (JTextField)l.add((Component)new JTextField(this.getOrigPinTName(), 20));
            l.newline();
            if (this.mPinInstance != null) {
                l.pushNoFill();
                this.mCbOverride = (JCheckBox)l.add((Component)new JCheckBox(), (GridBagConstraints)GridBagManager.LEFT.insetRight(0));
                l.add("Instance name override:", (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
                l.pop();
                this.mTxtInstName = (JTextField)l.add((Component)new JTextField(this.getOrigPinTName(), 20));
                String pinInstName = this.mPinInstance.getPinInstanceName();
                if (pinInstName != null) {
                    this.mCbOverride.setSelected(true);
                    this.mTxtInstName.setText(pinInstName);
                }
                l.newline();
            }
            long pinInstCount = AUtil.count((Iterator)this.mPinTemplate.getPinInstances());
            long pinInstOverrideNameCount = this.mPinTemplate.getPinInstances().stream().filter(pi -> pi.getPinInstanceName() != null).count();
            String overDesc = String.format("<html><i>There are a total of %d instance(s) of this PinTemplate, %d instance(s)<br/>override the PinTemplate name%s.", pinInstCount, pinInstOverrideNameCount, this.mPinInstance == null || this.mPinInstance.getPinInstanceName() == null ? "" : " (including this instance)");
            l.push("Name Overrides", (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.add(overDesc);
            if (pinInstOverrideNameCount > 1L || pinInstOverrideNameCount > 0L && this.mPinInstance.getPinInstanceName() == null) {
                l.newline();
                this.mCbRemoveAllOverrides = (JCheckBox)l.add((Component)new JCheckBox("Remove all current instance overrides"), (GridBagConstraints)GridBagManager.RIGHT);
            }
            l.popNl();
            l.addFillY();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOk = new JButton("OK");
            l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnOk.addActionListener(this.mOk);
            JButton btnCancel = new JButton("Cancel");
            l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.mTxtTmpltName.getDocument().addDocumentListener(ADocumentAdapter.notifyChange(e -> this.updateControls()));
            if (this.mTxtInstName != null) {
                this.mTxtInstName.getDocument().addDocumentListener(ADocumentAdapter.notifyChange(e -> this.updateControls()));
            }
            if (this.mCbOverride != null) {
                this.mCbOverride.addActionListener(e -> this.updateControls());
            }
            if (this.mCbRemoveAllOverrides != null) {
                this.mCbRemoveAllOverrides.addActionListener(e -> this.updateControls());
            }
            this.updateControls();
        }

        protected void updateControls() {
            this.mBtnOk.setEnabled(this.pinTNameChanged() || this.instNameOverrideChanged() || this.instNameChanged() || this.removeAllOverrides());
            if (this.mTxtInstName != null) {
                this.mTxtInstName.setEnabled(this.mCbOverride != null && this.mCbOverride.isSelected());
            }
        }

        protected boolean pinTNameChanged() {
            return !this.getNewPinTName().isEmpty() && !this.mPinTemplate.getName().equals(this.getNewPinTName());
        }

        protected boolean instNameOverrideChanged() {
            boolean instNameOverride;
            boolean bl = instNameOverride = this.mCbOverride != null && this.mCbOverride.isSelected();
            return this.mCbOverride != null && instNameOverride != (this.getOrigInstName() != null);
        }

        protected boolean instNameChanged() {
            String origInstName = this.getOrigInstName().orElse("");
            return !this.instNameOverrideChanged() && !origInstName.equals(this.getNewInstName());
        }

        protected boolean removeAllOverrides() {
            return this.mCbRemoveAllOverrides != null && this.mCbRemoveAllOverrides.isSelected();
        }

        protected String getOrigPinTName() {
            String pinTName = this.mPinTemplate.getName();
            return pinTName == null ? "" : pinTName;
        }

        protected String getNewPinTName() {
            return this.mTxtTmpltName.getText().trim();
        }

        protected String getNewInstName() {
            return this.mCbOverride == null ? "" : (this.mCbOverride.isSelected() ? this.mTxtInstName.getText().trim() : "");
        }

        protected Optional<String> getOrigInstName() {
            if (this.mPinInstance == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.mPinInstance.getName());
        }
    }
}

