/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADocumentAdapter;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RenameSubstrateUI {
    public static boolean renameSubstrate(String oldName, String newName) {
        Substrate s = Substrate.getSubstrate((Db)OrbitIO.getCurDb(), (String)oldName);
        if (s == null) {
            ALog.logError((String)"No substrate named '%s' exists in the current database.", (Object[])new Object[]{oldName});
            return false;
        }
        s.setName(newName);
        return true;
    }

    public static boolean rename(Window dlgOwner, Substrate substrate) {
        RenameSubstrateDlg dlg = new RenameSubstrateDlg(dlgOwner, substrate);
        dlg.setVisible(true);
        return dlg.mRenamed;
    }

    static class RenameSubstrateDlg
    extends ADialog {
        protected Substrate mSubstrate;
        protected boolean mRenamed = false;
        protected JTextField mTxtNewName;
        protected JButton mBtnOk;
        protected DocumentListener mNameChangeListener = new ADocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                super.documentChanged(e);
                mBtnOk.setEnabled(mTxtNewName.getText().trim().length() > 0 && !mTxtNewName.getText().equals(mSubstrate.getName()));
            }
        };
        protected ActionListener mOk = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName = mTxtNewName.getText().trim();
                String deviceTemplateName = mSubstrate.getName();
                String pkg = this.getClass().getPackage().getName();
                mRenamed = (Boolean)Cp.exec((String)"%s.RenameSubstrateUI.renameSubstrate(\"%s\", \"%s\")", (Object[])new Object[]{pkg, deviceTemplateName, newName});
                UIUtil.closeWindow((Window)((Object)this));
            }
        };

        public RenameSubstrateDlg(Window owner, Substrate substrate) {
            super(owner);
            this.setTitle("Rename Substrate");
            this.mSubstrate = substrate;
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Current name:");
            l.add(this.mSubstrate.getName());
            l.newline();
            l.add("New name:");
            this.mTxtNewName = new JTextField(20);
            l.add((Component)this.mTxtNewName, (GridBagConstraints)GridBagManager.FILLX);
            this.mTxtNewName.getDocument().addDocumentListener(this.mNameChangeListener);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOk = new JButton("OK");
            l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnOk.addActionListener(this.mOk);
            JButton btnCancel = new JButton("Cancel");
            l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.mTxtNewName.setText(this.mSubstrate.getName());
            this.mNameChangeListener.changedUpdate(null);
        }
    }
}

