/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AReflection;
import com.sigrity.acl.AStream;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.AComponentTitledBorder;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.placement.DeviceReplace;
import com.sigrity.orbit.diff_merge.CompareSubstrate;
import com.sigrity.orbit.ui.DeviceChooser;
import com.sigrity.orbit.ui.LayerMappingPanel;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ReplaceDeviceUI
extends ADialog {
    protected Device mDevice;
    protected JButton mBtnReplace = new JButton("Replace");
    protected JButton mBtnCancel = new JButton("Cancel");
    protected DeviceChooser.DCPanel mReplacementDeviceChooser;
    protected JPanel mPnlNetMapping;
    protected JRadioButton mRbByNetName = new JRadioButton("Reconnect nets by common net names");
    protected JRadioButton mRbByPinConnection = new JRadioButton("Reconnect nets by pin connections");
    protected JRadioButton mRbByPinLocation = new JRadioButton("Reconnect nets based on pin locations");
    protected LayerMappingPanel mPnlLayerMapping;
    protected JRadioButton mRbNoMapping = new JRadioButton("No mapping is done");
    protected JCheckBox mCbRelocReplacement = new JCheckBox("Relocate replacement device");
    protected JRadioButton mRbRelocSimilar = new JRadioButton("Based on the original device");
    protected JRadioButton mRbRelocOrig = new JRadioButton("Identical to the original device");
    protected JCheckBox mCbRmOldDevice = new JCheckBox("Delete the old device");
    protected JCheckBox mCbRmOldDevTemplate = new JCheckBox("Delete the old device template if no longer used");
    protected JCheckBox mCbRmOldSubstrate = new JCheckBox("Delete the old substrate if no longer used");
    protected JCheckBox mCbInheritChildren = new JCheckBox("Inherit old device's children");
    protected boolean mRefreshingLayerMappingControls = false;
    protected DeviceChooser.DCPanel.DeviceListener mSelectedReplacementDeviceListener = new DeviceChooser.DCPanel.DeviceListener(){

        @Override
        public void deviceSelected(Device d) {
            ReplaceDeviceUI.this.updateLayerMappingControls();
            ReplaceDeviceUI.this.enableReplace();
        }

        @Override
        public void deviceActivated(Device l) {
        }
    };
    protected ActionListener mReplaceListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DeviceReplace.Reloc reloc;
            Device replDevice = ReplaceDeviceUI.this.getReplacementDevice();
            if (replDevice == null) {
                return;
            }
            Device.PinMapOptions o = ReplaceDeviceUI.this.mRbByNetName.isSelected() ? Device.PinMapOptions.BYNETNAME : (ReplaceDeviceUI.this.mRbByPinConnection.isSelected() ? Device.PinMapOptions.BYPINCONNECTION : (ReplaceDeviceUI.this.mRbByPinLocation.isSelected() ? Device.PinMapOptions.BYPPINLOCATION : Device.PinMapOptions.NOMAPPING));
            StringBuffer matchLayerArgs = new StringBuffer();
            if (o == Device.PinMapOptions.BYPPINLOCATION) {
                ReplaceDeviceUI.this.mPnlLayerMapping.getMappings().forEach((l, r) -> {
                    if (l == null || r == null) {
                        return;
                    }
                    matchLayerArgs.append(String.format("%s\"%s\", \"%s\"", matchLayerArgs.length() == 0 ? "" : ", ", l.getName(), r.getName()));
                });
            }
            Cp.exec((String)"unset(\"$dr\")", (Object[])new Object[0]);
            Cp.exec((String)"$dr = %s.create()", (Object[])new Object[]{DeviceReplace.class.getCanonicalName()});
            Cp.exec((String)"$dr.setMapOption(Device.PinMapOptions.%s)", (Object[])new Object[]{o.name()});
            if (matchLayerArgs.length() > 0) {
                Cp.exec((String)"$dr.setMatchLayers(%s)", (Object[])new Object[]{matchLayerArgs.toString()});
            }
            Object object = !ReplaceDeviceUI.this.mCbRelocReplacement.isSelected() ? DeviceReplace.Reloc.NONE : (ReplaceDeviceUI.this.mRbRelocOrig.isSelected() ? DeviceReplace.Reloc.ORIG : (reloc = ReplaceDeviceUI.this.mRbRelocSimilar.isSelected() ? DeviceReplace.Reloc.SIMILAR : null));
            if (reloc != null) {
                Cp.exec((String)"$dr.setRelocateDevice(%s.%s)", (Object[])new Object[]{AReflection.getJavaClassName(DeviceReplace.Reloc.class), reloc.name()});
            }
            Cp.exec((String)"$dr.setRemoveOldDevice(%s)", (Object[])new Object[]{ReplaceDeviceUI.this.mCbRmOldDevice.isSelected()});
            Cp.exec((String)"$dr.setDeleteTemplateIfUnused(%s)", (Object[])new Object[]{ReplaceDeviceUI.this.mCbRmOldDevTemplate.isSelected()});
            Cp.exec((String)"$dr.setDeleteSubstrateIfUnused(%s)", (Object[])new Object[]{ReplaceDeviceUI.this.mCbRmOldSubstrate.isSelected()});
            Cp.exec((String)"$dr.setInheritOldChildren(%b)", (Object[])new Object[]{ReplaceDeviceUI.this.mCbInheritChildren.isSelected()});
            Cp.exec((String)"$dr.replace(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{ReplaceDeviceUI.this.mDevice.getKeyStr(), replDevice.getKeyStr()});
            Cp.exec((String)"unset(\"$dr\")", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
            DbExplorerPanel.refreshAll();
            UIUtil.closeWindow((Window)((Object)ReplaceDeviceUI.this));
        }
    };
    protected ActionListener mDeleteUpdateListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ReplaceDeviceUI.this.mCbRmOldDevTemplate.setEnabled(ReplaceDeviceUI.this.mCbRmOldDevice.isSelected());
            if (!ReplaceDeviceUI.this.mCbRmOldDevice.isSelected()) {
                ReplaceDeviceUI.this.mCbRmOldDevTemplate.setSelected(false);
            }
            ReplaceDeviceUI.this.mCbRmOldSubstrate.setEnabled(ReplaceDeviceUI.this.mCbRmOldDevTemplate.isSelected());
            if (!ReplaceDeviceUI.this.mCbRmOldDevTemplate.isSelected()) {
                ReplaceDeviceUI.this.mCbRmOldSubstrate.setSelected(false);
            }
        }
    };

    public static void showMe(Window owner, Device d, Device root) {
        ReplaceDeviceUI ui = new ReplaceDeviceUI(owner, d, root);
        ui.setVisible(true);
    }

    protected ReplaceDeviceUI(Window owner, Device d, Device root) {
        super(owner);
        this.mDevice = d;
        String title = "Replace Device";
        if (this.mDevice != null) {
            title = String.format("%s '%s'", title, this.mDevice.getName());
        }
        this.setTitle(title);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        l.pushFillAllRemainX("Replace with");
        this.mReplacementDeviceChooser = new DeviceChooser.DCPanel();
        this.mReplacementDeviceChooser.setDeviceListSupplier(db -> {
            List nextLevelChildren;
            List nonDescendants;
            List valids;
            Design dsn = Design.getDesign((Db)db);
            if (dsn == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            List<Object> nextLevelChildrenTemplates = new LinkedList<Object>();
            if (root == null) {
                nextLevelChildrenTemplates.add(dsn);
            } else {
                nextLevelChildrenTemplates.add(root.getTemplate());
                list.add(root);
            }
            while (!(valids = (nonDescendants = (nextLevelChildren = nextLevelChildrenTemplates.stream().flatMap(t -> t.getChildren().stream()).collect(Collectors.toList())).stream().filter(c -> c != this.mDevice && !this.mDevice.isMyDescendant(c)).collect(Collectors.toList())).stream().filter(c -> !c.isMyDescendant(this.mDevice)).collect(Collectors.toList())).isEmpty() || !nonDescendants.isEmpty()) {
                list.addAll(valids);
                nextLevelChildrenTemplates = nonDescendants.stream().map(Device::getTemplate).distinct().collect(Collectors.toList());
            }
            return list.parallelStream().sorted().collect(Collectors.toCollection(ArrayList::new));
        });
        this.mReplacementDeviceChooser.setDb(this.mDevice.getDb());
        l.add((Component)this.mReplacementDeviceChooser, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        this.mReplacementDeviceChooser.addDeviceListener(this.mSelectedReplacementDeviceListener);
        l.popNl();
        this.mPnlNetMapping = l.pushFillXRemainX("Net Map Updating");
        this.mRbByNetName.setToolTipText("For all nets on the new device, find the net (by name) on the old device and connect to the old parent net.");
        l.addNl((Component)this.mRbByNetName, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        this.mRbByPinConnection.setToolTipText("For all pins on the new device, find that pin (by name) on the old device and connect to the parent net that was connected to the old pin.");
        l.addNl((Component)this.mRbByPinConnection, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        this.mRbByPinLocation.setToolTipText("For all pins on the new device, find that pin (by location) on the old device and connect to the parent net that was connected to the old pin.");
        l.addNl((Component)this.mRbByPinLocation, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        this.mPnlLayerMapping = (LayerMappingPanel)l.addNl((Component)new LayerMappingPanel(d.getDb()), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.indent());
        this.mPnlLayerMapping.observeMappings().subscribe(v -> this.refreshLayerMappingControls());
        this.mRbNoMapping.setToolTipText("Do not reconnect nets between the new device and its parent.");
        l.addNl((Component)this.mRbNoMapping, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        l.popNl();
        AButtonGroup bgNetMapping = new AButtonGroup(this.mRbByNetName, this.mRbByPinConnection, this.mRbByPinLocation, this.mRbNoMapping);
        this.mRbByNetName.setSelected(true);
        l.pushFillXRemainX();
        GridBagManager.GridBagConstraintsEx csRb = GridBagManager.LEFT.insetVert(0);
        JPanel pnlRelocate = l.push((GridBagConstraints)GridBagManager.TOPLEFT);
        pnlRelocate.setBorder(new AComponentTitledBorder(this.mCbRelocReplacement, pnlRelocate));
        this.mCbRelocReplacement.setToolTipText("Relocate the replacement device");
        ((JRadioButton)l.addNl((Component)this.mRbRelocSimilar, (GridBagConstraints)csRb)).setToolTipText("Locate similar to the original device considering differences in the device templates");
        ((JRadioButton)l.add((Component)this.mRbRelocOrig, (GridBagConstraints)csRb)).setToolTipText("Use the location, rotation, mirror and flip of the original device (does not consider changes to the template)");
        AButtonGroup bgReloc = new AButtonGroup(this.mRbRelocSimilar, this.mRbRelocOrig);
        bgReloc.setSelected(this.mRbRelocSimilar.getModel(), true);
        this.mCbRelocReplacement.setSelected(true);
        l.pop();
        JPanel pnlDelete = l.push((GridBagConstraints)GridBagManager.TOPLEFT);
        pnlDelete.setBorder(new AComponentTitledBorder(this.mCbRmOldDevice, pnlDelete));
        l.addNl((Component)this.mCbRmOldDevTemplate, (GridBagConstraints)csRb);
        l.add((Component)this.mCbRmOldSubstrate, (GridBagConstraints)csRb);
        l.popNl();
        ((JCheckBox)l.add((Component)this.mCbInheritChildren, (GridBagConstraints)GridBagManager.LEFT.insetBottom(0))).setToolTipText("If selected, the replacement device will inherit all children of the device being replaced.");
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        l.add((Component)this.mBtnReplace, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mBtnCancel, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        l.pop();
        this.setPreferredSize(new Dimension(500, 650));
        this.setModal(true);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnReplace);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.verifyWindowOnScreen((Window)((Object)this));
        UIUtil.center((Component)((Object)this));
        this.mCbRmOldDevice.addActionListener(this.mDeleteUpdateListener);
        this.mCbRmOldDevTemplate.addActionListener(this.mDeleteUpdateListener);
        this.mCbRmOldSubstrate.addActionListener(this.mDeleteUpdateListener);
        bgNetMapping.getButtons().forEach(b -> b.addActionListener(e -> this.updateLayerMappingControls()));
        this.mCbRelocReplacement.addActionListener(e -> this.updateRelocOpts(pnlRelocate));
        this.mBtnReplace.addActionListener(this.mReplaceListener);
        this.mDeleteUpdateListener.actionPerformed(null);
        this.enableReplace();
        this.updateLayerMappingControls();
        this.updateRelocOpts(pnlRelocate);
        this.mPnlLayerMapping.setLeftLayers(this.mDevice.getSubstrate());
    }

    protected void updateLayerMappingControls() {
        boolean showLayerMapping;
        boolean bl = showLayerMapping = this.mRbByPinLocation.isSelected() && this.getReplacementDevice() != null && this.getReplacementDevice().getSubstrate() != this.mDevice.getSubstrate();
        if (showLayerMapping != this.mPnlLayerMapping.isVisible()) {
            this.mPnlLayerMapping.setVisible(showLayerMapping);
            this.getGlassPane().setVisible(showLayerMapping);
            GridBagLayout lo = (GridBagLayout)this.getContentPane().getLayout();
            GridBagConstraints c = lo.getConstraints(this.mPnlNetMapping);
            if (showLayerMapping) {
                c.fill = 1;
                c.weighty = 1.0;
            } else {
                c.fill = 2;
                c.weighty = 0.0;
            }
            lo.setConstraints(this.mPnlNetMapping, c);
            this.invalidate();
        }
        if (showLayerMapping) {
            this.refreshLayerMappingControls();
        }
    }

    protected void updateRelocOpts(JPanel pnlOpts) {
        AStream.of((Object[])pnlOpts.getComponents()).filter(comp -> comp != this.mCbRelocReplacement).forEach(comp -> comp.setEnabled(this.mCbRelocReplacement.isSelected()));
    }

    protected Device getReplacementDevice() {
        return this.mReplacementDeviceChooser.getSelectedDevice();
    }

    protected Substrate getReplacementSubstrate() {
        Device d = this.getReplacementDevice();
        return d == null ? null : d.getSubstrate();
    }

    protected void refreshLayerMappingControls() {
        if (this.mRefreshingLayerMappingControls) {
            return;
        }
        this.mRefreshingLayerMappingControls = true;
        try {
            this._refreshLayerMappingControls();
        }
        finally {
            this.mRefreshingLayerMappingControls = false;
        }
    }

    protected void _refreshLayerMappingControls() {
        boolean noCurLayers;
        Substrate replaceSubst = this.getReplacementSubstrate();
        boolean noReplaceLayers = replaceSubst == null || !replaceSubst.hasAtLeastOneLayer();
        Substrate curSubst = !this.mPnlLayerMapping.getRightLayers().findAny().isPresent() ? null : ((Layer)this.mPnlLayerMapping.getRightLayers().iterator().next()).getSubstrate();
        boolean bl = noCurLayers = curSubst == null || !curSubst.hasAtLeastOneLayer();
        if (replaceSubst == curSubst || noReplaceLayers && noCurLayers) {
            return;
        }
        this.mPnlLayerMapping.clearMappings();
        this.mPnlLayerMapping.setRightLayers(replaceSubst);
        CompareSubstrate.LayerMatcher matcher = new CompareSubstrate.LayerMatcher(this.mDevice.getSubstrate(), this.getReplacementSubstrate());
        for (Layer l : matcher.getMatched().keySet()) {
            this.mPnlLayerMapping.addMapping(l, (Layer)matcher.getMatched().get((Object)l));
        }
    }

    protected void enableReplace() {
        Device d = this.getReplacementDevice();
        this.mBtnReplace.setEnabled(d != null);
    }
}

