/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.ui.SimpleConstraintFrame;
import com.sigrity.orbit.ui.common.DeviceTree;
import com.sigrity.orbit.ui.wb_route.BondRingDefinitionEditDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class RouteConnectionDlg
extends ADialog {
    protected static RouteConnectionDlg mDlg = null;
    protected DeviceTree mDeviceTree;
    private JProgressBar mProgressMeter;
    protected SingleLayerRouter.LoadListener mListener;
    private Db mDb;
    private Design mDesign;
    protected DeviceTree.PopupMenuHandler mPopupMenuHandler = new DeviceTree.PopupMenuHandler(){

        @Override
        public void handlePopup(int x, int y) {
            DevicePath path = RouteConnectionDlg.this.getSelectedDevicePath();
            if (path != null) {
                RouteConnectionDlg.this.mPopupMenu.show(RouteConnectionDlg.this.mDeviceTree, x, y);
            }
        }
    };
    protected ActionListener mEditConstraints = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            DevicePath path = RouteConnectionDlg.this.getSelectedDevicePath();
            Device d = path.getLast();
            RuleEditDlg dlg = RuleEditDlg.createDialog((Window)((Object)RouteConnectionDlg.this), RouteConnectionDlg.this.mDb, d.getTemplate(), false);
            dlg.setVisible(true);
            UIUtil.closeWindow((Window)((Object)dlg));
        }
    };
    protected ActionListener mRouteConnection = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            DevicePath dp = RouteConnectionDlg.this.getSelectedDevicePath();
            if (dp == null) {
                ALog.logWarn((String)"Please select a substrate to be routed on.");
                return;
            }
            Device d = dp.getLast();
            if (d == null) {
                ALog.logWarn((String)"Please select a substrate to be routed on.");
                return;
            }
            DeviceTemplate dt = d.getTemplate();
            if (dt == null) {
                ALog.logWarn((String)"Please select a substrate to be routed on.");
                return;
            }
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouterInterface.routeSelectedConnections(\"%s\");", (Object[])new Object[]{dp});
        }
    };
    protected ActionListener mRemoveRoute = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            DevicePath dp = RouteConnectionDlg.this.getSelectedDevicePath();
            if (dp == null) {
                ALog.logWarn((String)"Please select a substrate to remove wires.");
                return;
            }
            Device d = dp.getLast();
            if (d == null) {
                ALog.logWarn((String)"Please select a substrate to remove wires.");
                return;
            }
            DeviceTemplate dt = d.getTemplate();
            if (dt == null) {
                ALog.logWarn((String)"Please select a substrate to remove wires.");
                return;
            }
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouterInterface.turnRoutesToSelectedConnections(\"%s\");", (Object[])new Object[]{dp});
        }
    };
    JPopupMenu mPopupMenu = new JPopupMenu(){
        protected Action mItemEditConstraints;
        protected Action mItemRouteConnection;
        protected Action mItemRemoveRoute;
        {
            this.mItemEditConstraints = this.add("Edit Constraints...", RouteConnectionDlg.this.mEditConstraints);
            this.mItemRouteConnection = this.add("Route Selected Connections", RouteConnectionDlg.this.mRouteConnection);
            this.mItemRemoveRoute = this.add("Turn Route Layer Wires to Selected Connections", RouteConnectionDlg.this.mRemoveRoute);
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            super.show(invoker, x, y);
        }

        protected void prepare(int x, int y) {
            boolean popup = RouteConnectionDlg.this.getSelectedDevicePath() != null && !RouteConnectionDlg.this.getSelectedDevicePath().isEmpty();
            this.mItemEditConstraints.setEnabled(popup);
            this.mItemRouteConnection.setEnabled(popup);
            this.mItemRemoveRoute.setEnabled(popup);
        }
    };

    public static void showMe(Frame owner) {
        if (mDlg != null && RouteConnectionDlg.mDlg.mDb == OrbitIO.getCurDb()) {
            mDlg.setVisible(true);
        } else {
            mDlg = new RouteConnectionDlg(owner);
        }
    }

    private RouteConnectionDlg(Frame owner) {
        super(owner);
        this.setTitle("Route Connections");
        this.setDefaultCloseOperation(2);
        GridBagManager gb = new GridBagManager((Container)((Object)this));
        JLabel label1 = new JLabel("Route Selected Connections on ");
        gb.add((Component)label1, (GridBagConstraints)GridBagManager.LEFT);
        gb.newline();
        this.mDb = OrbitIO.getCurDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
        this.mDeviceTree = new DeviceTree(this.mDesign);
        this.mDeviceTree.setPopupMenuHandler(this.mPopupMenuHandler);
        JScrollPane scrollDeviceTree = new JScrollPane(this.mDeviceTree);
        scrollDeviceTree.setBorder(BorderFactory.createTitledBorder("New Parent:"));
        gb.add((Component)scrollDeviceTree, (GridBagConstraints)GridBagManager.FILLALL);
        gb.newline();
        this.mProgressMeter = new JProgressBar(0, 100);
        this.mProgressMeter.setStringPainted(true);
        gb.add((Component)this.mProgressMeter, (GridBagConstraints)GridBagManager.FILLX);
        gb.newline();
        this.mListener = new SingleLayerRouter.LoadListener(){

            @Override
            public void stats(int percent, boolean done, String data) {
                if (done) {
                    percent = 100;
                }
                RouteConnectionDlg.this.mProgressMeter.setValue(percent);
                Object s = done ? data : percent + "% " + data;
                RouteConnectionDlg.this.mProgressMeter.setString((String)s);
                Dimension d = RouteConnectionDlg.this.mProgressMeter.getSize();
                RouteConnectionDlg.this.mProgressMeter.paintImmediately(0, 0, d.width, d.height);
                if (done) {
                    OrbitIO.getApp().zoomFitCurrentView();
                }
            }
        };
        SingleLayerRouter.addLoadListener(this.mListener);
        gb.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UIUtil.closeWindow((Window)((Object)RouteConnectionDlg.this));
            }
        });
        gb.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        gb.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.setVisible(true);
    }

    protected DevicePath getSelectedDevicePath() {
        if (this.mDeviceTree.getModel().getRoot() == null) {
            assert (false);
            return null;
        }
        if (this.mDeviceTree.getSelectionCount() == 0) {
            this.mDeviceTree.setSelectionRow(0);
        }
        TreePath selPath = this.mDeviceTree.getSelectionPath();
        return this.devicePathFromTreePath(selPath);
    }

    protected DevicePath devicePathFromTreePath(TreePath tp) {
        LinkedList<Device> path = new LinkedList<Device>();
        for (Object o : tp.getPath()) {
            if (o instanceof DeviceTree.RootNode) continue;
            if (o instanceof DeviceTree.DeviceNode) {
                path.add(((DeviceTree.DeviceNode)((Object)o)).getDevice());
                continue;
            }
            assert (false);
        }
        return DevicePath.fromList(path);
    }

    public static class RuleEditDlg
    extends ADialog {
        protected AAppView mView;
        protected Personality mPersonality = null;
        protected DeviceTemplate mDeviceTemplate = null;
        protected JTextField mTxtName;
        protected AColorIcon mIconColor = new AColorIcon(16, 16, this.getBackground());
        protected boolean mAccepted = false;
        protected SimpleConstraintFrame mConstraintFrame;
        protected boolean mSaveOnlyChanged;
        protected ActionListener mChangeColor = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)this), "Select Color", mIconColor.getColor());
                ccd.setShowOpacity(true);
                Color c = ccd.doModal();
                if (c != null) {
                    mIconColor.setColor(c);
                }
            }
        };
        protected ActionListener mOk = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.saveConstraints();
                UIUtil.closeWindow((Window)((Object)this));
            }
        };
        protected ActionListener mApply = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.saveConstraints();
            }
        };

        public static RuleEditDlg createDialog(Window owner, Db db, DeviceTemplate devTemp, boolean saveOnlyChanged) {
            RuleEditDlg dlg = null;
            dlg = new RuleEditDlg(owner);
            dlg.setTitle("Route Constraints");
            dlg.init(db, devTemp, saveOnlyChanged);
            return dlg;
        }

        @Deprecated
        public static RuleEditDlg createDialog(Window owner, Db db, Substrate substrate, boolean saveOnlyChanged) {
            RuleEditDlg dlg = null;
            dlg = new RuleEditDlg(owner);
            dlg.setTitle("Route Constraints");
            dlg.init(db, (DeviceTemplate)substrate.getDeviceTemplates().next(), saveOnlyChanged);
            return dlg;
        }

        public RuleEditDlg(Window owner) throws HeadlessException {
            super(owner);
            this.setRecallBounds(false);
        }

        public boolean getAccepted() {
            return this.mAccepted;
        }

        public String getPersonalityName() {
            return this.mTxtName.getText();
        }

        public Color getPersonalityColor() {
            return this.mIconColor.getColor();
        }

        protected void init(Db db, DeviceTemplate devTemp, boolean saveOnlyChanged) {
            this.mView = OrbitIO.getCurView();
            this.mSaveOnlyChanged = saveOnlyChanged;
            this.mDeviceTemplate = devTemp;
            if (!this.setPersonality(db)) {
                return;
            }
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            Border etch = BorderFactory.createEtchedBorder();
            JPanel basicPanel = new JPanel();
            basicPanel.setBorder(BorderFactory.createTitledBorder(etch, "Personality of " + this.mDeviceTemplate.getName()));
            l.push((Container)basicPanel, (GridBagConstraints)GridBagManager.LEFT);
            l.add("Name:");
            this.mTxtName = new JTextField(10);
            l.add((Component)this.mTxtName, (GridBagConstraints)GridBagManager.FILLX);
            l.pop();
            l.newline();
            Constraint.DescriptorList descList = new Constraint.DescriptorList();
            descList.add((Object)Constraint.WIRE_WIDTH);
            descList.add((Object)Constraint.WIRE_CLEAR);
            descList.add((Object)Constraint.ROUTE_LAYER);
            descList.add((Object)Constraint.ROUTE_ANGLE);
            descList.add((Object)Constraint.PIN_EXIT_LENGTH);
            descList.add((Object)Constraint.ROUTE_STRATEGY);
            descList.add((Object)Constraint.ROUTING_GRID);
            descList.add((Object)Constraint.ANIMATION);
            this.mConstraintFrame = new SimpleConstraintFrame(descList, (DbObject)this.mPersonality, devTemp.getSubstrate(), BondRingDefinitionEditDlg.BondRingDialogType.Edit);
            this.mConstraintFrame.setOpaque(true);
            l.add((Component)this.mConstraintFrame, (GridBagConstraints)GridBagManager.FILLY);
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton btnApply = new JButton("Apply");
            l.add((Component)btnApply, (GridBagConstraints)GridBagManager.RIGHT);
            btnApply.addActionListener(this.mApply);
            JButton btnOk = new JButton("OK");
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(this.mOk);
            JButton btnClose = new JButton("Cancel");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.updateUI();
        }

        protected boolean setPersonality(Db db) {
            String personalityName = "SIP_Placement";
            this.mPersonality = Personality.getPersonality((DeviceTemplate)this.mDeviceTemplate, (Personality.Type)Personality.Type.DEVICE, (String)personalityName).orElse(null);
            if (this.mPersonality == null) {
                String templateKeyStr = this.mDeviceTemplate.getKeyStr();
                Personality personality = (Personality)Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.addPersonality(\"%s\", com.sigrity.acl.db.std.Personality.Type.DEVICE, \"%s\", \"%s\")", (Object[])new Object[]{personalityName, templateKeyStr, AUtil.colorToString((Color)this.getPersonalityColor())});
                if (personality == null) {
                    return false;
                }
                this.mPersonality = personality;
            }
            return true;
        }

        protected void updateUI() {
            this.mTxtName.setText(this.mPersonality.getName());
            this.mTxtName.setEnabled(false);
        }

        private void saveConstraints() {
            try {
                AFieldValidator.validateText((JTextComponent)this.mTxtName);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            this.mConstraintFrame.doSave((DbObject)this.mPersonality, this.mDeviceTemplate.getSubstrate(), this.mSaveOnlyChanged);
            this.mAccepted = true;
        }
    }
}

