/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.ColumnsAutoSizer;
import com.sigrity.orbit.ui.RatioSpecificationDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class RulesRatioPanel
extends JPanel {
    protected static Db mDb = null;
    protected SelectionContext mSelCtx;
    protected static RulesRatioListener mListener = null;
    protected JTable mTable;
    protected TableModel mTableModel = null;
    protected JScrollPane mScroller = null;
    protected TableCellRenderer mCellRenderer = null;
    protected int mColumnWidth = 1;
    protected int mDesireWidth = 16;
    protected int mDesiredHeight = 600;
    protected ColumnsAutoSizer mColSizer = ColumnsAutoSizer.create().setDistributeExcessToLastCol(true);
    static DbObject initObj1 = null;
    static DbObject initObj2 = null;
    static int initVal1 = -1;
    static int initVal2 = -1;
    static double initTolerance = 0.0;

    protected String getRequiredText(int row) {
        return mListener.getRatioNumerator(row) + " : " + mListener.getRatioDenominator(row);
    }

    public RulesRatioPanel(Db db, RulesRatioListener listener) {
        this.init(db, listener);
    }

    protected void init(Db db, RulesRatioListener listener) {
        GridBagManager l = GridBagManager.layout((Container)this);
        mDb = db;
        mListener = listener;
        this.mSelCtx = SelectionContext.create((Db)db);
        this.mTable = new JTable();
        JTableHeader jth = this.mTable.getTableHeader();
        this.mCellRenderer = jth.getDefaultRenderer();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        this.mColumnWidth = metrics.charWidth('m');
        this.mTable.setFillsViewportHeight(true);
        this.mTable.setAutoResizeMode(0);
        this.mTableModel = new TableModel();
        this.mTable.setModel(this.mTableModel);
        this.mTable.setRowSelectionAllowed(true);
        this.mTable.setColumnSelectionAllowed(false);
        this.mTable.setSelectionMode(2);
        this.mTable.setDefaultRenderer(Object.class, new RulesRatioTableCellRenderer());
        this.mTable.getColumnModel().getColumn(0).setHeaderValue("Pair");
        this.mTable.getColumnModel().getColumn(1).setHeaderValue("Required");
        this.mTable.getColumnModel().getColumn(2).setHeaderValue("Actual");
        this.mScroller = new JScrollPane(this.mTable);
        this.mScroller.setHorizontalScrollBarPolicy(30);
        this.mScroller.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                RulesRatioPanel.this.mColSizer.distributeExcessToLastCol(RulesRatioPanel.this.mTable);
            }
        });
        l.add((Component)this.mScroller, (GridBagConstraints)GridBagManager.FILLALL);
        this.installPopupMenu();
    }

    public void refresh() {
        this.mColSizer.sizeColumnsToFit(this.mTable);
        this.mTable.repaint();
    }

    protected void installPopupMenu() {
        class ButtonMouseListener
        extends MouseAdapter {
            JPopupMenu popup;

            protected void showPopup(MouseEvent e) {
                int row = RulesRatioPanel.this.mTable.rowAtPoint(e.getPoint());
                this.popup = new JPopupMenu();
                this.popup.add(new ActionAddItem(RulesRatioPanel.this.mTable));
                if (row >= 0) {
                    this.popup.add(new ActionEditItem(RulesRatioPanel.this.mTable, row));
                    this.popup.add(new ActionDeleteRow(RulesRatioPanel.this.mTable, row));
                    this.popup.add(new ActionDeleteAll(RulesRatioPanel.this.mTable));
                    if (mListener.enableCopyPaste()) {
                        this.popup.add(new ActionCopyItems());
                    }
                }
                if (mListener.enableCopyPaste() && mListener.getPasteObject1s() != null) {
                    this.popup.add(new ActionPasteItems());
                }
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }
        }
        this.mTable.addMouseListener(new ButtonMouseListener());
    }

    protected class ActionPasteItems
    extends AbstractAction {
        public ActionPasteItems() {
            super("Paste");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<DbObject> objs1 = mListener.getPasteObject1s();
            List<DbObject> objs2 = mListener.getPasteObject2s();
            List<Integer> nums = mListener.getNums();
            List<Integer> dems = mListener.getDems();
            List<Double> tols = mListener.getTols();
            for (int i = 0; i < objs1.size(); ++i) {
                DbObject obj1 = objs1.get(i);
                DbObject obj2 = objs2.get(i);
                Integer num = nums.get(i);
                Integer dem = dems.get(i);
                Double tol = tols.get(i);
                mListener.setRatio(obj1, obj2, num, dem, tol);
            }
            RulesRatioPanel.this.mColSizer.sizeColumnsToFit(RulesRatioPanel.this.mTable);
            RulesRatioPanel.this.mTable.repaint();
        }
    }

    protected class ActionCopyItems
    extends AbstractAction {
        public ActionCopyItems() {
            super("Copy picked");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objInds = RulesRatioPanel.this.mTable.getSelectedRows();
            ArrayList<DbObject> obj1List = new ArrayList<DbObject>();
            ArrayList<DbObject> obj2List = new ArrayList<DbObject>();
            ArrayList<Integer> numList = new ArrayList<Integer>();
            ArrayList<Integer> demList = new ArrayList<Integer>();
            ArrayList<Double> tolList = new ArrayList<Double>();
            for (int i : objInds) {
                obj1List.add(mListener.getDbObject1(i));
                obj2List.add(mListener.getDbObject2(i));
                numList.add(mListener.getRatioNumerator(i));
                demList.add(mListener.getRatioDenominator(i));
                tolList.add(mListener.getTolerance(i));
            }
            mListener.copyObjects(obj1List, obj2List, numList, demList, tolList);
        }
    }

    protected class ActionDeleteAll
    extends AbstractAction {
        JTable mTable;

        public ActionDeleteAll(JTable table) {
            super("Delete all");
            this.mTable = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = mListener.getNumRatios() - 1; i >= 0; --i) {
                mListener.removeRatio(i);
            }
            this.mTable.repaint();
        }
    }

    protected class ActionDeleteRow
    extends AbstractAction {
        int row;
        JTable mTable;

        public ActionDeleteRow(JTable table, int r) {
            super("Delete Ratio");
            this.row = 0;
            this.row = r;
            this.mTable = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mListener.removeRatio(this.row);
            RulesRatioPanel.this.mColSizer.sizeColumnsToFit(this.mTable);
            this.mTable.repaint();
        }
    }

    private static class RatioSpecificationAdapter
    implements RatioSpecificationDlg.RatioSpecificationListener {
        private RatioSpecificationAdapter() {
        }

        @Override
        public String getTitle() {
            return mListener.getTitle();
        }

        @Override
        public List<DbObject> getList() {
            return mListener.getList();
        }

        @Override
        public String getText(DbObject obj) {
            return mListener.getText(obj);
        }

        @Override
        public Icon getIcon(DbObject obj) {
            return mListener.getIcon(obj);
        }

        @Override
        public void doOk(DbObject obj1, DbObject obj2, int r1, int r2, double tolerance) {
            mListener.setRatio(obj1, obj2, r1, r2, tolerance);
        }

        @Override
        public DbObject getItem1InitValue() {
            return initObj1;
        }

        @Override
        public DbObject getItem2InitValue() {
            return initObj2;
        }

        @Override
        public int getValue1InitValue() {
            return initVal1;
        }

        @Override
        public int getValue2InitValue() {
            return initVal2;
        }

        @Override
        public double getToleranceInitValue() {
            return initTolerance;
        }
    }

    protected class ActionEditItem
    extends AbstractAction {
        JTable mTable;
        int row;

        public ActionEditItem(JTable table, int r) {
            super("Edit...");
            this.row = 0;
            this.mTable = table;
            this.row = r;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            initObj1 = mListener.getDbObject1(this.row);
            initObj2 = mListener.getDbObject2(this.row);
            initVal1 = mListener.getRatioNumerator(this.row);
            initVal2 = mListener.getRatioDenominator(this.row);
            initTolerance = mListener.getTolerance(this.row);
            RatioSpecificationDlg.createDialog(OrbitIO.getMainWindow(), mDb, new RatioSpecificationAdapter());
            RulesRatioPanel.this.mColSizer.sizeColumnsToFit(this.mTable);
            this.mTable.repaint();
        }
    }

    protected class ActionAddItem
    extends AbstractAction {
        JTable mTable;

        public ActionAddItem(JTable table) {
            super("Add...");
            this.mTable = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            initObj1 = null;
            initObj2 = null;
            initVal1 = -1;
            initVal2 = -1;
            initTolerance = 0.0;
            RatioSpecificationDlg.createDialog(OrbitIO.getMainWindow(), mDb, new RatioSpecificationAdapter());
            RulesRatioPanel.this.mColSizer.sizeColumnsToFit(this.mTable);
            this.mTable.repaint();
        }
    }

    public class RulesRatioTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            this.setIcon(null);
            this.setText(null);
            this.setForeground(Color.black);
            if (isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            this.setToolTipText("");
            switch (column) {
                case 0: {
                    this.setText(mListener.getPairText(row));
                    break;
                }
                case 1: {
                    this.setText(RulesRatioPanel.this.getRequiredText(row));
                    break;
                }
                default: {
                    if (mListener.getBackgroundColor(row, column) != null) {
                        this.setBackground(mListener.getBackgroundColor(row, column));
                    }
                    this.setText(mListener.getActualText(row));
                }
            }
            return this;
        }
    }

    class TableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public int getRowCount() {
            return mListener.getNumRatios();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return mListener.getPairText(rowIndex);
                }
                case 1: {
                    return RulesRatioPanel.this.getRequiredText(rowIndex);
                }
            }
            return mListener.getActualText(rowIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Pair";
                }
                case 1: {
                    return "Required";
                }
            }
            return "Actual";
        }
    }

    public static interface RulesRatioListener {
        public String getTitle();

        public List<DbObject> getList();

        public String getText(DbObject var1);

        public Icon getIcon(DbObject var1);

        public int getNumRatios();

        public String getPairText(int var1);

        public Color getBackgroundColor(int var1, int var2);

        public DbObject getDbObject1(int var1);

        public DbObject getDbObject2(int var1);

        public int getRatioNumerator(int var1);

        public int getRatioDenominator(int var1);

        public double getTolerance(int var1);

        public String getActualText(int var1);

        public void removeRatio(int var1);

        public void setRatio(DbObject var1, DbObject var2, int var3, int var4, double var5);

        public boolean enableCopyPaste();

        public void copyObjects(List<DbObject> var1, List<DbObject> var2, List<Integer> var3, List<Integer> var4, List<Double> var5);

        public List<DbObject> getPasteObject1s();

        public List<DbObject> getPasteObject2s();

        public List<Integer> getNums();

        public List<Integer> getDems();

        public List<Double> getTols();
    }
}

