/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Scribe;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.ui.DeviceTemplateUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScribePanelUI
extends JPanel {
    protected Design mDesign = null;
    protected JLabel mNorthLabel = null;
    protected JLabel mSouthLabel = null;
    protected JLabel mEastLabel = null;
    protected JLabel mWestLabel = null;
    protected JTextField mNorthScribe = null;
    protected JTextField mSouthScribe = null;
    protected JTextField mEastScribe = null;
    protected JTextField mWestScribe = null;
    protected FocusListener mScribeChangeListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            if (ScribePanelUI.this.mNorthScribe.getText().length() != 0 && ScribePanelUI.this.mSouthScribe.getText().length() == 0 && ScribePanelUI.this.mEastScribe.getText().length() == 0 && ScribePanelUI.this.mWestScribe.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)ScribePanelUI.this.mNorthScribe);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                ScribePanelUI.this.mSouthScribe.setText(ScribePanelUI.this.mNorthScribe.getText());
                ScribePanelUI.this.mEastScribe.setText(ScribePanelUI.this.mNorthScribe.getText());
                ScribePanelUI.this.mWestScribe.setText(ScribePanelUI.this.mNorthScribe.getText());
            } else if (ScribePanelUI.this.mSouthScribe.getText().length() != 0 && ScribePanelUI.this.mNorthScribe.getText().length() == 0 && ScribePanelUI.this.mEastScribe.getText().length() == 0 && ScribePanelUI.this.mWestScribe.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)ScribePanelUI.this.mSouthScribe);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                ScribePanelUI.this.mNorthScribe.setText(ScribePanelUI.this.mSouthScribe.getText());
                ScribePanelUI.this.mEastScribe.setText(ScribePanelUI.this.mSouthScribe.getText());
                ScribePanelUI.this.mWestScribe.setText(ScribePanelUI.this.mSouthScribe.getText());
            } else if (ScribePanelUI.this.mEastScribe.getText().length() != 0 && ScribePanelUI.this.mNorthScribe.getText().length() == 0 && ScribePanelUI.this.mSouthScribe.getText().length() == 0 && ScribePanelUI.this.mWestScribe.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)ScribePanelUI.this.mEastScribe);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                ScribePanelUI.this.mNorthScribe.setText(ScribePanelUI.this.mEastScribe.getText());
                ScribePanelUI.this.mSouthScribe.setText(ScribePanelUI.this.mEastScribe.getText());
                ScribePanelUI.this.mWestScribe.setText(ScribePanelUI.this.mEastScribe.getText());
            } else if (ScribePanelUI.this.mWestScribe.getText().length() != 0 && ScribePanelUI.this.mNorthScribe.getText().length() == 0 && ScribePanelUI.this.mEastScribe.getText().length() == 0 && ScribePanelUI.this.mSouthScribe.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)ScribePanelUI.this.mWestScribe);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                ScribePanelUI.this.mNorthScribe.setText(ScribePanelUI.this.mWestScribe.getText());
                ScribePanelUI.this.mEastScribe.setText(ScribePanelUI.this.mWestScribe.getText());
                ScribePanelUI.this.mSouthScribe.setText(ScribePanelUI.this.mWestScribe.getText());
            }
        }
    };

    public ScribePanelUI(Design design) {
        this.init(design);
    }

    private void init(Design design) {
        this.mDesign = design;
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mNorthLabel = l.add("North scribe :", (GridBagConstraints)GridBagManager.LEFT);
        this.mNorthLabel.setToolTipText("Scribe line width on North side of die when oriented face-up without any rotation.");
        this.mNorthScribe = new JTextField("", 10);
        l.add((Component)this.mNorthScribe, (GridBagConstraints)GridBagManager.LEFT);
        this.mNorthScribe.addFocusListener(this.mScribeChangeListener);
        l.newline();
        this.mSouthLabel = l.add("South scribe :", (GridBagConstraints)GridBagManager.LEFT);
        this.mSouthLabel.setToolTipText("Scribe line width on South side of die when oriented face-up without any rotation.");
        this.mSouthScribe = new JTextField("", 10);
        l.add((Component)this.mSouthScribe, (GridBagConstraints)GridBagManager.LEFT);
        this.mSouthScribe.addFocusListener(this.mScribeChangeListener);
        l.newline();
        this.mEastLabel = l.add("East scribe :", (GridBagConstraints)GridBagManager.LEFT);
        this.mEastLabel.setToolTipText("Scribe line width on East side of die when oriented face-up without any rotation.");
        this.mEastScribe = new JTextField("", 10);
        l.add((Component)this.mEastScribe, (GridBagConstraints)GridBagManager.LEFT);
        this.mEastScribe.addFocusListener(this.mScribeChangeListener);
        l.newline();
        this.mWestLabel = l.add("West scribe :", (GridBagConstraints)GridBagManager.LEFT);
        this.mWestLabel.setToolTipText("Scribe line width on West side of die when oriented face-up without any rotation.");
        this.mWestScribe = new JTextField("", 10);
        this.mWestScribe.addFocusListener(this.mScribeChangeListener);
        l.add((Component)this.mWestScribe, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.newline();
        l.addFillY();
    }

    public Unit getUnitDist() {
        return this.mDesign == null ? Design.getDefaultUnitDist() : this.mDesign.getUnit();
    }

    protected String formatUserDist(long v) {
        return this.getUnitDist().toUserStr(v);
    }

    public void initValues(Scribe scribe) {
        this.mNorthScribe.setText(this.formatUserDist(scribe.getNorth()));
        this.mSouthScribe.setText(this.formatUserDist(scribe.getSouth()));
        this.mEastScribe.setText(this.formatUserDist(scribe.getEast()));
        this.mWestScribe.setText(this.formatUserDist(scribe.getWest()));
    }

    public void setContentsEnabled(boolean flag) {
        this.mNorthLabel.setEnabled(flag);
        this.mSouthLabel.setEnabled(flag);
        this.mEastLabel.setEnabled(flag);
        this.mWestLabel.setEnabled(flag);
        this.mNorthScribe.setEnabled(flag);
        this.mSouthScribe.setEnabled(flag);
        this.mEastScribe.setEnabled(flag);
        this.mWestScribe.setEnabled(flag);
    }

    public void setContentsVisible(boolean flag) {
        this.mNorthLabel.setVisible(flag);
        this.mSouthLabel.setVisible(flag);
        this.mEastLabel.setVisible(flag);
        this.mWestLabel.setVisible(flag);
        this.mNorthScribe.setVisible(flag);
        this.mSouthScribe.setVisible(flag);
        this.mEastScribe.setVisible(flag);
        this.mWestScribe.setVisible(flag);
    }

    public boolean validateFields() {
        try {
            AFieldValidator.validateDouble((JTextField)this.mNorthScribe);
            AFieldValidator.validateDouble((JTextField)this.mSouthScribe);
            AFieldValidator.validateDouble((JTextField)this.mEastScribe);
            AFieldValidator.validateDouble((JTextField)this.mWestScribe);
        }
        catch (AFieldValidator.AFieldValidationException fve) {
            return false;
        }
        return true;
    }

    public void updateDB(boolean enabled, DeviceTemplate dt) {
        long north = this.getNorthScribe();
        long south = this.getSouthScribe();
        long east = this.getEastScribe();
        long west = this.getWestScribe();
        Cp.exec((String)"%s.updateScribe(curDb(), \"%s\", %b, %dL, %dL, %dL, %dL)", (Object[])new Object[]{DeviceTemplateUI.class.getName(), dt.getKeyStr(), enabled, north, south, east, west});
    }

    public long getNorthScribe() {
        return this.getScribe(this.mNorthScribe);
    }

    public long getSouthScribe() {
        return this.getScribe(this.mSouthScribe);
    }

    public long getEastScribe() {
        return this.getScribe(this.mEastScribe);
    }

    public long getWestScribe() {
        return this.getScribe(this.mWestScribe);
    }

    private Long getScribe(JTextField scribeTxtField) {
        return this.getUnitDist().fromUserString(scribeTxtField.getText());
    }
}

