/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.SealRing;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.ui.DeviceTemplateUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SealRingPanelUI
extends JPanel {
    protected Design mDesign = null;
    protected JLabel mNorthLabel = null;
    protected JLabel mSouthLabel = null;
    protected JLabel mEastLabel = null;
    protected JLabel mWestLabel = null;
    protected JTextField mNorthRing = null;
    protected JTextField mSouthRing = null;
    protected JTextField mEastRing = null;
    protected JTextField mWestRing = null;
    protected FocusListener mRingChangeListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            if (SealRingPanelUI.this.mNorthRing.getText().length() != 0 && SealRingPanelUI.this.mSouthRing.getText().length() == 0 && SealRingPanelUI.this.mEastRing.getText().length() == 0 && SealRingPanelUI.this.mWestRing.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)SealRingPanelUI.this.mNorthRing);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                SealRingPanelUI.this.mSouthRing.setText(SealRingPanelUI.this.mNorthRing.getText());
                SealRingPanelUI.this.mEastRing.setText(SealRingPanelUI.this.mNorthRing.getText());
                SealRingPanelUI.this.mWestRing.setText(SealRingPanelUI.this.mNorthRing.getText());
            } else if (SealRingPanelUI.this.mSouthRing.getText().length() != 0 && SealRingPanelUI.this.mNorthRing.getText().length() == 0 && SealRingPanelUI.this.mEastRing.getText().length() == 0 && SealRingPanelUI.this.mWestRing.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)SealRingPanelUI.this.mSouthRing);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                SealRingPanelUI.this.mNorthRing.setText(SealRingPanelUI.this.mSouthRing.getText());
                SealRingPanelUI.this.mEastRing.setText(SealRingPanelUI.this.mSouthRing.getText());
                SealRingPanelUI.this.mWestRing.setText(SealRingPanelUI.this.mSouthRing.getText());
            } else if (SealRingPanelUI.this.mEastRing.getText().length() != 0 && SealRingPanelUI.this.mNorthRing.getText().length() == 0 && SealRingPanelUI.this.mSouthRing.getText().length() == 0 && SealRingPanelUI.this.mWestRing.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)SealRingPanelUI.this.mEastRing);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                SealRingPanelUI.this.mNorthRing.setText(SealRingPanelUI.this.mEastRing.getText());
                SealRingPanelUI.this.mSouthRing.setText(SealRingPanelUI.this.mEastRing.getText());
                SealRingPanelUI.this.mWestRing.setText(SealRingPanelUI.this.mEastRing.getText());
            } else if (SealRingPanelUI.this.mWestRing.getText().length() != 0 && SealRingPanelUI.this.mNorthRing.getText().length() == 0 && SealRingPanelUI.this.mEastRing.getText().length() == 0 && SealRingPanelUI.this.mSouthRing.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)SealRingPanelUI.this.mWestRing);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                SealRingPanelUI.this.mNorthRing.setText(SealRingPanelUI.this.mWestRing.getText());
                SealRingPanelUI.this.mEastRing.setText(SealRingPanelUI.this.mWestRing.getText());
                SealRingPanelUI.this.mSouthRing.setText(SealRingPanelUI.this.mWestRing.getText());
            }
        }
    };

    public SealRingPanelUI(Design design) {
        this.init(design);
    }

    private void init(Design design) {
        this.mDesign = design;
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mNorthLabel = l.add("North ring :", (GridBagConstraints)GridBagManager.LEFT);
        this.mNorthLabel.setToolTipText("Ring line width on North side of die when oriented face-up without any rotation.");
        this.mNorthRing = new JTextField("", 10);
        l.add((Component)this.mNorthRing, (GridBagConstraints)GridBagManager.LEFT);
        this.mNorthRing.addFocusListener(this.mRingChangeListener);
        l.newline();
        this.mSouthLabel = l.add("South ring :", (GridBagConstraints)GridBagManager.LEFT);
        this.mSouthLabel.setToolTipText("Ring line width on South side of die when oriented face-up without any rotation.");
        this.mSouthRing = new JTextField("", 10);
        l.add((Component)this.mSouthRing, (GridBagConstraints)GridBagManager.LEFT);
        this.mSouthRing.addFocusListener(this.mRingChangeListener);
        l.newline();
        this.mEastLabel = l.add("East ring :", (GridBagConstraints)GridBagManager.LEFT);
        this.mEastLabel.setToolTipText("Ring line width on East side of die when oriented face-up without any rotation.");
        this.mEastRing = new JTextField("", 10);
        l.add((Component)this.mEastRing, (GridBagConstraints)GridBagManager.LEFT);
        this.mEastRing.addFocusListener(this.mRingChangeListener);
        l.newline();
        this.mWestLabel = l.add("West ring :", (GridBagConstraints)GridBagManager.LEFT);
        this.mWestLabel.setToolTipText("Ring line width on West side of die when oriented face-up without any rotation.");
        this.mWestRing = new JTextField("", 10);
        this.mWestRing.addFocusListener(this.mRingChangeListener);
        l.add((Component)this.mWestRing, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
    }

    public Unit getUnitDist() {
        return this.mDesign == null ? Design.getDefaultUnitDist() : this.mDesign.getUnit();
    }

    protected String formatUserDist(long v) {
        return this.getUnitDist().toUserStr(v);
    }

    public void initValues(SealRing ring) {
        this.mNorthRing.setText(this.formatUserDist(ring.getNorth()));
        this.mSouthRing.setText(this.formatUserDist(ring.getSouth()));
        this.mEastRing.setText(this.formatUserDist(ring.getEast()));
        this.mWestRing.setText(this.formatUserDist(ring.getWest()));
    }

    public void setContentsEnabled(boolean flag) {
        this.mNorthLabel.setEnabled(flag);
        this.mSouthLabel.setEnabled(flag);
        this.mEastLabel.setEnabled(flag);
        this.mWestLabel.setEnabled(flag);
        this.mNorthRing.setEnabled(flag);
        this.mSouthRing.setEnabled(flag);
        this.mEastRing.setEnabled(flag);
        this.mWestRing.setEnabled(flag);
    }

    public void setContentsVisible(boolean flag) {
        this.mNorthLabel.setVisible(flag);
        this.mSouthLabel.setVisible(flag);
        this.mEastLabel.setVisible(flag);
        this.mWestLabel.setVisible(flag);
        this.mNorthRing.setVisible(flag);
        this.mSouthRing.setVisible(flag);
        this.mEastRing.setVisible(flag);
        this.mWestRing.setVisible(flag);
    }

    public boolean validateFields() {
        try {
            AFieldValidator.validateDouble((JTextField)this.mNorthRing);
            AFieldValidator.validateDouble((JTextField)this.mSouthRing);
            AFieldValidator.validateDouble((JTextField)this.mEastRing);
            AFieldValidator.validateDouble((JTextField)this.mWestRing);
        }
        catch (AFieldValidator.AFieldValidationException fve) {
            return false;
        }
        return true;
    }

    public void updateDB(boolean enabled, DeviceTemplate dt) {
        long north = this.getNorthRing();
        long south = this.getSouthRing();
        long east = this.getEastRing();
        long west = this.getWestRing();
        Cp.exec((String)"%s.updateSealRing(curDb(), \"%s\", %b, %dL, %dL, %dL, %dL)", (Object[])new Object[]{DeviceTemplateUI.class.getName(), dt.getKeyStr(), enabled, north, south, east, west});
    }

    public long getNorthRing() {
        return this.getRing(this.mNorthRing);
    }

    public long getSouthRing() {
        return this.getRing(this.mSouthRing);
    }

    public long getEastRing() {
        return this.getRing(this.mEastRing);
    }

    public long getWestRing() {
        return this.getRing(this.mWestRing);
    }

    private Long getRing(JTextField ringTxtField) {
        return this.getUnitDist().fromUserString(ringTxtField.getText());
    }
}

