/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AImageUtil;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.SelectionCriteria;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AImageIcon;
import com.sigrity.acl.ui.ASelectIconDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class SelectionCriteriaUI {
    public static final Dimension IconSize = new Dimension(16, 16);

    public static class SelectionCriteriaListCellRenderer
    extends DefaultListCellRenderer {
        protected Font mFontNormal = null;
        protected Font mFontDefCriteria = null;

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean sel, boolean focus) {
            super.getListCellRendererComponent(list, val, idx, sel, focus);
            if (this.mFontNormal == null) {
                this.mFontNormal = this.getFont();
                this.mFontDefCriteria = this.mFontNormal.deriveFont(1);
            }
            if (val instanceof SelectionCriteria) {
                SelectionCriteria sc = (SelectionCriteria)val;
                this.setText(sc.getName());
                this.setIcon(sc.getIconSmall());
                String className = sc.getReferenceClass();
                boolean isDefault = false;
                try {
                    Class<?> cls = Class.forName(className);
                    className = cls.getSimpleName();
                    UUID defId = SelectionCriteria.getDefault(cls).map(d -> d.getId()).orElse(null);
                    if (sc.getId().equals(defId)) {
                        isDefault = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (isDefault) {
                    this.setFont(this.mFontDefCriteria);
                    this.setToolTipText(String.format("Default criteria for %s selection.", className));
                } else {
                    this.setFont(this.mFontNormal);
                    this.setToolTipText(String.format("Criteria for %s selection.", className));
                }
            }
            return this;
        }
    }

    public static class DefaultsDialog
    extends ADialog {
        protected JComboBox<SelectionCriteria> mCbDfltDeviceCriteria = new JComboBox();
        protected JComboBox<SelectionCriteria> mCbDfltPinCriteria = new JComboBox();
        boolean mMonitorChanges = false;

        public DefaultsDialog(Component owner) {
            super(owner);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setTitle("Set Default Selection Criteria Sets");
            this.setRecallBounds(false);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            l.add("Device selection:");
            l.add(this.mCbDfltDeviceCriteria);
            this.mCbDfltDeviceCriteria.setRenderer(new SelectionCriteriaListCellRenderer());
            l.newline();
            l.add("PinSelection:");
            l.add(this.mCbDfltPinCriteria);
            this.mCbDfltPinCriteria.setRenderer(new SelectionCriteriaListCellRenderer());
            l.newline();
            l.pushFillXRemainX();
            ((JButton)l.add((Component)new JButton("Reset All"))).addActionListener(e -> this.resetDefaults());
            l.addFillX();
            JButton btnClose = (JButton)l.add((Component)new JButton("Close"));
            l.pop();
            this.loadData();
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)btnClose);
            this.mCbDfltDeviceCriteria.addActionListener(e -> {
                if (this.mMonitorChanges) {
                    SelectionCriteria.setDefault((SelectionCriteria)((SelectionCriteria)this.mCbDfltDeviceCriteria.getSelectedItem()));
                }
            });
            this.mCbDfltPinCriteria.addActionListener(e -> {
                if (this.mMonitorChanges) {
                    SelectionCriteria.setDefault((SelectionCriteria)((SelectionCriteria)this.mCbDfltPinCriteria.getSelectedItem()));
                }
            });
        }

        protected void loadData() {
            this.mMonitorChanges = false;
            this.mCbDfltDeviceCriteria.removeAllItems();
            SelectionCriteria.getSavedCriteria().stream().filter(c -> c.getReferenceClass().equals(Device.class.getName())).forEach(c -> this.mCbDfltDeviceCriteria.addItem((SelectionCriteria)c));
            this.mCbDfltPinCriteria.removeAllItems();
            SelectionCriteria.getSavedCriteria().stream().filter(c -> c.getReferenceClass().equals(PinInstance.class.getName())).forEach(c -> this.mCbDfltPinCriteria.addItem((SelectionCriteria)c));
            this.mCbDfltDeviceCriteria.setSelectedItem(SelectionCriteria.getDefault(Device.class).orElse(null));
            this.mCbDfltPinCriteria.setSelectedItem(SelectionCriteria.getDefault(PinInstance.class).orElse(null));
            this.mMonitorChanges = true;
        }

        protected void resetDefaults() {
            if (0 != JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to reset the defaults?", "Confirm Defaults Reset", 0)) {
                return;
            }
            SelectionCriteria.resetDefaults();
            this.loadData();
            JOptionPane.showMessageDialog((Component)((Object)this), "Defaults reset.", "Complete", 1);
        }
    }

    public static class EditDialog
    extends ADialog {
        protected SelectionCriteria mSelCriteria;
        protected JTextField mTxtName;
        protected JLabel mLblIcon;
        protected JCheckBox mCbFavorite;
        protected boolean mWarnOverwrite = false;
        protected Action mActionChangeIcon = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File instDir = AApp.getInstallDir();
                File iconDir = new File(instDir, "res/icon/select");
                LinkedList<AImageIcon> icons = new LinkedList<AImageIcon>();
                icons.add(null);
                for (File f : iconDir.listFiles(AFileFilter.toJavaIoFileFilter((FileFilter)AFileFilter.aggregate((String)"Icon files", (List)ASelectIconDialog.IMAGE_FILTERS)))) {
                    try {
                        AImageIcon i = new AImageIcon(f.getAbsolutePath());
                        icons.add(i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ASelectIconDialog dlg = new ASelectIconDialog((Component)((Object)this), icons, new ASelectIconDialog.Complete(){

                    public void oked(Icon newIcon) {
                        if (newIcon != null && (newIcon.getIconWidth() != SelectionCriteriaUI.IconSize.width || newIcon.getIconHeight() != SelectionCriteriaUI.IconSize.height)) {
                            BufferedImage tmpImg = new BufferedImage(SelectionCriteriaUI.IconSize.width, SelectionCriteriaUI.IconSize.height, 2);
                            Graphics2D g2 = tmpImg.createGraphics();
                            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g2.drawImage(AImageUtil.getImage((Icon)newIcon), 0, 0, SelectionCriteriaUI.IconSize.width, SelectionCriteriaUI.IconSize.height, null);
                            g2.dispose();
                            newIcon = new AImageIcon((Image)tmpImg);
                        }
                        mSelCriteria.setIconSmall(newIcon);
                        mLblIcon.setIcon(newIcon);
                    }
                });
                dlg.setVisible(true);
            }
        };

        public EditDialog(Component owner) {
            super(owner);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setTitle("Edit Criteria");
            this.setRecallBounds(false);
        }

        public void showDialog(final SelectionCriteria sc, List<SelectionCriteria> others, final DialogComplete completeHandler) {
            this.mSelCriteria = sc;
            this.getContentPane().removeAll();
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            l.add("Name:");
            this.mTxtName = (JTextField)l.add((Component)new JTextField(40), (GridBagConstraints)GridBagManager.FILLX);
            this.mTxtName.setText(sc.getName());
            l.newline();
            l.add("Icon:");
            l.pushNoFill();
            this.mLblIcon = (JLabel)l.add((Component)new JLabel(sc.getIconSmall()));
            l.add((Component)UIUtil.makeSmallButton((Action)this.mActionChangeIcon, (String)"Change...", (String)"Pick a different icon"));
            l.pop();
            l.newline();
            l.add("Favorite:");
            this.mCbFavorite = (JCheckBox)l.add((Component)new JCheckBox(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mCbFavorite.setSelected(sc.getFavorite());
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String msg;
                    try {
                        AFieldValidator.validateText((JTextComponent)mTxtName);
                    }
                    catch (AFieldValidator.AFieldValidationException e1) {
                        return;
                    }
                    String newName = mTxtName.getText().trim();
                    if (mWarnOverwrite && SelectionCriteria.getByName((String)newName).isPresent() && 0 != JOptionPane.showConfirmDialog((Component)((Object)this), msg = String.format("A saved selection criteria set named '%s' already exists.\nDo you want to replace it?", newName), "Confirm Overwrite", 0)) {
                        return;
                    }
                    sc.setName(newName);
                    sc.setFavorite(mCbFavorite.isSelected());
                    completeHandler.oked(sc);
                    UIUtil.closeWindow((Window)((Object)this));
                }
            });
            this.mTxtName.requestFocus();
            this.setVisible(true);
        }

        public void setWarnOverwrite(boolean b) {
            this.mWarnOverwrite = b;
        }
    }

    public static class SelectionCriteriaList
    extends ADialog {
        protected DefaultListModel<SelectionCriteria> mLmCriteria;
        protected JList<SelectionCriteria> mLstCriteria;
        protected JButton mBtnDefaults;
        protected JButton mBtnEdit;
        protected JButton mBtnDelete;

        public SelectionCriteriaList(Component owner) {
            super(owner);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setTitle("Saved Selection Criteria");
        }

        public void showDialog(final DialogComplete completeHandler) {
            List allCriteria = SelectionCriteria.getSavedCriteria();
            if (allCriteria.isEmpty()) {
                JOptionPane.showMessageDialog(this.getOwner(), "There are no saved criteria sets.", "No Saved Sets", 1);
                return;
            }
            this.getContentPane().removeAll();
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            this.mLstCriteria = new JList();
            ((JScrollPane)l.add((Component)new JScrollPane(this.mLstCriteria), (GridBagConstraints)GridBagManager.FILLALL.insetBottom(0))).setPreferredSize(new Dimension(500, 200));
            l.newline();
            l.push((GridBagConstraints)GridBagManager.FILLX.noInsets());
            this.mBtnDefaults = (JButton)l.add((Component)UIUtil.makeSmallButton((Action)new DefaultsAction(), (String)"Defaults...", (String)"Select default criteria sets"), (GridBagConstraints)GridBagManager.LEFT.insetTop(0));
            l.addFillX();
            this.mBtnEdit = (JButton)l.add((Component)UIUtil.makeSmallButton((Action)new EditAction(), (String)"Edit...", (String)"Edit saved criteria properties"), (GridBagConstraints)GridBagManager.LEFT.insetHoriz(0).insetTop(0));
            this.mBtnDelete = (JButton)l.add((Component)UIUtil.makeSmallButton((Action)new DeleteAction(), (String)"Delete", (String)"Delete"), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0).insetTop(0));
            l.pop();
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            final JButton btnOK = (JButton)l.add((Component)new JButton("Load"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Close"));
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.mLmCriteria = new DefaultListModel();
            this.mLstCriteria.setModel(this.mLmCriteria);
            this.loadCriteria();
            this.mLstCriteria.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    boolean oneSelected = mLstCriteria.getSelectedIndices().length == 1;
                    SelectionCriteria selected = mLstCriteria.getSelectedValue();
                    btnOK.setEnabled(oneSelected);
                    mBtnEdit.setEnabled(oneSelected);
                    mBtnDelete.setEnabled(oneSelected && !selected.getDefault());
                }
            });
            this.mLstCriteria.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (e.getButton() == 1 && e.getClickCount() == 2 && btnOK.isEnabled()) {
                        btnOK.doClick();
                    }
                }
            });
            this.mLstCriteria.setCellRenderer(new SelectionCriteriaListCellRenderer());
            btnOK.setEnabled(false);
            btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectionCriteria sc = mLstCriteria.getSelectedValue();
                    completeHandler.oked(sc);
                    UIUtil.closeWindow((Window)((Object)this));
                }
            });
            this.mBtnEdit.setEnabled(false);
            this.mBtnDelete.setEnabled(false);
            this.setVisible(true);
        }

        protected void loadCriteria() {
            this.mLmCriteria.removeAllElements();
            for (SelectionCriteria sc : SelectionCriteria.getSavedCriteria()) {
                this.mLmCriteria.addElement(sc);
            }
        }

        public void saveAllCriteria() {
            OrbitGuiWS ws;
            LinkedList<SelectionCriteria> updated = new LinkedList<SelectionCriteria>();
            for (int i = 0; i < this.mLmCriteria.getSize(); ++i) {
                updated.add(this.mLmCriteria.getElementAt(i));
            }
            SelectionCriteria.saveCriteria(updated);
            OrbitIO orbit = OrbitIO.getApp();
            OrbitGuiWS orbitGuiWS = ws = orbit == null ? null : orbit.getWorkspace();
            if (ws == null) {
                return;
            }
            for (Db db : orbit.getOpenDBs()) {
                for (AAppView v : ws.getViews(db)) {
                    if (!(v instanceof DesignView2D)) continue;
                    DesignView2D v2d = (DesignView2D)v;
                    v2d.removeFavoriteSelectionCriteriaActions();
                    v2d.addFavoriteSelectionCriteriaActions();
                }
            }
            ws.refreshViewToolbar();
        }

        protected class DeleteAction
        extends AbstractAction {
            protected DeleteAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIdx = SelectionCriteriaList.this.mLstCriteria.getSelectedIndex();
                if (selIdx < 0) {
                    return;
                }
                SelectionCriteriaList.this.mLmCriteria.remove(selIdx);
                SelectionCriteriaList.this.saveAllCriteria();
            }
        }

        protected class EditAction
        extends AbstractAction {
            protected EditAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                final int selIdx = SelectionCriteriaList.this.mLstCriteria.getSelectedIndex();
                if (selIdx < 0) {
                    return;
                }
                final SelectionCriteria sc = SelectionCriteriaList.this.mLmCriteria.get(selIdx);
                EditDialog dlg = new EditDialog((Component)((Object)SelectionCriteriaList.this));
                dlg.showDialog(sc, SelectionCriteria.getSavedCriteria(), new DialogComplete(){

                    @Override
                    public void oked(SelectionCriteria selected) {
                        SelectionCriteriaList.this.mLmCriteria.remove(selIdx);
                        SelectionCriteriaList.this.mLmCriteria.add(selIdx, sc);
                        SelectionCriteriaList.this.mLstCriteria.setSelectedIndex(selIdx);
                        SelectionCriteriaList.this.saveAllCriteria();
                    }
                });
            }
        }

        protected class DefaultsAction
        extends AbstractAction {
            protected DefaultsAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                new DefaultsDialog((Component)((Object)SelectionCriteriaList.this)).setVisible(true);
                int selIdx = SelectionCriteriaList.this.mLstCriteria.getSelectedIndex();
                SelectionCriteriaList.this.loadCriteria();
                if (selIdx > 0 && selIdx < SelectionCriteriaList.this.mLmCriteria.getSize()) {
                    SelectionCriteriaList.this.mLstCriteria.setSelectedIndex(selIdx);
                    SelectionCriteriaList.this.mLstCriteria.scrollRectToVisible(SelectionCriteriaList.this.mLstCriteria.getCellBounds(selIdx, selIdx));
                }
            }
        }
    }

    public static interface DialogComplete {
        public void oked(SelectionCriteria var1);
    }
}

