/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADocumentAdapter;
import com.sigrity.acl.ui.ALinkLabel;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.ATextField;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.NetGraphPanel;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.PinUI;
import com.sigrity.orbit.ui.common.DeviceTree;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rx.Observable;
import rx.subjects.PublishSubject;

public class SetPinNetUI {
    public static final ObjectActionRegistry.ActionFactory<HierInst<DbObject>> ActionFactory = new ObjectActionRegistry.ActionFactory<HierInst<DbObject>>(){

        @Override
        public Iterator<Action> getActions(HierInst<DbObject> hierObj, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            PinTemplate pinTmplt;
            DbObject dbo = hierObj.getDbObject();
            Object object = dbo instanceof PinTemplate ? (PinTemplate)dbo : (pinTmplt = dbo instanceof PortTemplate ? ((PortTemplate)dbo).getPinTemplate() : null);
            if (pinTmplt == null) {
                return AEmptyItr.create();
            }
            return new ASingletonItr((Object)new ActionShowUI(OrbitIO.getMainWindow(), (HierInst<PinTemplate>)new HierInst(hierObj.getPath(), (DbObject)pinTmplt)));
        }
    };
    public static final ObjectActionRegistry.ActionFactory<Selection> ActionFactorySelection = new ObjectActionRegistry.ActionFactory<Selection>(){

        @Override
        public Iterator<Action> getActions(Selection selection, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            Db db = selection.getDb();
            if (db == null) {
                return AEmptyItr.create();
            }
            List<DbClass> pinDbcs = List.of(db.getDbClass(PinInstance.class), db.getDbClass(PinTemplate.class));
            for (DbClass dbc : pinDbcs) {
                LinkedList<HierInst<PinTemplate>> hpins = new LinkedList<HierInst<PinTemplate>>();
                for (DbObject p : selection.get(dbc)) {
                    for (DevicePath path : selection.getSelectedPaths(p)) {
                        if (!path.getIsAbsolute()) continue;
                        PinTemplate pinT = p instanceof PinInstance ? ((PinInstance)p).getPinTemplate() : (PinTemplate)p;
                        hpins.add((HierInst<PinTemplate>)new HierInst(path, (DbObject)pinT));
                    }
                }
                if (hpins.isEmpty()) continue;
                return new ASingletonItr((Object)new ActionShowSelPinsUI(OrbitIO.getMainWindow(), hpins));
            }
            return AEmptyItr.create();
        }
    };

    public static boolean setPinNet(Db db, String pinTemplateKey, String netName) {
        if (db == null) {
            ALog.logError((String)"No database specified.");
            return false;
        }
        PinTemplate pinT = (PinTemplate)db.getByKeyStr(PinTemplate.class, pinTemplateKey);
        if (pinT == null) {
            ALog.logError((String)"Invalid pin template key '%s'.", (Object[])new Object[]{pinTemplateKey});
            return false;
        }
        Net net = pinT.getDeviceTemplate().getNet(netName);
        if (net == null) {
            ALog.logError((String)"Invalid net name '%s'.", (Object[])new Object[]{netName});
            return false;
        }
        boolean res = pinT.setNet(net);
        OrbitIO.refreshViewsOf((DbObject)pinT);
        DbExplorerPanel.refreshAll();
        return res;
    }

    public static boolean setPinNet(Db db, String pinDevicePath, String origNetName, String pinTemplateName, String netDevicePath, String netName) {
        if (db == null) {
            ALog.logError((String)"No database specified.");
            return false;
        }
        DevicePath pinPath = DevicePath.fromString((Db)db, (String)pinDevicePath);
        if (pinPath == null) {
            ALog.logError((String)"Invalid pin device path '%s'.", (Object[])new Object[]{pinDevicePath});
            return false;
        }
        Net origNet = pinPath.getDeviceTemplate().getNet(origNetName);
        if (origNet == null) {
            ALog.logError((String)"Invalid original Net '%s'.", (Object[])new Object[]{origNetName});
            return false;
        }
        PinTemplate pinT = origNet.getPinTemplate(pinTemplateName);
        if (pinT == null) {
            ALog.logError((String)"Invalid PinTemplate name '%s'.", (Object[])new Object[]{pinTemplateName});
            return false;
        }
        return SetPinNetUI.setPintNet(pinPath, pinT, netDevicePath, netName);
    }

    @Deprecated
    public static boolean setPinNet(Db db, String pinDevicePath, String pinTemplateName, String netDevicePath, String netName) {
        if (db == null) {
            ALog.logError((String)"No database specified.");
            return false;
        }
        DevicePath pinPath = DevicePath.fromString((Db)db, (String)pinDevicePath);
        if (pinPath == null) {
            ALog.logError((String)"Invalid pin device path '%s'.", (Object[])new Object[]{pinDevicePath});
            return false;
        }
        IterableIterator pinTs = pinPath.getDeviceTemplate().getPinsByName(pinTemplateName);
        if (!pinTs.hasNext()) {
            ALog.logError((String)"Invalid pin name '%s'.", (Object[])new Object[]{pinTemplateName});
            return false;
        }
        PinTemplate pinT = (PinTemplate)pinTs.next();
        if (pinTs.hasNext()) {
            ALog.logError((String)"Three are multiple PinTemplates named '%s' on DeviceTemplate '%s', unable to determine specific pin, net not set.", (Object[])new Object[]{pinTemplateName, pinPath.getDeviceTemplate()});
            return false;
        }
        return SetPinNetUI.setPintNet(pinPath, pinT, netDevicePath, netName);
    }

    public static boolean setPintNet(DevicePath pinPath, PinTemplate pinT, String netDevicePath, String netName) {
        Db db = pinT.getDb();
        DevicePath netPath = DevicePath.fromString((Db)db, (String)netDevicePath);
        if (netPath == null) {
            ALog.logError((String)"Invalid net device path '%s'.", (Object[])new Object[]{netDevicePath});
            return false;
        }
        Net net = netPath.getDeviceTemplate().getNet(netName);
        if (net == null) {
            ALog.logError((String)"Invalid net name '%s'.", (Object[])new Object[]{netName});
            return false;
        }
        if (!netPath.contains(pinPath)) {
            ALog.logError((String)"The specified pin's device '%s' is not the within the specified netDevicePath '%s', unable to set or map net.", (Object[])new Object[]{pinPath.escapedString(), netDevicePath});
            return false;
        }
        if (net.getDeviceTemplate() == pinT.getDeviceTemplate()) {
            pinT.setNet(net);
            OrbitIO.refreshViewsOf((DbObject)pinT);
            DbExplorerPanel.refreshAll();
            return true;
        }
        if (pinT.getNet().isUnused()) {
            if (net.isUnused()) {
                return true;
            }
            SetPinNetUI.createAndAssignNewNet(pinT, false);
        }
        DevicePath netToPinPath = pinPath.getRelativePath(net.getDeviceTemplate());
        if (net.getDeviceTemplate() instanceof Design) {
            NetMap.mapToRoot((DevicePath)netToPinPath, (Net)pinT.getNet(), (String)net.getName());
        } else {
            NetMap.mapThroughPath((DevicePath)netToPinPath, (Net)pinT.getNet(), (String)net.getName());
        }
        return true;
    }

    public static Net inquireBreakNet(Component owner, HierInst<PinTemplate> hpin) {
        return SetPinNetUI.inquireBreakNet(owner, hpin, null);
    }

    public static Net inquireBreakNet(Component owner, HierInst<PinTemplate> hpin, MutableInteger selOpt) {
        PinTemplate pin = (PinTemplate)hpin.getDbObject();
        int sel = -1;
        if (selOpt != null && (selOpt.getValue() == 0 || selOpt.getValue() == 1)) {
            sel = selOpt.getValue();
        } else {
            DevicePath pinPath = hpin.getPath();
            String title = "Map Net or Pin?";
            String msg = String.format("There are other objects on the same net '%s' on the lowest-level device '%s'. Would you like to remap the entire Net, or move the pin to a new net?", pin.getNet().getName(), pinPath.getDevice().getName());
            final JDialog dlg = new JDialog(UIUtil.getParentWindow((Component)owner), title, Dialog.ModalityType.APPLICATION_MODAL);
            GridBagManager l = GridBagManager.layout((JDialog)dlg);
            JTextArea ta = (JTextArea)l.addNl((Component)new JTextArea(msg), (GridBagConstraints)GridBagManager.FILLX_REMAINX.insets(8, 8));
            ta.setColumns(50);
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            ta.setEditable(false);
            ta.setFocusable(false);
            ta.setOpaque(false);
            ta.setFont(ta.getFont().deriveFont(1));
            AButtonGroup bg = new AButtonGroup();
            for (String opt : new String[]{"Remap Entire Net", "Move Pin to New Net"}) {
                JRadioButton rb = (JRadioButton)l.add((Component)new JRadioButton(opt), (GridBagConstraints)GridBagManager.LEFT.indent().indent().insetBottom(0));
                l.newline();
                bg.add(rb);
            }
            bg.getElements().nextElement().setSelected(true);
            JCheckBox cbForAll = selOpt == null ? null : (JCheckBox)l.add((Component)new JCheckBox("Do this for all remaining pins on Nets with multiple objects"), (GridBagConstraints)GridBagManager.LEFT.insets(8, 12));
            l.addFillY();
            l.addFillX();
            JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            final MutableBoolean userOked = new MutableBoolean(false);
            btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    userOked.setValue(true);
                    UIUtil.closeWindow((Window)dlg);
                }
            });
            UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOK);
            dlg.pack();
            UIUtil.center((Component)dlg);
            dlg.setVisible(true);
            if (!userOked.getValue()) {
                return null;
            }
            sel = bg.getSelectedButtonIndex();
            if (cbForAll != null && cbForAll.isSelected()) {
                selOpt.setValue(sel);
            }
        }
        if (sel == 0) {
            return pin.getNet();
        }
        return SetPinNetUI.createAndAssignNewNet(pin, true);
    }

    protected static Net createAndAssignNewNet(PinTemplate pin, boolean record) {
        DeviceTemplate dt = pin.getDeviceTemplate();
        String newNetName = "Net" + pin.getName();
        int i = 1;
        while (dt.getNet(newNetName) != null) {
            newNetName = "Net" + pin.getName() + i;
            ++i;
        }
        Net newNet = (Net)Cp.exec((boolean)record, (String)"Net.create(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{dt.getName(), newNetName, dt.getSubstrate().getName()});
        if (newNet == null) {
            ALog.logError((String)"Error creating a new net for the pin '%s'.", (Object[])new Object[]{pin.getKeyStr()});
            assert (false);
            return null;
        }
        boolean b = (Boolean)Cp.exec((boolean)record, (String)"com.sigrity.orbit.ui.SetPinNetUI.setPinNet(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{pin.getKeyStr(), newNet.getName()});
        if (!b) {
            return null;
        }
        return newNet;
    }

    public static String queryUserForNetName(final Component dlgOwner, final DeviceTemplate netOwner, String initialName) {
        final ADialog dlg = new ADialog(dlgOwner, "New Net Name", Dialog.ModalityType.APPLICATION_MODAL);
        GridBagManager l = GridBagManager.layout((Container)dlg.getContentPane());
        l.add("Name:");
        final JTextField tfName = (JTextField)l.add((Component)new JTextField(32), (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX);
        final JButton btnOk = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        tfName.getDocument().addDocumentListener(new ADocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                String curName = tfName.getText().trim();
                btnOk.setEnabled(netOwner.getNet(curName) == null);
            }
        });
        final StringBuffer name = new StringBuffer();
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String netName = tfName.getText().trim();
                if (netOwner.getNet(netName) != null) {
                    JOptionPane.showMessageDialog(dlgOwner, "There is already a netnamed '" + netName + "'.", "Invalid Name", 0);
                    return;
                }
                name.append(netName);
                UIUtil.closeWindow((Window)dlg);
            }
        });
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
        dlg.pack();
        UIUtil.center((Component)dlg);
        tfName.setText(initialName);
        dlg.setVisible(true);
        if (name.length() > 0) {
            return name.toString();
        }
        return null;
    }

    public static class NetList
    extends AList<Net> {
        public static final Net UnmapNet = new Net(null, "<Unmap Net>");
        protected Net mInitialNet = null;

        public NetList(DeviceTemplate deviceTmplt) {
            super(new Model());
            this.setCellRenderer(new CellRenderer());
            this.setSelectionMode(0);
            this.setDeviceTemplate(deviceTmplt);
        }

        public void setDeviceTemplate(DeviceTemplate dt) {
            this.setModel(new Model(dt));
        }

        public DeviceTemplate getDeviceTemplate() {
            return this.getModel().mDeviceTemplate;
        }

        public Model getModel() {
            return (Model)super.getModel();
        }

        public void includeNetUnused() {
            this.getModel().includeNetUnused();
        }

        public void includeUnmap() {
            this.getModel().includeUnmap();
        }

        public void setInitialNet(Net net) {
            this.setSelectedValue(net, true);
            this.mInitialNet = net;
        }

        public Net getInitialNet() {
            return this.mInitialNet;
        }

        public String setFilter(String filter) {
            return this.getModel().setFilter(filter);
        }

        public String getFilter() {
            return this.getModel().getFilter();
        }

        public static class CellRenderer
        extends DefaultListCellRenderer {
            Font fontNormal = null;
            Font fontItalic = null;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                if (this.fontNormal == null) {
                    this.fontNormal = this.getFont();
                    this.fontItalic = this.fontNormal.deriveFont(2);
                }
                this.setFont(this.fontNormal);
                Net n = (Net)value;
                if (n != UnmapNet && (n == null || n.getDb() == null)) {
                    this.setText("<Removed from Db>");
                    return this;
                }
                Object name = n.getName();
                if (n == UnmapNet) {
                    this.setFont(this.fontItalic);
                } else if (n.getPinCount() > 0) {
                    name = (String)name + " (" + n.getPinCount() + ")";
                    this.setForeground(Color.blue);
                }
                this.setText((String)name);
                Object toolTipText = "Pins: ";
                int count = 0;
                for (PinTemplate dtp : n.getPins()) {
                    if (count == 0) {
                        toolTipText = (String)toolTipText + "<br>";
                    }
                    toolTipText = (String)toolTipText + dtp.getName();
                    if (++count < 24) continue;
                    toolTipText = (String)toolTipText + "<br>...";
                    break;
                }
                this.setToolTipText(String.format("<html> %s </html>", toolTipText));
                return this;
            }
        }

        public static class Model
        extends AbstractListModel<Net> {
            protected DeviceTemplate mDeviceTemplate = null;
            protected List<Net> mAllNets = null;
            protected List<Net> mFilteredNets = null;
            protected Pattern mFilter = null;

            public Model(DeviceTemplate devT) {
                this.mDeviceTemplate = devT;
                this.mAllNets = devT == null ? new LinkedList() : AUtil.linkedList((Iterator)new FilteringIterator<Net>((Iterator)devT.getNets()){

                    protected boolean include(Net n) {
                        return !n.isUnused();
                    }
                });
                Collections.sort(this.mAllNets, Net.NameComparator);
                this.mFilteredNets = this.mAllNets;
            }

            public Model() {
                this(null);
            }

            @Override
            public int getSize() {
                return this.mFilteredNets.size();
            }

            @Override
            public Net getElementAt(int idx) {
                return this.mFilteredNets.get(idx);
            }

            public void includeNetUnused() {
                if (this.mAllNets.size() == 0 || !this.mAllNets.get(0).isUnused()) {
                    if (this.mFilteredNets != this.mAllNets) {
                        this.mAllNets.add(0, this.mDeviceTemplate.getNetUnused());
                    }
                    this.mFilteredNets.add(0, this.mDeviceTemplate.getNetUnused());
                    this.fireIntervalAdded(this, 0, 0);
                }
            }

            public void includeUnmap() {
                if (this.mAllNets.size() == 0 || this.mAllNets.get(0) != UnmapNet) {
                    if (this.mFilteredNets != this.mAllNets) {
                        this.mAllNets.add(0, UnmapNet);
                    }
                    this.mFilteredNets.add(0, UnmapNet);
                    this.fireIntervalAdded(this, 0, 0);
                }
            }

            public void addNet(Net net) {
                if (this.mAllNets.add(net)) {
                    if (this.mFilteredNets != this.mAllNets) {
                        this.mFilteredNets.add(net);
                    }
                    int idx = this.mFilteredNets.size() - 1;
                    this.fireIntervalAdded(this, idx, idx);
                }
            }

            public String setFilter(String filter) {
                if (filter != null && (filter = filter.trim()).isEmpty()) {
                    filter = null;
                }
                try {
                    this.mFilter = filter == null ? null : Pattern.compile(filter);
                    this.updateFilteredData();
                    return null;
                }
                catch (PatternSyntaxException pse) {
                    this.mFilter = null;
                    return pse.getDescription();
                }
            }

            public String getFilter() {
                return this.mFilter == null ? null : this.mFilter.toString();
            }

            protected void updateFilteredData() {
                if (this.mFilter == null) {
                    if (this.mFilteredNets != this.mAllNets) {
                        this.mFilteredNets = this.mAllNets;
                        this.fireContentsChanged(this, 0, this.mFilteredNets.size() - 1);
                    }
                } else {
                    int size = this.mFilteredNets.size();
                    this.mFilteredNets = this.mAllNets.stream().filter(n -> this.mFilter.matcher(n.getName()).matches()).collect(Collectors.toList());
                    size = Math.max(size, this.mFilteredNets.size());
                    this.fireContentsChanged(this, 0, size - 1);
                }
            }
        }
    }

    public static class NetSelector
    extends JPanel {
        protected DeviceTree mTree;
        protected ATextField mTxtNetFilter;
        protected NetList mNetList;
        protected JButton mBtnCreateNet;
        protected JLabel mSelNet;
        protected Optional<HierInst<Net>> mRefNet = Optional.empty();
        protected LinkedHashSet<NetSelectionListener> mSelListeners = new LinkedHashSet();
        protected PublishSubject<String> mStatusSubject = PublishSubject.create();

        public NetSelector(DeviceTemplate dt, Net initialSelection) {
            this.createNetList();
            this.mNetList.setDeviceTemplate(dt);
            this.mNetList.includeNetUnused();
            GridBagManager l = GridBagManager.layout((Container)this);
            l.addNl((Component)new JScrollPane(this.mNetList), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.insetBottom(0));
            this.mBtnCreateNet.setMargin(new Insets(1, 0, 1, 0));
            l.add((Component)this.mBtnCreateNet);
            l.newline();
            this.mSelNet = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.anchor(11));
            if (initialSelection != null) {
                this.mNetList.setInitialNet(initialSelection);
            }
        }

        public NetSelector(DevicePath dp, HierInst<Net> initialSelection) {
            this.mRefNet = Optional.ofNullable(initialSelection);
            this.createNetList();
            this.mTree = new DeviceTree(dp);
            this.mTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DevicePath selPath = mTree.getSelectedDevicePath();
                    DeviceTemplate dt = selPath == null ? null : selPath.getDeviceTemplate();
                    mNetList.setDeviceTemplate(dt);
                    TreePath tsp = mTree.getSelectionPath();
                    if (tsp != null) {
                        TreeNode tn = (TreeNode)tsp.getLastPathComponent();
                        if (tn.getChildCount() == 0) {
                            mNetList.includeNetUnused();
                        } else if (mRefNet.isPresent()) {
                            mNetList.includeUnmap();
                        }
                    }
                    mRefNet.ifPresent(hNet -> {
                        Net netAtSelPath = NetMap.getNetAt((Net)((Net)hNet.getDbObject()), (DevicePath)hNet.getPath(), (DeviceTemplate)dt, null);
                        mNetList.setInitialNet(netAtSelPath != null ? netAtSelPath : NetList.UnmapNet);
                    });
                    mBtnCreateNet.setEnabled(tsp != null);
                }
            });
            GridBagManager l = GridBagManager.layout((Container)this);
            JPanel rightPane = new JPanel();
            GridBagManager lr = GridBagManager.layout((Container)rightPane);
            this.mTxtNetFilter = new ATextField(8);
            lr.pushFillXRemainX();
            lr.add("Name filter:", (GridBagConstraints)GridBagManager.LEFT);
            lr.add((Component)this.mTxtNetFilter, (GridBagConstraints)GridBagManager.FILLX.insetLeft(0));
            lr.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.RIGHT.insetLeft(0));
            lr.popNl();
            this.mTxtNetFilter.setActionHandler(() -> this.updateFilteredNets());
            this.mTxtNetFilter.setInvokeActionOnTextUpdate(true);
            l.newline();
            lr.addNl((Component)new JScrollPane(this.mNetList), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.insetBottom(0));
            this.mBtnCreateNet.setMargin(new Insets(1, 0, 1, 0));
            lr.add((Component)this.mBtnCreateNet);
            ASplitPane splitter = new ASplitPane(1, new JScrollPane(this.mTree), rightPane);
            l.add((Component)splitter, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            this.mSelNet = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.anchor(11));
            this.mTree.setSelectedDevicePath(dp);
            if (initialSelection != null) {
                this.mNetList.setInitialNet((Net)initialSelection.getDbObject());
            }
        }

        protected void updateFilteredNets() {
            String errMsg;
            Object filter = this.mTxtNetFilter.getText();
            if (!(((String)filter).isEmpty() || ((String)filter).contains("\\") || ((String)filter).contains(".") || ((String)filter).contains("["))) {
                filter = (String)filter + ".*";
            }
            if ((errMsg = this.mNetList.setFilter((String)filter)) != null) {
                this.updateStatus("Invalid pattern. %s", errMsg);
            } else if (this.mNetList.getFilter() == null) {
                this.updateStatus(null, new Object[0]);
            } else {
                this.updateStatus("Nets filtered.", new Object[0]);
            }
        }

        protected void createNetList() {
            this.mNetList = new NetList(null);
            this.mBtnCreateNet = new JButton("Create Net...");
            this.mNetList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    HierInst<Net> hn = this.getSelectedNet();
                    if (hn == null) {
                        mSelNet.setText("<No Net selected>");
                    } else if (hn.getPath() == null) {
                        mSelNet.setText(String.format("<html><b>%s</b>", ((Net)hn.getDbObject()).getName()));
                    } else {
                        mSelNet.setText(String.format("<html><b>%s</b> on %s", AUtil.escapeHtml((String)((Net)hn.getDbObject()).getName()), AUtil.escapeHtml((String)hn.getPath().toString())));
                    }
                    this.fireSelectionChange(hn);
                    SwingUtilities.invokeLater(() -> {
                        Rectangle r;
                        int[] sels = mNetList.getSelectedIndices();
                        if (sels != null && sels.length > 0 && (r = mNetList.getCellBounds(sels[0], sels[sels.length - 1])) != null) {
                            mNetList.scrollRectToVisible(r);
                        }
                    });
                }
            });
            this.mBtnCreateNet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTemplate dt = mNetList.getDeviceTemplate();
                    DevicePath selPath = mTree.getSelectedDevicePath();
                    Substrate s = selPath.getSubstrate();
                    String newNetName = SetPinNetUI.queryUserForNetName(mBtnCreateNet, dt, "");
                    if (newNetName == null) {
                        return;
                    }
                    Net newNet = null;
                    newNet = dt instanceof Design ? (Net)Cp.exec((String)"Net.create(Design.getDesign(curDb()), \"%s\")", (Object[])new Object[]{newNetName}) : (Net)Cp.exec((String)"Net.create(curDb(), \"%s\", \"%s\", %s)", (Object[])new Object[]{dt.getName(), newNetName, s == null ? "null" : String.format("\"%s\"", s.getName())});
                    if (newNet == null) {
                        return;
                    }
                    mNetList.getModel().addNet(newNet);
                    mNetList.setInitialNet(newNet);
                }
            });
        }

        public HierInst<Net> getSelectedNet() {
            DevicePath path = this.mTree == null ? null : this.mTree.getSelectedDevicePath();
            Net net = (Net)this.mNetList.getSelectedValue();
            if (net == null) {
                return null;
            }
            return new HierInst(path, (DbObject)net);
        }

        public void addSelectionListener(NetSelectionListener l) {
            this.mSelListeners.add(l);
        }

        public void removeSelectionListener(NetSelectionListener l) {
            this.mSelListeners.remove(l);
        }

        protected void fireSelectionChange(HierInst<Net> newSel) {
            for (NetSelectionListener l : this.mSelListeners) {
                l.selectionChanged(newSel);
            }
        }

        public Observable<String> observeStatus() {
            return this.mStatusSubject;
        }

        protected void updateStatus(String fmt, Object ... args) {
            String status = fmt == null ? "" : String.format(fmt, args);
            this.mStatusSubject.onNext((Object)status);
        }

        public static interface NetSelectionListener {
            public void selectionChanged(HierInst<Net> var1);
        }
    }

    public static class SetMultiplePinsNetDlg
    extends DbDialog {
        protected List<HierInst<PinTemplate>> mHierPins;
        protected DevicePath mCommonPath;
        protected JButton mBtnOK;
        protected NetSelector mNetSelector;

        public SetMultiplePinsNetDlg(Component owner, List<HierInst<PinTemplate>> hpins) {
            super(((PinTemplate)hpins.get(0).getDbObject()).getDb(), owner);
            this.setTitle("Set Pin Net");
            this.setRecallBounds(false);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            this.mHierPins = hpins;
            this.mCommonPath = DevicePath.commonAnscestorInsts(this.mHierPins.iterator());
            l.add("<html><b>Common device:");
            l.add(String.format("<html><head>%s</head><body>%s</body></html>", "<style type='text/css'>\n.pathSep {\n\tfont-weight: bold;\n\tbackground-color: #FFFF00;\n}\n</style>", this.mCommonPath.getHTML()), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            l.add("<html><b>Pins:");
            l.add("" + hpins.size());
            l.newline();
            l.push("Select New Net", (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mNetSelector = new NetSelector(this.mCommonPath, null);
            l.add((Component)this.mNetSelector, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.popNl();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOK = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOK);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.enableControls();
            this.mNetSelector.addSelectionListener(new NetSelector.NetSelectionListener(){

                @Override
                public void selectionChanged(HierInst<Net> newSel) {
                    this.enableControls();
                }
            });
            this.mBtnOK.addActionListener(e -> this.doOk());
        }

        protected void enableControls() {
            this.mBtnOK.setEnabled(this.mNetSelector.getSelectedNet() != null);
        }

        protected void doOk() {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Set Pins Net");){
                this._doOk();
            }
        }

        protected void _doOk() {
            HierInst<Net> hnet = this.mNetSelector.getSelectedNet();
            if (hnet == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No Net selected.", "Error", 0);
                return;
            }
            DevicePath netPath = hnet.getPath();
            Net newNet = (Net)hnet.getDbObject();
            boolean res = true;
            int countSet = 0;
            MutableInteger doAllOpt = new MutableInteger(-1);
            for (HierInst<PinTemplate> hpin : this.mHierPins) {
                Net newPinNet;
                IterableIterator itr;
                DevicePath pinPath = hpin.getPath();
                PinTemplate pin = (PinTemplate)hpin.getDbObject();
                if (newNet.getDeviceTemplate() != pin.getDeviceTemplate() && !pin.getNet().isUnused() && (itr = pin.getNet().getContents()).hasNext() && itr.next() != null && itr.hasNext() && (newPinNet = SetPinNetUI.inquireBreakNet((Component)((Object)this), hpin, doAllOpt)) == null) {
                    return;
                }
                boolean cmdRes = (Boolean)Cp.exec((String)"com.sigrity.orbit.ui.SetPinNetUI.setPinNet(curDb(), \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{pinPath, pin.getName(), netPath, newNet.getName()});
                res &= cmdRes;
                if (!cmdRes) continue;
                ++countSet;
            }
            ALog.logInfo((String)"Set the net on %d pin%s to '%s'.", (Object[])new Object[]{countSet, countSet == 1 ? "" : "s", newNet.getName()});
            if (res) {
                UIUtil.closeWindow((Window)((Object)this));
                OrbitIO.refreshViewsOf(this.mHierPins.get(0).getDbObject());
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Error setting nets, please refer to logged output.", "Error", 0);
            }
        }
    }

    public static class SetPinNetDlg
    extends DbDialog {
        protected HierInst<PinTemplate> mHierPin;
        protected JButton mBtnOk;
        protected NetSelector mNetSelector;

        public static SetPinNetDlg createDialog(Component owner, HierInst<PinTemplate> hpin) {
            SetPinNetDlg dlg = new SetPinNetDlg(owner, hpin);
            dlg.setVisible(true);
            return dlg;
        }

        public SetPinNetDlg(Component owner, HierInst<PinTemplate> hpin) {
            super(((PinTemplate)hpin.getDbObject()).getDb(), owner);
            Device d;
            if (hpin.getPath() == null && (d = ((PinTemplate)hpin.getDbObject()).getDeviceTemplate().getAnInstance()) != null) {
                DevicePath apath = d.getADevicePath();
                hpin.first = apath;
            }
            this.setTitle("Set Pin Net");
            this.setRecallBounds(false);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            this.mHierPin = hpin;
            DevicePath path = hpin.getPath();
            PinTemplate pin = (PinTemplate)hpin.getDbObject();
            l.pushFillX();
            if (path == null) {
                l.add("<html><b>Device Template:");
                l.add(pin.getDeviceTemplate().getName(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            } else {
                l.add("<html><b>Device:");
                l.add(String.format("<html><head>%s</head><body>%s</body></html>", "<style type='text/css'>\n.pathSep {\n\tfont-weight: bold;\n\tbackground-color: #FFFF00;\n}\n</style>", path.getHTML()), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            }
            l.newline();
            l.add("<html><b>Pin:");
            l.add(pin.getName());
            l.newline();
            l.add("<html><b>Current Net:");
            l.add(pin.getNet().getName());
            l.add((Component)new ALinkLabel("Graph", NetGraphPanel.createShowNetGraphAction((Window)((Object)this), path, pin.getNet())));
            l.popNl();
            l.push("Select New Net", (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mNetSelector = path == null ? new NetSelector(pin.getDeviceTemplate(), pin.getNet()) : new NetSelector(path, (HierInst<Net>)new HierInst(path, (DbObject)pin.getNet()));
            l.add((Component)this.mNetSelector, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.popNl();
            l.pushFillXRemainX();
            JLabel lblStatus = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX);
            this.mBtnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            this.setMinimumSize(new Dimension(300, 400));
            UIUtil.center((Component)((Object)this));
            this.enableControls();
            this.mNetSelector.addSelectionListener(new NetSelector.NetSelectionListener(){

                @Override
                public void selectionChanged(HierInst<Net> newSel) {
                    this.enableControls();
                }
            });
            this.mNetSelector.observeStatus().subscribe(status -> lblStatus.setText((String)status));
            this.mBtnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.doOk();
                }
            });
        }

        protected void enableControls() {
            DevicePath initPath = this.mHierPin.getPath();
            Net initNet = ((PinTemplate)this.mHierPin.getDbObject()).getNet();
            HierInst<Net> curSelHNet = this.mNetSelector.getSelectedNet();
            if (curSelHNet == null) {
                this.mBtnOk.setEnabled(false);
            } else {
                Net curNetAtSelDev = NetMap.getNetAt((Net)initNet, (DevicePath)initPath, (DeviceTemplate)curSelHNet.getPath().getDeviceTemplate(), null);
                if (curSelHNet.getDbObject() == NetList.UnmapNet) {
                    this.mBtnOk.setEnabled(curNetAtSelDev != null);
                } else {
                    this.mBtnOk.setEnabled(curNetAtSelDev != curSelHNet.getDbObject());
                }
            }
        }

        protected void doOk() {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Set Pin Net");){
                this._doOk();
            }
        }

        protected void _doOk() {
            HierInst<Net> hnet = this.mNetSelector.getSelectedNet();
            if (hnet == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No Net selected.", "Error", 0);
                return;
            }
            DevicePath pinPath = this.mHierPin.getPath();
            PinTemplate pin = (PinTemplate)this.mHierPin.getDbObject();
            Net curPinNet = pin.getNet();
            DevicePath newNetPath = hnet.getPath();
            Net newNet = (Net)hnet.getDbObject();
            Boolean res = null;
            if (newNet == NetList.UnmapNet) {
                DevicePath selDevChildPath = pinPath.getSubPath(0, newNetPath.size() + 1);
                Device selDevChildDev = selDevChildPath.getDevice();
                DeviceTemplate selDevChildT = selDevChildDev.getTemplate();
                Net selDevChildNet = NetMap.getNetAt((Net)curPinNet, (DevicePath)pinPath, (DeviceTemplate)selDevChildT, null);
                Net parentNet = NetMap.getParentNet((Device)selDevChildDev, (Net)selDevChildNet);
                if (selDevChildNet != null && parentNet != null) {
                    Object o = Cp.exec((String)"NetMap.unmap(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{selDevChildDev.getKeyStr(), selDevChildNet.getKeyStr()});
                    if (o instanceof Net) {
                        ALog.logInfo((String)"Device '%s' Net '%s' is no longer mapped to parent Net '%s'.", (Object[])new Object[]{selDevChildDev.getName(), selDevChildNet.getName(), parentNet.getName()});
                        UIUtil.closeWindow((Window)((Object)this));
                        OrbitIO.refreshViewsOf((DbObject)pin);
                    } else {
                        ALog.logInfo((String)"No net mapping changed.");
                    }
                }
            } else {
                if (pinPath == null) {
                    res = (Boolean)Cp.exec((String)"com.sigrity.orbit.ui.SetPinNetUI.setPinNet(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{pin.getKeyStr(), newNet.getName()});
                } else {
                    Net newPinNet;
                    IterableIterator itr;
                    if (newNet.getDeviceTemplate() != pin.getDeviceTemplate() && !pin.getNet().isUnused() && (itr = pin.getNet().getContents()).hasNext() && itr.next() != null && itr.hasNext() && (newPinNet = SetPinNetUI.inquireBreakNet((Component)((Object)this), this.mHierPin)) == null) {
                        return;
                    }
                    res = (Boolean)Cp.exec((String)"com.sigrity.orbit.ui.SetPinNetUI.setPinNet(curDb(), \"%s\", \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{pinPath, pin.getNet().getName(), pin.getName(), newNetPath, newNet.getName()});
                }
                if (res != null && res.booleanValue()) {
                    UIUtil.closeWindow((Window)((Object)this));
                    OrbitIO.refreshViewsOf((DbObject)pin);
                    ALog.logInfo((String)"Set pin's net to '%s'.", (Object[])new Object[]{newNet.getName()});
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Error setting net, please refer to logged output.", "Error", 0);
                }
            }
        }
    }

    public static class ActionShowSelPinsUI
    extends AbstractAction {
        protected Component mOwner;
        protected List<HierInst<PinTemplate>> mPins;

        public ActionShowSelPinsUI(Component owner, List<HierInst<PinTemplate>> pins) {
            super(String.format("Set Selected %s' Nets...", PinUI.getTextForPinHierList(pins)));
            this.putValue("Group", "SelectedPins");
            this.mOwner = owner;
            this.mPins = pins;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SetMultiplePinsNetDlg dlg = new SetMultiplePinsNetDlg(this.mOwner, this.mPins);
            dlg.setVisible(true);
        }
    }

    public static class ActionShowUI
    extends AbstractAction {
        public static final String NAME_TEXT = "Set Pin's Net...";
        protected Component mOwner;
        protected HierInst<PinTemplate> mPin;

        public ActionShowUI(Component owner, HierInst<PinTemplate> pin) {
            super(NAME_TEXT);
            this.putValue("Group", "Pin");
            this.mOwner = owner;
            this.mPin = pin;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SetPinNetDlg.createDialog(this.mOwner, this.mPin);
        }
    }
}

