/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.SiliconRemainder;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.ui.DeviceTemplateUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SiliconRemainderPanelUI
extends JPanel {
    protected Design mDesign = null;
    protected JLabel mNorthLabel = null;
    protected JLabel mSouthLabel = null;
    protected JLabel mEastLabel = null;
    protected JLabel mWestLabel = null;
    protected JTextField mNorthRemainder = null;
    protected JTextField mSouthRemainder = null;
    protected JTextField mEastRemainder = null;
    protected JTextField mWestRemainder = null;
    protected FocusListener mRemainderChangeListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            if (SiliconRemainderPanelUI.this.mNorthRemainder.getText().length() != 0 && SiliconRemainderPanelUI.this.mSouthRemainder.getText().length() == 0 && SiliconRemainderPanelUI.this.mEastRemainder.getText().length() == 0 && SiliconRemainderPanelUI.this.mWestRemainder.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)SiliconRemainderPanelUI.this.mNorthRemainder);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                SiliconRemainderPanelUI.this.mSouthRemainder.setText(SiliconRemainderPanelUI.this.mNorthRemainder.getText());
                SiliconRemainderPanelUI.this.mEastRemainder.setText(SiliconRemainderPanelUI.this.mNorthRemainder.getText());
                SiliconRemainderPanelUI.this.mWestRemainder.setText(SiliconRemainderPanelUI.this.mNorthRemainder.getText());
            } else if (SiliconRemainderPanelUI.this.mSouthRemainder.getText().length() != 0 && SiliconRemainderPanelUI.this.mNorthRemainder.getText().length() == 0 && SiliconRemainderPanelUI.this.mEastRemainder.getText().length() == 0 && SiliconRemainderPanelUI.this.mWestRemainder.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)SiliconRemainderPanelUI.this.mSouthRemainder);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                SiliconRemainderPanelUI.this.mNorthRemainder.setText(SiliconRemainderPanelUI.this.mSouthRemainder.getText());
                SiliconRemainderPanelUI.this.mEastRemainder.setText(SiliconRemainderPanelUI.this.mSouthRemainder.getText());
                SiliconRemainderPanelUI.this.mWestRemainder.setText(SiliconRemainderPanelUI.this.mSouthRemainder.getText());
            } else if (SiliconRemainderPanelUI.this.mEastRemainder.getText().length() != 0 && SiliconRemainderPanelUI.this.mNorthRemainder.getText().length() == 0 && SiliconRemainderPanelUI.this.mSouthRemainder.getText().length() == 0 && SiliconRemainderPanelUI.this.mWestRemainder.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)SiliconRemainderPanelUI.this.mEastRemainder);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                SiliconRemainderPanelUI.this.mNorthRemainder.setText(SiliconRemainderPanelUI.this.mEastRemainder.getText());
                SiliconRemainderPanelUI.this.mSouthRemainder.setText(SiliconRemainderPanelUI.this.mEastRemainder.getText());
                SiliconRemainderPanelUI.this.mWestRemainder.setText(SiliconRemainderPanelUI.this.mEastRemainder.getText());
            } else if (SiliconRemainderPanelUI.this.mWestRemainder.getText().length() != 0 && SiliconRemainderPanelUI.this.mNorthRemainder.getText().length() == 0 && SiliconRemainderPanelUI.this.mEastRemainder.getText().length() == 0 && SiliconRemainderPanelUI.this.mSouthRemainder.getText().length() == 0) {
                try {
                    AFieldValidator.validateDouble((JTextField)SiliconRemainderPanelUI.this.mWestRemainder);
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                SiliconRemainderPanelUI.this.mNorthRemainder.setText(SiliconRemainderPanelUI.this.mWestRemainder.getText());
                SiliconRemainderPanelUI.this.mEastRemainder.setText(SiliconRemainderPanelUI.this.mWestRemainder.getText());
                SiliconRemainderPanelUI.this.mSouthRemainder.setText(SiliconRemainderPanelUI.this.mWestRemainder.getText());
            }
        }
    };

    public SiliconRemainderPanelUI(Design design) {
        this.init(design);
    }

    private void init(Design design) {
        this.mDesign = design;
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mNorthLabel = l.add("North remainder :", (GridBagConstraints)GridBagManager.LEFT);
        this.mNorthLabel.setToolTipText("Remainder line width on North side of die when oriented face-up without any rotation.");
        this.mNorthRemainder = new JTextField("", 10);
        l.add((Component)this.mNorthRemainder, (GridBagConstraints)GridBagManager.LEFT);
        this.mNorthRemainder.addFocusListener(this.mRemainderChangeListener);
        l.newline();
        this.mSouthLabel = l.add("South remainder :", (GridBagConstraints)GridBagManager.LEFT);
        this.mSouthLabel.setToolTipText("Remainder line width on South side of die when oriented face-up without any rotation.");
        this.mSouthRemainder = new JTextField("", 10);
        l.add((Component)this.mSouthRemainder, (GridBagConstraints)GridBagManager.LEFT);
        this.mSouthRemainder.addFocusListener(this.mRemainderChangeListener);
        l.newline();
        this.mEastLabel = l.add("East remainder :", (GridBagConstraints)GridBagManager.LEFT);
        this.mEastLabel.setToolTipText("Remainder line width on East side of die when oriented face-up without any rotation.");
        this.mEastRemainder = new JTextField("", 10);
        l.add((Component)this.mEastRemainder, (GridBagConstraints)GridBagManager.LEFT);
        this.mEastRemainder.addFocusListener(this.mRemainderChangeListener);
        l.newline();
        this.mWestLabel = l.add("West remainder :", (GridBagConstraints)GridBagManager.LEFT);
        this.mWestLabel.setToolTipText("Remainder line width on West side of die when oriented face-up without any rotation.");
        this.mWestRemainder = new JTextField("", 10);
        this.mWestRemainder.addFocusListener(this.mRemainderChangeListener);
        l.add((Component)this.mWestRemainder, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
    }

    public Unit getUnitDist() {
        return this.mDesign == null ? Design.getDefaultUnitDist() : this.mDesign.getUnit();
    }

    protected String formatUserDist(long v) {
        return this.getUnitDist().toUserStr(v);
    }

    public void initValues(SiliconRemainder remainder) {
        this.mNorthRemainder.setText(this.formatUserDist(remainder.getNorth()));
        this.mSouthRemainder.setText(this.formatUserDist(remainder.getSouth()));
        this.mEastRemainder.setText(this.formatUserDist(remainder.getEast()));
        this.mWestRemainder.setText(this.formatUserDist(remainder.getWest()));
    }

    public void setContentsEnabled(boolean flag) {
        this.mNorthLabel.setEnabled(flag);
        this.mSouthLabel.setEnabled(flag);
        this.mEastLabel.setEnabled(flag);
        this.mWestLabel.setEnabled(flag);
        this.mNorthRemainder.setEnabled(flag);
        this.mSouthRemainder.setEnabled(flag);
        this.mEastRemainder.setEnabled(flag);
        this.mWestRemainder.setEnabled(flag);
    }

    public void setContentsVisible(boolean flag) {
        this.mNorthLabel.setVisible(flag);
        this.mSouthLabel.setVisible(flag);
        this.mEastLabel.setVisible(flag);
        this.mWestLabel.setVisible(flag);
        this.mNorthRemainder.setVisible(flag);
        this.mSouthRemainder.setVisible(flag);
        this.mEastRemainder.setVisible(flag);
        this.mWestRemainder.setVisible(flag);
    }

    public boolean validateFields() {
        try {
            AFieldValidator.validateDouble((JTextField)this.mNorthRemainder);
            AFieldValidator.validateDouble((JTextField)this.mSouthRemainder);
            AFieldValidator.validateDouble((JTextField)this.mEastRemainder);
            AFieldValidator.validateDouble((JTextField)this.mWestRemainder);
        }
        catch (AFieldValidator.AFieldValidationException fve) {
            return false;
        }
        return true;
    }

    public void updateDB(boolean enabled, DeviceTemplate dt) {
        long north = this.getNorthRemainder();
        long south = this.getSouthRemainder();
        long east = this.getEastRemainder();
        long west = this.getWestRemainder();
        Cp.exec((String)"%s.updateSiliconRemainder(curDb(), \"%s\", %b, %dL, %dL, %dL, %dL)", (Object[])new Object[]{DeviceTemplateUI.class.getName(), dt.getKeyStr(), enabled, north, south, east, west});
    }

    public long getNorthRemainder() {
        return this.getRemainder(this.mNorthRemainder);
    }

    public long getSouthRemainder() {
        return this.getRemainder(this.mSouthRemainder);
    }

    public long getEastRemainder() {
        return this.getRemainder(this.mEastRemainder);
    }

    public long getWestRemainder() {
        return this.getRemainder(this.mWestRemainder);
    }

    private Long getRemainder(JTextField remainderTxtField) {
        return this.getUnitDist().fromUserString(remainderTxtField.getText());
    }
}

