/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AExpression;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.ViaFactory;
import com.sigrity.orbit.ui.PinTemplateIcon;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.wb_route.BondRingDefinitionEditDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SimpleConstraintFrame
extends JPanel {
    public static final String UNKNOWN_VAL = "?";
    static final String NO_LAYER = "<No Layer>";
    static final String DefaultViaName = "Use Default From Via Factory";
    JTable mTable;
    ArrayList<SimpleConstraintUIModel> mUIModelList = new ArrayList();

    public SimpleConstraintFrame(Constraint.DescriptorList desc, DbObject owner, Substrate substrate, BondRingDefinitionEditDlg.BondRingDialogType dialogType) {
        super(new GridLayout(1, 0));
        this.loadUIModel(desc);
        this.mTable = new JTable(new SimpleConstraintModel(this.mUIModelList, owner, substrate)){
            ConstraintCellRenderer r;
            {
                this.r = new ConstraintCellRenderer();
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel);
            }

            @Override
            public TableCellRenderer getCellRenderer(int arg0, int arg1) {
                return this.r;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    SimpleConstraintUIModel uiModel = SimpleConstraintFrame.this.mUIModelList.get(rowIndex);
                    String tt = uiModel.desc.getToolTip();
                    jc.setToolTipText(tt);
                }
                return c;
            }
        };
        ConstraintCellEditor e = new ConstraintCellEditor();
        e.setSubstrate(substrate);
        this.mTable.getColumnModel().getColumn(1).setCellEditor(e);
        this.mTable.setFillsViewportHeight(true);
        this.mTable.setRowSelectionAllowed(false);
        this.mTable.setRowHeight(this.mTable.getRowHeight() + 4);
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        scrollPane.setMinimumSize(new Dimension(300, 70));
        this.add(scrollPane);
        if (dialogType == BondRingDefinitionEditDlg.BondRingDialogType.NewFinger || dialogType == BondRingDefinitionEditDlg.BondRingDialogType.NewMetal) {
            this.loadDefaultValues();
        } else {
            this.loadValues();
        }
        JTableHeader hdr = this.mTable.getTableHeader();
        Dimension d = UIUtil.add((Dimension[])new Dimension[]{hdr.getPreferredSize(), this.mTable.getPreferredSize()});
        d = UIUtil.add((Dimension)d, (Insets[])new Insets[]{scrollPane.getInsets()});
        scrollPane.setPreferredSize(d);
    }

    protected void loadUIModel(Constraint.DescriptorList desc) {
        int size = desc.size();
        for (int i = 0; i < size; ++i) {
            SimpleConstraintUIModel uiModel = new SimpleConstraintUIModel();
            uiModel.desc = (Constraint.Descriptor)desc.get(i);
            uiModel.changed = false;
            uiModel.exposedValue = "";
            this.mUIModelList.add(uiModel);
        }
    }

    public void doSave(DbObject owner, Substrate substrate, boolean saveOnlyChanged) {
        ConstraintCellEditor e = (ConstraintCellEditor)this.mTable.getColumnModel().getColumn(1).getCellEditor();
        e.done();
        int size = this.mUIModelList.size();
        for (int i = 0; i < size; ++i) {
            Double dVal;
            String sVal;
            SimpleConstraintUIModel uiModel = this.mUIModelList.get(i);
            if (!uiModel.changed && saveOnlyChanged) continue;
            Class classType = uiModel.desc.getType();
            if (classType == AExpression.class) {
                sVal = (String)uiModel.exposedValue;
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{owner.getDbClass().getName(), owner.getKeyStr(), uiModel.desc.getName(), sVal});
                continue;
            }
            if (classType == Double.class) {
                sVal = (String)uiModel.exposedValue;
                sVal = sVal.replace(",", "");
                dVal = Double.valueOf(sVal);
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", (Double) %f)", (Object[])new Object[]{owner.getDbClass().getName(), owner.getKeyStr(), uiModel.desc.getName(), dVal});
                continue;
            }
            if (classType == Long.class) {
                sVal = (String)uiModel.exposedValue;
                sVal = sVal.replace(",", "");
                dVal = Double.valueOf(sVal);
                Long lVal = OrbitIO.getCurView().getUnit().fromUser(dVal.doubleValue());
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", (Long) %dL)", (Object[])new Object[]{owner.getDbClass().getName(), owner.getKeyStr(), uiModel.desc.getName(), lVal});
                continue;
            }
            if (classType == Integer.class) {
                sVal = (String)uiModel.exposedValue;
                Integer iVal = Integer.valueOf(sVal);
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", (Integer) %d)", (Object[])new Object[]{owner.getDbClass().getName(), owner.getKeyStr(), uiModel.desc.getName(), iVal});
                continue;
            }
            if (classType.isEnum()) {
                if (owner == null || owner.getDbClass() == null) continue;
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{owner.getDbClass().getName(), owner.getKeyStr(), uiModel.desc.getName(), ((Enum)uiModel.exposedValue).name()});
                continue;
            }
            if (classType == Boolean.class) {
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", (Boolean) %s)", (Object[])new Object[]{owner.getDbClass().getName(), owner.getKeyStr(), uiModel.desc.getName(), uiModel.exposedValue});
                continue;
            }
            if (classType == Layer.class) {
                Object val = uiModel.exposedValue;
                if (val instanceof Layer || val == NO_LAYER) {
                    String strVal = val == NO_LAYER ? "null" : String.format("\"%s\"", ((Layer)val).getKeyStr());
                    Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", %s)", (Object[])new Object[]{owner.getDbClass().getName(), owner.getKeyStr(), uiModel.desc.getName(), strVal});
                    continue;
                }
                assert (false);
                continue;
            }
            if (classType != PadTemplate.class) continue;
            PadTemplate via = null;
            if (uiModel.exposedValue instanceof PadTemplate) {
                via = (PadTemplate)uiModel.exposedValue;
            }
            if (via != null) {
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{owner.getDbClass().getName(), owner.getKeyStr(), uiModel.desc.getName(), via.getKeyStr()});
                continue;
            }
            Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", null)", (Object[])new Object[]{owner.getDbClass().getName(), owner.getKeyStr(), uiModel.desc.getName()});
        }
    }

    public HashMap<String, Object> getDefaultConstraints() {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put(Constraint.RING_GEOM.getName(), Constraint.RingGeom.ARC);
        retMap.put(Constraint.BOND_SIDE.getName(), Constraint.BondSide.DEFAULT);
        retMap.put(Constraint.BONDFINGER_WIDTH.getName(), "60");
        retMap.put(Constraint.BONDFINGER_LENGTH.getName(), "260");
        retMap.put(Constraint.BONDFINGER_SEPARATION.getName(), "60");
        retMap.put(Constraint.BONDWIRE_TO_BONDWIRE_CLR.getName(), "10");
        retMap.put(Constraint.BONDMIN_LENGTH.getName(), "600");
        retMap.put(Constraint.BONDMAX_LENGTH.getName(), "1000");
        retMap.put(Constraint.BONDWIRE_WIDTH.getName(), "10");
        retMap.put(Constraint.BONDMIN_ANGLE.getName(), "45");
        retMap.put(Constraint.BONDFINGER_ANGLE.getName(), Constraint.BondFingerAngle.ORTHOGONAL);
        retMap.put(Constraint.BONDFINGER_TIER_DIST.getName(), "100");
        retMap.put(Constraint.BONDFINGER_LAYER.getName(), NO_LAYER);
        retMap.put(Constraint.WIREBOND_LAYER.getName(), NO_LAYER);
        retMap.put(Constraint.MAX_BONDFINGERGROUPING.getName(), "0");
        retMap.put(Constraint.CONNECT_STRATEGY.getName(), Constraint.ConnectToStrategy.SAMEPERSONALITY);
        retMap.put(Constraint.METALRING_WIDTH.getName(), "150");
        retMap.put(Constraint.METALRING_DIST.getName(), "600");
        return retMap;
    }

    public void loadDefaultValues() {
        HashMap<String, Object> consMap = this.getDefaultConstraints();
        SimpleConstraintModel scm = (SimpleConstraintModel)this.mTable.getModel();
        for (int row = 0; row < scm.getRowCount(); ++row) {
            SimpleConstraintUIModel scuim = scm.mUIModel.get(row);
            Constraint.Descriptor<?> desc = scuim.desc;
            String name = desc.getName();
            Object value = consMap.get(name);
            scuim.exposedValue = value != null ? value : "";
        }
    }

    public void loadValues() {
        SimpleConstraintModel scm = (SimpleConstraintModel)this.mTable.getModel();
        DbObject owner = scm.mOwner;
        for (int row = 0; row < scm.getRowCount(); ++row) {
            String sVal;
            SimpleConstraintUIModel scuim = scm.mUIModel.get(row);
            Constraint.Descriptor<?> desc = scuim.desc;
            Constraint c = null;
            if (owner != null) {
                c = Constraint.getConstraint((DbObject)owner, desc, (boolean)false);
            }
            Class classType = desc.getType();
            scuim.exposedValue = UNKNOWN_VAL;
            if (classType == AExpression.class) {
                if (c != null) {
                    AExpression ae = (AExpression)c.getValue();
                    scuim.exposedValue = ae.getExpression(false);
                } else {
                    scuim.exposedValue = "";
                }
            }
            if (classType == Double.class) {
                if (c != null) {
                    double dVal = (Double)c.getValue();
                    sVal = Double.toString(dVal);
                    scuim.exposedValue = sVal;
                    continue;
                }
                scuim.exposedValue = "0";
                continue;
            }
            if (classType == Long.class) {
                if (c != null) {
                    long lVal = (Long)c.getValue();
                    sVal = OrbitIO.getCurView().getUnit().toUserStr(lVal);
                    scuim.exposedValue = sVal;
                    continue;
                }
                scuim.exposedValue = "0";
                continue;
            }
            if (classType == Integer.class) {
                if (c != null) {
                    long lVal = ((Integer)c.getValue()).intValue();
                    sVal = Long.toString(lVal);
                    scuim.exposedValue = sVal;
                    continue;
                }
                scuim.exposedValue = "0";
                continue;
            }
            if (classType.isEnum()) {
                if (c != null && c.getValue() != null) {
                    scuim.exposedValue = c.getValue();
                    continue;
                }
                T[] list = classType.getEnumConstants();
                scuim.exposedValue = list[0];
                continue;
            }
            if (classType == Boolean.class) {
                if (c != null) {
                    scuim.exposedValue = c.getValue();
                    continue;
                }
                scuim.exposedValue = Boolean.FALSE;
                continue;
            }
            if (classType == Layer.class) {
                scuim.exposedValue = c == null || c.getValue() == null ? NO_LAYER : c.getValue();
                continue;
            }
            if (classType != PadTemplate.class) continue;
            if (c != null) {
                PadTemplate vrg = (PadTemplate)c.getValue();
                if (vrg != null) {
                    scuim.exposedValue = vrg;
                    continue;
                }
                scuim.exposedValue = DefaultViaName;
                continue;
            }
            scuim.exposedValue = DefaultViaName;
        }
    }

    public static class AViaIcon
    implements Icon {
        protected int mWidth;
        protected int mHeight;
        protected Color mColorT;
        protected Color mColorB;

        public AViaIcon(int width, int height, Color colorT, Color colorB) {
            this.mWidth = width;
            this.mHeight = height;
            this.mColorT = colorT;
            this.mColorB = colorB;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Shape oldClip = g.getClip();
            g.clipRect(x, y, this.mWidth, this.mHeight);
            g.setColor(Color.WHITE);
            g.fillRect(x + 1, y + 1, this.mWidth - 2, this.mHeight - 2);
            int dy = (this.mHeight - 3) / 2;
            g.setColor(this.mColorB);
            g.fillRect(x + 1, y + 1, this.mWidth - 2, y + 1 + dy);
            g.setColor(this.mColorT);
            g.fillRect(x + 1, y + 2 + dy, this.mWidth - 2, y + 2 + dy + dy);
            g.setClip(oldClip);
        }

        @Override
        public int getIconWidth() {
            return this.mWidth;
        }

        @Override
        public int getIconHeight() {
            return this.mHeight;
        }
    }

    class MyListCellRenderer<T>
    extends JLabel
    implements ListCellRenderer<T> {
        Substrate s;

        MyListCellRenderer() {
        }

        public void setSubstrate(Substrate s) {
            this.s = s;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof PadTemplate) {
                PadTemplate via = (PadTemplate)value;
                this.setText(via.getName());
                PinTemplateIcon icon = new PinTemplateIcon(this.s, via, 64, 64);
                icon.setBorderColor(Color.black);
                this.setIcon(icon);
            } else if (value instanceof Layer) {
                APatternColor color;
                Layer l = (Layer)value;
                this.setText(l.getName());
                ViewColorizer colorizer = OrbitIO.getCurColorizer();
                DevicePath path = l.getSubstrate().getADevicePathUsing();
                APatternColor aPatternColor = color = path == null ? null : colorizer.getColor(path, l, true);
                if (color == null) {
                    this.setIcon(null);
                } else {
                    this.setIcon((Icon)new AColorIcon(10, 10, color.getColor()));
                }
            } else {
                this.setText("" + value);
                this.setIcon(null);
            }
            return this;
        }
    }

    static class SimpleConstraintModel
    extends AbstractTableModel {
        DbObject mOwner;
        Substrate mSubstrate;
        ArrayList<SimpleConstraintUIModel> mUIModel;
        private String[] columnNames = new String[]{"Rule", "Value"};

        SimpleConstraintModel(ArrayList<SimpleConstraintUIModel> uiModel, DbObject owner, Substrate substrate) {
            this.mUIModel = uiModel;
            this.mOwner = owner;
            this.mSubstrate = substrate;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.mUIModel.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public String getRowName(int row) {
            Constraint.Descriptor<?> desc = this.mUIModel.get((int)row).desc;
            return desc.getDesc();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Constraint.Descriptor<?> desc = this.mUIModel.get((int)row).desc;
            if (col == 0) {
                return desc.getDesc();
            }
            return this.mUIModel.get((int)row).exposedValue;
        }

        public Class<?> getRowClass(int r) {
            return this.getValueAt(r, 2).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }

    static class ConstraintCellRenderer
    extends DefaultTableCellRenderer {
        ConstraintCellRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Layer) {
                this.setText(((Layer)value).getName());
            } else if (value instanceof PadTemplate) {
                this.setText(((PadTemplate)value).getName());
            } else {
                this.setText((String)(value == null ? "" : "" + value));
            }
        }
    }

    class ConstraintCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        Component using = null;
        SimpleConstraintUIModel scuim = null;
        Object originalValue;
        Boolean requiresValidation = false;
        Substrate substrate = null;

        ConstraintCellEditor() {
        }

        public void setSubstrate(Substrate s) {
            this.substrate = s;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.scuim = SimpleConstraintFrame.this.mUIModelList.get(row);
            Constraint.Descriptor<?> desc = this.scuim.desc;
            Class classType = desc.getType();
            this.originalValue = this.scuim.exposedValue;
            if (classType == AExpression.class || classType == Double.class) {
                JTextField label = new JTextField(this.scuim.exposedValue.toString());
                this.using = label;
                this.requiresValidation = false;
                return label;
            }
            if (classType == Long.class || classType == Integer.class) {
                JTextField label = new JTextField(this.scuim.exposedValue.toString());
                this.using = label;
                this.requiresValidation = true;
                return label;
            }
            if (classType.isEnum()) {
                T[] list = classType.getEnumConstants();
                JComboBox box = new JComboBox();
                for (Object l : list) {
                    box.addItem(l);
                }
                this.using = box;
                this.requiresValidation = false;
                return box;
            }
            if (classType == Layer.class) {
                JComboBox<Object> box = new JComboBox<Object>();
                MyListCellRenderer renderer = new MyListCellRenderer();
                box.setRenderer(renderer);
                if (this.substrate != null) {
                    ArrayList<Layer> sortedLayers = new ArrayList<Layer>();
                    for (Layer l : this.substrate.getLayers()) {
                        sortedLayers.add(l);
                    }
                    Collections.sort(sortedLayers);
                    Collections.reverse(sortedLayers);
                    box.addItem(SimpleConstraintFrame.NO_LAYER);
                    for (Layer l : sortedLayers) {
                        box.addItem(l);
                    }
                }
                this.using = box;
                this.requiresValidation = false;
                return box;
            }
            if (classType == PadTemplate.class) {
                JComboBox<Object> box = new JComboBox<Object>();
                MyListCellRenderer renderer = new MyListCellRenderer();
                renderer.setSubstrate(this.substrate);
                box.setRenderer(renderer);
                if (this.substrate != null) {
                    ArrayList vias = AUtil.arrayList(ViaFactory.getViaTemplates(this.substrate));
                    Collections.sort(vias, PadTemplate.TopLayerSorter.reversed());
                    box.addItem(SimpleConstraintFrame.DefaultViaName);
                    for (PadTemplate pt : vias) {
                        box.addItem(pt);
                    }
                }
                this.using = box;
                this.requiresValidation = false;
                return box;
            }
            if (classType == Boolean.class) {
                JComboBox<Boolean> box = new JComboBox<Boolean>();
                box.addItem(Boolean.TRUE);
                box.addItem(Boolean.FALSE);
                this.using = box;
                this.requiresValidation = false;
                return box;
            }
            return new JTextField();
        }

        @Override
        public Object getCellEditorValue() {
            String s;
            JTextField t;
            if (this.requiresValidation.booleanValue()) {
                t = (JTextField)this.using;
                s = t.getText();
                s = s.replace(",", "");
                try {
                    Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    ALog.logError((Throwable)e, (String)"Invalid Distance", (Object[])new Object[0]);
                    return this.originalValue;
                }
            }
            if (this.using instanceof JTextField) {
                t = (JTextField)this.using;
                s = t.getText();
                this.scuim.exposedValue = s;
            } else if (this.using instanceof JComboBox) {
                JComboBox cbo = (JComboBox)this.using;
                this.scuim.exposedValue = cbo.getSelectedItem();
            }
            this.scuim.changed = true;
            return this.scuim.exposedValue;
        }

        public void done() {
            this.fireEditingStopped();
        }
    }

    static class SimpleConstraintUIModel {
        Constraint.Descriptor<?> desc;
        Object exposedValue;
        boolean changed;

        SimpleConstraintUIModel() {
        }
    }
}

