/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.SubstrateListRenderer;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class SubstrateChooser
extends JComboBox<Substrate> {
    protected Db mDb;
    protected boolean mAllowCreate = false;

    public SubstrateChooser(Db db) {
        this.mDb = db;
        this.setRenderer(new SubstrateListRenderer("<Create New>"));
        this.reload();
    }

    public void setAllowCreate(boolean allowCreate) {
        if (allowCreate == this.mAllowCreate) {
            return;
        }
        this.mAllowCreate = allowCreate;
        if (this.mAllowCreate) {
            this.insertItemAt(null, 0);
        } else {
            this.remove(0);
        }
    }

    public Substrate getSelectedItem() {
        return (Substrate)super.getSelectedItem();
    }

    public void reload() {
        Substrate oldSel = this.getSelectedItem();
        LinkedList elems = new LinkedList();
        if (this.mAllowCreate) {
            elems.add(null);
        }
        this.mDb.getObjects(Substrate.class).stream().sorted(Substrate.NameComparator).forEach(elems::add);
        this.setModel(new DefaultComboBoxModel<Substrate>(elems.toArray(new Substrate[elems.size()])));
        if (oldSel != null) {
            this.setSelectedItem(oldSel);
        }
    }
}

