/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.SubstrateFromFootprintDevice;
import com.sigrity.orbit.ui.LayerListCellRenderer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class SubstrateFromFootprintDeviceUI {
    public static final String SettingSection = AReflection.getJavaClassName(SubstrateFromFootprintDeviceUI.class);
    public static final String Setting_ContactOpt = "ContactOpt";
    public static SubstrateFromFootprintDevice.ContactCreationOpt Setting_ContactOpt_Dflt = SubstrateFromFootprintDevice.ContactCreationOpt.Pins;
    public static final String Setting_ShowDeviceContactOpt = "ShowDeviceContactOpt";
    public static boolean Setting_ShowDeviceContactOpt_Dflt = false;
    public static final String Setting_AssignPinPersonalities = "AssignPinPersonalities";
    public static boolean Setting_AssignPinPersonalities_Dflt = true;

    public static void PromoteBGAFootPrint(Window uiOwner, DeviceTemplate devT) {
        DeviceTemplate.Type refType;
        ADialog optDlg = new ADialog(OrbitIO.getMainWindow());
        optDlg.setTitle("New Substrate Device Options");
        optDlg.setRecallBounds(false);
        GridBagManager l = GridBagManager.layout((JDialog)optDlg);
        l.add("New type:");
        JComboBox<DeviceTemplate.Type> cboType = new JComboBox<DeviceTemplate.Type>();
        JLabel lblNewType = (JLabel)l.add((Component)new JLabel());
        l.newline();
        l.add("Contact layer:");
        JComboBox cboContactLayer = (JComboBox)l.add(new JComboBox());
        l.newline();
        JComboBox<SubstrateFromFootprintDevice.ContactCreationOpt> cboContactOpt = new JComboBox<SubstrateFromFootprintDevice.ContactCreationOpt>();
        l.newline();
        l.add("Net names:");
        JComboBox cboNetOpt = (JComboBox)l.add(new JComboBox());
        l.newline();
        l.add("Create flipped:");
        JCheckBox cbFlipped = (JCheckBox)l.add((Component)new JCheckBox());
        l.newline();
        l.add("Create pins on layer:");
        JComboBox cboNewPinsLayer = (JComboBox)l.add(new JComboBox());
        cboNewPinsLayer.setRenderer(LayerListCellRenderer.create());
        l.newline();
        l.add("Assign pin personalities:");
        JCheckBox cbAssignPinPers = (JCheckBox)l.add((Component)new JCheckBox(""));
        l.newline();
        l.addFillY();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        cboType.addItem(DeviceTemplate.Type.PACKAGE);
        cboType.addItem(DeviceTemplate.Type.PACKAGEDDIE);
        cboType.addItem(DeviceTemplate.Type.DIE);
        List parentTypes = devT.getDeviceInstances().stream().map(Device::getParent).map(DeviceTemplate::getType).distinct().collect(Collectors.toList());
        DeviceTemplate.Type type = refType = parentTypes.size() == 1 ? (DeviceTemplate.Type)parentTypes.get(0) : devT.getType();
        if (refType == DeviceTemplate.Type.DIE || refType == DeviceTemplate.Type.PACKAGE) {
            cboType.setSelectedItem(DeviceTemplate.Type.DIE);
        } else {
            cboType.setSelectedItem(DeviceTemplate.Type.PACKAGE);
        }
        if (cboType.getSelectedItem() == DeviceTemplate.Type.DIE) {
            cbFlipped.setSelected(true);
        }
        ActionListener tgtLayersUpdateListener = event -> {
            DeviceTemplate.Type selType = (DeviceTemplate.Type)cboType.getSelectedItem();
            lblNewType.setText("" + selType);
            DefaultComboBoxModel m = (DefaultComboBoxModel)cboNewPinsLayer.getModel();
            m.removeAllElements();
            Substrate.getDefaultLayers((DeviceTemplate.Type)selType, null).forEach(lyr -> {
                if (cbFlipped.isSelected()) {
                    m.addElement(lyr);
                } else {
                    m.insertElementAt(lyr, 0);
                }
            });
            if (m.getSize() > 0) {
                cboNewPinsLayer.setSelectedIndex(m.getSize() - 1);
            }
        };
        cboType.addActionListener(tgtLayersUpdateListener);
        cbFlipped.addActionListener(tgtLayersUpdateListener);
        tgtLayersUpdateListener.actionPerformed(null);
        for (Layer lyr : devT.getSubstrate().getLayers(Layer.TopFirstSort)) {
            cboContactLayer.addItem(lyr);
        }
        cboContactLayer.setRenderer(LayerListCellRenderer.create());
        SubstrateFromFootprintDevice.ContactCreationOpt selectCco = SubstrateFromFootprintDevice.ContactCreationOpt.Pins;
        boolean showDeviceContactOpt = (Boolean)Settings.get((String)SettingSection, (String)Setting_ShowDeviceContactOpt, (Object)Setting_ShowDeviceContactOpt_Dflt);
        for (SubstrateFromFootprintDevice.ContactCreationOpt o : SubstrateFromFootprintDevice.ContactCreationOpt.values()) {
            if (o == SubstrateFromFootprintDevice.ContactCreationOpt.Device && !showDeviceContactOpt) continue;
            if (o == SubstrateFromFootprintDevice.ContactCreationOpt.Pins) {
                for (Device srcDev : devT.getDeviceInstances()) {
                    DeviceTemplate parentDevT = srcDev.getParent();
                    if (parentDevT != null && parentDevT.getSubstrate() == devT.getSubstrate() || selectCco != o) continue;
                    if (showDeviceContactOpt) {
                        selectCco = SubstrateFromFootprintDevice.ContactCreationOpt.Device;
                        continue;
                    }
                    selectCco = SubstrateFromFootprintDevice.ContactCreationOpt.None;
                }
            }
            cboContactOpt.addItem(o);
        }
        cboContactOpt.setSelectedItem(selectCco);
        boolean hasExactlyOneDeviceInstance = devT.hasExactlyOneDeviceInstance();
        for (SubstrateFromFootprintDevice.NetCreationOpt o : SubstrateFromFootprintDevice.NetCreationOpt.values()) {
            if (o == SubstrateFromFootprintDevice.NetCreationOpt.Pin || o == SubstrateFromFootprintDevice.NetCreationOpt.ParentNet && !hasExactlyOneDeviceInstance) continue;
            cboNetOpt.addItem(o);
        }
        cboNetOpt.setSelectedItem(SubstrateFromFootprintDevice.NetCreationOpt.Net);
        cbAssignPinPers.setSelected((Boolean)Settings.get((String)SettingSection, (String)Setting_AssignPinPersonalities, (Object)Setting_AssignPinPersonalities_Dflt));
        btnOk.addActionListener(event -> {
            Settings.set((String)SettingSection, (String)Setting_ContactOpt, (Object)((SubstrateFromFootprintDevice.ContactCreationOpt)cboContactOpt.getSelectedItem()));
            Settings.set((String)SettingSection, (String)Setting_AssignPinPersonalities, (Object)cbAssignPinPers.isSelected());
            Settings.save((String)SettingSection);
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)devT.getDb(), (String)"Substrate from footprint");){
                Cp.exec((String)"unset(\"_ssff\")", (Object[])new Object[0]);
                Cp.exec((String)"_ssff = %s.create(curDb(), \"%s\", %s.%s, \"%s\")", (Object[])new Object[]{SubstrateFromFootprintDevice.class.getName(), devT.getKeyStr(), AReflection.getJavaClassName(DeviceTemplate.Type.class), ((DeviceTemplate.Type)cboType.getSelectedItem()).name(), ((Layer)cboContactLayer.getSelectedItem()).getName()});
                Cp.exec((String)"_ssff.setContactCreationOpt(%s.%s)", (Object[])new Object[]{AReflection.getJavaClassName(SubstrateFromFootprintDevice.ContactCreationOpt.class), ((Enum)cboContactOpt.getSelectedItem()).name()});
                Cp.exec((String)"_ssff.setNetCreationOpt(%s.%s)", (Object[])new Object[]{AReflection.getJavaClassName(SubstrateFromFootprintDevice.NetCreationOpt.class), ((Enum)cboNetOpt.getSelectedItem()).name()});
                Cp.exec((String)"_ssff.setAssignPinPersonalities(%b)", (Object[])new Object[]{cbAssignPinPers.isSelected()});
                if (cbFlipped.isSelected()) {
                    Cp.exec((String)"_ssff.setCreateFlipped(true)", (Object[])new Object[0]);
                }
                if (cboNewPinsLayer.getSelectedItem() != null) {
                    Layer pinLayer = (Layer)cboNewPinsLayer.getSelectedItem();
                    Cp.exec((String)"_ssff.setPinCreationLayer(\"%s\")", (Object[])new Object[]{pinLayer.getName()});
                }
                Object res = Cp.exec((String)"_ssff.createSubstrate()", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_ssff\")", (Object[])new Object[0]);
                if (res instanceof DeviceTemplate) {
                    DeviceTemplate newDevT = (DeviceTemplate)res;
                    OrbitIO.refreshViewsOf(newDevT.getDb());
                } else {
                    ALog.logWarn((String)"Unexpected result type '%s' from %s.", (Object[])new Object[]{AReflection.getClassNameOfObject((Object)res), AReflection.getJavaClassName(SubstrateFromFootprintDevice.class)});
                }
            }
            UIUtil.closeWindow((Window)optDlg);
        });
        UIUtil.enableEscCloseDefault((JDialog)optDlg, (AbstractButton)btnCancel, (JButton)btnOk);
        optDlg.pack();
        optDlg.setMinimumSize(optDlg.getPreferredSize());
        UIUtil.center((Component)optDlg);
        optDlg.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        optDlg.setVisible(true);
    }

    public static Action createAction(final Window uiOwner, final DeviceTemplate devT) {
        AbstractAction a = new AbstractAction("Synthesize Substrate Device From Footprint..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstrateFromFootprintDeviceUI.PromoteBGAFootPrint(uiOwner, devT);
            }
        };
        a.putValue("ShortDescription", "Create a new substrate and template using this template as a contact footprint definition.");
        return a;
    }
}

