/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.Lists;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbTrigger;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.ASpinner;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.BabylonFile;
import com.sigrity.orbit.oio3d.A3DViewPanel;
import com.sigrity.orbit.oio3d.Cube;
import com.sigrity.orbit.ui.DeleteDeviceUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.table_editor.EditContactLayerUI;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class SubstrateStackUI
extends DbDialog {
    private static final int CONTACTLAYER_PANEL_MIN_WIDTH = 600;
    private static final int CONTACTLAYER_PANEL_MIN_HEIGHT = 200;
    public static final DataFlavor SubstrateDataFlavor = new DataFlavor(Substrate.class, "Substrate");
    protected AAppView mOrbitView;
    protected ASplitPane mDlgContentPanel;
    protected ASplitPane mSplitter;
    protected JPanel mPnlTree;
    protected JPanel mPnlView;
    protected Container mPnlContactLayer;
    protected SubstrateList mLstSubstrates;
    protected JButton mBtnEditSubstrate;
    protected JButton mBtnAddView;
    protected JButton mBtn3dView;
    protected JSlider mZoomSlider;
    protected ViewPort mViewPort;
    protected JCheckBox mChkPins;
    protected JComboBox<String> jCmbViews;
    protected CanvasMonitor mMonitor;
    protected JPanel mPnlViewLinks;
    protected View3D mView3d;
    protected DevicePath mLastHightlighted = null;
    protected JToggleButton mBtnAutoContact;
    protected ActionListener mToggleStackView = e -> this.setView(this.get3dViewVisible());
    protected ActionListener mAddView = e -> this.mViewPort.addView();
    protected ListSelectionListener mSubstrateSelectionListener = e -> {
        this.enableButtons();
        DevicePath path = this.mViewPort.getSelectedDevice();
        if (path.equals((Object)this.mLastHightlighted)) {
            return;
        }
        if (this.mView3d != null) {
            try {
                if (this.mLastHightlighted != null) {
                    this.mView3d.updateColor(this.mLastHightlighted);
                }
                if (path != null) {
                    this.mView3d.updateColor(path);
                }
            }
            catch (Exception ex) {
                ALog.logWarn((Throwable)ex, (String)"Error updating selection in view.", (Object[])new Object[0]);
            }
        }
        this.mLastHightlighted = path;
    };
    protected ActionListener mEditSubstrate = e -> {
        DevicePath path = this.mViewPort.getSelectedDevice();
        if (path == null) {
            return;
        }
        Substrate substrate = path.getSubstrate();
        assert (substrate != null);
        if (substrate == null) {
            return;
        }
        Unit unit = this.mOrbitView.getUnit();
        long zLocOrig = Substrate.getZLoc((DevicePath)path);
        String strZLocOrig = unit.toUserStr(zLocOrig, false);
        long heightOrig = substrate.getHeight();
        String strHeightOrig = unit.toUserStr(heightOrig, false);
        ADialog dlg = new ADialog((Window)((Object)this), "Edit " + this.mViewPort.getSelectedName(), ADialog.DEFAULT_MODALITY_TYPE);
        GridBagManager l = new GridBagManager(dlg.getContentPane());
        l.push("Position", (GridBagConstraints)GridBagManager.FILLX);
        l.add("Z Location:");
        JTextField txtZLoc = new JTextField(10);
        l.add((Component)txtZLoc, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        txtZLoc.setText(strZLocOrig);
        l.newline();
        l.add("Height:");
        JTextField txtHeight = new JTextField(10);
        l.add((Component)txtHeight, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        txtHeight.setText(strHeightOrig);
        l.addFillX();
        l.pop();
        l.newline();
        l.addFillY();
        l.newline();
        l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(event -> {
            long heightNew;
            try {
                AFieldValidator.validateDouble((JTextField)txtHeight);
                AFieldValidator.validateDouble((JTextField)txtZLoc);
            }
            catch (AFieldValidator.AFieldValidationException e1) {
                return;
            }
            boolean changed = false;
            long zLocNew = unit.fromUserString(txtZLoc.getText());
            if (zLocNew != zLocOrig) {
                changed |= SubstrateStackUI.setSubstrateZ(path, zLocNew);
            }
            if ((heightNew = unit.fromUserString(txtHeight.getText()).longValue()) != heightOrig) {
                changed |= SubstrateStackUI.setSubstrateHeight(path, heightNew);
            }
            if (changed) {
                this.mLstSubstrates.refreshData();
                if (this.mView3d != null) {
                    this.mView3d.notifyChanged(path);
                }
            }
            UIUtil.closeWindow((Window)dlg);
            this.mViewPort.refresh();
        });
        JButton btnCancel = new JButton("Cancel");
        l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefault((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
        dlg.pack();
        dlg.setResizable(false);
        UIUtil.center((Component)dlg);
        dlg.setVisible(true);
    };
    static final int AXIS_X = 0;
    static final int AXIS_Y = 1;
    static final int AXIS_Z = 2;
    private JSplitPane mRootSplitPane;

    public static Action getAction() {
        return new AbstractAction("Design Stack"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstrateStackUI.createDlg(OrbitIO.getCurView(), OrbitIO.getCurDb()).setVisible(true);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static SubstrateStackUI createDlg(AAppView owner, Db db) {
        return new SubstrateStackUI(UIUtil.getParentWindow((Component)owner.getComponent()), db, owner);
    }

    public SubstrateStackUI(Window owner, Db db, AAppView view) {
        super(db, (Component)owner);
        this.setTitle("Design Stack Editor");
        this.mDb = db;
        this.mOrbitView = view;
        this.mPnlContactLayer = this.setDownLayout();
        this.mDlgContentPanel = new ASplitPane();
        this.mDlgContentPanel.setOneTouchExpandable(true);
        this.mBtnAddView = new JButton("+");
        this.mBtnAddView.addActionListener(this.mAddView);
        boolean view3dVisible = (Boolean)Settings.get((String)"GUI", (String)"SubstrateStackPreviewVisible", (Object)false);
        this.setView(view3dVisible);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        this.mRootSplitPane = new JSplitPane(0, this.mDlgContentPanel, this.mPnlContactLayer);
        this.mRootSplitPane.setOneTouchExpandable(true);
        l.add((Component)this.mRootSplitPane, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        this.mBtnEditSubstrate = (JButton)l.add((Component)new JButton("Edit"), (GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnEditSubstrate.addActionListener(this.mEditSubstrate);
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.pack();
        this.enableButtons();
        this.mViewPort.setUp();
        this.mMonitor = new CanvasMonitor();
        this.mMonitor.setActive(true);
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.makeFootButton((AbstractButton)this.mBtnEditSubstrate);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
        UIUtil.center((Component)((Object)this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SubstrateStackUI.this.mMonitor.setActive(false);
            }
        });
    }

    private JPanel setTreeLayout(JPanel pnl) {
        GridBagManager leftLayout = new GridBagManager((Container)pnl);
        this.mLstSubstrates = new SubstrateList();
        this.mLstSubstrates.setCellRenderer(new DevicePathCellRenderer());
        this.mLstSubstrates.setSelectionMode(0);
        this.mLstSubstrates.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    SubstrateStackUI.this.mViewPort.reColor(((DevicePath)SubstrateStackUI.this.mLstSubstrates.getSelectedValue()).getLast().getName());
                    if (e.getClickCount() == 2) {
                        SubstrateStackUI.this.mBtnEditSubstrate.doClick();
                    }
                }
            }
        });
        JScrollPane spLayers = new JScrollPane(this.mLstSubstrates);
        leftLayout.add((Component)spLayers, (GridBagConstraints)GridBagManager.FILLALL.insetTop(12));
        leftLayout.newline();
        ASpinner spin = new ASpinner(ASpinner.SpinnerLayout.HORIZONTAL);
        spin.setUpToolTip("Increase the stacking order in Z direction");
        spin.addUpActionListener(e -> this.moveSelected(true));
        spin.setDownToolTip("Decrease the stacking order in Z direction");
        spin.addDownActionListener(e -> this.moveSelected(false));
        String autoContactMsg = "Automatically stack substrates according to the contact layers.";
        this.mBtnAutoContact = new JToggleButton("Auto Stacking");
        this.mBtnAutoContact.setToolTipText(autoContactMsg);
        this.mBtnAutoContact.addActionListener(ae -> {
            this.mViewPort.setAutoContact(this.mBtnAutoContact.isSelected());
            this.mViewPort.refresh();
        });
        JPanel btnPanel = new JPanel();
        GridBagManager btn = new GridBagManager((Container)btnPanel);
        btn.add((Component)spin, (GridBagConstraints)GridBagManager.LEFT);
        btn.add((Component)this.mBtnAutoContact, (GridBagConstraints)GridBagManager.LEFT);
        leftLayout.add((Component)btnPanel, (GridBagConstraints)GridBagManager.TOPLEFT);
        this.pack();
        return pnl;
    }

    private JPanel setViewLayout(JPanel pnl) {
        GridBagManager rightLayout = new GridBagManager((Container)pnl);
        this.mViewPort = (ViewPort)rightLayout.add((Component)new ViewPort(), (GridBagConstraints)GridBagManager.FILLALL);
        return pnl;
    }

    private Container setDownLayout() {
        EditContactLayerUI.TableBodyPanel contactLayerPane = EditContactLayerUI.getBodyPanel((Window)((Object)this), this.mDb);
        ((Component)((Object)contactLayerPane)).setMinimumSize(new Dimension(600, 200));
        return contactLayerPane;
    }

    protected boolean get3dViewVisible() {
        return this.mView3d != null;
    }

    protected void setView(boolean view3dVisible) {
        if (view3dVisible) {
            this.set3dView();
        } else {
            this.set2dView();
        }
        Settings.set((String)"GUI", (String)"SubstrateStackPreviewVisible", (Object)this.get3dViewVisible());
        Settings.save((String)"GUI");
    }

    protected void set3dView() {
        try {
            this.mView3d = new View3D();
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Unable to create stack view. 3D viewing may not be available using the current platform configuration.", (Object[])new Object[0]);
        }
        this.mDlgContentPanel.removeAll();
        GridBagManager rightLayout = new GridBagManager((Container)this.mPnlView);
        this.mPnlViewLinks = new JPanel();
        this.mSplitter = new ASplitPane();
        Insets insets = this.mSplitter.getInsets();
        rightLayout.add((Component)this.mPnlViewLinks, (GridBagConstraints)GridBagManager.FILLX.insets(insets.left, 0));
        rightLayout.newline();
        this.mView3d.setPreferredSize(new Dimension(200, 200));
        this.mView3d.setMinimumSize(this.getPreferredSize());
        try {
            rightLayout.add((Component)this.mView3d, (GridBagConstraints)GridBagManager.FILLALL);
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Unable to create stack view. 3D viewing may not be available on the current graphics device.", (Object[])new Object[0]);
            this.set2dView();
            return;
        }
        this.mView3d.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagManager pl = new GridBagManager((Container)this.mPnlViewLinks);
        pl.add("View:");
        for (final String viewName : this.mView3d.getDefinedViews()) {
            String text = String.format("<html><a href='#'>%s</a></html>", viewName);
            JLabel lbl = pl.add(text);
            lbl.setCursor(Cursor.getPredefinedCursor(12));
            lbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SubstrateStackUI.this.mView3d.setView(viewName);
                }
            });
        }
        pl.addFillX();
        this.mPnlViewLinks.setMinimumSize(this.getPreferredSize());
        this.pack();
        this.validate();
    }

    protected void set2dView() {
        this.mView3d = null;
        this.mPnlTree = this.setTreeLayout(new JPanel());
        this.mPnlView = this.setViewLayout(new JPanel());
        this.mDlgContentPanel.setLeftComponent(this.mPnlTree);
        this.mDlgContentPanel.setRightComponent(this.mPnlView);
    }

    protected void moveSelected(boolean up) {
        DevicePath moveLayer = (DevicePath)this.mLstSubstrates.getSelectedValue();
        int moveIndex = this.mLstSubstrates.getSelectedIndex();
        if (moveIndex < 0) {
            return;
        }
        int otherIndex = moveIndex + (up ? -1 : 1);
        if (otherIndex >= 0 && otherIndex < this.mLstSubstrates.getModel().getSize()) {
            this.mLstSubstrates.mData.swap(moveIndex, otherIndex);
            this.mLstSubstrates.setSelectedValue(moveLayer, true);
            this.enableButtons();
            this.mViewPort.refresh();
        }
    }

    protected void enableButtons() {
        boolean enable = false;
        if (this.mViewPort != null && this.mViewPort.getSelectedDevice() != null && !this.mViewPort.getSelectedName().equals("") && this.mViewPort.getSelectedDevice().getLast().getName().equals(this.mViewPort.getSelectedName())) {
            enable = true;
        }
        this.mBtnEditSubstrate.setEnabled(enable);
    }

    protected void setWindowSize(Dimension d) {
        this.setSize(d);
    }

    protected void bufferWindow() {
        int width = (int)this.getWindowSize().getWidth();
        int height = (int)this.getWindowSize().getHeight();
        this.setSize(new Dimension(width + 1, height + 1));
        this.setSize(new Dimension(width, height));
    }

    protected Dimension getWindowSize() {
        return this.getSize();
    }

    protected static boolean setSubstrateZ(DevicePath path, long zLocNew) {
        String parentSubstrateName;
        String parentName;
        long zLocOrig = Substrate.getZLoc((DevicePath)path);
        long diff = zLocNew - zLocOrig;
        long localZ = Substrate.getZLoc((Device)path.getLast());
        long newLocalZ = localZ + diff;
        DevicePath parentPath = path.getParent();
        if (parentPath.isDesign()) {
            parentName = "<Design>";
            parentSubstrateName = "null";
        } else {
            parentName = parentPath.getLast().getTemplate().getName();
            parentSubstrateName = String.format("\"%s\"", parentPath.getLast().getTemplate().getSubstrate().getName());
        }
        String childDevice = path.getLast().getName();
        return (Boolean)Cp.exec((String)"com.sigrity.orbit.ui.SubstrateStackUI.setSubstrateZ(curDb(), %s, \"%s\", \"%s\", %dL)", (Object[])new Object[]{parentSubstrateName, parentName, childDevice, newLocalZ});
    }

    protected static boolean setSubstrateHeight(DevicePath path, long heightNew) {
        Substrate substrate = path.getSubstrate();
        if (substrate == null) {
            return false;
        }
        return (Boolean)Cp.exec((String)"com.sigrity.orbit.ui.SubstrateStackUI.setSubstrateHeight(null, \"%s\", %dL)", (Object[])new Object[]{path.getSubstrate().getName(), heightNew});
    }

    public static boolean setSubstrateZ(Db db, String parentSubstrateName, String parentTemplateName, String childDeviceName, long zLoc) {
        Substrate s;
        Device d;
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if ((d = Device.getChildDevice((Db)db, (Substrate)(s = parentSubstrateName == null ? null : Substrate.getSubstrate((Db)db, (String)parentSubstrateName)), (String)parentTemplateName, (String)childDeviceName)) == null) {
            ALog.logWarn((String)"The template '%s' has no child substrate named '%s', unable to set it's z location.", (Object[])new Object[]{parentTemplateName, childDeviceName});
            return false;
        }
        if (!d.getIsSubstrate()) {
            ALog.logWarn((String)"The template '%s' child named '%s' is not a substrate, unable to set it's z location.", (Object[])new Object[]{parentTemplateName, childDeviceName});
            return false;
        }
        Substrate.setZLoc((Device)d, (long)zLoc);
        return true;
    }

    public static boolean setSubstrateHeight(Db db, String substrateName, long height) {
        Substrate substrate;
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if ((substrate = Substrate.getSubstrate((Db)db, (String)substrateName)) == null) {
            ALog.logWarn((String)"Substrate '%s' cannot be found, unable to set it's height.", (Object[])new Object[]{substrateName});
            return false;
        }
        substrate.setHeight(height);
        return true;
    }

    public static DeviceTemplate createSpacerTemplate(Db db, String name, long llx, long lly, long urx, long ury, long dz) {
        Substrate spacerSubstrate = Substrate.create((Db)db, (String)name, (boolean)true);
        spacerSubstrate.setHeight(dz);
        DeviceTemplate spacerTemplate = DeviceTemplate.create((Substrate)spacerSubstrate, (String)name, (boolean)true);
        spacerTemplate.setType(DeviceTemplate.Type.SPACER);
        spacerTemplate.setBounds((AGeom)new ARect(llx, lly, urx, ury));
        return spacerTemplate;
    }

    public static Device createSpacerDevice(Db db, String spacerTKey, String parentKey, String instName) {
        DeviceTemplate spacerTemplate = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, spacerTKey);
        DeviceTemplate parent = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, parentKey);
        return Device.create((Db)db, (String)instName, (DeviceTemplate)spacerTemplate, (DeviceTemplate)parent);
    }

    public static void getCurrentView3D() {
        try {
            BabylonFile f = new BabylonFile();
            f.writeFile();
            f.open();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error create view 3D", (Object[])new Object[0]);
        }
    }

    public static File getCurrentView3DHtml() {
        try {
            BabylonFile f = new BabylonFile();
            f.writeFile();
            return f.getFile();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error create view 3D", (Object[])new Object[0]);
            return null;
        }
    }

    public static class zOrderDescendingComparator
    implements Comparator<ShapeInfo> {
        @Override
        public int compare(ShapeInfo a, ShapeInfo b) {
            return Long.compare(b.getPointZ(), a.getPointZ());
        }
    }

    public static class zOrderAscendingComparator
    implements Comparator<ShapeInfo> {
        @Override
        public int compare(ShapeInfo a, ShapeInfo b) {
            return Long.compare(a.getPointZ() + a.getPointZ(), b.getPointZ() + b.getPointZ());
        }
    }

    public static class xOrderDescendingComparator
    implements Comparator<ShapeInfo> {
        @Override
        public int compare(ShapeInfo a, ShapeInfo b) {
            return Long.compare(b.getPointX(), a.getPointX());
        }
    }

    public static class xOrderAscendingComparator
    implements Comparator<ShapeInfo> {
        @Override
        public int compare(ShapeInfo a, ShapeInfo b) {
            return Long.compare(a.getPointX() + a.getPointX(), b.getPointX() + b.getPointX());
        }
    }

    public static class yOrderDescendingComparator
    implements Comparator<ShapeInfo> {
        @Override
        public int compare(ShapeInfo a, ShapeInfo b) {
            return Long.compare(b.getPointY(), a.getPointY());
        }
    }

    public static class yOrderAscendingComparator
    implements Comparator<ShapeInfo> {
        @Override
        public int compare(ShapeInfo a, ShapeInfo b) {
            return Long.compare(a.getPointY() + a.getPointY(), b.getPointY() + b.getPointY());
        }
    }

    public class CanvasMonitor
    implements Consumer<DbTrigger.Txn> {
        private DbTrigger mTrigger = DbTrigger.create((Consumer)this, (Supplier)OrbitApp.getApp().getDbSupplier()).fieldChange(true, DeviceTemplate.class, new String[]{"bounds"}).fieldChange(true, Device.class, new String[]{"loc", "mirror"}).fieldChange(true, Substrate.class, new String[]{"height"}).fieldChange(true, Layer.class, new String[]{"thickness"}).fieldChange(true, ContactLayer.class, new String[]{"height"}).objectChange(ContactLayer.class, new DbTrigger.ObjEvent[]{DbTrigger.ObjEvent.Add}).objectChange(ContactLayer.class, new DbTrigger.ObjEvent[]{DbTrigger.ObjEvent.Del});

        public void setActive(boolean active) {
            this.mTrigger.setActive(active);
        }

        @Override
        public void accept(DbTrigger.Txn t) {
            boolean active = this.mTrigger.getActive();
            this.setActive(false);
            SubstrateStackUI.this.mViewPort.refresh();
            this.setActive(active);
        }
    }

    protected static class ShapeInfo {
        private long[] mPoint = new long[3];
        private long[] mSize = new long[3];
        private String mName;
        private boolean mFlipped;
        private Color mColor;
        private DevicePath mPath;
        private AGeom mGeom;

        public static LinkedList<ShapeInfo> makeShapeInfoList(List<DevicePath> paths, ViewPort v) {
            LinkedList<ShapeInfo> shapes = ShapeInfo.getShapes(paths, v);
            if (v.getAutoContact()) {
                for (int i = 0; i < shapes.size(); ++i) {
                    ShapeInfo.addContactHeight(shapes, i);
                }
            }
            return shapes;
        }

        private static LinkedList<ShapeInfo> getShapes(List<DevicePath> paths, ViewPort v) {
            LinkedList<ShapeInfo> shapes = new LinkedList<ShapeInfo>();
            for (DevicePath dp : paths) {
                shapes.add(new ShapeInfo(dp, v));
            }
            return shapes;
        }

        private static void addContactHeight(LinkedList<ShapeInfo> shapes, int curId) {
            ShapeInfo curShape = shapes.get(curId);
            DevicePath curPath = curShape.getPath();
            Long maxZ = ShapeInfo.getHighestContactZ(shapes, curId);
            if (maxZ != null) {
                curShape.mPoint[2] = maxZ + curShape.mSize[2];
                SubstrateStackUI.setSubstrateZ(curPath, maxZ);
            }
        }

        private static Long getHighestContactZ(LinkedList<ShapeInfo> shapes, int curId) {
            ShapeInfo curShape = shapes.get(curId);
            List<ContactLayer> contactLayers = ShapeInfo.getContacts(curShape.getPath());
            Long maxZ = null;
            for (ContactLayer cl : contactLayers) {
                Optional<Long> r = shapes.subList(0, curId).stream().filter(shape -> cl.isContacted(shape.getPath()) && curShape.isHigherOrder((ShapeInfo)shape, cl)).map(shape -> shape.getContactZLoc(cl)).max(Comparator.comparing(Long::valueOf));
                if (!r.isPresent()) continue;
                maxZ = maxZ == null || r.get() > maxZ ? r.get() : maxZ;
            }
            return maxZ;
        }

        private static List<ContactLayer> getContacts(DevicePath dPath) {
            return ContactLayer.getValid((Db)dPath.getDb()).parallelStream().filter(cl -> cl.isContacted(dPath)).collect(Collectors.toList());
        }

        protected ShapeInfo(DevicePath path, ViewPort v) {
            this.mName = path.getLast().getName();
            this.mColor = v == null ? Color.BLACK : v.getNewColor();
            this.mPath = path;
            this.mFlipped = path.getLast().getFlipped();
            this.mGeom = path.getLast().getTemplate().getBounds();
            if (this.mGeom == null) {
                this.mGeom = path.getLast().getTemplate().getExtent();
            }
            ARect r = path.getLast().getAllWorldBounds();
            APoint2D uL = r.getUL();
            long height = path.getSubstrate().getHeight();
            this.mPoint[0] = uL.getX();
            this.mPoint[1] = uL.getY();
            this.mPoint[2] = Substrate.getZLoc((DevicePath)path) + height;
            this.mSize[0] = r.width();
            this.mSize[1] = r.height();
            this.mSize[2] = height;
        }

        public boolean isHigherOrder(ShapeInfo other, ContactLayer cl) {
            Layer topLayer;
            Layer layer = cl.isContactWithPathA(this.getPath()) ? cl.getContactLayerA() : cl.getContactLayerB();
            Layer bottomLayer = this.getFlipped() ? layer.getSubstrate().getTopLayer() : layer.getSubstrate().getBottomLayer();
            Layer otherLayer = cl.isContactWithPathA(other.getPath()) ? cl.getContactLayerA() : cl.getContactLayerB();
            Layer layer2 = topLayer = other.getFlipped() ? otherLayer.getSubstrate().getBottomLayer() : otherLayer.getSubstrate().getTopLayer();
            if (layer == bottomLayer && otherLayer == topLayer) {
                return true;
            }
            ARect bound = this.getPath().getBB();
            ARect otherBound = other.getPath().getBB();
            return otherBound.contains((AGeom)bound);
        }

        public AGeom getGeom() {
            return this.mGeom;
        }

        public long getPointX() {
            return this.mPoint[0];
        }

        public long getPointY() {
            return this.mPoint[1];
        }

        public long getPointZ() {
            return this.mPoint[2];
        }

        public long getSizeX() {
            return this.mSize[0];
        }

        public long getSizeY() {
            return this.mSize[1];
        }

        public long getSizeZ() {
            return this.mSize[2];
        }

        public long[] getPoints() {
            return this.mPoint;
        }

        public long[] getSize() {
            return this.mSize;
        }

        public IterableIterator<PinInstance> getPins() {
            return this.mPath.getLast().getPins();
        }

        public DevicePath getPath() {
            return this.mPath;
        }

        public boolean getFlipped() {
            return this.mFlipped;
        }

        public long getHorizontalMax(int index) {
            if (index == 0) {
                return this.mPoint[index] + this.mSize[index];
            }
            return this.mPoint[index];
        }

        public long getHorizontalMin(int index) {
            if (index == 0) {
                return this.mPoint[index];
            }
            return this.mPoint[index] - this.mSize[index];
        }

        public long getVerticalMax(int index) {
            return this.mPoint[index];
        }

        public long getVerticalMin(int index) {
            return this.mPoint[index] - this.mSize[index];
        }

        public Color getColor() {
            return this.mColor;
        }

        public String toString() {
            return this.mName;
        }

        private long getBottomZLoc() {
            return this.mPoint[2] - this.mSize[2];
        }

        private long getLayerRelZLoc(Layer layer) {
            long zLoc = layer.getSubstrate().getTopLayer() == layer ? layer.getSubstrate().getHeight() : (layer.getSubstrate().getBottomLayer() == layer ? 0L : layer.getZLoc() + layer.getHeight());
            return this.getFlipped() ? layer.getSubstrate().getHeight() - zLoc : zLoc;
        }

        private long getContactZLoc(ContactLayer cl) {
            Layer layer = cl.isContactWithPathA(this.getPath()) ? cl.getContactLayerA() : cl.getContactLayerB();
            return this.getBottomZLoc() + this.getLayerRelZLoc(layer) + cl.getHeight();
        }
    }

    private class CanvasPolygon
    extends Rectangle {
        private Shape mGeom;
        private String mName;
        private APoint2D mNameLocation;
        private boolean mMirrored;
        private char mFlipped;
        private APoint2D mOriginalNameLocation;
        private Color mColor;
        private DevicePath mPath;

        protected CanvasPolygon(APoint2D upperLeft, APoint2D lowerRight, DevicePath path, boolean mirrored, char flipped, Color color, Shape s) {
            if (!mirrored) {
                super.setLocation((int)upperLeft.getX(), (int)upperLeft.getY());
            } else {
                super.setLocation((int)lowerRight.getX(), (int)upperLeft.getY());
            }
            this.setSize(Math.abs((int)(upperLeft.getX() - lowerRight.getX())), Math.abs((int)(upperLeft.getY() - lowerRight.getY())));
            this.mName = path.getLast().getName();
            this.mMirrored = mirrored;
            this.mFlipped = flipped;
            this.mColor = color;
            this.mGeom = s;
            this.mPath = path;
            this.setUpName();
        }

        public void setUpName() {
            this.mNameLocation = new APoint2D(this.getUL().getX(), this.getUL().getY());
            this.mNameLocation.setY(this.mNameLocation.getY() + 10L);
            this.mOriginalNameLocation = this.mNameLocation;
        }

        public Point getUR() {
            return new Point((int)(this.getLocation().getX() + this.getSize().getWidth()), (int)this.getLocation().getY());
        }

        public Point getUL() {
            return new Point((int)this.getLocation().getX(), (int)this.getLocation().getY());
        }

        public Point getLL() {
            return new Point((int)this.getLocation().getX(), (int)(this.getLocation().getY() + this.getSize().getHeight()));
        }

        public Point getLR() {
            return new Point((int)(this.getLocation().getX() + this.getSize().getWidth()), (int)(this.getLocation().getY() + this.getSize().getHeight()));
        }

        public Shape getGeom() {
            return this.mGeom;
        }

        public void resetNameLocation() {
            this.mNameLocation = this.mOriginalNameLocation;
        }

        protected String getName() {
            return this.mName;
        }

        protected DevicePath getPath() {
            return this.mPath;
        }

        protected char getFlipped() {
            return this.mFlipped;
        }

        protected int getTop() {
            return (int)this.getUL().getY();
        }

        protected int getBottom() {
            return (int)this.getLR().getY();
        }

        protected APoint2D getNameLocation() {
            return this.mNameLocation;
        }

        protected void incrementNameLocation() {
            this.mNameLocation.setY(this.mNameLocation.getY() + 1L);
        }

        protected Point getCenter() {
            return new Point((int)(this.getUL().getX() + this.getSize().getWidth() / 2.0), (int)(this.getUL().getY() + this.getSize().getHeight() / 2.0));
        }

        public Color getColor() {
            return this.mColor;
        }

        public void setAlpha(int alpha) {
            this.mColor = new Color(this.mColor.getRed(), this.mColor.getGreen(), this.mColor.getBlue(), alpha);
        }

        @Override
        public void translate(int deltaX, int deltaY) {
            super.translate(deltaX, deltaY);
            this.mNameLocation.moveBy(new APoint2D((long)deltaX, (long)deltaY));
        }

        @Override
        public void setLocation(int x, int y) {
            super.setLocation(x, y);
            this.setUpName();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CanvasPolygon)) {
                return false;
            }
            CanvasPolygon c = (CanvasPolygon)o;
            return this.mPath.equals((Object)c.mPath);
        }

        @Override
        public int hashCode() {
            return this.mPath.hashCode();
        }
    }

    private class ResizeHandle
    extends ARect {
        private Color mColor;
        private boolean mIsUpper;

        public ResizeHandle(Point p0, Point p1, boolean upper) {
            this.setBounds((long)p0.getX(), (long)p0.getY(), (long)p1.getX(), (long)p1.getY());
            this.setIsUpper(upper);
            this.release();
        }

        public void release() {
            this.mColor = Color.YELLOW;
        }

        public void drag(CanvasPolygon shape, APoint2D postDrag) {
            this.mColor = Color.RED;
            this.moveCenterTo(this.centerX(), postDrag.getY());
            long zLoc = this.isUpper() ? (long)shape.getBottom() : (long)shape.getTop();
            long newH = Math.abs(postDrag.getY() - zLoc);
            shape.setSize((int)shape.getWidth(), (int)newH);
            if (this.isUpper()) {
                shape.setLocation((int)shape.getX(), (int)postDrag.getY());
            }
        }

        public boolean isUpper() {
            return this.mIsUpper;
        }

        public void setIsUpper(boolean isUpper) {
            this.mIsUpper = isUpper;
        }

        public Color getColor() {
            return this.mColor;
        }

        public boolean equals(Object obj) {
            return super.equals(obj) && this.mColor.equals(this.mColor);
        }

        public int hashCode() {
            return super.hashCode() ^ this.mColor.hashCode();
        }
    }

    protected class GraphicsCanvas
    extends JPanel
    implements ChangeListener {
        private View2D mParent;
        private List<CanvasPolygon> mPolygons;
        private LinkedList<ShapeInfo> mShapes;
        private String mSelectedName;
        private CanvasPolygon mSelectedShape;
        private ResizeHandle mShapeResizeHandle = null;
        private boolean mDragged;
        private boolean mDragging;
        private Point mPreDrag;
        private int mLineHeight;
        private long mZLocation;
        private long mShapeHeight;
        private String mSnapName;
        private double mScreenPercentage;
        private double[] horizontalFunction;
        private double[] verticalFunction;

        public GraphicsCanvas(View2D parent) {
            this.mParent = parent;
            this.mLineHeight = -3;
            this.mZLocation = 0L;
            this.mShapeHeight = 0L;
            this.mScreenPercentage = 0.5;
            this.mSnapName = "";
            this.setBackground(Color.WHITE);
            this.mSelectedName = SubstrateStackUI.this.mViewPort.getSelectedName();
            this.mDragged = false;
            this.mDragging = false;
            this.setFocusable(true);
            SubstrateStackUI.this.mZoomSlider.addChangeListener(this);
            this.addMouseListener(new EditShapeAdapter());
            this.addMouseMotionListener(new EditShapeMotionAdapter());
            this.addMouseWheelListener(new MouseAdapter(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    double scrollDistance = e.getPreciseWheelRotation();
                    if (scrollDistance < 0.0 && GraphicsCanvas.this.mScreenPercentage >= 0.9) {
                        return;
                    }
                    if (scrollDistance > 0.0 && GraphicsCanvas.this.mScreenPercentage <= 0.1) {
                        return;
                    }
                    GraphicsCanvas.this.mScreenPercentage -= scrollDistance / 100.0;
                    SubstrateStackUI.this.mZoomSlider.setValue(SubstrateStackUI.this.mZoomSlider.getValue() - (int)scrollDistance);
                    GraphicsCanvas.this.repaint();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (GraphicsCanvas.this.mSelectedShape == null) {
                        return;
                    }
                    if (e.getKeyCode() == 40) {
                        GraphicsCanvas.this.offsetDevice(GraphicsCanvas.this.mSelectedShape, false);
                    } else if (e.getKeyCode() == 38) {
                        GraphicsCanvas.this.offsetDevice(GraphicsCanvas.this.mSelectedShape, true);
                    }
                    SubstrateStackUI.this.mViewPort.refresh();
                    SubstrateStackUI.this.mViewPort.reColor(GraphicsCanvas.this.mSelectedName);
                }
            });
            UIUtil.installPopupMenu((Component)this, (UIUtil.APopupMenuAdapter)new PopupMenuAdapter());
        }

        private void updateZLoc(DevicePath devicePath, long zLoc) {
            String parentSubstrateName;
            String parentName;
            DevicePath parentPath = devicePath.getParent();
            if (parentPath.isDesign()) {
                parentName = "<Design>";
                parentSubstrateName = "null";
            } else {
                parentName = parentPath.getLast().getTemplate().getName();
                parentSubstrateName = String.format("\"%s\"", parentPath.getLast().getTemplate().getSubstrate().getName());
            }
            if (((Boolean)Cp.exec((String)"com.sigrity.orbit.ui.SubstrateStackUI.setSubstrateZ(curDb(), %s, \"%s\", \"%s\", %dL)", (Object[])new Object[]{parentSubstrateName, parentName, devicePath.getLast().getName(), zLoc})).booleanValue() && SubstrateStackUI.this.mView3d != null) {
                SubstrateStackUI.this.mView3d.notifyChanged(devicePath);
            }
        }

        private void offsetDevice(CanvasPolygon c, boolean up) {
            DevicePath device = SubstrateStackUI.this.mViewPort.getDevice(c.getName());
            if (!this.mParent.mSelectedView.equals("Top") && !this.mParent.mSelectedView.equals("Bottom")) {
                long updatedZ = up ? Substrate.getZLoc((DevicePath)device) + 500L : Substrate.getZLoc((DevicePath)device) - 500L;
                this.updateZLoc(device, updatedZ);
            }
        }

        private void setSelected(String name) {
            for (CanvasPolygon c : this.mPolygons) {
                if (!c.getName().equals(name)) continue;
                this.mSelectedName = name;
                this.mSelectedShape = c;
                return;
            }
            this.mSelectedName = "";
            this.mSelectedShape = null;
        }

        @Override
        public void paintComponent(Graphics g) {
            Polygon p;
            Polygon trap;
            Polygon p2;
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(2.0f));
            if (!this.mDragging) {
                if (!this.mSelectedName.equals("")) {
                    g2.drawString(this.mSelectedName + " selected.", 5, (int)this.getSize().getHeight() - 5);
                }
                this.mShapes = SubstrateStackUI.this.mViewPort.getShapeInfoList();
                this.getShapes();
            }
            this.setSelected(this.mSelectedName);
            this.fixText(this.mPolygons, g2);
            for (CanvasPolygon s : this.mPolygons) {
                Color arrowColor;
                if (this.mSelectedShape == s) {
                    s.setAlpha(150);
                    arrowColor = Color.WHITE;
                } else {
                    s.setAlpha(50);
                    arrowColor = Color.BLACK;
                }
                g2.setColor(Color.BLACK);
                if (s.getGeom() != null) {
                    g2.draw(s.getGeom());
                    g2.setPaint(s.getColor());
                    g2.fill(s.getGeom());
                } else {
                    g2.draw(s);
                    g2.setPaint(s.getColor());
                    g2.fill(s);
                }
                g2.setColor(Color.BLACK);
                g2.drawString(s.getName(), (float)s.getNameLocation().getX(), (float)s.getNameLocation().getY());
                g2.setColor(arrowColor);
                if (s.getFlipped() == '\u0001') {
                    this.drawUpArrow(s.getCenter(), g2);
                    continue;
                }
                if (s.getFlipped() != '\u00ff') continue;
                this.drawDownArrow(s.getCenter(), g2);
            }
            if (this.mShapeResizeHandle != null) {
                g2.setColor(this.mShapeResizeHandle.getColor());
                g2.fillRect((int)this.mShapeResizeHandle.getLL().getX(), (int)this.mShapeResizeHandle.getLL().getY(), (int)this.mShapeResizeHandle.width(), (int)this.mShapeResizeHandle.height());
            }
            if (this.mLineHeight > 0) {
                g2.setPaint(Color.BLUE);
                g2.setStroke(new BasicStroke(3.0f));
                g2.drawLine(0, this.mLineHeight, (int)this.getSize().getWidth(), this.mLineHeight);
            }
            if (this.mZLocation > 0L) {
                g2.setPaint(Color.BLACK);
                String s = "Set the z location of " + this.mSelectedName + " to: " + this.mZLocation;
                if (!this.mSnapName.equals("")) {
                    s = s + ", snapping to " + this.mSnapName;
                }
                g2.drawString(s, 5, (int)this.getSize().getHeight() - 5);
            }
            g2.setColor(Color.BLACK);
            if (this.mParent.mSelectedView.equals("West")) {
                p2 = new Polygon();
                p2.addPoint((int)this.getSize().getWidth() - 47, 38);
                p2.addPoint((int)this.getSize().getWidth() - 50, 35);
                p2.addPoint((int)this.getSize().getWidth() - 50, 41);
                g2.drawRect((int)this.getSize().getWidth() - 56, 20, 36, 36);
                g2.drawLine((int)this.getSize().getWidth() - 65, 38, (int)this.getSize().getWidth() - 47, 38);
                g2.draw(p2);
                g2.fill(p2);
            } else if (this.mParent.mSelectedView.equals("East")) {
                p2 = new Polygon();
                p2.addPoint((int)this.getSize().getWidth() - 29, 38);
                p2.addPoint((int)this.getSize().getWidth() - 26, 35);
                p2.addPoint((int)this.getSize().getWidth() - 26, 41);
                g2.drawRect((int)this.getSize().getWidth() - 56, 20, 36, 36);
                g2.drawLine((int)this.getSize().getWidth() - 11, 38, (int)this.getSize().getWidth() - 29, 38);
                g2.draw(p2);
                g2.fill(p2);
            } else if (this.mParent.mSelectedView.equals("North")) {
                p2 = new Polygon();
                p2.addPoint((int)this.getSize().getWidth() - 38, 29);
                p2.addPoint((int)this.getSize().getWidth() - 35, 26);
                p2.addPoint((int)this.getSize().getWidth() - 41, 26);
                g2.drawRect((int)this.getSize().getWidth() - 56, 20, 36, 36);
                g2.drawLine((int)this.getSize().getWidth() - 38, 11, (int)this.getSize().getWidth() - 38, 29);
                g2.draw(p2);
                g2.fill(p2);
            } else if (this.mParent.mSelectedView.equals("South")) {
                p2 = new Polygon();
                p2.addPoint((int)this.getSize().getWidth() - 38, 47);
                p2.addPoint((int)this.getSize().getWidth() - 35, 50);
                p2.addPoint((int)this.getSize().getWidth() - 41, 50);
                g2.drawRect((int)this.getSize().getWidth() - 56, 20, 36, 36);
                g2.drawLine((int)this.getSize().getWidth() - 38, 65, (int)this.getSize().getWidth() - 38, 47);
                g2.draw(p2);
                g2.fill(p2);
            } else if (this.mParent.mSelectedView.equals("Top")) {
                trap = new Polygon();
                trap.addPoint((int)this.getSize().getWidth() - 15, 15);
                trap.addPoint((int)this.getSize().getWidth() - 41, 27);
                trap.addPoint((int)this.getSize().getWidth() - 77, 27);
                trap.addPoint((int)this.getSize().getWidth() - 51, 15);
                p = new Polygon();
                p.addPoint((int)this.getSize().getWidth() - 46, 21);
                p.addPoint((int)this.getSize().getWidth() - 43, 18);
                p.addPoint((int)this.getSize().getWidth() - 49, 18);
                g2.draw(trap);
                g2.draw(p);
                g2.drawLine((int)this.getSize().getWidth() - 46, 3, (int)this.getSize().getWidth() - 46, 21);
            } else if (this.mParent.mSelectedView.equals("Bottom")) {
                trap = new Polygon();
                trap.addPoint((int)this.getSize().getWidth() - 15, 5);
                trap.addPoint((int)this.getSize().getWidth() - 41, 17);
                trap.addPoint((int)this.getSize().getWidth() - 77, 17);
                trap.addPoint((int)this.getSize().getWidth() - 51, 5);
                p = new Polygon();
                p.addPoint((int)this.getSize().getWidth() - 46, 11);
                p.addPoint((int)this.getSize().getWidth() - 43, 14);
                p.addPoint((int)this.getSize().getWidth() - 49, 14);
                g2.draw(p);
                g2.drawLine((int)this.getSize().getWidth() - 46, 11, (int)this.getSize().getWidth() - 46, 29);
                g2.setColor(new Color(255, 255, 255, 150));
                g2.fill(trap);
                g2.setColor(Color.BLACK);
                g2.draw(trap);
            }
        }

        private void drawUpArrow(Point center, Graphics2D g) {
            int centerX = (int)center.getX();
            int centerY = (int)center.getY();
            Point stem1 = new Point(centerX, centerY + 15);
            Point stem2 = new Point(centerX, centerY - 10);
            Point tri1 = new Point(centerX + 2, (int)stem2.getY());
            Point tri2 = new Point(centerX, (int)stem2.getY() - 5);
            Point tri3 = new Point(centerX - 2, (int)stem2.getY());
            Polygon p = new Polygon();
            p.addPoint((int)tri1.getX(), (int)tri1.getY());
            p.addPoint((int)tri2.getX(), (int)tri2.getY());
            p.addPoint((int)tri3.getX(), (int)tri3.getY());
            g.draw(p);
            g.fill(p);
            g.drawLine((int)stem1.getX(), (int)stem1.getY(), (int)stem2.getX(), (int)stem2.getY());
        }

        private void drawDownArrow(Point center, Graphics2D g) {
            int centerX = (int)center.getX();
            int centerY = (int)center.getY();
            Point stem1 = new Point(centerX, centerY - 15);
            Point stem2 = new Point(centerX, centerY + 10);
            Point tri1 = new Point(centerX + 2, (int)stem2.getY());
            Point tri2 = new Point(centerX, (int)stem2.getY() + 5);
            Point tri3 = new Point(centerX - 2, (int)stem2.getY());
            Polygon p = new Polygon();
            p.addPoint((int)tri1.getX(), (int)tri1.getY());
            p.addPoint((int)tri2.getX(), (int)tri2.getY());
            p.addPoint((int)tri3.getX(), (int)tri3.getY());
            g.draw(p);
            g.fill(p);
            g.drawLine((int)stem1.getX(), (int)stem1.getY(), (int)stem2.getX(), (int)stem2.getY());
        }

        public void setSelectedName(String name) {
            this.mSelectedName = name;
        }

        public String getSelectedName() {
            return this.mSelectedName;
        }

        private void getShapes() {
            if ("South".contentEquals(this.mParent.mSelectedView)) {
                this.mPolygons = this.getShapes(0, 2, this.mShapes, false);
            } else if ("West".contentEquals(this.mParent.mSelectedView)) {
                this.mPolygons = this.getShapes(1, 2, this.mShapes, true);
            } else if ("East".contentEquals(this.mParent.mSelectedView)) {
                this.mPolygons = this.getShapes(1, 2, this.mShapes, false);
            } else if ("North".contentEquals(this.mParent.mSelectedView)) {
                this.mPolygons = this.getShapes(0, 2, this.mShapes, true);
            } else if ("Top".contentEquals(this.mParent.mSelectedView)) {
                this.mPolygons = this.getShapes(0, 1, this.mShapes, false);
            } else if ("Bottom".contentEquals(this.mParent.mSelectedView)) {
                this.mPolygons = this.getShapes(0, 1, this.mShapes, true);
            }
        }

        private List<CanvasPolygon> getShapes(int horizontal, int vertical, LinkedList<ShapeInfo> l, boolean mirrored) {
            if (l.isEmpty()) {
                return Collections.emptyList();
            }
            long horizontalMax = l.getFirst().getHorizontalMax(horizontal);
            long horizontalMin = l.getFirst().getHorizontalMin(horizontal);
            long verticalMax = l.getFirst().getVerticalMax(vertical);
            long verticalMin = l.getFirst().getVerticalMin(vertical);
            for (ShapeInfo s : l) {
                horizontalMax = Math.max(horizontalMax, s.getHorizontalMax(horizontal));
                horizontalMin = Math.min(horizontalMin, s.getHorizontalMin(horizontal));
                verticalMax = Math.max(verticalMax, s.getVerticalMax(vertical));
                verticalMin = Math.min(verticalMin, s.getVerticalMin(vertical));
            }
            this.horizontalFunction = this.findScaleFunction(horizontalMax, horizontalMin, this.getSize().getWidth(), false);
            this.verticalFunction = vertical != 1 ? this.findScaleFunction(verticalMax, verticalMin, this.getSize().getHeight(), true) : this.findScaleFunction(verticalMax, verticalMin, this.getSize().getHeight(), false);
            LinkedList<CanvasPolygon> shapes = new LinkedList<CanvasPolygon>();
            for (int curId = 0; curId < l.size(); ++curId) {
                ShapeInfo curShape = l.get(curId);
                shapes.add(this.getPolygon(horizontal, vertical, mirrored, curShape));
            }
            return shapes;
        }

        private double[] findScaleFunction(long max, long min, double windowMax, boolean yIsVertical) {
            double b;
            double slope;
            if (yIsVertical) {
                slope = this.mScreenPercentage * windowMax / (double)(max - min);
                double y = windowMax * (1.0 - this.mScreenPercentage) / 2.0;
                b = y - slope * (double)min;
            } else {
                slope = 0.8 * windowMax / (double)(max - min);
                b = 0.9 * windowMax - slope * (double)max;
            }
            return new double[]{slope, b};
        }

        private void applyScale(APoint2D p) {
            p.setX((long)((int)(this.horizontalFunction[0] * (double)p.getX() + this.horizontalFunction[1])));
            p.setY((long)((int)(this.verticalFunction[0] * (double)p.getY() + this.verticalFunction[1])));
            p.setY((long)((int)this.getSize().getHeight()) - p.getY());
        }

        private Shape applyScale(AGeom g) {
            if (g.getClass().equals(ACircle.class)) {
                ACircle c = (ACircle)g;
                APoint2D anchor = c.getBounds().getUL();
                APoint2D UR = c.getBounds().getUR();
                this.applyScale(anchor);
                this.applyScale(UR);
                int width = Math.abs((int)(anchor.getX() - UR.getX()));
                return new Ellipse2D.Float(anchor.getX(), anchor.getY(), width, width);
            }
            if (g.getClass().isAssignableFrom(APolygon.class)) {
                // empty if block
            }
            return null;
        }

        private void inverseScale(APoint2D p) {
            p.setX((long)(((double)p.getX() - this.horizontalFunction[1]) / this.horizontalFunction[0]));
            p.setY((long)this.getSize().getHeight() - p.getY());
            p.setY((long)(((double)p.getY() - this.verticalFunction[1]) / this.verticalFunction[0]));
        }

        public CanvasPolygon getPolygon(int horizontal, int vertical, boolean mirrored, ShapeInfo curShape) {
            APoint2D lowerRight;
            APoint2D upperLeft;
            Shape geom = null;
            long[] point = curShape.getPoints();
            long[] size = curShape.getSize();
            if (horizontal == 0) {
                upperLeft = new APoint2D(point[horizontal], point[vertical]);
                lowerRight = new APoint2D(point[horizontal] + size[horizontal], point[vertical] - size[vertical]);
                if (vertical == 1) {
                    geom = this.applyScale(curShape.getGeom());
                }
            } else {
                upperLeft = new APoint2D(point[horizontal] - size[horizontal], point[vertical]);
                lowerRight = new APoint2D(point[horizontal], point[vertical] - size[vertical]);
            }
            if (mirrored) {
                this.flipHorizontal(upperLeft);
                this.flipHorizontal(lowerRight);
            }
            this.applyScale(upperLeft);
            this.applyScale(lowerRight);
            char flip = '\u0000';
            flip = curShape.getFlipped() ? (char)'\u00ff' : '\u0001';
            return new CanvasPolygon(upperLeft, lowerRight, curShape.getPath(), mirrored, flip, curShape.getColor(), geom);
        }

        private void flipHorizontal(APoint2D p) {
            p.setX((long)this.getSize().getWidth() - p.getX());
        }

        private void fixText(List<CanvasPolygon> l, Graphics2D g) {
            boolean done = false;
            while (!done) {
                done = true;
                for (int i = 0; i < l.size(); ++i) {
                    CanvasPolygon c2;
                    int j;
                    boolean clipsNothing = true;
                    CanvasPolygon c1 = l.get(i);
                    for (j = i; j > 0; --j) {
                        c2 = l.get(j);
                        if (!this.withinBounds(c1, c2, g)) continue;
                        clipsNothing = false;
                    }
                    if (clipsNothing) {
                        c1.resetNameLocation();
                    }
                    for (j = i + 1; j < l.size(); ++j) {
                        c2 = l.get(j);
                        while (this.withinBounds(c1, c2, g)) {
                            c1.incrementNameLocation();
                            done = false;
                        }
                    }
                }
            }
        }

        private boolean withinBounds(CanvasPolygon c1, CanvasPolygon c2, Graphics2D g) {
            Font f = g.getFont();
            Rectangle2D r1 = f.getStringBounds(c1.getName(), g.getFontRenderContext());
            Rectangle2D r2 = f.getStringBounds(c2.getName(), g.getFontRenderContext());
            r1.setRect(c1.getNameLocation().getX(), c1.getNameLocation().getY(), r1.getWidth(), r1.getHeight());
            r2.setRect(c2.getNameLocation().getX(), c2.getNameLocation().getY(), r2.getWidth(), r2.getHeight());
            return r1.intersects(r2);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.mScreenPercentage = (double)SubstrateStackUI.this.mZoomSlider.getValue() / 100.0;
            this.repaint();
        }

        public EditShapeAction getEditAction() {
            EditShapeAction action = this.mShapeResizeHandle != null ? new ResizeShapeAction() : new MoveShapeAction();
            return action;
        }

        protected class ResizeShapeAction
        extends EditShapeAction {
            protected ResizeShapeAction() {
            }

            @Override
            public void move(MouseEvent e) {
                if (!this.repaintHandleIfTouched(e, GraphicsCanvas.this.mSelectedShape.getUL(), GraphicsCanvas.this.mSelectedShape.getUR(), true)) {
                    this.repaintHandleIfTouched(e, GraphicsCanvas.this.mSelectedShape.getLL(), GraphicsCanvas.this.mSelectedShape.getLR(), false);
                }
            }

            @Override
            public void drag(MouseEvent e) {
                APoint2D preDrag = new APoint2D(0.0, GraphicsCanvas.this.mPreDrag.getY());
                APoint2D postDrag = new APoint2D(0L, (long)this.getNewY(e));
                GraphicsCanvas.this.mShapeResizeHandle.drag(GraphicsCanvas.this.mSelectedShape, postDrag);
                GraphicsCanvas.this.inverseScale(preDrag);
                GraphicsCanvas.this.inverseScale(postDrag);
                long halfH = Substrate.getHeight((Device)GraphicsCanvas.this.mSelectedShape.getPath().getDevice()) / 2L;
                GraphicsCanvas.this.mShapeHeight = GraphicsCanvas.this.mShapeResizeHandle.isUpper() ? postDrag.yDistance(preDrag) + halfH : preDrag.yDistance(postDrag) + halfH;
            }

            @Override
            public void release(MouseEvent e) {
                this.resizeDevice();
                SubstrateStackUI.this.mLstSubstrates.refreshData();
                GraphicsCanvas.this.mShapeResizeHandle = null;
                GraphicsCanvas.this.mShapeHeight = -1L;
                GraphicsCanvas.this.mSnapName = "";
                GraphicsCanvas.this.mLineHeight = -3;
            }

            protected void resizeDevice() {
                DevicePath dPath = SubstrateStackUI.this.mViewPort.getDevice(GraphicsCanvas.this.mSelectedName);
                SubstrateStackUI.setSubstrateHeight(dPath, GraphicsCanvas.this.mShapeHeight);
                if (!GraphicsCanvas.this.mShapeResizeHandle.isUpper()) {
                    APoint2D postDrag = new APoint2D(0L, GraphicsCanvas.this.mShapeResizeHandle.centerY());
                    GraphicsCanvas.this.inverseScale(postDrag);
                    SubstrateStackUI.setSubstrateZ(dPath, postDrag.getY());
                }
            }

            protected int getNewY(MouseEvent e) {
                int newY;
                Point curr = this.getYAndCheckBound(e);
                SnapInfo snapInfo = this.getSnap((int)curr.getY());
                CanvasPolygon snapShape = snapInfo.getPolygon();
                if (!snapInfo.hasSnap()) {
                    GraphicsCanvas.this.mLineHeight = -3;
                    GraphicsCanvas.this.mSnapName = "";
                    newY = (int)curr.getY();
                } else if (snapInfo.isSnapToTop()) {
                    newY = snapShape.getTop();
                    GraphicsCanvas.this.mLineHeight = snapShape.getTop();
                    GraphicsCanvas.this.mSnapName = snapShape.getName();
                } else {
                    GraphicsCanvas.this.mLineHeight = newY = snapShape.getBottom();
                    GraphicsCanvas.this.mSnapName = snapShape.getName();
                }
                return newY;
            }

            private Point getYAndCheckBound(MouseEvent e) {
                Point curr = e.getPoint();
                boolean isUpper = GraphicsCanvas.this.mShapeResizeHandle.isUpper();
                if (isUpper && curr.getY() >= (double)GraphicsCanvas.this.mSelectedShape.getBottom()) {
                    curr.setLocation(curr.getX(), (double)GraphicsCanvas.this.mSelectedShape.getBottom());
                } else if (!isUpper && curr.getY() <= (double)GraphicsCanvas.this.mSelectedShape.getTop()) {
                    curr.setLocation(curr.getX(), (double)GraphicsCanvas.this.mSelectedShape.getTop());
                }
                return curr;
            }

            public SnapInfo getSnap(int mouseZ) {
                int zLoc = mouseZ;
                List<CanvasPolygon> children = this.getChildren(GraphicsCanvas.this.mSelectedShape);
                CanvasPolygon tSnap = this.getBestSnap(zLoc, children, true);
                CanvasPolygon bSnap = this.getBestSnap(zLoc, children, false);
                SnapInfo snapInfo = tSnap != null ? new SnapInfo(tSnap, true, GraphicsCanvas.this.mShapeResizeHandle.isUpper()) : (bSnap != null ? new SnapInfo(bSnap, false, GraphicsCanvas.this.mShapeResizeHandle.isUpper()) : new SnapInfo(null, false, false));
                return snapInfo;
            }
        }

        protected class MoveShapeAction
        extends EditShapeAction {
            protected MoveShapeAction() {
            }

            @Override
            public void move(MouseEvent e) {
                if (!this.repaintHandleIfTouched(e, GraphicsCanvas.this.mSelectedShape.getUL(), GraphicsCanvas.this.mSelectedShape.getUR(), true)) {
                    this.repaintHandleIfTouched(e, GraphicsCanvas.this.mSelectedShape.getLL(), GraphicsCanvas.this.mSelectedShape.getLR(), false);
                }
            }

            @Override
            public void drag(MouseEvent e) {
                GraphicsCanvas.this.mSelectedShape.setLocation((int)GraphicsCanvas.this.mSelectedShape.getUL().getX(), this.getNewY(e));
                int yDiff = (int)(GraphicsCanvas.this.mSelectedShape.getCenterY() - GraphicsCanvas.this.mPreDrag.getY());
                GraphicsCanvas.this.mPreDrag = GraphicsCanvas.this.mSelectedShape.getCenter();
                for (CanvasPolygon child : this.getChildren(GraphicsCanvas.this.mSelectedShape)) {
                    child.translate(0, yDiff);
                }
                APoint2D p = new APoint2D(0L, (long)GraphicsCanvas.this.mSelectedShape.getBottom());
                GraphicsCanvas.this.inverseScale(p);
                GraphicsCanvas.this.mZLocation = p.getY();
            }

            @Override
            public void release(MouseEvent e) {
                SnapInfo snapInfo = this.getSnap(e.getY());
                this.moveDevice(snapInfo, e.getY());
                SubstrateStackUI.this.mLstSubstrates.refreshData();
                GraphicsCanvas.this.mZLocation = -1L;
                GraphicsCanvas.this.mLineHeight = -3;
                GraphicsCanvas.this.mSnapName = "";
            }

            protected int getNewY(MouseEvent e) {
                int newY;
                Point curr = e.getPoint();
                SnapInfo snapInfo = this.getSnap(e.getY());
                CanvasPolygon snapShape = snapInfo.getPolygon();
                if (!snapInfo.hasSnap()) {
                    GraphicsCanvas.this.mLineHeight = -3;
                    GraphicsCanvas.this.mSnapName = "";
                    newY = (int)(curr.getY() + GraphicsCanvas.this.mSelectedShape.getHeight() / 2.0);
                } else if (snapInfo.isSnapToTop()) {
                    newY = snapShape.getTop();
                    GraphicsCanvas.this.mLineHeight = snapShape.getTop();
                    GraphicsCanvas.this.mSnapName = snapShape.getName();
                } else {
                    GraphicsCanvas.this.mLineHeight = newY = snapShape.getBottom();
                    GraphicsCanvas.this.mSnapName = snapShape.getName();
                }
                return snapInfo.isSnapFromTop() ? newY : newY - (int)GraphicsCanvas.this.mSelectedShape.getHeight();
            }

            public SnapInfo getSnap(int mouseZ) {
                int zBottom = (int)((double)mouseZ + GraphicsCanvas.this.mSelectedShape.getHeight() / 2.0);
                int zTop = (int)((double)mouseZ - GraphicsCanvas.this.mSelectedShape.getHeight() / 2.0);
                List<CanvasPolygon> children = this.getChildren(GraphicsCanvas.this.mSelectedShape);
                CanvasPolygon btSnap = this.getBestSnap(zBottom, children, true);
                CanvasPolygon ttSnap = this.getBestSnap(zTop, children, true);
                CanvasPolygon bbSnap = this.getBestSnap(zBottom, children, false);
                CanvasPolygon tbSnap = this.getBestSnap(zTop, children, false);
                SnapInfo snapInfo = btSnap != null ? new SnapInfo(btSnap, true, false) : (ttSnap != null ? new SnapInfo(ttSnap, true, true) : (bbSnap != null ? new SnapInfo(bbSnap, false, false) : (tbSnap != null ? new SnapInfo(tbSnap, false, true) : new SnapInfo(null, false, false))));
                return snapInfo;
            }

            private void moveDevice(SnapInfo snapInfo, int mouseZ) {
                DevicePath device = SubstrateStackUI.this.mViewPort.getDevice(GraphicsCanvas.this.mSelectedName);
                if (snapInfo.hasSnap()) {
                    DevicePath snapDevice = snapInfo.getPolygon().getPath();
                    long zLoc = Substrate.getZLoc((DevicePath)snapDevice);
                    if (snapInfo.isSnapToTop()) {
                        zLoc += Substrate.getHeight((Device)snapDevice.getLast());
                    }
                    if (snapInfo.isSnapFromTop()) {
                        zLoc -= Substrate.getHeight((Device)device.getLast());
                    }
                    GraphicsCanvas.this.updateZLoc(device, zLoc - Substrate.getZLoc((DevicePath)device.getParent()));
                } else {
                    APoint2D correctedPoint = new APoint2D(0L, (long)mouseZ);
                    GraphicsCanvas.this.inverseScale(correctedPoint);
                    long newZLoc = correctedPoint.getY() - (long)((double)Substrate.getHeight((Device)device.getLast()) * 0.5 + (double)Substrate.getZLoc((DevicePath)device.getParent()));
                    GraphicsCanvas.this.updateZLoc(device, newZLoc);
                }
            }
        }

        abstract class EditShapeAction {
            static final long HANDLE_SENSITIVITY = 10L;
            static final long HANDLE_SIZE = 2L;

            EditShapeAction() {
            }

            public abstract void move(MouseEvent var1);

            public abstract void drag(MouseEvent var1);

            public abstract void release(MouseEvent var1);

            protected boolean repaintHandleIfTouched(MouseEvent e, Point p0, Point p1, boolean upper) {
                ResizeHandle lastHandle = GraphicsCanvas.this.mShapeResizeHandle;
                ResizeHandle handle = new ResizeHandle(p0, p1, upper);
                long handleSensi = (long)(10.0 * GraphicsCanvas.this.mScreenPercentage);
                handle.grow(handleSensi);
                boolean isTouched = handle.leftPart(2).contains((long)e.getPoint().getX(), (long)e.getPoint().getY());
                if (isTouched) {
                    handle.grow(2L - handleSensi);
                    GraphicsCanvas.this.mShapeResizeHandle = handle;
                } else {
                    GraphicsCanvas.this.mShapeResizeHandle = null;
                }
                boolean isChanged = false;
                if (lastHandle != GraphicsCanvas.this.mShapeResizeHandle) {
                    GraphicsCanvas.this.repaint();
                    isChanged = true;
                }
                return isChanged;
            }

            protected CanvasPolygon getBestSnap(int zLoc, List<CanvasPolygon> ignore, boolean topSnap) {
                ToIntFunction<CanvasPolygon> calSnapDist = p -> topSnap ? Math.abs(zLoc - p.getTop()) : Math.abs(zLoc - p.getBottom());
                return GraphicsCanvas.this.mPolygons.stream().filter(p -> !p.equals(GraphicsCanvas.this.mSelectedShape) && !ignore.contains(p) && calSnapDist.applyAsInt((CanvasPolygon)p) < 15).min((a, b) -> calSnapDist.applyAsInt((CanvasPolygon)a) - calSnapDist.applyAsInt((CanvasPolygon)b)).orElse(null);
            }

            protected List<CanvasPolygon> getChildren(CanvasPolygon c) {
                DevicePath d = SubstrateStackUI.this.mViewPort.getDevice(c.getName());
                ArrayList<DevicePath> children = this.getAllChildren(d);
                return GraphicsCanvas.this.mPolygons.stream().filter(p -> children.stream().anyMatch(child -> child.equals((Object)p.getPath()))).collect(Collectors.toList());
            }

            private ArrayList<DevicePath> getAllChildren(DevicePath d) {
                ArrayList<DevicePath> children = new ArrayList<DevicePath>();
                this.getAllChildren(d, children);
                return children;
            }

            private void getAllChildren(DevicePath d, ArrayList<DevicePath> list) {
                IterableIterator children = d.getChildren();
                for (DevicePath device : children) {
                    list.add(device);
                    IterableIterator grandChildren = device.getChildren();
                    if (!grandChildren.hasNext()) continue;
                    this.getAllChildren(device, list);
                }
            }
        }

        class SnapInfo {
            CanvasPolygon mSnapPolygon;
            boolean mSnapToTop;
            boolean mSnapFromTop;

            public SnapInfo(CanvasPolygon polygon, boolean snapToTop, boolean snapFromTop) {
                this.mSnapPolygon = polygon;
                this.mSnapToTop = snapToTop;
                this.mSnapFromTop = snapFromTop;
            }

            public CanvasPolygon getPolygon() {
                return this.mSnapPolygon;
            }

            public boolean isSnapToTop() {
                return this.mSnapToTop;
            }

            public boolean isSnapFromTop() {
                return this.mSnapFromTop;
            }

            public boolean hasSnap() {
                return this.mSnapPolygon != null;
            }
        }

        class EditShapeMotionAdapter
        extends MouseMotionAdapter {
            EditShapeMotionAdapter() {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!this.prerequisite(e)) {
                    return;
                }
                GraphicsCanvas.this.getEditAction().move(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!this.prerequisite(e)) {
                    return;
                }
                GraphicsCanvas.this.mDragging = true;
                if (!GraphicsCanvas.this.mDragged) {
                    GraphicsCanvas.this.mPreDrag = GraphicsCanvas.this.mSelectedShape.getCenter();
                    GraphicsCanvas.this.mDragged = true;
                }
                GraphicsCanvas.this.getEditAction().drag(e);
                GraphicsCanvas.this.repaint();
            }

            private boolean prerequisite(MouseEvent e) {
                return !GraphicsCanvas.this.mSelectedName.equals("") && !GraphicsCanvas.this.mParent.mSelectedView.equals("Top") && !GraphicsCanvas.this.mParent.mSelectedView.equals("Bottom");
            }
        }

        class EditShapeAdapter
        extends MouseAdapter {
            CanvasPolygon mLastPoly = null;

            EditShapeAdapter() {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1 || !GraphicsCanvas.this.mDragged) {
                    return;
                }
                GraphicsCanvas.this.mDragged = false;
                GraphicsCanvas.this.mDragging = false;
                EditShapeAction action = GraphicsCanvas.this.getEditAction();
                action.release(e);
                SubstrateStackUI.this.mViewPort.refresh();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GraphicsCanvas.this.mShapeResizeHandle != null) {
                    return;
                }
                this.selectShape(e.getPoint());
                if (e.getClickCount() == 2) {
                    SubstrateStackUI.this.mBtnEditSubstrate.doClick();
                    SubstrateStackUI.this.mBtnEditSubstrate.setSelected(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ((GraphicsCanvas)e.getSource()).requestFocus(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((GraphicsCanvas)e.getSource()).requestFocus(false);
            }

            private void selectShape(Point p) {
                Comparator<CanvasPolygon> closestPolygon = new Comparator<CanvasPolygon>(){

                    @Override
                    public int compare(CanvasPolygon c1, CanvasPolygon c2) {
                        double area1 = this.getArea(c1);
                        double area2 = this.getArea(c2);
                        int ret = 0;
                        if (c1.equals(EditShapeAdapter.this.mLastPoly) || area1 > area2) {
                            ret = 1;
                        } else if (c2.equals(EditShapeAdapter.this.mLastPoly) || area1 < area2) {
                            ret = -1;
                        }
                        return ret;
                    }

                    private double getArea(CanvasPolygon c) {
                        Rectangle2D r = c.getBounds2D();
                        return r.getHeight() * r.getWidth();
                    }
                };
                Optional<CanvasPolygon> r = GraphicsCanvas.this.mPolygons.stream().filter(c -> c.contains(p)).min(closestPolygon);
                if (r.isPresent()) {
                    this.mLastPoly = r.get();
                    SubstrateStackUI.this.mViewPort.reColor(r.get().getName());
                    SubstrateStackUI.this.mLstSubstrates.setSelectedValue(r.get().getPath(), true);
                } else {
                    this.mLastPoly = null;
                    SubstrateStackUI.this.mViewPort.reColor("");
                    SubstrateStackUI.this.mLstSubstrates.clearSelection();
                }
            }
        }
    }

    protected class View2D
    extends JPanel {
        private GraphicsCanvas mCanvas;
        protected JButton m3dViewButton;
        private JComboBox<String> mViewSelector;
        protected String mSelectedView;
        private JButton mCloseButton;
        private int viewNumber;
        private final String[] views = new String[]{"South", "North", "East", "West", "Top", "Bottom"};

        public View2D(int viewCount) {
            GridBagManager layout = new GridBagManager((Container)this);
            this.m3dViewButton = new JButton("Launch 3D viewer");
            this.m3dViewButton.addActionListener(ae -> SubstrateStackUI.getCurrentView3D());
            SubstrateStackUI.this.mZoomSlider = new JSlider(10, 90, 50);
            SubstrateStackUI.this.mZoomSlider.setMinimumSize(new Dimension(200, 50));
            SubstrateStackUI.this.mZoomSlider.setPaintTicks(true);
            SubstrateStackUI.this.mZoomSlider.setMajorTickSpacing(10);
            SubstrateStackUI.this.mZoomSlider.setName("Height Zoom");
            SubstrateStackUI.this.mZoomSlider.setPaintLabels(true);
            this.mViewSelector = new JComboBox<String>(this.views);
            this.mViewSelector.addActionListener(e -> {
                this.mSelectedView = (String)this.mViewSelector.getSelectedItem();
                this.mCanvas.repaint();
            });
            this.mSelectedView = (String)this.mViewSelector.getSelectedItem();
            this.mCloseButton = new JButton("X");
            this.mCloseButton.addActionListener(SubstrateStackUI.this.mViewPort);
            this.mCloseButton.setActionCommand("" + viewCount);
            this.viewNumber = viewCount;
            this.mCanvas = new GraphicsCanvas(this);
            layout.add((Component)this.mCanvas, (GridBagConstraints)GridBagManager.FILLALL);
            this.mCanvas.setMinimumSize(new Dimension(300, 300));
            layout.newline();
            JPanel btnPanel = new JPanel();
            GridBagManager top = new GridBagManager((Container)btnPanel);
            top.add(this.mViewSelector, (GridBagConstraints)GridBagManager.LEFT);
            top.add((Component)SubstrateStackUI.this.mZoomSlider, (GridBagConstraints)GridBagManager.LEFT);
            top.add((Component)this.m3dViewButton, (GridBagConstraints)GridBagManager.LEFT);
            layout.add((Component)btnPanel, (GridBagConstraints)GridBagManager.CENTER);
        }

        public void refreshCanvas() {
            this.mCanvas.repaint();
        }

        public void resetSize() {
            this.mCanvas.setSize(this.getPreferredSize());
        }

        public int getViewNumber() {
            return this.viewNumber;
        }

        private void reColor(String name) {
            this.mCanvas.repaint();
            this.mCanvas.setSelected(name);
        }

        public GraphicsCanvas getCanvas() {
            return this.mCanvas;
        }
    }

    protected class ViewPort
    extends JPanel
    implements ActionListener {
        static final int MAX_VIEW_PORT = 6;
        private LinkedList<View2D> mViews;
        private String mSelectedName = "";
        private DevicePath mSelectedDevice = null;
        private LinkedList<ShapeInfo> mShapeList;
        private final Color[] mColors = new Color[]{Color.RED, Color.BLUE, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.GRAY, Color.YELLOW};
        private int mColorCount = 0;
        private boolean mAutoContact = false;

        public ViewPort() {
            this.mViews = new LinkedList();
        }

        public boolean isMaxViewReached() {
            return this.mViews.size() >= 6;
        }

        public void setUp() {
            this.normalizeThickness(SubstrateStackUI.this.mDb);
            this.mShapeList = ShapeInfo.makeShapeInfoList(Lists.reverse(SubstrateStackUI.this.mLstSubstrates.mData.mDevices), SubstrateStackUI.this.mViewPort);
            this.mViews.add(new View2D(this.mViews.size() + 1));
            this.refreshSize(false, true);
        }

        public void addView() {
            if (this.isMaxViewReached()) {
                return;
            }
            this.mViews.add(new View2D(this.mViews.size() + 1));
            this.refreshSize(true, true);
        }

        public String getSelectedName() {
            return this.mSelectedName;
        }

        public DevicePath getSelectedDevice() {
            return this.mSelectedDevice;
        }

        public void clearSelection() {
            this.mSelectedName = "";
            this.mSelectedDevice = null;
        }

        public LinkedList<ShapeInfo> getShapeInfoList() {
            return this.mShapeList;
        }

        public void normalizeThickness(Db db) {
            for (Substrate s : db.getObjects(Substrate.class)) {
                if (s.getLayerCount() == 0 || s.getLayers().stream().mapToLong(Layer::getHeight).sum() == s.getHeight()) continue;
                ALog.logWarn((String)"Substrate %s has a height mismatch.", (Object[])new Object[]{s.getName()});
            }
        }

        public void refreshSize(boolean changing, boolean increasing) {
            this.mColorCount = 0;
            int size = this.mViews.size();
            this.removeAll();
            GridBagManager layout = new GridBagManager((Container)this);
            if (size == 1) {
                if (changing) {
                    if (increasing) {
                        SubstrateStackUI.this.bufferWindow();
                    } else if (!increasing) {
                        SubstrateStackUI.this.setWindowSize(new Dimension((int)(SubstrateStackUI.this.getWindowSize().getWidth() - this.mViews.get(0).getSize().getWidth()), (int)SubstrateStackUI.this.getWindowSize().getHeight()));
                    }
                } else {
                    SubstrateStackUI.this.setWindowSize(new Dimension(300, 300));
                }
                layout.add((Component)this.mViews.get(0), (GridBagConstraints)GridBagManager.FILLALL);
            } else if (size == 2) {
                if (changing) {
                    if (increasing) {
                        SubstrateStackUI.this.setWindowSize(new Dimension((int)SubstrateStackUI.this.getWindowSize().getWidth() + 310, (int)SubstrateStackUI.this.getWindowSize().getHeight()));
                    } else if (!increasing) {
                        SubstrateStackUI.this.setWindowSize(new Dimension((int)SubstrateStackUI.this.getWindowSize().getWidth(), (int)SubstrateStackUI.this.getWindowSize().getHeight() - 310));
                    }
                }
                ASplitPane splitter = new ASplitPane(1);
                JPanel left = new JPanel();
                GridBagManager leftLayout = new GridBagManager((Container)left);
                JPanel right = new JPanel();
                GridBagManager rightLayout = new GridBagManager((Container)right);
                leftLayout.add((Component)this.mViews.get(0), (GridBagConstraints)GridBagManager.FILLALL);
                rightLayout.add((Component)this.mViews.get(1), (GridBagConstraints)GridBagManager.FILLALL);
                splitter.setLeftComponent(left);
                splitter.setRightComponent(right);
                layout.add((Component)splitter, (GridBagConstraints)GridBagManager.FILLALL);
                splitter.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.5));
            } else if (size == 3) {
                if (changing) {
                    if (increasing) {
                        SubstrateStackUI.this.setWindowSize(new Dimension((int)SubstrateStackUI.this.getWindowSize().getWidth(), (int)SubstrateStackUI.this.getWindowSize().getHeight() + 310));
                    }
                    if (!increasing) {
                        SubstrateStackUI.this.bufferWindow();
                    }
                }
                ASplitPane splitter1 = new ASplitPane(0);
                JPanel s1B = new JPanel();
                GridBagManager s1BL = new GridBagManager((Container)s1B);
                ASplitPane splitter2 = new ASplitPane(1);
                JPanel s2L = new JPanel();
                GridBagManager s2LL = new GridBagManager((Container)s2L);
                JPanel s2R = new JPanel();
                GridBagManager s2RL = new GridBagManager((Container)s2R);
                s2LL.add((Component)this.mViews.get(0), (GridBagConstraints)GridBagManager.FILLALL);
                s2RL.add((Component)this.mViews.get(1), (GridBagConstraints)GridBagManager.FILLALL);
                s1BL.add((Component)this.mViews.get(2), (GridBagConstraints)GridBagManager.FILLALL);
                splitter2.setLeftComponent(s2L);
                splitter2.setRightComponent(s2R);
                splitter1.setTopComponent(splitter2);
                splitter1.setBottomComponent(s1B);
                layout.add((Component)splitter1, (GridBagConstraints)GridBagManager.FILLALL);
                splitter1.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getHeight() - 150.0) * 0.5));
                splitter2.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.5));
            } else if (size == 4) {
                if (changing) {
                    if (increasing) {
                        SubstrateStackUI.this.bufferWindow();
                    }
                    if (!increasing) {
                        SubstrateStackUI.this.setWindowSize(new Dimension((int)SubstrateStackUI.this.getWindowSize().getWidth() - 310, (int)SubstrateStackUI.this.getWindowSize().getHeight()));
                    }
                }
                ASplitPane splitter1 = new ASplitPane(0);
                ASplitPane splitter2 = new ASplitPane(1);
                JPanel s2L = new JPanel();
                GridBagManager s2LL = new GridBagManager((Container)s2L);
                JPanel s2R = new JPanel();
                GridBagManager s2RL = new GridBagManager((Container)s2R);
                ASplitPane splitter3 = new ASplitPane(1);
                JPanel s3L = new JPanel();
                GridBagManager s3LL = new GridBagManager((Container)s3L);
                JPanel s3R = new JPanel();
                GridBagManager s3RL = new GridBagManager((Container)s3R);
                s2LL.add((Component)this.mViews.get(0), (GridBagConstraints)GridBagManager.FILLALL);
                s2RL.add((Component)this.mViews.get(1), (GridBagConstraints)GridBagManager.FILLALL);
                s3LL.add((Component)this.mViews.get(2), (GridBagConstraints)GridBagManager.FILLALL);
                s3RL.add((Component)this.mViews.get(3), (GridBagConstraints)GridBagManager.FILLALL);
                splitter3.setLeftComponent(s3L);
                splitter3.setRightComponent(s3R);
                splitter2.setLeftComponent(s2L);
                splitter2.setRightComponent(s2R);
                splitter1.setTopComponent(splitter2);
                splitter1.setBottomComponent(splitter3);
                layout.add((Component)splitter1, (GridBagConstraints)GridBagManager.FILLALL);
                splitter1.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getHeight() - 150.0) * 0.5));
                splitter2.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.5));
                splitter3.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.5));
            } else if (size == 5) {
                if (changing) {
                    if (increasing) {
                        SubstrateStackUI.this.setWindowSize(new Dimension((int)SubstrateStackUI.this.getWindowSize().getWidth() + 310, (int)SubstrateStackUI.this.getWindowSize().getHeight()));
                    }
                    if (!increasing) {
                        SubstrateStackUI.this.bufferWindow();
                    }
                }
                ASplitPane splitter1 = new ASplitPane(0);
                ASplitPane splitter2 = new ASplitPane(1);
                JPanel s2L = new JPanel();
                GridBagManager s2LL = new GridBagManager((Container)s2L);
                ASplitPane splitter3 = new ASplitPane(1);
                JPanel s3L = new JPanel();
                GridBagManager s3LL = new GridBagManager((Container)s3L);
                JPanel s3R = new JPanel();
                GridBagManager s3RL = new GridBagManager((Container)s3R);
                ASplitPane splitter4 = new ASplitPane(1);
                JPanel s4L = new JPanel();
                GridBagManager s4LL = new GridBagManager((Container)s4L);
                JPanel s4R = new JPanel();
                GridBagManager s4RL = new GridBagManager((Container)s4R);
                s2LL.add((Component)this.mViews.get(0), (GridBagConstraints)GridBagManager.FILLALL);
                s3LL.add((Component)this.mViews.get(1), (GridBagConstraints)GridBagManager.FILLALL);
                s3RL.add((Component)this.mViews.get(2), (GridBagConstraints)GridBagManager.FILLALL);
                s4LL.add((Component)this.mViews.get(3), (GridBagConstraints)GridBagManager.FILLALL);
                s4RL.add((Component)this.mViews.get(4), (GridBagConstraints)GridBagManager.FILLALL);
                splitter3.setLeftComponent(s3L);
                splitter3.setRightComponent(s3R);
                splitter4.setLeftComponent(s4L);
                splitter4.setRightComponent(s4R);
                splitter2.setLeftComponent(s2L);
                splitter2.setRightComponent(splitter3);
                splitter1.setTopComponent(splitter2);
                splitter1.setBottomComponent(splitter4);
                layout.add((Component)splitter1, (GridBagConstraints)GridBagManager.FILLALL);
                splitter1.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getHeight() - 150.0) * 0.5));
                splitter2.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.33));
                splitter3.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.33));
                splitter4.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.5));
            } else if (size == 6) {
                SubstrateStackUI.this.bufferWindow();
                ASplitPane splitter1 = new ASplitPane(0);
                ASplitPane splitter2 = new ASplitPane(1);
                JPanel s2L = new JPanel();
                GridBagManager s2LL = new GridBagManager((Container)s2L);
                ASplitPane splitter3 = new ASplitPane(1);
                JPanel s3L = new JPanel();
                GridBagManager s3LL = new GridBagManager((Container)s3L);
                JPanel s3R = new JPanel();
                GridBagManager s3RL = new GridBagManager((Container)s3R);
                ASplitPane splitter4 = new ASplitPane(1);
                JPanel s4L = new JPanel();
                GridBagManager s4LL = new GridBagManager((Container)s4L);
                ASplitPane splitter5 = new ASplitPane(1);
                JPanel s5L = new JPanel();
                GridBagManager s5LL = new GridBagManager((Container)s5L);
                JPanel s5R = new JPanel();
                GridBagManager s5RL = new GridBagManager((Container)s5R);
                s2LL.add((Component)this.mViews.get(0), (GridBagConstraints)GridBagManager.FILLALL);
                s3LL.add((Component)this.mViews.get(1), (GridBagConstraints)GridBagManager.FILLALL);
                s3RL.add((Component)this.mViews.get(2), (GridBagConstraints)GridBagManager.FILLALL);
                s4LL.add((Component)this.mViews.get(3), (GridBagConstraints)GridBagManager.FILLALL);
                s5LL.add((Component)this.mViews.get(4), (GridBagConstraints)GridBagManager.FILLALL);
                s5RL.add((Component)this.mViews.get(5), (GridBagConstraints)GridBagManager.FILLALL);
                splitter3.setLeftComponent(s3L);
                splitter3.setRightComponent(s3R);
                splitter5.setLeftComponent(s5L);
                splitter5.setRightComponent(s5R);
                splitter2.setLeftComponent(s2L);
                splitter2.setRightComponent(splitter3);
                splitter4.setLeftComponent(s4L);
                splitter4.setRightComponent(splitter5);
                splitter1.setTopComponent(splitter2);
                splitter1.setBottomComponent(splitter4);
                layout.add((Component)splitter1, (GridBagConstraints)GridBagManager.FILLALL);
                splitter1.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getHeight() - 150.0) * 0.5));
                splitter2.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.33));
                splitter3.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.33));
                splitter4.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.33));
                splitter5.setDividerLocation((int)((SubstrateStackUI.this.getWindowSize().getWidth() - 50.0) * 0.33));
            } else if (size == 0) {
                layout.newline();
                layout.newline();
                layout.newline();
                layout.newline();
                layout.newline();
                layout.add((Component)new JLabel("Click the '+' button to add a view"), (GridBagConstraints)GridBagManager.CENTER);
                SubstrateStackUI.this.bufferWindow();
            }
            this.refresh();
            this.repaint();
        }

        public void reColor(String name) {
            this.mColorCount = 0;
            this.mSelectedName = name;
            this.mSelectedDevice = this.getDevice(name);
            for (View2D v : this.mViews) {
                v.reColor(name);
            }
            SubstrateStackUI.this.enableButtons();
        }

        public DevicePath getDevice(String name) {
            List<DevicePath> devicePaths = SubstrateStackUI.this.mLstSubstrates.mData.mDevices;
            for (DevicePath d : devicePaths) {
                if (!d.getLast().getName().equals(name)) continue;
                return d;
            }
            return null;
        }

        public void refresh() {
            this.mColorCount = 0;
            this.mShapeList = ShapeInfo.makeShapeInfoList(Lists.reverse(SubstrateStackUI.this.mLstSubstrates.mData.mDevices), SubstrateStackUI.this.mViewPort);
            for (View2D view : this.mViews) {
                view.refreshCanvas();
            }
            SubstrateStackUI.this.enableButtons();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int view = Integer.parseInt(e.getActionCommand());
            View2D toBeRemoved = null;
            for (View2D v : this.mViews) {
                if (v.getViewNumber() != view) continue;
                toBeRemoved = v;
            }
            if (toBeRemoved != null) {
                this.mViews.remove(toBeRemoved);
            }
            this.refreshSize(true, false);
        }

        public Color getNewColor() {
            Color c = this.mColors[this.mColorCount++];
            if (this.mColorCount >= this.mColors.length) {
                this.mColorCount = 0;
            }
            return c;
        }

        public boolean getAutoContact() {
            return this.mAutoContact;
        }

        public void setAutoContact(boolean autoContact) {
            this.mAutoContact = autoContact;
        }
    }

    public class AddSpacerDlg
    extends ADialog {
        protected boolean mAddAbove;
        protected JTabbedPane mTabs;
        protected JPanel mPnlRefGeom;
        protected JTextField mTxtXAdj;
        protected JTextField mTxtYAdj;
        protected JTextField mTxtHeight;
        protected JPanel mPnlTemplate;
        protected JList<DeviceTemplate> mLstSpacerTemplates;

        public AddSpacerDlg(DevicePath refSubstrate, boolean aboveRef) {
            super((Window)((Object)SubstrateStackUI.this), "Add Spacer", Dialog.ModalityType.APPLICATION_MODAL);
            this.mAddAbove = aboveRef;
            GridBagManager l = new GridBagManager(this.getContentPane());
            this.mTabs = new JTabbedPane();
            l.add((Component)this.mTabs, (GridBagConstraints)GridBagManager.FILLALL);
            this.mPnlRefGeom = new JPanel();
            this.mTabs.add("Device geometry", this.mPnlRefGeom);
            GridBagManager lRefGeom = new GridBagManager((Container)this.mPnlRefGeom);
            lRefGeom.add("Z size: ");
            this.mTxtHeight = new JTextField("0.0", 10);
            lRefGeom.add((Component)this.mTxtHeight, (GridBagConstraints)GridBagManager.LEFT);
            lRefGeom.newline();
            lRefGeom.add("Adjust X size: ");
            this.mTxtXAdj = new JTextField("0.0", 10);
            lRefGeom.add((Component)this.mTxtXAdj, (GridBagConstraints)GridBagManager.LEFT);
            this.mTxtXAdj.setMinimumSize(this.mTxtXAdj.getPreferredSize());
            lRefGeom.newline();
            lRefGeom.add("Adjust Y size: ");
            this.mTxtYAdj = new JTextField("0.0", 10);
            lRefGeom.add((Component)this.mTxtYAdj, (GridBagConstraints)GridBagManager.LEFT);
            lRefGeom.addFillAll();
            this.mPnlTemplate = new JPanel();
            this.mTabs.add("From template", this.mPnlTemplate);
            GridBagManager lTemplate = new GridBagManager((Container)this.mPnlTemplate);
            lTemplate.add("Select template:");
            lTemplate.newline();
            this.mLstSpacerTemplates = new JList<DeviceTemplate>(new AbstractListModel<DeviceTemplate>(){
                protected ArrayList<DeviceTemplate> mSpacers = new ArrayList();
                {
                    for (DeviceTemplate dt : SubstrateStackUI.this.mDb.getObjects(DeviceTemplate.class)) {
                        if (dt.getType() != DeviceTemplate.Type.SPACER) continue;
                        this.mSpacers.add(dt);
                    }
                    Collections.sort(this.mSpacers);
                }

                @Override
                public DeviceTemplate getElementAt(int index) {
                    return this.mSpacers.get(index);
                }

                @Override
                public int getSize() {
                    return this.mSpacers.size();
                }
            });
            this.mLstSpacerTemplates.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                    DeviceTemplate dt = (DeviceTemplate)value;
                    Substrate substrate = dt.getSubstrate();
                    this.setText(String.format("%s/%s", substrate.getName(), dt.getName()));
                    return c;
                }
            });
            JScrollPane spTemplates = new JScrollPane(this.mLstSpacerTemplates);
            lTemplate.add((Component)spTemplates, (GridBagConstraints)GridBagManager.FILLALL);
            l.addFillY();
            l.newline();
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.addFillX();
            JButton btnOk = new JButton("OK");
            btnOk.addActionListener(e -> {
                this.apply();
                SubstrateStackUI.this.mViewPort.refresh();
            });
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            JButton btnCancel = new JButton("Cancel");
            l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        protected void apply() {
            DevicePath path = SubstrateStackUI.this.mViewPort.getSelectedDevice();
            if (path == null) {
                assert (false);
                ALog.logError((Throwable)new NullPointerException("No selected substrate."), (String)"No selected substrate.", (Object[])new Object[0]);
                return;
            }
            Unit unit = SubstrateStackUI.this.mOrbitView.getUnit();
            Device refDevice = path.getLast();
            long refZLoc = Substrate.getZLoc((Device)refDevice);
            DevicePath parentPath = path.getParent();
            DeviceTemplate parent = parentPath.isDesign() ? Design.getDesign((Db)SubstrateStackUI.this.mDb) : parentPath.getDeviceTemplate();
            String instName = Device.getUniqueName((DeviceTemplate)parent, (String)(refDevice.getName() + "Spacer"));
            DeviceTemplate spacerTemplate = null;
            Component curTab = this.mTabs.getSelectedComponent();
            if (curTab == this.mPnlRefGeom) {
                Object o;
                long height;
                long yadd;
                long xadd;
                try {
                    double userXAdd = AFieldValidator.getValidatedDouble((JTextField)this.mTxtXAdj);
                    double userYAdd = AFieldValidator.getValidatedDouble((JTextField)this.mTxtYAdj);
                    double userHeight = AFieldValidator.getValidatedDouble((JTextField)this.mTxtHeight);
                    xadd = unit.fromUser(userXAdd);
                    yadd = unit.fromUser(userYAdd);
                    height = unit.fromUser(userHeight);
                    if (height <= 0L) {
                        throw AFieldValidator.createException((String)this.mTxtHeight.getText(), (String)"height, must be greater than zero", null, (Component)this.mTxtHeight);
                    }
                }
                catch (AFieldValidator.AFieldValidationException e) {
                    return;
                }
                ARect refRect = refDevice.getTemplate().getBounds(true).getBounds();
                ARect rect = new ARect(refRect);
                rect.expandBy(xadd / 2L, yadd / 2L, xadd / 2L, yadd / 2L);
                String name = refDevice.getTemplate().getName() + "Spacer";
                if (!refDevice.getMirror()) {
                    o = Cp.exec((String)"%s.createSpacerTemplate(curDb(), \"%s\", %dL, %dL, %dL, %dL, %dL)", (Object[])new Object[]{SubstrateStackUI.class.getName(), name, rect.getLL().getX(), rect.getLL().getY(), rect.getUR().getX(), rect.getUR().getY(), height});
                } else {
                    long length = Math.abs(rect.getUL().getX() - rect.getUR().getX());
                    o = Cp.exec((String)"%s.createSpacerTemplate(curDb(), \"%s\", %dL, %dL, %dL, %dL, %dL)", (Object[])new Object[]{SubstrateStackUI.class.getName(), name, rect.getLL().getX() - length, rect.getLL().getY(), rect.getUR().getX() - length, rect.getUR().getY(), height});
                }
                if (!(o instanceof DeviceTemplate)) {
                    ALog.logError((String)"Unexpected return from createSpacerTemplate().");
                    return;
                }
                spacerTemplate = (DeviceTemplate)o;
            } else if (curTab == this.mPnlTemplate) {
                spacerTemplate = this.mLstSpacerTemplates.getSelectedValue();
                if (spacerTemplate == null) {
                    JOptionPane.showMessageDialog(this.mLstSpacerTemplates, "A template must be selected.", "Add Spacer Error", 0);
                    return;
                }
            } else {
                assert (false);
                return;
            }
            Substrate spacerSubstrate = spacerTemplate.getSubstrate();
            long zloc = refZLoc;
            zloc = this.mAddAbove ? (zloc += Substrate.getHeight((Device)refDevice)) : (zloc -= spacerSubstrate.getHeight());
            APoint2D loc = refDevice.getLoc();
            float rot = refDevice.getRotate();
            Device d = (Device)Cp.exec((String)"_d = %s.createSpacerDevice(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{SubstrateStackUI.class.getName(), spacerTemplate.getKeyStr(), parent.getKeyStr(), instName});
            Cp.exec((String)"_d.setLoc(%dL, %dL", (Object[])new Object[]{loc.getX(), loc.getY()});
            Cp.exec((String)"_d_setRotate(%ff)", (Object[])new Object[]{Float.valueOf(rot)});
            Cp.exec((String)"Substrate.setZLoc(_d, %dL)", (Object[])new Object[]{zloc});
            Cp.exec((String)"unset(\"_d\");", (Object[])new Object[0]);
            DevicePath pathSpacer = new DevicePath(parentPath, d);
            SubstrateStackUI.this.mLstSubstrates.refreshData();
            if (SubstrateStackUI.this.mView3d != null) {
                SubstrateStackUI.this.mView3d.addOrUpdateNodeForPath(pathSpacer);
            }
            UIUtil.closeWindow((Window)((Object)this));
        }
    }

    protected class View3D
    extends A3DViewPanel {
        protected final PolygonAttributes sPolygonAttrs;
        protected final TransparencyAttributes sTransparencyAttrs = new TransparencyAttributes(4, 0.5f);
        protected ViewColorizer mColorizer;
        protected BranchGroup mSceneNode;
        protected BranchGroup mConnectionGroup;
        protected HashMap<DevicePath, BranchGroup> mPath2Node;
        protected Unit m3dViewUnit;

        public View3D() {
            this.sPolygonAttrs = new PolygonAttributes();
            this.sPolygonAttrs.setCullFace(0);
            this.mColorizer = null;
            this.mConnectionGroup = null;
            this.mPath2Node = new HashMap();
            this.m3dViewUnit = null;
            if (SubstrateStackUI.this.mOrbitView instanceof DesignView2D) {
                DesignView2D v2d = (DesignView2D)SubstrateStackUI.this.mOrbitView;
                this.mColorizer = v2d.getColorizer();
            } else {
                this.mColorizer = ViewColorizer.createViewColorizer((Db)SubstrateStackUI.this.mDb, (DevicePath)Design.getDesignPath((Db)SubstrateStackUI.this.mDb));
            }
            this.mSceneNode = new BranchGroup();
            this.mSceneNode.setCapability(12);
            this.mSceneNode.setCapability(13);
            this.mSceneNode.setCapability(14);
            List<DevicePath> substrateInsts = SubstrateStackUI.this.mLstSubstrates.mData.mDevices;
            for (DevicePath path : substrateInsts) {
                this.addOrUpdateNodeForPath(path);
            }
            BoundingSphere boundingSphere = new BoundingSphere(this.mSceneNode.getBounds());
            this.constructAxes((Group)this.mSceneNode, (float)boundingSphere.getRadius() * 1.1f);
            this.setContent(this.mSceneNode);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.setView("South");
        }

        public void updateColor(DevicePath path) {
            BranchGroup bg = this.mPath2Node.get(path);
            if (bg == null) {
                return;
            }
            ColoringAttributes colorAttrs = this.getColor(path);
            TransformGroup tg = (TransformGroup)bg.getChild(0);
            Cube cube = (Cube)tg.getChild(0);
            cube.getAppearance().setColoringAttributes(colorAttrs);
        }

        public void addConnection(Connection c) {
            LineArray connectionVector = new LineArray(2, 5);
            DevicePath aDevicePath = c.getDPPA().getPath();
            APoint2D p = c.getDPPA().getWorldLoc();
            Device s = aDevicePath.pathToSubstrate().getLast();
            Unit unit = this.get3DViewUnit();
            float x = (float)unit.toUser(p.getX());
            float y = (float)unit.toUser(p.getY());
            float z = (float)unit.toUser(Substrate.getZLoc((DevicePath)aDevicePath));
            connectionVector.setCoordinate(0, new Point3f(x, y, z += (float)unit.toUser(Substrate.getHeight((Device)s))));
            aDevicePath = c.getDPPB().getPath();
            p = c.getDPPB().getWorldLoc();
            s = aDevicePath.pathToSubstrate().getLast();
            x = (float)unit.toUser(p.getX());
            y = (float)unit.toUser(p.getY());
            z = (float)unit.toUser(Substrate.getZLoc((Device)s));
            connectionVector.setCoordinate(1, new Point3f(x, y, z += (float)unit.toUser(Substrate.getHeight((Device)s))));
            connectionVector.setColor(0, new Color3b(Color.YELLOW));
            connectionVector.setColor(1, new Color3b(Color.YELLOW));
            this.mConnectionGroup.addChild((Node)new Shape3D((Geometry)connectionVector));
        }

        public BranchGroup makeNode(DevicePath path) {
            Substrate substrate = path.getSubstrate();
            if (substrate == null) {
                return null;
            }
            ColoringAttributes colorAttrs = this.getColor(path);
            Unit unit = this.get3DViewUnit();
            ARect bounds = path.getBB();
            APoint2D loc = bounds.center();
            float x = (float)unit.toUser(loc.getX());
            float y = (float)unit.toUser(loc.getY());
            float z = (float)unit.toUser(Substrate.getZLoc((DevicePath)path));
            float dx = (float)unit.toUser(bounds.width());
            float dy = (float)unit.toUser(bounds.height());
            float dz = (float)unit.toUser(substrate.getHeight());
            Transform3D xform = new Transform3D();
            xform.setTranslation(new Vector3f(x, y, z + dz / 2.0f));
            TransformGroup tg = new TransformGroup(xform);
            tg.setCapability(12);
            Appearance appear = new Appearance();
            appear.setColoringAttributes(colorAttrs);
            appear.setPolygonAttributes(this.sPolygonAttrs);
            appear.setTransparencyAttributes(this.sTransparencyAttrs);
            appear.setCapability(9);
            Cube c = new Cube(appear, dx, dy, dz);
            c.setCapability(14);
            tg.addChild((Node)c);
            BranchGroup bg = new BranchGroup();
            bg.setCapability(17);
            bg.setCapability(12);
            bg.addChild((Node)tg);
            return bg;
        }

        public ColoringAttributes getColor(DevicePath path) {
            Color color = Color.WHITE;
            DevicePath selected = (DevicePath)SubstrateStackUI.this.mLstSubstrates.getSelectedValue();
            if (selected == null || !path.equals((Object)selected)) {
                APatternColor pc = this.mColorizer.getColor(path);
                Color color2 = color = pc != null ? pc.getColor() : null;
                if (color == null) {
                    color = Color.GRAY;
                }
            }
            return new ColoringAttributes(new Color3f(color), 0);
        }

        public void updateAllConnections() {
            try {
                if (this.mConnectionGroup != null && this.mConnectionGroup.numChildren() > 0) {
                    this.mSceneNode.removeChild((Node)this.mConnectionGroup);
                }
                this.mConnectionGroup = new BranchGroup();
                this.mConnectionGroup.setCapability(17);
                this.mConnectionGroup.setCapability(12);
                for (Connection c : OrbitIO.getCurDb().getObjects(Connection.class)) {
                    this.addConnection(c);
                }
                this.mSceneNode.addChild((Node)this.mConnectionGroup);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void notifyChanged(DevicePath path) {
            this.updateAllConnections();
            Design design = Design.getDesign((Db)SubstrateStackUI.this.mDb);
            if (design != null) {
                for (DevicePath p2 : design.getDescendantDevices()) {
                    if (!p2.getLast().getIsSubstrate()) continue;
                    if (p2.getLast().getTemplate() == path.getLast().getTemplate()) {
                        this.addOrUpdateNodeForPath(p2);
                    }
                    if (!p2.getString().startsWith(path.getString())) continue;
                    this.addOrUpdateNodeForPath(p2);
                }
            } else {
                this.addOrUpdateNodeForPath(path);
            }
        }

        public void addOrUpdateNodeForPath(DevicePath path) {
            try {
                this.updateAllConnections();
                this.removeNodeForPath(path);
                BranchGroup bg = this.makeNode(path);
                if (bg != null) {
                    this.mSceneNode.addChild((Node)bg);
                    this.mPath2Node.put(path, bg);
                }
            }
            catch (Exception e) {
                ALog.logWarn((Throwable)e, (String)"Error adding view node for path '%s'.", (Object[])new Object[]{path});
            }
        }

        public void removeNodeForPath(DevicePath path) {
            try {
                BranchGroup bg = this.mPath2Node.get(path);
                if (bg != null) {
                    this.mSceneNode.removeChild((Node)bg);
                    this.mPath2Node.remove(path);
                }
            }
            catch (Exception e) {
                ALog.logWarn((Throwable)e, (String)"Error removing view node for path '%s'.", (Object[])new Object[]{path});
            }
        }

        protected Vector3f getWorldCenter() {
            Design design = Design.getDesign((Db)SubstrateStackUI.this.mDb);
            ARect world = null;
            for (DevicePath path : design.getDescendantDevices()) {
                if (world == null) {
                    world = new ARect(path.getBB());
                    continue;
                }
                world.expand(path.getBB());
            }
            if (world == null) {
                return new Vector3f();
            }
            Unit u = this.get3DViewUnit();
            return new Vector3f((float)u.toUser(world.centerX()), (float)u.toUser(world.centerX()), 0.0f);
        }

        protected Unit get3DViewUnit() {
            if (this.m3dViewUnit == null) {
                this.m3dViewUnit = Design.getUnit((Db)SubstrateStackUI.this.mDb);
                this.m3dViewUnit = new Unit("3D View Unit", (double)this.m3dViewUnit.fromUser(1.0) * 1000.0);
            }
            return this.m3dViewUnit;
        }

        protected void constructAxes(Group node, float extent) {
            LineArray axisXLines = new LineArray(2, 5);
            node.addChild((Node)new Shape3D((Geometry)axisXLines));
            axisXLines.setCoordinate(0, new Point3f(-extent, 0.0f, 0.0f));
            axisXLines.setCoordinate(1, new Point3f(extent, 0.0f, 0.0f));
            axisXLines.setColor(0, new Color3b(Color.RED));
            axisXLines.setColor(1, new Color3b(Color.RED));
            LineArray axisYLines = new LineArray(2, 5);
            node.addChild((Node)new Shape3D((Geometry)axisYLines));
            axisYLines.setCoordinate(0, new Point3f(0.0f, -extent, 0.0f));
            axisYLines.setCoordinate(1, new Point3f(0.0f, extent, 0.0f));
            axisYLines.setColor(0, new Color3b(Color.GREEN));
            axisYLines.setColor(1, new Color3b(Color.GREEN));
            LineArray axisZLines = new LineArray(2, 5);
            node.addChild((Node)new Shape3D((Geometry)axisZLines));
            axisZLines.setCoordinate(0, new Point3f(0.0f, 0.0f, -extent));
            axisZLines.setCoordinate(1, new Point3f(0.0f, 0.0f, extent));
            axisZLines.setColor(0, new Color3b(Color.BLUE));
            axisZLines.setColor(1, new Color3b(Color.BLUE));
        }
    }

    public class DevicePathCellRenderer
    extends JLabel
    implements ListCellRenderer<DevicePath> {
        @Override
        public Component getListCellRendererComponent(JList<? extends DevicePath> list, DevicePath value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setOpaque(true);
            String txt = value instanceof DevicePath ? value.getString() : "";
            this.setText(txt);
            this.setToolTipText(txt);
            return this;
        }
    }

    public class SubstrateList
    extends JList<DevicePath> {
        protected Model mData = new Model();
        protected TransferHandler mTransferHandler = new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                final DevicePath substratePath = (DevicePath)SubstrateList.this.getSelectedValue();
                if (substratePath == null) {
                    return null;
                }
                return new Transferable(){

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                        if (flavor == DataFlavor.stringFlavor) {
                            return String.format(substratePath.toString(), new Object[0]);
                        }
                        if (flavor == SubstrateDataFlavor) {
                            return substratePath;
                        }
                        throw new UnsupportedFlavorException(flavor);
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return SubstrateList.this.SupportedDataFlavors;
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return AUtil.find((Object)flavor, (Object[])SubstrateList.this.SupportedDataFlavors) >= 0;
                    }
                };
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                if (!support.isDataFlavorSupported(SubstrateDataFlavor)) {
                    return false;
                }
                JList.DropLocation dropLoc = (JList.DropLocation)support.getDropLocation();
                int insertAt = dropLoc.getIndex();
                return insertAt != -1;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                long newZ;
                DevicePath devicePath;
                if (!support.isDrop()) {
                    return false;
                }
                JList.DropLocation dropLoc = (JList.DropLocation)support.getDropLocation();
                int insertAt = dropLoc.getIndex();
                if (insertAt == -1) {
                    return false;
                }
                try {
                    devicePath = (DevicePath)support.getTransferable().getTransferData(SubstrateDataFlavor);
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Error moving substrate.", (Object[])new Object[0]);
                    return false;
                }
                if (insertAt == SubstrateList.this.mData.getSize()) {
                    DevicePath under = SubstrateList.this.mData.getElementAt(insertAt - 1);
                    long z = Substrate.getZLoc((DevicePath)under);
                    newZ = z - Substrate.getHeight((Device)devicePath.getLast());
                } else {
                    DevicePath over = SubstrateList.this.mData.getElementAt(insertAt);
                    long z = Substrate.getZLoc((DevicePath)over);
                    newZ = z + Substrate.getHeight((Device)over.getLast());
                }
                long oldZ = Substrate.getZLoc((DevicePath)devicePath);
                long diff = newZ - oldZ;
                if (diff != 0L) {
                    String parentSubstrateName;
                    String parentName;
                    long localZ = Substrate.getZLoc((Device)devicePath.getLast());
                    long newLocalZ = localZ + diff;
                    DevicePath parentPath = devicePath.getParent();
                    if (parentPath.isDesign()) {
                        parentName = "<Design>";
                        parentSubstrateName = "null";
                    } else {
                        parentName = parentPath.getLast().getTemplate().getName();
                        parentSubstrateName = String.format("\"%s\"", parentPath.getLast().getTemplate().getSubstrate().getName());
                    }
                    if (((Boolean)Cp.exec((String)"com.sigrity.orbit.ui.SubstrateStackUI.setSubstrateZ(curDb(), %s, \"%s\", \"%s\", %dL)", (Object[])new Object[]{parentSubstrateName, parentName, devicePath.getLast().getName(), newLocalZ})).booleanValue()) {
                        SubstrateList.this.refreshData();
                        if (SubstrateStackUI.this.mView3d != null) {
                            SubstrateStackUI.this.mView3d.notifyChanged(devicePath);
                        }
                    }
                    EventQueue.invokeLater(() -> SubstrateList.this.setSelectedValue(devicePath, true));
                }
                SubstrateStackUI.this.mViewPort.refresh();
                return true;
            }
        };
        public final DataFlavor[] SupportedDataFlavors = new DataFlavor[]{DataFlavor.stringFlavor, SubstrateDataFlavor};

        public SubstrateList() {
            this.refreshData();
            this.setModel(this.mData);
            this.setCellRenderer(new CellRenderer());
            this.setSelectionMode(0);
            this.setDragEnabled(true);
            this.setTransferHandler(this.mTransferHandler);
            this.setDropMode(DropMode.ON);
            UIUtil.installPopupMenu((Component)this, (UIUtil.APopupMenuAdapter)new PopupMenuAdapter());
        }

        public void refreshData() {
            DevicePath oldSelection = (DevicePath)this.getSelectedValue();
            this.mData.populate(SubstrateStackUI.this.mDb);
            this.setSelectedValue(oldSelection, true);
        }

        protected class CellRenderer
        extends DefaultListCellRenderer {
            protected CellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                if (value instanceof DevicePath) {
                    DevicePath path = (DevicePath)value;
                    long z = Substrate.getZLoc((DevicePath)path);
                    Unit unit = SubstrateStackUI.this.mOrbitView.getUnit();
                    String strZ = unit.toUserStr(z, false);
                    long h = Substrate.getHeight((Device)path.getLast());
                    String strZTop = unit.toUserStr(z + h);
                    this.setText(String.format("%s (%s \u2013 %s)", path.toString(), strZ, strZTop));
                }
                return c;
            }
        }

        protected class Model
        extends AbstractListModel<DevicePath> {
            protected List<DevicePath> mDevices = new LinkedList<DevicePath>();

            protected Model() {
            }

            @Override
            public DevicePath getElementAt(int index) {
                return this.mDevices.get(index);
            }

            @Override
            public int getSize() {
                return this.mDevices.size();
            }

            public void populate(Db db) {
                List substrates = Substrate.getSubstrateInstances((Db)db).stream().filter(dp -> !dp.getLast().getIsDefinitelyNotSubstrate()).collect(Collectors.toList());
                SubstrateList.this.mData.mDevices = SubstrateList.this.mData.mDevices.stream().filter(substrates::contains).collect(Collectors.toList());
                substrates.stream().filter(d -> !SubstrateList.this.mData.mDevices.contains(d)).forEach(SubstrateList.this.mData.mDevices::add);
                Collections.sort(SubstrateList.this.mData.mDevices, Substrate.ZOrderDescendingComparator);
                this.fireContentsChanged(this, 0, this.mDevices.size() - 1);
            }

            public void swap(int first, int second) {
                Collections.swap(this.mDevices, first, second);
            }
        }
    }

    public static class PhysicalTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object val, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, val, selected, expanded, leaf, row, hasFocus);
            this.setFont(this.getFont().deriveFont(0));
            if (val instanceof SubstrateNode) {
                ((SubstrateNode)val).render(this);
            }
            return this;
        }
    }

    public class SubstrateNode
    extends DefaultMutableTreeNode {
        public SubstrateNode(DevicePath d) {
            super(d);
        }

        public SubstrateNode() {
        }

        @Override
        public String toString() {
            if (this.userObject instanceof DevicePath) {
                return ((DevicePath)this.userObject).getLast().getName();
            }
            return "";
        }

        public void render(PhysicalTreeCellRenderer r) {
            if (this.userObject instanceof DevicePath) {
                r.setText(((DevicePath)this.userObject).getLast().getName());
                r.setIcon(DbExplorerPanel.getIconForTemplateType(((DevicePath)this.userObject).getLast().getTemplate().getType()));
            }
        }
    }

    protected class PopupMenuAdapter
    extends UIUtil.AStaticPopupMenuAdapter {
        public PopupMenuAdapter() {
            super((JPopupMenu)new PopupMenu());
        }

        public void showMenu(Component component, int x, int y) {
            super.showMenu(component, x, y);
        }
    }

    protected class PopupMenu
    extends JPopupMenu {
        protected JMenuItem mItemRemoveSpacer;

        public PopupMenu() {
            this.add(new JMenuItem("Add spacer above")).addActionListener(ae -> this.addSpacer(true));
            this.add(new JMenuItem("Add spacer below")).addActionListener(ae -> this.addSpacer(false));
            this.mItemRemoveSpacer = new JMenuItem("Remove spacer");
            this.mItemRemoveSpacer.addActionListener(ae -> this.removeSpacer());
            this.add(this.mItemRemoveSpacer);
            this.add(new JMenuItem("Flip device")).addActionListener(ae -> {
                DevicePath d = SubstrateStackUI.this.mViewPort.getSelectedDevice();
                Cp.exec((String)"UserCommands.flipDeviceInPlace(\"%s\");", (Object[])new Object[]{d.toString()});
                OrbitIO.getApp().refreshCurrentView(false);
                SubstrateStackUI.this.mViewPort.refresh();
            });
            JMenuItem updateHeight = new JMenuItem("Update height");
            updateHeight.setToolTipText("Update substrate height with its layers.");
            updateHeight.addActionListener(ae -> {
                Substrate s = SubstrateStackUI.this.mViewPort.getSelectedDevice().getSubstrate();
                Cp.exec((String)"_substrate = Substrate.getSubstrate(curDb(), \"%s\")", (Object[])new Object[]{s.getName()});
                Cp.exec((String)"_substrate.normalizeThickness(true)", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_substrate\")", (Object[])new Object[0]);
                SubstrateStackUI.this.mViewPort.refresh();
            });
            this.add(updateHeight);
        }

        @Override
        public void show(Component invoker, int x, int y) {
            DevicePath path = SubstrateStackUI.this.mViewPort.getSelectedDevice();
            if (path == null || path.isEmpty() || path.getLast().getDb() == null) {
                return;
            }
            this.mItemRemoveSpacer.setVisible(path.getLast() != null && path.getLast().getTemplate().getType() == DeviceTemplate.Type.SPACER);
            super.show(invoker, x, y);
        }

        protected void addSpacer(boolean above) {
            DevicePath path = SubstrateStackUI.this.mViewPort.getSelectedDevice();
            AddSpacerDlg dlg = new AddSpacerDlg(path, above);
            dlg.setVisible(true);
        }

        protected void removeSpacer() {
            DevicePath path = SubstrateStackUI.this.mViewPort.getSelectedDevice();
            DeleteDeviceUI.showUI(OrbitIO.getMainWindow(), path.getDevice());
            SubstrateStackUI.this.mLstSubstrates.refreshData();
            if (SubstrateStackUI.this.mView3d != null) {
                SubstrateStackUI.this.mView3d.removeNodeForPath(path);
            }
            SubstrateStackUI.this.mViewPort.clearSelection();
            SubstrateStackUI.this.mViewPort.refresh();
        }
    }

    public class SubstrateTree
    extends JTree {
        public SubstrateTree() {
            this.setModel(null);
            this.setCellRenderer(new PhysicalTreeCellRenderer());
            this.setModel(new Model());
            this.setRootVisible(false);
            this.expandAllNodes();
            this.setShowsRootHandles(true);
            this.setDragEnabled(false);
            UIUtil.installPopupMenu((Component)this, (UIUtil.APopupMenuAdapter)new PopupMenuAdapter());
        }

        private void expandAllNodes() {
            this.expandAllNodes(0, this.getRowCount());
        }

        private void expandAllNodes(int startingIndex, int rowCount) {
            for (int i = startingIndex; i < rowCount; ++i) {
                this.expandRow(i);
            }
            if (this.getRowCount() != rowCount) {
                this.expandAllNodes(rowCount, this.getRowCount());
            }
        }

        public void refresh() {
            this.setModel(new Model());
            this.expandAllNodes();
        }

        @Override
        public Model getModel() {
            return (Model)super.getModel();
        }

        public class Model
        extends DefaultTreeModel {
            public Model() {
                super(new SubstrateNode());
                this.generateTree();
            }

            public Model(TreeNode n) {
                super(n);
            }

            public SubstrateNode getNode(DevicePath d) {
                SubstrateNode n = (SubstrateNode)this.getRoot();
                for (int i = 0; i < n.getChildCount(); ++i) {
                    SubstrateNode node = (SubstrateNode)n.getChildAt(i);
                    if ((node = this.getNode(d, node)) == null) continue;
                    return node;
                }
                return null;
            }

            public SubstrateNode getNode(DevicePath d, SubstrateNode n) {
                if (((DevicePath)n.getUserObject()).equals((Object)d)) {
                    return n;
                }
                if (n.isLeaf()) {
                    return null;
                }
                for (int i = 0; i < n.getChildCount(); ++i) {
                    SubstrateNode node = (SubstrateNode)n.getChildAt(i);
                    if (this.getNode(d, node) == null) continue;
                    return node;
                }
                return null;
            }

            private void generateTree() {
                LinkedList<DevicePath> paths = new LinkedList<DevicePath>(SubstrateStackUI.this.mLstSubstrates.mData.mDevices);
                Collections.sort(paths, Substrate.ZOrderAscendingComparator);
                LinkedList<Device> devices = new LinkedList<Device>();
                for (DevicePath d : paths) {
                    devices.add(d.getLast());
                }
                for (int i = 0; i < paths.size(); ++i) {
                    Device d1 = paths.get(i).getLast();
                    long height1 = Substrate.getZLoc((DevicePath)paths.get(i));
                    ARect r1 = d1.getAllWorldBounds();
                    SubstrateNode n = (SubstrateNode)this.getRoot();
                    for (int j = i - 1; j >= 0; --j) {
                        Device d2 = paths.get(j).getLast();
                        long height2 = Substrate.getZLoc((DevicePath)paths.get(j));
                        ARect r2 = d2.getAllWorldBounds();
                        if (height1 == height2 || !r1.hOverlaps(r2) || !r1.vOverlaps(r2)) continue;
                        n = this.getNode(paths.get(j));
                        j = -1;
                    }
                    this.insertNodeInto(new SubstrateNode(paths.get(i)), n, n.getChildCount());
                }
            }
        }
    }
}

