/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class SwapPinsUI {
    public static final String SWAP_SELECTED_PINS_ACTIONNAME = "SwapSelectedPins";
    public static final String SWAP_SELECTED_PINS_BUTTONNAME = "Swap Nets";

    private SwapPinsUI() {
    }

    public static Action getSwapSelectedPinsAction() {
        return new ActionSwapPinNets();
    }

    public static void swapSelectedPins() {
        SwapPinsUI.swapSelectedPins(false);
    }

    public static boolean isValidForSelectedPins(boolean checkContactPins) {
        List selPins = OrbitIO.getCurDesign().getCurSelection().getSelectedHierInsts(PinInstance.class).stream().filter(hPin -> !((PinInstance)hPin.getDbObject()).fixed()).limit(3L).collect(Collectors.toList());
        if (selPins.size() != 2) {
            return false;
        }
        HierInst selPinA = (HierInst)selPins.get(0);
        HierInst selPinB = (HierInst)selPins.get(1);
        return ((PinInstance)selPinA.getDbObject()).getType() == ((PinInstance)selPinB.getDbObject()).getType();
    }

    private static void swapSelectedPins(boolean checkContactPins) {
        List selPins = OrbitIO.getCurDesign().getCurSelection().getSelectedHierInsts(PinInstance.class).stream().filter(hPin -> !((PinInstance)hPin.getDbObject()).fixed()).limit(3L).collect(Collectors.toList());
        if (selPins.size() != 2) {
            ALog.logInfo((String)"Select exactly two free pins");
            return;
        }
        HierInst selPinA = (HierInst)selPins.get(0);
        HierInst selPinB = (HierInst)selPins.get(1);
        SwapPinsUI.cpSwapPins((HierInst<PinInstance>)selPinA, (HierInst<PinInstance>)selPinB);
        if (checkContactPins) {
            SwapPinsUI.checkContactPins((HierInst<PinInstance>)selPinA, (HierInst<PinInstance>)selPinB);
        }
    }

    private static void checkContactPins(HierInst<PinInstance> selPinA, HierInst<PinInstance> selPinB) {
        ArrayList contactPinAs = AUtil.arrayList((Iterator)PinMap.getContactPin(selPinA));
        ArrayList contactPinBs = AUtil.arrayList((Iterator)PinMap.getContactPin(selPinB));
        if (contactPinAs.isEmpty() || contactPinBs.isEmpty()) {
            return;
        }
        if (contactPinAs.size() > 1 || contactPinBs.size() > 1) {
            ALog.logDebug((String)"Swap contact pins failed. There exist multiple contact pins for the selected pins.");
            return;
        }
        assert (contactPinAs.size() == 1 && contactPinBs.size() == 1);
        HierInst contactPinA = (HierInst)contactPinAs.get(0);
        HierInst contactPinB = (HierInst)contactPinBs.get(0);
        SwapPinsUI.showOptionsUI((HierInst<PinTemplate>)contactPinA, (HierInst<PinTemplate>)contactPinB);
    }

    private static void showOptionsUI(HierInst<PinTemplate> contactPinA, HierInst<PinTemplate> contactPinB) {
        int op = 0;
        if (AApp.getApp().getMainWin() != null && !OrbitApp.suppressWaringDialogs()) {
            String message = "Swap contact pins of selected pins?";
            op = OrbitApp.showWarningConfirmDialog((String)message, (String)"Swap Pins");
        }
        if (op == 0) {
            SwapPinsUI.swapPins(contactPinA, contactPinB);
        }
    }

    private static void cpSwapPins(HierInst<PinInstance> pinInstA, HierInst<PinInstance> pinInstB) {
        SwapPinsUI.cpSwapPins(pinInstA.getPath(), ((PinInstance)pinInstA.getDbObject()).getPinTemplate(), pinInstB.getPath(), ((PinInstance)pinInstB.getDbObject()).getPinTemplate());
    }

    private static void swapPins(HierInst<PinTemplate> contactPinA, HierInst<PinTemplate> contactPinB) {
        SwapPinsUI.cpSwapPins(contactPinA.getPath(), (PinTemplate)contactPinA.getDbObject(), contactPinB.getPath(), (PinTemplate)contactPinB.getDbObject());
    }

    private static void cpSwapPins(DevicePath devPathA, PinTemplate pinTA, DevicePath devPathB, PinTemplate pinTB) {
        Cp.exec((String)"com.sigrity.orbit.util.SwapPins.swapPins(curDb(), \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{devPathA.getAFullPath(), pinTA.getName(), devPathB.getAFullPath(), pinTB.getName()});
    }

    private static void refreshView() {
        Db db = OrbitIO.getCurDb();
        if (db.getObjectCount(Connection.class) > 0) {
            DbHistory history = db.getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("Refresh Connection After Swap Nets");){
                Cp.exec((String)"%s.createConnections()", (Object[])new Object[]{UserCommands.class.getName()});
            }
        } else {
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionSwapPinNets
    extends AbstractAction {
        public ActionSwapPinNets() {
            super(SwapPinsUI.SWAP_SELECTED_PINS_ACTIONNAME);
            this.putValue("ButtonText", SwapPinsUI.SWAP_SELECTED_PINS_BUTTONNAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Design design = OrbitIO.getCurDesign();
            if (design == null) {
                return;
            }
            SwapPinsUI.swapSelectedPins(true);
            SwapPinsUI.refreshView();
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && OrbitIO.getCurDb() != null && SwapPinsUI.isValidForSelectedPins(true);
        }
    }
}

