/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.APair;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SymbolSpreadsheet {
    public static final String EXCEL_DATA_NONE = "None";
    public static final String EXCEL_DATA_FIELD_PIN_NAME = "Pin Name";
    public static final String EXCEL_DATA_FIELD_NET_NAME = "Net Name";
    public static final String EXCEL_DATA_COLOR_SOURCE_PERSONALITY = "Personalities";
    public static final String EXCEL_DATA_COLOR_SOURCE_INTERFACE = "Interfaces/Personalities";
    protected static String mWorksheetName = null;
    protected static DevicePath mDevicePath = null;
    protected static Worksheet mWorksheet = null;
    protected static Map<String, Worksheet> mWorksheets = new HashMap<String, Worksheet>();
    protected static Map<String, Style> mStyles = new HashMap<String, Style>();

    public static class Style {
        public final String id;
        public final String name;
        public final String parent;
        public final List<StyleBorder> borders = new ArrayList<StyleBorder>();
        public final List<APair<String, String>> alignments = new ArrayList<APair<String, String>>();
        public final List<APair<String, String>> fonts = new ArrayList<APair<String, String>>();
        public final List<APair<String, String>> interiors = new ArrayList<APair<String, String>>();
        public final List<APair<String, String>> numberFormats = new ArrayList<APair<String, String>>();
        public final List<APair<String, String>> protections = new ArrayList<APair<String, String>>();

        public Style(String i, String n, String p) {
            this.id = i;
            this.name = n;
            this.parent = p;
            this.borders.clear();
            this.alignments.clear();
            this.fonts.clear();
            this.interiors.clear();
            this.numberFormats.clear();
            this.protections.clear();
        }

        public void createBorder(String pos, String c, String ls, String w) {
            StyleBorder b = new StyleBorder(pos, c, ls, w);
            this.borders.add(b);
        }

        public void createAlignment(String key, String val) {
            APair pair = new APair((Object)key, (Object)val);
            this.alignments.add((APair<String, String>)pair);
        }

        public void createFont(String key, String val) {
            APair pair = new APair((Object)key, (Object)val);
            this.fonts.add((APair<String, String>)pair);
        }

        public void createInterior(String key, String val) {
            APair pair = new APair((Object)key, (Object)val);
            this.interiors.add((APair<String, String>)pair);
        }

        public void createNumberFormats(String key, String val) {
            APair pair = new APair((Object)key, (Object)val);
            this.numberFormats.add((APair<String, String>)pair);
        }

        public void createProtections(String key, String val) {
            APair pair = new APair((Object)key, (Object)val);
            this.protections.add((APair<String, String>)pair);
        }
    }

    public static class StyleBorder {
        public final String position;
        public final String color;
        public final String lineStyle;
        public final String weight;

        public StyleBorder(String pos, String col, String ls, String wgt) {
            this.position = pos;
            this.color = col;
            this.lineStyle = ls;
            this.weight = wgt;
        }
    }

    public static class Worksheet {
        public String name = "";
        public int numRows = 0;
        public int numCols = 0;
        public TreeMap<Long, WorksheetRow> rows = new TreeMap();
        public TreeMap<Long, WorksheetCol> cols = new TreeMap();
        public TreeMap<String, Integer> personalitiesList = new TreeMap();
        public TreeMap<String, Integer> interfacesList = new TreeMap();
        public ArrayList<PinInfo> pinsList = new ArrayList();

        public Worksheet(String n) {
            this.name = n;
            this.numRows = 0;
            this.numCols = 0;
            this.rows.clear();
            this.cols.clear();
            this.personalitiesList.clear();
            this.interfacesList.clear();
            this.pinsList.clear();
        }

        public static class PinInfo {
            public PinTemplate pin = null;
            public String netName = null;
            public String part1Str = null;
            public String part2Str = null;
            public long rowNum = 0L;
            public long colNum = 0L;
            public long xLoc = 0L;
            public long yLoc = 0L;
            public DbObject perOrIntf = null;

            public PinInfo(PinTemplate pi, long r, long c, long x, long y, DbObject d, String n, String p1, String p2) {
                this.pin = pi;
                this.rowNum = r;
                this.colNum = c;
                this.xLoc = x;
                this.yLoc = y;
                this.perOrIntf = d;
                this.netName = n;
                this.part1Str = p1;
                this.part2Str = p2;
            }
        }
    }

    public static class WorksheetCol {
        public long colNum = 0L;
        public String width = "";
        public String autoWidth = "";
        public String style = "";

        public WorksheetCol(long i, String w, String aw, String s) {
            this.colNum = i;
            this.width = w;
            this.autoWidth = aw;
            this.style = s;
        }
    }

    public static class WorksheetRow {
        public long rowNum = 0L;
        public String height = "";
        public String autoHeight = "";
        public String style = "";
        public ArrayList<WorksheetCell> cells = new ArrayList();

        public WorksheetRow(long i, String h, String ah, String s) {
            this.rowNum = i;
            this.height = h;
            this.autoHeight = ah;
            this.style = s;
        }
    }

    public static class WorksheetCell {
        public final long rowNum;
        public final long colNum;
        public String style;
        public String type;
        public String data;
        public String formula;

        public WorksheetCell(long row, long col, String style, String type, String data, String formula) {
            this.rowNum = row;
            this.colNum = col;
            this.style = style;
            this.type = type;
            this.data = data;
            this.formula = formula;
        }
    }
}

