/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.DeviceTemplateTypeListRenderer;
import com.sigrity.acl.dbui.render.SubstrateTemplateListRenderer;
import com.sigrity.acl.dbui.render.TemplateListRenderer;
import com.sigrity.acl.ui.AComboBox;
import com.sigrity.acl.ui.AComponentTitledBorder;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.SubstrateTemplate;
import com.sigrity.orbit.automation.placement.PlaceableDefinitionUI;
import com.sigrity.orbit.ui.CreateSubstrateUI;
import com.sigrity.orbit.ui.DesignDialog;
import com.sigrity.orbit.ui.DevicePathChooser;
import com.sigrity.orbit.ui.DieExtentsUI;
import com.sigrity.orbit.ui.LefDefUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class TemplateUI
extends DesignDialog {
    protected JPanel mPanel = null;
    protected JButton mButCancel = new JButton("Close");
    protected static final int PINSIZE = 200;
    protected AComboBox<SubstrateTemplate> mCboSubstrate;
    protected JCheckBox mCbScale;
    protected JTextField mTxtScaleFactor;
    protected JTextField mTxtDevName;
    protected JTextField mTxtDevTempltName;
    protected JComboBox<DeviceTemplate> mCboDevTemplt;
    protected JRadioButton mRadioBtnFromTemplate;
    protected JRadioButton mRadioBtnFromNew;
    protected DevicePath mParentDevice;
    protected DeviceTemplate mReferDeviceTemplate;
    protected JComboBox<DeviceTemplate.Type> mCboDeviceType;
    protected JCheckBox mCbSpecifyPinData;
    protected JLabel mCSVLabel;
    protected AFileChooserControl mFcCSV;
    protected PlaceableDefinitionUI mPlcDefUI = null;
    protected JTextField mTxtWidth;
    protected JTextField mTxtHeight;
    protected DieExtentsUI.DieExtentPanel mDieExtentPanel;
    protected final CardLayout mCardLayout = new CardLayout();
    private List<StepForm> mForms = new ArrayList<StepForm>();
    private List<JButton> mProgress = new ArrayList<JButton>();
    private List<String> mStepCmds = new ArrayList<String>();
    private String mCurrentStage = "Substrate";
    private final JPanel mContentPanel = new JPanel();
    private final JLabel mWarningTip = new JLabel();
    private final JPanel mFooterPanel = new JPanel();
    private final JButton mPrevBtn = (JButton)UIUtil.makeFootButton((AbstractButton)new JButton("Prev"));
    private final JButton mNextBtn = (JButton)UIUtil.makeFootButton((AbstractButton)new JButton("Next"));
    private boolean mCreateCheck = false;
    private static final String CMD_SUBSTRATE = "Substrate";
    private static final String CMD_DEVICE = "Device";
    private static final String CMD_PIN = "Pin";
    private static final String CMD_BOUND = "Bound";
    protected DocumentListener mTextBoxChangedListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            TemplateUI.this.pinDataChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TemplateUI.this.pinDataChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TemplateUI.this.pinDataChanged();
        }
    };
    protected ActionListener mSubstrateListener = e -> this.substrateChanged();
    private JButton mParentDevBtn;

    public static void showUI() {
        new TemplateUI(OrbitIO.getMainWindow(), "device");
    }

    public TemplateUI(Component owner, String typeName) {
        super(OrbitIO.getCurDb(), owner);
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        if (typeName.equalsIgnoreCase("device")) {
            this.setTitle("Create Device");
            JPanel contentPane = new JPanel();
            this.initialize(contentPane);
            l.add((Component)contentPane, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        } else assert (false);
        l.newline();
        l.pushFillX();
        Unit unit = this.getUnitDist();
        JLabel unitNote = new JLabel("Unit: " + unit.getUserName());
        l.add((Component)unitNote, (GridBagConstraints)GridBagManager.LEFT.insetTop(0));
        l.addFillX();
        l.add((Component)this.mButCancel, (GridBagConstraints)GridBagManager.RIGHT);
        l.newline();
        l.pop();
        this.pack();
        this.setMinimumSize(new Dimension(400, 500));
        this.setMaximumSize(new Dimension(400, 500));
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mButCancel);
        UIUtil.enforceDialogMinSize((Window)((Object)this));
        UIUtil.center((Component)((Object)this));
        this.setVisible(true);
    }

    public void setParentDevPath(DevicePath devPath) {
        this.mParentDevice = devPath;
        this.refreshParentDevUI();
    }

    private void initialize(JPanel contentPane) {
        contentPane.setLayout(new BorderLayout());
        this.mContentPanel.setLayout(this.mCardLayout);
        this.mForms.add(new SubstrateForm());
        this.mForms.add(new DeviceTemplateForm());
        this.mForms.add(new PinForm());
        this.mForms.add(new BoundForm());
        for (StepForm form : this.mForms) {
            JPanel p = form.getContentPane();
            this.mContentPanel.add((Component)p, form.getCommand());
            JButton nagBtn = new JButton(form.getCommand());
            nagBtn.setName(form.getCommand());
            this.mProgress.add(nagBtn);
            this.mStepCmds.add(form.getCommand());
        }
        this.mCardLayout.show(this.mContentPanel, this.mForms.get(0).getCommand());
        JPanel headerPanel = new JPanel();
        GridBagManager l = new GridBagManager((Container)headerPanel);
        for (int i = 0; i < this.mProgress.size(); ++i) {
            JButton btn = this.mProgress.get(i);
            btn.setOpaque(false);
            btn.setContentAreaFilled(false);
            btn.setBorderPainted(false);
            btn.setMargin(new Insets(0, 0, 0, 0));
            btn.addActionListener(e -> {
                this.mCurrentStage = btn.getName();
                this.mCardLayout.show(this.mContentPanel, btn.getName());
                this.updateNav();
            });
            l.add((Component)btn, (GridBagConstraints)GridBagManager.LEFT);
            if (i != this.mProgress.size() - 1) {
                l.add(">");
                continue;
            }
            l.addFillX();
        }
        this.initFooter();
        contentPane.add((Component)headerPanel, "North");
        contentPane.add((Component)this.mContentPanel, "Center");
        contentPane.add((Component)this.mFooterPanel, "South");
        this.updateNav();
        this.populateSubstrates();
        this.initSwitches();
        this.optionsChanged();
    }

    private void updateNav() {
        HashMap<TextAttribute, Serializable> textAttrMap;
        JButton btn;
        int i;
        int index = this.mStepCmds.indexOf(this.mCurrentStage);
        this.mPrevBtn.setEnabled(index > 0);
        if (this.mForms.get(index).hasNextStep()) {
            this.mNextBtn.setText("Next");
        } else {
            this.mNextBtn.setText("Create");
        }
        for (i = 0; i <= index; ++i) {
            btn = this.mProgress.get(i);
            btn.setEnabled(true);
            btn.setText(this.mForms.get(i).getShortDesc());
            textAttrMap = new HashMap<TextAttribute, Serializable>();
            textAttrMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            textAttrMap.put(TextAttribute.FOREGROUND, Color.BLUE);
            btn.setFont(btn.getFont().deriveFont(textAttrMap));
        }
        for (i = index + 1; i < this.mStepCmds.size(); ++i) {
            btn = this.mProgress.get(i);
            btn.setEnabled(false);
            textAttrMap = new HashMap();
            textAttrMap.put(TextAttribute.FOREGROUND, Color.BLACK);
            btn.setFont(btn.getFont().deriveFont(textAttrMap));
        }
    }

    private void initFooter() {
        GridBagManager l = new GridBagManager((Container)this.mFooterPanel);
        this.mWarningTip.setForeground(Color.RED);
        l.add((Component)this.mWarningTip, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.add((Component)this.mPrevBtn, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mNextBtn, (GridBagConstraints)GridBagManager.RIGHT);
        this.mNextBtn.addActionListener(e -> {
            int index = this.mStepCmds.indexOf(this.mCurrentStage);
            if (this.mForms.get(index).next()) {
                this.mCurrentStage = this.mStepCmds.get(index + 1);
                this.mCardLayout.show(this.mContentPanel, this.mCurrentStage);
                this.updateNav();
            } else if (this.mNextBtn.getText().equals("Create") && this.mCreateCheck) {
                this.createDevice();
            }
        });
        this.mPrevBtn.addActionListener(e -> {
            int index = this.mStepCmds.indexOf(this.mCurrentStage);
            this.mCurrentStage = this.mStepCmds.get(index - 1);
            this.mCardLayout.show(this.mContentPanel, this.mCurrentStage);
            this.updateNav();
        });
    }

    private JPanel createSubstrateCardPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        l.push("Substrate Definition", (GridBagConstraints)GridBagManager.FILLALL);
        l.add((Component)new JLabel("Substrate:"), (GridBagConstraints)GridBagManager.LEFT);
        this.mCboSubstrate = new AComboBox();
        l.add(this.mCboSubstrate, (GridBagConstraints)GridBagManager.FILLX);
        this.mCboSubstrate.addActionListener(this.mSubstrateListener);
        this.mCboSubstrate.setRenderer((ListCellRenderer)new SubstrateTemplateListRenderer());
        JButton importBtn = new JButton();
        importBtn.setAction(new ActionImportSubstrate(importBtn, (Window)((Object)this)));
        UIUtil.makeToolBarButton((AbstractButton)importBtn);
        importBtn.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.IMPORT, (int)16, (int)16));
        l.add((Component)importBtn);
        JButton refresh = new JButton("");
        refresh.addActionListener(e -> this.populateSubstrates());
        UIUtil.makeToolBarButton((AbstractButton)refresh);
        refresh.setIcon(OrbitIcons.REFRESH);
        l.add((Component)refresh);
        l.newline();
        l.indent();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.LEFT);
        this.mCbScale = (JCheckBox)l.add((Component)new JCheckBox("Process Shrink:"));
        this.mCbScale.setToolTipText("Select to scale the substrate");
        this.mTxtScaleFactor = (JTextField)l.add((Component)new JTextField(10));
        this.mTxtScaleFactor.setText("1.0");
        this.mTxtScaleFactor.setEnabled(false);
        this.mTxtScaleFactor.setToolTipText("The scale factor for the substrate (e.g., 0.75 to scale to 75%)");
        this.mCbScale.addActionListener(e -> this.updateScaleControls());
        l.newline();
        l.indent();
        l.add("(1.00 = no shrink, 0.75 = shrink to 0.75)", (GridBagConstraints)GridBagManager.LEFT.width(2));
        l.pop();
        l.newline();
        l.addFillX();
        l.addFillY();
        return panel;
    }

    private JPanel createDeviceCardPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        l.push("Device Definition", (GridBagConstraints)GridBagManager.FILLALL);
        l.add((Component)new JLabel("Parent Device:"), (GridBagConstraints)GridBagManager.LEFT);
        this.mParentDevBtn = new JButton();
        this.mParentDevBtn.setHorizontalAlignment(2);
        this.mParentDevBtn.setOpaque(true);
        this.mParentDevBtn.setForeground(Color.BLUE);
        this.mParentDevBtn.setBackground(Color.WHITE);
        this.mParentDevBtn.setBorder(this.mTxtScaleFactor.getBorder());
        this.mParentDevBtn.addActionListener(e -> {
            this.mParentDevice = DevicePathChooser.Dialog.createDialog((Window)((Object)this), this.mDb);
            this.refreshParentDevUI();
        });
        this.refreshParentDevUI();
        l.add((Component)this.mParentDevBtn, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add("Type", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboDeviceType = new JComboBox();
        this.mCboDeviceType.setRenderer(new DeviceTemplateTypeListRenderer());
        this.updateTypeOptions(DeviceTemplate.Type.UNKNOWN);
        l.add(this.mCboDeviceType, (GridBagConstraints)GridBagManager.FILLX);
        this.mCboDeviceType.addItemListener(e -> {
            if (this.getDeviceTemplateType() == DeviceTemplate.Type.DIE) {
                this.mPlcDefUI.setPlaceableType(PlaceableDefinitionUI.PlaceableType.Device);
            } else {
                this.mPlcDefUI.setPlaceableType(PlaceableDefinitionUI.PlaceableType.Pin);
            }
            this.optionsChanged();
        });
        l.newline();
        JLabel la = new JLabel("Template:");
        this.mRadioBtnFromNew = new JRadioButton("New");
        this.mRadioBtnFromNew.addItemListener(e -> {
            this.mTxtDevTempltName.setEnabled(this.mRadioBtnFromNew.isSelected());
            this.templateSourceChange();
        });
        this.mTxtDevTempltName = new JTextField("MyChip", 20);
        this.mRadioBtnFromTemplate = new JRadioButton("Existing");
        this.mRadioBtnFromTemplate.addItemListener(e -> {
            this.mCboDevTemplt.setEnabled(this.mRadioBtnFromTemplate.isSelected());
            this.templateSourceChange();
        });
        this.mCboDevTemplt = new JComboBox();
        this.mCboDevTemplt.setRenderer(new TemplateListRenderer());
        this.mCboDevTemplt.addItemListener(e -> this.templateSourceChange());
        this.mCboDevTemplt.setPreferredSize(new Dimension(200, 24));
        this.mCboDevTemplt.setMinimumSize(new Dimension(200, 24));
        ButtonGroup templateSourceGroup = new ButtonGroup();
        templateSourceGroup.add(this.mRadioBtnFromNew);
        templateSourceGroup.add(this.mRadioBtnFromTemplate);
        this.mRadioBtnFromNew.setSelected(true);
        l.pushFillX();
        l.add((Component)la, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.add((Component)this.mRadioBtnFromNew, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.indent();
        l.addFillX();
        l.add((Component)this.mRadioBtnFromTemplate, (GridBagConstraints)GridBagManager.LEFT);
        l.pop();
        l.pushFillX();
        l.add((Component)this.mTxtDevTempltName, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add(this.mCboDevTemplt, (GridBagConstraints)GridBagManager.FILLX);
        l.pop();
        l.newline();
        la = new JLabel("Name:");
        l.add((Component)la, (GridBagConstraints)GridBagManager.LEFT);
        this.mTxtDevName = new JTextField("MyChip", 20);
        l.add((Component)this.mTxtDevName, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.addFillX();
        l.addFillY();
        return panel;
    }

    private void refreshParentDevUI() {
        if (this.mParentDevice != null) {
            this.mParentDevBtn.setIcon(DbExplorerPanel.getIconForTemplate(this.mParentDevice.getDeviceTemplate()));
            this.mParentDevBtn.setText(this.mParentDevice.getDevice().getName());
            this.updateTypeOptions(this.mParentDevice.getDeviceTemplate().getType());
        } else {
            this.mParentDevBtn.setIcon(DBEResources.ICON_DESIGN);
            this.mParentDevBtn.setText("<Design>");
        }
        this.mParentDevBtn.repaint();
    }

    private JPanel createPinPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        String pinSectName = "Pins";
        this.mCbSpecifyPinData = new JCheckBox(pinSectName);
        this.mCbSpecifyPinData.addItemListener(e -> this.pinDataChanged());
        JPanel pnlPinData = l.push(pinSectName, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        pnlPinData.setBorder(new AComponentTitledBorder(this.mCbSpecifyPinData, pnlPinData));
        this.mFcCSV = new AFileChooserControl();
        this.mFcCSV.addChoosableFileFilter(AFileFilter.CSV);
        this.mFcCSV.setMultiple(false);
        this.mCSVLabel = l.add("CSV file:");
        this.mCSVLabel.setLabelFor((Component)this.mFcCSV);
        l.addNl((Component)this.mFcCSV, (GridBagConstraints)GridBagManager.FILLX);
        this.mFcCSV.setMinimumSize(this.mFcCSV.getPreferredSize());
        this.mFcCSV.getTextField().getDocument().addDocumentListener(this.mTextBoxChangedListener);
        l.newline();
        if (this.mPlcDefUI == null) {
            this.mPlcDefUI = new PlaceableDefinitionUI(null, true, this.getSubstrate(), this.getDeviceTemplateType());
            l.add((Component)this.mPlcDefUI, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
        }
        l.popNl();
        l.addFillY();
        l.newline();
        JLabel la = new JLabel("Note: CSV data is expected to be in microns.");
        l.add((Component)la, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        return panel;
    }

    private JPanel createBoundPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        JPanel pnlBounds = l.push("Specify Bounds", (GridBagConstraints)GridBagManager.FILLALL);
        this.mTxtWidth = new JTextField("0", 20);
        this.mTxtWidth.setToolTipText("If set 0, compute bound automatically");
        this.mTxtHeight = new JTextField("0", 20);
        this.mTxtHeight.setToolTipText("If set 0, compute bound automatically");
        l.add((Component)new JLabel("Width:"));
        l.add((Component)this.mTxtWidth, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.newline();
        l.add((Component)new JLabel("Height:"));
        l.add((Component)this.mTxtHeight, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.newline();
        l.addFillX();
        l.newline();
        l.addFillY();
        l.pop();
        this.mDieExtentPanel = new DieExtentsUI.DieExtentPanel((DeviceTemplate)Design.getDesign((Db)OrbitIO.getCurDb()));
        this.mDieExtentPanel.setContentsEnabled(false);
        this.mDieExtentPanel.setVisible(this.getDeviceTemplateType() == DeviceTemplate.Type.DIE);
        l.add((Component)this.mDieExtentPanel, (GridBagConstraints)GridBagManager.FILLALL);
        pnlBounds.setMinimumSize(pnlBounds.getPreferredSize());
        return panel;
    }

    private void updateTypeOptions(DeviceTemplate.Type parentType) {
        List<Object> types;
        DeviceTemplate.Type subType;
        Substrate useSubstrate = this.getSubstrate();
        DeviceTemplate.Type type = subType = useSubstrate == null ? null : (DeviceTemplate.Type)useSubstrate.getInferredType(true).orElse(null);
        if (subType == null) {
            types = AUtil.arrayList((Object[])new DeviceTemplate.Type[]{DeviceTemplate.Type.DIE, DeviceTemplate.Type.PACKAGE, DeviceTemplate.Type.COVER, DeviceTemplate.Type.PACKAGEDDIE, DeviceTemplate.Type.CORE, DeviceTemplate.Type.BOARD, DeviceTemplate.Type.INTERPOSER, DeviceTemplate.Type.PAD, DeviceTemplate.Type.BUMP, DeviceTemplate.Type.GROUP});
        } else {
            types = new ArrayList();
            for (DeviceTemplate.Type t2 : DeviceTemplate.Type.values()) {
                if (t2.getUserName() == null || !DeviceTemplate.Type.isValid((DeviceTemplate.Type)subType, (DeviceTemplate.Type)t2) && subType != t2) continue;
                types.add(t2);
            }
        }
        types = types.stream().filter(t -> DeviceTemplate.Type.isValid((DeviceTemplate.Type)parentType, (DeviceTemplate.Type)t)).collect(Collectors.toList());
        Collections.sort(types, DeviceTemplate.Type.ComparePriority);
        this.mCboDeviceType.setModel(new DefaultComboBoxModel<DeviceTemplate.Type>(types.toArray(new DeviceTemplate.Type[types.size()])));
    }

    private void setCreateCheck(boolean ok) {
        this.mCreateCheck = ok;
    }

    private boolean isValidConfig() {
        try {
            Design parent;
            if (this.mCbScale.isEnabled()) {
                AFieldValidator.validateDouble((JTextField)this.mTxtScaleFactor);
            }
            if (this.mCbSpecifyPinData.isSelected()) {
                this.mPlcDefUI.validateSettings();
            }
            AFieldValidator.validateDouble((JTextField)this.mTxtWidth);
            AFieldValidator.validateDouble((JTextField)this.mTxtHeight);
            if (this.mRadioBtnFromTemplate.isSelected() && this.mCboDevTemplt.getSelectedItem() == null) {
                return false;
            }
            String childDeviceName = this.mTxtDevName.getText();
            Object object = parent = this.mParentDevice == null ? Design.getDesign((Db)this.mDb) : this.mParentDevice.getDeviceTemplate();
            if (parent.getChild(childDeviceName) != null) {
                return false;
            }
        }
        catch (AFieldValidator.AFieldValidationException e) {
            return false;
        }
        return this.getDeviceTemplateType() != DeviceTemplate.Type.DIE || this.mDieExtentPanel.validateFields();
    }

    private void executeCommand() {
        Unit unit = this.getUnitDist();
        if (this.mRadioBtnFromTemplate.isSelected()) {
            Cp.exec((String)"Device.create(\"%s\", %s, %s)", (Object[])new Object[]{this.mTxtDevName.getText(), CpHelper.getObjCmdStr((DeviceTemplate)this.mCboDevTemplt.getSelectedItem()), CpHelper.getObjCmdStr(this.mParentDevice == null ? Design.getDesign((Db)this.mDb) : this.mParentDevice.getDeviceTemplate())});
            return;
        }
        DeviceTemplate.Type t = this.getDeviceTemplateType();
        Cp.exec((String)"unset(\"_deviceFactory\")", (Object[])new Object[0]);
        Cp.exec((String)"_deviceFactory = com.sigrity.orbit.factory.DeviceFactory.create(curDb())", (Object[])new Object[0]);
        Cp.exec((String)"_deviceFactory.setInstantiateAsDevices(%b)", (Object[])new Object[]{this.mPlcDefUI.getPlaceableType() == PlaceableDefinitionUI.PlaceableType.Device});
        Cp.exec((String)"_deviceFactory.setSubstrateName(\"%s\")", (Object[])new Object[]{this.getSubstrate().getName()});
        if (this.mCbSpecifyPinData.isSelected()) {
            String pinFilePath = this.mFcCSV.getPath();
            if (pinFilePath != null) {
                Cp.exec((String)"_deviceFactory.setPinFile(%s)", (Object[])new Object[]{Cp.getFileAsArgument((String)pinFilePath)});
            }
            if (this.mPlcDefUI.fromTemplate()) {
                Cp.exec((String)"_deviceFactory.setPinFromTemplateName(\"%s\")", (Object[])new Object[]{this.mPlcDefUI.getTemplateName()});
                Cp.exec((String)"_deviceFactory.setPinParamDevTName(null)", (Object[])new Object[0]);
                Cp.exec((String)"_deviceFactory.setPinParamPadTName(null)", (Object[])new Object[0]);
            } else {
                float rot;
                Cp.exec((String)"_deviceFactory.setPinFromTemplateName(null)", (Object[])new Object[0]);
                Cp.exec((String)"_deviceFactory.setPinParamPadTName(\"%s\")", (Object[])new Object[]{this.mPlcDefUI.getPinPadTemplateName()});
                Cp.exec((String)"_deviceFactory.setPinParamDevTName(\"%s\")", (Object[])new Object[]{this.mPlcDefUI.getPinDeviceTemplateName()});
                String pinLayerName = this.mPlcDefUI.getLayerName();
                if (pinLayerName != null) {
                    Cp.exec((String)"_deviceFactory.setLayerName(%s)", (Object[])new Object[]{pinLayerName});
                }
                Cp.exec((String)"_deviceFactory.setPinSize(%s)", (Object[])new Object[]{this.mPlcDefUI.getSizeStr(unit)});
                if (this.mPlcDefUI.getPadShapeStyle() == PadTemplate.PadShapeStyle.Rect || this.mPlcDefUI.getPadShapeStyle() == PadTemplate.PadShapeStyle.Oblong) {
                    Cp.exec((String)"_deviceFactory.setPinSizeB(%s)", (Object[])new Object[]{this.mPlcDefUI.getSize2Str(unit)});
                }
                if ((double)(rot = (float)this.mPlcDefUI.getRotation()) != 0.0) {
                    Cp.exec((String)"_deviceFactory.setPinRotation((float) %f)", (Object[])new Object[]{Float.valueOf(rot)});
                }
                Cp.exec((String)"_deviceFactory.setPadShape(PadTemplate.PadShapeStyle.%s)", (Object[])new Object[]{this.mPlcDefUI.getShapeName()});
            }
        }
        Cp.exec((String)"_deviceFactory.setWidth(%dL)", (Object[])new Object[]{unit.fromUserString(this.mTxtWidth.getText())});
        Cp.exec((String)"_deviceFactory.setHeight(%dL)", (Object[])new Object[]{unit.fromUserString(this.mTxtHeight.getText())});
        if (this.mParentDevice != null) {
            Cp.exec((String)"_deviceFactory.setParentDevice(\"%s\")", (Object[])new Object[]{this.mParentDevice.getDevice().getTemplate().getKeyStr()});
        }
        Device device = (Device)Cp.exec((String)"_deviceFactory.createDevice(\"%s\", \"%s\", %s)", (Object[])new Object[]{this.mTxtDevTempltName.getText(), this.mTxtDevName.getText(), "DeviceTemplate.Type." + t.name()});
        if (this.mPlcDefUI.getPlaceableType() != PlaceableDefinitionUI.PlaceableType.Device) {
            Cp.exec((String)"_deviceFactory.setInstantiateAsDevices(false)", (Object[])new Object[0]);
        }
        Cp.exec((String)"unset(\"_deviceFactory\")", (Object[])new Object[0]);
        if (device == null) {
            ALog.logError((String)"Device not created");
            return;
        }
        this.mDieExtentPanel.setDeviceTemplate(device.getTemplate());
        this.mDieExtentPanel.apply();
        Object msg = String.format("Device '%s' created.", device.getName());
        if (this.mTxtScaleFactor.isEnabled()) {
            double scaleFactor = AFieldValidator.getDouble((JTextField)this.mTxtScaleFactor, (double)1.0);
            if (scaleFactor != 1.0) {
                Cp.exec((String)"Substrate.getSubstrate(curDb(), \"%s\").scaleDependents(%f)", (Object[])new Object[]{device.getSubstrate().getName(), scaleFactor});
                msg = (String)msg + String.format(" Shrink amount: %f", scaleFactor);
            }
        } else {
            double existingScale;
            Substrate substrate = device.getSubstrate();
            double d = existingScale = substrate == null ? Double.NaN : substrate.getScale();
            if (!Double.isNaN(existingScale) && existingScale != 1.0) {
                Cp.exec((String)"DeviceTemplate.get(curDb(), \"%s\", \"%s\").transform(java.awt.geom.AffineTransform.getScaleInstance(%f, %f))", (Object[])new Object[]{device.getSubstrate().getName(), device.getTemplate().getName(), existingScale, existingScale});
                Cp.exec((String)"DeviceTemplate.get(curDb(), \"%s\", \"%s\").transformLayerShapes(java.awt.geom.AffineTransform.getScaleInstance(%f, %f))", (Object[])new Object[]{device.getSubstrate().getName(), device.getTemplate().getName(), existingScale, existingScale});
                msg = (String)msg + String.format(" Scaled per existing substrate shrink amount: %f", existingScale);
            }
        }
        ALog.logInfo((String)msg);
    }

    private void createDevice() {
        this.doCommand();
        OrbitIO o = (OrbitIO)AApp.getApp();
        Db db = o.getCurrentDb();
        Design currentDesign = Design.getDesign((Db)db);
        currentDesign.binAllDevices();
        o.zoomFitCurrentView();
    }

    private void doCommand() {
        if (!this.isValidConfig()) {
            return;
        }
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Create Device");){
            this.executeCommand();
            this.mCbSpecifyPinData.setSelected(false);
        }
    }

    private DeviceTemplate.Type getDeviceTemplateType() {
        DeviceTemplate.Type o = (DeviceTemplate.Type)this.mCboDeviceType.getSelectedItem();
        if (o == null) {
            return DeviceTemplate.Type.UNKNOWN;
        }
        return o;
    }

    protected void initSwitches() {
        this.mCboSubstrate.setSelectedItem(null);
        this.mCbSpecifyPinData.setSelected(false);
        this.pinDataChanged();
    }

    protected void optionsChanged() {
        if (this.mCboSubstrate.getSelectedItem() == null) {
            this.mPlcDefUI.setByParametric(true);
            this.mPlcDefUI.updateLayerList(this.getSubstrate(), this.getDeviceTemplateType());
        }
        if (this.mPlcDefUI != null) {
            this.mPlcDefUI.updateTemplates(this.getSubstrate(), this.getDeviceTemplateType());
        }
        this.updateScaleControls();
        this.updateDevTemplt();
        this.pinDataChanged();
        this.updateDieExtent();
        this.updateNav();
        this.revalidate();
        this.pack();
    }

    protected void pinDataChanged() {
        if (this.mCbSpecifyPinData.isSelected()) {
            this.mCSVLabel.setEnabled(true);
            this.mFcCSV.setEnabled(true);
            UIUtil.setEnabled((Container)this.mPlcDefUI, (boolean)true);
        } else {
            this.setCreateCheck(true);
            this.mCSVLabel.setEnabled(false);
            this.mFcCSV.setEnabled(false);
            UIUtil.setEnabled((Container)this.mPlcDefUI, (boolean)false);
        }
        this.mCSVLabel.setVisible(true);
        this.mFcCSV.setVisible(true);
        this.repaint();
    }

    protected void templateSourceChange() {
        if (this.mRadioBtnFromNew.isSelected()) {
            this.setCreateCheck(true);
            return;
        }
        this.setCreateCheck(this.mCboDevTemplt.getSelectedItem() != null);
        this.updateNav();
    }

    private void updateDevTemplt() {
        DeviceTemplate.Type type = this.getDeviceTemplateType();
        Substrate sub = this.getSubstrate();
        if (sub != null) {
            ArrayList<DeviceTemplate> devices = new ArrayList<DeviceTemplate>();
            for (DeviceTemplate dt : sub.getDeviceTemplates()) {
                if (dt.getType() != type) continue;
                devices.add(dt);
            }
            Collections.sort(devices, (a, b) -> AAlphaNumComp.get().compare((Object)a.getName(), (Object)b.getName()));
            this.mCboDevTemplt.setModel(new DefaultComboBoxModel<DeviceTemplate>(devices.toArray(new DeviceTemplate[devices.size()])));
        } else {
            this.mCboDevTemplt.setModel(new DefaultComboBoxModel());
        }
    }

    protected void updateDieExtent() {
        boolean visible = DeviceTemplate.Type.DIE == this.getDeviceTemplateType();
        this.mDieExtentPanel.setVisible(visible);
        this.mDieExtentPanel.setEnabled(visible);
    }

    protected void updateScaleControls() {
        SubstrateTemplate st = (SubstrateTemplate)((Object)this.mCboSubstrate.getSelectedItem());
        boolean scaleEnabled = st == null || this.mCboSubstrate.getSelectedItem() == null || st.first == null || ((Substrate)st.first).getDeviceTemplateCount() == 0;
        this.mCbScale.setEnabled(scaleEnabled);
        this.mTxtScaleFactor.setEnabled(scaleEnabled && this.mCbScale.isSelected());
        if (st != null) {
            Substrate substrate = (Substrate)st.first;
            if (!Double.isNaN(substrate.getScale())) {
                this.mTxtScaleFactor.setText("" + substrate.getScale());
            } else {
                this.mTxtScaleFactor.setText("1.0");
            }
        }
    }

    protected Substrate getSubstrate() {
        SubstrateTemplate subTemp = (SubstrateTemplate)((Object)this.mCboSubstrate.getSelectedItem());
        if (subTemp != null) {
            return (Substrate)subTemp.first;
        }
        return null;
    }

    protected void substrateChanged() {
        if (this.mPlcDefUI != null) {
            this.mPlcDefUI.updateLayerList(this.getSubstrate(), this.getDeviceTemplateType());
            this.mPlcDefUI.updateTemplates(this.getSubstrate(), this.getDeviceTemplateType());
        }
        this.updateScaleControls();
        this.updateTypeOptions(this.mParentDevice == null ? null : this.mParentDevice.getDeviceTemplate().getType());
    }

    protected void populateSubstrates() {
        this.mCboSubstrate.removeAllItems();
        LinkedList<SubstrateTemplate> list = SubstrateTemplate.getSubstrateInstances(OrbitIO.getCurDb(), true, false, null);
        if (list.isEmpty()) {
            this.mCboSubstrate.addItem(null);
        }
        for (SubstrateTemplate st : list) {
            if (this.mPlcDefUI != null && this.mPlcDefUI.getTempSubstrate() == st.first) continue;
            this.mCboSubstrate.addItem((Object)st);
        }
        this.optionsChanged();
    }

    private class ActionImportSubstrate
    extends AbstractAction {
        private final AbstractButton mOri;
        private final Window mWindow;

        public ActionImportSubstrate(AbstractButton button, Window window) {
            super("");
            this.mOri = button;
            this.mWindow = window;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu menu = new JPopupMenu();
            OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
            AbstractAction newSub = new AbstractAction("New..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateSubstrateUI.showMe(OrbitIO.getCurDb(), ActionImportSubstrate.this.mWindow);
                    TemplateUI.this.populateSubstrates();
                }
            };
            AbstractAction fromLEF = new AbstractAction("From LEF"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LefDefUI.showDialog(ActionImportSubstrate.this.mWindow);
                    TemplateUI.this.populateSubstrates();
                }
            };
            fromLEF.putValue("ShortDescription", AFileFilter.LEF.getDescription());
            AbstractAction fromCSV = new AbstractAction("From Layer CSV"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AFileChooser fc = new AFileChooser();
                    AFileFilter filter = AFileFilter.CSV;
                    fc.setFileFilter((FileFilter)filter);
                    fc.setDialogTitle("Import Layer CSV...");
                    if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                        return;
                    }
                    File f = fc.getSelectedFile();
                    String path = f.getPath();
                    if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                        path = String.format("%s.csv", path);
                    }
                    Cp.exec((String)"com.cadence.orbit.pi.csvio.LayerCsvImport.importCsv(curDb(), %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
                    TemplateUI.this.populateSubstrates();
                }
            };
            menu.add(newSub);
            menu.add(fromLEF);
            menu.add(fromCSV);
            ws.beautify(menu);
            menu.show(this.mOri, 0, this.mOri.getHeight());
        }
    }

    class BoundForm
    implements StepForm {
        BoundForm() {
        }

        @Override
        public String getCommand() {
            return TemplateUI.CMD_BOUND;
        }

        @Override
        public JPanel getContentPane() {
            return TemplateUI.this.createBoundPanel();
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public boolean hasNextStep() {
            return false;
        }

        @Override
        public String getShortDesc() {
            return TemplateUI.CMD_BOUND;
        }
    }

    class PinForm
    implements StepForm {
        PinForm() {
        }

        @Override
        public String getCommand() {
            return TemplateUI.CMD_PIN;
        }

        @Override
        public JPanel getContentPane() {
            return TemplateUI.this.createPinPanel();
        }

        @Override
        public boolean next() {
            return true;
        }

        @Override
        public boolean hasNextStep() {
            return true;
        }

        @Override
        public String getShortDesc() {
            return TemplateUI.CMD_PIN;
        }
    }

    class DeviceTemplateForm
    implements StepForm {
        DeviceTemplateForm() {
        }

        @Override
        public String getCommand() {
            return TemplateUI.CMD_DEVICE;
        }

        @Override
        public JPanel getContentPane() {
            return TemplateUI.this.createDeviceCardPanel();
        }

        @Override
        public boolean next() {
            Design parent;
            String childDeviceName = TemplateUI.this.mTxtDevName.getText();
            Object object = parent = TemplateUI.this.mParentDevice == null ? Design.getDesign((Db)TemplateUI.this.mDb) : TemplateUI.this.mParentDevice.getDeviceTemplate();
            if (parent.getChild(childDeviceName) != null) {
                TemplateUI.this.mWarningTip.setVisible(true);
                TemplateUI.this.mWarningTip.setText(String.format("Please check device name '%s'", childDeviceName));
                childDeviceName = Device.getUniqueName((DeviceTemplate)parent, (String)childDeviceName);
                TemplateUI.this.mTxtDevName.setText(childDeviceName);
                return false;
            }
            if (TemplateUI.this.mRadioBtnFromTemplate.isSelected()) {
                return false;
            }
            String templtName = TemplateUI.this.mTxtDevTempltName.getText();
            Substrate sub = TemplateUI.this.getSubstrate();
            if (sub == null || DeviceTemplate.getDeviceTemplate((Substrate)sub, (String)templtName) != null) {
                TemplateUI.this.mWarningTip.setVisible(true);
                TemplateUI.this.mWarningTip.setText(String.format("Please check template name '%s'", templtName));
                templtName = DeviceTemplate.getUniqueName((Substrate)sub, (String)templtName);
                TemplateUI.this.mTxtDevTempltName.setText(templtName);
                return false;
            }
            TemplateUI.this.mWarningTip.setVisible(false);
            return true;
        }

        @Override
        public boolean hasNextStep() {
            return !TemplateUI.this.mRadioBtnFromTemplate.isSelected();
        }

        @Override
        public String getShortDesc() {
            return String.format("%s (%s)", TemplateUI.CMD_DEVICE, TemplateUI.this.getDeviceTemplateType());
        }
    }

    class SubstrateForm
    implements StepForm {
        SubstrateForm() {
        }

        @Override
        public String getCommand() {
            return TemplateUI.CMD_SUBSTRATE;
        }

        @Override
        public JPanel getContentPane() {
            return TemplateUI.this.createSubstrateCardPanel();
        }

        @Override
        public boolean next() {
            if (TemplateUI.this.getSubstrate() == null) {
                TemplateUI.this.mWarningTip.setVisible(true);
                TemplateUI.this.mWarningTip.setText("Please create substrate first");
                return false;
            }
            TemplateUI.this.mWarningTip.setVisible(false);
            return true;
        }

        @Override
        public boolean hasNextStep() {
            return true;
        }

        @Override
        public String getShortDesc() {
            if (TemplateUI.this.getSubstrate() == null) {
                return TemplateUI.CMD_SUBSTRATE;
            }
            Object name = TemplateUI.this.getSubstrate().getName();
            if (((String)name).length() > 16) {
                name = ((String)name).substring(0, 16) + "...";
            }
            return String.format("Substrate (%s)", name);
        }
    }

    static interface StepForm {
        public String getCommand();

        public boolean next();

        public boolean hasNextStep();

        public JPanel getContentPane();

        public String getShortDesc();
    }
}

