/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Text;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class TextUI {
    public static final String DESIGN = "<Design>";
    public static final String TEXTUI_NO_LAYER_MSG = "No valid Artwork layer found. Create an Artwork layer on the device substrate to display the Text object.";

    protected TextUI() {
    }

    public static TextDlg createDlg(Window owner, Db db, DevicePath devPath) {
        return new TextDlg(owner, db, devPath);
    }

    public static class ActionTextDevice
    extends AbstractAction {
        protected final DevicePath mDevicePath;

        public ActionTextDevice(DevicePath path, String str) {
            super(str == null ? "Text..." : str);
            this.mDevicePath = path;
            this.setEnabled(this.mDevicePath != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextUI.createDlg(OrbitIO.getMainWindow(), OrbitApp.getCurDb(), this.mDevicePath);
        }
    }

    public static class EditTextDlg
    extends DbDialog {
        protected DevicePath mDevPath;
        protected Device mDev;
        protected Text mText;
        protected long mPrevWidth;
        protected long mPrevHeight;
        protected int mNewLayerOrder = -1;
        protected boolean mSavedData = false;
        protected JTextArea mTxtDesc;
        protected JComboBox<Layer> mCboLayer;
        protected JComboBox<String> mCboFont;
        protected JButton mBtnColor;
        protected JButton mBtnOk;
        protected JButton mBtnCancel;
        protected JCheckBox mChkBold;
        protected JCheckBox mChkItalic;
        protected JCheckBox mChkMirror;
        protected JCheckBox mChkDevRot;
        protected JLabel mTxtRotLabel;
        protected JTextField mTxtRot;
        protected JTextField mTxtX;
        protected JTextField mTxtY;
        protected JSpinner mSpinSize;
        protected JRadioButton mRadFit;
        protected JRadioButton mRadCursor;
        protected JRadioButton mRadManual;

        public static EditTextDlg create(Component owner, DevicePath devPath, Text text) {
            if (devPath == null || devPath.getDevice() == null) {
                String msg = "A path to a Device instance must be provided.";
                ALog.logError((Throwable)new IllegalArgumentException(msg), (String)msg, (Object[])new Object[0]);
                return null;
            }
            return new EditTextDlg(owner, devPath, text);
        }

        protected EditTextDlg(Component owner, DevicePath devPath, Text text) {
            super(devPath.getLast().getDb(), owner);
            this.mDevPath = devPath;
            this.mDev = devPath.getLast();
            this.mText = text;
            ARect lastBnds = text == null ? null : text.getLastBoundsDisplayed();
            this.mPrevWidth = lastBnds == null ? 0L : lastBnds.width();
            this.mPrevHeight = lastBnds == null ? 0L : lastBnds.height();
            this.setTitle("Text for device " + this.mDev.getName());
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            l.push("Text", (GridBagConstraints)GridBagManager.LEFT);
            l.add("Text:");
            this.mTxtDesc = (JTextArea)l.add((Component)new JTextArea(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            LayerRenderer layerRenderer = new LayerRenderer();
            l.add("Layer:");
            this.mCboLayer = (JComboBox)l.add(new JComboBox());
            this.mCboLayer.setRenderer(layerRenderer);
            this.updateLayerCombo(this.mDev.getSubstrate(), this.mCboLayer);
            l.newline();
            GraphicsEnvironment graphEnviron = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] allFonts = graphEnviron.getAvailableFontFamilyNames();
            FontRenderer fontRenderer = new FontRenderer();
            l.add("Font:");
            this.mCboFont = (JComboBox)l.add(new JComboBox<String>(allFonts));
            this.mCboFont.setRenderer(fontRenderer);
            this.mBtnColor = (JButton)l.add((Component)new JButton());
            this.mBtnColor.setPreferredSize(new Dimension(25, 25));
            this.mBtnColor.setBackground(Color.blue);
            this.mBtnColor.setToolTipText("Edit the text color");
            this.mBtnColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)this), "Select Color", Color.red);
                    ccd.setShowOpacity(true);
                    Color c = ccd.doModal();
                    mBtnColor.setBackground(c);
                }
            });
            this.mChkBold = (JCheckBox)l.add((Component)new JCheckBox("<html><b>Bold"));
            this.mChkBold.setToolTipText("Set text to Bold");
            this.mChkItalic = (JCheckBox)l.addNl((Component)new JCheckBox("<html><i>Italics"));
            this.mChkItalic.setToolTipText("Set text to <html><i>Italics");
            l.pop();
            l.newline();
            l.pushFill("Placement");
            this.mChkDevRot = (JCheckBox)l.add((Component)new JCheckBox("Use device rotation"));
            this.mChkDevRot.setToolTipText("Set text rotation to device rotation");
            this.mChkDevRot.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    mTxtRotLabel.setVisible(!mChkDevRot.isSelected());
                    mTxtRot.setVisible(!mChkDevRot.isSelected());
                    mTxtRot.setEditable(!mChkDevRot.isSelected());
                }
            });
            this.mTxtRotLabel = new JLabel("Rotation:");
            l.add((Component)this.mTxtRotLabel);
            this.mTxtRot = (JTextField)l.addNl((Component)new JTextField(10));
            this.mTxtRot.setToolTipText("Rotate text clockwise in degrees (absolute rotation).");
            this.mRadFit = (JRadioButton)l.addNl((Component)new JRadioButton("Fit device bounds"));
            this.mRadFit.setToolTipText("Fit the text in device center");
            this.mRadFit.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.manageRadios();
                }
            });
            this.mRadCursor = (JRadioButton)l.add((Component)new JRadioButton("Place with cursor"));
            this.mRadCursor.setToolTipText("Place the text using the cursor");
            l.add("Text size");
            SpinnerNumberModel sm = new SpinnerNumberModel(30, 0, 100, 1);
            this.mSpinSize = new JSpinner(sm);
            this.mSpinSize.setToolTipText("Set the size of the text");
            l.addNl((Component)this.mSpinSize);
            this.mRadManual = (JRadioButton)l.add((Component)new JRadioButton("Offset from device origin"));
            this.mRadManual.setToolTipText("Place the text using offset coordinates");
            this.mRadManual.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.manageRadios();
                }
            });
            UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mRadFit, this.mRadCursor, this.mRadManual});
            l.add("X:");
            this.mTxtX = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtX.setToolTipText("Offset in x-direction from device origin");
            this.mTxtX.setEditable(false);
            l.add("Y:");
            this.mTxtY = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtY.setToolTipText("Offset in y-direction from device origin");
            this.mTxtY.setEditable(false);
            l.pop();
            this.mChkDevRot.setSelected(true);
            l.addFillY();
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOk = (JButton)l.add((Component)new JButton("OK"));
            this.mBtnOk.setEnabled(true);
            if (this.mCboLayer.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(null, TextUI.TEXTUI_NO_LAYER_MSG);
                this.mBtnOk.setEnabled(false);
            }
            this.mBtnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            this.mBtnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int placeType;
                    if (!this.validateData()) {
                        return;
                    }
                    String desc = mTxtDesc.getText();
                    Layer layer = (Layer)mCboLayer.getSelectedItem();
                    if (layer == null) {
                        ALog.logInfo((String)TextUI.TEXTUI_NO_LAYER_MSG);
                        return;
                    }
                    boolean mirror = false;
                    String font = (String)mCboFont.getSelectedItem();
                    Color col = mBtnColor.getBackground();
                    boolean bold = mChkBold.isSelected();
                    boolean ita = mChkItalic.isSelected();
                    int size = (Integer)mSpinSize.getValue();
                    long offsetX = Long.parseLong(mTxtX.getText());
                    long offsetY = Long.parseLong(mTxtY.getText());
                    float rot = Float.parseFloat(mTxtRot.getText()) - mDevPath.getRot();
                    int n = mRadFit.isSelected() ? 0 : (placeType = mRadCursor.isSelected() ? 1 : 2);
                    if (mText != null) {
                        Cp.exec((String)"%s.deleteFromDb();", (Object[])new Object[]{CpHelper.getObjCmdStr(mText)});
                    }
                    mText = (Text)Cp.exec((String)"Text.create(curDb(), \"Device\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", %d, %b, %b, %b, %f, %dL, %dL, %d, %d);", (Object[])new Object[]{mDev.getKeyStr(), layer.getSubstrate().getKeyStr(), layer.getName(), desc, font, col.getRGB(), bold, ita, mirror, mChkDevRot.isSelected() ? 0.0 : (double)rot, offsetX, offsetY, size, placeType});
                    if (mPrevWidth != 0L || mPrevHeight != 0L) {
                        mText.setLastBoundsDisplayed(mPrevWidth, mPrevHeight);
                    }
                    mSavedData = true;
                    UIUtil.closeWindow((Window)((Object)this));
                    if (mRadCursor.isSelected()) {
                        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.DoText.Start()", (Object[])new Object[0]);
                        APoint2D startLoc = ((DesignView2D)OrbitIO.getCurView()).getCanvas().getWorldPt(AbstractViewMode.getLastInspectedPoint());
                        String locStr = String.format("%dL, %dL,", startLoc.getX(), startLoc.getY());
                        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.moveObjectInteractively(%s \"%s\",\"%s\", false, false)", (Object[])new Object[]{locStr, mDevPath, mText.getKeyStr()});
                    }
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            });
            if (this.mText != null) {
                this.mTxtDesc.setText(Text.removeHtml((String)this.mText.getText()));
                this.mCboLayer.setSelectedItem(this.mText.getLayer());
                this.mChkBold.setSelected(Text.isBold((Text)this.mText));
                this.mChkItalic.setSelected(Text.isItalic((Text)this.mText));
                this.mBtnColor.setBackground(Text.getColor((Text)this.mText));
                this.mCboFont.setSelectedItem(Text.getFontFace((Text)this.mText));
                this.mTxtX.setText(String.valueOf(this.mText.getLoc().getX()));
                this.mTxtY.setText(String.valueOf(this.mText.getLoc().getY()));
                this.mSpinSize.setValue(Text.getSize((Text)this.mText));
                if (this.mText.getPlaceType() == Text.PlacementType.FitToSize) {
                    this.mRadFit.setSelected(true);
                } else {
                    this.mRadManual.setSelected(true);
                }
                float textRot = this.mText.getRotate();
                this.mTxtRot.setText(Float.toString(textRot + this.mDevPath.getRot()));
                this.mChkDevRot.setSelected(0.0f == textRot);
            } else {
                this.mTxtRot.setText("0.0");
                this.mTxtX.setText("0");
                this.mTxtY.setText("0");
                this.mRadFit.setSelected(true);
            }
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
        }

        public boolean doModal() {
            this.setModal(true);
            this.setVisible(true);
            return this.mSavedData;
        }

        protected void manageRadios() {
            this.mTxtX.setEditable(this.mRadManual.isSelected());
            this.mTxtY.setEditable(this.mRadManual.isSelected());
            this.mSpinSize.setEnabled(!this.mRadFit.isSelected());
        }

        public Text getText() {
            return this.mText;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean validateData() {
            try {
                AFieldValidator.validateText((JTextComponent)this.mTxtDesc);
                AFieldValidator.validateText((JTextComponent)this.mTxtRot);
                AFieldValidator.validateText((JTextComponent)this.mTxtX);
                AFieldValidator.validateText((JTextComponent)this.mTxtY);
                String newDesc = this.mTxtDesc.getText();
                if (this.mText != null && newDesc.equals(this.mText.getText())) return true;
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return false;
            }
            return true;
        }

        protected void updateLayerCombo(Substrate s, JComboBox<Layer> box) {
            ArrayList<Layer> sortedLayers = new ArrayList<Layer>();
            for (Layer l : s.getLayers()) {
                sortedLayers.add(l);
            }
            if (!sortedLayers.isEmpty()) {
                Collections.sort(sortedLayers);
                Collections.reverse(sortedLayers);
                for (Layer l : sortedLayers) {
                    box.addItem(l);
                }
            }
        }

        class FontRenderer
        extends DefaultListCellRenderer {
            FontRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        }

        class LayerRenderer
        extends DefaultListCellRenderer {
            LayerRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                if (value instanceof Layer) {
                    APatternColor color;
                    Layer l = (Layer)value;
                    this.setText(l.getName());
                    ViewColorizer colorizer = OrbitIO.getCurColorizer();
                    DevicePath path = l.getSubstrate().getADevicePathUsing();
                    APatternColor aPatternColor = color = path == null ? null : colorizer.getColor(path, l, true);
                    if (color != null) {
                        this.setIcon((Icon)new AColorIcon(16, 16, color.getColor()));
                    }
                }
                if (value == null) {
                    this.setText("No Layer");
                }
                return c;
            }
        }
    }

    protected static class TextListModel
    extends AbstractListModel<Text> {
        protected ArrayList<Text> mTexts = new ArrayList();

        protected TextListModel() {
        }

        @Override
        public int getSize() {
            return this.mTexts.size();
        }

        @Override
        public Text getElementAt(int index) {
            return this.mTexts.get(index);
        }

        public void clear() {
            int size = this.mTexts.size();
            if (size == 0) {
                return;
            }
            this.mTexts.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }

        public void addText(Text t) {
            int index = this.mTexts.size();
            this.mTexts.add(t);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public static class TextListCellRenderer
    extends JLabel
    implements ListCellRenderer<Text> {
        @Override
        public Component getListCellRendererComponent(JList<? extends Text> list, Text value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (!(value instanceof Text)) {
                this.setText((String)(value == null ? "" : "" + value));
                return this;
            }
            Text text = value;
            Font newFont = Text.getFont((Text)text);
            this.setFont(newFont);
            Color color = Text.getColor((Text)text);
            this.setForeground(color);
            this.setOpaque(true);
            this.setText(Text.removeHtml((String)text.getText()));
            return this;
        }
    }

    public static class TextDlg
    extends DbDialog {
        protected Device mDev;
        protected DevicePath mDevPath;
        protected JList<Text> mTextList = new JList();
        protected TextListModel mTexts = new TextListModel();
        protected JButton mBtnAdd;
        protected JButton mBtnEdit;
        protected JButton mBtnDelete;

        public TextDlg(Window owner, Db db, DevicePath devPath) {
            super(db, (Component)owner);
            this.mDevPath = devPath;
            this.mDev = devPath.getLast();
            this.setTitle("Text for " + this.mDev.getName());
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.newline();
            l.addNl("Text:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            this.mTextList = new JList<Text>(this.mTexts);
            JScrollPane spLayers = new JScrollPane(this.mTextList);
            l.add((Component)spLayers, (GridBagConstraints)GridBagManager.FILLALL);
            this.mTextList.setCellRenderer(new TextListCellRenderer());
            this.mTextList.setSelectionMode(0);
            this.mTextList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.enableButtons();
                }
            });
            this.mTextList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        mBtnEdit.doClick();
                    }
                }
            });
            l.newline();
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            GridBagManager.GridBagConstraintsEx btnCs = GridBagManager.LEFT.insetTop(0).insetBottom(12);
            l.addFillX();
            this.mBtnAdd = new JButton("Add...");
            this.mBtnAdd.setMargin(new Insets(1, 0, 1, 0));
            this.mBtnAdd.setToolTipText("Add a new text");
            this.mBtnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditTextDlg dlg = EditTextDlg.create(mBtnAdd, mDevPath, null);
                    if (dlg != null && dlg.doModal()) {
                        this.updateTextList();
                        mTextList.setSelectedValue(dlg.getText(), true);
                    }
                }
            });
            l.add((Component)this.mBtnAdd, (GridBagConstraints)btnCs);
            this.mBtnEdit = new JButton("Edit...");
            this.mBtnEdit.setMargin(new Insets(1, 0, 1, 0));
            this.mBtnEdit.setToolTipText("Edit the selected text");
            this.mBtnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditTextDlg dlg = EditTextDlg.create(mBtnAdd, mDevPath, this.getText());
                    if (dlg != null && dlg.doModal()) {
                        this.updateTextList();
                        mTextList.setSelectedValue(dlg.getText(), true);
                    }
                }
            });
            l.add((Component)this.mBtnEdit, (GridBagConstraints)btnCs);
            this.mBtnDelete = new JButton("Delete");
            this.mBtnDelete.setMargin(new Insets(1, 0, 1, 0));
            this.mBtnDelete.setToolTipText("Delete the selected dimension");
            this.mBtnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Text t = this.getText();
                    int idx = mTextList.getSelectedIndex();
                    Cp.exec((String)"%s.deleteFromDb();", (Object[])new Object[]{CpHelper.getObjCmdStr(t)});
                    this.updateTextList();
                    if (idx >= mTexts.getSize()) {
                        --idx;
                    }
                    if (idx >= 0) {
                        mTextList.setSelectedIndex(idx);
                    }
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            });
            l.add((Component)this.mBtnDelete, (GridBagConstraints)btnCs);
            l.popNl();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnClose = new JButton("Close");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            this.updateTextList();
            this.enableButtons();
            this.setVisible(true);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        protected void updateSubstrates(String substrateToUse) {
            this.enableButtons();
        }

        protected void updateTextList() {
            this.mTexts.clear();
            if (this.mDb == null) {
                return;
            }
            for (Text t : Text.getTexts((DbObject)this.mDev, (Comparator)Text.NameComparator)) {
                this.mTexts.addText(t);
            }
        }

        protected Text getText() {
            return this.mTextList.getSelectedValue();
        }

        protected void enableButtons() {
            int selIdx = this.mTextList.getSelectedIndex();
            this.mBtnEdit.setEnabled(selIdx >= 0);
            this.mBtnDelete.setEnabled(selIdx >= 0);
        }
    }
}

