/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.APair;
import com.sigrity.acl.Unit;
import com.sigrity.acl.ui.AComboBox;
import com.sigrity.acl.ui.GridBagManager;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UserUnitsPanel
extends JPanel {
    protected JLabel mUserUnitL;
    protected AComboBox<AComboBox.AComboBoxItem> mUserUnitCB;
    protected LinkedList<JTextField> mTxtFields;
    protected Unit mUnits;
    protected ActionListener mUnitChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            UserUnitsPanel.this.updateTextFields((String)((AComboBox.AComboBoxItem)UserUnitsPanel.this.mUserUnitCB.getSelectedItem()).getText());
        }
    };

    public UserUnitsPanel(Unit defaultUnit) {
        this.init(defaultUnit);
    }

    protected void init(Unit defaultUnit) {
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mUserUnitL = l.add("Unit:", (GridBagConstraints)GridBagManager.LEFT);
        this.mUserUnitCB = new AComboBox();
        for (int i = 0; i < Unit.KnownUserDistanceUnits.size(); ++i) {
            this.mUserUnitCB.addItem((Object)new AComboBox.AComboBoxItem((Object)((Unit.Distance)((APair)Unit.KnownUserDistanceUnits.get((int)i)).second).getUserName(), null, (Object)i));
        }
        this.mUserUnitCB.setSelectedIndex(Unit.getKnownUserDistanceIndex((Unit)defaultUnit));
        this.mUnits = defaultUnit;
        l.add(this.mUserUnitCB, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        this.mUserUnitCB.addActionListener(this.mUnitChangedListener);
        this.mTxtFields = new LinkedList();
    }

    public void addTextField(JTextField field) {
        this.mTxtFields.add(field);
    }

    protected void updateTextFields(String newUnitString) {
        Unit newUnits = (Unit)((APair)Unit.KnownUserDistanceUnits.get((int)Unit.getKnownUserDistanceIndex((String)newUnitString))).second;
        for (JTextField field : this.mTxtFields) {
            String rawNumber = field.getText().replace(",", "");
            double doubleVal = 0.0;
            try {
                doubleVal = Double.parseDouble(rawNumber);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (rawNumber.length() <= 0) continue;
            field.setText(Double.toString(newUnits.convertTo(this.mUnits, doubleVal)));
        }
        this.mUnits = newUnits;
    }

    public Unit getUnit() {
        return this.mUnits;
    }
}

