/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ABoolean;
import com.sigrity.acl.AFile;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.SubstrateChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VerilogUI
extends DbDialog {
    private static final String TITLE = "Import Verilog";
    protected AFileChooserControl mFileChooser;
    protected SubstrateChooser mSubstrateChooser;
    protected JTextField mTxtNewSubstrateName;
    private JRadioButton mOverwriteBtn;
    private JCheckBox mOverwritePGCb;
    private JCheckBox mOverwriteBumpCb;

    public static Action getAction() {
        return new AbstractAction(TITLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerilogUI.showDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb());
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showDialog(Component owner, Db db) {
        VerilogUI dlg = new VerilogUI(owner, db);
        dlg.setVisible(true);
    }

    public static boolean open(File file) {
        if (OrbitIO.getCurDb() == null) {
            OrbitIO.getApp().createDesign();
        }
        try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)TITLE);){
            Object res = Cp.exec((String)"com.sigrity.orbit.verilog.Verilog.importFiles(new String[] {\"%s\"}, curDb(), null)", (Object[])new Object[]{file.getAbsolutePath()});
            if (res instanceof Boolean) {
                boolean bl = (Boolean)res;
                return bl;
            }
        }
        return false;
    }

    public static void registerFileHandler(OrbitIO app) {
        app.registerFileHandler("Open", new OrbitIO.FileHandler(){

            @Override
            public boolean canHandle(String action, File file) {
                if (!file.isFile()) {
                    return false;
                }
                if (!file.canRead()) {
                    return false;
                }
                String ext = AFile.getExtension((File)file);
                if (ext == null) {
                    return false;
                }
                return ext.equalsIgnoreCase("v");
            }

            @Override
            public boolean handle(String action, File file) {
                String ext = AFile.getExtension((File)file);
                if (ext == null) {
                    return false;
                }
                if (ext.equalsIgnoreCase("v")) {
                    return VerilogUI.open(file);
                }
                return false;
            }
        });
    }

    private VerilogUI(Component owner, Db db) {
        super(db, owner);
        this.setTitle(TITLE);
        this.setRecallBounds(false);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        l.pushFill("Source");
        l.add("File:");
        this.mFileChooser = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mFileChooser.addChoosableFileFilter(AFileFilter.VERILOG_FAMILY);
        this.mFileChooser.setMultiple(true);
        l.popNl();
        l.pushFill("Design");
        l.add("Substrate:");
        this.mSubstrateChooser = (SubstrateChooser)l.add((Component)new SubstrateChooser(this.getDb()));
        this.mSubstrateChooser.setAllowCreate(true);
        l.newline();
        JLabel newSubstrateLabel = l.add("Substrate Name:", (GridBagConstraints)GridBagManager.LEFT.indent().insetTop(0));
        String subName = Substrate.getUniqueName((Db)this.mDb, (String)"VerilogImport", (String)"", (boolean)false);
        this.mTxtNewSubstrateName = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.FILLX_REMAINX.insetTop(0));
        this.mTxtNewSubstrateName.setText(subName);
        if (this.mSubstrateChooser.getSelectedItem() != null) {
            this.mTxtNewSubstrateName.setEnabled(false);
        }
        l.popNl();
        l.pushFill("Import Mode");
        this.mOverwriteBtn = new JRadioButton("Overwrite");
        this.mOverwriteBtn.setToolTipText("Overwrite existing design");
        this.mOverwriteBtn.setSelected(true);
        l.add((Component)this.mOverwriteBtn, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        l.addFillX();
        l.newline();
        this.mOverwritePGCb = new JCheckBox("Overwrite power/ground");
        l.add((Component)this.mOverwritePGCb, (GridBagConstraints)GridBagManager.LEFT_REMAINX.indent().insetTop(0));
        l.newline();
        this.mOverwriteBumpCb = new JCheckBox("Overwrite bump devices");
        l.add((Component)this.mOverwriteBumpCb, (GridBagConstraints)GridBagManager.LEFT_REMAINX.indent().insetTop(0));
        l.newline();
        JRadioButton mergeBtn = new JRadioButton("Merge");
        mergeBtn.setToolTipText("Import change only");
        l.add((Component)mergeBtn, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        l.newline();
        AButtonGroup mBgMessageLevel = new AButtonGroup();
        mBgMessageLevel.add(this.mOverwriteBtn);
        mBgMessageLevel.add(mergeBtn);
        l.popNl();
        ActionListener overwriteListener = e -> {
            this.mOverwritePGCb.setEnabled(this.mOverwriteBtn.isSelected());
            this.mOverwriteBumpCb.setEnabled(this.mOverwriteBtn.isSelected());
        };
        overwriteListener.actionPerformed(null);
        this.mOverwriteBtn.addActionListener(overwriteListener);
        mergeBtn.addActionListener(overwriteListener);
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOk = new JButton("Import");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(event -> {
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)TITLE);){
                this.doImport();
            }
        });
        JButton btnCancel = new JButton("Close");
        l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.mSubstrateChooser.addItemListener(event -> {
            UIUtil.setEnabled((Container)this.mTxtNewSubstrateName, (this.mSubstrateChooser.getSelectedItem() == null ? 1 : 0) != 0);
            UIUtil.setEnabled((Container)newSubstrateLabel, (this.mSubstrateChooser.getSelectedItem() == null ? 1 : 0) != 0);
        });
    }

    public void doImport() {
        Substrate newSubstrate;
        try {
            AFieldValidator.validateFilesReadable((JTextField)this.mFileChooser.getTextField());
            if (this.mSubstrateChooser.getSelectedItem() == null) {
                AFieldValidator.validateText((JTextComponent)this.mTxtNewSubstrateName);
            }
        }
        catch (AFieldValidator.AFieldValidationException e) {
            return;
        }
        String substrateName = this.mSubstrateChooser.getSelectedItem() == null ? this.mTxtNewSubstrateName.getText().trim() : this.mSubstrateChooser.getSelectedItem().getName();
        StringBuilder pathsStrBuilder = new StringBuilder();
        for (String p : this.mFileChooser.getPaths()) {
            if (pathsStrBuilder.length() != 0) {
                pathsStrBuilder.append(", ");
            }
            pathsStrBuilder.append("\"");
            pathsStrBuilder.append(p);
            pathsStrBuilder.append("\"");
        }
        Cp.exec((String)"_Importer = new com.sigrity.orbit.verilog.Verilog.Importer(curDb());", (Object[])new Object[0]);
        Cp.exec((String)"_Importer.setTargetSubstrateName(Optional.ofNullable(\"%s\"))", (Object[])new Object[]{substrateName});
        boolean isOverwrite = this.mOverwriteBtn.isSelected();
        Cp.exec((String)"_Importer.setIsOverwriteExisting(%b)", (Object[])new Object[]{isOverwrite});
        if (isOverwrite) {
            Cp.exec((String)"_Importer.setIsOverwritePG(%b)", (Object[])new Object[]{this.mOverwritePGCb.isSelected()});
            Cp.exec((String)"_Importer.setIsOverwriteBump(%b)", (Object[])new Object[]{this.mOverwriteBumpCb.isSelected()});
        }
        Object r = Cp.exec((String)"_Importer.importFiles(%s)", (Object[])new Object[]{pathsStrBuilder.toString()});
        Cp.exec((String)"unset(\"_Importer\");", (Object[])new Object[0]);
        String title = this.getTitle();
        if (r instanceof Boolean && ABoolean.of((Object)r)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Import complete", title, 1);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Import failed, see the log for errors", title, 0);
        }
        if (this.mSubstrateChooser.getSelectedItem() == null && (newSubstrate = Substrate.getSubstrate((Db)this.mDb, (String)substrateName)) != null) {
            this.mSubstrateChooser.reload();
            this.mSubstrateChooser.setSelectedItem(newSubstrate);
        }
    }
}

