/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ALinkLabel;
import com.sigrity.acl.ui.APatternColorChooser;
import com.sigrity.acl.ui.ASeparator;
import com.sigrity.acl.ui.ASpinner;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.ATabbedPane;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PersonalityMappingMgmt;
import com.sigrity.orbit.ui.common.DeviceTree;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.tools.dbexplorer.NodeOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class VisibilityControlUI {
    public static final String CN_TXT_CUSTOM_PIN_TEXT = "txtCustomPinText";
    public static final String CN_CB_SHOW_CUSTOM_PIN_TEXT = "cbShowCustomPinText";
    protected static BiMap<DesignView2D, VisibilityControlUI> mView2Dialog = HashBiMap.create();
    protected ADialog mDlg;
    protected DesignView2D mView;
    private ATabbedPane mTabs;
    protected ViewColorizer mViewColorizer;
    protected JCheckBox mCbIgnoreHierarchySettings;
    protected JList<ViewColorizer.Priority> mLstPriorities;
    protected PriorityListModel mPriorities = new PriorityListModel();
    protected JButton mBtnPriorityReset;
    protected JCheckBox mCbShowDeviceNames;
    protected JCheckBox mCbShowPinNames;
    protected JCheckBox mCbShowPinNetNames;
    protected JCheckBox mCbShowPinTopmostNetNames;
    protected JCheckBox mCbShowSynthMarkers;
    protected JCheckBox mCbShowFixedMarkers;
    protected JCheckBox mCbShowSchedConns;
    protected JCheckBox mCbShowInterfaces;
    protected JCheckBox mCbUseMappedNets;
    protected JCheckBox mCbUseArrowCursorForSelectModes;
    protected JCheckBox mCbShowDiffPair;
    protected JCheckBox mCbShowTexts;
    protected JCheckBox mCbShowDesignBounds;
    protected JCheckBox mCbShowRotationIndicators;
    protected JCheckBox mCbShowTextualTransform;
    protected JComboBox<String> mCbUseCanvasTheme;
    protected JCheckBox mCbShowCustomPinText;
    protected JTextField mTxtCustomPinText;
    protected JCheckBox mCbHollowWires;
    protected JCheckBox mCbHollowPins;
    protected JCheckBox mCbHollowDevices;
    protected JCheckBox mCbHollowMetals;
    protected JCheckBox mCbWireVertices;
    protected DeviceTree mDeviceTree;
    protected JTabbedPane mTabsSettingType;
    protected ColorList mLstObjectColors = new ColorList();
    protected ColorList mLstLayerColors = new ColorList();
    protected ColorList mLstNetColors = new ColorList();
    protected JButton mBtnChangeSelDisplayItem;
    protected JButton mBtnRemoveOverride;
    protected ChangeCustomPinText mChangeCustomPinText = new ChangeCustomPinText();
    protected ListSelectionListener mColorListSelectionChanged = e -> this.enableSelectedVisibilityItemButtons();
    protected ActionListener mIgnoreOverridesChangeListener = e -> {
        this.mViewColorizer.setIgnoreOverrides(!this.mViewColorizer.getIgnoreOverrides());
        this.mCbIgnoreHierarchySettings.setSelected(this.mViewColorizer.getIgnoreOverrides());
        this.refreshCanvas();
    };
    protected TreeSelectionListener mDeviceSelectionListener = e -> this.loadSettings();
    protected Action mChangeColorAction = new AbstractAction("Change..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorList colorList = VisibilityControlUI.this.getCurrentColorList();
            ViewColorizer.Key curKey = colorList.getSelectedItem();
            if (curKey == null) {
                return;
            }
            DevicePath selDevPath = VisibilityControlUI.this.getSelectedDevicePath(true);
            new ActionChangeColor(colorList, VisibilityControlUI.this.mViewColorizer, curKey, selDevPath).actionPerformed(e);
            VisibilityControlUI.this.refreshCanvas();
            int selIdx = colorList.getSelectedIndex();
            colorList.repaint(colorList.getCellBounds(selIdx, selIdx));
            VisibilityControlUI.this.enableSelectedVisibilityItemButtons();
        }
    };
    protected Action mRemoveOverridesAction = new AbstractAction("Remove Overrides"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorList colorList = VisibilityControlUI.this.getCurrentColorList();
            boolean removed = false;
            for (ViewColorizer.Key key : colorList.getSelectedOverrides()) {
                if (!VisibilityControlUI.this.mViewColorizer.removeDisplayInfo(VisibilityControlUI.this.getSelectedDevicePath(true), key)) continue;
                removed = true;
            }
            if (!removed) {
                return;
            }
            VisibilityControlUI.this.getCurrentColorList().requestFocus();
            VisibilityControlUI.this.refreshCanvas();
            colorList.repaint();
            VisibilityControlUI.this.enableSelectedVisibilityItemButtons();
        }
    };
    protected Action mRemoveAllOverridesAction = new AbstractAction("Remove All Overrides"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorList colorList = VisibilityControlUI.this.getCurrentColorList();
            boolean removed = false;
            for (ViewColorizer.Key key : AUtil.linkedList(colorList.getOverrides())) {
                if (!VisibilityControlUI.this.mViewColorizer.removeDisplayInfo(VisibilityControlUI.this.getSelectedDevicePath(true), key)) continue;
                removed = true;
            }
            if (!removed) {
                return;
            }
            VisibilityControlUI.this.getCurrentColorList().requestFocus();
            VisibilityControlUI.this.refreshCanvas();
            colorList.repaint();
            VisibilityControlUI.this.enableSelectedVisibilityItemButtons();
        }
    };
    protected ActionListener mShowToggleListener = e -> {
        if (e.getSource() == this.mCbShowDeviceNames) {
            this.mViewColorizer.setShowDeviceNames(this.mCbShowDeviceNames.isSelected());
        } else if (e.getSource() == this.mCbShowPinNames) {
            this.mViewColorizer.setShowPinNames(this.mCbShowPinNames.isSelected());
        } else if (e.getSource() == this.mCbShowPinNetNames) {
            this.mViewColorizer.setShowPinNetNames(this.mCbShowPinNetNames.isSelected());
        } else if (e.getSource() == this.mCbShowPinTopmostNetNames) {
            this.mViewColorizer.setShowPinTopmostNetNames(this.mCbShowPinTopmostNetNames.isSelected());
        } else if (e.getSource() == this.mCbShowSchedConns) {
            this.mViewColorizer.setShowSchedConns(this.mCbShowSchedConns.isSelected());
        } else if (e.getSource() == this.mCbShowInterfaces) {
            this.mViewColorizer.setShowInterfaces(this.mCbShowInterfaces.isSelected());
        } else if (e.getSource() == this.mCbUseMappedNets) {
            this.mViewColorizer.setUseMappedNets(this.mCbUseMappedNets.isSelected());
        } else if (e.getSource() == this.mCbUseArrowCursorForSelectModes) {
            this.mViewColorizer.setArrowCursorForSelectModes(this.mCbUseArrowCursorForSelectModes.isSelected());
        } else if (e.getSource() == this.mCbShowDiffPair) {
            this.mViewColorizer.setShowDiffPair(this.mCbShowDiffPair.isSelected());
        } else if (e.getSource() == this.mCbShowTexts) {
            this.mViewColorizer.setShowTexts(this.mCbShowTexts.isSelected());
        } else if (e.getSource() == this.mCbShowDesignBounds) {
            this.mViewColorizer.setShowDesignBounds(this.mCbShowDesignBounds.isSelected());
        } else if (e.getSource() == this.mCbShowSynthMarkers) {
            this.mViewColorizer.setShowSynthMarkers(this.mCbShowSynthMarkers.isSelected());
        } else if (e.getSource() == this.mCbShowFixedMarkers) {
            this.mViewColorizer.setShowFixedMarkers(this.mCbShowFixedMarkers.isSelected());
        } else if (e.getSource() == this.mCbShowRotationIndicators) {
            this.mViewColorizer.setShowRotationIndicators(this.mCbShowRotationIndicators.isSelected());
        } else if (e.getSource() == this.mCbShowTextualTransform) {
            this.mViewColorizer.setShowTextualTransform(this.mCbShowTextualTransform.isSelected());
        } else if (e.getSource() == this.mCbHollowWires) {
            this.mViewColorizer.setHollowWires(this.mCbHollowWires.isSelected());
        } else if (e.getSource() == this.mCbWireVertices) {
            this.mViewColorizer.setShowWireVertices(this.mCbWireVertices.isSelected());
        } else if (e.getSource() == this.mCbHollowPins) {
            this.mViewColorizer.setHollowPins(this.mCbHollowPins.isSelected());
        } else if (e.getSource() == this.mCbHollowDevices) {
            this.mViewColorizer.setHollowDevices(this.mCbHollowDevices.isSelected());
        } else if (e.getSource() == this.mCbHollowMetals) {
            this.mViewColorizer.setHollowMetals(this.mCbHollowMetals.isSelected());
        } else if (e.getSource() == this.mCbShowCustomPinText) {
            this.mViewColorizer.setShowCustomPinText(this.mCbShowCustomPinText.isSelected());
            this.mTxtCustomPinText.setEnabled(this.mCbShowCustomPinText.isSelected());
        } else assert (false);
        Db db = OrbitIO.getCurDb();
        if (db != null) {
            PersonalityMappingMgmt.clear((Db)db);
        }
        this.refreshCanvas();
    };

    public static JDialog showFor(DesignView2D v) {
        VisibilityControlUI d = (VisibilityControlUI)mView2Dialog.get((Object)v);
        if (d != null) {
            d.mDlg.setVisible(true);
            return d.mDlg;
        }
        final VisibilityControlUI vcui = new VisibilityControlUI(v);
        mView2Dialog.put((Object)v, (Object)vcui);
        vcui.mDlg.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                mView2Dialog.inverse().remove((Object)vcui);
            }
        });
        if (v != null) {
            v.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    VisibilityControlUI ui = (VisibilityControlUI)mView2Dialog.get((Object)event.getComponent());
                    if (ui != null) {
                        UIUtil.closeWindow((Window)ui.mDlg);
                    }
                }
            });
        }
        return vcui.mDlg;
    }

    public static JDialog showFor(DesignView2D v, int tabIndex) {
        JDialog d = VisibilityControlUI.showFor(v);
        VisibilityControlUI ui = (VisibilityControlUI)mView2Dialog.get((Object)v);
        ui.mTabs.setSelectedIndex(tabIndex);
        return d;
    }

    protected VisibilityControlUI(DesignView2D v) {
        this.mView = v;
        this.loadColorizer();
        String title = String.format("View Settings - %s", this.mView != null ? this.mView.getTitle() : "");
        this.mDlg = new ADialog((Component)this.mView, title, Dialog.ModalityType.MODELESS);
        this.mDlg.setIconImage(((ImageIcon)OrbitIcons.VIEW_SETTING).getImage());
        this.mTabs = new ATabbedPane();
        this.mTabs.addTab("Color/Visibility", this.createLayersPanel(v));
        this.mTabs.addTab("Display", this.createDisplayPanel());
        this.mTabs.addTab("Priority", this.createPriorityPanel());
        this.mTabs.addTab("UI Properties", this.createPropertyPanel());
        this.mDlg.getContentPane().setLayout(new BorderLayout());
        this.mDlg.getContentPane().add((Component)this.mTabs, "Center");
        JPanel optionsPanel = new JPanel();
        GridBagManager l = new GridBagManager((Container)optionsPanel);
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        ALinkLabel lblReset = new ALinkLabel("Reset design");
        lblReset.setToolTipText("Reset the design settings to the saved default settings.");
        lblReset.addActionListener(e -> {
            int response = JOptionPane.showConfirmDialog((Component)this.mDlg, "Do you want to reset the design visibility settings?", "Confirm Reset", 0, 3);
            if (response != 0) {
                return;
            }
            this.mView.getCanvas().resetViewSettings();
            this.loadSettings();
        });
        l.add((Component)lblReset, (GridBagConstraints)GridBagManager.LEFT);
        ALinkLabel lblSaveDefaults = new ALinkLabel("Save as defaults");
        lblSaveDefaults.setToolTipText("Save current settings as default settings for the application.");
        lblSaveDefaults.addActionListener(e -> {
            int response = JOptionPane.showConfirmDialog((Component)this.mDlg, "Do you want to save the current visibility settings as the defaults?", "Confirm Save", 0, 3);
            if (response != 0) {
                return;
            }
            this.mView.getCanvas().saveDefaults();
            JOptionPane.showMessageDialog((Component)this.mDlg, "Defaults saved.");
            this.loadSettings();
        });
        l.add((Component)lblSaveDefaults, (GridBagConstraints)GridBagManager.LEFT);
        ALinkLabel lblResetAll = new ALinkLabel("Reset defaults");
        lblResetAll.setToolTipText("Reset the design and system settings to the application default settings.");
        lblResetAll.addActionListener(e -> {
            int response = JOptionPane.showConfirmDialog((Component)this.mDlg, "Do you want to reset all default visibility settings?", "Confirm Reset", 0, 3);
            if (response != 0) {
                return;
            }
            DesignCanvas2D.resetDefaults();
            this.mView.getCanvas().resetViewSettings();
            this.loadSettings();
        });
        l.add((Component)lblResetAll, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        JButton btnClose = new JButton("Close");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        UIUtil.enableEscapeClose((Window)this.mDlg, (AbstractButton)btnClose);
        UIUtil.enforceDialogMinSize((Window)this.mDlg);
        l.pop();
        this.mDlg.getContentPane().add((Component)optionsPanel, "South");
        this.enableSelectedVisibilityItemButtons();
        this.mDlg.pack();
        this.mDlg.setMinimumSize(this.mDlg.getPreferredSize());
        this.mDlg.setResizable(false);
        this.loadSettings();
        this.enableSelectedVisibilityItemButtons();
        UIUtil.center((Component)this.mDlg);
        this.mDlg.setVisible(true);
    }

    private JPanel createLayersPanel(DesignView2D v) {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        l.push((GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        ASplitPane splitColorSelections = new ASplitPane();
        l.add((Component)splitColorSelections, (GridBagConstraints)GridBagManager.FILLALL);
        Design design = Design.getDesign((Db)v.getDb());
        Objects.requireNonNull(design);
        this.mDeviceTree = new DeviceTree(design){

            @Override
            protected int getPreferredWidth(int defWidth) {
                return defWidth;
            }
        };
        this.mDeviceTree.addTreeSelectionListener(this.mDeviceSelectionListener);
        JScrollPane scrollDeviceTree = new JScrollPane(this.mDeviceTree);
        scrollDeviceTree.setBorder(null);
        splitColorSelections.setLeftComponent(scrollDeviceTree);
        JPanel pnlColors = new JPanel();
        splitColorSelections.setRightComponent(pnlColors);
        GridBagManager l2 = new GridBagManager((Container)pnlColors);
        this.mTabsSettingType = new JTabbedPane();
        l2.add((Component)this.mTabsSettingType, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        this.mTabsSettingType.add("Layers", new JScrollPane(this.mLstLayerColors));
        this.mLstLayerColors.addListSelectionListener(this.mColorListSelectionChanged);
        this.mTabsSettingType.add("Objects", new JScrollPane(this.mLstObjectColors));
        this.mLstObjectColors.addListSelectionListener(this.mColorListSelectionChanged);
        this.mTabsSettingType.addChangeListener(e -> {
            this.loadSettings();
            this.enableSelectedVisibilityItemButtons();
        });
        l2.newline();
        l2.addFillX();
        this.mBtnChangeSelDisplayItem = new JButton("Change...");
        l2.add((Component)this.mBtnChangeSelDisplayItem, (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnChangeSelDisplayItem.addActionListener(this.mChangeColorAction);
        this.mBtnChangeSelDisplayItem.setMnemonic(67);
        this.mBtnRemoveOverride = new JButton("Remove Overrides");
        l2.add((Component)this.mBtnRemoveOverride, (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnRemoveOverride.addActionListener(this.mRemoveOverridesAction);
        this.mBtnRemoveOverride.setMnemonic(82);
        UIUtil.makeSmallButton((JButton)this.mBtnChangeSelDisplayItem);
        UIUtil.makeSmallButton((JButton)this.mBtnRemoveOverride);
        l.newline();
        this.mCbIgnoreHierarchySettings = new JCheckBox("Ignore hierarchy overrides, only use Design settings");
        l.add((Component)this.mCbIgnoreHierarchySettings, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCbIgnoreHierarchySettings.addActionListener(this.mIgnoreOverridesChangeListener);
        l.pop();
        l.newline();
        return panel;
    }

    private JPanel createPriorityPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        l.push("Color Priorities", (GridBagConstraints)GridBagManager.FILLALL);
        this.mLstPriorities = new JList<ViewColorizer.Priority>(this.mPriorities);
        this.mLstPriorities.setSelectionMode(1);
        this.mLstPriorities.setBorder(BorderFactory.createEtchedBorder());
        this.mLstPriorities.setSelectionMode(0);
        l.add(this.mLstPriorities, (GridBagConstraints)GridBagManager.FILLALL.anchor(18));
        l.pushNoFill();
        ASpinner spin = new ASpinner();
        l.add((Component)spin, (GridBagConstraints)GridBagManager.CENTER);
        spin.setUpToolTip("Move selected priority up");
        spin.addUpActionListener(e -> this.movePriority(true));
        spin.setDownToolTip("Move selected priority down");
        spin.addDownActionListener(e -> this.movePriority(false));
        l.newline();
        l.pop();
        this.mBtnPriorityReset = new JButton("Restore Defaults");
        this.mBtnPriorityReset.setToolTipText("Reset priority order");
        l.add((Component)this.mBtnPriorityReset, (GridBagConstraints)GridBagManager.RIGHT.anchor(16));
        this.mBtnPriorityReset.addActionListener(e -> this.resetPriorities());
        l.pop();
        return panel;
    }

    private JPanel createDisplayPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        GridBagManager.GridBagConstraintsEx cbOptConstrain = GridBagManager.LEFT.insets(0, 0);
        l.push((GridBagConstraints)GridBagManager.FILLX.anchor(11));
        l.add((Component)new ASeparator("Text Display"), (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        this.mCbShowDeviceNames = new JCheckBox("Show device names");
        this.mCbShowDeviceNames.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowDeviceNames, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowPinNames = new JCheckBox("Show pin names");
        this.mCbShowPinNames.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowPinNames, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowPinNetNames = new JCheckBox("Show pin net names");
        this.mCbShowPinNetNames.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowPinNetNames, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowPinTopmostNetNames = new JCheckBox("Show pin topmost net names");
        this.mCbShowPinTopmostNetNames.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowPinTopmostNetNames, (GridBagConstraints)cbOptConstrain);
        l.newline();
        String customPinTextTip = "<html>The following variables are set:<br/>&nbsp;&nbsp;&nbsp;<b>path</b>: current DevicePath<br/>&nbsp;&nbsp;&nbsp;<b>pin</b>: current PinInstance<br/>&nbsp;&nbsp;&nbsp;<b>port</b>: current PortTemplate<br/>For exmample: <b>pin.getName()</b><br/></html>";
        this.mCbShowCustomPinText = new JCheckBox("Show custom pin text (hover for help)");
        this.mCbShowCustomPinText.setName(CN_CB_SHOW_CUSTOM_PIN_TEXT);
        this.mCbShowCustomPinText.setToolTipText(customPinTextTip);
        this.mCbShowCustomPinText.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowCustomPinText, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mTxtCustomPinText = new JTextField();
        this.mTxtCustomPinText.setName(CN_TXT_CUSTOM_PIN_TEXT);
        this.mTxtCustomPinText.setToolTipText(customPinTextTip);
        l.add((Component)this.mTxtCustomPinText, (GridBagConstraints)GridBagManager.FILLX_REMAINX.indent().indent().insetTop(0));
        this.mTxtCustomPinText.addActionListener(this.mChangeCustomPinText);
        this.mTxtCustomPinText.getDocument().addDocumentListener(this.mChangeCustomPinText);
        l.newline();
        l.add((Component)new ASeparator("Object Display"), (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        this.mCbShowInterfaces = new JCheckBox("Show interfaces");
        this.mCbShowInterfaces.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowInterfaces, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowDesignBounds = new JCheckBox("Show design area");
        this.mCbShowDesignBounds.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowDesignBounds, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowDiffPair = new JCheckBox("Show diff pair coupling");
        this.mCbShowDiffPair.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowDiffPair, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowTexts = new JCheckBox("Show texts");
        this.mCbShowTexts.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowTexts, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowSchedConns = new JCheckBox("Show scheduled connections");
        this.mCbShowSchedConns.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowSchedConns, (GridBagConstraints)cbOptConstrain);
        l.newline();
        l.pop();
        l.push((GridBagConstraints)GridBagManager.TOPLEFT);
        l.add((Component)new ASeparator("Marker/Decoration"), (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        this.mCbShowSynthMarkers = new JCheckBox("Show synthesized markers");
        this.mCbShowSynthMarkers.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowSynthMarkers, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowFixedMarkers = new JCheckBox("Show fixed item markers");
        this.mCbShowFixedMarkers.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowFixedMarkers, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowRotationIndicators = new JCheckBox("Show device rotation indicators");
        this.mCbShowRotationIndicators.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowRotationIndicators, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbShowTextualTransform = new JCheckBox("Show transform relative to substrate");
        this.mCbShowTextualTransform.setToolTipText("Display the .def transform text on the device");
        this.mCbShowTextualTransform.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbShowTextualTransform, (GridBagConstraints)cbOptConstrain);
        l.newline();
        l.add((Component)new ASeparator("Draw Style"), (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        this.mCbHollowDevices = new JCheckBox("Draw hollow devices");
        this.mCbHollowDevices.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbHollowDevices, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbHollowPins = new JCheckBox("Draw hollow pins");
        this.mCbHollowPins.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbHollowPins, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbHollowWires = new JCheckBox("Draw hollow wires");
        this.mCbHollowWires.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbHollowWires, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbHollowMetals = new JCheckBox("Draw hollow metals");
        this.mCbHollowMetals.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbHollowMetals, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbWireVertices = new JCheckBox("Draw wire vertices");
        this.mCbWireVertices.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbWireVertices, (GridBagConstraints)cbOptConstrain);
        l.newline();
        l.add((Component)new ASeparator("Other"), (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        this.mCbUseMappedNets = new JCheckBox("Use mapped nets for net color");
        this.mCbUseMappedNets.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbUseMappedNets, (GridBagConstraints)cbOptConstrain);
        l.newline();
        this.mCbUseArrowCursorForSelectModes = new JCheckBox("Use arrow cursor for select modes");
        this.mCbUseArrowCursorForSelectModes.addActionListener(this.mShowToggleListener);
        l.add((Component)this.mCbUseArrowCursorForSelectModes, (GridBagConstraints)cbOptConstrain);
        l.newline();
        l.pop();
        l.newline();
        l.add((Component)new ASeparator("Canvas"), (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        JPanel canvasPanel = new JPanel();
        GridBagManager sl = GridBagManager.layout((Container)canvasPanel);
        sl.add("Theme", (GridBagConstraints)GridBagManager.LEFT);
        String[] canvasTheme = new String[]{"Default", "Classic (Dark)"};
        this.mCbUseCanvasTheme = new JComboBox<String>(canvasTheme);
        this.mCbUseCanvasTheme.addActionListener(ae -> {
            int idx = this.mCbUseCanvasTheme.getSelectedIndex();
            if (idx == 0) {
                DesignCanvas2D.applyDefaultTheme();
            } else {
                DesignCanvas2D.applyClassicTheme();
            }
        });
        sl.add(this.mCbUseCanvasTheme, (GridBagConstraints)GridBagManager.LEFT);
        sl.newline();
        this.addObjectFilter(sl);
        l.add((Component)canvasPanel, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        return panel;
    }

    private JPanel createPropertyPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        GridBagManager.GridBagConstraintsEx cbOptConstrain = GridBagManager.LEFT.insets(0, 0);
        l.push((GridBagConstraints)GridBagManager.FILLX.anchor(11));
        l.add((Component)new ASeparator("Layer Display"), (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        Set<Layer.LayerType> displayed = NodeOptions.getDisplayLayerTypes();
        for (Layer.LayerType ltype : Layer.LayerType.values()) {
            JCheckBox cb = new JCheckBox(ltype.getUserName());
            cb.setSelected(displayed.contains(ltype));
            cb.setToolTipText(ltype.getDesc());
            cb.addChangeListener(e -> {
                HashSet set = AUtil.hashSet(NodeOptions.getDisplayLayerTypes());
                if (cb.isSelected()) {
                    set.add(ltype);
                } else {
                    set.remove(ltype);
                }
                NodeOptions.setDisplayLayerTypes(set);
            });
            l.add((Component)cb, (GridBagConstraints)cbOptConstrain);
            l.newline();
        }
        l.newline();
        l.pop();
        l.addFillY();
        return panel;
    }

    protected void loadColorizer() {
        this.mViewColorizer = this.mView.getColorizer();
    }

    protected void loadSettings() {
        this.loadColorizer();
        this.loadDisplayTextSettings();
        this.loadObjectSettings();
        this.loadLayerSettings();
        this.mLstNetColors.clearItems();
        this.mCbIgnoreHierarchySettings.setSelected(this.mViewColorizer.getIgnoreOverrides());
    }

    protected void loadObjectSettings() {
        this.mLstObjectColors.clearItems();
        DevicePath path = this.getSelectedDevicePath(false);
        if (path == null) {
            return;
        }
        for (ViewColorizer.Key key : ViewColorizer.getDefaultColorizer().getColorKeys(path.getDeviceTemplate().getType())) {
            this.mLstObjectColors.addItem(key);
        }
    }

    protected void loadLayerSettings() {
        this.mLstLayerColors.clearItems();
        ArrayList<ViewColorizer.LayerKey> layerKeys = new ArrayList<ViewColorizer.LayerKey>();
        DevicePath path = this.getSelectedDevicePath(false);
        if (path == null) {
            return;
        }
        if (path.isDesign()) {
            for (ViewColorizer.LayerKey key : this.mViewColorizer.getLayerKeys()) {
                layerKeys.add(key);
            }
        } else {
            Device device = path.getLast();
            DeviceTemplate dt = device.getTemplate();
            Substrate substrate = dt.getSubstrate();
            if (substrate == null) {
                return;
            }
            for (Layer layer : substrate.getLayers()) {
                ViewColorizer.LayerKey key = this.mViewColorizer.getLayerKey(layer, true);
                layerKeys.add(key);
            }
        }
        Collections.sort(layerKeys, new Comparator<ViewColorizer.LayerKey>(){

            @Override
            public int compare(ViewColorizer.LayerKey o1, ViewColorizer.LayerKey o2) {
                return o1.compareTo(o2);
            }
        }.reversed());
        for (ViewColorizer.LayerKey k : layerKeys) {
            this.mLstLayerColors.addItem((ViewColorizer.Key)k);
        }
    }

    protected void loadDisplayTextSettings() {
        this.mCbShowDeviceNames.setSelected(this.mViewColorizer.getShowDeviceNames());
        this.mCbShowPinNames.setSelected(this.mViewColorizer.getShowPinNames());
        this.mCbShowPinNetNames.setSelected(this.mViewColorizer.getShowPinNetNames());
        this.mCbShowPinTopmostNetNames.setSelected(this.mViewColorizer.getShowPinTopmostNetNames());
        this.mCbShowDesignBounds.setSelected(this.mViewColorizer.getShowDesignBounds());
        this.mCbShowSchedConns.setSelected(this.mViewColorizer.getShowSchedConns());
        this.mCbShowInterfaces.setSelected(this.mViewColorizer.getShowInterfaces());
        this.mCbUseMappedNets.setSelected(this.mViewColorizer.getUseMappedNets());
        this.mCbUseArrowCursorForSelectModes.setSelected(this.mViewColorizer.getUseArrowCursorForSelectModes());
        this.mCbShowDiffPair.setSelected(this.mViewColorizer.getShowDiffPair());
        this.mCbShowTexts.setSelected(this.mViewColorizer.getShowTexts());
        this.mCbShowSynthMarkers.setSelected(this.mViewColorizer.getShowSynthMarkers());
        this.mCbShowFixedMarkers.setSelected(this.mViewColorizer.getShowFixedMarkers());
        this.mCbShowRotationIndicators.setSelected(this.mViewColorizer.getShowRotationIndicators());
        this.mCbShowTextualTransform.setSelected(this.mViewColorizer.getShowTextualTransfom());
        this.mCbShowCustomPinText.setSelected(this.mViewColorizer.getShowCustomPinText());
        this.mTxtCustomPinText.setText(this.mViewColorizer.getCustomPinText());
        this.mTxtCustomPinText.setEnabled(this.mCbShowCustomPinText.isSelected());
        this.mCbHollowPins.setSelected(this.mViewColorizer.getHollowPins());
        this.mCbHollowDevices.setSelected(this.mViewColorizer.getHollowDevices());
        this.mCbHollowMetals.setSelected(this.mViewColorizer.getHollowMetals());
        this.mCbHollowWires.setSelected(this.mViewColorizer.getHollowWires());
        this.mCbWireVertices.setSelected(this.mViewColorizer.getShowWireVertices());
        this.mCbUseCanvasTheme.setSelectedIndex(this.mViewColorizer.getUseClassicTheme() ? 1 : 0);
    }

    protected DevicePath getSelectedDevicePath(boolean returnNonDeviceNodePath) {
        if (this.mDeviceTree.getModel().getRoot() == null) {
            assert (false);
            return null;
        }
        if (this.mDeviceTree.getSelectionCount() == 0) {
            this.mDeviceTree.setSelectionRow(0);
        }
        TreePath selPath = this.mDeviceTree.getSelectionPath();
        if (!(returnNonDeviceNodePath || selPath.getLastPathComponent() instanceof DeviceTree.DeviceNode || selPath.getLastPathComponent() instanceof DeviceTree.RootNode)) {
            return null;
        }
        return this.devicePathFromTreePath(selPath);
    }

    protected ColorList getCurrentColorList() {
        Component c = this.mTabsSettingType.getSelectedComponent();
        if (!(c instanceof JScrollPane)) {
            return null;
        }
        JScrollPane sp = (JScrollPane)c;
        Component c2 = sp.getViewport().getView();
        if (c2 instanceof ColorList) {
            return (ColorList)c2;
        }
        return null;
    }

    protected ViewColorizer.Key getSelectedColorizerKey() {
        ColorList cl = this.getCurrentColorList();
        if (cl == null) {
            return null;
        }
        return cl.getSelectedItem();
    }

    protected DevicePath devicePathFromTreePath(TreePath tp) {
        LinkedList<Device> path = new LinkedList<Device>();
        DevicePath root = null;
        for (Object o : tp.getPath()) {
            if (o instanceof DeviceTree.RootNode) {
                if (((DeviceTree.RootNode)((Object)o)).getRoot() == null) continue;
                root = new DevicePath(((DeviceTree.RootNode)((Object)o)).getRoot());
                continue;
            }
            if (!(o instanceof DeviceTree.DeviceNode)) continue;
            path.add(((DeviceTree.DeviceNode)((Object)o)).getDevice());
        }
        return path.isEmpty() ? root : DevicePath.fromList(path);
    }

    protected TreePath treePathFromDevicePath(DevicePath devicePath) {
        TreePath tp = new TreePath(devicePath.getRoot());
        for (Device d : devicePath) {
            tp = tp.pathByAddingChild(d);
        }
        return tp;
    }

    protected void movePriority(boolean up) {
        int i = this.mLstPriorities.getSelectedIndex();
        if (i != -1) {
            this.mPriorities.move(i, up);
        }
    }

    protected void resetPriorities() {
        this.mPriorities.reset();
    }

    protected void enableSelectedVisibilityItemButtons() {
        ColorList cl = this.getCurrentColorList();
        if (cl != null) {
            this.mBtnChangeSelDisplayItem.setEnabled(cl.getSelectedIndices().length > 0);
            int selOverrideCount = AUtil.linkedList(cl.getSelectedOverrides()).size();
            this.mBtnRemoveOverride.setEnabled(selOverrideCount > 0);
            String rotxt = selOverrideCount != 1 ? "Remove Selected Overrides" : "Remove Selected Override";
            this.mBtnRemoveOverride.setText(rotxt);
            this.mRemoveOverridesAction.putValue("Name", rotxt);
        }
    }

    protected void refreshCanvas() {
        if (this.mView != null) {
            this.mView.getCanvas().refresh();
        }
    }

    protected Action createSetAllVisibilityAction(String typeName, final boolean visibility, final ColorList list) {
        return new AbstractAction(String.format("All %s %s", typeName, visibility ? "On" : "Off")){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisibilityControlUI.this.setAllVisibility(list, visibility);
            }
        };
    }

    protected boolean anyVisibility(ColorList list, boolean state) {
        DevicePath path = this.getSelectedDevicePath(true);
        for (ViewColorizer.Key key : list.getAllKeys()) {
            if (this.mViewColorizer.findColor(path, key) != null != state) continue;
            return true;
        }
        return false;
    }

    protected void setAllVisibility(ColorList list, boolean visible) {
        if (list == null) {
            return;
        }
        DevicePath path = this.getSelectedDevicePath(true);
        boolean changed = false;
        for (ViewColorizer.Key key : list.getAllKeys()) {
            if (this.mViewColorizer.findColor(path, key) != null == visible) continue;
            APatternColor initColor = this.mViewColorizer.findColor(path, key, true);
            if (initColor != null) {
                this.mViewColorizer.setColor(path, key, initColor.getColor());
            }
            this.mViewColorizer.setDisplay(path, key, visible);
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.getCurrentColorList().requestFocus();
        this.refreshCanvas();
        list.repaint();
        this.enableSelectedVisibilityItemButtons();
    }

    void addObjectFilter(GridBagManager l) {
        JSpinner s = new JSpinner(new SpinnerNumberModel(0, 0, 20, 1));
        ObjectFilterSlider slider = new ObjectFilterSlider(0, 20, this.mView);
        String tooltip = "Objects below the specified size will not be displayed. 0: detail, 20: speed";
        JLabel label = new JLabel("Object size filter");
        label.setToolTipText(tooltip);
        l.add((Component)label);
        l.add((Component)s, (GridBagConstraints)GridBagManager.FILLX);
        l.addFillX();
        s.setToolTipText(tooltip);
        s.addChangeListener(e -> slider.setValue((Integer)s.getValue()));
        try {
            int curMinDrawSize = this.mView.getColorizer().getMinDrawSize();
            s.setValue(curMinDrawSize);
        }
        catch (Exception e2) {
            ALog.logWarn((String)"Lost object filter info.");
        }
    }

    public static class ObjectFilterSlider
    extends JSlider {
        DesignView2D d2d;
        protected ChangeListener mChangeListener = e -> {
            if (this.d2d == null || this.getValueIsAdjusting() || !this.isMinDrawSizeChange()) {
                return;
            }
            this.setMinDrawSize();
            if (this.d2d != null) {
                this.d2d.getCanvas().refresh();
            }
        };

        public ObjectFilterSlider(int min, int max, DesignView2D d2d) {
            super(min, max);
            this.setMajorTickSpacing(10);
            this.setMinorTickSpacing(1);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.d2d = d2d;
            this.addChangeListener(this.mChangeListener);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void setSmall() {
            this.setPaintLabels(false);
            this.setPaintTicks(false);
            this.addMouseListener(new SliderPopupListener());
        }

        @Override
        public String getToolTipText() {
            return String.format("Objects below %dpx will not be displayed", this.getValue());
        }

        public void setView(DesignView2D d2d) {
            this.d2d = d2d;
            this.setEnabled(d2d != null);
            if (d2d != null) {
                this.setValue(d2d.getColorizer().getMinDrawSize());
            }
        }

        private boolean isMinDrawSizeChange() {
            if (this.d2d == null || this.d2d.getCanvas() == null) {
                return false;
            }
            int currentValue = this.d2d.getColorizer().getMinDrawSize();
            return currentValue != this.getValue();
        }

        private void setMinDrawSize() {
            this.d2d.getColorizer().setMinDrawSize(this.getValue());
        }

        class SliderPopupListener
        extends MouseAdapter {
            private final JWindow toolTip = new JWindow();
            private final JLabel label = new JLabel("", 0);
            private final Dimension size = new Dimension(40, 20);
            private int prevValue = -1;

            protected SliderPopupListener() {
                this.label.setOpaque(false);
                this.label.setBackground(UIManager.getColor("ToolTip.background"));
                this.label.setBorder(UIManager.getBorder("ToolTip.border"));
                this.toolTip.add(this.label);
                this.toolTip.setSize(this.size);
            }

            protected void updateToolTip(MouseEvent me) {
                JSlider slider = (JSlider)me.getComponent();
                int intValue = slider.getValue();
                if (this.prevValue != intValue) {
                    this.label.setText(String.format("%d px", slider.getValue()));
                    Point pt = me.getPoint();
                    pt.y = -this.size.height;
                    SwingUtilities.convertPointToScreen(pt, me.getComponent());
                    pt.translate(-this.size.width / 2, 0);
                    this.toolTip.setLocation(pt);
                }
                this.prevValue = intValue;
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                this.updateToolTip(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (UIManager.getBoolean("Slider.onlyLeftMouseButtonDrag") && SwingUtilities.isLeftMouseButton(me)) {
                    this.toolTip.setVisible(true);
                    this.updateToolTip(me);
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.toolTip.setVisible(false);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JSlider s = (JSlider)e.getComponent();
                int i = s.getValue() - e.getWheelRotation();
                BoundedRangeModel m = s.getModel();
                s.setValue(Math.min(Math.max(i, m.getMinimum()), m.getMaximum()));
            }
        }
    }

    class CellRenderer
    extends JPanel
    implements ListCellRenderer<ViewColorizer.Key> {
        protected JCheckBox mCb = new JCheckBox();
        protected JLabel mIcon = new JLabel();
        protected JLabel mLabel = new JLabel();

        public CellRenderer() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setOpaque(true);
            this.add(this.mCb);
            this.mCb.setOpaque(false);
            this.mCb.setBackground(new Color(0, 0, 0, 0));
            this.add(this.mIcon);
            this.mLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
            this.add(this.mLabel);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ViewColorizer.Key> list, ViewColorizer.Key key, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(list.getFont());
            DevicePath selDevPath = VisibilityControlUI.this.getSelectedDevicePath(true);
            ViewColorizer vc = VisibilityControlUI.this.mViewColorizer.getColorizerFor(selDevPath, key);
            if (vc == null) {
                this.mLabel.setText("Unable to find DisplayInfo");
                this.setEnabled(false);
                assert (false);
            } else {
                boolean isInherited;
                ViewColorizer.DisplayInfo info = vc.getDisplayInfo(null, key);
                this.mLabel.setText(VisibilityControlUI.this.mViewColorizer.getDescription((Object)key));
                this.mCb.setSelected(info.getDisplay());
                this.mIcon.setIcon(info.getPatternColor().getIcon(16));
                boolean bl = isInherited = !selDevPath.equals((Object)vc.getPath());
                if (isInherited) {
                    this.setToolTipText(String.format("Inherited from: %s", vc.getPath().toString()));
                } else {
                    this.setToolTipText(null);
                }
                this.mLabel.setEnabled(!isInherited);
                this.mCb.setEnabled(!isInherited);
                if (key == ViewColorizer.KDesignCanvas) {
                    this.mCb.setSelected(true);
                    this.mCb.setEnabled(false);
                }
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setEnabled(list.isEnabled());
            }
            return this;
        }
    }

    class ColorList
    extends JList<ViewColorizer.Key> {
        protected DefaultListModel<ViewColorizer.Key> mModel = new DefaultListModel();
        protected KeyListener mColorListKeyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                super.keyTyped(e);
                if (e.isConsumed()) {
                    return;
                }
                if (e.getKeyChar() == ' ') {
                    Component c = e.getComponent();
                    if (!(c instanceof JList)) {
                        return;
                    }
                    ColorList colorList = (ColorList)c;
                    boolean changed = false;
                    for (int idx : colorList.getSelectedIndices()) {
                        ViewColorizer.Key key = colorList.getItem(idx);
                        DevicePath selDevPath = VisibilityControlUI.this.getSelectedDevicePath(true);
                        ViewColorizer.DisplayInfo info = VisibilityControlUI.this.mViewColorizer.findDisplayInfo(selDevPath, key);
                        boolean oldDisplay = info.getDisplay();
                        VisibilityControlUI.this.mViewColorizer.setColor(selDevPath, key, info.getColor());
                        VisibilityControlUI.this.mViewColorizer.setDisplay(selDevPath, key, !oldDisplay);
                        UIUtil.repaintListItem((JList)colorList, (int)idx);
                        changed = true;
                    }
                    if (changed) {
                        VisibilityControlUI.this.refreshCanvas();
                    }
                }
            }
        };
        protected MouseListener mColorListMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                    return;
                }
                Component c = e.getComponent();
                if (!(c instanceof ColorList)) {
                    return;
                }
                ColorList colorList = (ColorList)c;
                Point lstPoint = e.getPoint();
                int index = colorList.locationToIndex(lstPoint);
                if (index == -1) {
                    return;
                }
                ViewColorizer.Key key = colorList.getItem(index);
                CellRenderer renderer = (CellRenderer)colorList.getCellRenderer();
                Rectangle cellBounds = colorList.getCellBounds(index, index);
                renderer.getListCellRendererComponent((JList<? extends ViewColorizer.Key>)colorList, key, index, false, false);
                renderer.setBounds(0, 0, cellBounds.width, cellBounds.height);
                Point rendererPoint = new Point(lstPoint);
                rendererPoint.translate(-cellBounds.x, -cellBounds.y);
                if (renderer.getComponentAt(rendererPoint) == renderer.mCb) {
                    if (e.getClickCount() == 1) {
                        DevicePath selDevPath = VisibilityControlUI.this.getSelectedDevicePath(true);
                        boolean isDisplay = VisibilityControlUI.this.mViewColorizer.getDisplay(selDevPath, key);
                        try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)selDevPath.getDb(), (String)"Change Layer Visible");){
                            Cp.exec((String)"com.sigrity.orbit.ui.core.ViewColorizer.setDisplay(\"%s\", \"%s\", %b)", (Object[])new Object[]{selDevPath.escapedString(), key.asString(), !isDisplay});
                        }
                        VisibilityControlUI.this.refreshCanvas();
                        colorList.repaint(cellBounds);
                        VisibilityControlUI.this.enableSelectedVisibilityItemButtons();
                    }
                } else if (renderer.getComponentAt(rendererPoint) == renderer.mIcon) {
                    VisibilityControlUI.this.mChangeColorAction.actionPerformed(null);
                }
            }

            public void popupMenu(MouseEvent e) {
                ColorList list;
                Component c = e.getComponent();
                if (!(c instanceof ColorList)) {
                    return;
                }
                ColorList colorList = (ColorList)c;
                Point lstPoint = e.getPoint();
                int index = colorList.locationToIndex(lstPoint);
                if (index == -1) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                if (ColorList.this.getSelectedIndices().length > 0) {
                    menu.add(VisibilityControlUI.this.mChangeColorAction);
                }
                if (!AUtil.linkedList(ColorList.this.getSelectedOverrides()).isEmpty()) {
                    menu.add(VisibilityControlUI.this.mRemoveOverridesAction);
                }
                if (colorList.getOverrides().hasNext()) {
                    menu.add(VisibilityControlUI.this.mRemoveAllOverridesAction);
                }
                if ((list = VisibilityControlUI.this.getCurrentColorList()) == VisibilityControlUI.this.mLstLayerColors) {
                    if (VisibilityControlUI.this.anyVisibility(VisibilityControlUI.this.mLstLayerColors, false)) {
                        menu.add(VisibilityControlUI.this.createSetAllVisibilityAction("Layers", true, VisibilityControlUI.this.mLstLayerColors));
                    }
                    if (VisibilityControlUI.this.anyVisibility(VisibilityControlUI.this.mLstLayerColors, true)) {
                        menu.add(VisibilityControlUI.this.createSetAllVisibilityAction("Layers", false, VisibilityControlUI.this.mLstLayerColors));
                    }
                } else if (list == VisibilityControlUI.this.mLstObjectColors) {
                    if (VisibilityControlUI.this.anyVisibility(VisibilityControlUI.this.mLstObjectColors, false)) {
                        menu.add(VisibilityControlUI.this.createSetAllVisibilityAction("Objects", true, VisibilityControlUI.this.mLstObjectColors));
                    }
                    if (VisibilityControlUI.this.anyVisibility(VisibilityControlUI.this.mLstObjectColors, true)) {
                        menu.add(VisibilityControlUI.this.createSetAllVisibilityAction("Objects", false, VisibilityControlUI.this.mLstObjectColors));
                    }
                }
                OrbitIO.getApp().getWorkspace().beautify(menu);
                if (menu.getComponentCount() > 0) {
                    menu.show(ColorList.this, e.getX(), e.getY());
                }
            }
        };

        public ColorList() {
            this.setModel(this.mModel);
            this.setCellRenderer(new CellRenderer());
            this.setSelectionMode(2);
            this.addMouseListener(this.mColorListMouseListener);
            this.addKeyListener(this.mColorListKeyListener);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public void removeNotify() {
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public IterableIterator<ViewColorizer.Key> getAllKeys() {
            return new IterableIterator<ViewColorizer.Key>(){
                int mNextIdx = 0;

                public boolean hasNext() {
                    return this.mNextIdx < ColorList.this.mModel.size();
                }

                public ViewColorizer.Key next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return ColorList.this.mModel.get(this.mNextIdx++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Iterator<ViewColorizer.Key> iterator() {
                    return this;
                }
            };
        }

        public int getItemCount() {
            return this.mModel.getSize();
        }

        public void clearItems() {
            this.mModel.clear();
        }

        public void addItem(ViewColorizer.Key item) {
            this.mModel.addElement(item);
        }

        public ViewColorizer.Key getItem(int idx) {
            return (ViewColorizer.Key)this.getModel().getElementAt(idx);
        }

        public ViewColorizer.Key getSelectedItem() {
            return (ViewColorizer.Key)this.getSelectedValue();
        }

        public IterableIterator<ViewColorizer.Key> getOverrides() {
            ViewColorizer vc = VisibilityControlUI.this.mViewColorizer.getOverride(VisibilityControlUI.this.getSelectedDevicePath(true), false);
            if (vc == null) {
                return AEmptyItr.create();
            }
            return vc.getColorKeys();
        }

        public IterableIterator<ViewColorizer.Key> getSelectedOverrides() {
            return new FilteringIterator<ViewColorizer.Key>(this.getSelectedValuesList().iterator()){

                protected boolean include(ViewColorizer.Key key) {
                    if (key == null) {
                        return false;
                    }
                    DevicePath selDevPath = VisibilityControlUI.this.getSelectedDevicePath(true);
                    ViewColorizer vc = VisibilityControlUI.this.mViewColorizer.getColorizerFor(selDevPath, key);
                    return vc != null && selDevPath.equals((Object)vc.getPath());
                }
            };
        }
    }

    protected class PriorityListModel
    extends AbstractListModel<ViewColorizer.Priority> {
        private static final int DEFAULT_OFFSET = 1;

        protected PriorityListModel() {
        }

        @Override
        public ViewColorizer.Priority getElementAt(int index) {
            return VisibilityControlUI.this.mViewColorizer.getPriorityAt(index + 1);
        }

        @Override
        public int getSize() {
            return VisibilityControlUI.this.mViewColorizer == null ? 0 : VisibilityControlUI.this.mViewColorizer.getPriorityCount() - 1;
        }

        public void move(int idx, boolean up) {
            int newIdx = idx + (up ? -1 : 1);
            if (newIdx < 0 || newIdx >= this.getSize()) {
                return;
            }
            ViewColorizer.Priority p = VisibilityControlUI.this.mViewColorizer.getPriorityAt(idx + 1);
            if (p == null) {
                assert (false);
                return;
            }
            VisibilityControlUI.this.mViewColorizer.movePriority(p, newIdx + 1);
            this.fireContentsChanged(this, idx, newIdx);
            VisibilityControlUI.this.mLstPriorities.setSelectedIndex(newIdx);
            VisibilityControlUI.this.refreshCanvas();
        }

        public void reset() {
            VisibilityControlUI.this.mViewColorizer.resetPriorities();
            this.fireContentsChanged(this, 0, VisibilityControlUI.this.mViewColorizer.getPriorityCount() - 1);
            VisibilityControlUI.this.refreshCanvas();
        }
    }

    public static class ActionChangeColor
    extends AbstractAction {
        private Component mOwner;
        private ViewColorizer mViewColorizer;
        private ViewColorizer.Key mKey;
        private DevicePath mPath;

        public ActionChangeColor(Component owner, ViewColorizer vc, ViewColorizer.Key key, DevicePath path) {
            super("Change Color: " + key);
            this.mOwner = owner;
            this.mViewColorizer = vc;
            this.mKey = key;
            this.mPath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = String.format("%s Color", this.mViewColorizer.getDescription((Object)this.mKey));
            APatternColorChooser dlg = APatternColorChooser.show(this.mOwner, title, this.mViewColorizer.findColor(this.mPath, this.mKey));
            if (!dlg.isOK()) {
                return;
            }
            try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.ui.core.ViewColorizer.setColor(\"%s\", \"%s\", %s)", (Object[])new Object[]{this.mPath.escapedString(), this.mKey.asString(), dlg.getPatternColor().toCpString()});
            }
        }
    }

    protected class ChangeCustomPinText
    implements ActionListener,
    DocumentListener {
        protected Timer mUpdateTimer = new Timer(3000, this);

        protected ChangeCustomPinText() {
            this.mUpdateTimer.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateCustomPinText();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.startTimer();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.startTimer();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.startTimer();
        }

        protected void startTimer() {
            if (this.mUpdateTimer.isRunning()) {
                this.mUpdateTimer.restart();
            } else {
                this.mUpdateTimer.start();
            }
        }

        protected void updateCustomPinText() {
            if (this.mUpdateTimer.isRunning()) {
                this.mUpdateTimer.stop();
            }
            VisibilityControlUI.this.mViewColorizer.setCustomPinText(VisibilityControlUI.this.mTxtCustomPinText.getText());
            VisibilityControlUI.this.refreshCanvas();
        }
    }
}

