/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.ui.OrbitGuiObjectActionRegistry;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.route_edit.InteractiveRouteEditMode;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;

public class WireUI {
    public static final ObjectActionRegistry.ActionFactory<Selection> ActionFactorySelection = (selection, constraints) -> {
        long count = 0L;
        ArrayList<Wire> wires = new ArrayList<Wire>();
        for (Wire w : selection.get(Wire.class)) {
            wires.add(w);
        }
        count = wires.size();
        if (count == 0L) {
            return AEmptyItr.create();
        }
        LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
        ArrayList wireInsts = AUtil.arrayList((Iterator)selection.getSelectedHierInsts(Wire.class));
        if (wireInsts.size() == 1) {
            HierInst wireInst = (HierInst)wireInsts.get(0);
            actions.add(new ActionEditWireRoutePath((HierInst<Wire>)wireInst));
            actions.add(new ActionZoomToHierWire(OrbitIO.getCurView(), wireInst.getPath(), (Wire)wireInst.getDbObject()));
            actions.add(new OrbitGuiObjectActionRegistry.ActionSelectDbObject(wireInst.getDbObject(), wireInst.getPath()));
            actions.add(new ActionShowMeWire(wireInst.getPath(), (Wire)wireInst.getDbObject()));
        }
        return actions.iterator();
    };
    public static final OrbitGuiShortcutActionRegistry.ViewActionFactory ViewActionFactory = new OrbitGuiShortcutActionRegistry.ViewActionFactory(){

        @Override
        public Iterator<Object> getActions(Db db, Selection selection, APoint2D worldPoint) {
            ArrayList wiresInst;
            long count = 0L;
            ArrayList<Wire> wires = new ArrayList<Wire>();
            for (Wire w : selection.get(Wire.class)) {
                wires.add(w);
            }
            count = wires.size();
            if (count == 0L) {
                return AEmptyItr.create();
            }
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            if (count > 0L) {
                actions.add(new ActionDeleteSelectedWires(wires));
            }
            if ((wiresInst = AUtil.arrayList((Iterator)selection.getSelectedHierInsts(Wire.class))).size() == 1) {
                actions.add(new ActionEditWireRoutePath((HierInst<Wire>)((HierInst)wiresInst.get(0))));
            }
            return actions.iterator();
        }

        @Override
        public String getGroupName() {
            return "Wire Actions";
        }
    };

    private WireUI() {
    }

    public static class ActionShowMeWire
    extends AbstractAction {
        protected DevicePath mDevicePath;
        protected Wire mWire;

        public ActionShowMeWire(DevicePath dpath, Wire wire) {
            super("Show Me");
            this.mDevicePath = dpath;
            this.mWire = wire;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowMeTheWay.addWire(this.mDevicePath, this.mWire);
        }
    }

    public static class ActionZoomToHierWire
    extends AbstractAction {
        protected DevicePath mDevicePath;
        protected Wire mWire;
        protected DesignView2D mView;

        public ActionZoomToHierWire(AAppView view, DevicePath dpath, Wire wire) {
            super("Zoom To");
            this.mDevicePath = dpath;
            this.mWire = wire;
            if (!(view instanceof DesignView2D)) {
                this.setEnabled(false);
                return;
            }
            this.mView = (DesignView2D)view;
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Zoom"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mWire.getDb() == null) {
                return;
            }
            ARect bounds = this.mWire.getWorldBounds(this.mDevicePath);
            if (bounds == null) {
                return;
            }
            ARect r = new ARect(bounds);
            this.mView.getCanvas().getXForm().setWorld(r);
            this.mView.getCanvas().refresh();
        }
    }

    public static class ActionEditWireRoutePath
    extends AbstractAction {
        protected HierInst<Wire> mWire;

        public ActionEditWireRoutePath(HierInst<Wire> wire) {
            super("Edit Route Path");
            this.mWire = wire;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AAppView view = OrbitIO.getCurView();
            if (view instanceof DesignView2D) {
                InteractiveRouteEditMode.startEditWire((DesignView2D)view, this.mWire.getPath(), (Wire)this.mWire.getDbObject(), true);
            }
        }
    }

    public static class ActionDeleteSelectedWires
    extends AbstractAction {
        protected List<Wire> mWires;

        public ActionDeleteSelectedWires(List<Wire> wires) {
            super(String.format("Delete Selected Wires (%d)", wires.size()));
            this.mWires = wires;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Delete Selected Wires");){
                for (Wire wire : this.mWires) {
                    Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(wire)});
                }
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }
}

