/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkCreate;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.netlist_editor.ItemFilters;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javafx.animation.PauseTransition;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import javafx.util.Duration;

public abstract class BulkCreateUI<J extends DbObject>
extends AJFXDesignDialog {
    private DevicePath mChildDevPath;

    protected BulkCreateUI(Window owner, String title, DevicePath childDevPath) {
        super(childDevPath.getDb(), owner, title);
        this.mChildDevPath = childDevPath;
    }

    protected DevicePath getChildDevPath() {
        return this.mChildDevPath;
    }

    protected Device getChildDev() {
        return this.mChildDevPath.getDevice();
    }

    protected DeviceTemplate getChildDevT() {
        return this.mChildDevPath.getDeviceTemplate();
    }

    protected DevicePath getParentDevPath() {
        return this.mChildDevPath.getParent();
    }

    protected abstract class BulkCreatePanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 550;
        private static final int PANEL_HEIGHT = 600;
        private ItemBoxs.ObjItemBox<J> mSelectedBox;
        private ItemBoxs.NewNameBox mNewNameBox;
        private Map<J, String> mSelected2NewName = new HashMap();
        private Map<String, J> mNewName2Selected = new HashMap();
        private List<String> mNewNames = new ArrayList<String>();

        protected abstract ItemBoxs.ObjItemBox<J> newSelectedBox();

        protected abstract ItemBoxs.NewNameBox newNewItemBox();

        protected abstract EventHandler<ActionEvent> getOkHandler();

        protected BulkCreatePanel() {
            this.setPreferredSize(new Dimension(550, 600));
        }

        protected String getSelectorRegex() {
            return this.mSelectedBox.getRegex();
        }

        protected int getSelectorRegexFlags() {
            return this.mSelectedBox.getRegexFlags();
        }

        protected BulkHelper.StringGetter<J> getSelectorStringGetter() {
            return this.mSelectedBox.getStringGetter();
        }

        protected String getSelectorShowedStr(J item) {
            return this.mSelectedBox.getShowedStr(item);
        }

        protected boolean isVisibleSelectedItem(J item) {
            return this.mSelectedBox.isVisibleItem(item);
        }

        protected IterableIterator<ItemFilters.ItemFilter<J>> getSelectedActiveFilter() {
            return this.mSelectedBox.getActiveFilters();
        }

        protected String getNewNameRegex() {
            return this.mNewNameBox.getRegex();
        }

        protected void cpBulkCreate(Class<? extends BulkCreate<J>> bulkCreateClass) {
            this.cpBulkCreate(bulkCreateClass, null);
        }

        protected void cpBulkCreate(Class<? extends BulkCreate<J>> bulkCreateClass, BulkHelper.StringGetter<J> selectedStringGetter) {
            Cp.exec((String)"unset(\"_bulkCreate\");", (Object[])new Object[0]);
            Cp.exec((String)"_bulkCreate = new %s(%s)", (Object[])new Object[]{bulkCreateClass.getName(), CpHelper.getObjCmdStr(BulkCreateUI.this.getChildDev())});
            Cp.exec((String)"_bulkCreate.setSelectorPattern(\"%s\", %d)", (Object[])new Object[]{this.getSelectorRegex(), this.getSelectorRegexFlags()});
            Cp.exec((String)"_bulkCreate.setNewNamePattern(\"%s\")", (Object[])new Object[]{this.getNewNameRegex()});
            if (selectedStringGetter != null) {
                Cp.exec((String)"_bulkCreate.setSelectedStringGetter(%s.%s)", (Object[])new Object[]{BulkHelper.class.getName(), selectedStringGetter.name()});
            }
            for (ItemFilters.ItemFilter f : this.getSelectedActiveFilter()) {
                Cp.exec((String)"_bulkCreate.addSelectedItemFilter(%s.%s.get())", (Object[])new Object[]{ItemFilters.class.getName(), f.getClass().getSimpleName()});
            }
            this.cpPreExecuteCmd();
            Cp.exec((String)"_bulkCreate.execute()", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_bulkCreate\");", (Object[])new Object[0]);
        }

        protected void cpPreExecuteCmd() {
        }

        protected Parent initSceneGraph() {
            BorderPane pane = new BorderPane();
            Node mainPane = this.getMainPane();
            pane.setCenter(mainPane);
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)BulkCreateUI.this), this.getOkHandler());
            okCancelHBox.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
            pane.setBottom((Node)okCancelHBox);
            return pane;
        }

        private Node getMainPane() {
            SplitPane mainPane = new SplitPane();
            this.mSelectedBox = this.newSelectedBox();
            this.mSelectedBox.setRegexChangeListener(this.getSelectorChangeListener());
            this.mSelectedBox.setIngoreCaseChangeListener((EventHandler<ActionEvent>)((EventHandler)e -> this.runSelectorChangeAction()));
            this.mSelectedBox.setShowedStrGettersComboBoxListener((EventHandler<ActionEvent>)((EventHandler)e -> this.runSelectorChangeAction()));
            this.mSelectedBox.setListViewSelectionChangeListener(this.getSelectedListViewEventHandler());
            this.mSelectedBox.setFilterMenuHideAction((EventHandler<Event>)((EventHandler)e -> this.runSelectorChangeAction()));
            mainPane.getItems().add(this.mSelectedBox);
            this.mNewNameBox = this.newNewItemBox();
            this.mNewNameBox.setRegexChangeListener(this.getMatcherChangeListener());
            this.mNewNameBox.setListViewSelectionChangeListener(this.getMatchedListViewEventHandler());
            mainPane.getItems().add((Object)this.mNewNameBox);
            this.runSelectorChangeAction();
            return mainPane;
        }

        private ChangeListener<String> getSelectorChangeListener() {
            PauseTransition pause = new PauseTransition(Duration.seconds((double)1.0));
            return (observable, oldValue, newValue) -> {
                pause.setOnFinished(event -> this.runSelectorChangeAction());
                pause.playFromStart();
            };
        }

        private ChangeListener<String> getMatcherChangeListener() {
            PauseTransition pause = new PauseTransition(Duration.seconds((double)1.0));
            return (observable, oldValue, newValue) -> {
                pause.setOnFinished(event -> this.runMatcherChangeAction());
                pause.playFromStart();
            };
        }

        private ChangeListener<J> getSelectedListViewEventHandler() {
            return (observable, oldValue, newValue) -> {
                String newItemName = this.mSelected2NewName.get(newValue);
                if (newItemName != null) {
                    this.mNewNameBox.select(newItemName);
                    this.mNewNameBox.scrollToSelection();
                }
            };
        }

        private ChangeListener<String> getMatchedListViewEventHandler() {
            return (observable, oldValue, newValue) -> {
                DbObject selectedItem = (DbObject)this.mNewName2Selected.get(newValue);
                if (selectedItem != null) {
                    this.mSelectedBox.select(selectedItem);
                    this.mSelectedBox.scrollToSelection();
                }
            };
        }

        private void runSelectorChangeAction() {
            this.loadMappedItems();
            this.setHighlightedItems();
            this.setSelectedFilter();
            this.setNewNameItems();
        }

        private void runMatcherChangeAction() {
            this.loadMappedItems();
            this.setHighlightedItems();
            this.setNewNameItems();
        }

        private void setSelectedFilter() {
            Pattern selectorPattern = this.getSelectorPattern();
            ArrayList selectorPatterns = selectorPattern == null ? Collections.emptyList() : AUtil.arrayList((Object[])new Pattern[]{selectorPattern});
            this.mSelectedBox.setFilterPattern(selectorPatterns);
        }

        private Pattern getSelectorPattern() {
            return BulkHelper.getSelectorPattern(this.getSelectorRegex(), this.getSelectorRegexFlags());
        }

        private void setNewNameItems() {
            this.mNewNameBox.setItems(this.mNewNames);
        }

        private void loadMappedItems() {
            this.mSelected2NewName.clear();
            this.mNewName2Selected.clear();
            this.mNewNames.clear();
            Pattern selectorPattern = this.getSelectorPattern();
            if (selectorPattern == null) {
                return;
            }
            for (DbObject item : this.mSelectedBox.getItems()) {
                String newNameRegex;
                String refStr;
                String newName;
                if (!this.isVisibleSelectedItem(item) || (newName = BulkHelper.getNewName(selectorPattern, refStr = this.mSelectedBox.getShowedStr(item), newNameRegex = this.getNewNameRegex())) == null || newName.isEmpty()) continue;
                if (!this.mNewName2Selected.containsKey(newName)) {
                    this.mNewNames.add(newName);
                }
                this.mSelected2NewName.put(item, newName);
                this.mNewName2Selected.put(newName, item);
            }
        }

        private void setHighlightedItems() {
            this.mSelectedBox.setHighLighter(item -> {
                String newNameRegex;
                Pattern selectorPattern = this.getSelectorPattern();
                if (selectorPattern == null) {
                    return false;
                }
                String refStr = this.mSelectedBox.getShowedStr(item);
                String newName = BulkHelper.getNewName(selectorPattern, refStr, newNameRegex = this.getNewNameRegex());
                return newName != null && !newName.isEmpty();
            });
            this.refresh();
        }

        private void refresh() {
            this.mSelectedBox.refresh();
            this.mNewNameBox.refresh();
        }
    }
}

